/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             olrpm_RxProcessing.c
 * DESCRIPTION:      Functions that implement the showtime state OLR.
 *
 **********************************************************************/

//******************************************************************************
// olrpm_RxProcessing.c
//
// History
//
// 05/07/2012 Ram: Merged "ReTx" Segmented Bitswap Request code from ARX ADSL code base.
//   To cope with sweeping and fixed RFI, the following changes are done.
//   1. Below changes #2,#4,#5,#6 are under cmv control INFO 103 23 bitmask(0x0040). This bit is one (enabled) by default.
//   2. Modify the maximum number of bits for bitswap (gs_REDUCE_LP_DELTA_BITSWAP) from 20 to 120.
//   3. Increase Tx HDLC buffer size (MAX_TX_HDLC_MSG_SIZE, MAX_TX_HDLC_BUFFER_SIZE) from 700 to 1000.
//   4. Increase the maximum tone number (gs_MaxTonePerOvhdMsg) in one HDLC segment from 160 to 240.
//   5. Enable segmented bitswap request.
//   6. Change gs_DD_RxChannelsPerSymbol from 16 to 32 to improve SNR updating frequency.
//   7. Once marign on tones were ever dropped to below -6 dB, then bitswap is triggered when minimum margin is below 0 dB.
//      The threshold (-6dB by default) can be changed with cmv INFO 119 0.
//   8. Do not move bits to the tones whose margin were ever dropped to below -6 dB since these tones were very likely
//      to be affected by RFI before, and will be affected by RFI again. This mechanism is under cmv control
//      INFO 103 23 bitmask(0x0080). This bit is one (enabled) by default.
//   9. If bitswap is failed, checking of #7 condition will be ignored. Then bitswap will be tried again.
//   10. Include fix SMS01320806 IOP_A_BisPlus_CNXT_ImprovedBitSwap.
//   Grep for "XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest"
////08/11/2012 Anantha: To increase frequency of FDQ adaptation changing num of tones used in noise accumulation window
//             grep for XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap
// 20/02/2013 Mahesh:  Removed Ananta's bitswap enhancement changes for L2 & SRA
//******************************************************************************

#include <stdio.h>
#include "common.h"
#include "gdata.h"
#include "dslengin.h"
#include "dec_gain.h"
#include "cmv.h"
#include "tone_ord.h"
#include "bitload.h"
#include "rx_m3oh.h"
#include "enc_gain.h"
#include "dec_adap.h"
#include "gdata_bis.h"
#include "trailend.h"
#include "ovhd_ini_bis.h"
#include "rx_ovrhd_bis.h"
#include "showinit.h"
#include "olr_Bpn_check.h"
#include "ApplyFineGains.h"
#include "tx_ops2.h"
#include "CalcRate_BIS.h"
#include "mul.h"

extern int16 gs_INP; // defined as 2 * MinINP

/*****************************************************************************
;  Subroutine Name: OLRPM_RxPreProcessing(void)
;
;  Prototype:
;     void OLRPM_RxPreProcessing(void)
;
;  Input Arguments:
;
;
;  Output Arguments:
;
;
;  Return:
;
;
;  Global Variable used by this file:
;
;****************************************************************************/
C_SCOPE void OLRPM_RxPreProcessing(void)
{


   guc_ddProcState = DD_PROC_DISABLE;
   /* Disable FDQ computation */
   guc_FdqAdaptationState = FDQ_ADAPTATION_DISABLE;
   /* Disable Showtime Snr computation */
   guc_ShowtimeSnrCalcState = SHOWTIME_SNR_CALC_DISABLE;

   /* Disable SEF detection */
   guc_SEFDetectState  = SEF_DETECT_DISABLED;
   /* Disable DEC adaptation, in the future */

   /* reset flag to false */
   gft_ShowtimeSnrUpdateFlag = FALSE;


}

/*****************************************************************************
;  Subroutine Name: OLRPM_RxPostProcessing(void)
;
;  Prototype:
;     void OLRPM_RxPostProcessing(void)
;
;  Input Arguments:
;
;
;  Output Arguments:
;
;
;  Return:
;
;
;  Global Variable used by this file:
;
;****************************************************************************/
C_SCOPE void OLRPM_RxPostProcessing(uint8 uc_OLRPM)
{
   int32 i;

   /* 'Start' LOS detection -- Never disabled once enabled */
    if (gft_LOSDetectFlag == TRUE)
    {
      guc_LOSDetectState = LOS_DETECT_ENABLED;
   }

   /* 'Start or restart' rest of showtiem procesisng */
   if (gft_doDDSnrFdqUpdate)
   {
      for (i = 0; i < (int32)gt_rx_config.s_Nlp; i++)
      {

            /* If S < 1/4, limit # of DD channels processed per frame to 16 to avoid Mips shortage */
         if ((gt_RxShowTimeVars.t_FrameParms[i].s_CodewordSize * 32) < gt_rx_config.s_Lp[i])
         {
#ifndef AMAZON_SE

                if (gs_DD_RxChannelsPerSymbol > 16)
            {
               gs_DD_RxChannelsPerSymbol = 16;
            }
#else
                if (gs_DD_RxChannelsPerSymbol > 8)
            {
               gs_DD_RxChannelsPerSymbol = 8;
            }
#endif
         }
         /* If S >= 1/4, increase # of DD channels processed per frame to 32 */
         else
         {
#ifndef AMAZON_SE
            if (gs_DD_RxChannelsPerSymbol < 32)
            {
               gs_DD_RxChannelsPerSymbol = 32;
            }
#else
               if (gs_DD_RxChannelsPerSymbol < 16)
            {
               gs_DD_RxChannelsPerSymbol = 16;
            }
#endif
         }

         if (gs_DD_RxChannelsPerSymbol > gs_DD_MaxRxChannelsPerSymbol)
            gs_DD_RxChannelsPerSymbol = gs_DD_MaxRxChannelsPerSymbol;

         //XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (Start)
         //Change gs_DD_RxChannelsPerSymbol from 16 to 32 to improve SNR updating frequency.
         //Set gs_DD_RxChannelsPerSymbol = 16 for minINP >= 2 to avoid MIPS shortage
         //since the high INP can compromise the CRC resulted from slow bitswap/SNR updating.
      //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start)
      if(TESTArray[Test_DisableBitSwapImprvmnt]) {
            if ((gt_INFX_CMV.us_OperatorSpBits3 & CMV_TO_ENABLE_FAST_BITSWAP) && (gs_INP < 4))
               gs_DD_RxChannelsPerSymbol = 32;
            else
               gs_DD_RxChannelsPerSymbol = 16;
      } else {
         gs_DD_RxChannelsPerSymbol = 48;
      }
      //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(end)
         //XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (End)
      }
      // The order of initializing the guc_ddProcState after updating
      //gs_DD_RxFirstChannel and gs_DD_RxLastChannel matters. Because
      //there is possibility that this function could be interrupted by high
      //priority task and cause problems. We postpone enabling guc_ddProcState
      //until we are sure gs_DD_RxFirstChannel and gs_DD_RxLastChannel are both upated
      //correctly.

      gs_DD_RxFirstChannel = gs_RxFirstChannel; // reset channels
      gs_DD_RxLastChannel = gs_DD_RxFirstChannel + gs_DD_RxChannelsPerSymbol - 1;

        #ifdef AMAZON_SE
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,UpdateRTV);
        #endif

        guc_ddProcState = DD_PROC_INITIALIZE;
   }

   if (OPTNArray[OPTN_AlgControl2] & OPTN_FdqAdaptDisable)
      guc_FdqAdaptationState = FDQ_ADAPTATION_DISABLE;
   else
   /* Restart FDQ computation */
   guc_FdqAdaptationState = FDQ_ADAPTATION_INITIALIZE;

   /* Restart Showtime Snr computation */
    if (gft_ShowTimeSnrFlag == TRUE)
    {
      guc_ShowtimeSnrCalcState = SHOWTIME_SNR_CALC_INITIALIZE;
   }

   gus_10sec_SNRUpdate = 4000 * 15;  //Set showtime watchdog timer to 15 seconds.
   gs_OlrReq=0;

   /* Restart SEF detection */
    if (gft_SEFDetectFlag == TRUE)
    {
      guc_SEFDetectState  = SEF_DETECT_ENABLED;
   }


   if (( gl_SelectedMode & (MODE_ADSL2)  ))
   {
      /* ADSL2 mode changes sync symbol phase and has L2 PCB processing etc */
      /* Restart DEC adaptation here after we enable it for ADSL2/+ modes */

      /* Successful OLR/PM, update DS rate etc */
      if ((uc_OLRPM) &&
         ((STATArray[uc_OLRPM] & STAT_OLRPM_ABORTED)!= STAT_OLRPM_ABORTED))
      {
         // we think we have successfully completed the DS OLR task
         STATArray[uc_OLRPM] &= ~STAT_OLRPM_IN_PROGRESS;
         STATArray[uc_OLRPM] |= (STAT_OLRPM_COMPLETE|STAT_OLRPM_RESPONSE);

         //Update the net data rate and ovhd msg rate
         CalcRate_BitsPerSecond(&gt_rx_config, gla_DSDataRate, gsa_DSOvhdRate);

            //Calculate CRC Increment @ new PERp after an OLR but not when in L2.
            if (uc_OLRPM == STAT_OLRStatus_DS)
            {
               Calc_CRCIncrement();
            }

            //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start)
            //Reset LOS defect state machine.
            //Recompute Average pilot power for LOS detection in PM L2
            //if (uc_OLRPM == STAT_PMStatus)
            //{
            //    guc_LosDefect_state = 0;
            //}
            //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (End)

        }

      //no matter whether auto SRA is aborted or successfully done, we should deem it as completed
      // and start to think about next auto SRA.
      if ((uc_OLRPM == STAT_OLRStatus_DS) && ((STATArray[STAT_OLRStatus_DS] & STAT_OLR_TYPE) == STAT_OLR_SRA)
         && (OPTNArray[OPTN_OLRControl_DS] & OPTN_EnableAutoSRA))
      {
         gft_Auto_SRA_Completed = TRUE;
         gs_OlrReq = 0;
         gus_ra_Interval_Timer = TESTArray[TEST_OLR_SRA_SettlingTime];
      }
   }


}

/*****************************************************************************
;  Subroutine Name: Calc_CRCIncrement(void)
;   Calculate normalized CRCs based on adjusted PERp after OLR.
;
;  Prototype:
;     Calc_CRCIncrement(void)
;
;  Input Arguments:
;
;
;  Output Arguments:
;
;
;  Return:
;
;
;  Global Variable used by this file:
;   gsa_rx_SEQp, gsa_DSOvhdRate, gsa_CRCincrement, gt_rx_config.s_Nlp
;
;****************************************************************************/
C_SCOPE void Calc_CRCIncrement(void)
{
    int lp;
    int16 s_PER[2];
    int32 l_temp;

    for (lp = 0; lp < (int32)gt_rx_config.s_Nlp; lp++)
    {
        // s_PER[lp] in 8.8 = (8*SEQp/ORp) * 256 = ((gsa_rx_SEQp[lp]<<11) / ((gsa_DSOvhdRate[lp]*125)/1000))
        //                  = ((gsa_rx_SEQp[lp]<<14) / gsa_DSOvhdRate[lp])
        s_PER[lp] = ((gsa_rx_SEQp[lp]<<14) / gsa_DSOvhdRate[lp]);

        if (s_PER[lp] > 0x1400)      // PERp > 20
        {
            // gsa_CRCincrement[lp] in 8.8  =  (s_PER[lp] * 256) / 20 = (s_PER[lp]<<8) / 0x1400
            //                              ~= ((s_PER[lp] * 13107) / 262144) = ((s_PER[lp] * 13107)>>18)
         MULS32x16(l_temp,(int32)s_PER[lp], 13107);
            gsa_CRCincrement[lp] = (int16)(l_temp>>18);
        }
        else if (s_PER[lp] < 0xF00)  // PERp < 15
        {
            // gsa_CRCincrement[lp] in 8.8  =  (s_PER[lp] * 256) / 15 = (s_PER[lp]<<8) / 0xF00
            //                              ~= ((s_PER[lp] * 8738) / 131072) = ((s_PER[lp] * 8738)>>17)

         MULS32x16(l_temp,(int32)s_PER[lp], 8738);
            gsa_CRCincrement[lp] = (int16)(l_temp>>17);
        }
        else
        {
            gsa_CRCincrement[lp] = 0x0100;
        }

    }

}


