/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             pm_rx_tc_bis.c
 * DESCRIPTION:      Functions that implement the bis showtime RX time critical tasks.
 *
 **********************************************************************/

#include <stdio.h>
#include "common.h"
#include "gdata.h"
#include "xgdata.h"
#include "gdata_bis.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "tx_eoc.h"
#include "aoc.h"
#include "aoc_ini.h"
#include "pn_tab.h"
#include "states.h"
#include "mtkernel.h"
#include "enc_gain.h"
#include "dec_gain.h"
#include "tx_m3oh.h"
#include "rx_m3oh.h"
#include "rt_tones.h"
#include "rt_state.h"
#include "ib.h"
#include "tx_ib.h"
#include "rx_ib.h"
#include "synsymbl.h"
#include "tone_ord.h"
#include "bitload.h"
#include "fifo.h"
#include "cmv.h"
#include "mp.h"
#include "qos.h"
#include "rx_eoc.h"
#include "rx_eoc1.h"
#include "rx_aoc.h"
#include "dec_adap_Data.h"
#include "pll.h"
#include "timercov.h"
#include "bitswap.h"
#include "tx_aoc.h"
#include "rx_aoc.h"
#include "tx_plam.h"
#include "rx_plam.h"
#include "prf_man.h"
#include "bert.h"
#include "detect.h"
#include "tx_ovrhd_bis.h"
#include "rx_ovrhd_bis.h"
#include "showinit.h"
#include "showtime_bis.h"
#include "DSLEngin.h"
#include "fdqmult.h"
#include "showinit_olr.h"

// **************************************************************************
//  pm_rx_tc_bis.c
//
// History
//
// 22/03/2013 Ram: 1. FDQ Co-effs computation during L2 to L0 transition is split across
//                    symbols to avoid Mips peaking.
//                 2. Added code to handle 'false reverb detection' (L2 exit). Hence disabled
//                    the Exception 'E_CODE_L2_EXIT_REV_FALSE_DET'
//                 Grep for XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2
//
// 09/09/2014 ChihWen: HW acceleration for FDQ adaptation and SNR measurement.
//            Grep for XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ
//
// 09/09/2014 ChihWen: Avoid MIPs peaking in L2 entry and exit by moving calculation of FDQ coefficients to background tasks.
//            Grep for XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit
// ***************************************************************************


// XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
#define MAX_NUM_CHNLS_FOR_FDQ_COMPUTATION       (370)
// XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)

// ******************************************************************
// Pm_rx_tc_bis.c
//
// History
//
// 18/06/2012 Raghu L2 changes grep for XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2
//                  Also some unused code is removed.
// ******************************************************************

extern void do_data_frame_processing(void);

//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
#ifdef HW_SNR_FDQ
extern int16 gsa_pilot_FDQ_coef[2];
extern uint8 guc_pilot_FDQ_exp;
#endif
//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)

//==============================
// Rx PM Utilities
//==============================

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void compute_fftscaleback(int16 s_FFTGaindB, int16 s_FdqGain,
*                                   int16 *ps_scaleback, int16 *ps_fdqMultiplier,
*                                   int16 *psa_fdq_coef, int8 *puca_fdq_exp,
*                                   int16 s_firsttone, int16 s_numtones, FlafT ft_loadScaleback)
*
*  Prototype: void compute_fdqcoef(int16 s_FFTGaindB, int16 s_FdqGain,
*                                   int16 *ps_scaleback, int16 *ps_fdqMultiplier,
*                                   int16 *psa_fdq_coef, int8 *puca_fdq_exp,
*                                   int16 s_firsttone, int16 s_numtones, FlafT ft_loadScaleback)
*
*   Description:
*   computes fft scaleback and fdq coef
*   ADLS_62 splits compute_fftscaleback_fdqcoef() into two fucntions.
*  During L2 exit, fdq coefficients is re-computed during the L2-exit reverb symbol to avoid the mips surge
*   for L2-exit segue symbol
*  FdqMultiply takes 10000 cycles to complete.
*  Arguments:
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
void compute_fftscaleback(int16 s_FFTGaindB, int16 s_FdqGain,
                          int16 *ps_scaleback, int16 *ps_fdqMultiplier,
                          int16 *psa_fdq_coef, int8 *puca_fdq_exp,
                          int16 s_firsttone, int16 s_numtones, FlagT ft_loadScaleback)
{
    int16 sa_FftScalebackMask[(MAX_FFT_GAIN_ADD/6)+1] =
    {
        FFT_SCALEBACK_GAIN_0DB_MASK,
        FFT_SCALEBACK_GAIN_6DB_MASK,
        FFT_SCALEBACK_GAIN_12DB_MASK,
        FFT_SCALEBACK_GAIN_18DB_MASK,
        FFT_SCALEBACK_GAIN_24DB_MASK,
        FFT_SCALEBACK_GAIN_30DB_MASK
    };

    /* compute fft scalebacks, the fft butterfly pass that are enabled */
    *ps_scaleback = sa_FftScalebackMask[s_FFTGaindB/6];

    /* load FFT scalebacks*/
    if (ft_loadScaleback)
    {
        OLRPM_RxFftReconfigDataPumpSetup();
    }
}

void compute_fdqcoef(int16 s_FFTGaindB, int16 s_FdqGain,
                     int16 *ps_scaleback, int16 *ps_fdqMultiplier,
                     int16 *psa_fdq_coef, int8 *puca_fdq_exp,
                     int16 s_firsttone, int16 s_numtones, FlagT ft_loadScaleback)
{

    int16 sa_FdqMultiplier[21] =
    {
        0xa1e, 0xb5a,   0xcbd,   0xe4b,   0x1009,
        0x11fe, 0x1430, 0x16a7, 0x196b, 0x1c85,
        0x2000,
        0x23e8, 0x2849, 0x2d33,  0x32b7, 0x38e8,
        0x3fd9, 0x47a3, 0x5061, 0x5a30, 0x6531
    };


    /* recompute new FDQ coefficients */
    *ps_fdqMultiplier = sa_FdqMultiplier[s_FdqGain+10];
    FdqMultiply(psa_fdq_coef,
                puca_fdq_exp,
                *ps_fdqMultiplier,
                s_firsttone,
                s_numtones,
                FDQ_MANTISSA_WORDLENGTH, 13 /* s_FdqMultiplier is in Q3.13 format */);
}

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void reconfig_fft_fdq_for_l2exit(void)
*
*   Description:
*     reconfigs fft/fdq block
*
*  Arguments:
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
void reconfig_fft_fdq_for_l2exit(void)
{
    int16 s_additionalFdqGaindB;
    L2PowerCutBack_t *pt_L2PowerCutBack = &(gt_RxOLRPMVars.t_L2PowerCutBack);

    //////////////////////////////////////////////////////////////////////////////////////
    // L2 Exit -- recompute FDQ and load FFT/FDQ corresponding to L0 PCB values
    //////////////////////////////////////////////////////////////////////////////////////
    /* set fft and fdq gain to 0 */
    pt_L2PowerCutBack->s_L2FFTGaindB = 0;

    /* compute FDQ gain */
    s_additionalFdqGaindB = -(pt_L2PowerCutBack->s_L2FdqGaindB);
    pt_L2PowerCutBack->s_L2FdqGaindB = 0;

    //////////////////////////////////////////////////////////
    // FDQ Multiplication requires around 10000 clock cycles//
    // in plus mode and this FDQ TC task may cross the frame//
    // boundary. Hence we load FFT scalebacks and then start//
    // computing and loading the new FDQ's. We also disable //
    // Qam Done Interrupt In following frame for same reason//
    // Note: This TC task can cross the frame boundary but  //
    // it needs to be finished before FDQ done interrupt of //
    // next frame(no QAM done interrupt in next frame) with //
    // enough time remaining for NTC task.               //
    //////////////////////////////////////////////////////////
    /* compute fft scalebacks since scaled fdq coefs are computed in the previous symbol */
    compute_fftscaleback(pt_L2PowerCutBack->s_L2FFTGaindB, s_additionalFdqGaindB,
                         &(pt_L2PowerCutBack->s_FftScalebackMask), &(pt_L2PowerCutBack->s_fdqMultiplier),
                         gsa_pre_FDQ_coef, (int8 *)(void *)guca_pre_FDQ_exp, gs_RxFirstChannel,
                         (int16)(gs_RxLastChannel - gs_RxFirstChannel+1), TRUE);

}

// XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void compute_fdqcoef_for_l2exit(void)
*
*   Description:
*     1. Reconfigs fdq scale
*     2. Limit the number of tones, for which FDQ Co-effs are computed, to
*        'MAX_NUM_CHNLS_FOR_FDQ_COMPUTATION' to avoid Mips peaking.
*
*  Arguments:
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/

void compute_fdqcoef_for_l2exit(void)
{
   int16 s_StartChnl, s_NumChnls;
   L2PowerCutBack_t *pt_L2PowerCutBack = &(gt_RxOLRPMVars.t_L2PowerCutBack);

   if (pt_L2PowerCutBack->s_SplitFDQCoefsComputation == 0) {
      //Take backup. We may have to restore during 'false exit reverb detection'.
      pt_L2PowerCutBack->s_Prev_L2FFTGaindB = pt_L2PowerCutBack->s_L2FFTGaindB;
      pt_L2PowerCutBack->s_Prev_additionalFdqGaindB = pt_L2PowerCutBack->s_additionalFdqGaindB;
      pt_L2PowerCutBack->s_Prev_L2FdqGaindB = pt_L2PowerCutBack->s_L2FdqGaindB;

      // L2 Exit -- recompute FDQ and load FFT/FDQ corresponding to L0 PCB values
     /* set fft and fdq gain to 0 */
     pt_L2PowerCutBack->s_L2FFTGaindB = 0;

     /* compute FDQ gain */
     pt_L2PowerCutBack->s_additionalFdqGaindB = -(pt_L2PowerCutBack->s_L2FdqGaindB);
     pt_L2PowerCutBack->s_L2FdqGaindB = 0;

     s_StartChnl = gs_RxFirstChannel;

     if (gs_RxLastChannel > MAX_NUM_CHNLS_FOR_FDQ_COMPUTATION) {
        pt_L2PowerCutBack->s_PrevLastChnl = MAX_NUM_CHNLS_FOR_FDQ_COMPUTATION;
        pt_L2PowerCutBack->s_SplitFDQCoefsComputation = 1;
     } else {
        pt_L2PowerCutBack->s_PrevLastChnl = gs_RxLastChannel;
        pt_L2PowerCutBack->s_SplitFDQCoefsComputation = 0;
     }

     s_NumChnls = pt_L2PowerCutBack->s_PrevLastChnl - s_StartChnl + 1;
   } else {
      s_StartChnl = pt_L2PowerCutBack->s_PrevLastChnl + 1;
      s_NumChnls = gs_RxLastChannel - s_StartChnl + 1;

      pt_L2PowerCutBack->s_PrevLastChnl = gs_RxLastChannel;
      pt_L2PowerCutBack->s_SplitFDQCoefsComputation = 0;
   }

   /* compute fft scalebacks and scaled fdq coefs */
   compute_fdqcoef(pt_L2PowerCutBack->s_L2FFTGaindB, pt_L2PowerCutBack->s_additionalFdqGaindB,
                  &(pt_L2PowerCutBack->s_FftScalebackMask), &(pt_L2PowerCutBack->s_fdqMultiplier),
                  gsa_pre_FDQ_coef, (int8 *)(void *)guca_pre_FDQ_exp, s_StartChnl, s_NumChnls, FALSE);
}

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void restore_fdqcoef(void)
*
*   Description:
*     Restores back fdq scale
*
*  Arguments:
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/


void restore_fdqcoef(void)
{
   int16 s_StartChnl, s_NumChnls;
   L2PowerCutBack_t *pt_L2PowerCutBack = &(gt_RxOLRPMVars.t_L2PowerCutBack);

   //Restore back
   pt_L2PowerCutBack->s_L2FFTGaindB = pt_L2PowerCutBack->s_Prev_L2FFTGaindB;
   pt_L2PowerCutBack->s_additionalFdqGaindB = pt_L2PowerCutBack->s_Prev_additionalFdqGaindB;
   pt_L2PowerCutBack->s_L2FdqGaindB = pt_L2PowerCutBack->s_Prev_L2FdqGaindB;

   s_StartChnl = gs_RxFirstChannel;
   pt_L2PowerCutBack->s_PrevLastChnl =
      (gs_RxLastChannel > MAX_NUM_CHNLS_FOR_FDQ_COMPUTATION)? MAX_NUM_CHNLS_FOR_FDQ_COMPUTATION: gs_RxLastChannel;
   s_NumChnls = pt_L2PowerCutBack->s_PrevLastChnl - s_StartChnl + 1;

   pt_L2PowerCutBack->s_SplitFDQCoefsComputation = 0;

   /* compute fft scalebacks and scaled fdq coefs */
   compute_fdqcoef(pt_L2PowerCutBack->s_L2FFTGaindB, pt_L2PowerCutBack->s_additionalFdqGaindB,
                   &(pt_L2PowerCutBack->s_FftScalebackMask), &(pt_L2PowerCutBack->s_fdqMultiplier),
                   gsa_pre_FDQ_coef, (int8 *)(void *)guca_pre_FDQ_exp, s_StartChnl, s_NumChnls, FALSE);
}
// XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void exit_l2_state(void)
*
*   Description:
*     updates necessary to exit l2 state
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
// XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
extern int8 gft_ResetTrelMetricHist;
void exit_l2_state(void)
{
    /* bi/gi/Lp reconfiguration for L2 Exit */
    /* Time to reconfigure RCD related (except bi/gi tables) DSP variables */
    gt_rx_config.s_Lp[0] = gt_rx_config.s_currentLp[0];
    gt_rx_config.s_Lp[1] = gt_rx_config.s_currentLp[1];
    OLRPM_RxInit(RECONFIG_Lp);

    /* Bi/gi changes must take effect on the next symbol */
    PML2ToL0_RestoreRxL0Config();

    /* Reconfigure FFT/FDQ related DSP variables and HW core to L0 State right now */
    reconfig_fft_fdq_for_l2exit();

    /* load FDQ */
    LoadFDQ();

    //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
    #ifdef HW_SNR_FDQ
    gsa_pilot_FDQ_coef[0] = gsa_pre_FDQ_coef[gs_PilotToneIdx*2];
    gsa_pilot_FDQ_coef[1] = gsa_pre_FDQ_coef[gs_PilotToneIdx*2+1];
    guc_pilot_FDQ_exp = guca_pre_FDQ_exp[gs_PilotToneIdx];
    #endif
    //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)

    gft_ResetTrelMetricHist = 1;

#ifdef AMAZON_SE
// L2 power cutback workaround
    gft_postL2_fastpll = 1;
    guc_postL2_fastpll_sframe = 100;

    gs_Kp_Showtime = 0x4000;     /* Fast Kp parameter in the loop filter */
    gs_Ki_Showtime = 0x200;

    gs_Kp = (int16)gs_Kp_Showtime;
    gs_Ki = (int16)gs_Ki_Showtime;

    l_Kp = (int32)gs_PllScaling * gs_Kp;
    l_Kp >>= 14;
    l_Ki = (int32)gs_PllScaling * gs_Ki;
    l_Ki >>= 14;

    if((l_Kp > 0) && (l_Kp < 0x7fff) &&  (l_Ki > 0) && (l_Ki < 0x7fff))
    {
        gs_Kp = (int16) l_Kp;
        gs_Ki = (int16) l_Ki;
    }
#endif


}
// XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (END)

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: FlagT detect_l2_exit_seq(void)
*
*   Description:
*     l2 exit sequence detection (updates l2 processing state m/c)
*     returns TRUE if entire l2 exit sequence detected
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/



// XDSLRTFQ-416 : Enhancement_ALL_BisPLus_ALL_L2 (START)
extern uint32 gul_NumFalseRevDetect;
FlagT detect_l2_exit_seq(void)
{
    int16 s_signalType;

    s_signalType=1;

    /* if detected a L2 exit sequence */
   // L2 exit detected based on two conditions.
   // 1) Detect Rev/Segue in between Data symbols using ref based correlation. The detection alone
   //    has false detection. This may be fixed by increase the tones used
   //    in the detection. But this increases the cycles. Cycles consumed in the exit symbols are
   //    close to the Max limits.
   // 2) So Vitterbi decoder metric is also used for exit detection.
    if((isReverbSegueDetected(s_signalType)) && (gft_frame_with_lowmetric))
    {
        /* If expecting segue, entire L2 exit sequence detected */
        if(gt_RxOLRPMVars.uc_l2ProcState == PM_L2_EXIT_SEQ_REVERB_DETECTED)
        {
            gt_RxOLRPMVars.uc_l2ProcState = PM_L2_EXIT_SEQ_SEGUE_DETECTED;

            // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
            //Splitting new FDQ co-effs computation, across symbols, to avoid Mips Peaking.
            //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
            //XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (START)
            //Move to background tasks to avoid MIPs peaking.
            #ifndef HW_SNR_FDQ
            if(gt_RxOLRPMVars.t_L2PowerCutBack.s_SplitFDQCoefsComputation == 1) {
               compute_fdqcoef_for_l2exit();
            }
            #endif
            //XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (END)
            //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)
            // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)

            exit_l2_state();  /* l2 exit sequence detected -- exit l2 state*/

            return(TRUE);  /* return TRUE to indicate l2 exit sequence detection completed */
        }
        /* Else detected reverb, first symbol in L2 exit sequence detected */
        else
        {

         OLRPM_RxPreProcessing();
            //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
            //XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (START)
            //Move to background tasks to avoid MIPs peaking.
            #ifndef HW_SNR_FDQ
            compute_fdqcoef_for_l2exit();
            #endif
            //XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (END)
            //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)
            gt_RxOLRPMVars.uc_l2ProcState = PM_L2_EXIT_SEQ_REVERB_DETECTED;
        }
    }
    else
    {
        /* Save Rx rate buf wptr and Rx Bit fifo -- used before restoring L0 configuration */
        SaveQamOutputState();
        if(gt_RxOLRPMVars.uc_l2ProcState == PM_L2_EXIT_SEQ_REVERB_DETECTED)/* else if mistaken detection in earlier symbol */
        {
            gt_RxOLRPMVars.uc_l2ProcState = PM_L2_STATE;
            STATArray[STAT_PowerMode] = STAT_PM_L2;

            // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
            //False Reverb detected, Restore back newly computed FDQ Co-efs.
            restore_fdqcoef();
            gul_NumFalseRevDetect++;

            //Misdetection (False Reverb detection), Hence Re-Init
            OLRPM_RxPostProcessing(0);

            //Disable the exception as we are now handling misdection.
#if 0
            gft_fdqTCDone = TRUE;

         // Set exception handler variables
         gus_ExceptionState   = gs_RxState;
         gus_ExceptionCode = E_CODE_L2_EXIT_REV_FALSE_DET;
         gs_RxNextState = FAIL_RX;
         gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
#endif
         // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)
        }
    }

    return(FALSE);   /* return FALSE to indicate l2 exit sequence not yet detected*/
}
// XDSLRTFQ-416 : Enhancement_ALL_BisPLus_ALL_L2 (END)


/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void do_l2_processing(void)
*
*   Description:
*     Does l2 state machine processing
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
void do_l2_processing(void)
{


    /* l2 exit post processing */
    if (gt_RxOLRPMVars.uc_l2ProcState == PM_L2_EXIT_POSTPROCESS)
    {
        /* Back to L0 state (implies all s/w tables restored) */
        if (gt_RxOLRPMVars.uc_rxOLRPMState == L0_STEADY_STATE)
        {
            /* L2 exit changes bi/gi table -- setup Iridia Reverb Segue Detector again */
#ifndef ISDN
            PreSelectReverbSegueDetector();
            ReverbSegueDetectorSetup();

#else
         //XDSLRTFW-601: BugFix_DS_All_All_SESFail (start)
            AddFunctionToBkgdFifo((PtrToBkgdFunc)PreSelectReverbSegueDetector);
            AddFunctionToBkgdFifo((PtrToBkgdFunc)ReverbSegueDetectorSetup);
         //XDSLRTFW-601: BugFix_DS_All_All_SESFail (end)
#endif
            /* Setup Iridia Reverb Segue Detector to do sync symbol detection */
            ReverbSegueDetectorSelect((int16)!gs_RxSyncToneType);
            /* reset l2 processing state m/c */
            gt_RxOLRPMVars.uc_l2ProcState = PM_L0_STATE;
            STATArray[STAT_PowerMode] = STAT_PM_L0;
        }
    }
    /* in l2 state */
    else
    {
        /* do l2 exit sequence detection only data frame */
        /* setup Iridia Reverb Segue Detector for oncoming detection namely sync/l2exit */
      // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (START)
        if (gs_RxPMDFrameCnt_FftFdqBufferSymbol != RX_SYMBOLS_PER_SFRAME)
        {
         if(!detect_l2_exit_seq())  /* l2 exit sequence not detecetd yet */
           {
                /* Setup Reverb Segue Detector
                to do exit sequence symbol detection */
                if(gt_RxOLRPMVars.uc_l2ProcState == PM_L2_EXIT_SEQ_REVERB_DETECTED)
               gft_L2_Detect = R_SEGUE;
            else
               gft_L2_Detect = R_REVERB;
            }
        }
      // Else
      // Do nothing on sync symbol in L2 mode here. SEF and sync symbol inversion is done later.
      // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (END)
    }
}
