/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             showinit_rx_olrpm.c
 * DESCRIPTION:      Functions that implement the showtime state OLR.
 *
 **********************************************************************/

// **************************************************************************
//  showinit_rx_olrpm.c
//
// History
//
// 22/03/2013 Ram: FDQ Co-effs computation during L0 to L2 transition is split across
//                 symbols to avoid Mips peaking.
//                 Grep for XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2
//
// 09/09/2014 ChihWen: HW acceleration for FDQ adaptation and SNR measurement.
//            Grep for XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ
//
// 09/09/2014 ChihWen: Avoid MIPs peaking in L2 entry and exit by moving calculation of FDQ coefficients to background tasks.
//            Grep for XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit
// ***************************************************************************

#include <stdio.h>
#include "common.h"
#include "gdata.h"
#include "dslengin.h"
#include "dec_gain.h"
#include "cmv.h"
#include "tone_ord.h"
#include "bitload.h"
#include "rx_m3oh.h"
#include "enc_gain.h"
#include "dec_adap.h"
#include "gdata_bis.h"
#include "trailend.h"
#include "ovhd_ini_bis.h"
#include "rx_ovrhd_bis.h"
#include "showinit.h"
#include "olr_Bpn_check.h"
#include "ApplyFineGains.h"
#include "tx_ops2.h"
#include "memory.h"
#include "mul.h"
#include "fifo.h"

// XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
#define MAX_NUM_CHNLS_FOR_FDQ_COMPUTATION       (370)

//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
//XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (START)
#ifdef HW_SNR_FDQ
extern uint8 guc_ReconfigNextFdqCoefForL2Pcb;
#endif
//XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (END)
//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void reconfig_fft_fdq_for_l2pcb(void)
*
*   Description:
*     1. Reconfigs fft/fdq block.
*     2. Limit the number of tones, for which FDQ Co-effs are computed, to
*        'MAX_NUM_CHNLS_FOR_FDQ_COMPUTATION' to avoid Mips peaking.
*
*  Arguments:
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
extern FlagT gft_SkipDECDownload;
void reconfig_fft_fdq_for_l2pcb(void)
{
   int16 s_pcbL0SymbolL2SymbolDiff, s_pcbL2ExitL2SymbolDiff;
   int32 l_temp;

   L2PowerCutBack_t *pt_L2PowerCutBack = &(gt_RxOLRPMVars.t_L2PowerCutBack);

   //////////////////////////////////////////////////////////////////////////////////////
   // Compute the distribution of gain due to L2 PCB between FFT and FDQ
   //////////////////////////////////////////////////////////////////////////////////////
   s_pcbL0SymbolL2SymbolDiff  = pt_L2PowerCutBack->s_pcbDsL2Symbols - pt_L2PowerCutBack->s_pcbDsL0Symbols;
   s_pcbL2ExitL2SymbolDiff    = pt_L2PowerCutBack->s_pcbDsL2Symbols - pt_L2PowerCutBack->s_pcbDsL2toL0ExitSymbols;

   //update ACTATP during L2 state
   MULS16(l_temp, s_pcbL0SymbolL2SymbolDiff, 10);
   gt_NearEndParam.s_ActualAggregateXmtPwr = gs_DS_ACTATP_L0 - (int16)l_temp;

   /* If using L0 gain add the difference of fine gains between L0 and L2 symbols */
   if(pt_L2PowerCutBack->ft_isL2Gain)
   {
      /* Add code here to update s_pcbL2ExitL2SymbolDiff based on bi/gi flag */
   }

   /* compute fft gain, should be less than the max fft gain when L2 exit symbols are received */
   if ((s_pcbL0SymbolL2SymbolDiff+s_pcbL2ExitL2SymbolDiff) > MAX_FFT_GAIN_ADD)
      pt_L2PowerCutBack->s_L2FFTGaindB = (MAX_FFT_GAIN_ADD - s_pcbL2ExitL2SymbolDiff);
   else
      pt_L2PowerCutBack->s_L2FFTGaindB = s_pcbL0SymbolL2SymbolDiff;
   pt_L2PowerCutBack->s_L2FFTGaindB = pt_L2PowerCutBack->s_L2FFTGaindB/6 * 6;

   /* compute FDQ gain */
   pt_L2PowerCutBack->s_additionalFdqGaindB = s_pcbL0SymbolL2SymbolDiff - pt_L2PowerCutBack->s_L2FFTGaindB - pt_L2PowerCutBack->s_L2FdqGaindB;
   pt_L2PowerCutBack->s_L2FdqGaindB = s_pcbL0SymbolL2SymbolDiff - pt_L2PowerCutBack->s_L2FFTGaindB;

    /* compute fft scalebacks and scaled fdq coefs */
    compute_fftscaleback(pt_L2PowerCutBack->s_L2FFTGaindB, pt_L2PowerCutBack->s_additionalFdqGaindB,
                         &(pt_L2PowerCutBack->s_FftScalebackMask), &(pt_L2PowerCutBack->s_fdqMultiplier),
                         gsa_pre_FDQ_coef, (int8 *)(void *)guca_pre_FDQ_exp, gs_RxFirstChannel,
                         (int16)(gs_RxLastChannel - gs_RxFirstChannel+1), FALSE);

    /* Reduce cycles consumed by splitting new FDQ co-eff computation across
       two symbols. */
    pt_L2PowerCutBack->s_PrevLastChnl =
       (gs_RxLastChannel > MAX_NUM_CHNLS_FOR_FDQ_COMPUTATION)? MAX_NUM_CHNLS_FOR_FDQ_COMPUTATION: gs_RxLastChannel;

    compute_fdqcoef(pt_L2PowerCutBack->s_L2FFTGaindB, pt_L2PowerCutBack->s_additionalFdqGaindB,
                    &(pt_L2PowerCutBack->s_FftScalebackMask), &(pt_L2PowerCutBack->s_fdqMultiplier),
                    gsa_pre_FDQ_coef, (int8 *)(void *)guca_pre_FDQ_exp, gs_RxFirstChannel,
                    (int16)(pt_L2PowerCutBack->s_PrevLastChnl - gs_RxFirstChannel+1), FALSE);

//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
//XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (START)
#ifndef HW_SNR_FDQ
    //TO prevent Mips peak, prevent DEC co-eff download
    gft_SkipDECDownload = TRUE;
#endif
//XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (END)
//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)
}

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void reconfig_next_fdq_for_l2pcb(void)
*
*   Description:
*     reconfigs fdq for remaining num of tones
*
*  Arguments:
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
void reconfig_next_fdq_for_l2pcb(void)
{
   int16 s_StartChnl, s_NumChnls;

   L2PowerCutBack_t *pt_L2PowerCutBack = &(gt_RxOLRPMVars.t_L2PowerCutBack);

   s_StartChnl = pt_L2PowerCutBack->s_PrevLastChnl + 1;
   s_NumChnls = gs_RxLastChannel - s_StartChnl + 1;

   pt_L2PowerCutBack->s_PrevLastChnl = gs_RxLastChannel;

   compute_fdqcoef(pt_L2PowerCutBack->s_L2FFTGaindB, pt_L2PowerCutBack->s_additionalFdqGaindB,
                   &(pt_L2PowerCutBack->s_FftScalebackMask), &(pt_L2PowerCutBack->s_fdqMultiplier),
                   gsa_pre_FDQ_coef, (int8 *)(void *)guca_pre_FDQ_exp, s_StartChnl, s_NumChnls, FALSE);

//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
//XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (START)
#ifdef HW_SNR_FDQ
    guc_ReconfigNextFdqCoefForL2Pcb = 0;
#endif
//XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (END)
//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)

}
// XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)

/*****************************************************************************
;  Subroutine Name: OLRPM_RxInit(int16 s_event)
;
;  This subroutine conducts reconfiguration for ADSL RX-side operations.
;
;  Prototype:
;     void OLRPM_RxInit(int16 s_event)
;
;  Input Arguments:
;
;
;  Output Arguments:
;
;
;  Return:
;
;
;  Global Variable used by this file:
;
;****************************************************************************/
void OLRPM_RxInit(int16 s_event)
{
    int i, j;
   int32 l_CheckBpnConfigAllowed;


   l_CheckBpnConfigAllowed = FALSE;

   /* Do Bpn only Reconfig */
   if(s_event & RECONFIG_Bpn)
   {
      /* Initialize variables */
         gt_RxShowTimeVars.t_FrameParms[0].s_RawFrameSize = 0;
         gt_RxShowTimeVars.t_FrameParms[1].s_RawFrameSize = 0;
      // Under the assumption that we have initialized these in showinitrx.c
      // there is no need to initialize here again
      //for(i = 0; i < NUM_BEARER_CHANNELS; i++) {
      // gt_RxShowTimeVars.t_BCParms[i].sa_BC_Bytes = 0;
      // gt_RxShowTimeVars.t_BCParms[i].sa_BC_BytesIn = 0;
      // gt_RxShowTimeVars.t_BCParms[i].sa_BC_LPath = -1;      // Undefined
      // gt_RxShowTimeVars.t_BCParms[i].sa_BC_LSXASX = -1;     // Undefined
      //}

      /* Reconfigure changed variables */
      for(i = 0; i < NUM_DS_BEARER_CHANNELS_SUPPORTED; i++)
      {
         j = guca_rxBCnToLPp[i];


         if (j != DISABLED_LP)
         {
            // if we get valid latency path associated with this bearer channel
            gt_rx_config.sa_currentBpn[i][j] = gt_rx_config.sa_Bpn[i][j];

            gt_RxShowTimeVars.t_FrameParms[j].s_RawFrameSize +=
               gt_rx_config.sa_Bpn[j][i];
            gt_RxShowTimeVars.t_FrameParms[j].sa_B_alloc[i] =
               gt_rx_config.sa_Bpn[j][i];
            gt_RxShowTimeVars.t_FrameParms[j].sa_B_in[i] = 0;

            gt_RxShowTimeVars.t_BCParms[i].sa_BC_Bytes = gt_rx_config.sa_Bpn[j][i];
            gt_RxShowTimeVars.t_BCParms[i].sa_BC_BytesIn = gt_rx_config.sa_Bpn[j][i];
            gt_RxShowTimeVars.t_BCParms[i].sa_BC_LPath = j;
            gt_RxShowTimeVars.t_BCParms[i].sa_BC_LSXASX = i;
         }
      }

      /* ========================================================================= */
      /* Verify if codeword size < 256 */
      /* Also computes parameters for Rx framer block configuration */
      /* ========================================================================= */
      VerifyAndUpdateRxFramerParameters();

      /* Check if Bpn reconfiguration caused a change in possibilities of future */
      /* Bpn reconfiguration on this latency path */
      l_CheckBpnConfigAllowed = TRUE;
   }

   /* Do Lp reconfig */
   if((s_event & RECONFIG_Lp) && (!(gt_RxOLRPMVars.s_rxOLRPMEvent & RECONFIG_Bpn)))
   {
      /* If no pending Bpn reconfiguration, check if Lp reconfiguration caused a change in */
      /* possibilities of future Bpn reconfiguration on this latency path */
      l_CheckBpnConfigAllowed = TRUE;
   }

   if (l_CheckBpnConfigAllowed)
   {
      for(i = 0; i < NUM_DATA_PATHS; i++)
         CheckForBpnReconfig(gt_RxShowTimeVars.t_FrameParms[i].s_CodewordSize,
            gt_rx_config.s_Lp[i], gt_rx_config.s_Rp[i], gt_rx_config.s_Dp[i], &gft_RxBpnReconfigAllowed[i]);

   }
   /* Do PCB reconfiguration */
   if(s_event & RECONFIG_PCB)
   {
        //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
        //XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (START)
        //Move to background tasks to avoid MIPs peaking.
   #ifndef HW_SNR_FDQ
      reconfig_fft_fdq_for_l2pcb();

           // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)
           //Split new FDQ co-eff computation across two symbols (to reduce cycles consumption per symbol)
           if (gs_RxLastChannel > MAX_NUM_CHNLS_FOR_FDQ_COMPUTATION) {
              AddFunctionToFifo(gp_RxLoadingFunctionFifo, reconfig_next_fdq_for_l2pcb);
           }
           // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)
        #endif
        //XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (END)
        //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)
   }
}


/*****************************************************************************
;  Subroutine Name: OLR_BgBackupRxConfig(void)
;
;  This subroutine backsup the BAT and Gains table
;
;  Prototype:
;     void OLR_BgBackupRxConfig(void)
;
;  Input Arguments:
;
;
;  Output Arguments:
;
;
;  Return:
;
;
;  Global Variable used by this file:
;
;****************************************************************************/
void OLR_BgBackupRxConfig(void)
{
   /* For L2 reconfigurations, currentLp/currentRxBat/currentRxFineGains tables always contain the L0 state Lp/Bat/Gain values */
   /* Backup the Lp value into s_currentLp for OLR only */
      gt_rx_config.s_currentLp[0] = gt_rx_config.s_Lp[0];
      gt_rx_config.s_currentLp[1] = gt_rx_config.s_Lp[1];

   OLRPM_RxPostProcessing(STAT_OLRStatus_DS);


#ifdef LEAVE_TRAIL
   OLRPM_PrnShowtimeParams(0,1, OLR_BACKUP_CONFIG);
#endif

   /* Done with reconfiguration, clear State */
   gt_RxOLRPMVars.uc_rxOLRPMState = L0_STEADY_STATE;
}

/*****************************************************************************
;  Subroutine Name: PM_BgRxL0ToL2Config(void)
;
;  This subroutine does background tasks for L0 to L2 transition
;
;  Prototype:
;     void PM_BgRxL0ToL2Config(void)
;
;  Input Arguments:
;
;
;  Output Arguments:
;
;
;  Return:
;
;
;  Global Variable used by this file:
;
;****************************************************************************/
/* For reasons not known yet, fdqs change after L0 to L2 state transition by*/
/* around 1%. This would cause adverse effects in L0 restore when we do not */
/* have excess margin. even this 1% change can cause large # of errors then   */
FlagT gft_disableL2FdqAdapt=TRUE;   // for now
void PM_BgRxL0ToL2Config(void)
{
#ifdef LEAVE_TRAIL
   OLRPM_PrnShowtimeParams(0, 1, PM_L0TOL2_BACKUP_CONFIG);
#endif
   OLRPM_RxPostProcessing(STAT_PMStatus);
   /* Disable FDQ adaptation in L2 state */
   if (gft_disableL2FdqAdapt) guc_FdqAdaptationState = FDQ_ADAPTATION_DISABLE;
}


/*****************************************************************************
;  Subroutine Name: OLRPM_BgRestoreRxL0Config(void)
;
;  This subroutine restore the s/w copy of L0 state BAT and Gains table
;
;  Prototype:
;     void OLRPM_BgRestoreRxL0Config(void)
;
;  Input Arguments:
;
;
;  Output Arguments:
;
;
;  Return:
;
;
;  Global Variable used by this file:
;
;****************************************************************************/
void OLRPM_BgRestoreRxL0Config(void)
{
#ifdef LEAVE_TRAIL
   if(gt_RxOLRPMVars.uc_rxOLRPMState == PM_BKGND_PROC_STATE)
      OLRPM_PrnShowtimeParams(0, 1, PM_RESTOREL0_BACKUP_CONFIG);
#endif

   // Restore original fine gains and associated metrics.
   // Currently we restore gains from a software copy of the table.  To conserve
   // data memory this could be changed back to require restoration from h/w again.
   memcpy(gsa_RxFineGains, gsa_TempRxFineGains, sizeof(int16) * gs_RxNumTones);
   gl_SumFGainLinSq = gl_save_SumFGainLinSq;
   gl_SumGiSqTssiSq = gl_save_SumGiSqTssiSq;

   //restore the actatp
   gt_NearEndParam.s_ActualAggregateXmtPwr = gs_DS_ACTATP_L0;

// CalcDecodGain(guca_RxBat, gsa_RxCombinedGains, gsa_RxFineGains, 0, gs_RxNumTones, TRUE, NULL);
// ConvertGainsToDB(gsa_RxFineGains);

   /* ========================================================================= */
   /* Verify if frame size matches to bit allocation table (DMT/BIS Showtime,OLR,L2)*/
   /* Also computes parameters for Rx QAM/TCM block configuration*/
   /* ========================================================================= */
   VerifyAndUpdateRxQAMParameters();

   if(gt_RxOLRPMVars.uc_rxOLRPMState == OLR_BKGND_PROC_STATE)
      OLRPM_RxPostProcessing(STAT_OLRStatus_DS);
   else
   {
      OLRPM_RxPostProcessing(STAT_PMStatus);

      // restore these only for PM
      gsa_DSOvhdRate[0] = gsa_save_DSOvhdRate[0];
      gsa_DSOvhdRate[1] = gsa_save_DSOvhdRate[1];
      gla_DSDataRate[0] = gla_save_DSDataRate[0];
      gla_DSDataRate[1] = gla_save_DSDataRate[1];
   }

   /* Done with reconfiguration, Clear Event and Update State */
   gt_RxOLRPMVars.s_rxOLRPMEvent = 0;
   gt_RxOLRPMVars.uc_rxOLRPMState = L0_STEADY_STATE;
}



