/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             showinit_olr.c
 * DESCRIPTION:      Functions that implement the showtime state OLR.
 *
 **********************************************************************/

#include <stdio.h>
#include "common.h"
#include "gdata.h"
#include "dslengin.h"
#include "dec_gain.h"
#include "cmv.h"
#include "tone_ord.h"
#include "bitload.h"
#include "rx_m3oh.h"
#include "enc_gain.h"
#include "dec_adap.h"
#include "gdata_bis.h"
#include "trailend.h"
#include "ovhd_ini_bis.h"
#include "aoc_ini.h"
#include "showinit.h"
#include "T1413.h"
#include "ghs.h"
#include "olr_Bpn_check.h"
#include "states.h"
#include "ApplyFineGains.h"
#include "tx_ops_bis.h"
#include "tx_ops.h"
#include "memory.h"
#include "showtime_bis.h"

/*****************************************************************************
;  Subroutine Name: OLR_TxInit(void)
;
;  This subroutine conducts reconfiguration for ADSL TX-side operations.
;
;  Prototype:
;     void OLR_TxInit(void)
;
;  Input Arguments:
;
;
;  Output Arguments:
;
;
;  Return:
;
;
;  Global Variable used by this file:
;
;****************************************************************************/
void OLR_TxInit(void)
{
   int i, j;

   //RECONFIG_Bpn
   {
      /* Initialize variables */
        for(i = 0; i < NUM_US_LATENCY_PATHS; i++)
        {
         gt_TxShowTimeVars.t_FrameParms[i].s_RawFrameSize = 0;
      }

      // Under the assumption that we have initialized these in showinittx.c
      // there is no need to initialize here again
      //for(i = 0; i < NUM_BEARER_CHANNELS; i++) {
      // gt_TxShowTimeVars.t_BCParms[i].sa_BC_Bytes = 0;
      // gt_TxShowTimeVars.t_BCParms[i].sa_BC_BytesOut = 0;
      // gt_TxShowTimeVars.t_BCParms[i].sa_BC_LPath = -1;      // Undefined
      // gt_TxShowTimeVars.t_BCParms[i].sa_BC_LSX = -1;        // Undefined
      //}

      /* Reconfigure changed variables */
      for (i = 0; i < NUM_US_BEARER_CHANNELS_SUPPORTED; i++)
      {
         j = guca_txBCnToLPp[i];


         if (j != DISABLED_LP)
         {
            gt_TxShowTimeVars.t_FrameParms[j].s_RawFrameSize +=
               gt_tx_config.sa_Bpn[j][i];

               gt_TxShowTimeVars.t_BCParms[i].sa_BC_Bytes = gt_tx_config.sa_Bpn[j][i];
               gt_TxShowTimeVars.t_BCParms[i].sa_BC_BytesOut = gt_tx_config.sa_Bpn[j][i];
         }
      }
      for(i=0; i < NUM_US_LATENCY_PATHS; i++)
      {
         if (gt_tx_config.s_Lp[i] > 0)
            gt_TxShowTimeVars.t_FrameParms[i].s_MuxFrameSize = gt_TxShowTimeVars.t_FrameParms[i].s_RawFrameSize + 1;
         else
            gt_TxShowTimeVars.t_FrameParms[i].s_MuxFrameSize = 0;

         // For faster Rx Data Pump processing -- ZA Run Count Mechanism
         gsa_TxMuxFrameSize[i][0] = gt_TxShowTimeVars.t_FrameParms[i].s_MuxFrameSize;
         gsa_TxMuxFrameSize[i][1] = (gsa_TxMuxFrameSize[i][0] + gt_tx_config.s_Rp[i]);

         gt_TxShowTimeVars.t_FrameParms[i].s_CodewordSize_Odd =
         gt_TxShowTimeVars.t_FrameParms[i].s_CodewordSize =
            (gt_TxShowTimeVars.t_FrameParms[i].s_MuxFrameSize *
            gt_tx_config.s_Mp[i]) +
            gt_tx_config.s_Rp[i];

         if(!(gt_TxShowTimeVars.t_FrameParms[i].s_CodewordSize&0x1))
            gt_TxShowTimeVars.t_FrameParms[i].s_CodewordSize_Odd++;
      }
   }

   /* Check if Bpn/Lp reconfiguration caused a change in possibilities of future */
   /* Bpn reconfiguration on this latency path */
   for(i=0; i < NUM_US_LATENCY_PATHS; i++)
      CheckForBpnReconfig(gt_TxShowTimeVars.t_FrameParms[i].s_CodewordSize,
      gt_tx_config.s_Lp[i], gt_tx_config.s_Rp[i], gt_tx_config.s_Dp[i], &gft_TxBpnReconfigAllowed[i]);

}

/*****************************************************************************
;  Subroutine Name: OLR_BgBackupTxConfig(void)
;
;  This subroutine backsup the BAT and Gains table
;
;  Prototype:
;     void OLR_BgBackupTxConfig(void)
;
;  Input Arguments:
;
;
;  Output Arguments:
;
;
;  Return:
;
;
;  Global Variable used by this file:
;
;****************************************************************************/
void OLR_BgBackupTxConfig(void)
{
   // we think we have successfully completed the OLR task
   STATArray[STAT_OLRStatus_US] &= ~STAT_OLRPM_IN_PROGRESS;
   STATArray[STAT_OLRStatus_US] |= STAT_OLRPM_COMPLETE|STAT_OLRPM_RESPONSE;

#ifdef LEAVE_TRAIL
   OLRPM_PrnShowtimeParams(1,0, OLR_BACKUP_CONFIG);
#endif

   /* Update gsa_Showtime_TxToneBuf to use data symbol fine gains for sync frames */
   /* Get R_REVERB from that saved in buffer (use buffer to avoid program meory needed to regenerate it) */
   memcpy(gsa_Showtime_TxToneBuf, gsa_TxToneBuf, sizeof(int16) * (TX_FFT_LENGTH+2));
   /* make it R_SEGUE if need be*/
   if (gs_TxSyncToneType) PhaseInvertSyncSymbol(NULL);
   /* now apply fine gains */
   ApplyFineGains(gsa_Showtime_TxToneBuf, (int16)gs_TxFirstChannel, (int16)gs_TxLastChannel, (uint16 *)(void *)gt_tx_config.psa_FineGains);

   /* Done with reconfiguration, Update State */
   gt_TxOLRVars.uc_txOLRState = L0_STEADY_STATE;
}
