/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  showtime_rx_b_bis.c
;
;  Bis-only showtime background functions relating to sync symbol or SNR processing.
;
;***************************************************************************/

// ******************************************************************************************************************************
// showtime_rx_b_bis.c
//
// History
//
// 14/12/2012 Hanyu/Vinjam: Integrated "XDSLRTFW_523" changes to R5.2 mainline
//          Fixed low ATTANDRds issue when SRA is enabled in capped/fixed rate cases.
//          Replaced gs_RxDesiredMargin with gs_RxDesiredMargin_original from bitloading
//          since gs_RxDesiredMargin could be overwritten by gs_RxAvMargin in SRA,
//          which would cause lower ATTANDRds when gs_RxAvMargin is much higher than target margin in capped/fixed rate cases.
//              Grep for XDSLRTFW-632 XDSLRTFW_523 BugFix_DS_BisPlus_AB_All_UpdateATTNDRds_SRA
//
//  23/05/2013 Anantha Ramu: Did modifications to set proper ATTNDR values in ReTx mode.
//                           Grep for: XDSLRTFW-923:Fix_DS_BisPlus_ALL_ReTx_Attndr
// ******************************************************************************************************************************

#include "common.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "diagparam_bis.h"
//XDSLRTFW-923:Fix_DS_BisPlus_ALL_ReTx_Attndr Begin
//max(1/S1)*252*8*4*(1-(2/3+4)/252)
#define ATTNDR_LIMIT_FACTOR 7914667
//XDSLRTFW-923:Fix_DS_BisPlus_ALL_ReTx_Attndr End

/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *    UpdateATTNDR
 *
 * Prototype:
 *    void UpdateATTNDR();
 *
 * Input Arguments:
 *
 * Output Arguments:
 *
 *  Abstract:  Updates Attainable Net Data Rate estimate
 *
 *  Returns:
 *
 *------------------------------------------------------------------------
 */
void UpdateATTNDR(void)
{
   int32 l_delta;
//XDSLRTFW-923:Fix_DS_BisPlus_ALL_ReTx_Attndr Begin
   uint32 ul_tmp;
//XDSLRTFW-923:Fix_DS_BisPlus_ALL_ReTx_Attndr End
   // int16 s_delta;

   // Add only excess margin reduction to coding gain value.  Before we was using RMSgi which includes both excess margin and fine gain.
   // Also account for margin delta from optn 20.
  // XDSLRTFW-632 XDSLRTFW_523 BugFix_DS_BisPlus_AB_All_UpdateATTNDRds_SRA (SATRT)
    // Replace gs_RxDesiredMargin with gs_RxDesiredMargin_original from bitloading
    // since gs_RxDesiredMargin could be overwritten by gs_RxAvMargin in SRA,
    // which would cause lower ATTANDRds when gs_RxAvMargin is much higher than target margin in capped/fixed rate cases.
      //gl_ATTNDRds_Estimate_Updated = (int32) CalcATTNDR(gsa_RxShowtimeSnrBuf, (gs_RxDesiredMargin - OPTNArray[OPTN_MarginDelta]), (int16)(gs_CodingGainForATTNDR + gt_FineGainInfo.s_ExcessMarRedDB ));
      gl_ATTNDRds_Estimate_Updated = (int32) CalcATTNDR(gsa_RxShowtimeSnrBuf, gs_RxDesiredMargin_original, (int16)(gs_CodingGainForATTNDR + gt_FineGainInfo.s_ExcessMarRedDB ));
  // XDSLRTFW-632 XDSLRTFW_523 BugFix_DS_BisPlus_AB_All_UpdateATTNDRds_SRA (END)

      // Total data rate difference in bits/second.
      l_delta = (gl_ATTNDRds_Estimate_Updated - gl_ATTNDRds_Estimate_Initial);

      // Account for fraction of rate consumed by RS checkbytes, if any.
//    s_delta = QuickAverage(l_delta, s_CWSize - s_Rp);
//    l_delta = (int32) s_delta * s_CWSize;

      // New ATTNDR estimate is original Medley-based ATTNDR (based on actual bitloading)
      // plus the estimated delta based on Showtime vs. Medley SNRs.
      gl_ATTNDRds_Estimate_Updated = gl_ATTNDRds_Initial + l_delta;
//XDSLRTFW-923:Fix_DS_BisPlus_ALL_ReTx_Attndr Begin
   if(gt_ReTxConfigInfo.ft_ReTxOn == 1)
   {
      ul_tmp = (uint32)((gt_ReTxConfigInfo.us_SpMinInvers) * ATTNDR_LIMIT_FACTOR);
      if(gl_ATTNDRds_Estimate_Updated >= ul_tmp)
      {
         gl_ATTNDRds_Estimate_Updated = ul_tmp;

      }

   }
//XDSLRTFW-923:Fix_DS_BisPlus_ALL_ReTx_Attndr End
}
