/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
*
* Aware DMT Technology. Proprietary and Confidential.
*
* ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
* TELEPHONE:        781.276.4000
* FAX:              781.276.4001
* WEB:              http://www.aware.com
*
* FILE:             showtime_rx_bis.c
* DESCRIPTION:      Functions that implement the showtime RX non-time critical tasks for g.dmt.bis.
*
**********************************************************************/
// ******************************************************************
// showtime_rx_bis.c
//
// History
//
// 19/04/2010 Nihar: For debugging purposes it's very helpfull to have information
//            about the previous exception state/code available. So, put previous
//            Exc.Code/State into persistent memory and map it to CMVs
//            cr STAT 22 0 -> Prev. Exception State
//            cr STAT 23 0 -> Prev. Exception Code
//            Grep for Feature_ALL_ALL_ALL_PrevExceptionsCMV
//
// 06/08/10 Nihar: Added code to delay DS BitSwap
//       for all DSLAMs in DMT mode. Grep for the following
//       (i) IOP_DS_DMT_ALL_EnableDsBitSwap
//
// 10/08/2010 Nihar: Clear Persistent memory bit which was being used to get
//            Reduced C-RATES-RA option in ADSL1 Mode. Grep for
//            PERF_DS_DMT/T1413_ALL_ReduceBmaxInRMsgRA_ToGetLessCratesRAOptions
//
// 10/08/10 Nihar: Time period for declaring "Los due to CRC errors" is increased to 16 seconds.
//                 Reason: To pass the RFI test at AT&T
//                 Grep for "ENH_DS_ALL_ALL_LOS_16Sec"
//
// 17/08/2010 AdeelJ/Palaksha/Bhadra: IOP fix for SRA Upshift and Downshift not achieving the Target Margin.
//               Changed Logic to start Upshift and DnShift SRA process instead of checking for
//               SRA Trigger Margin. The Process ends when the Average Margin reaches between
//               (Target Margin) and (Target Margin + 0.25dB).
//               Modified Bitswap trigger thresholds during SRA Upshift process in order to equalize
//               Per Tone Margins. This is to reduce chance of CRCs when approaching Target margin.
//               Grep for SMS00951973:IOP_DS_BISPlus_ALL_SRATargetMarginFix
//
// 17/08/2010 AdeelJ/Palaksha/bhadra: Modification of SRA Algorithm to make SRA Step more accurate and inclusion of
//               overshoot check for SRA DnShift.
//               removed external reference to Upshift Process as the variable is now declared in gdata.h
//               changed variable types of Upshift and DnShift process to global flag.
//               Grep for SMS00954738:Feature_AB_DS_BISPlus_ALL_IncreaseAccuracySRAStep
//
// 17/08/2009 Kannan/Bhadra: IOP fix for Downstream Upshift SRA failure
//                    against  ISAM 7302 NALT-C  & Geminax.
//               Grep for SMS00900615 IOP_DS_BISPLus_ALL_AllowUpshiftSRA
//
// 02/08/2011 Vinjam: LOS due to CRC count is taken out.
//                    LOS is triggered only with drop in pilot power.
//                    Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//
// 23/08/2011 Vinjam: detect_LOS( ) routine is called for every symbol.
//                    call to detect_LOS( ) routine is taken out from sync symbol handler
//                    It is placed in show tme NTC task function.
//                    Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//
// 06/09/2011 Vinjam: Report LOS Due to DS CRC through a CMV PLAM 0 0 Bit-14 (Mask: 0x4000)
//                    Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//
// 23/09/2011 Kannan: LOS declaration change based on CRC is taken from DMT mode
//                    to declare LOS. This is required when strong RFI noise is applied
//                    to sustain the link without link drop. This change can be generic and
//                    need not be DSLAM specific.
//               Grep for XDSLRTFW-332 IOP_A_DS_BisPlus_CNXT_BitswapDuetoRFI
//
// 10/01/2012 Shakil/Bhadra: Random link drops seen in ADSL2p mode in a noisy line of DTAG customer house.CPE dropped the link
//             due to near end LOS generated by excessive Downstream CRCs. According to our reboot criterion it
//             requires more than 1000 downstream CRCs to declare LOS from the CPE side but while we supressed
//             the LOS generation (cw test 29 0 0x4) we did not see the issue and the maximum CRC was less
//             than 300. Since we expected more than 1000 CRCs when the LOS was supressed the root cause was in
//             the LOS based on CRC block of the code where we did not increase gsa_good_count_ variable atall which
//             trigerred LOS if CRC is increased by more than 40 in 20 seconds interval. The reason that gsa_good_count
//             did not increased is, it resides in a function called ProcessFramingBytes() which was excluded in the VR9
//             compilation process(executes only ifndef HERCULES_ADSL_CPE). Asa fix this variable was moved to the
//             correct place to be compiled and incremented correctly.
//             Code Grep: XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC
//
// 05/06/2012 Vinjam: Re-adjusted showtime snr buffer pointer to convey actual ShowTime SNR in the presence of
//            virtual noise break points in overhead channel, in reply to SNRps EOC command (from DSLAM).
//            It also helps to alter the initialization of "gpsa_RxSnrBuf_ovhd" based on Present/absence of downstream virtual noise break points.
//            Grep for XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise
//
// 19/06/2012 Ram: Merged "ReTx" related MGMT counters and Test Params code from
//                 ARX ADSL code base (Grep: FEATURE_DS_BisPlus_ALL_ReTx_MGMTCntrs_TestParams)
//                 Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//19-02-2013 Anantha: Added logic to correct difference between previous CRC count and present CRC count
//             when CRC counter wraps around.
//             Grep for XDSLRTFW-259: BugFix_DS_All_All_LosDetWhileCRCCntWrap
//
// 22/03/2103 Ram: PM L2 fixes for JIRA 416.
//                 a) DEC adaptation is restricted to L0 state only. We are seeing burst CRC errors when
//                    DEC adaptation is enabled in L2 state. Remove this restriction once the issue is fixed.
//                 b) Calling ReverbSegueDetectorSetup() in 'Data symbol 1' (during L0 to L2 transition)
//                    to avoid Mips Peaking
//                 Grep for XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2
//
//  19/06/2013 Balabath:Link drops when there is a change number of 1bit loaded
//  tones after bitswap.Link drops were observed with Annex M mode only, AnnexA
//  cases seems fine.Did experiments by disabling "1 "bit tone modifications
//  during bit-swap, and link is stable.Required RX_MIN_ADDR (IR_ACT_ADDRD)
//  programming to be (gs_RxFirstChannel-1) when No. of 1 bit tones are not
//  multiple of 4. With this fix, AnnexM link is stable.
//
//  Avoid triggering of continuous bitswaps in these profiles: Removed the
//  code changes that overwrites "gs_RxDesiredMargin"(ie., Target Margin).
//  Grep for XDSLRTFW-945 Bug_DS_BisPlus_SRACappedprofile_Lindrops.
//
// 25/06/2013 Kannan:
//            DEC Rx Samples capture state machine is controlled through
//            intermediate DEC state variables to control DEC Capture
//            HW state machine. This is required to avoid DEC HW state machine
//            to be in intermediate state indefinetely.
// Grep for XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest.
//
// 30/08/2013 Prashant:
//            Get SNR without virtual noise, irrespective of request from CO.
//            Grep XDSLRTFW-1170 Feature_DS_BisPlus_All_GetSnrWoVN
//
// 08/04/2013 ChihWen/Balabath:
//            Optimize the code for SRA, which are mainly as below.
//            1. Modify gs_MaxRateLp/gs_MinRateLp to be the max/min Lp complying to all framing constraints(including max/min net rate) when framing check is enabled(INFO 103 26 bitmask(0x400)),
//               gs_MaxRateLp/gs_MinRateLp will be the Lp with max/min net rate when framing check is not enabled.
//                2. Combine the framing check in "isValidFramingConfiguration" and "RShowtimeRxF_BIS". The combined framing check will refer to gs_MaxRateLp/gs_MinRateLp.
//                3. Optimize the CMV setting related to SRA.
//                4. Add two CMV to enable/disable the checking for min INP, and max delay when searching delta Lp in training.
//            Grep for XDSLRTFW-721 Enhance_DS_BisPlus_ALL_OptimizedSRACode
// 06/11/2013 Balabath :XDSLRTFW-1313 XDSLRTFW-1208In TR105E testsuite SRA functional tests were failing.
// The problems are
// 1) Expected Result SRA_reported_margin_downshift_ds >= RA-DSNRM is not meeting
// Description: This is due to the Min message based overhead data rate requirement.
// As per the profile configured, MinDSOverheadRate is 6kbps, after framing params
// Message based Ovhd rate is 6.3 kbps only. This restricts Downshift SRA.
// Solution: Modift framing params calculation to come up with more DSOverheadRate
// for SRA profiles.
// 2) Upshift SRA triggered before reaching RA-USNRM.
// Description: These are because of the fixes added to reach target margin after
// downshift or upshift. But there are multiple bugs with this portion of code.
// 2.a)Upshift SRA triggered before reaching RA-USNRM
// 2.b)Not honouring RA-DTIMEus.
// 2.c)Not honouring RA-DTIMEds etc..
// 2.d) SRA triggers when BER test is undergoing.
// Solutions:Total algorithm needs to be modified. Changes include
// 2.a)Fix for Upshift SRA triggered before reaching RA-USNRM.
// 2.b)Consider parameter RA-DTIMEus.
// 2.c)Consider parameter RA-DTIMEds.
// 2.d)Reaching Target Margin moved under CMV control.
// CMV INFO 103 28 1(bitmask 0x1). By default this is disabled.
// (This will be enabled based on the customer requirement.)
// And if multiple SRAs are required to reach target margin,
// They will be issued within settling time (30s) and the process will be stopped
// after settling time. Otherwise SRA triggers are going to happen when BER process starts.
// 3) Other changes include introduction of new CMV bits.
// 3.a) CMV control for enable/disable framing constraint minoverhead rate conveyed in GHS.
// CMV INFO 103 28 2(bitmask # 0x0002 [CMV_SRA_TO_ENABLE_MINOVERHEAD_GHS_CHECK]).
// By default this is enabled.
// 3.b) CMV control for enable/disable framing constraint Maxdelay conveyed in GHS.
// CMV INFO 103 28 4(bitmask # 0x0004 [CMV_TO_ENABLE_SRA_MAXLATENCY_CHECK]).
// By default this is enabled.
// Note: For CNXT DSLAM this CMV will disabled internally in the code. With
// CNXT DSLAMs, OneOverS is limited to 3. This will have impact on delay constraint and NDR.
// Tests show that voilation of delay constraint works fine with CNXT based DSLAMs.
// To find code changes grep for
// XDSLRTFW-1313 XDSLRTFW-1208 : BugFix_DS_BisPlus_All_TR105SRAChanges
// Downshift process and Upshift process introduced to reach close to target_margin +- 0.5dB
// There were some problems with FLEXIT2 TR-105 SRA cases
// FLEXIT stops if DnShift+UpShift is triggered during "gft_SRADnShift_process"
// So make sure only DnShifts will be allowed here during Downshift process.
// Grep for XDSLRTFW-1313 XDSLRTFW-1208 : BugFix_DS_BisPlus_All_TR105SRAChanges to see code changes
//
// 09/09/2014 ChihWen: HW acceleration for FDQ adaptation and SNR measurement.
//            Grep for XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ
//
// 09/09/2014 ChihWen: Avoid MIPs peaking in L2 entry and exit by moving calculation of FDQ coefficients to background tasks.
//            Grep for XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit
// 09/04/2014 Sriram Shastry: To avoid showtime link drop and long training time against ECI/Pulsecom DSLAM
//      at AT&T lab with AT&T capped US/DS lower data rates profiles, the following changes are introduced:
//      (1) US Tx powercutback by 4dB on all loops to avoid US linkdrop.
//      (2) Preferred to select pilot tone #48 and reduced the pilot power threshold
//          to avoid US/DS link drop due to polit tone corruption.
//      (3) Limited US max bits/bin to 8.
//      The above changes are protected by PLSE CO vendor ID and CMV
//      info 103 26 0x0800 with default value 0 (Disabled).
//      Enabling the CMV bit may introduce side-effects for both US and DS performance.
//      It is only recommended for AT&T profiles with the capped US/DS lower data rates
//      attached in the Jira entry.
//         Grep for ADSLRTFW-1412_XDSLRTFW-1591_IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop
//
// 29/04/2015 Vinay: Fixed the issue of not able to read DS SNR in DELT mode from CPE side.
//
//  2/12/2015 Sriram Shastry : Observed Quartz instabilities with  AVM  fritzbox[7490]. Added Detection algorithm for frequency drift and  phase drift
//  such that PLL adapt's to  fast setting  instead of  showtime setting .It helps to avoid showtime link drops in field
//
// Grep for : XDSLRTFW-2464
// ****************************************************************************

#include <stdio.h>
#include "common.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "xgdata.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "pn_tab.h"
#include "states.h"
#include "mtkernel.h"
#include "enc_gain.h"
#include "dec_gain.h"
#include "tx_m3oh.h"
#include "rx_m3oh.h"
#include "rt_tones.h"
#include "rt_state.h"
#include "synsymbl.h"
#include "datasymbl.h"
#include "tone_ord.h"
#include "bitload.h"
#include "fifo.h"
#include "cmv.h"
#include "mp.h"
#include "dslengin.h"
#include "qos.h"
#include "dec_adap.h"
#include "pll.h"
#include "timercov.h"
#include "bitswap.h"
#include "rx_plam_bis.h"
#include "prf_man.h"
#include "bert.h"
#include "detect.h"
#include "showtime_bis.h"
#include "ovhd_bis.h"
#include "tx_ovrhd_bis.h"
#include "ovhd_ini_bis.h"
#include "rx_ovrhd_bis.h"
#include "showinit.h"
#include "tx_plam.h"
#include "tx_plam_bis.h"
#include "trail.h"
#include "mul.h"
#include "stdlib.h"
#ifdef REIN_DBG_CODE
#include "memrymap.h"
#include "LL_IOf.h"
#include "zep_memmap.h"
#include "zep_memmap_cnfg.h"
#endif

// XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
#ifdef L2_RES_DBG
#include "LL_IOf.h"
#include "memrymap.h"
#include "iri_iof.h"
#endif
// XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)

// IOP_DS_DMT_ALL_EnableDsBitSwap (Start)
#ifndef ISDN   // Only for Anx-A
extern void Check_DsBitSwapTimeWindow(void);
#define FIRST_BITSWAP_SFRAMES_DELAY 50
#define NEXT_BITSWAP_SFRAMES_DELAY  20
#endif // ifndef ISDN
// IOP_DS_DMT_ALL_EnableDsBitSwap (End)


//==============================
// Rx OLR Utilities
//==============================
#define START_RX     2 // A new state of gft_RestoreShowtimeBGState for kicking off showtime tasks


//XDSLRTFW-332 IOP_A_DS_BisPlus_CNXT_BitswapDuetoRFI (START - END)
extern int16 gs_bitswap_rx_sframe_count_4_times;
extern int16   gs_maxdatarate;

//XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (Start_End)
extern uint8  guc_RxDecCaptureState;

//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
//XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (START)
#ifdef HW_SNR_FDQ
#include "IRI_IOf.h"
#define L2_SETUP_RTV0_STATE   20
#define L2_SETUP_RTV1_STATE   21
#define L2_WAIT1_STATE        22
#define L2_WAIT2_STATE        23
#define MAX_NUM_CHNLS_FOR_FDQ_COMPUTATION       (370)
extern void compute_fdqcoef_for_l2exit(void);
#endif
//XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (END)
//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)


//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start)
/*
 *-------------------------------------------------------------------
 *
 * Prototype: void Update_UReTx_Counters(void)
 *
 *   Description: Reads parameters from the shared memory between DFE & PPE
 *
 *
 *
 *
 * Arguments:
 *    none
 *
 *
 *-------------------------------------------------------------------
 *
 */
void Update_UReTx_Counters(void)
{
   gus_17MSec_RxShowtimeFrameCnt = 0;

   gul_RxDtuCorrectedCNT = gt_ReTXStats.ul_CorrectedDtuCnt;
   gul_RxReTxDtuUncorrectedCNT = gt_ReTXStats.ul_UncorrectedDtuCnt;

   if(gul_RxReTxDtuUncorrectedCNT > gul_prev_RxReTxDtuUncorr )
   {
      gul_DTUuc += gul_RxReTxDtuUncorrectedCNT - gul_prev_RxReTxDtuUncorr;
      gs_norm_DTUuc_1sec += gsa_CRCincrement[1];
      gul_CRC_count_ReTx++;
   }
   gul_prev_RxReTxDtuUncorr = gul_RxReTxDtuUncorrectedCNT;
}

//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (End)

/*****************************************************************************
;  Subroutine Name: RShowtimeRxF_BIS
;
;  This subroutine runs RX state to perform the following
;  operations:
;     process synchronization symbol (SNR calculation and FDQ adaptation)
;     perform QAM decoding
;     perform deinterleaving
;     perform Reed Solomon decoding
;     perform descrambling
;     perform CRC check
;     extract sync byte
;     perform byte flip
;
;  Prototype:
;     void RShowtimeRxF_BIS(void);
;
;  Arguments:
;     none
;
;  Global Variable Used By This File:
;     gs_CRC_err_count  -- CRC error count
;     gsa_RxToneBuf[]      -- RX tone buffer
;     gsa_FFT_InBuf[]      -- buffer of input samples to FFT
;     gt_TDQInput       -- TDQ interface structure
;
;****************************************************************************/

// XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
#ifdef L2_RES_DBG
extern uint8 guc_L2Residue[8];
extern uint8 guc_L2ResData[8];
extern uint8  guc_L2ResIdx;
#endif
// XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)
#ifdef REIN_DBG_CODE
extern uint16 gusa_pll_err_log[];                  /* PLL error trace */
extern int16 gs_pll_err_index;
extern uint32 gul_UncorrectedDtuCnt_Last;
FlagT gft_LogCorruptFrame = TRUE;
int16 gs_pll_reduce_Index = 120;
uint16 gus_Log_Stop       = 0;


FlagT  CW_Status(uint8 InData, uint8 uc_shift);
#endif
void RShowtimeRxF_BIS(void)
{
    int32 s_priority, l_temp;
   FlagT ft_DnShift, ft_UpShift;
   //SMS00966298 SMS00951973 IOP_DS_BISPlus_ALL_SRATargetMarginFix (START)
   int16 s_SRA_step;
   int16 s_TARSNRMds;
   int16 s_USTTARSNRMds;
   int16 s_DSTTARSNRMds;
   //SMS00966298 SMS00951973 IOP_DS_BISPlus_ALL_SRATargetMarginFix (END)
   int16 s_temp_snr, s_temp_SnrDiff;//SMS00838915:DS_PERF_ALL_PllSnrThresshold (START END)

   // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
#ifdef REIN_DBG_CODE
   uint32 ul_metric_value;
   uint16 us_UncorrCW0_value;
   uint8 uc_metric_value;
   uint32 InDataCW0;
   uint32 InDataCW1;
   uint16 s_CodeWord0;
   uint16 s_CodeWord1;
   uint16 InDataCW_CNT;
   uint16 Prev_InDataCW_CNT;
   uint32 InDataCW_UNCORR_CW0;
   uint32 InDataCW_UNCORR_CW1;
   uint32 InDataCW_FEC_CNT;
   uint32 InDataCW_FLAG_CTRL1;
   int16 s_cw_diff;
   uint8 num_cw;
   uint8 InData;
   uint8 uc_CW_Status;
#endif
#ifdef L2_RES_DBG
   int32 temp = 0;

   ReadCoreReg((uint32)IRI_QT_REG_RX_LP0_BIT_FIFO_ADDR,&temp);
   guc_L2Residue[guc_L2ResIdx] = (temp & 0x700) >> 8;
   guc_L2ResData[guc_L2ResIdx] = (temp & 0xff);
   guc_L2ResIdx  = ((guc_L2ResIdx+1) & 0x7);
#endif
   // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)

    gul_TotalRxDataFrameCnt++;         // Increment count of total showtime Rx frames.

    if (gft_COSetTimer)
    {
        gft_COSetTimer = FALSE;
        gt_Timer = gt_Saved_CO_Timer;
    }
#ifdef REIN_DBG_CODE

   if((gs_pll_reduce_Index >0 ) && (gft_LogCorruptFrame == TRUE))
   {
      if(gs_RxPMDFrameCnt != RX_SYMBOLS_PER_SFRAME)      // Don't log  Sync  bytes
      {
         ReadCoreReg (IRI_QT_REG_RX_RMETRIC_VAL_ADDR, &ul_metric_value);
         uc_metric_value = ul_metric_value & 0xFF;
         gusa_pll_err_log[gs_pll_err_index++]  = uc_metric_value;                         // 1
#if 0
         ReadCoreReg (ZEP_PRAM_ZR_CODEWORD_LP1_ADDR, &InDataCW_UNCORR_CW1);       // How many CW Processed
         gusa_pll_err_log[gs_pll_err_index++]  = InDataCW_UNCORR_CW1;               //   CW_SIZE  KP_VAL & CB_SIZE   //2
         gusa_pll_err_log[gs_pll_err_index++]  = InDataCW_UNCORR_CW1>>16;           //  SYM_CW                 // 3
#endif
         ReadCoreReg (ZEP_PRAM_ZR_FEC_CNT_LP1_ADDR, &InDataCW_FEC_CNT);       // How many Un-CW  and  Corr-CW
         InDataCW_FEC_CNT  = (InDataCW_FEC_CNT & 0xFFFF0000);     //[2^16 = 65536]   //4
         gusa_pll_err_log[gs_pll_err_index++]  = (InDataCW_FEC_CNT>>16);      //[2^16 = 65536]   //4
         ReadCoreReg (ZEP_PRAM_ZR_CW_COUNT_LP1_ADDR, &us_UncorrCW0_value);   // How many code word processed in a Symbol [S =1/smin]
         InDataCW_CNT = (us_UncorrCW0_value & 0xFFFF);            //[2^16 = 65536]
         gusa_pll_err_log[gs_pll_err_index++]  = InDataCW_CNT;                //  7
         ReadCoreReg (ZEP_PRAM_ZR_UNCORR_CW0_LP1_ADDR, &InDataCW_UNCORR_CW0);       // How many CW went Bad for Reg Read 0-31
         gusa_pll_err_log[gs_pll_err_index++]  = (uint16)(InDataCW_UNCORR_CW0 & 0xFFFF);  // 8
         if ((InDataCW_UNCORR_CW0 == 0xFFFFFFFF)  && (gus_Log_Stop == 0) ) // 8
         {
            gus_Log_Stop = 1;
         }
         if (gus_Log_Stop == 1)
         {
               gs_pll_reduce_Index--;
         }
         gusa_pll_err_log[gs_pll_err_index++]  = gt_ReTXStats.ul_CorrectedDtuCnt & 0xFFFF;
         gusa_pll_err_log[gs_pll_err_index++]  = gt_ReTXStats.ul_UncorrectedDtuCnt & 0xFFFF;
         gusa_pll_err_log[gs_pll_err_index++]  = gt_ReTXStats.ul_GoodDtuCnt & 0xFFFF;
         gusa_pll_err_log[gs_pll_err_index++]  = gt_ReTXStats.ul_BadDtuCnt & 0xFFFF;
         gusa_pll_err_log[gs_pll_err_index++]  = gt_ReTXStats.ul_RetransmittedDtuCnt & 0xFFFF;
         gusa_pll_err_log[gs_pll_err_index++]  = gt_ReTXStats.ul_UnexpectedDtuCnt & 0xFFFF;
         gusa_pll_err_log[gs_pll_err_index++]  = gt_ReTXStats.ul_LastUncorrectedDtus & 0xFFFF;
         gusa_pll_err_log[gs_pll_err_index++]  = gt_ReTXStats.ul_ErroredBitsPerSec & 0xFFFF;
         InData = (uint8)(InDataCW_UNCORR_CW0 & 0xFF);
         s_cw_diff = InDataCW_CNT - Prev_InDataCW_CNT;
         if (s_cw_diff < 0)
         {
            num_cw = s_cw_diff + 65536;
         }
         else{
            num_cw = s_cw_diff;
         }
         uc_CW_Status  = CW_Status(InData,num_cw);
#if 0
         gusa_pll_err_log[gs_pll_err_index++]  = uc_CW_Status;             // 9
#endif
         if (InDataCW_CNT != Prev_InDataCW_CNT)
         {
            Prev_InDataCW_CNT = InDataCW_CNT;
         }
      }
      if (gs_pll_err_index == 9216)    // 9216 = 8192
      {
         gs_pll_err_index = 0;   // Stop Logging
      }
   }

#endif
    // Get the 1 sec timer based on the showtime Rx Frames
    // exclude 1 frame per supoerframe
    if(gs_RxPMDFrameCnt_FftFdqBufferSymbol != RX_SYMBOLS_PER_SFRAME)
    //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start)
    {
    //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (End)
      gus_1Sec_RxShowtimeFrameCnt++;

    //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start)
      gus_17MSec_RxShowtimeFrameCnt++;
    }

    //Changes as per section 11 of G.INP
    //As there is no CRC on the latecncy path carrying the DTUs, the CRC-8 anomaly is
    // redefined by the detection of at least one uncorrected DTU(s) per time unit(17 ms).
    if ((gus_17MSec_RxShowtimeFrameCnt >= RX_SYMBOLS_PER_SFRAME) &&
        (gt_ReTxConfigInfo.ft_ReTxOn == 1))
    {
       if (gft_RestoreShowtimeBGState == START_RX)
       {
           Update_UReTx_Counters();
       }
       else
       {   //Program flow comes here, in worst case scenario where SHOWBG2 is not swapped with in first 67 symbols
           gus_17MSec_RxShowtimeFrameCnt = 0;
       }
    }
    //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (End)
//#ifdef ISDN
   UpdatePLLAdaption(gsa_RxPilotTone);    /* XDSLRTFW-2464 */
//#endif
   gus_4096SymbolCnt = (gus_4096SymbolCnt+1) & 0xFFF;
    if (gus_1Sec_RxShowtimeFrameCnt == FRAME_COUNT_FOR_ONE_SEC)
    {
      // XDSLRTFW-1170 Feature_DS_BisPlus_All_GetSnrWoVN (Start)


      gus_1Sec_RxShowtimeFrameCnt = 0;
      if (gs_DD_1SecFdqUpdateCount < gs_DD_min1SecFdqUpdateCount)
         gs_DD_min1SecFdqUpdateCount = gs_DD_1SecFdqUpdateCount;
      gs_DD_1SecFdqUpdateCount = 0;

        // update the internal timer
        gt_Timer.uc_second++;
// XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead (START)
#ifdef HDLC_POLL_TEST
        guc_PollPrior1Messages++;
        guc_PollPrior2Messages++;
#endif
// XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead (END)
        if (!(gt_Timer.uc_second & 0x15)) gl_ShowTimeEventTrig=0; // Automatic retrigger every 16 seconds
        if (gt_Timer.uc_second == SECONDS_PER_MINUTE)
        {
            gt_Timer.uc_second = 0;
            gt_Timer.uc_minute++;
            if(gt_Timer.uc_minute == MINUTES_PER_HOUR)
            {
                gt_Timer.uc_minute = 0;
                gt_Timer.uc_hour++;
                if (gt_Timer.uc_hour == HOURS_PER_DAY)
                gt_Timer.uc_hour = 0;
            }
        }

        // ENH_DS_ALL_ALL_LOS_16Sec (Start_End)
        if (!(gt_Timer.uc_second % guc_RxCellDelineatePeriod)) // if >= 45*4 crcs in a 6 second interval, declare LOS
        {
            // In L2 the rate of CRC bytes can be very low.  We don't want to trigger a reset based on, e.g. 4 bad and 0 good CRCs. So
            // we require a minimum number of bad CRCs.  This effectively disables this check if the overhead rate is too low.
#define MIN_CRC_ERRORS_PER_PERIOD   (40)
            //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start)
            // change of int16 to uint16
            static uint16 us_prevCrcCnt=0;
            static uint16 us_prevGoodCnt=0;
            int16 s_deltaBadCnt, s_deltaGoodCnt;

            // set us_prevCrcCnt to the SW-initialized CRC-count value once at showtime-start
            if (us_prevCrcCnt == 0)
            us_prevCrcCnt = gusa_CRC_count[LP0_DATA_PATH];
            // assume no overflow, we could consider overflow situation,
            // but don't know whether it is worthwhile for this situation
            s_deltaBadCnt = gusa_CRC_count[LP0_DATA_PATH] - us_prevCrcCnt;

            s_deltaGoodCnt = gusa_good_count[LP0_DATA_PATH]-us_prevGoodCnt;   // overflow? eg: (-30000)-(31000) = -61000 >0 in signed int16

         //XDSLRTFW-259: BugFix_DS_All_All_LosDetWhileCRCCntWraps (start)
         if(s_deltaBadCnt<0) {
            s_deltaBadCnt = (int16)((int32)(1<<16)+gusa_CRC_count[LP0_DATA_PATH] - us_prevCrcCnt);
         }

         if(s_deltaGoodCnt < 0) {
            s_deltaGoodCnt = (int16)((int32)(1<<16) +gusa_good_count[LP0_DATA_PATH]-us_prevGoodCnt);
         }

         //XDSLRTFW-259: BugFix_DS_All_All_LosDetWhileCRCCntWraps (end)
#if 0    //XDSLRTFW-332 IOP_A_DS_BisPlus_CNXT_BitswapDuetoRFI (START - END)
            if ((s_deltaBadCnt > MIN_CRC_ERRORS_PER_PERIOD) && (s_deltaGoodCnt >= 0) && !(TESTArray[TEST_SuppressErrorReportingToME] & TEST_SuppressCRCBasedLosToME) &&
                    (s_deltaBadCnt >= (s_deltaGoodCnt << 4)))
            {
                // report LOS failure to ME if the cmv is not set
                gs_NearEndFailure |= PLAM_LOS_FailureBit;

                //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start_End)
                //Report LOS due to DS CRC
                gs_NearEndFailure |= PLAM_LOS_DueToCRC_FailureBit;

                gs_los_cnt++;    /* Count of LOS defects per second */

                gt_tx_Anomaly.uc_los_def = PRESENT;
            }
#else
         //XDSLRTFW-332 IOP_A_DS_BisPlus_CNXT_BitswapDuetoRFI (START)
            if ((s_deltaBadCnt >= 250) && (s_deltaGoodCnt >= 0) &&
            !(TESTArray[TEST_SuppressErrorReportingToME] & TEST_SuppressCRCBasedLosToME) &&
                    (s_deltaBadCnt >= (s_deltaGoodCnt << 4)))
            {
               gs_bitswap_rx_sframe_count_4_times++;
               if (gs_bitswap_rx_sframe_count_4_times > 4)
               {
                gs_bitswap_rx_sframe_count_4_times = 0;

                // report LOS failure to ME if the cmv is not set
                gs_NearEndFailure |= PLAM_LOS_FailureBit;

                //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start_End)
                //Report LOS due to DS CRC
                gs_NearEndFailure |= PLAM_LOS_DueToCRC_FailureBit;

                gs_los_cnt++;    /* Count of LOS defects per second */

                gt_tx_Anomaly.uc_los_def = PRESENT;
               }
            }
         else
         {
            gs_bitswap_rx_sframe_count_4_times = 0;   // reset the counter
         }
         //XDSLRTFW-332 IOP_A_DS_BisPlus_CNXT_BitswapDuetoRFI (END)
#endif
            us_prevCrcCnt = gusa_CRC_count[LP0_DATA_PATH];
            us_prevGoodCnt = gusa_good_count[LP0_DATA_PATH];
        }
         //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (End)

         //SMS00914848 DS_PERF_ALL_PllSnrThresshold (START)
         if ( (OPTNArray[OPTN_AlgControl3] & CMV_TO_ENABLE_TEMPCHAMBER_PLL_THRESSHOLD) && !(gt_Timer.uc_second % 2) )
         {
            s_temp_snr = gsa_RxShowtimeSnrBuf[gs_PilotToneIdx];
            if ( (s_temp_snr > 0) && (gs_pilot_STsnr_avg > 0) )
            {
               s_temp_SnrDiff = s_temp_snr - gs_pilot_STsnr_avg;
               s_temp_SnrDiff = abs((int32) s_temp_SnrDiff);//+ve
               if (s_temp_SnrDiff > 0x0500) //>5db
               {
                  gs_pilot_STsnr_avg = (gs_pilot_STsnr_avg + s_temp_snr) >> 1;//Avg of SNR's
                  gs_pilot_snir_threshold = gs_pilot_STsnr_avg - 0x0A00; //10dB = 10 * 256

                  if(gs_pilot_snir_threshold < 0)
                     gs_pilot_snir_threshold = 0;  //restricting min value to 16*256=4096=16dB
               }

            }
            else
            {
               gs_pilot_STsnr_avg = s_temp_snr;
            }

         }
         //SMS00914848 DS_PERF_ALL_PllSnrThresshold (END)

        //SMS01501974 SMS01501977 SMS01397264 SMS01276795 Enhancment_DS_ALL_ALL_FT_Reboot_Criteria (Start)
        //Feature_ALL_ALL_FT_ReInit_Triggers(Start)
      if ((gs_crc_cnt > 0) || ((gs_los_cnt + gs_sef_cnt + gs_lpr_detect) > 0))
      {

            guc_consecutive_err_sec_cnt++;
      }
      else
      {
            guc_consecutive_err_sec_cnt=0;
      }
      if ((gs_norm_crc_1sec >= 0x1200) || ((gs_los_cnt + gs_sef_cnt + gs_lpr_detect) > 0))
      {

            guc_consecutive_sev_err_sec_cnt++;
      }
      else
      {
            guc_consecutive_sev_err_sec_cnt=0;
      }

      //Feature_ALL_ALL_FT_ReInit_Triggers(End)
        //SMS01501974 SMS01501977 SMS01397264 SMS01276795 Enhancment_DS_ALL_ALL_FT_Reboot_Criteria (End)
// XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead (START)
#ifdef HERC_API
#ifdef HDLC_POLL_TEST
        // An uc_PollTimer = 1 configures a polling cycle of 5s/10s for prio1/prio2.
        uint8 uc_PollTimer = (uint8)(gt_HercADSL_OPTNMap_EocPollControl.us_EocPollControl >> 8);
        if (uc_PollTimer == 0)
        {
            uc_PollTimer = 1;  // MinValue
        }
        else if (uc_PollTimer > 10)
        {
            uc_PollTimer = 10; // MaxValue
        }
        uc_PollTimer *= 5;

        if (gt_HercADSL_OPTNMap_EocPollControl.us_EocPollControl & OPTN_25_HERC_EocPollPrio1_ENABLE)
        {
            if (guc_PollPrior1Messages == uc_PollTimer)
            {
                gft_PollHDLC1 = TRUE;
                guc_PollPrior1Messages = 0;
            }
        }
        if (gt_HercADSL_OPTNMap_EocPollControl.us_EocPollControl & OPTN_25_HERC_EocPollPrio2_ENABLE)
        {
            uc_PollTimer <<= 1;
            if (guc_PollPrior2Messages == uc_PollTimer)
            {
                gft_PollHDLC2 = TRUE;
                guc_PollPrior2Messages = 0;
            }
        }
#endif
#endif
// XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead (END)

        //check whether:   1. L0 state
        //              2. We support AutoSRA
        //              3. CO gives us good condition to do AutoSRA;
        //              4. We have new SNR Update
      //XDSLRTFW-1313 XDSLRTFW-1208 : BugFix_DS_BisPlus_All_TR105SRAChanges (start)
        if((gt_RxOLRPMVars.uc_rxOLRPMState == L0_STEADY_STATE)
                && ((OPTNArray[OPTN_OLRControl_DS] & OPTN_EnableAutoSRA)!= 0)
                && (gft_AutoSRA_ErrorCondition == FALSE) && (gft_ShowtimeSnrUpdateFlag == TRUE))
        {

            // This is triggered every 1s interval in showtime if this condition is met.
            s_SRA_step = (int16) TESTArray[TEST_OLR_SRA_DeltaLpchange];//initialize to default 1dB
            l_temp = (int32) gt_RCMsgs1_bis.us_TARSNRMds << 8;
            s_TARSNRMds = (int16) (l_temp / 10) ;   // 8.8 format
            if ( gt_INFX_CMV.us_SRA_IOP_Bits & CMV_SRA_ACHIEVE_TARGETMARGIN)
            {
               s_USTTARSNRMds = s_TARSNRMds + 0x0040; // TargetMargin+0.25 dB (8.8 format)
               s_DSTTARSNRMds = s_TARSNRMds - 0x0040; // TargetMargin-0.25 dB (8.8 format)
            }
            else
            {
               // MIN((RA-DSNRM + 1.5dB(Took from TR105) ), TargetMargin-1.5dB)
               // added 0.5dB tweak MIN((RA-DSNRM + 2.0dB, TargetMargin-1.5dB)
               s_DSTTARSNRMds = MAX((gt_RCMsgs1_bis.us_RA_DSNRMds + 0x0200 ),(s_TARSNRMds-0x0180));
               //MIN(RA-USNRM - 1.5dB (Took from TR105), TargetMargin+0.5)
               s_USTTARSNRMds = MIN((gt_RCMsgs1_bis.us_RA_USNRMds - 0x0100), (s_TARSNRMds+0x0080));
            }

            //SMS01470581 IOP_A_BIS_DMT_CNXT_PLDT_LinkDrop (START)
            //Upshift SRA is only triggered when average maegin is above the SRA upshift margin and
            //the data rate is below the max data rate capped by CO.
         if( (gs_RxAvMargin > gt_RCMsgs1_bis.us_RA_USNRMds)
             &&(gla_DSDataRate[0] < ((gs_maxdatarate-8)*4000))
         )
               ft_UpShift = TRUE;
            else
               ft_UpShift = FALSE;

            ft_DnShift = (gs_RxAvMargin < gt_RCMsgs1_bis.us_RA_DSNRMds) ? TRUE : FALSE;
            if( ft_DnShift == TRUE)
            {
                gft_enable_new_adaptation = TRUE;
                OPTNArray[OPTN_AlgControl3] |= CMV_TO_ENABLE_TEMPCHAMBER_PLL_THRESSHOLD;
            }

            if(gft_SRAUpShift_process ||gft_SRADnShift_process ||gft_UpShift_DSProcess||gft_DnShift_USProcess)
            {
               if(gus_DSorUS_Process_Interval_Timer > 0)
               {
                  gus_DSorUS_Process_Interval_Timer--;
                  gus_DSorUS_Process_Dbg = gus_DSorUS_Process_Interval_Timer;
               }
               if(gus_DSorUS_Process_Interval_Timer == 0)
               {
                  gft_SRAUpShift_process = 0;
                  gft_SRADnShift_process = 0;
                  gft_UpShift_DSProcess = 0;
                  gft_DnShift_USProcess = 0;
               }
            }
            else
            {
               //gus_DSorUS_Process_Dbg = gus_DSorUS_Process_Interval_Timer;
               gus_DSorUS_Process_Interval_Timer = 0;
            }
            //XDSLRTFW-945 Bug_DS_BisPlus_SRACappedprofile_Lindrops (Start)
            //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved: (START)
            //s_SRA_step = (int16) TESTArray[TEST_OLR_SRA_DeltaLpchange];//initialize to default 1dB
            if(gft_SRAUpShift_process || gft_UpShift_DSProcess)
            {

               //SMS00966303 SMS00954738 Feature_AB_DS_BISPlus_ALL_IncreaseAccuracySRAStep (START_END)
               //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved: (START)
               //if(gs_RxAvMargin > (s_TARSNRMds+0x20)) // bring within 0.25 dB accuracy 0x20(0.125dB s_TARSNRMds bias) + 0x20 (this one)
               if(gs_RxAvMargin > s_USTTARSNRMds)
                  ft_UpShift = TRUE;
               //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved: (END)
               else
               {
                  ft_UpShift = FALSE;
                  gft_SRAUpShift_process = FALSE;
                  gft_UpShift_DSProcess  = FALSE;
                  // SMS01221899 Feature_DS_All_All_EnableOneStepSRA (START)
                  if(gs_RxAvMargin < s_DSTTARSNRMds)
                  {
                        //gs_RxDesiredMargin  // if new average margin is less than target margin
                        //gft_SRADnShift_process = TRUE; // To bring back overshoot from UpShift
                        // SMS01221899 Feature_DS_All_All_EnableOneStepSRA (END)
                        gft_DnShift_USProcess = TRUE;
                  }
               }

               //XDSLRTFW-945 Bug_DS_BisPlus_SRACappedprofile_Lindrops (Start)
            }

            if(gft_SRADnShift_process || gft_DnShift_USProcess)
            {
               if(gs_RxAvMargin < s_DSTTARSNRMds) //(gs_RxDesiredMargin)) 0x0020 correspond to factor added before line :433
                  ft_DnShift = TRUE;
               else
               {
                  ft_DnShift = FALSE;
                  gft_SRADnShift_process = FALSE;
                  gft_DnShift_USProcess  = FALSE;
                  if(gs_RxAvMargin > s_USTTARSNRMds)//if new average margin  is greater than 'target margin + 0.25dB
                  {
                     gft_UpShift_DSProcess = TRUE;
                  }
               }
            }
            //SMS00966298 SMS00951973 IOP_DS_BISPlus_ALL_SRATargetMarginFix (END)


            // Implementation of the settling time.
            if(gft_Auto_SRA_Completed == TRUE)
            {
                if(gus_ra_Interval_Timer == 0)
                {
                    gft_Auto_SRA_Completed = FALSE;
                    gft_Poll_SRACond = FALSE;
                }
                else
                gus_ra_Interval_Timer--;
            }
            else
            {
                if(ft_UpShift)
                {
                    //Intialize the timer with Utime or Dtime and set the PollSRA condition flag ==1.
                    if (gft_Poll_SRACond == FALSE)
                    {
                        gft_UpShiftFlag = TRUE;
                        gus_ra_Interval_Timer  = gt_RCMsgs1_bis.us_RA_UTIMEds;
                     if (gft_UpShift_DSProcess || gft_SRAUpShift_process )
                        gus_ra_Interval_Timer = 2;//TESTArray[TEST_OLR_SRA_SettlingTime];
                        gft_Poll_SRACond = TRUE;
                    }
                }
                else
                // clear Upshift block bit
                STATArray[STAT_Misc] &= ~STAT_DSSRA_UPSHIFT_BLOCKED;

                if(ft_DnShift)
                {
                    //Intialize the timer with Utime or Dtime and set the PollSRA condition flag ==1.
                    if (gft_Poll_SRACond == FALSE)
                    {
                        gft_DownShiftFlag = TRUE;
                        gus_ra_Interval_Timer  = gt_RCMsgs1_bis.us_RA_DTIMEds;
                     if (gft_DnShift_USProcess || gft_SRADnShift_process )
                        gus_ra_Interval_Timer = 2; //TESTArray[TEST_OLR_SRA_SettlingTime];
                        gft_Poll_SRACond = TRUE;
                    }
                }
                else
                // clear downshift block bit
                STATArray[STAT_Misc] &= ~STAT_DSSRA_DNSHIFT_BLOCKED;

                if((gft_Poll_SRACond == TRUE))
                {
                    //If condition is violated within this timer, timer and flag shall be reset.
                    if((!ft_DnShift && gft_DownShiftFlag)
                            || (!ft_UpShift && gft_UpShiftFlag))
                    {
                        gus_ra_Interval_Timer = 0;
                        gft_Poll_SRACond = FALSE;
                        gft_UpShiftFlag = FALSE;
                        gft_DownShiftFlag = FALSE;
                    }
                    if(gus_ra_Interval_Timer > 0)
                    {
                        gus_ra_Interval_Timer--;
                        if(gus_ra_Interval_Timer == 0)
                        {

                           if (ft_UpShift)
                           {
                              s_SRA_step = ((gs_RxAvMargin-s_USTTARSNRMds)<((int16) TESTArray[TEST_OLR_SRA_DeltaLpchange]))?
                                    (gs_RxAvMargin-s_USTTARSNRMds): ((int16) TESTArray[TEST_OLR_SRA_DeltaLpchange]);
                              MULS16(l_temp, s_SRA_step, (gus_ToneNumNon15Bits/3));
                              l_temp = l_temp>>8;
                              int16 s_OLR_LMaxNoBpn = gt_DerivedFrameProperties_DS.PropPerLp[LP0_DATA_PATH].s_OLR_LMaxNoBpn;
                              if (gt_rx_config.s_Lp[LP0_DATA_PATH] + l_temp > s_OLR_LMaxNoBpn)
                                 l_temp = s_OLR_LMaxNoBpn - gt_rx_config.s_Lp[LP0_DATA_PATH];
                              if (l_temp < 0)
                                 l_temp = 0;
                              TESTArray[TEST_OLR_Lp0Delta] = (int16) l_temp;  // Configuring the CMV's
                                                                              // for SRA.
                              gft_UpShiftFlag = FALSE;
                              //SMS00900615 IOP_DS_BISPLus_ALL_AllowUpshiftSRA (Start)
                              // Set the flag here to allow for the upshit SRA
                              gft_AllowUpshiftSRA = TRUE;
                              //SMS00900615 IOP_DS_BISPLus_ALL_AllowUpshiftSRA (End)
                              if ( gt_INFX_CMV.us_SRA_IOP_Bits & CMV_SRA_ACHIEVE_TARGETMARGIN)
                              {
                                 gft_SRAUpShift_process = TRUE;
                                 if ( gus_DSorUS_Process_Interval_Timer == 0)
                                    gus_DSorUS_Process_Interval_Timer = 30;
                              }
                           }
                           if (ft_DnShift)
                           {
                              // For FLEXIT2 TR-105 problem
                              // FLEXIT stops if DnShift+UpShift is triggered during "gft_SRADnShift_process"
                              // So make sure only DnShifts will be allowed here.
#if 1
                              if ( gt_INFX_CMV.us_SRA_IOP_Bits & CMV_SRA_ACHIEVE_TARGETMARGIN)
                              {
                                //Removing more bits are resulting slighltly above (Targetmargin +0.25+delta)
                                // the requirement => results (one DownShift+upshift) during SRA DnShift process.
                                if((s_DSTTARSNRMds-gs_RxAvMargin)> 0x0600)
                                    s_DSTTARSNRMds = s_DSTTARSNRMds - 0x0100;

                              }
#endif
                              s_SRA_step = ((s_DSTTARSNRMds-gs_RxAvMargin)<((int16) TESTArray[TEST_OLR_SRA_DeltaLpchange]))?
                                    (s_DSTTARSNRMds-gs_RxAvMargin):((int16) TESTArray[TEST_OLR_SRA_DeltaLpchange]);
                                  MULS16(l_temp, s_SRA_step, (gus_ncloaded/3));
                              l_temp = l_temp>>8;
                              //XDSLRTFW-721 ADSLRTFW-1688 Enhance_DS_BisPlus_ALL_OptimizedSRACode (START)
                              int16 s_OLR_LMinNoBpn = gt_DerivedFrameProperties_DS.PropPerLp[LP0_DATA_PATH].s_OLR_LMinNoBpn;
                              if (gt_rx_config.s_Lp[LP0_DATA_PATH] - l_temp < s_OLR_LMinNoBpn)
                              l_temp =  gt_rx_config.s_Lp[LP0_DATA_PATH] - s_OLR_LMinNoBpn;
                              //XDSLRTFW-721 Enhance_DS_BisPlus_ALL_OptimizedSRACode (END)

                              TESTArray[TEST_OLR_Lp0Delta] = (int16) (-l_temp);
                              gft_DownShiftFlag = FALSE;
                              if ( gt_INFX_CMV.us_SRA_IOP_Bits & CMV_SRA_ACHIEVE_TARGETMARGIN)
                              {
                                 gft_SRADnShift_process = TRUE;
                                 if ( gus_DSorUS_Process_Interval_Timer == 0)
                                    gus_DSorUS_Process_Interval_Timer = 30;
                              }
                           }
                           TESTArray[TEST_ReconfigControl] |= TEST_TestOLR;
                           gft_Poll_SRACond = FALSE;
                        }
                    }
                }
            }
        }
    }
   //XDSLRTFW-1313 XDSLRTFW-1208 : BugFix_DS_BisPlus_All_TR105SRAChanges (end)
    // implement a 10s timer for BIS ovhd update test paramter
    if (gft_UpdateTestPar || (TESTArray[TEST_Control2] & TEST_ForceTestParamUpdates))
    {
        gus_10sec_Timer = (uint16)(FRAME_COUNT_FOR_ONE_SEC*10+1);

        // We should turn off the UpdateTestPar here so that it can be
        // turned on when we get another Update msg during 10s period.
        // In this case, we will reset gs_10s_timer to be maximum value
        // and restart another 10s.
        gft_UpdateTestPar = FALSE;

      //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START)
      if (gt_DS_RefVirtNoiseLevel_ADSL2.us_NumberOfTones == 0)
      {  //original code
         gpsa_RxSnrBuf_ovhd = gsa_RxShowtimeSnrBuf;
      }
      else
      {  //Modified during integration of Downstream virtual noise feature
         gpsa_RxSnrBuf_ovhd = gpsa_RxSnrBufWoVN;
      }
      //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (END)

    }

    if (gus_10sec_Timer > 0)
    gus_10sec_Timer--;

#ifndef HERCULES_ADSL_CPE
    /* =======================================================================   */
    /* Process framing bytes from data pump runs in this PMD frame            */
    /* =======================================================================   */
    ProcessFramingBytes();
#endif

    /* ============================================================================= */
    /*  Note: All EC, TDQ, FFT and FDQ operations are done in RunModem() and GetRxTones() */
    /* ============================================================================= */
    if (gft_ShowTimeFirstPassRx==0)
    {
        gft_ShowTimeFirstPassRx=1;
        // XDSLRTFW-1481 (Start)
        gt_DS_StPilotDescriptorTable.s_NumPilotTones = 1;
        gt_DS_StPilotDescriptorTable.s_PilotTones = gs_PilotToneIdx;
        // XDSLRTFW-1481 (End)

        // IOP_DS_DMT_ALL_EnableDsBitSwap (Start)
#ifndef ISDN   // Only for Anx-A
        if (!(OPTNArray[OPTN_AlgControl] & OPTN_DSAutoBitSwapDisable))
        {
            // Provide 50 superframes delay for the first bitswap &
            // provide 20 superframes dealy between the bitswap requests.
            // Valid for all DSLAMs in all modes
            guc_TimeWindow_DS_BitSwaps = FIRST_BITSWAP_SFRAMES_DELAY;
            OPTNArray[OPTN_AlgControl] |= OPTN_DSAutoBitSwapDisable;
        }
#endif // ifndef ISDN
        // IOP_DS_DMT_ALL_EnableDsBitSwap (End)

        // Successful full initialization. If far end supports short initialization
        // next time on we can try linking in short initialization mode. However, check
        // if CPE supports short initialization before we commit
        if (gft_farEndSISupport &&
                (OPTNArray[OPTN_StateMachineCtrl] & OPTN_EnableShortInit))
        {
            gl_SelectedMode |= LINK_SHORTINIT;
        }
    }

    // Once the codeswap is done, we restore the enable states back.
    if (gft_RestoreShowtimeBGState == TRUE)
    {
        //we should immediately set Restore flag to a new state; otherwise it will keep setting the
        //latched state to the global variables
        gft_RestoreShowtimeBGState = START_RX;
#ifdef TARGET_HW
        /* Enable DEC adaptation if not disabled. */
        //     if ((OPTNArray[OPTN_AlgControl] & OPTN_DECAdaptDisable) == 0)

        //Disable DEC Adaption
        //gft_DECAdaptDisable< = 1;
        //guc_DECAdaptationState = DEC_ADAPTATION_DISABLED;

        if (gft_DECAdaptDisable ==0)
        {
            /* Enable DEC adaptation */
            guc_DECAdaptationState = DEC_ADAPTATION_INITIALIZE;
        }

#ifdef PCM_INTERFACE_SUPPORT
        if (CNTLArray[CNTL_ME_HDLC] & CNTL_ME_Start_PCM)
        {
            // Start PCM state m/c state
            if (guc_PCMState == 0)
            guc_PCMState = 1;
        }
#endif   //#ifdef PCM_INTERFACE_SUPPORT

#endif  //#ifdef TARGET_HW

#ifndef TARGET_HW
        if (gft_DECAdaptDisable ==0)
        /* Enable DEC adaptation */
        guc_DECAdaptationState = DEC_ADAPTATION_INITIALIZE;
#endif

        //enable showtime processing state machine
        OLRPM_RxPostProcessing(0);

        gt_RxOLRPMVars.uc_rxOLRPMState = L0_STEADY_STATE;
        gt_TxOLRVars.uc_txOLRState = L0_STEADY_STATE;

        STATArray[STAT_Misc] |= STAT_AllCodeSwapsDone;
        // PERF_DS_DMT/T1413_ALL_ReduceBmaxInRMsgRA_ToGetLessCratesRAOptions (Start)
#ifndef ISDN   // Only for Anx-A
        // Though this bit is required for ADSL1 Mode, it is necessary to clear it here, in case if
        // it was set in ADSL1 Mode.
        gus_Persistent_UserDefBits &= (~REDUCE_BMAX_IN_RMSGRA_FOR_ADSL1);
#endif // ifndef ISDN
        // PERF_DS_DMT/T1413_ALL_ReduceBmaxInRMsgRA_ToGetLessCratesRAOptions (End)
//ADSLRTFW-1412_XDSLRTFW-1591_IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop (START)
#ifndef ISDN   // Only for Annex-A
   gft_workaround_ECI_PLSE = FALSE;
#endif // ifndef ISDN
//ADSLRTFW-1412_XDSLRTFW-1591_IOP_A_DS_ADSL1_ECI_PLSE_LinkDrop (END)
    }

#ifdef BIS_CODESWAP
    // Before we finish swap in SHOWRX page, no task would be started
    // it could cause problem if this showtime codeswap page take too long and no functionalities will
    // be tested. But let's put the code as it is now and see.
    if (gft_RestoreShowtimeBGState != START_RX)
    return;

#endif //BIS_CODESWAP


     //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start)
     /* Detect LOS */
     if (guc_LOSDetectState == LOS_DETECT_ENABLED)
   {
      detect_LOS();
   }
     //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (End)


    //==============================
    // OLR/PM NTC processing
    //==============================
    /* If we need to load b/g/trb tables for OLR/PM, do so in sync symbol TC task */
    if(gs_RxPMDFrameCnt == RX_SYMBOLS_PER_SFRAME-1)
    {
        /* load b/g/trb tables for OLR and L2 Entry */
        if( gt_RxOLRPMVars.uc_rxOLRPMState == OLR_LOAD_TABLES ||
                gt_RxOLRPMVars.uc_rxOLRPMState == L2_LOAD_TABLES )
        {
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,OLRPM_RxLoadTables);
        }
        /* read b/g/trb tables for L2 Exit and aborted OLR */
        if( gt_RxOLRPMVars.uc_rxOLRPMState == L2_READ_TABLES ||
                gt_RxOLRPMVars.uc_rxOLRPMState == OLR_READ_TABLES)
        {
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,OLRPM_RxReadTables);
        }
    }
    /* bi/gi/Lp/Bpn reconfiguration for OLR, L0 to L2, L2 Trim(for state updates only) */
    else if(gt_RxOLRPMVars.uc_rxOLRPMState == OLR_RECONFIGURE ||
            gt_RxOLRPMVars.uc_rxOLRPMState == L2_RECONFIGURE)
    {
        if(gs_RxPMDFrameCnt == RX_SYMBOLS_PER_SFRAME) /* (OLRPM_DS_ReconfigPMDSymbolCount - 2) % 68 */
        {
            /* Time to reconfigure RCD related DSP variables */
            OLRPM_RxInit((int16)(gt_RxOLRPMVars.s_rxOLRPMEvent & RECONFIG_Lp));
            /* Reconfig RCD at next qam done interrupt, and will take effect two frames from now */
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,OLRPM_RxIridiaReconfigDataPumpSetup);

            // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
            /* Disable DD Processing for the duration of this instantaneous MIPs peak */
            if (gs_DD_NumFramesProcDisable<2) gs_DD_NumFramesProcDisable = 2;
            // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)
        }
        else if(gs_RxPMDFrameCnt == OLRPM_DS_ReconfigPMDSymbolCount-1)
        {
            /* Time to reconfigure Bpn related DSP variables and HW cores */
            OLRPM_RxInit((int16)(gt_RxOLRPMVars.s_rxOLRPMEvent & RECONFIG_Bpn));
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,OLRPM_RxAZIReconfigDataPumpSetup);
            /* Disable DD Processing for the duration of this instantaneous MIPs peak */
            if (gs_DD_NumFramesProcDisable<2) gs_DD_NumFramesProcDisable = 2;
        }
    }
    // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
    else if(gt_RxOLRPMVars.uc_rxOLRPMState == L2_SETUP_REVSEQ_DETECTOR)
    {
       // Call ReverbSegueDetectorSetup() in 'Data symbol 1' (during L0 to L2 transition) to avoid Mips Peaking
       AddFunctionToFifo(gp_RxLoadingFunctionFifo,ReverbSegueDetectorSetup);
       //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
       //XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (START)
       #ifdef HW_SNR_FDQ
          gt_RxOLRPMVars.uc_rxOLRPMState = L2_SETUP_RTV0_STATE;
       #else
          gt_RxOLRPMVars.uc_rxOLRPMState = L2_STEADY_STATE;
       #endif
       //XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (END)
       //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)
    }
    //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
    //XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (START)
    #ifdef HW_SNR_FDQ
    else if(gt_RxOLRPMVars.uc_rxOLRPMState == L2_SETUP_RTV0_STATE)
    {
      AddFunctionToFifo(gp_RxLoadingFunctionFifo,ConfigRTVBuf0_RCD_OUT);
      gt_RxOLRPMVars.uc_rxOLRPMState = L2_SETUP_RTV1_STATE;
    }
    else if(gt_RxOLRPMVars.uc_rxOLRPMState == L2_SETUP_RTV1_STATE)
    {
      AddFunctionToFifo(gp_RxLoadingFunctionFifo,ConfigRTVBuf1_SFDQ_OUT);
      gt_RxOLRPMVars.uc_rxOLRPMState = L2_WAIT1_STATE;
    }
    //Start the re-calculation for FDQ coefficients of all tones in L2 exit to avoid MIPs peaking.
    else if(gt_RxOLRPMVars.uc_rxOLRPMState == L2_WAIT1_STATE)
    {
      AddFunctionToBkgdFifo((PtrToBkgdFunc)compute_fdqcoef_for_l2exit);

      if (gs_RxLastChannel > MAX_NUM_CHNLS_FOR_FDQ_COMPUTATION)
         AddFunctionToBkgdFifo((PtrToBkgdFunc)compute_fdqcoef_for_l2exit);
      gt_RxOLRPMVars.uc_rxOLRPMState = L2_WAIT2_STATE;
    }
    else if(gt_RxOLRPMVars.uc_rxOLRPMState == L2_WAIT2_STATE)
    {
      gt_RxOLRPMVars.uc_rxOLRPMState = L2_STEADY_STATE;
    }
    #endif
    //XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (END)
    //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)
    // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)

    /* Activate Rx data capture for DEC adaptation */
   // XDSLRTFW-576: IOP_DS_BisPlus_ALL_LinkDropADMAError (start_end)
    if ((guc_DECAdaptationState != DEC_ADAPTATION_DISABLED)&&(gft_Dec_Init == TRUE) )
    {
#ifdef ADSL_62
       // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
       // We are seeing burst CRC errors when DEC adaptation is done in L2 state. For now, DEC adaptation
       // is limited to L0 state. Remove this check once the issue is fixed.
       if (gt_RxOLRPMVars.uc_rxOLRPMState == L0_STEADY_STATE)
       // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)
       {

          // The DEC Capture Enable should be set in advance of setting the Sync Frame bit in the V_RX_EXTEN register
          //XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (Start)
          if ((gs_RxPMDFrameCnt == RX_SYMBOLS_PER_SFRAME - DECADAPT_PRESTART-5) && (guc_DECCoefDnloadFlag == WAIT)
               && (guc_RxDecCaptureState == 0) && (guc_DECRxCaptureFlag == START))
          {
              AddFunctionToFifo(gp_RxLoadingFunctionFifo,ActivateDECAdaptationRxCapture);
              guc_RxDecCaptureState = 1;
          }
          else if ((gs_RxPMDFrameCnt == RX_SYMBOLS_PER_SFRAME - DECADAPT_PRESTART) && (guc_DECCoefDnloadFlag == WAIT)
               && (guc_RxDecCaptureState == 1))
          {
              AddFunctionToFifo(gp_RxLoadingFunctionFifo,SetRxSyncFrame);
              guc_RxDecCaptureState = 2;
          }
          else if ((gs_RxPMDFrameCnt == RX_SYMBOLS_PER_SFRAME - DECADAPT_PRESTART + 1) && (guc_DECCoefDnloadFlag == WAIT)
               && (guc_RxDecCaptureState == 2))
          {
              AddFunctionToFifo(gp_RxLoadingFunctionFifo,SupressDECAdaptationRxCapture);
              guc_RxDecCaptureState = 3;
          }
          else if ((gs_RxPMDFrameCnt == RX_SYMBOLS_PER_SFRAME-1) &&(guc_DECCoefDnloadFlag == WAIT) &&(gs_TxState == R_SHOWTIME_TX)
               && (guc_RxDecCaptureState == 3))
          {
           /* Copy captured Rx as well as Tx data for DEC adaptation from the engine to the task layer. */
              AddFunctionToFifo(gp_RxLoadingFunctionFifo,GetDECAdaptationRxData);
          }
          //XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (End)

       }
#else
        if ((gs_RxPMDFrameCnt == RX_SYMBOLS_PER_SFRAME - DECADAPT_PRESTART) && (guc_DECRxCaptureFlag == START))
        {
            guc_DECRxCaptureFlag = ACTIVE;
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,ActivateDECAdaptationRxCapture);

        }
        else if (gs_RxPMDFrameCnt == RX_SYMBOLS_PER_SFRAME - DECADAPT_PRESTART + 1)
        {
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,SupressDECAdaptationRxCapture);
        }
#endif //#ifdef ADSL_62
    }

    /* ================================================================    */
    /*  when gs_RxPMDFrameCnt, captured in the previous TC task,     */
    /*   indicates a Sync Frame, then call the SyncSymbolHandler routine.  */
    /* ================================================================    */
    if(gs_RxPMDFrameCnt == RX_SYMBOLS_PER_SFRAME)
    {
        // IOP_DS_DMT_ALL_EnableDsBitSwap (Start)
#ifndef ISDN   // Only for Anx-A
        if (OPTNArray[OPTN_AlgControl] & OPTN_DSAutoBitSwapDisable)
        {
            Check_DsBitSwapTimeWindow();
        }
#endif // ifndef ISDN
        // IOP_DS_DMT_ALL_EnableDsBitSwap (End)
        /* ========================================================================= */
        /* Process synchronization symbol */
        /* ========================================================================= */
        SynchSymbolHandler(gsa_RxToneBuf);

        /* Update super frame count */
        gl_rx_sframe_count++;

        /* =====================================*/
        /* Increment the timer every superframe */
        /* =====================================*/

        for (s_priority = MAX_OVHD_PRIORITY-1; s_priority >= 0; s_priority--)
        {
            if(gta_TxHdlcControlInfo[s_priority].ft_ack_expected == TRUE)
            gta_TxHdlcControlInfo[s_priority].us_ovhd_timer++;
        }
        /* Process the IBs received for the last CRC superframe */
        RxIbProcessor_bis();

#ifdef DO_PLAM
        /* Rx PLAM function */
        RxPlamProcessor_bis();
#endif /* DO_PLAM */
    }
    /* =======================================================================   */
    /*   Else indicates a Data Frame                                    */
    /* =======================================================================   */
    else
    {
        /* =======================================================================  */
        /*  do snr and fdq updates                                      */
        /* =======================================================================  */
        DataSymbolHandler();

        /* =======================================================================  */
        /*  do BERT processing if BERT control enabled                        */
        /* =======================================================================  */
        if ((TESTArray[TEST_Control] & TEST_BertControl) != 0)
        {
#ifndef DISABLE_BERT
            RxPNSequence();
#endif
        }
    }
    // Feature_ALL_ALL_ALL_PrevExceptionsCMV (Start)
    // Once the modem is in Showtime, these vairables need to be
    // initialized again, since the last initialization
    gus_ExceptionCode_Persis = gus_ExceptionCode;
    gus_ExceptionState_Persis = gus_ExceptionState;
    // Feature_ALL_ALL_ALL_PrevExceptionsCMV (End)
    return;
}

#undef START_RX
#ifdef REIN_DBG_CODE
FlagT CW_Status(uint8 InData, uint8 uc_shift)
{
    int16 i;
   int16 uc_Cwcount;
   uint8 uc_shift_ref = 0x1;
   for (i=0;i<uc_shift;i++)
   {
#if 0
      if(InData & 0x1)
      {
         uc_Cwcount++;
      }
      InData >>= 1;
#else
      if (InData & uc_shift_ref)
         uc_Cwcount++;
      uc_shift_ref = uc_shift_ref << 1;
#endif
   }
   return (uc_Cwcount);
}
#endif
