/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             showtime_rx_tc_bis.c
 * DESCRIPTION:      Functions that implement the bis showtime RX time critical tasks.
 *
 **********************************************************************/
// **********************************************************************************************//
// showtime_rx_tc_bis.c
//
// History
//
// 10/01/2010 Abraham Binu : Addition of the transition to state 8(TC Sync) from state 7(No TC Sync)
//                           based on the TC Status indicated in the PPE DREG register DREG_AR_STATx,
//                           bit 1, which has inverted logic, i.e, 0 - TC Sync, 1 - No TC Sync.
//       Grep for SMS01357654
//
// 09/08/2011 Vinjam/SriRam: Integrated code which finds "OOS" anamoly by reading the PPE register.
//                           Retained the inverted logic for "OOS" anamoly which later used for
//                           finding the "OOS" defect.
//                           Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//                           Grep for Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
//
//12/01/2012: Balabath: Added CMV to trigger LPR in idication.DSL 5 0 1 will trigger this.By default
//                      this bit is set to zero. if LPR is triggered by DSL 5 0 don't set "gs_lpr_detect"
//                      which will increment the error seconds.
//                Grep for XDSLRTFW-201 Feature_US_ALL_ALL_LPR
// 13/03/2013 Raghu M        Typo error cused the PMD counter to increment twice during L2 exit. This fixed.
//                           Grep Enhancement_ALL_BisPLus_ALL_L2.
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
// 14/06/2012 Kannan:
//          1. FIFO3 may be used to capture the RxData at the TC Layer Input
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 19/06/2012 Ram: Merged "ReTx" related MGMT counters and Test Params code from
//                 ARX ADSL code base (Grep: FEATURE_DS_BisPlus_ALL_ReTx_MGMTCntrs_TestParams)
//                 Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 18/02/2013 Vinjam: Report downstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 1 [14:15]" & "CMV_RATE 1 [16:17] respectively.
//            Also, Report upstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 0 [14:15]" & "CMV_RATE 0 [16:17] respectively.
//            Modified enable/disable of Erasuredecoder logic as per VRx Msg Spec through "CMV DSL 1 0"
//            Grep for XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec
//
// 22/03/2013 Ram: Fixes to avoid Mips peaking during L0 to L2 transition
//                 Grep for XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2
//
// 09/09/2014 ChihWen: HW acceleration for FDQ adaptation and SNR measurement.
//            Grep for XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ
//
// 09/09/2014 ChihWen: Avoid MIPs peaking in L2 entry and exit by moving calculation of FDQ coefficients to background tasks.
//            Grep for XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit
// 09/02/2018  Abu Rahman
//             XDSLRTFW-3708:Control of GPIO14 to indicate dying gasp for ADSL
//
//             In case of Dying Gasp set VRX518 GPIO pin 14 from high to low.
//             This feature is CMV controlled
//             CMV CNFG 58 Bit 8 (LSB = Bit0) = 1 Enable this feature
//             CMV CNFG 58 Bit 8 (LSB = Bit0) = 0 Disable this feature (default configuration)
//             Preferable configuration method for Enabling this feature: "dmms 3A48 0 1 0100 0100" at "wait for link activation" state
//
//             To control GPIO 14 first below mentioned registers need to be programmed
//             Register GPIO PAD PORTMUXC14(VRX518 address 0x24038) = 0
//             Register GPIO_FUNC DIRSET_0(VRX518 address 0x20048) bit14 value = 1
//             Register GPIO_FUNC OUTSET_0(VRX518 address 0x20040) bit14 value = 1
//
//             After detecting Dying Gasp
//             Register GPIO_FUNC OUTCLR_0(VRX518 address 0x20044) bit14 value = 1 will set
//             GPIO pin 14 voltage level low.
//             Check Jira for more information about register spec
//
//             Note: BAR registers can access only up to 64k from it's base address so that special care needed
//             to be taken while using BAR register to access data.
//
//             Grep pattern:  XDSLRTFW-3708
// **********************************************************************************************//

#include <stdio.h>
#include "common.h"
#include "gdata.h"
#include "xgdata.h"
#include "gdata_bis.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "tx_eoc.h"
#include "aoc.h"
#include "aoc_ini.h"
#include "pn_tab.h"
#include "states.h"
#include "mtkernel.h"
#include "enc_gain.h"
#include "dec_gain.h"
#include "tx_m3oh.h"
#include "rx_m3oh.h"
#include "rt_tones.h"
#include "rt_state.h"
#include "ib.h"
#include "tx_ib.h"
#include "rx_ib.h"
#include "synsymbl.h"
#include "tone_ord.h"
#include "bitload.h"
#include "fifo.h"
#include "cmv.h"
#include "mp.h"
#include "qos.h"
#include "rx_eoc.h"
#include "rx_eoc1.h"
#include "rx_aoc.h"
#include "dec_adap_Data.h"
#include "pll.h"
#include "bitswap.h"
#include "tx_aoc.h"
#include "rx_aoc.h"
#include "tx_plam.h"
#include "rx_plam.h"
#include "prf_man.h"
#include "bert.h"
#include "detect.h"
#include "tx_ovrhd_bis.h"
#include "rx_ovrhd_bis.h"
#include "showinit.h"
#include "showtime_bis.h"
#include "DSLEngin.h"
#include "trail.h"
#include "DSLEngin.h"
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start_End)
#include "memrymap.h"
#include "dsp_regs_62.h"
#include "codeswap.h"
#ifdef DEBUG_STREAMING
#include "DebugBuffer.h"
#endif

#if defined(HERCULES_ADSL_CPE) || defined(AMAZON_SE)
   #define TWO_FFT_BUFFERS       1
   #define  QAM_DISABLED_FRAME       RX_SYMBOLS_PER_SFRAME
   #define SYNC_LOGICAL_BUFFER      DD_FFTFDQ_LOGICAL_BUFFER
   #define  BEFORE_QAM_DISABLED_FRAME       (RX_SYMBOLS_PER_SFRAME-1)
#else
   #define QAM_DISABLED_FRAME 0
   #define SYNC_LOGICAL_BUFFER      DD_GSRCD_LOGICAL_BUFFER
   #define  BEFORE_QAM_DISABLED_FRAME       RX_SYMBOLS_PER_SFRAME
#endif

extern int8 gft_ResetTrelMetricHist;

//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
//XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (START)
//#ifdef HW_SNR_FDQ
//uint8 guc_LoadFdqCoef = 0;
//#define MAX_NUM_CHNLS_FOR_FDQ_COMPUTATION       (370)
//extern void ReadFDQ1(void);
//extern void ReadFDQ2(void);
//#endif
//XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (END)
//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)
extern void Calculate_DiscardFrame_Flag(void);
extern void DisableRxPms(void);
extern uint8 ModXIncrY(uint16 us_Input, uint16 us_Y, uint16 us_Modulo_X);
//==============================
// Showtime  Utilities
//==============================
/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void ModuloUpdateCount(int16 *ps_count, int16 s_Max_Count)
*
*   Description:
*     Modulo Updates the Count
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
void ModuloUpdateCount(int16 *ps_count, int16 s_Max_Count)
{
   /* update PMD frame counter. This counter goes from 0 to 68 */
   (*ps_count)++;
   if (*ps_count > s_Max_Count)
      *ps_count = 0;
}


//==============================
// Rx Utilities
//==============================
/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : isNextZARunRequired
 *
 *  Description: Checks for another DT-ZA Run
 *
 *  Prototype:
 *      int16 isNextZARunRequired(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *      NONE
 *
 *  Return:
 *      s_ZARunCnt   - No. of times to run zephyr
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
FlagT isNextZARunRequired(void)
{
   int i;
   FlagT ft_isZARunRequired = FALSE;

   gus_IrSizeRegValue = 0;
   gus_ZrLineRegMask &= ~0x0600; //Disable LPx
   gus_ACfgRegMask &= ~0x2800;

   for(i=0; i<gt_rx_config.s_Nlp; i++)
   {
#ifdef DANUBE

      if (gsa_NBytes_In_RateBuffer[i] >= gt_RxShowTimeVars.t_FrameParms[i].s_CodewordSize)
      {
         // gus_IrSizeRegValue |= (gusa_PreconfigIRSize[i] << (8*i));
         gsa_NBytes_In_RateBuffer[i] -= gt_RxShowTimeVars.t_FrameParms[i].s_CodewordSize;
#else
      /* is data transfer required -- if num of bits in rate buffer greater than transfer size */
      if (gsa_NBytes_In_RateBuffer[i] >= gusa_PreconfigIRSize[i])
      {
         gus_IrSizeRegValue |= (gusa_PreconfigIRSize[i] << (8*i));
         gsa_NBytes_In_RateBuffer[i] -= gusa_PreconfigIRSize[i];
#endif
         /* ZA run required -- interleave startup delay has elapsed */
         if (!gus_RxInterleaveStartupDelay[i])
         {
            gus_ZrLineRegMask |= ((1<<9) << i);
            gus_ACfgRegMask |= gusa_PreconfigACfg[i];
         }
         /* skip ZA run -- if interleave startup delay not yet elapsed */
         else
         {
            gus_RxInterleaveStartupDelay[i]--;
         }

         /* if next mux frame cnt = mux frames/codeword - 1 */

         if (gsa_RxMuxFrameCount[i] == (gt_rx_config.s_Mp[i]-1))
         {
#ifndef DANUBE
            gusa_PreconfigIRSize[i] = gsa_RxMuxFrameSize[i][1];
#endif
            gsa_RxMuxFrameCount[i] = 0;
         }
         else
         {
#ifndef DANUBE
            gusa_PreconfigIRSize[i] = gsa_RxMuxFrameSize[i][0];
#endif
            gsa_RxMuxFrameCount[i]++;
         }
         ft_isZARunRequired  = TRUE;
      }
   }

   return (ft_isZARunRequired);
}

//==============================
// Rx OLR/PM Utilities
//==============================

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void do_atm_processing(void)
*
*   Description:
*     Atm processing (gets atm status)
*     - read hec err and idle/non-idle cell cnts
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/

// XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start)
// Sriram : For PTM_PPE_Cntr_Engine (Start)
uint16 s_temp_SYNC_PTM =0xf;
uint8 guc_temp_tcsync_atm = 0xA;
uint8 guc_temp_tcsync_ptm = 0xE;
uint8 guc_temp_tcsync = 0x0;
uint16 us_PTM_Status;
// XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (End)

void do_atm_processing(void)
{
   int16 s_bc;
   uint16 us_ATM_Status;
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start_End)
   uint32 ula_data[NUM_READ_RX_PTM_REGS]; // Added for PTM PPE register support

   for(s_bc = 0; s_bc < gt_rx_config.s_Nbc; s_bc++)
   {
      /* Skip if not ATM mode for this bearer channel */
      if (guca_DS_TransferMode_bis[s_bc] != ATM)
         continue;

      /*=================================*/
      /* Get the cell delineation status */
      /*=================================*/

      us_ATM_Status = Get_ATM_Status(s_bc);
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start_End)
      //guc_temp_tcsync_atm = !((us_ATM_Status & 0x2)>>1);    //Sriram : For PTM_PPE_Cntr_Engine //OLD Implementation
      //XDSLRTFW-2050
      //Latest Spec for ATM PPE
      //Status Bit 1 = 0 No TC Sync
      //Status Bit 1 = 1 TC Sync
      //XDSLRTFW-2050 : Debug
      //if(gft_Introduce_TCNoSync) //snv
      //{
      //   us_ATM_Status = 0;
      //}
      //XDSLRTFW-2050 : Debug
      guc_temp_tcsync_atm = ((us_ATM_Status & 0x2)>>1);    //Sriram : For PTM_PPE_Cntr_Engine

      //bit1: ATM_SYNC (0 = cell delineation was loss during the current superframe)
      //bit0: ATM_ERR  (1 = an ATM HEC error occurred during the current superframe)
      //gt_tx_Anomaly.s_cd_flag[s_bc] = !((us_ATM_Status & 0x2)>>1); //OLD Implementation
      gt_tx_Anomaly.s_cd_flag[s_bc] = ((us_ATM_Status & 0x2)>>1);

        if(STATArray[STAT_MacroState] != STAT_FailState)
      {
         if (gt_tx_Anomaly.s_cd_flag[s_bc] == FALSE)
         { // SMS01357654 No TC Synch, Inverted logic, 1 - No TC Sync, 0 - TC Sync
            STATArray[STAT_MacroState] = STAT_ShowTimeState;
            // XDSLRTFW-3548 (Start)
            gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_ShowTimeState;
            gusa_HercADSL_MONIMap_Curr[0] = MONI_SHOWTIME_TC_NOSYNC;
            // XDSLRTFW-3548 (End)
            gt_tx_Anomaly.s_cd_flag[s_bc] = FALSE;
         }
         else
         { // TC Sync.
#ifdef TARGET_HW
            STATArray[STAT_MacroState] = STAT_ShowTimeTCSyncState;
            // XDSLRTFW-3548 (Start)
            gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_ShowTimeTCSyncState;
            gusa_HercADSL_MONIMap_Curr[0] = MONI_SHOWTIME_TC_SYNC;
            // XDSLRTFW-3548 (End)
            gt_tx_Anomaly.s_cd_flag[s_bc] = TRUE;
#endif
         } //SMS01357654 - End.
         }

      Update_Anamoly_bis(1); //1: stands for Near end Anomaly update

      //log ATM near end ocd, lcd and ncd total count
      if (gt_tx_Anomaly.uc_lcd_def[0] == PRESENT)
         gula_NE_lcd_cnt++;

      if (gt_tx_Anomaly.uc_ocd_anom[0] == PRESENT)
         gula_NE_ocd_cnt++;

      if (gt_tx_Anomaly.uc_ncd_anom[0] == PRESENT)
         gula_NE_ncd_cnt++;

      /*====================================================================*/
      /* Count Near End total cell count */
      /*====================================================================*/
      Get_ATM_Counters(s_bc);

      ResetARCellCnt(s_bc);
   }
   // XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start)
#ifdef PPE_ENGINE
   //Sriram: For the PTM PPE counter
   for(s_bc = 0; s_bc < gt_rx_config.s_Nbc; s_bc++)
   {
      if (guca_DS_TransferMode_bis[s_bc] != PTM)
         continue;
#if 1
      //Update_Anamoly_bis(1); //1: stands for Near end Anomaly update
      us_PTM_Status = Get_PTM_Status(s_bc);
//    gt_tx_Anomaly.s_cd_flag[s_bc] = !((us_PTM_Status & 0x2)>>1);
      guc_temp_tcsync_ptm = !((us_PTM_Status & 0x2)>>1);
      gt_tx_Anomaly.s_cd_flag[s_bc] = !((us_PTM_Status & 0x2)>>1);
        if(STATArray[STAT_MacroState] != STAT_FailState)
      {
         if (gt_tx_Anomaly.s_cd_flag[s_bc] == FALSE)
         { // SMS01357654 No TC Synch, Inverted logic, 1 - No TC Sync, 0 - TC Sync
            STATArray[STAT_MacroState] = STAT_ShowTimeState;//STAT_ShowTimeTCSyncState;//STAT_ShowTimeState;
            // XDSLRTFW-3548 (Start)
            gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_ShowTimeState;
            gusa_HercADSL_MONIMap_Curr[0] = MONI_SHOWTIME_TC_NOSYNC;
            // XDSLRTFW-3548 (End)
            guc_temp_tcsync = 7;
         }
         else
         { // TC Sync.
#ifdef TARGET_HW
            STATArray[STAT_MacroState] = STAT_ShowTimeTCSyncState;//;STAT_ShowTimeState;//STAT_ShowTimeTCSyncState;
            // XDSLRTFW-3548 (Start)
            gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_ShowTimeTCSyncState;
            gusa_HercADSL_MONIMap_Curr[0] = MONI_SHOWTIME_TC_SYNC;
            // XDSLRTFW-3548 (End)
            guc_temp_tcsync = 8;
#endif
         } //SMS01357654 - End.
         }
#endif

         //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start_End)
         //For converting anamoly to defect using UpdateFailureInfo( ), Anamoly must be set to "1"
        //Below line can be taken out by changing the above logic.
         gt_tx_Anomaly.s_cd_flag[s_bc] = ((us_PTM_Status & 0x2)>>1);

      Get_Rx_PTM_Counters(s_bc,ula_data);
      //ResetARCellCnt(s_bc); // Sriram : To check the if required for  PTM mode

      gul_CRC_P_cnt += ula_data[RX_CERRN_CNT];  //CRC_P
      gul_CVC_P_cnt += ula_data[RX_CVN_CNT];      //CVC_P
      gul_CRC_NP_cnt += ula_data[RX_CERRNP_CNT];  //CRC_NP
      gul_CVC_NP_cnt += ula_data[RX_CVNP_CNT];  //CVC_NP


#if 0
      if (ula_data[RX_PTM_STAT] & MASK_BIT1)
      {
         //Inverted logic, 1 - No TC Sync, 0 - TC Sync
         gt_tx_Anomaly.s_cd_flag[s_bc] = FALSE;
         STATArray[STAT_MacroState] = STAT_ShowTimeTCSyncState;
      }
      else
      {
         gt_tx_Anomaly.s_cd_flag[s_bc] = TRUE;
         STATArray[STAT_MacroState] = STAT_ShowTimeState;
      }
#endif

   }
   // XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (End)
#endif
}

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void do_sync_frame_processing_bis(void)
*
*   Description:
*     Data frame processing
*     - do atm processing
*     - Load Fdq
*     - GetRxTones
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
// XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (START)

void do_sync_frame_processing_bis(void)
{
#ifdef IFX_XTC
   if (gft_AlphaeusSel)
#endif
   do_atm_processing();
   //do_ptm_processing();


#ifndef TARGET_HW
   if (!gft_doDDSnrFdqUpdate)
   {
      /* Load/activate new FDQ coefficients if available.               */
      /* If this takes too long, it will need to be delayed or broken      */
      /* up over several sync frames.                             */

      /* load FDQ coefficient calculated by update algorithm      */
      if (guc_FdqAdaptationState == FDQ_ADAPTATION_LOAD_COEFFICIENTS) {
         LoadFDQ();
         /* Once all new FDQ coefficients are loaded, change state for FDQ adaptation. */
         guc_FdqAdaptationState = FDQ_ADAPTATION_COEFFICIENTS_LOADED;
      }

      /* load FDQ coefficient set manually   */
      if (guc_FdqAdaptationState == FDQ_MANUAL_LOAD_COEFFICIENTS) {
         LoadFDQ();
         /* Once all new FDQ coefficients are loaded, change state for FDQ adaptation. */
         guc_FdqAdaptationState = FDQ_MANUAL_COEFFICIENTS_LOADED;
      }
   }
#endif // #ifndef TARGET_HW


}
// XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (END)

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void do_data_frame_processing(void)
*
*   Description:
*     Data frame processing
*     - Compute ZARunCnt
*     - Run TCB Task (includes trigger of data pump)
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
void do_data_frame_processing(void)
{
   int16 s_Mips = ReadRxTimer();

   /* TC Task data collection for DD snr and fdq updates */
   if (gft_doDDSnrFdqUpdate)
   {
      /* read consdec output for qam frame counts (0,67) -- no DDHandler() on sync symbol */
#if defined(AMAZON_SE) //Constellation decisions
      //The new RTV contains Constellation decisions with different format(matching GS). Since there is no benefit
      //in precision in a constellation decision, we read this data from the FFT buffer instead of RTV.
      GetRxData(&gsa_DD_rxQAMOutput[0], 1, gs_DD_RxFirstChannel, (int16)(gs_DD_RxLastChannel-gs_DD_RxFirstChannel+1));
#else
      GetRxData(&gsa_DD_rxQAMOutput[0], DD_GSRCD_LOGICAL_BUFFER, gs_DD_RxFirstChannel, (int16)(gs_DD_RxLastChannel-gs_DD_RxFirstChannel+1));
#endif
   }


#ifndef HERCULES_ADSL_CPE
   /* get total # of bits in rx rate buffer for each latency path */
   for(i=0; i<gt_rx_config.s_Nlp; i++)
   {

      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start)
      // According to G.INP section 11"No defect,anomaly & failure are defined for
      // latency path carrying overhead channel". Hence routine
      // GetRSErrorCnt_BIS(latency_path) is not called for latency path 0,
      // which is the path for carrying overhead channel.
      /* Process FEC Counts in TCA instead of TCB to save Mips while sacrificing accuracy of
         Uncorrected RS Errors */
      if(((gt_ReTxConfigInfo.ft_ReTxOn == 1) && (i != 0))||(gt_ReTxConfigInfo.ft_ReTxOn == 0))
      {
         GetRSErrorCnt_BIS(i);
      }
      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (End)

#ifndef AMAZON_SE
#ifdef DANUBE
     if (gt_RxOLRPMVars.uc_l2ProcState != PM_L2_EXIT_SEQ_REVERB_DETECTED &&  gt_RxOLRPMVars.uc_l2ProcState != PM_L2_EXIT_SEQ_SEGUE_DETECTED)
      gsa_NBytes_In_RateBuffer[i] = CalcBitsInRxRateBuffer(i);
#endif
#else
      gsa_NBytes_In_RateBuffer[i] = CalcBitsInRxRateBuffer(i);
#endif

   }
#endif

   /* Start the Rx Data Pump to complete the Rx processing */
   RShowtimeRxTC_BIS_B();

   s_Mips = ReadRxTimer() - s_Mips;
   if (s_Mips > gs_dbgTCAMaxMips)
   {
      gs_dbgTCAMaxMips = s_Mips;
   }

}

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void RShowtimeRxFdqTC_BIS(void)
*
*   Description:
*
*  Time-critical task associated with Showtime Rx Sync Frames.
*  Also,
*     - Used to collect freq domain data (fdq o/p)
*     - Used to detect sync symbol phase inversion
*     - Used to perform l2 state processing
*       - Detect corrupted frames.
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
// XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (START)

//extern uint32 gu_L2SymbCount;
void RShowtimeRxFdqTC_BIS(void)
{
   FlagT ft_SkipPilotProcessing = FALSE;
//   int16 *gsa_RxToneBuf_tmp;

#ifdef PROFILE_TASKS //#ifdef out purely for Program memory reasons for now 3 Aug 2004
   LogMips(ST_RX_TC_FDQ, TC_NTC_START_FLAG);
#endif

//    gsa_RxToneBuf_tmp = gsa_RxToneBuf;
   /* update FDQ PMD frame counter. This counter goes from 0 to 68 */
   ModuloUpdateCount(&gs_RxPMDFrameCnt_FftFdqBufferSymbol, RX_SYMBOLS_PER_SFRAME);
   /* After being updated, the counter identifies the PMD that originated this interrupt */

   /* fdq done interrupt does not control state m/c-- except in the absence of QAM done interrupt */
   gt_TaskArray[RX_FDQ_DONE].NonTimeCriticalTask = NULL;

   //==============================
   // Book Keeping in absence of QAM interrupt
   //==============================

    if (gs_RxPMDFrameCnt_FftFdqBufferSymbol == QAM_DISABLED_FRAME) /* TRUE for sync frames and during L2 Exit Sequence */
   {
      /* state machine processing handled by FDQ done interrupt's TC task */
      /* If there are pending loading functions, then run them */
      ExecuteQueuedLoadingFunctions(gp_RxLoadingFunctionFifo);

      /* update QAM PMD frame counter. This counter goes from 0 to 68 */
      ModuloUpdateCount(&gs_RxPMDFrameCnt, RX_SYMBOLS_PER_SFRAME);

      /* fdq done interrupt controls state m/c-- assign NTC task to this interrupt */
      gt_TaskArray[RX_FDQ_DONE].NonTimeCriticalTask = RxForeGround;

      /* no harm in doing the below unconditionally */
      /* if this were a sync symbol -- re-enable GS-QAM block for subsequent frame */

      RxSyncFrameTearDown();  /* prepare for a oncoming data symbol */
    }
   else
   {
      /* if this were a L2 Exit Seq Detection --
         Re-enable QAM interrupt processing for subsequent frames */

      // This function is not called in sync symbol becuase QT is disabled.
      // Default use new algorithm to decide on discard frame.
      // If the new algorithm is dis-abled then L2 will not work
      if ((gt_INFX_CMV.us_OperatorSpBits6 & CMV_TO_TOGGLE_NewAndOldDiscardFrameAlgo))
         Calculate_DiscardFrame_Flag();
   }
   /* exit sequence in fdq buffer -- disable GS-QAM block for subsequent frame */
   if(gs_RxPMDFrameCnt_FftFdqBufferSymbol == BEFORE_QAM_DISABLED_FRAME)
      RxSyncFrameSetup();     /* prepare for a oncoming sync symbol */


   // Since we don't have HW reverb segue detector,
   // We need FDQ OUT data.
   // This data is in the RTV1 which DSP can access directly.
   // The functions GetRxData(gsa_RxToneBuf, DD_FFTFDQ_LOGICAL_BUFFER, 0, gs_RxNumTones);
   // is not needed, instead just assign RTV1 buffer address to gsa_RxToneBuf.
   // This reduces the cycles consumed in the DMA transfer
   gsa_RxToneBuf = (int16 *)((uint32)IRI_QT_RAM_RX_NOISE_ACCMR_LSW_ADDR + 512*4);

    if(gt_RxOLRPMVars.uc_l2ProcState != PM_L0_STATE)
    {
        // L2 State m/c processing
      // This function does all the L2 related processing.
        do_l2_processing();
    }

   // L0 to L2/L2 Trim/L2 Exit (Mips Intensive Fdq Multiply and Load preformed in this frame)
    if (gft_fdqState)
    {
        // do not perform unncessary functionalities in the rest of the function
      gft_fdqState = FALSE;
      return;
   }

   if (guc_FdqAdaptationState == FDQ_ADAPTATION_LOAD_COEFFICIENTS)
   {
      //==============================
      // load adapted FDQs
      //==============================
      LoadDDFDQ();
      guc_FdqAdaptationState = FDQ_ADAPTATION_INITIALIZE;
   }


   // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
   //if (gt_RxOLRPMVars.uc_rxOLRPMState == L0_STEADY_STATE) {
   //   gu_L2SymbCount = 0;
   //} else if (gt_RxOLRPMVars.uc_rxOLRPMState == L2_STEADY_STATE) {
   //   gu_L2SymbCount++;
   //}
   // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)

   if(gs_RxPMDFrameCnt_FftFdqBufferSymbol == RX_SYMBOLS_PER_SFRAME)
   {
      //==============================
      // Sync frame in fdq buffer
      //==============================
        DisableRxPms(); //zep rx doesn't like to run on sync frame, with dt_size =0. (fixme m-code)
#ifdef TWO_FFT_BUFFERS
      do_sync_frame_processing_bis();
#endif // HERCULES_ADSL_CPE

      // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (START)
      switch(gt_RxOLRPMVars.uc_rxOLRPMState)
      {
         int16 s_signalType;

         case OLR_RECV_SYNC_INDICATOR: /* OLR            */
         case L2_RECV_SYNC_INDICATOR:  /* L0 to L2       */
         case L2_STEADY_STATE:         /* L2 Low Power Trim*/

            s_signalType=2;

            if(isReverbSegueDetected(s_signalType))
            {
               /* Update the sync signal type */
               gs_RxSyncToneType = !gs_RxSyncToneType;
               /* Signal to DEC adaptation that synch symbol has changed. */
               gft_SynchSymbolChange = TRUE;
               /* Do OLR/PM sync symbol processing */
               DoRxSyncSymbolOLRPM();

               // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start End)
               ft_SkipPilotProcessing = TRUE; //To Avoid Mips peaking

               // SEF detection is disabled to reduce the cycle consumption
               // During L2 entry and L2 trim.
               guc_SEFDetectState = SEF_DETECT_DISABLED;

                // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
                //Bug fix: OLRPM State changed to L2_RECONFIGURE in func DoRxSyncSymbolOLRPM()
               if (gt_RxOLRPMVars.uc_rxOLRPMState == L2_RECONFIGURE)
                  gft_ResetTrelMetricHist = 1;
               // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)
               }
            else
            {
               guc_SEFDetectState = SEF_DETECT_ENABLED;

                // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
                //gsa_RxToneBuf contains address of "IRI_QT_RAM_RX_NOISE_ACCMR_LSW_ADDR" and
                //"SYNC_LOGICAL_BUFFER" buffer points to the "IRI_QT_RAM_RX_NOISE_ACCMR_LSW_ADDR"
                //Hence DMA of same location is not required.
#if 0
               // Assign actual RxTone buffer address back
               // after L2 processing and after inverted sync detection is done
               gsa_RxToneBuf = gsa_RxToneBuf_tmp;
               // Sync Symbol Processing is done in background.
               // Here it is assumed that background function is completed by the next
               // Sync frame.
               GetRxData(gsa_RxToneBuf, SYNC_LOGICAL_BUFFER, 0, gs_RxNumTones);
#endif
                // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)
            }
        }

      // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
      /* read pilot tone, pll processing, micro-interruption check etc */
      if (ft_SkipPilotProcessing != TRUE) { // To avoid Mips peaking
         do_showtime_pilot_processing(TRUE);
      }
      // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)

   }
   else
   {

      //==============================
      // Data frame in fdq buffer
      //==============================
#ifndef TWO_FFT_BUFFERS
      // no need to toggle for Hercules build
      /* Toggle buffer select */
      gs_DD_rxFDQOutput_Buffer_Select = (1-gs_DD_rxFDQOutput_Buffer_Select);
#endif // AMAZON_SE || HERCULES_ADSL_CPE

      // To reduce the cycle consumption during L2 exit, pilot tone processing and
      // FDQ output capture is not done.
        if ((gt_RxOLRPMVars.uc_l2ProcState != PM_L2_EXIT_SEQ_REVERB_DETECTED) &&
         (gt_RxOLRPMVars.uc_l2ProcState != PM_L2_EXIT_SEQ_SEGUE_DETECTED))
        {
            /* read pilot tone, pll processing, micro-interruption check etc */
            do_showtime_pilot_processing(FALSE);

            /* TC Task data collection for DD snr and fdq updates */
            /* read fdq output for fdq frame cnts (0,67) -- no DDHandler() on sync symbol */
         GetRxData(&gsa_DD_rxFDQOutput[gs_DD_rxFDQOutput_Buffer_Select][0],
                     DD_FFTFDQ_LOGICAL_BUFFER, gs_DD_RxFirstChannel,
                     (int16)(gs_DD_RxLastChannel-gs_DD_RxFirstChannel+1));
        }

   }


#ifdef VR9_FIXME
   /* clear fdq done event register and poll for its completion */
   ClearEventRegister(0, 0x8);// cutme
#endif  //#ifdef VR9_FIXME
   /* set fdq processing done flag */
   gft_fdqTCDone = TRUE;


#ifdef PROFILE_TASKS //#ifdef out purely for Program memory reasons for now 3 Aug 2004
   LogMips(ST_RX_TC_FDQ, TC_NTC_END_FLAG);
#endif

//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (START - END)
#if   defined (ZEP_DEBUG_BLD) || defined (ZEP_DEBUG_BLD_RX)
   UpdateRxFifo3Stat();
#endif //#if   defined (ZEP_DEBUG_BLD) || defined (ZEP_DEBUG_BLD_RX)



}
// XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (END)

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void RShowtimeRxTC_BIS_A
*
*   Description:
*
*  TC task for qam done interrupt
*  Time-critical task associated with Showtime Rx Data Frames.
*
*  Arguments:
*     none
*
*  Global Variables:
*
*     gft_CopyPilotTone -- (I) set to TRUE to capture Pilot Tone
*                       information.  It is set in the state
*                       machine.
*
*-------------------------------------------------------------------
*^^^
*/

void RShowtimeRxTC_BIS_A(void)
{

#ifdef PROFILE_TASKS //#ifdef out purely for Program memory reasons for now 3 Aug 2004
   LogMips(ST_RX_TC_QAM, TC_NTC_START_FLAG);
#endif

   // call FDQ_DONE TC task at the beginning of QAM_DONE TC task
   // since there is no FDQ_DONE interrupt available in Hercules

   RShowtimeRxFdqTC_BIS();

   //XDSLRTFW-2751 (Start)
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
   if (gt_ReTxConfigInfo.ft_ReTxOn == 1)
   {
      guc_EstimatedTS = ModXIncrY(guc_EstimatedTS, 1, TS_MODULO);
   }
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
   // skip QAM_DONE TC task for sync frame
    if (gs_RxPMDFrameCnt_FftFdqBufferSymbol == QAM_DISABLED_FRAME)
    {
#ifdef PROFILE_TASKS
      LogMips(ST_RX_TC_QAM, TC_NTC_END_FLAG);
#endif
      return;
   }

   /* If there are pending loading functions, then run them */
   ExecuteQueuedLoadingFunctions(gp_RxLoadingFunctionFifo);

   /* update PMD frame counter. This counter goes from 0 to 68 */
   ModuloUpdateCount(&gs_RxPMDFrameCnt, RX_SYMBOLS_PER_SFRAME);

#ifdef PCM_INTERFACE_SUPPORT
   if (guc_PCMState >= 2)
   {
      pcm_rxProcessing();
   }
#endif   //#ifdef PCM_INTERFACE_SUPPORT

   /******        Loss of Power     ********/



   if ( gs_NE_LPR_indication || (CNTLArray[CNTL_ModemDying] == CNTL_ModemSendDyingGasp) )
   {
      gs_NearEndFailure |= PLAM_LPR_FailureBit;
   // XDSLRTFW-201 Feature_US_ALL_ALL_LPR(start)
      if (gus_Set_LPR & DSL_ModemSendDyingGasp) //Check only DSL 5 0 Bit-0
      {
         gs_lpr_detect = FALSE;  //Intentional so don't increment CRC counters
      }
      else
      {
         // XDSLRTFW-201 Feature_US_ALL_ALL_LPR(end)
         gs_lpr_detect = TRUE;
      }
      //The LPR indicator bit shall be coded 0 for the next 3 LPR indicator bit transmissions to
      //indicate that an LPR primitive (i.e., "dying gasp") is being reported
      gs_IB_lpr_cnt = 3;

      //XDSLRTFW-3708 Control of GPIO14 to indicate dying gasp for ADSL (Start)
   //This section is for GPIO14 control for BIS-PLUS Dying Gasp
      if (gus_Cnfg_Misc & CNFG_MISC_VRX518_ENABLE_GPIO14_FOR_DYING_GASP)
      {
         volatile uint32 ul_RegAddress;
         uint32 ul_AddressPointedByBAR18;
         uint32 ul_data;

         // VRX518 CHIPID_EFUSE (relative) base address which is stored in first 20 bits of DSP_XMEM_BAR18
         // address location. 12 MS bits are used for PCIe_BaseAddress
         // all the address access via BAR18 register must be located within 64K byte address range from it's base address
         ul_AddressPointedByBAR18 = (*((volatile uint32 *)DSP_XMEM_BAR18)) & 0xFFFFF;

         // note1: memory locations below is located outside ARC memory region. According to coding guideline
         // these memory locations must be accessed via DMA!
         // This memory is needed to be accessed during Dying Gasp. Before power goes down a very small time
         // will be available so the this memory is accessed via direct access.
         // !! These memory access is an exception!!

         // Note2: address offset range is checked intentionally. If there is any problem in address offset renge
         // then it would be caught in InitVRX518Regs_for_Gpio14() function.


         // Set VRx518 GPIO14 pin voltage from high to low
         ul_RegAddress = (uint32)(&__StartOfSramBAR18) + (uint32)(VRX518_GPIO_FUNC_OUTCLR_0_ADDRESS - ul_AddressPointedByBAR18);
         ul_data = *(volatile uint32 *)ul_RegAddress;
         ul_data |= 0x4000; // set bit 14 to 1
         *(volatile uint32 *)ul_RegAddress = ul_data;
      }
      //XDSLRTFW-3708 Control of GPIO14 to indicate dying gasp for ADSL (End)

   }

      //==============================
      // Data frame processing
      //==============================
      // Datapump needs to be the last Rx TC task that should run

      gft_fdqTCDone = FALSE;

      do_data_frame_processing();

#ifndef TWO_FFT_BUFFERS
#ifndef TARGET_HW
   }
#endif
#endif // HERCULES_ADSL_CPE || AMAZON_SE



#ifdef PROFILE_TASKS //#ifdef out purely for Program memory reasons for now 3 Aug 2004
   LogMips(ST_RX_TC_QAM, TC_NTC_END_FLAG);
#endif

}

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void RShowtimeRxTC_BIS_B
*
*   Description:
*
*  Time-critical task associated with Showtime Rx Data Frames.
*
*  Arguments:
*     none
*
*  Global Variables:
*
*
*-------------------------------------------------------------------
*^^^
*/
void RShowtimeRxTC_BIS_B(void)
{
#if defined  (DANUBE_WB) ||defined (VR9_ERASURE)

   //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (Start_End)
//This function is not fully tested on VR9 Platform. It is commented out
//while cleaning up the "Erasure decoder" enable logic as per VRx Message Spec - Vinjam
//This function is meant for enbaling/disabling the erasure decoder on the fly in the showtime
// if(gft_allow_reset_erasure)
//        Erasure_Reconfig();

   // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2
   // Default use new algorithm to decide on discard frame.
   if (!(gt_INFX_CMV.us_OperatorSpBits6 & CMV_TO_TOGGLE_NewAndOldDiscardFrameAlgo))
      Calculate_DiscardFrame_Threshold();

#endif   //#if defined  (DANUBE_WB) ||defined (VR9_ERASURE)
    /* Start the Rx Data Pump to complete the Rx processing */
   StartRxDataPump_BIS();
}

