/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             showtime_tx_bis.c
 * DESCRIPTION:      Functions that implement the showtime TX non-time critical tasks for g.dmt.bis.
 *
 **********************************************************************/

#include <stdio.h>
#include "common.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "xgdata.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "pn_tab.h"
#include "states.h"
#include "mtkernel.h"
#include "enc_gain.h"
#include "dec_gain.h"
#include "tx_m3oh.h"
#include "rx_m3oh.h"
#include "rt_tones.h"
#include "rt_state.h"
#include "synsymbl.h"
#include "tone_ord.h"
#include "bitload.h"
#include "fifo.h"
#include "cmv.h"
#include "mp.h"
#include "dslengin.h"
#include "qos.h"
#include "dec_adap.h"
#include "pll.h"
#include "timercov.h"
#include "bitswap.h"
#include "tx_plam_bis.h"
#include "prf_man.h"
#include "bert.h"
#include "detect.h"
#include "showtime_bis.h"
#include "tx_ovrhd_bis.h"
#include "ovhd_ini_bis.h"
#include "rx_ovrhd_bis.h"
#include "showinit.h"
#include "memory.h"
#include "ApplyFineGains.h"
#include "CalcRate_BIS.h"
#include "trail.h"

// Functions PhaseInvertSyncSymbol(), DoTxSyncSymbolOLR() and BgTxShowtimePreProc()
// imported from showtime_tx_bis.c . It module will be placed in the External/cache memory.
// It has been done to reduce the internal program memory size

void DoTxSyncSymbolOLR(void);
void BgTxShowtimePreProc(void);
void PhaseInvertSyncSymbol(int16 *ps_syncSignalType);

//==============================
// Tx OLR Utilities
//==============================
/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void PhaseInvertSyncSymbol(int16 *ps_syncSignalType)
*
*   Description:
*
*  Phase inverts the sync symbol.
*  For now, DSP does the phase inversion by parsing the gsa_Showtime_TxToneBuf
*  which forms the sync symbol
*  Later, this will be replaced by a hardware write which specifies
*  the sync signal   to be sent
*
*  Arguments:
*     none
*
*  Global Variables:
*
*     ps_syncSignalType -- (O) specifies the signal type of current
*                          sync symbol (Reverb--0/Segue--1)
*-------------------------------------------------------------------
*^^^
*/
void PhaseInvertSyncSymbol(int16 *ps_syncSignalType)
{
    int32 i;

    for(i = 2*gs_TxFirstChannel; i < 2*(gs_TxLastChannel+1); i++)
    {
        gsa_Showtime_TxToneBuf[i] = -gsa_Showtime_TxToneBuf[i];
    }

    /* Update the sync signal type */
    if (ps_syncSignalType != NULL) *ps_syncSignalType = !(*ps_syncSignalType);
}

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void DoTxSyncSymbolOLR(void)
*
*   Description:
*     Tx Sync Symbol OLR NTC Pre-Processing
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
void DoTxSyncSymbolOLR(void)
{
    if (gt_TxOLRVars.uc_txOLRState == OLR_SEND_SYNC_INDICATOR)
    {
        gt_TxOLRVars.uc_txOLRState = OLR_RECONFIGURE;
        /* Send phase inverted sync symbol as a reconfiguration indicator */
        PhaseInvertSyncSymbol(&gs_TxSyncToneType);
        /* Disable DD Processing for the duration of this instantaneous MIPs peak */
        if (gs_DD_NumFramesProcDisable<7) gs_DD_NumFramesProcDisable = 7;
    }
}

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void BgTxShowtimePreProc(void)
*
*   Description:
*  If we have just switched to tx showtime, re-initialize f/w
*  NOTE: This background task needs to be done in 1 superframe
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
void BgTxShowtimePreProc(void)
{
    /* Generate R_REVERB only ONCE and save in gsa_TxToneBuf (need during US OLR) -- save Program Memory */
    /* During OLRs, we need to update the sync frame based on new US fine gains */
    TxReverbSegueSetUp(gs_TxFirstChannel, gs_TxLastChannel, R_REVERB);
    /* Update gsa_Showtime_TxToneBuf to use data symbol fine gains for sync frames */
    memcpy(gsa_Showtime_TxToneBuf, gsa_TxToneBuf, sizeof(int16) * (TX_FFT_LENGTH+2));
    ApplyFineGains(gsa_Showtime_TxToneBuf, (int16)gs_TxFirstChannel, (int16)gs_TxLastChannel, (uint16 *)(void *)gt_tx_config.psa_FineGains);
    /* Use this variable to indicate progress of any last BgTasks using */
    /* R_NOSHOW page before we bring in SHOWBG1 and SHOWBG2 pages    */
    /* Currently, this is the last Bg process in showtime that makes use of R_NOSHOW */
    guc_BkgdTaskState = BKGDTASK_DONE;
}

