/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             showtime_tx_tc_bis.c
 * DESCRIPTION:      Functions that implement the bis showtime TX time critical tasks.
 *
 **********************************************************************/
/**********************************************************************/
// showtime_tx_tc_bis.c
//
// History
//
// 26/08/2011 Sriram Shastry : Add support for PTM transfer mode (in addition to ATM mode which is normally used in ADSL).
// This includes support in G.HS to indicate PTM support and evaluate CO response regarding possible PTM support
// Interface towards PPE engine -> Exchange of data-> reading of TC status counters from PPE engine and forwarding them to the
// related CMVs such that API can read them
// This feature is contolled via
// cnfg 0 0 2  // 1 : PTM 2: ATM 3: PTM+ATM
// cnfg 2 0 2  // 1 : PTM 2: ATM 3: PTM+ATM
// Default : ATM mode
// Grep for XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
//
/**********************************************************************/

#include <stdio.h>
#include "common.h"
#include "gdata.h"
#include "xgdata.h"
#include "gdata_bis.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "tx_eoc.h"
#include "aoc.h"
#include "aoc_ini.h"
#include "pn_tab.h"
#include "states.h"
#include "mtkernel.h"
#include "enc_gain.h"
#include "dec_gain.h"
#include "tx_m3oh.h"
#include "rx_m3oh.h"
#include "rt_tones.h"
#include "rt_state.h"
#include "ib.h"
#include "tx_ib.h"
#include "rx_ib.h"
#include "synsymbl.h"
#include "tone_ord.h"
#include "bitload.h"
#include "fifo.h"
#include "cmv.h"
#include "mp.h"
#include "qos.h"
#include "rx_eoc.h"
#include "rx_eoc1.h"
#include "rx_aoc.h"
#include "dec_adap.h"
#include "pll.h"
#include "timercov.h"
#include "bitswap.h"
#include "tx_aoc.h"
#include "rx_aoc.h"
#include "tx_plam.h"
#include "tx_plam_bis.h"
#include "rx_plam.h"
#include "prf_man.h"
#include "bert.h"
#include "detect.h"
#include "tx_ovrhd_bis.h"
#include "rx_ovrhd_bis.h"
#include "showinit.h"
#include "showtime_bis.h"
#include "DSLEngin.h"
#include "trail.h"

#include "atm_tx_processing.h"

#if defined(CUSTOMER_TASKS) && defined(IFX_XTC)
#include "customertasks.h"
#endif
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start)
#include "memrymap.h"
#include "ppe_memmap.h"
#include "LL_IOf.h"
#ifdef PPE_ENGINE
void GetTxPTMCnts(int16 s_abc);
void GetPPETxPtmCnts(int16 s_abc, uint32 *pula_CntBuf);
#endif
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (End)
//==============================
// Tx Utilities
//==============================
/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ComputeAZRunCount
 *
 *  Description: Computes number of times to run Alphaeus/Zephyr to generate Lp number of bits into rate buffer
 *
 *  Prototype:
 *      int16 ComputeAZRunCount(int16 s_NBits_In_RateBuffer, int16 s_LatencyPath)
 *
 *  Input Arguments:
 *      s_NBits_In_RateBuffer - No. of bits in the Tx Rate buffer
 *    s_LatencyPath        - path LP0 or LP1
 *
 *  Output Arguments:
 *      NONE
 *
 *  Return:
 *      s_AZRunCnt   - No. of times to run zephyr to generate atleast Lp number of bits into rate buffer
 *
 *  Global Variables Used:
 *
 *      gsa_TxMuxFrameCount[s_LatencyPath] : Tx Mux frame count for path specified in s_LatencyPath
 *    gt_TxShowTimeVars.t_FrameParms[s_LatencyPath].s_MuxFrameSize - Mux frame size (Kp) in bytes
 *    gt_tx_config.s_Rp[s_LatencyPath] - No. of check bytes per codeword (Rp) in bytes
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
#ifdef DEBUG_AZRUN
int gl_minAZRunSymbol;
int16 gs_dbg_maxAZRunCnt = 0;
int16 gs_dbg_minAZRunCnt = 10;
#endif

#ifndef HERCULES_ADSL_CPE
int16 ComputeAZRunCount(int16 s_NBits_In_RateBuffer, int16 s_BitsLp, int16 s_num_addtl_AZ_runs, int16 s_LatencyPath)
{
    int16 s_TransferSize, s_AZRunCnt = 0;

    while((s_NBits_In_RateBuffer < s_BitsLp)
            ||((s_NBits_In_RateBuffer < s_BitsLp + gs_total_extrabitsNeeded+7) && (s_AZRunCnt < gs_maxAZRunCnt)))
    {
        /* Compute Transfer size for next PMS run */
        /* if (mux_frame_count == (Mp -1)   */
        /*    s_TransferSize = Kp + Rp      */
        /* else                        */
        /*     s_TransferSize = Kp;          */
        if(gsa_TxMuxFrameCount[s_LatencyPath] == (gt_tx_config.s_Mp[s_LatencyPath] -1))
        {
            s_TransferSize = gsa_TxMuxFrameSize[s_LatencyPath][1];
            gsa_TxMuxFrameCount[s_LatencyPath] = 0;
        }
        else
        {
            s_TransferSize = gsa_TxMuxFrameSize[s_LatencyPath][0];
            gsa_TxMuxFrameCount[s_LatencyPath]++;
        }

        /* Initialize variables- These are used in StartRxDataPump_BIS() */
        gusa_ACfgRegValue[s_AZRunCnt] |= gusa_PreconfigACfgTx[s_LatencyPath];
        gusa_ZtLineRegValue[s_AZRunCnt] |= ((1<<11)<<s_LatencyPath);
        gsa_ItSizeRegValue[s_AZRunCnt] |= (s_TransferSize << (8*s_LatencyPath));

        s_NBits_In_RateBuffer += (s_TransferSize << 3); /* convert to bits */
        s_AZRunCnt++;
    }

#ifdef DEBUG_AZRUN
    /* Record the maximum AZRunCnt, ideally shouldnt be more than 3 for Plus and 2 for Bis */
    if (s_AZRunCnt > gs_dbg_maxAZRunCnt)
    {
        gs_dbg_maxAZRunCnt = s_AZRunCnt;
    }

    if (s_AZRunCnt < gs_dbg_minAZRunCnt)
    {
        gs_dbg_minAZRunCnt = s_AZRunCnt;
        gl_minAZRunSymbol = gl_TxSymbolCount;
    }
#endif

    return(s_AZRunCnt);
}
#endif

//==============================
// Tx OLR Utilities
//==============================
/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : RShowtimeTxTC_BIS_A
 *
 *  Description: Tx time-critical operation in showtime
 *
 *  Prototype:
 *      void RShowtimeTxTC_BIS_A(void)
 *
 *  Input Arguments:
 *      None
 *
 *  Output Arguments:
 *      None
 *
 *  Return:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RShowtimeTxTC_BIS_A(void)
{
    int i;

#ifdef PROFILE_TASKS
    LogMips(ST_TX_TC_FS, TC_NTC_START_FLAG);
#endif

    /* If there are pending loading functions, then run them.  */
    ExecuteQueuedLoadingFunctions(gp_TxLoadingFunctionFifo);

    /* update PMD frame counter. This counter goes from 0 to 68 */
    ModuloUpdateCount(&gs_TxPMDFrameCnt, TX_SYMBOLS_PER_SFRAME);

    switch(gs_TxPMDFrameCnt)
    {
    case TX_SYMBOLS_PER_SFRAME:
        //==============================
        // Sync frame processing
        //==============================
#ifdef PCM_INTERFACE_SUPPORT
        if (guc_PCMState==1)
        {
            pcm_enable();
        }
#endif   //#ifdef PCM_INTERFACE_SUPPORT
#ifdef IFX_XTC
        if (gft_AlphaeusSel)
#endif

            do_atm_tx_processing();

        //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(Start)
#ifdef PPE_ENGINE
        for(i=0; i<NUM_DS_BEARER_CHANNELS_SUPPORTED; i++)
        {
            if(guca_US_TransferMode_bis[i] & PTM)
            {
                GetTxPTMCnts((int16)i);
            }
        }
#endif
        //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(End)
        TxSyncFrameSetup();
        break;

    default:

#ifdef PCM_INTERFACE_SUPPORT
        if (guc_PCMState >= 2)
        {
            pcm_txProcessing();
        }
#endif   //#ifdef PCM_INTERFACE_SUPPORT

        //==============================
        // Data frame processing
        //==============================
        //s_Mips = ReadTxTimer();
#ifndef HERCULES_ADSL_CPE
        /* Initialize variables- These are used in StartTxDataPump_BIS() to determine transfer size*/
        gus_ZtLineRegMask = 0;
        for(i=0; i<MAX_AZ_RUNS; i++)
        {
            gusa_ACfgRegValue[i] = gusa_ZtLineRegValue[i] = gsa_ItSizeRegValue[i] = 0;
        }
        /* compute the number of times to run Alphaeus and Zephyr */
        gs_AZRunCnt = 0;
        for(i=0; i<gt_tx_config.s_Nlp; i++)
        {
            ProcessCorruptCRC_BIS((int16)i);
            s_NBits_In_RateBuffer = CalcBitsInTxRateBuffer((int16)i);
            GetTxLpBits((int16)i, &s_BitsLp);
            s_AZRunCount = ComputeAZRunCount(s_NBits_In_RateBuffer, s_BitsLp, gsa_num_preproc_frames[i], (int16)i);
            /* get the max AZ Run Cnt */
            if (gs_AZRunCnt < s_AZRunCount) gs_AZRunCnt = s_AZRunCount;
        }
        TxIbProcessor_bis();
#endif

        /* set up iridia for non-sync frame processing */
        if (gs_TxPMDFrameCnt == 0)
        {
            TxSyncFrameTearDown();
        }


#ifndef DISABLE_BERT
        TxBERTSetup();
#endif

        RShowtimeTxTC_BIS_B();

        //s_Mips = ReadTxTimer() - s_Mips;
        //if (s_Mips > gs_dbgTCAMaxMipsTx)
            //gs_dbgTCAMaxMipsTx = s_Mips;
    }


    /* Copy captured Rx data for DEC adaptation from  */
    /* the engine to the task layer.                  */
    if (guc_DECAdaptationState != DEC_ADAPTATION_DISABLED)
    {
#ifndef ADSL_62
        GetDECAdaptationRxData();
#endif
    }

#ifdef PROFILE_TASKS
    LogMips(ST_TX_TC_FS, TC_NTC_END_FLAG);
#endif
}

//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(Start)
/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : RShowtimeTxTC_BIS_B
 *
 *  Description: Tx time-critical operation in showtime data frames
 *
 *  Prototype:
 *      void RShowtimeTxTC_BIS_B(void)
 *
 *  Input Arguments:
 *      None
 *
 *  Output Arguments:
 *      None
 *
 *  Return:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RShowtimeTxTC_BIS_B(void)
{
    StartTxDataPump_BIS();
}
/*
*-------------------------------------------------------------------------------
*
*  Prototype: void GetTxPTMCnts(int16 s_abc)
*
*  This function reads Tx PTM counters.
*
*  Input Arguments:
*
*     s_abc: PTM BC #, 0 = ABC0, 1 =ABC1
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/


void GetTxPTMCnts(int16 s_abc)
{
#ifdef PPE_ENGINE
    uint32 ula_data[NUM_READ_TX_PTM_REGS];

    GetPPETxPtmCnts(s_abc, ula_data);
#endif
}


/*
*-------------------------------------------------------------------------------
*
*  Prototype: void GetPPETxPtmCnts(int16 s_abc, uint32 *pula_CntBuf)
*
*  This function reads PPE TX PTM counters
*
*  Input Arguments:
*     s_abc: the bearer channel number: 0 = ABC0, 1 = ABC1
*
*  Output Arguments:
*     pula_CntBuf -- pointer to the array containing the register values.
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

void GetPPETxPtmCnts(int16 s_abc, uint32 *pula_CntBuf)
{

    uint8 uc_offset;
    uint32 ul_addr, ul_data;
#ifdef PPE_ENGINE
    //Compute the register address offset
    uc_offset = (uint8)(s_abc<<2);

    //Compute the number of non-idle cells -----------------------
    ul_addr = DREG_AT_CELL0_ADDR + uc_offset;
    ReadCoreReg(ul_addr, &ul_data);

    //Compute the counter difference between the previous read and current read
    pula_CntBuf[TX_CW_CNT] = CompWrapAroundCounterDiff(&gula_DREG_AT_CELL_Shadow[s_abc], &ul_data);
#endif
} //GetPPETxPtmCellCnts()
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(End)


