/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   tone_reord_load.c
 *
 *
 *----------------------------------------------------------------------------
 */

#include "const.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "tone_ord.h"

//=========================================================
// Global variables
//=========================================================

//=========================================================
// Static variables
//=========================================================

//=========================================================
// Functions
//=========================================================

/********************************************************************************
;  Subroutine Name: void ToneOrdering1BitTcm(int16 *psa_BAT, int16 *psa_toneorder, int16 s_NumTones, int16 s_NumLoadedTones, int16 s_num1bits, int16 *psa_toneorderTCM)
;
;
;  Prototype:
;     void ToneOrdering1BitTcm(void)
;
;  Input Arguments:
;     psa_BAT        -  Input bat table
;     psa_toneorder  -  Input tone-ordering table
;     s_NumTones     -  Number of tones
;     s_num1bits     -  Number of 1 bits
;     psa_toneorderTCM- Output tone-ordering table with 1 bits moved to the end
;
;
;  Output Arguments:
;
;
;  Return:
;
;
;  Global Variable used by this file:
;
;****************************************************************************/
C_SCOPE void ToneOrdering1BitTcm(uint8 *psa_BAT, int16 *psa_toneorder, int16 s_NumTones, int16 s_NumLoadedTones, int16 s_num1bits, int16 *psa_toneorderTCM)
{
    int i;
    int16 s_bat, s_tone, *psa_toneorderTCM_1bits, *psa_toneorderTCM_non1bits;

    psa_toneorderTCM_1bits = (psa_toneorderTCM + s_NumTones - s_num1bits);
    psa_toneorderTCM_non1bits = (psa_toneorderTCM + (s_NumTones - s_NumLoadedTones));
    for (i = 0; i < s_NumTones; i++)
    {
        s_tone = *psa_toneorder++;
        s_bat = *(psa_BAT+s_tone);
        if (s_bat == 0)
        {
            *psa_toneorderTCM++ = s_tone;
        }
        else if (s_bat == 1)
        {
            *psa_toneorderTCM_1bits++ = s_tone;
        }
        else
        {
            *psa_toneorderTCM_non1bits++ = s_tone;
        }
    }
}

/********************************************************************************
;  Subroutine Name: void BgRxToneReorderLoad(void)
;
;
;  Prototype:
;     void BgRxToneReorderLoad(void)
;
;  Abstract:
;     Uses the stack to save original Tone order table, reorders the tone order
;     table if necessary to move the 1 bit tones to the end, triggers and waits
;     until download of the reordered table into h/w and then returns
;
;  Input Arguments:
;
;
;  Output Arguments:
;
;
;  Return:
;
;
;  Global Variable used by this file:
;
;****************************************************************************/
C_SCOPE void BgRxToneReorderLoad(void)
{
    int i;
    int16 sa_SaveOrigRxToneOrder[RX_NUM_TONES];

    //Save the original RxToneOrdering Table on the stack
    for(i=0; i<gs_RxNumTones; i++)
        sa_SaveOrigRxToneOrder[i] = gsa_RxToneOrder[i];

    //Reorder the tone-order table to load into hardware
    ToneOrdering1BitTcm(gt_rx_config.psa_BAT, sa_SaveOrigRxToneOrder, gs_RxNumTones, (int16)gus_ncloaded, gus_Rx_Tcm_Num1bits, gsa_RxToneOrder);

    //NOTE :: Waits for TC task to finish loading the Tone Order Table in a loop
    //We need to wait here in the same function instead of calling a separate bkgrnd func after TC
    //task because the original Rx Tone Order Table that needs to be restored is saved on the stack
    //Also note, we can avoid this after RTL is updated so that DSP can access the unused b/g/t bank
    //in Iridia @ all times
    guc_RxToneOrderLoadState = RXTONEORDERLOAD_TC_LOAD;
#ifndef WIN32
    //Only viable on h/w, Cocomo would go into an infinite loop here
    while(guc_RxToneOrderLoadState == RXTONEORDERLOAD_TC_LOAD)
    {
        delay(10);   // Without this delay, strange things would occur!!
    }
#else
    //On Cocomo call TC task here instead of waiting to having it as a interrupt service routine
    if(guc_RxDataPumpState == TRAINING_IN_PROGRESS)
        RxDataPumpSetUp();
    else if(gt_RxOLRPMVars.s_rxOLRPMEvent & LOAD_TRB)
        OLRPM_RxLoadTables();
#endif

    //Restore the original RxToneOrdering Table from the stack
    for(i=0; i<gs_RxNumTones; i++)
        gsa_RxToneOrder[i] = sa_SaveOrigRxToneOrder[i];

    guc_RxToneOrderLoadState = RXTONEORDERLOAD_BKGD_DONE;
}

