/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: train_gen.c
;
;  This program generates test signal for testing G.DMT ATU-C system:
;   The testvector is assumed to be the signal received from ATU-R
;  and is used to test ATU-C state from the beginning of Tranceiver Training
;  to the end of Exchange or Showtime.
;
;  To run the program:
;
;  a.out          -> produce the testvector (rx input) for test
;                    tranceiver training to exchange;
;
;   a.out st_rxin.bin   -> produce the testvector (rx input) for test
;                    tranceiver training to showtime, where
;                    st_rxin.bin is the showtime RX input file,
;                    which may be produced by running "SHOWTIME" first.
;
;  the testvector is stored in "train.bin"
;
;
;***************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <memory.h>

#include "config.h"
#include "common.h"
#include "rt_tones.h"
#include "rt_state.h"
#include "tx_ops2.h"
#include "dsp_op.h"
#include "snr.h"
#include "const_bis.h"
#include "DeScramble_bis.h"

#define FIR_LEN 7
#define IIR_LEN 7

int16 gs_TxNumTones = 32;

int16 gs_TxLog2FftLength1;
int16 gs_TxFftLength = TX_FFT_LENGTH;
int16 gs_TxCPLength = TX_PREFIX_LENGTH;

int16 gs_RxNumTones = RX_NUM_TONES;
int16 gs_RxLog2FftLength1;
int16 gs_RxLog2NumTones;
int16 gs_RxFftLength = RX_FFT_LENGTH;
int16 gs_RxCPLength = RX_PREFIX_LENGTH;

FlagT gft_SincTssiFlag = FALSE;

uint16 gusa_US_Tssi_Value[64] = {
136,
136,
140,
144,
153,
162,
1024,
1024,
1024,
1024,
1024,
1024,
1024,
1024,
1024,
1024,
1024,
1024,
1024,
1024,
1024,
1024,
1024,
1024,
1024,
1024,
1024,
1024,
1024,
1024,
1024,
1024,
384,
144,
130,
117,
105,
95,
86,
77,
69,
62,
56,
50,
45,
45,
44,
43,
43,
42,
41,
41,
40,
39,
37,
35,
34,
32,
31,
30,
28,
28,
28,
28};



int16 gsa_TxToneOrder[TX_NUM_TONES];

int16 gsa_x_mem[FIR_LEN] = {0, 0, 0, 0, 0, 0, 0};
int16 gsa_y_mem[IIR_LEN] = {0, 0, 0, 0, 0, 0, 0};

int16 gsa_b[FIR_LEN] = { (int16)0x173b, (int16)0x0,    (int16)0x45ae, (int16)0x0, (int16)0x45ae, (int16)0x0,    (int16)0x173b};
int16 gsa_a[IIR_LEN] = { (int16)0x2000, (int16)0x0,    (int16)0x4ba9, (int16)0x0, (int16)0x3d49, (int16)0x0,    (int16)0x10db };

/* use the extended length */
#define LEN_R_REVERB1   592      /* =272 or =592 */
#define LEN_R_QUIET4 0     /* >=0 and <=15872 */
#define LEN_R_MSG1_PREFIX  4
#define NUM_R_MSG1_OCTETS  4
#define  LEN_R_MSG1        (LEN_R_MSG1_PREFIX+NUM_R_MSG1_OCTETS+2)*8 /* 2 CRC bytes. */

//===============================================================================
//Global variables
//===============================================================================

int16 gsa_Comb_Carriers[16] = {11, 23, 35, 47, 59, 64, 71, 83, 95, 107, 119, 143, 179, 203, 227, 251};

// C_MSG_FMT
// definitions for C_MSG_FMT
#define FMT_R_REVERB1   0     /* 1=CO requests extended duration of R_REVERB1, 0=CO does not request extended duration of R_REVERB1 */
#define  FMT_C_REVERB4  0     /* 1=CO requests extended duration of C_REVERB4, 0=CO does not requests  extended duration of C_REVERB4 */
#define FMT_R_QUIET4 0     /* (value 0 to 31) indicates the duration of R_QUIET4 state */
#define FMT_C_MSG_PCB   0     /* 1=the C_MSG_PCB message shall include the C-BLACKOUT bits, 0= it shall not  */

#define LEN_C_MSGFMT_WITHOUT_CRC 2
uint8 guca_RCMsgFMTTab[LEN_C_MSGFMT_WITHOUT_CRC] = {(((FMT_R_QUIET4 & 0x1F) << 3) | (FMT_C_REVERB4 << 2) | FMT_R_REVERB1),
                              FMT_C_MSG_PCB };

// C_MSG_PCB
// definitions for C_MSG_PCB
#define C_MIN_PCB_DS 0     /* CO min. DS power cutback = 0, range is 0 to 40 dB */
#define C_MIN_PCB_US 0     /* CO min. US power cutback = 0, range is 0 to 40 dB */
#define HOOK_STATUS     0     /* 0=unknown, 1=on-hook, 2=off-hook, 3=not capable to detect */

#define LEN_C_MSGPCB_WITHOUT_CRC 2
uint8 guca_RCMsgPCBTab[LEN_C_MSGPCB_WITHOUT_CRC] = {(((C_MIN_PCB_US & 0x3) << 6) | (C_MIN_PCB_DS & 0x3F)),
                              ( ((HOOK_STATUS & 0x3) << 12) | ((C_MIN_PCB_US >> 2) & 0xF))};

/* Add the following definitions to remove compiling errors */
uint8 guca_RMsgPCBTab[LEN_R_MSGPCB_WITHOUT_CRC];

/* Structure used for C_MSG_FMT */
typedef struct {
   uint16   us_FMT_R_REVERB1;                /* Set to 1 indicates that the ATU-C requests an extended duration of the R-REVERB1 state. Set to 0 indicates not. */
// uint16   us_FMT_C_MSG1;                   /* Set to 1 indicates that the ATU-C shall transmit the C-MSG1 message. Set to 0 indicates it shall not. */
   uint16   us_FMT_C_REVERB4;                /* Set to 1 indicates that the ATU-C requests an extended duration of the C-REVERB4 state. Set to 0 indicates it does not. */
   uint16   us_FMT_R_QUIET4;                 /* The (0 to 31) value mapped in these bits indicates the duration of the R-QUIET4 state. The msb shall be mapped on the higher message bit index. */
        uint16  us_FMT_C_MSG_PCB;                           /* Set to 1 indicates that the C-MSG-PCB message shall include the C-BLACKOUT bits. Set to 0 indicates that it shall not  */
} CMsgFmt_Bis_t;

CMsgFmt_Bis_t gt_RCMsgFmt_bis;

/* The above definitions are added to remove compiling errors */


//C_MSGS1
#define TARSNRMds       6*10  /* target noise margin with 0.1dB step size */
#define MINSNRMds       4*10  /* minimum noise margin with 0.1dB step size */
#define MAXSNRMds       12*10 /* maximum noise margin with 0.1dB step size */
#define RA_MODEds       0  /* rate adaptation mode */
#define PM_MODE            0  /* power management mode. Bit0: indicates whether L3 state is allowed (1) or not allowed (0) */
                        /* Bit1: indicates whether L2 state is allowed (1) or not allowed (0) */
#define RA_USNRMds         0  /* rate adaptation upshift noise margin */
#define RA_UTIMEds         0  /* rate adaptation upshift time interval */
#define RA_DSNRMds         0  /* rate adaptation downshift noise margin */
#define RA_DTIMEds         0  /* rate adaptation downshift time interval */
#define BIMAXds            15 /* max number of bits per sub carrier, >=8 and <= 15 */
#define EXTGIds            0  /* max extension of gi range supported, >=0 and <= (MAXPSDds - NOMPSDds) */
#define  CA_MEDLEYus       41 /* minimum length of the R_MEDLEY state: 41*512 = 20992 */

#define PMD_TC_OCTET1      (TARSNRMds & 0xFF)   /* TARSNRMds (lsb) bits 7 to 0*/
#define PMD_TC_OCTET2      (TARSNRMds & 0x1) /* TARSNRMds (msb) bit 8 */
#define PMD_TC_OCTET3      (MINSNRMds & 0xFF)   /* MINSNRMds (lsb) bits 7 to 0*/
#define PMD_TC_OCTET4      (MINSNRMds & 0x1) /* MINSNRMds (msb) bit 8 */
#define PMD_TC_OCTET5      (MAXSNRMds & 0xFF)   /* MAXSNRMds (lsb) bits 7 to 0*/
#define PMD_TC_OCTET6      (MAXSNRMds & 0x1) /* MAXSNRMds (msb) bit 8 */
#define PMD_TC_OCTET7      (RA_MODEds & 0x3) /* RA-MODEds (lsb) bits 1 to 0*/
#define PMD_TC_OCTET8      (PM_MODE & 0x3)      /* PM-MODE (lsb) bit 1 to 0 */
#define PMD_TC_OCTET9      (RA_USNRMds & 0xFF)  /* RA-USNRMds (lsb) bits 7 to 0*/
#define PMD_TC_OCTET10     (RA_USNRMds & 0x1)   /* RA-USNRMds (msb) bit 8 */
#define PMD_TC_OCTET11     (RA_UTIMEds & 0xFF)  /* RA-UTIMEds (lsb) bits 7 to 0*/
#define PMD_TC_OCTET12     (RA_UTIMEds & 0x1)   /* RA-UTIMEds (msb) bit 8 */
#define PMD_TC_OCTET13     (RA_DSNRMds & 0xFF)  /* RA-DSNRMds (lsb) bits 7 to 0*/
#define PMD_TC_OCTET14     (RA_DSNRMds & 0x3F)  /* RA-DSNRMds (msb) bit 8 to 13*/
#define PMD_TC_OCTET15     (RA_DTIMEds & 0xFF)  /* RA-DTIMEds (lsb) bits 7 to 0*/
#define PMD_TC_OCTET16     (RA_DTIMEds & 0x3F)  /* RA-DTIMEds (msb) bit 8 to 13*/
#define PMD_TC_OCTET17     (BIMAXds & 0xF)      /* BIMAXds bits 3 to 0 */
#define PMD_TC_OCTET18     (EXTGIds & 0xFF)  /* EXTGIds bits 7 to 0 */
#define PMD_TC_OCTET19     (CA_MEDLEYus & 0x3F)/* CA-MEDLEYus bits 5 to 0 */
#define PMD_TC_OCTET20     0  /* reserved */

#define LEN_C_MSG1_PREFIX  4
#define NUM_C_MSG1_OCTETS  20
#define  LEN_C_MSG1        (LEN_C_MSG1_PREFIX+NUM_C_MSG1_OCTETS+2)*8 /* 2 CRC bytes */

uint8 guca_RCMsg1_Prefix[LEN_C_MSG1_PREFIX] = {0x55, 0x55, 0x55, 0x55};
uint8 guca_RCMsgs1Tab[NUM_C_MSG1_OCTETS] = {
                     PMD_TC_OCTET1,
                     PMD_TC_OCTET2,
                     PMD_TC_OCTET3,
                     PMD_TC_OCTET4,
                     PMD_TC_OCTET5,
                     PMD_TC_OCTET6,
                     PMD_TC_OCTET7,
                     PMD_TC_OCTET8,
                     PMD_TC_OCTET9,
                     PMD_TC_OCTET10,
                     PMD_TC_OCTET11,
                     PMD_TC_OCTET12,
                     PMD_TC_OCTET13,
                     PMD_TC_OCTET14,
                     PMD_TC_OCTET15,
                     PMD_TC_OCTET16,
                     PMD_TC_OCTET17,
                     PMD_TC_OCTET18,
                     PMD_TC_OCTET19,
                     PMD_TC_OCTET20 };

//C_MSGS2
/* subcarriers used to transmit R_PARAMS message */
#define NSC_R_PARAMS 8  // 8 carriers to be sent in C-PARAMS
uint8 guca_Tones_RCMsg2[NSC_R_PARAMS] = {8, 10, 12, 14, 16, 18, 22, 25};

//uint8 guca_RCMsgs2Tab[4] = {0x00, 0xFF, 0x00, 0x00};
uint8 guca_RCMsgs2Tab[4];

//C_MEDLEY
#define NUM_C_MEDLEY_BYTES 512/8

//C_PARAMS
/* subcarriers 207 to 222 are used to transmit C_PARAMS message */
/* These tones are determined in CPE's bitloading part and depend */
/* on the channel used in the test */
uint8 guca_Tones_RMsg2[NSC_C_PARAMS] = {167, 172, 175, 177,
                              183, 184, 189, 191,
                              193, 194, 196, 198,
                              202, 210, 213, 216};

// PMS-TC parameters for C-PARAMS
#define NTR_ENCODE         1     /* 1=NTR bit oriented overhead bits are used to encode the NTR timing offset */
#define  MSGLP          0     /* latency path in which the message based overhead info is to be xmitted. The values */
                           /* can be 00, 01, 10 and 11 corresponding to latency path #0, #1, #2 and #3, respectively */

#define BC0_TO_LATENCYPATH 0     /* indicated BC0 goes to latency path 0 */
#define BC1_TO_LATENCYPATH 0xF      /* BC1 is not assigned to any path */

#define BC2_TO_LATENCYPATH 0xF      /* BC2 is not assigned to any path */
#define BC3_TO_LATENCYPATH 0xF      /* BC3 is not assigned to any path */

#define PMS_TC_OCTET1      ((BC0_TO_LATENCYPATH << 4) | BC1_TO_LATENCYPATH)
#define PMS_TC_OCTET2      ((BC2_TO_LATENCYPATH << 4) | BC3_TO_LATENCYPATH)


#define MSGc            0     /* # of octects of message based overhead that are included in the latency path #MSGLP */
#define Bp_LP0_DATA_PATH   13    /* Bp for latency path #0. Set to zero if not used */
#define Mp_LP0_DATA_PATH   1     /* Mp for latency path #0. Set to zero if not used */
#define Rp_LP0_DATA_PATH   8     /* Rp for latency path #0. Set to zero if not used */
#define Dp_LP0_DATA_PATH   1     /* Dp for latency path #0. Set to zero if not used */
#define Log2_Dp_LP0_DATA_PATH 0
#define Tp_LP0_DATA_PATH   2     /* Tp for latency path #0. Set to zero if not used */
#define Lp_LP0_DATA_PATH   176      /* Lp for latency path #0. Set to zero if not used */

#define Bp_LP1_DATA_PATH   0     /* Bp for latency path #1. Set to zero if not used */
#define Mp_LP1_DATA_PATH   1     /* Mp for latency path #1. Set to zero if not used */
#define Rp_LP1_DATA_PATH   0     /* Rp for latency path #1. Set to zero if not used */
#define Dp_LP1_DATA_PATH   1     /* Dp for latency path #1. Set to zero if not used */
#define Log2_Dp_LP1_DATA_PATH 0
#define Tp_LP1_DATA_PATH   2     /* Tp for latency path #1. Set to zero if not used */
#define Lp_LP1_DATA_PATH   8     /* Lp for latency path #1. Set to zero if not used */

#define Bp_LP2_DATA_PATH   0     /* Bp for latency path #2. Set to zero if not used */
#define Mp_LP2_DATA_PATH   0     /* Mp for latency path #2. Set to zero if not used */
#define Rp_LP2_DATA_PATH   0     /* Rp for latency path #2. Set to zero if not used */
#define Dp_LP2_DATA_PATH   0     /* Dp for latency path #2. Set to zero if not used */
#define Log2_Dp_LP2_DATA_PATH 0
#define Tp_LP2_DATA_PATH   0     /* Tp for latency path #2. Set to zero if not used */
#define Lp_LP2_DATA_PATH   0     /* Lp for latency path #2. Set to zero if not used */

#define Bp_LP3_DATA_PATH   0     /* Bp for latency path #3. Set to zero if not used */
#define Mp_LP3_DATA_PATH   0     /* Mp for latency path #3. Set to zero if not used */
#define Rp_LP3_DATA_PATH   0     /* Rp for latency path #3. Set to zero if not used */
#define Dp_LP3_DATA_PATH   0     /* Dp for latency path #3. Set to zero if not used */
#define Log2_Dp_LP3_DATA_PATH 0
#define Tp_LP3_DATA_PATH   0     /* Tp for latency path #3. Set to zero if not used */
#define Lp_LP3_DATA_PATH   0     /* Lp for latency path #3. Set to zero if not used */

// PMD parameters for C-PARAMS
#define LATN_US            0     /* line attenuation for upstream */
#define SATN_US            0     /* signal attenuation for upstream */
#define SNRM_US            6     /* signal to noise margin for upstream */
#define ATTNDR_US       0     /* attainable net data rate for upstream */
#define ACTATP_US       0     /* actual aggregate transmit power */
#define TRELLIS_US         1     /* 0=trellis off, 1=trellis on */


#define LEN_C_PARAMS_PMD_HEADER (13 + 1)
#define LEN_C_PARAMS_PMD (LEN_C_PARAMS_PMD_HEADER + 1 + 2*(TX_NUM_TONES-1) + (TX_NUM_TONES-1))
#define LEN_C_PARAMS_PMS      (28)
#define LEN_C_PARAMS_CRC      (2)
#define LEN_C_PARAMS_MESSAGE_BYTES  (LEN_C_PARAMS_PMD + LEN_C_PARAMS_PMS + LEN_C_PARAMS_CRC)

uint8 guca_CRParamsPMD[LEN_C_PARAMS_PMD_HEADER] = {(LATN_US & 0xFF),
                                       ((LATN_US >> 8) & 0x3),
                                       (SATN_US & 0xFF),
                                       ((SATN_US >> 8) & 0x3),
                                       (SNRM_US & 0xFF),
                                       ((SNRM_US >> 8) & 0x7),
                                       (ATTNDR_US & 0xFF),
                                       ((ATTNDR_US >> 8) & 0xFF),
                                       ((ATTNDR_US >> 16) & 0xFF),
                                       ((ATTNDR_US >> 24) & 0xFF),
                                       (ACTATP_US & 0xFF),
                                       ((ACTATP_US >> 8) & 0xFF),
                                       TRELLIS_US,
                                       0                       /* reserved */
                                       };

uint8 guca_CRParamsPMS[LEN_C_PARAMS_PMS] = {MSGLP,
                                 PMS_TC_OCTET1,
                                 PMS_TC_OCTET2,
                                 MSGc,
                                 Bp_LP0_DATA_PATH,
                                 Bp_LP1_DATA_PATH,
                                 Bp_LP2_DATA_PATH,
                                 Bp_LP3_DATA_PATH,
                                 Mp_LP0_DATA_PATH,
                                 Tp_LP0_DATA_PATH,
                                 ((Rp_LP0_DATA_PATH<<3)|(Log2_Dp_LP0_DATA_PATH)),
                                 Lp_LP0_DATA_PATH, //lsb of Lp
                                 0,                //msb of Lp
                                 Mp_LP1_DATA_PATH,
                                 Tp_LP1_DATA_PATH,
                                 ((Rp_LP1_DATA_PATH<<3)|(Log2_Dp_LP1_DATA_PATH)),
                                 Lp_LP1_DATA_PATH, //lsb of Lp
                                 0,                //msb of Lp
                                 Mp_LP2_DATA_PATH,
                                 Tp_LP2_DATA_PATH,
                                 ((Rp_LP2_DATA_PATH<<3)|(Log2_Dp_LP2_DATA_PATH)),
                                 Lp_LP2_DATA_PATH, //lsb of Lp
                                 0,                //msb of Lp
                                 Mp_LP3_DATA_PATH,
                                 Tp_LP3_DATA_PATH,
                                 ((Rp_LP3_DATA_PATH<<3)|(Log2_Dp_LP3_DATA_PATH)),
                                 Lp_LP3_DATA_PATH, //lsb of Lp
                                 0,                //msb of Lp
                              };

/* bit allocation table */
#define NUM_DS_BITS  184   /* Total bits in Bat = 184 */

int16 gsa_TxBat[TX_NUM_TONES] = {
    0,  0,  0,  0,  0,  0,  2,  3,  4,  5,
    6,  7,  8,  9, 12, 15,  0, 15, 13,  9,
    7,  7,  7,  7,  7,  7,  7,  6,  6,  6,
    5,  4};


int16 gsa_FineGains[TX_NUM_TONES] =
{0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000};

uint8 guca_CRParamsTab[LEN_C_PARAMS_MESSAGE_BYTES+1];
int16 gsa_TxOutBuf[RX_INBUF_FRAME_SIZE];     //TX output buffer
int16 gs_NumBytesToPad, gs_NumBytesInParamsSymbol;

int16 gs_RCQuiet1_len = 512;              /* >= 512 and <= 4204 */
int16 gs_RCComb2_len  = 3872;             /* = 1024 or =3872 */
int16 gs_RCIComb1_len = 0;                /* =0 or 10 */
int16 gs_RCLineProbe_len = 0;             /* =0 or 512 */
int16 gs_RCQuiet3_len   = 384;               /* >=256 and <=906 */
int16 gs_RCQuiet4_len   = 474;               /* >=314 and <=1242 */
int16 gs_RCReverb1_len  = (LEN_R_REVERB1 + LEN_R_QUIET4 - 80);
/* use extended length */
int16 gs_RCTref1_len = 3584;              /* >=512 and <=15872 */
int16 gs_RCReverb3_len  = 962;               /* >=448 and <=15936 */
int16 gs_RCReverb4_len  = 256;               /* =256 or =1024 */
int16 gs_RCMSG1_len     = LEN_C_MSG1;        /* =0 or =LEN_C_MSG1 */
int16 gs_RCReverb5_len  = LEN_R_MSG1+10;        /* >=10 and <=(218+LEN_R_MSG1) */
int16 gs_RCReverb6_len  = (326-gs_TxNumTones);  /* >=(246-NSCus) and <=(2246-NSCus) */
int16 gs_RCReverb7_len  = 617-118;              /* >=128 and <=TBD */
int16 gs_c_params_length;

uint8 guca_R_C_PARAMS_bis[LEN_C_PARAMS_MESSAGE_BYTES+1];
uint8 guca_RMsgs2Tab_bis[R_MSG2_NUM_BYTES_BIS];

int16 gs_NumBytesEachRParamsSymbol;
int16 gs_R_Params_Frame_Len;
uint8 guca_R_PARAMS_bis[LEN_R_PARAMS_MESSAGE_BYTES+MAX_PADDING_BYTES];
int16 gs_NSC_RParams;
uint8 guc_FormRParamsState  = TRAINING_WAITING;
uint8 guc_CrcCalcState  = TRAINING_WAITING;  /*  CRC computation status for received C_PARAMS messages */
int32 gul_RxDescrambleState;
int16 gs_C_Params_Frame_Len;


extern uint16 gusa_PN512Tab[32];
extern int16 *gsa_RxToneBuf;

extern int16 gs_RxFirstChannel, gs_RxLastChannel;
extern int16 gsa_C_COMB_index[C_COMB_INDEX_CNT_G992_5];

FILE *outfd, *infd;

//===============================================================================
//External Function Prototypes
//===============================================================================
extern void CalcCRC16(uint16 *pus_CRC,
               uint16 us_infobit);

extern void CalcCRC16_Byte(int16 *pus_C_CRC, uint8 uc_infoByte);

extern void Gen_PNMedley(uint8 *puca_Buffer, int16 s_Length, uint32 *pul_State);

extern void Gen_MedleyBisTones(int16 *psa_ToneBuf,
                  uint8 *puca_MedleyPNSeq, int16 s_NumBytes, int16 s_NumTones, int16 s_FirstChan,
                  int16 s_constellation_gain);

extern void ToneOrdering(int16 *psa_BAT, int16 s_NumTones, int16 s_MaxBitsPerTone, int16 *psa_ToneIndices);

extern void IfftReal(int16* ps_inbuf,
               int16* ps_outbuf,
               int16 s_fftn,
               int16 s_log2n);

extern void Gen_Comb_Ref_fd(int16 *psa_OutBuf, int16 s_NumChn, int16 *psa_ReverbBuf_fd,
               int16 *psa_ToneArray,
               int16 s_NumXmtdTones);

extern void Scramble(uint8 *puca_Buffer, int16 s_Length, uint32 *pul_State);

extern void TxParamsSig(int16 *psa_ToneBuf, int16 s_TotalNumTones, uint8 *puca_Message, int16 s_NumBytes,
            uint8 *puca_TonesParams,
            int16 s_constellation_gain, int16 s_InsertPilotTone, uint8 uc_PilotToneNumber);

//===============================================================================
//Local Function Prototypes
//===============================================================================
int16 noise(void);
void filter(int16* x, int16* y, int16 len);
void TxOut(int16 *psa_inbuf, int16 s_InbufSize, int16 s_CP_length);


void main(int argc, char *argv[])
{
   int16 sa_C_Reverb_Ref_td[RX_INBUF_FRAME_SIZE];
   int16 sa_C_Segue_Ref_td[RX_INBUF_FRAME_SIZE];
   int16 sa_C_Comb_Ref_td[RX_INBUF_FRAME_SIZE];
   int16 sa_C_IComb_Ref_td[RX_INBUF_FRAME_SIZE];
   int16 sa_C_TRef_Ref_td[RX_INBUF_FRAME_SIZE];
   int16 sa_zero[RX_INBUF_FRAME_SIZE];
   uint8 uc_byte, uca_MedleyBuffer[NUM_C_MEDLEY_BYTES]; // 64 bits for upstream, 512 bits for DS
   int16  i, j, idx, s_byte, s_bitnum, s_temp;
    uint16 us_infobit, gus_C_CRC;
    int16  s_length;
   long l_file_length;

   int16 s_noise_flag = 0;    //0: not adding noise; 1: adding noise
   int16 s_filter_flag = 0;   //0: not applying channel filter; 1: apply channel filter
    int16  extra_0 = 0;       // extra zeros for checking frame alignment

   uint32 ul_scramble_state = 0xFFFFFFFF; // init to all ones.
   uint32 ul_MedleyState;
   int16 s_InsertPilotTone = 0;

   int16 s_LEN_C_PARAMS_MESSAGE_BYTES, s_LEN_C_PARAMS_BITS;

   gs_TxNumTones = 32;

   gs_TxFftLength = TX_FFT_LENGTH;
   gs_TxCPLength = TX_PREFIX_LENGTH;

   gs_RxNumTones = RX_NUM_TONES;
   gs_RxFftLength = RX_FFT_LENGTH;
   gs_RxCPLength = RX_PREFIX_LENGTH;

      /* Compute log2(gs_TxFftLength)-1 = log2(gs_TxFftLength/2) */
   gs_TxLog2FftLength1 = 0;
   s_temp = (gs_TxFftLength >> 1);
   while((s_temp&1) == 0)
   {
      gs_TxLog2FftLength1++;
      s_temp >>= 1;
   }

   /* Compute log2(gs_RxFftLength)-1 = log2(gs_FftLength/2) */
   gs_RxLog2FftLength1 = 0;
   s_temp = (gs_RxFftLength >> 1);
   while((s_temp&1) == 0)
   {
      gs_RxLog2FftLength1++;
      s_temp >>= 1;
   }

   /* Compute log2(gs_RxNumTones) */
   gs_RxLog2NumTones = 0;
   s_temp = (gs_RxNumTones>> 1);
   while((s_temp&1) == 0)
    {
      gs_RxLog2NumTones++;
      s_temp >>= 1;
   }
   gs_RxLog2NumTones++;

   if (gs_TxNumTones == 32) {
#ifndef EXTENDED_REACH_MODE_ON
      gs_RxFirstChannel = 33;
#else
      gs_RxFirstChannel = 6;
#endif


      gs_RxLastChannel = 255;

   }
   else { // Annex B
      gs_RxFirstChannel = 64;
      gs_RxLastChannel = 255;
   }

   //===========================================================================
   //Initialization
   //===========================================================================

   //Init. random number generator
    srand(0);

   //Generate C_Reverb reference signal in frequency domain
   Gen_Reverb_Ref_fd(sa_C_Reverb_Ref_td, GEN_REVERB_TYPE_CO, gs_RxNumTones,
               gs_RxFirstChannel, gs_RxLastChannel, (int16)(DEC_QPSK_GAIN));

    //Get C_Segue signal by reversing C_Reverb signal except at C-TREF Pilot tone (frequency domain)
   for(i=0; i<RX_FFT_LENGTH; i++)
      sa_C_Segue_Ref_td[i] = -sa_C_Reverb_Ref_td[i];

   sa_C_Segue_Ref_td[2*C_TREF_PILOT_TONE] = (int16) DEC_QPSK_GAIN;
   sa_C_Segue_Ref_td[2*C_TREF_PILOT_TONE+1] = (int16) DEC_QPSK_GAIN;

   //Generate C_Comb reference signal in frequency domain
   Gen_Comb_Ref_fd(sa_C_Comb_Ref_td,  gs_RxNumTones, sa_C_Reverb_Ref_td, gsa_Comb_Carriers,
               16);

   //Generate C_Reverb reference signal in time domain
   IfftReal(sa_C_Reverb_Ref_td, sa_C_Reverb_Ref_td, gs_RxNumTones, gs_RxLog2NumTones);

       //Generate C_Segue reference signal in time domain
   IfftReal(sa_C_Segue_Ref_td, sa_C_Segue_Ref_td, gs_RxNumTones, gs_RxLog2NumTones);


   //Generate C_Comb reference signal in time domain
   IfftReal(sa_C_Comb_Ref_td, sa_C_Comb_Ref_td, gs_RxNumTones, gs_RxLog2NumTones);

   //Reverse C_Comb signal to produce C_IComb signal
   for(i=0; i<RX_FFT_LENGTH; i++)
      sa_C_IComb_Ref_td[i] = -sa_C_Comb_Ref_td[i];

   //Generate C_TRef reference signal in frequency domain
   for(i=0; i<RX_FFT_LENGTH; i++)
      sa_C_TRef_Ref_td[i] = 0;

   sa_C_TRef_Ref_td[2*C_TREF_PILOT_TONE] = (int16) DEC_QPSK_GAIN;
   sa_C_TRef_Ref_td[2*C_TREF_PILOT_TONE+1] = (int16) DEC_QPSK_GAIN;

   //Generate C_TRef reference signal in time domain
   IfftReal(sa_C_TRef_Ref_td, sa_C_TRef_Ref_td, gs_RxNumTones, gs_RxLog2NumTones);

   //Make an array of zeros
   for(i=0; i<RX_FFT_LENGTH; i++)
      sa_zero[i] = 0;


    //===========================================================================
   // Open files
   //===========================================================================

   //Open output file
   if((outfd = fopen("tmp_file.bin", "wb")) == NULL) {
      fprintf(stderr, "Cannot open output file\n");
      exit(-1);
   }


   if(argc == 2) {

      //Open Showtime RX input file
      if((infd = fopen(argv[1], "rb")) == NULL) {
         fprintf(stderr, "Cannot open file %s\n", argv[1]);
         exit(-1);
      }
   }

    //===========================================================================
    //4204 symbols of C_QUIET1 without cyclic prefix
   //===========================================================================
   printf("C_QUIET1 (%d)\n", gs_RCQuiet1_len);

    for (j = 0; j < gs_RCQuiet1_len; j++) {

      TxOut(sa_zero, RX_FFT_LENGTH, 0);
    }


    //===========================================================================
    // extra zeros for checking frame alignment
   //===========================================================================

   TxOut(sa_zero, extra_0, 0);


    //===========================================================================
    //128 symbols of C_COMB1 without cyclic prefix
   //===========================================================================
   s_length = 128;
    printf("C_COMB1 (%d)\n", s_length);

    for (j = 0; j < s_length; j++) {

      TxOut(sa_C_Comb_Ref_td, RX_FFT_LENGTH, 0);
    }

    //===========================================================================
    //256 symbols of C_QUIET2 without cyclic prefix
   //===========================================================================
   s_length = 256;
    printf("C_QUIET2 (%d)\n", s_length);

    for (j = 0; j < s_length; j++) {

      TxOut(sa_zero, RX_FFT_LENGTH, 0);

    }

   //===========================================================================
    //3872 symbols of C_COMB2 without cyclic prefix
   //===========================================================================

    printf("C_COMB2 (%d)\n", gs_RCComb2_len);

    for (j = 0; j < gs_RCComb2_len; j++) {

      TxOut(sa_C_Comb_Ref_td, RX_FFT_LENGTH, 0);
    }

   /* optional states */
   //===========================================================================
    //0 or 10 symbols of C_ICOMB1 without cyclic prefix
   //===========================================================================

    printf("C_ICOMB1 (%d)\n", gs_RCIComb1_len);

    for (j = 0; j < gs_RCIComb1_len; j++) {

      TxOut(sa_C_IComb_Ref_td, RX_FFT_LENGTH, 0);
    }

   //===========================================================================
    //0 or 512 symbols of C_LINEPROBE without cyclic prefix
   //===========================================================================

    printf("C_LINEPROBE (%d)\n", gs_RCLineProbe_len);

    for (j = 0; j < gs_RCLineProbe_len; j++) {

      TxOut(sa_zero, RX_FFT_LENGTH, 0);
    }

   //===========================================================================
    //906 symbols of C_QUIET3 without cyclic prefix
   //===========================================================================

    printf("C_QUIET3 (%d)\n", gs_RCQuiet3_len);

    for (j = 0; j < gs_RCQuiet3_len; j++) {

      TxOut(sa_zero, RX_FFT_LENGTH, 0);

    }

   //===========================================================================
    //64 symbols of C_COMB3 without cyclic prefix
   //===========================================================================
   s_length = 64;
    printf("C_COMB3 (%d)\n", s_length);

    for (j = 0; j < s_length; j++) {

      TxOut(sa_C_Comb_Ref_td, RX_FFT_LENGTH, 0);
    }

   //===========================================================================
    //10 symbols of C_ICOMB2 without cyclic prefix
   //===========================================================================
   s_length = 10;
    printf("C_ICOMB2 (%d)\n", s_length);

    for (j = 0; j < s_length; j++) {

      TxOut(sa_C_IComb_Ref_td, RX_FFT_LENGTH, 0);
    }


   //===========================================================================
    // 96 symbols of C_MSG_FMT without cyclic prefix
   //===========================================================================
   s_length = 96;
    printf("C_MSG_FMT (%d)\n", s_length);

   gus_C_CRC = 0x0000;

   /* 2 bytes of C_MSG_FMT. This results in 48 C_MSG_FMT symbols */
    for (j = 0; j < 16; j++) {

        idx = (int16) (j >> 3);
      s_bitnum = (int16) (j & 0x7);
        us_infobit = (uint16) (guca_RCMsgFMTTab[idx] >> s_bitnum);
        us_infobit &= 0x0001;

        if (us_infobit == 1) {      // send 3 consecutive C_IComb
         TxOut(sa_C_IComb_Ref_td, RX_FFT_LENGTH, 0);
         TxOut(sa_C_IComb_Ref_td, RX_FFT_LENGTH, 0);
         TxOut(sa_C_IComb_Ref_td, RX_FFT_LENGTH, 0);
        }
        else {                      // send 3 consecutive C_Comb

         TxOut(sa_C_Comb_Ref_td, RX_FFT_LENGTH, 0);
         TxOut(sa_C_Comb_Ref_td, RX_FFT_LENGTH, 0);
         TxOut(sa_C_Comb_Ref_td, RX_FFT_LENGTH, 0);
        }

        CalcCRC16(&gus_C_CRC, us_infobit);
    }

    // 48 symbols of crc without cyclic prefix
   for (j = 0; j < 16; j++) {

      us_infobit = (uint16) (gus_C_CRC >> j);
        us_infobit &= 0x0001;

        if (us_infobit == 1) {      // send 3 consecutive C_ICOMB

         TxOut(sa_C_IComb_Ref_td, RX_FFT_LENGTH, 0);
         TxOut(sa_C_IComb_Ref_td, RX_FFT_LENGTH, 0);
         TxOut(sa_C_IComb_Ref_td, RX_FFT_LENGTH, 0);

        }
        else {                      // send 3 consecutive C_COMB

         TxOut(sa_C_Comb_Ref_td, RX_FFT_LENGTH, 0);
         TxOut(sa_C_Comb_Ref_td, RX_FFT_LENGTH, 0);
         TxOut(sa_C_Comb_Ref_td, RX_FFT_LENGTH, 0);
        }
    }


   //===========================================================================
    // 96 symbols of C_MSG_PCB without cyclic prefix
   //===========================================================================
   s_length = 96;
    printf("C_MSG_PCB (%d)\n", s_length);

   gus_C_CRC = 0x0000;

   /* 2 bytes of C_MSG_PCB. This results in 48 C_MSG_PCB symbols */
    for (j = 0; j < 16; j++) {

        idx = (int16) (j >> 3);
      s_bitnum = (int16) (j & 0x7);
        us_infobit = (uint16) (guca_RCMsgPCBTab[idx] >> s_bitnum);
        us_infobit &= 0x0001;

        if (us_infobit == 1) {      // send 3 consecutive C_IComb
         TxOut(sa_C_IComb_Ref_td, RX_FFT_LENGTH, 0);
         TxOut(sa_C_IComb_Ref_td, RX_FFT_LENGTH, 0);
         TxOut(sa_C_IComb_Ref_td, RX_FFT_LENGTH, 0);
        }
        else {                      // send 3 consecutive C_Comb

         TxOut(sa_C_Comb_Ref_td, RX_FFT_LENGTH, 0);
         TxOut(sa_C_Comb_Ref_td, RX_FFT_LENGTH, 0);
         TxOut(sa_C_Comb_Ref_td, RX_FFT_LENGTH, 0);
        }

        CalcCRC16(&gus_C_CRC, us_infobit);
    }

    // 48 symbols of crc without cyclic prefix
   for (j = 0; j < 16; j++) {

      us_infobit = (uint16) (gus_C_CRC >> j);
        us_infobit &= 0x0001;

        if (us_infobit == 1) {      // send 3 consecutive C_ICOMB

         TxOut(sa_C_IComb_Ref_td, RX_FFT_LENGTH, 0);
         TxOut(sa_C_IComb_Ref_td, RX_FFT_LENGTH, 0);
         TxOut(sa_C_IComb_Ref_td, RX_FFT_LENGTH, 0);

        }
        else {                      // send 3 consecutive C_COMB

         TxOut(sa_C_Comb_Ref_td, RX_FFT_LENGTH, 0);
         TxOut(sa_C_Comb_Ref_td, RX_FFT_LENGTH, 0);
         TxOut(sa_C_Comb_Ref_td, RX_FFT_LENGTH, 0);
        }
    }

   //===========================================================================
    // 1242 symbols of C_QUIET4 without cyclic prefix
   //===========================================================================
   printf("C_QUIET4 (%d)\n", gs_RCQuiet4_len);

    for (j = 0; j < gs_RCQuiet4_len; j++) {

      TxOut(sa_zero, RX_FFT_LENGTH, 0);

    }

   //===========================================================================
    // (592-80 = 512) symbols of C_REVERB1 without cyclic prefix
   //===========================================================================
   printf("C_REVERB1 (%d)\n", gs_RCReverb1_len);

    for (j = 0; j < gs_RCReverb1_len; j++) {

      TxOut(sa_C_Reverb_Ref_td, RX_FFT_LENGTH, 0);
    }

   //===========================================================================
    // 512 symbols of C_TREF1 without cyclic prefix
   //===========================================================================
   printf("C_TREF1 (%d)\n", gs_RCTref1_len);

    for (j = 0; j < gs_RCTref1_len; j++) {

      TxOut(sa_C_TRef_Ref_td, RX_FFT_LENGTH, 0);
    }

   //===========================================================================
    // 64 symbols of C_REVERB2 without cyclic prefix
   //===========================================================================
   s_length = 64;
    printf("C_REVERB2 (%d)\n", s_length);

    for (j = 0; j < s_length; j++) {

      TxOut(sa_C_Reverb_Ref_td, RX_FFT_LENGTH, 0);
    }

    //===========================================================================
    //512 symbols of C_ECT without cyclic prefix
   //===========================================================================
   s_length = 512;
    printf("C_ECT (%d)\n", s_length);

    for (j = 0; j < s_length; j++) {

      TxOut(sa_zero, RX_FFT_LENGTH, 0);
    }

   //===========================================================================
    // 15936 symbols of C_REVERB3 without cyclic prefix
   //===========================================================================
   printf("C_REVERB3 (%d)\n", gs_RCReverb3_len);

    for (j = 0; j < gs_RCReverb3_len; j++) {

      TxOut(sa_C_Reverb_Ref_td, RX_FFT_LENGTH, 0);
    }

   //===========================================================================
    // 576 symbols of C_TREF2 without cyclic prefix
   //===========================================================================
   s_length = 576;
    printf("C_TREF2 (%d)\n", s_length);

    for (j = 0; j < s_length; j++) {

      TxOut(sa_C_TRef_Ref_td, RX_FFT_LENGTH, 0);
    }

   //===========================================================================
    // 256 symbols of C_REVERB4 without cyclic prefix
   //===========================================================================
   printf("C_REVERB4 (%d)\n", gs_RCReverb4_len);

    for (j = 0; j < gs_RCReverb4_len; j++) {

      TxOut(sa_C_Reverb_Ref_td, RX_FFT_LENGTH, 0);
    }

    //===========================================================================
    //10 symbols of C_SEGUE1 without cyclic prefix
   //===========================================================================
   s_length = 10;
    printf("C_SEGUE1 (%d)\n", s_length);

    for (j = 0; j < s_length; j++) {

      TxOut(sa_C_Segue_Ref_td, RX_FFT_LENGTH, 0);
    }


    //===========================================================================
    // 232 symbols of C_MSG1
   //===========================================================================
   s_length = (LEN_C_MSG1_PREFIX + NUM_C_MSG1_OCTETS)*8+16;
    printf("C_MSG1 (%d)\n", s_length);

    //====================================================================
    // Send C_MSG1 Prefix with cyclic prefix
    //====================================================================
    for (j = 0; j < LEN_C_MSG1_PREFIX*8; j++) {

        idx = (int16) (j >> 3);
      s_bitnum = (int16) (j & 0x7);
        us_infobit = (uint16) (guca_RCMsg1_Prefix[idx] >> s_bitnum);
        us_infobit &= 0x0001;

        if (us_infobit == 0) {      // send C_Reverb

         TxOut(sa_C_Reverb_Ref_td, RX_FFT_LENGTH, RX_PREFIX_LENGTH);

      }
      else {                  // send C_Segue

         TxOut(sa_C_Segue_Ref_td, RX_FFT_LENGTH, RX_PREFIX_LENGTH);

        }

    }
    //====================================================================
    // Send C_MSG1 Options with cyclic prefix
    //====================================================================

    gus_C_CRC = 0x0000;

    for (j = 0; j < NUM_C_MSG1_OCTETS*8; j++) {

        idx = (int16) (j >> 3);
      s_bitnum = (int16) (j & 0x7);
        us_infobit = (uint16) (guca_RCMsgs1Tab[idx] >> s_bitnum);
        us_infobit &= 0x0001;

        if (us_infobit == 0) {      // send C_Reverb

         TxOut(sa_C_Reverb_Ref_td, RX_FFT_LENGTH, RX_PREFIX_LENGTH);

        }
        else {                      // send C_Segue

         TxOut(sa_C_Segue_Ref_td, RX_FFT_LENGTH, RX_PREFIX_LENGTH);

        }

        CalcCRC16(&gus_C_CRC, us_infobit);
    }


    //===========================================================================
    //16 symbols of CRC with cyclic prefix
   //===========================================================================
    for (j = 0; j < 16; j++) {

      us_infobit = (uint16) (gus_C_CRC >> j);
        us_infobit &= 0x0001;

        if (us_infobit == 0) {      // send C_Reverb

         TxOut(sa_C_Reverb_Ref_td, RX_FFT_LENGTH, RX_PREFIX_LENGTH);
        }
        else {                      // send C_Segue

         TxOut(sa_C_Segue_Ref_td, RX_FFT_LENGTH, RX_PREFIX_LENGTH);
        }

    }


   //===========================================================================
    // gs_RCReverb5_len symbols of C_REVERB5 with cyclic prefix
   //===========================================================================
   printf("C_REVERB5 (%d)\n", gs_RCReverb5_len);

    for (j = 0; j < gs_RCReverb5_len; j++) {

      TxOut(sa_C_Reverb_Ref_td, RX_FFT_LENGTH, RX_PREFIX_LENGTH);
    }

   //===========================================================================
    //10 symbols of C_SEGUE2 with cyclic prefix
   //===========================================================================
   s_length = 10;
    printf("C_SEGUE2 (%d)\n", s_length);

    for (j = 0; j < s_length; j++) {

      TxOut(sa_C_Segue_Ref_td, RX_FFT_LENGTH, RX_PREFIX_LENGTH);
    }


    //===========================================================================
    //512*CA_MEDLEYus symbols of C_MEDLEY with cyclic prefix
   //===========================================================================
   s_length = 512*PMD_TC_OCTET19;
    printf("C_MEDLEY (%d)\n", s_length);

   /* ul_MedleyState holds previous 32 bits of Medley sequence. First symbol has to be
   treated separately because we need to initialize first 23 bits of PN sequence to 1 */
   ul_MedleyState = 0x007FFFFF;

   uca_MedleyBuffer[0] = 0xFF; // copy to byte buffer
   uca_MedleyBuffer[1] = 0xFF;
   uca_MedleyBuffer[2] = 0x7F;
   uca_MedleyBuffer[3] = 0x00;

   // Generate PN sequence (different for first frame: 60 extra bytes (in the DS) to be generated because first 4 bytes are defined as above)
   Gen_PNMedley(&uca_MedleyBuffer[4], (int16)(NUM_C_MEDLEY_BYTES-4), &ul_MedleyState);

   for (j=0; j < s_length; j++)
   {
      // Modulate into tone buffer
      Gen_MedleyBisTones(gsa_RxToneBuf, uca_MedleyBuffer, (int16)NUM_C_MEDLEY_BYTES, gs_RxNumTones, gs_RxFirstChannel, (int16)DEC_QPSK_GAIN);

       // clear unsued freuqnecies
        for (i = 0; i < gs_RxFirstChannel; i++) {
            gsa_RxToneBuf[(2*i)]     = 0;
            gsa_RxToneBuf[(2*i) + 1] = 0;
        }

        // clear unsued freuqnecies
        for (i = (gs_RxLastChannel + 1); i < gs_RxNumTones; i++) {
            gsa_RxToneBuf[(2*i)]     = 0;
            gsa_RxToneBuf[(2*i) + 1] = 0;
        }


      gsa_RxToneBuf[2*C_TREF_PILOT_TONE] = (int16) DEC_QPSK_GAIN;
      gsa_RxToneBuf[2*C_TREF_PILOT_TONE+1] = (int16) DEC_QPSK_GAIN;

      //====================================================================
      //Do IFFT on the current frame
      //====================================================================
      IfftReal(gsa_RxToneBuf, gsa_TxOutBuf,gs_RxNumTones, gs_RxLog2NumTones);

      TxOut(gsa_TxOutBuf, RX_FFT_LENGTH, RX_PREFIX_LENGTH);

      //Generate new packed PN sequence
      Gen_PNMedley(uca_MedleyBuffer, (int16)NUM_C_MEDLEY_BYTES, &ul_MedleyState);


   }

   //===========================================================================
    // 64 symbols of C_EXCHMARKER with cyclic prefix
   //===========================================================================
   s_length = 64;
    printf("C_EXCHMARKER (C_REVERB) (%d)\n", s_length);

    for (j = 0; j < s_length; j++) {

      TxOut(sa_C_Reverb_Ref_td, RX_FFT_LENGTH, RX_PREFIX_LENGTH);
    }

   //=============================================================================
   // (32+16) symbols of C_MSG2 and 2 symbols of R_CRC3
   //=============================================================================
   printf("C_MSG2 (%d)\n", gs_TxNumTones+16);

    gus_C_CRC = 0x0000;

   for (j = 0; j < 4; j++)
      guca_RCMsgs2Tab[j] = 0; // Clear MSG2 array

   for (j=0; j < NSC_R_PARAMS; j++) {
      uc_byte = guca_Tones_RCMsg2[j];
      idx = (int16)(uc_byte >> 3);
      s_bitnum = (int16)(uc_byte & 0x07);
      // idx has the byte position, s_bitnum has the bit pos...
      guca_RCMsgs2Tab[idx] |= (0x1 << s_bitnum);
   }

    for (j = 0; j < gs_TxNumTones; j++) {

        idx = (int16) (j >> 3);
      s_bitnum = (int16) (j & 0x7);
        us_infobit = (uint16) (guca_RCMsgs2Tab[idx] >> s_bitnum);
        us_infobit &= 0x0001;

        if (us_infobit == 0) {      // send C_Reverb

         TxOut(sa_C_Reverb_Ref_td, RX_FFT_LENGTH, RX_PREFIX_LENGTH);

        }
        else {                      // send C_Segue

         TxOut(sa_C_Segue_Ref_td, RX_FFT_LENGTH, RX_PREFIX_LENGTH);

        }

        CalcCRC16(&gus_C_CRC, us_infobit);
    }


    //===========================================================================
    //16 symbols of CRC with cyclic prefix
   //===========================================================================
    for (j = 0; j < 16; j++) {

      us_infobit = (uint16) (gus_C_CRC >> j);
        us_infobit &= 0x0001;

        if (us_infobit == 0) {      // send C_Reverb

         TxOut(sa_C_Reverb_Ref_td, RX_FFT_LENGTH, RX_PREFIX_LENGTH);
        }
        else {                      // send C_Segue

         TxOut(sa_C_Segue_Ref_td, RX_FFT_LENGTH, RX_PREFIX_LENGTH);
        }

    }

   //===========================================================================
    // (2384-32) symbols of C_REVERB6 with cyclic prefix
   //===========================================================================

    printf("C_REVERB6 (%d)\n", gs_RCReverb6_len);

    for (j = 0; j < gs_RCReverb6_len; j++) {

      TxOut(sa_C_Reverb_Ref_td, RX_FFT_LENGTH, RX_PREFIX_LENGTH);
    }

   //===========================================================================
    // 10 symbols of C_SEGUE3 with cyclic prefix
   //===========================================================================
   s_length = 10;
    printf("C_SEGUE3 (%d)\n", s_length);

    for (j = 0; j < s_length; j++) {

      TxOut(sa_C_Segue_Ref_td, RX_FFT_LENGTH, RX_PREFIX_LENGTH);
    }

   //===========================================================================
    // LEN_C_PARAMS symbols of C_PARAMS with cyclic prefix
   //===========================================================================
   s_LEN_C_PARAMS_MESSAGE_BYTES = ((LEN_C_PARAMS_PMD_HEADER + 1 + 2*(gs_TxNumTones-1) + (gs_TxNumTones-1)) + LEN_C_PARAMS_PMS + LEN_C_PARAMS_CRC);
   s_LEN_C_PARAMS_BITS = s_LEN_C_PARAMS_MESSAGE_BYTES*8;
   gs_c_params_length = (int16)(ceil(((double)s_LEN_C_PARAMS_BITS/(double)(2*NSC_C_PARAMS))));
   printf("C_PARAMS (%d)\n", gs_c_params_length);

   // Create a tone ordering table (G992.1 compatible...)
   ToneOrdering(gsa_TxBat, gs_TxNumTones, (int16)TX_MAX_BITS_PER_TONE, gsa_TxToneOrder);

    gus_C_CRC = 0x0000;

   // Create C_Params message
   for(j=0; j< LEN_C_PARAMS_PMD_HEADER; j++)
   {
      guca_CRParamsTab[j] = guca_CRParamsPMD[j]; // first copy PMD header
      CalcCRC16_Byte(&gus_C_CRC, guca_CRParamsTab[j]);
   }

   idx = LEN_C_PARAMS_PMD_HEADER;
   for(j=1; j< gs_TxNumTones; j++) { // start from tone 1 to 32
      guca_CRParamsTab[idx] = (uint8)((gsa_FineGains[j] & 0xF0) | (gsa_TxBat[j] & 0x0F));
      CalcCRC16_Byte(&gus_C_CRC, guca_CRParamsTab[idx++]);
      guca_CRParamsTab[idx] = (uint8)(gsa_FineGains[j] >> 8);
      CalcCRC16_Byte(&gus_C_CRC, guca_CRParamsTab[idx++]);
   }
   guca_CRParamsTab[idx] = 0x00; // reserved byte
   CalcCRC16_Byte(&gus_C_CRC, guca_CRParamsTab[idx++]);

   // Put tone ordering table...
   for(j=1; j< gs_TxNumTones; j++)
   {
      guca_CRParamsTab[idx] = (uint8)gsa_TxToneOrder[j];
      CalcCRC16_Byte(&gus_C_CRC, guca_CRParamsTab[idx++]);
   }

   // PMS Parameters
   for (j=0; j < LEN_C_PARAMS_PMS; j++)
   {
      guca_CRParamsTab[idx] = guca_CRParamsPMS[j];
      CalcCRC16_Byte(&gus_C_CRC, guca_CRParamsTab[idx++]);
   }

   guca_CRParamsTab[idx++] = (uint8)(gus_C_CRC & 0xFF); //LSB's of CRC
   guca_CRParamsTab[idx++] = (uint8)(gus_C_CRC >> 8);

   gs_NumBytesToPad = (2 * NSC_C_PARAMS * gs_c_params_length - (int16)s_LEN_C_PARAMS_BITS) >> 3;
   for (j=0;j < gs_NumBytesToPad; j++)
      guca_CRParamsTab[idx++] = 0;  // pad with zeros

   // Scramble message...
   Scramble(guca_CRParamsTab, (int16)(s_LEN_C_PARAMS_MESSAGE_BYTES+gs_NumBytesToPad), &ul_scramble_state);

   /* check if C_TREF pilot signal is part of the set of NSC_PARAMS subcarriers */

    s_InsertPilotTone =1;
   for(j=0; j<NSC_C_PARAMS; j++)
   {
      if(guca_Tones_RMsg2[j] == C_TREF_PILOT_TONE)
      s_InsertPilotTone = 0;
   }

   gs_NumBytesInParamsSymbol = ((2*NSC_C_PARAMS) >> 3);  /* modulate 2*NSC_C_PARAM bits per symbol */

   // Transmit C_PARAMS message
   for (j=0; j < gs_c_params_length; j++)
   {

      idx = j * gs_NumBytesInParamsSymbol;   /* modulate 2*NSC_C_PARAM bits per symbol */
      TxParamsSig(gsa_RxToneBuf, gs_RxNumTones, &guca_CRParamsTab[idx], gs_NumBytesInParamsSymbol,
               guca_Tones_RMsg2, (int16)DEC_QPSK_GAIN, s_InsertPilotTone, (uint8)C_TREF_PILOT_TONE);

      IfftReal(gsa_RxToneBuf, gsa_TxOutBuf,gs_RxNumTones, gs_RxLog2NumTones);

      TxOut(gsa_TxOutBuf, RX_FFT_LENGTH, RX_PREFIX_LENGTH);


   }


   //===========================================================================
    // 617 symbols of C_REVERB7 with cyclic prefix
   //===========================================================================
   s_length = 617-118;
    printf("C_REVERB7 (%d)\n", s_length);

    for (j = 0; j < s_length; j++) {

      TxOut(sa_C_Reverb_Ref_td, RX_FFT_LENGTH, RX_PREFIX_LENGTH);
    }

   //===========================================================================
    // 10 symbols of C_SEGUE4 with cyclic prefix
   //===========================================================================
   s_length = 10;
    printf("C_SEGUE4 (%d)\n", s_length);

    for (j = 0; j < s_length; j++) {

      TxOut(sa_C_Segue_Ref_td, RX_FFT_LENGTH, RX_PREFIX_LENGTH);
    }

   if(argc == 1) {

      //===========================================================================
      //Put out some more symbols to allow state machine runs through
      //===========================================================================
      s_length = 20;
      for(j=0; j<s_length; j++) {

         TxOut(sa_C_Segue_Ref_td, RX_FFT_LENGTH, RX_PREFIX_LENGTH);
      }
   }
   else if(argc == 2) {

      //===========================================================================
      //(N*69) symbols of showtime sequence transmitted from ATU-R
      //This sequence is mainly used to test the SNR calculation and FDQ adaptation.
      //N must be greater than max(SHOWT_NUM_SNR_TRAINING_SYMBOLS, NUM_FDQ_TRAINING_SYMBOLS)
      //===========================================================================
      printf("R_SHOWTIME_TX (indefinite)\n");

      //Find out input file length (in bytes)
      fseek(infd, 0L, SEEK_END);
      l_file_length = ftell(infd);

      //number of samples in the file
      l_file_length >>= 1;

      //number of symbols in the file
      l_file_length = l_file_length/(long)(RX_FFT_LENGTH+RX_PREFIX_LENGTH);

      //number of superframes in the file
      l_file_length = l_file_length/(long)(69);

      //Generate (max(SHOWT_NUM_FDQ_TRAINING_SYMBOLS, NUM_SNR_TRAINING_SYMBOLS) + 4) number
      //of superframes
      for(j=0; j<(max(NUM_FDQ_TRAINING_SYMBOLS, (1 << OPTNArray[OPTN_Log2NumShowtimeSNRTrainingSymbols])) + RX_NUM_TONES+2); j++) {

         //rewind the input file every "l_file_length" superframes
         if((j%((int16)l_file_length)) == 0) {
            rewind(infd);
         }

         //Read 68 data frames (symbols) from input file
         for(i=0; i<68; i++) {

            //read one symbol from input file
            s_byte = fread(gsa_TxOutBuf, sizeof(int16), (RX_FFT_LENGTH+RX_PREFIX_LENGTH), infd);
            if(s_byte < (RX_FFT_LENGTH+RX_PREFIX_LENGTH)) {
               fprintf(stderr,"not enough data in %s\n", argv[1]);
               exit(-1);
            }

            //process by channel and write it out
            TxOut(gsa_TxOutBuf, (RX_FFT_LENGTH+RX_PREFIX_LENGTH), 0);
         }

         //read synch symbol but replace it by a right reverb symbol
         fread(gsa_TxOutBuf, sizeof(int16), (RX_FFT_LENGTH+RX_PREFIX_LENGTH), infd);

         //replace the synch symbol by synch symbol corresponding to ATU-R's synch symbol
         TxOut(sa_C_Reverb_Ref_td, RX_FFT_LENGTH, RX_PREFIX_LENGTH);
      }
   }

   if(outfd != NULL)
      fclose(outfd);

   if(infd != NULL)
      fclose(infd);


   //Process the output file by channel
   if((infd = fopen("tmp_file.bin", "rb")) == NULL) {
      fprintf(stderr, "Cannot open file tmp_file.bin\n");
      exit(-1);
   }

   //Open output file
   if((outfd = fopen("train.bin", "wb")) == NULL) {
      fprintf(stderr, "Cannot open file tr2show.bin\n");
      exit(-1);
   }


   //Add noise to output file if desired
   while(1) {
      s_length = fread(gsa_TxOutBuf, sizeof(int16), RX_INBUF_FRAME_SIZE, infd);

      if(s_length > 0) {
         if(s_noise_flag) {
            for(i=0; i<s_length; i++)
               gsa_TxOutBuf[i] += noise();
         }
         if(s_filter_flag) {
            filter(gsa_TxOutBuf, gsa_TxOutBuf, s_length);
         }

         fwrite(gsa_TxOutBuf, sizeof(int16), s_length, outfd);
      }
      else
         break;
   }

   if(outfd != NULL)
      fclose(outfd);

   if(infd != NULL)
      fclose(infd);


   //remove the tmp_file.bin
   if(remove ("tmp_file.bin") == -1)
      fprintf(stderr, "cannot remove tmp_file.bin\n");

   exit(0);

}

int16 noise()
{

    int16 s_noise;

    s_noise = (rand() - RAND_MAX/2) >> 8;
    //s_noise = 0;

    return s_noise;

}

void filter(int16* x, int16* y, int16 len)
{

    int16    n,i;
    int32   y0;
    int32   Acc0;

    for (n = 0; n < len; n++) {

        // clear output
        y0 = 0;

        //=================
        // compute FIR part
        //=================

        //update FIR memory
        for (i = (FIR_LEN - 1); i > 0; i--) {
            gsa_x_mem[i] = gsa_x_mem[i-1];
        }
        gsa_x_mem[0] = x[n];

        //apply FIR
        for (i = 0; i < FIR_LEN; i++) {
            Acc0 = gsa_x_mem[i] * gsa_b[i];
            y0 = l_add(y0, Acc0);
        }

        //=================
        // compute IIR part
        //=================

        //update IIR memory
        for (i = (IIR_LEN - 1); i > 0; i--) {
            gsa_y_mem[i] = gsa_y_mem[i-1];
        }

        //apply IIR
        for (i = 1; i < IIR_LEN; i++) {
            Acc0 = gsa_y_mem[i] * gsa_a[i];
            Acc0 *= -1;

            y0 = l_add(y0, Acc0);
        }

        gsa_y_mem[0] = (int16) (round(y0,15));
        y[n] = gsa_y_mem[0];

    }
}

void TxOut(int16 *psa_inbuf, int16 s_InbufSize, int16 s_CP_length)
{
   int16 i, s_length;

   int16 s_outbuf[RX_FFT_LENGTH+RX_PREFIX_LENGTH];

   s_length = s_InbufSize + s_CP_length;

   for(i = 0; i < s_CP_length; i++)
      s_outbuf[i] = psa_inbuf[s_InbufSize - s_CP_length + i];

   for(i=0; i<s_InbufSize; i++)
      s_outbuf[i+s_CP_length] = psa_inbuf[i];

   //Write to output file
   fwrite(s_outbuf, sizeof(int16), s_length, outfd);

}
