/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*********************************************************************************/
/* Test code to verify Bitload BIS
/* Standalone code
/* Sets up the handshake parameters and calls BgMedley_bitload
/* Takes predefined SNRs, defined in snr_data.c; we also have best option 60 dB on all tones,
/* to test pms selection such that gs_TotalBitsSupported is not the limiting factor

  /* Runs for two cases : 1) Trellis is on
  2) Trellis off

   /* Runs through a set of max data rates, max latency and min overhead rates
   /* Output is in files results_pms_trellis_on.dat & results_pms_trellis_off.dat


/********************************************************************************/
#define TESTALL
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "typedef.h"
#include "gdata_bis.h"
#include "bitload_bis.h"
#include "gdata.h"
#include "bitload2.h"
#include "bitload.h"
#include "bitload_const.h"
#include "compiler.h"
#include "cmv.h"
#include "cmv_data.h"
#include "const.h"
#include "statein1.h"
#include "states.h"
#include "changebat.h"
#include "pll.h"
#include "snr_data.h"

#include "ComputeRMSFineGain.h"
#include "snr.h"
#include "decimalgain.h"
#include "showinit.h"
#include "dsp_op.h"
#include "ghs.h"
#include "hndshk_Data.h"
#include "memsetbf.h"

// Local functions
C_SCOPE int16 VerifyBat(uint8 *psa_Bat);

// Define local buffers for SNRs, BAT.
int16 *gsa_my_MedleySnrBuf;

int16 gsa_my_RxShowtimeSnrBuf[256];

int16 gsa_my_RxShowtimeSnrBuf_Plus[512];

int16 gsa_my_RxFineGains[RX_NUM_TONES];
int16 gsa_my_RxToneOrder[RX_NUM_TONES];

int16 gs_maxdatarate_in;

FILE *file_pms;
FILE *file_pms1;

int16 gs_maxlatency;
int16 s_maxintlvdepth;
extern int16  gs_iter_conv;
extern int16 gs_found_valid_config, gs_flag_fixedrate, gs_tcm_coding_gain, gs_max_coding_gain, gs_flag_limitedrate;

extern int16  gsa_my_MedleySnrBuf_10kft[256],  gsa_my_MedleySnrBuf_0kft[256], gsa_my_MedleySnrBuf_16kft[256],gsa_my_MedleySnrBuf_18kft[256], gsa_my_MedleySnrBuf_test[256], gsa_my_MedleySnrBuf_18kft_500bt[256];
extern int16 gsa_test_snr_increase[256], gsa_test_snr_decrease[256], gsa_test_snr_increase_decrease[256], gsa_my_MedleysnrBuf_3kft[256], gsa_my_MedleySnrBuf_longloop[256], gsa_my_MedleySnrBuf_longloop1[256];
extern int16 gsa_Med_1kft_Plus[512], gsa_Med_0kft_Plus[512];
extern int16 gsa_med_constructed_nullloop[512];
extern int16 gsa_my_MedleySnrBuf_plus[512];
extern int16 gsa_my_MedleySnrBuf_plus_9kft[512];
extern int16 gsa_my_MedleySnrBuf_plus_12kft[512];
extern int16 gsa_my_MedleySnrBuf_plus_13kft[512];
extern int16 gs_MSGc_final, gs_seq_final, gs_per_final;
extern FlagT gft_EnableNomATP;
extern int16 gsa_my_MedleySnrBuf_0ft_plus[512];

int16 gs_BytesForBC0_final, gs_BytesForBC1_final, gs_Kp_MDF_final, gs_Dp_final, gs_Mp_final;
int16 gs_Rp_final, gs_Lp_final, gs_Tp_final, gs_TCM_Oh_final, gs_CWSize_final, gs_Sp_final;
int16  gs_net_datarate_final, gs_ovhd_rate_final, gs_latency_final;

int16 gs_ovhdrate_in, gs_INP_in, s_max_datarate_lim = 3073,j, i_desired_margin;
int16 s_iter_total, test_run, test_case;
int16 s_Lp_est, s_ncloaded_est,s_TCM_Oh_est;
float datarate_final, datarate_diff, datarate_msgc;
char file_tcm_on[50], file_tcm_off[50];

int16 s_RSCodingGain, s_error_code = 0, s_max_margin = 0, s_desired_margin, step_rate;
int32 l_Prod;
int16 Desired_Margin[5] = {0, 589, 1536, 3072, 4096};  // Desired margin 8.8
int16 Max_Margin[7] = {0, 60, 100, 150, 310, 510, 511 };  // Max margin 10* dB value

int16  gs_DS_RateOption;               /* final downstream rate option */
RMsgRA_t gt_RMsgRA;
RMsg2_t gt_RMsg2;                /* R_MSG2 parameters */
Option_t gta_DS_options[NUM_DS_RATE_OPTIONS];
int16 s_delta_Lp, s_ActualDeltaSumLp, s_OhTcm;
int16 gsa_RxFineGainsLin[RX_NUM_TONES];
int16  gs_supportedDvalues[21];
int16 save_myD_Values_Old[21]={64, 32, 16, 8, 4, 2, 1};
int16 save_myD_Values_New[21]={511,480, 448, 416,384,352, 320, 288, 256, 224, 192, 160, 128,96, 64, 32, 16, 8, 4, 2, 1};

DebugTrailTriggerControl_t gt_debugTrailTriggerControl;
DebugTrailCollectControl_t gt_debugTrailCollectControl;

uint16 gusa_DS_Tssi_Value1[512]={ 1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1014,
       1004,
        995,
        985,
        976,
        967,
        958,
        949,
        940,
        931,
        923,
        914,
        906,
        897,
        889,
        881,
        872,
        864,
        856,
        848,
        840,
        832,
        824,
        816,
        809,
        801,
        794,
        786,
        779,
        771,
        764,
        757,
        750,
        743,
        736,
        729,
        722,
        715,
        708,
        702,
        695,
        689,
        682,
        676,
        669,
        663,
        657,
        651,
        644,
        638,
        633,
        627,
        621,
        615,
        609,
        603,
        598,
        592,
        586,
        581,
        575,
        570,
        564,
        559,
        554,
        549,
        543,
        538,
        533,
        528,
        523,
        518,
        513,
        509,
        504,
        499,
        494,
        490,
        485,
        480,
        476,
        472,
        467,
        463,
        458,
        454,
        450,
        445,
        441,
        437,
        433,
        429,
        425,
        421,
        417,
        413,
        409,
        405,
        401,
        398,
        394,
        390,
        387,
        383,
        379,
        376,
        372,
        369,
        365,
        362,
        359,
        355,
        352,
        349,
        345,
        342,
        339,
        336,
        332,
        329,
        323,
        323,
        323,
        322,
        322,
        322,
        321,
        321,
        321,
        320,
        320,
        319,
        319,
        319,
        318,
        318,
        318,
        317,
        317,
        317,
        316,
        316,
        316,
        315,
        315,
        315,
        314,
        314,
        313,
        313,
        313,
        312,
        312,
        312,
        311,
        311,
        311,
        310,
        310,
        310,
        309,
        309,
        309,
        308,
        308,
        308,
        307,
        307,
        307,
        306,
        306,
        305,
        305,
        305,
        304,
        304,
        304,
        303,
        303,
        303,
        302,
        302,
        302,
        301,
        301,
        301,
        300,
        300,
        300,
        299,
        299,
        299,
        298,
        298,
        298,
        297,
        297,
        297,
        296,
        296,
        296,
        295,
        295,
        295,
        294,
        294,
        294,
        293,
        293,
        293,
        292,
        292,
        292,
        291,
        291,
        291,
        290,
        290,
        290,
        289,
        289,
        289,
        288,
        288,
        288,
        287,
        287,
        287,
        287,
        286,
        286,
        286,
        285,
        285,
        285,
        284,
        284,
        284,
        283,
        283,
        283,
        282,
        282,
        282,
        281,
        281,
        281,
        280,
        280,
        280,
        280,
        279,
        279,
        279,
        278,
        272};

      int16 s_FGainLin, s_MaxNomATP_DS, s_NOMATP_DS;
      int16 s_temp, s_nomATP_dB;

      int32 l_SumFGainLinSq, l_SumFGainLinSq_sub, l_AddGiSqTssiSq, l_GiSqTssiSq, l_test;
      float float_nomATP_dB;

#define DEFAULT_NOMPSD_DS  -40               /* absolute default DS NOMPSD (dBm/Hz) */
#define DEFAULT_MAXNOMATP_DS_204 204            /* absolute default DS MAXNOMATP*10 (0.1 dB step-size) */
#define TEN_LOG_DELTA_F (9305)         /* 36.35 = 10*log10(4312.5) in Q8.8 */
#define C_10LOG10_2 (771)              /* 10log10(2) in Q8.8 */

      // global variables
#define RX_MAX_BITS_PER_TONE     (15)        /*  maximum number of bits per tone at RX */

#define OPTN_FavorINPOverRate          0x0800   // Favor INP = 2frames over rate in case handshake INP is less

      int16 gs_maxlatency_array;
      int16 s_savelatencyvalue[7]={1, 2, 4, 8, 16, 32, 63};

      //int16 gs_OneOverSminADSL2;

      // Dummy function.  We don't need this functionality for this test.
      void DebugTrail(int16 s_count, ... )
      {}

      void copy_my_medley_snr(int16 *psa_destBuf, int16 *psa_srcBuf)
      {
         int16 i;

         for (i = 0; i < 512; i++)
         {
            psa_destBuf[i] = psa_srcBuf[i];
         }
      }

      int main(int argc, char **argv)
      // void main()
      {
         int16 i;
         int32 gl_Rx_Total_Power=0;                      /*  average received signal power */
         int16 INP;
         int16 s_BatCheck;
         float s_actual_inp;
         int16 s_path=2;


         /*******************************************************************************
         Initialize Global Variables
         ********************************************************************************/
         gs_TxNumTones = 32;

         if (gs_TxNumTones == 32) {

#ifndef EXTENDED_REACH_MODE_ON
            gs_RxFirstChannel = 33;
#else
            gs_RxFirstChannel = 6;
#endif


            gs_RxLastChannel = 255;

         }
         else { // Annex B
            gs_RxFirstChannel = 64;
            gs_RxLastChannel = 255;
         }

         /* for cocomo testing limit the max CWSize to be 240; this is because of bm limitation of
         TDP CO, will be removed in next upgrade*/
#ifdef WIN32
         gs_max_CWSize = 247;
#else
         gs_max_CWSize = 255;
#endif

         gs_RxBitLoadFirstChannel = gs_RxFirstChannel;
         gs_RxBitLoadLastChannel = gs_RxLastChannel;

         gft_FineGainOn = TRUE;

         gs_max_fine_gain =  640;      // 2.5dB in Q 8.8
         gs_min_fine_gain = -640;      // -2.5dB in Q8.8


         guca_RSCodingGain[0] = 0;
         guca_RSCodingGain[1]= RS_CODING_GAIN_2;
         guca_RSCodingGain[2]= RS_CODING_GAIN_4;
         guca_RSCodingGain[3]= RS_CODING_GAIN_6;
         guca_RSCodingGain[4]= RS_CODING_GAIN_8;
         guca_RSCodingGain[5]= RS_CODING_GAIN_10;
         guca_RSCodingGain[6]= RS_CODING_GAIN_12;
         guca_RSCodingGain[7]= RS_CODING_GAIN_14;
         guca_RSCodingGain[8]= RS_CODING_GAIN_16;


         //gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_16kft;
         // gsa_my_MedleySnrBuf = gsa_my_MedleysnrBuf_3kft;
         gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_0kft;

         //gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_test;

         // Point Task layer pointers to locally defined buffers.

         copy_my_medley_snr(gsa_MedleySnrBuf, gsa_my_MedleySnrBuf);

         gsa_RxShowtimeSnrBuf = gsa_my_RxShowtimeSnrBuf;
         gsa_RxFineGains = gsa_my_RxFineGains;
         gsa_RxToneOrder = gsa_my_RxToneOrder;



         for (i=0 ; i< RX_NUM_TONES ; i++)
         {
            gsa_RxToneOrder[i] = i;
         }
         for (i=gs_RxFirstChannel ; i<=gs_RxLastChannel ; i++)
            SETTONEFLAG(p_MEDLEYset_DS, i);

         // define BIS for standalone test
         gft_ModemType = G_DMT_BIS;

         STATArray[STAT_Mode] = STAT_ConfigMode_G992_3_A;

         gt_HandshakeBis.s_OneOverSminADSL2 = 2;

         gl_SelectedMode = MODE_G992_3 | ANNEX_A;

         /*  We re-allocate the default values to the HS_BIS structure before entering bit-loading. */
         gt_HandshakeBis.sa_DS_MaxCheckbytesLP[LP0_DATA_PATH] = (int16) (2* MAX_R_LP0_DS);
         gt_HandshakeBis.sa_DS_MaxIntlvDepthLP[LP0_DATA_PATH] = (int16) 64;


         guc_MaxAllocBitsPerTone = RX_MAX_BITS_PER_TONE;

         gs_CPilotTone = C_PILOT_TONE_64;

         gs_AuxPilotToneIdx = gs_CPilotTone;
         gft_AuxPilot = AUX_PILOT_DISABLE;

         OPTNArray[OPTN_AlgControl2] = !OPTN_FavorINPOverRate;
         for(i=0; i<21; i++)
         {
            gs_supportedDvalues[i] = save_myD_Values_Old[i];
         }

#ifdef TESTALL

         for (test_run=0; test_run < 4; test_run++)
         {
            // First two cases run min = max
            if(test_run==0) // set the parameters for tcm on
            {
               file_pms=fopen(argv[1],"w");
               //       file_pms=fopen("test1.txt","w");
               OPTNArray[OPTN_AlgControl] = 0x0FF8;
               gs_tcm_coding_gain = TCM_CODING_GAIN;
               gs_max_coding_gain = MAX_CODING_GAIN;
            }

            if (test_run==1)
            {
               file_pms=fopen(argv[2],"w");
               //       file_pms=fopen("test2.txt","w");
               OPTNArray[OPTN_AlgControl] = 0x2FF8;
               gs_tcm_coding_gain = 0;
               gs_max_coding_gain = MAX_CODING_GAIN;
            }

            if(test_run==2) // set the parameters for tcm on
            {
               file_pms=fopen(argv[3],"w");
               //       file_pms=fopen("test3.txt","w");
               OPTNArray[OPTN_AlgControl] = 0x0FF8;
               gs_tcm_coding_gain = TCM_CODING_GAIN;
               gs_max_coding_gain = MAX_CODING_GAIN;
            }

            if (test_run==3)
            {
               file_pms=fopen(argv[4],"w");
               //       file_pms=fopen("test4.txt","w");
               OPTNArray[OPTN_AlgControl] = 0x2FF8;
               gs_tcm_coding_gain = 0;
               gs_max_coding_gain = MAX_CODING_GAIN;
            }

            /*  SNR's (in dB) required for QAM */

            gsa_ConstellationSNR[0] = 0x0B4F;   /*  11.31 dB =  1 bit (NOT USED) */
            gsa_ConstellationSNR[1] = 0x0B4F;   /*  11.31 dB =  1 bit (NOT USED) */
            gsa_ConstellationSNR[2] = 0x0E51; /*  14.32 dB =  2 bits  */
            gsa_ConstellationSNR[3] = 0x131C;   /*  19.11 dB =  3 bits */
            gsa_ConstellationSNR[4] = 0x154F;   /*  21.31 dB =  4 bits */
            gsa_ConstellationSNR[5] = 0x1875;   /*  24.46 dB =  5 bits */
            gsa_ConstellationSNR[6] = 0x1B8A;   /*  27.54 dB =  6 bits */
            gsa_ConstellationSNR[7] = 0x1E97;   /*  30.59 dB =  7 bits */
            gsa_ConstellationSNR[8] = 0x219C;   /*  33.61 dB =  8 bits */
            gsa_ConstellationSNR[9] = 0x24A1;   /*  36.63 dB =  9 bits */
            gsa_ConstellationSNR[10] = 0x27A6; /*  39.65 dB = 10 bits */
            gsa_ConstellationSNR[11] = 0x2AA8; /*  42.66 dB = 11 bits */
            gsa_ConstellationSNR[12] = 0x2DAB; /*  45.67 dB = 12 bits */
            gsa_ConstellationSNR[13] = 0x30AE;  /*  48.68 dB = 13 bits */
            gsa_ConstellationSNR[14] = 0x33B0; /*  51.69 dB = 14 bits */
            gsa_ConstellationSNR[15] = 0x36B3; /*  54.70 dB = 15 bits */

            fprintf(file_pms, "INP\t maxrate\t msg_ovhdrate\t maxlatency\t Kp\t Dp\t Mp\t Rp\t Lp\t Tp\t CWSize\t Sp(8.8)\t net_datarate\t ovhd_rate\t latency_achvd\t INP_achvd\t  datarate\t diff_rate\t Ex_code\t  SEQp\t MSGc\t PERp\t MSGc_rate\t\n");

            /***********************************************************************
            Loop thru various values of max data rate, overhead rate and latency

            ***********************************************************************/
            for (gs_INP_in = 0 ; gs_INP_in < 7 ; gs_INP_in++)
            {

               if (gs_INP_in == 0)
               {
                  /* Initialize the handshake parameters for standalone test */
                  gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 0;
                  s_actual_inp = 0;
               }
               else if (gs_INP_in == 1)
               {
                  gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 1; // 0.5 frame protection
                  s_actual_inp = 0.5;
               }
               else if (gs_INP_in == 2)
               {
                  gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 2; // 1 frame protection
                  s_actual_inp = 1;
               }
               else if (gs_INP_in == 3)
               {
                  gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 4; // 2 frame protection
                  s_actual_inp = 2;
               }
               else if (gs_INP_in == 4)
               {
                  gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 8; // 4 frame protection
                  s_actual_inp = 4;
               }
               else if (gs_INP_in == 5)
               {
                  gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 16 ;// 8 frame protection
                  s_actual_inp = 8;
               }
               else if (gs_INP_in == 6)
               {
                  gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 32; // 16 frame protection
                  s_actual_inp = 16;
               }




               if(gs_INP_in <= 1)
                  s_max_datarate_lim = 3200;
               else
                  s_max_datarate_lim = min(4 * gt_HandshakeBis.sa_DS_MaxCheckbytesLP[LP0_DATA_PATH] * gt_HandshakeBis.sa_DS_MaxIntlvDepthLP[LP0_DATA_PATH] / s_actual_inp , 3200);

               for (gs_maxdatarate_in=33; gs_maxdatarate_in < s_max_datarate_lim; gs_maxdatarate_in+=200)
               {
                  printf("PMS TEST maxdatarate = %d\n", gs_maxdatarate_in);

                  for (gs_ovhdrate_in = 4; gs_ovhdrate_in < 28; gs_ovhdrate_in+=8)
                  {
                     s_Lp_est = gs_maxdatarate_in + gs_ovhdrate_in * 4;
                     s_ncloaded_est = (s_Lp_est +14) / 15;  // Assuming 15 bits max
                     // test_run = 0, TCM on
                     if (test_run ==0)
                        s_TCM_Oh_est = (s_ncloaded_est + 1)/2 + 4;
                     else
                        s_TCM_Oh_est = 0;

                     s_Lp_est = s_Lp_est + s_TCM_Oh_est;

                     if (s_Lp_est < RX_MAX_BITS_PER_TONE * (gs_RxLastChannel - gs_RxFirstChannel +1))
                     { // considered a pausible config

                        for (gs_maxlatency_array = 0; gs_maxlatency_array < 7; gs_maxlatency_array += 1)
                        {
                           gs_maxlatency = s_savelatencyvalue[gs_maxlatency_array];
                           gt_HandshakeBis.sa_DS_MaxDataRateLP[LP0_DATA_PATH] = gs_maxdatarate_in;


                           gt_HandshakeBis.sa_DS_MaxNetDataRateBC[0] = gs_maxdatarate_in;

                           if (test_run <= 1)
                              /* TEST MIN= MAX */
                              gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[0]  = gs_maxdatarate_in;
                           else
                              /* TEST MIN < MAX */
                              gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[0]  = 8;


                           gt_HandshakeBis.s_MinMSGDSOverheadRate = gs_ovhdrate_in;

                           gt_HandshakeBis.sa_DS_MaxLatencyBC[0] = gs_maxlatency;
                           /* define which Bearer channels and latency paths are active */

                           gt_HandshakeBis.sa_DS_BCActive[0] = 1;
                           gt_HandshakeBis.sa_DS_BCActive[1] = 0;
                           gt_HandshakeBis.s_NumDSLatencyPaths = 1;     /* DS number of latency paths activated */

                           // initialize the margin to be 6 dB
                           gs_RxDesiredMargin=DESIRED_SNR_MARGIN;

                           gs_RxNumTones=256;

                           /*****************************************************************
                           Initialze the medley and reverb3 snr and RX num Tones
                           *****************************************************************/

                           for(i=0;i<gs_RxNumTones;i++)
                           {
                              gsa_ReverbSnrBuf[i]=(int16)(gsa_my_MedleySnrBuf[i]);
                              gsa_ReverbEchoSnrBuf[i]=(int16)(gsa_my_MedleySnrBuf[i]);
                              gusa_DS_Tssi_Value[i] = gusa_DS_Tssi_Value1[i];
                           }

                           copy_my_medley_snr(gsa_MedleySnrBuf, gsa_my_MedleySnrBuf);

                           gl_SelectedMode = MODE_G992_3 | ANNEX_A;

                           // calls bitload_bis
                           BgMedleyBitload_bis();

                           if (gft_BitloadOK)
                           {

                              //compute back the final parameters, mainly to see the final results on data rates and final latency
                              gs_BytesForBC0_final = gt_PMSParams.sa_Bpn[LP0_DATA_PATH][DS_AS0_BEARER_CHANNEL];
                              gs_BytesForBC1_final =  gt_PMSParams.sa_Bpn[LP0_DATA_PATH][DS_AS1_BEARER_CHANNEL];
                              gs_Kp_MDF_final=gs_BytesForBC0_final + gs_BytesForBC1_final + 1;
                              gs_Dp_final=gt_PMSParams.s_Dp[LP0_DATA_PATH];
                              gs_Mp_final=gt_PMSParams.s_Mp[LP0_DATA_PATH];
                              gs_Rp_final=gt_PMSParams.s_Rp[LP0_DATA_PATH];
                              gs_Lp_final=gt_PMSParams.s_Lp[LP0_DATA_PATH];
                              gs_Tp_final=gt_PMSParams.s_Tp[LP0_DATA_PATH];

                              if(gft_TcmFlag_bis_DS == TRUE)
                              {
                                 gs_TCM_Oh_final =(((int16) gus_ncloaded - (gus_Rx_Tcm_Num1bits >> 1) + 1) >> 1) + 4;
                              }
                              else
                                 gs_TCM_Oh_final=0;

                              gs_CWSize_final = gs_Kp_MDF_final*gs_Mp_final + gs_Rp_final;
                              gs_Sp_final = (int16)(8 * gs_CWSize_final*256/ gs_Lp_final); // Sp in 8.8 format

                              // net data rate (bits per frame)
                              gs_net_datarate_final = (int16)((((gs_Tp_final*gs_Kp_MDF_final-1)*gs_Mp_final*((int32)(gs_Lp_final*16)))/(gs_Tp_final*(gs_Kp_MDF_final*gs_Mp_final+gs_Rp_final))+8)/16);

                              // overhead rate is in kbps (final rate is in 8.8 format)
                              gs_ovhd_rate_final=(int16)((gs_Mp_final*((int32)gs_Lp_final)*4*256)/(gs_Tp_final*(gs_Kp_MDF_final*gs_Mp_final+gs_Rp_final)));
                              gs_latency_final= (int16)((int32)gs_Sp_final * gs_Dp_final / 4); // 8.8 format (ms)

                              s_BatCheck = VerifyBat((uint8 *)&guca_RxBat[0]);
                              /**************************************************************************************
                              INP is impulse noise protection = (1/2) (S*D) (R/CWSize)
                              ***************************************************************************************/

                              if(gs_CWSize_final != 0)
                                 INP = (gs_Sp_final*gs_Dp_final * gs_Rp_final/(2*gs_CWSize_final));

                              else
                                 INP=0;

                                 /**************************************************************************************
                                 Save the final computed parameters
                              ***************************************************************************************/
                              datarate_final = (float)(  (gs_Tp_final * gs_Kp_MDF_final - 1) *  gs_Mp_final * (float)(gs_Lp_final) / (gs_Tp_final * gs_CWSize_final));
                              datarate_diff = datarate_final- (float) gs_maxdatarate_in ;

                              datarate_msgc = (float) (gs_ovhd_rate_final* gs_MSGc_final)/(256*(gs_MSGc_final+6));

                              /* compute RMS fine gain value */
                              l_Prod = (int32) ComputeRMSFineGain(guca_RxBat, gsa_RxFineGains, gs_RxNumTones, gs_CurrentCoChipset, 0, 0);

                              gt_TxPMDControl.us_RMSGI_DS = 2* (ConvertToDB(l_Prod)  -  ConvertToDB(8192));
                           }
                           if (gt_TxPMDControl.us_RMSGI_DS > 0)
                           {
                              s_error_code = 2;
                           }


                           if ((s_BatCheck == FAIL) || (gft_BitloadOK == FAIL))
                           {
                              fprintf(file_pms,"%8.1f\t %ld\t %ld\t %ld\t %ld\t %ld\t %ld\t %ld\t %ld\t %ld\t %ld\t  %ld\t %ld\t %ld\t  %ld\t %ld\t %8.2f\t %8.2f\t %ld\t  %ld\t  %ld\t %ld\t %8.2f\t %ld\t",s_actual_inp , gs_maxdatarate_in, gs_ovhdrate_in, gs_maxlatency,  gs_Kp_MDF_final, gs_Dp_final,   gs_Mp_final,   gs_Rp_final, gs_Lp_final,  gs_Tp_final,gs_CWSize_final,gs_Sp_final,gs_net_datarate_final,gs_ovhd_rate_final,gs_latency_final, INP, datarate_final, datarate_diff,gus_BitloadExceptionCode,  gs_seq_final, gs_MSGc_final, gs_per_final, datarate_msgc, gt_TxPMDControl.us_RMSGI_DS);

                              fprintf(file_pms, "***ERROR:");
                              // First check for BitloadOK failure
                              if (gft_BitloadOK == FAIL)
                                 fprintf(file_pms, "BitloadOK=FAIL***\n");
                              // Then if BitloadOK is ok, check for bad Bat.
                              else if (s_BatCheck == FAIL)
                                 fprintf(file_pms, "Bad BAT***\n");
                              ;
                           }
                           else
                              fprintf(file_pms,"%8.1f\t %ld\t %ld\t %ld\t %ld\t %ld\t %ld\t %ld\t %ld\t %ld\t %ld\t  %ld\t %ld\t %ld\t  %ld\t %ld\t %8.2f\t %8.2f\t %ld %ld\t  %ld\t %ld\t %8.2f\t %ld\t\n", s_actual_inp, gs_maxdatarate_in, gs_ovhdrate_in, gs_maxlatency,  gs_Kp_MDF_final,  gs_Dp_final,   gs_Mp_final,   gs_Rp_final, gs_Lp_final,  gs_Tp_final,gs_CWSize_final,gs_Sp_final,gs_net_datarate_final,gs_ovhd_rate_final,gs_latency_final, INP,  datarate_final,datarate_diff, gus_BitloadExceptionCode, gs_seq_final, gs_MSGc_final, gs_per_final, datarate_msgc, gt_TxPMDControl.us_RMSGI_DS);



                           // reset all the global variables and pms structure
                           gs_Kp_MDF_final= 0;
                           gs_Dp_final=0;
                           gs_Mp_final=0;
                           gs_Rp_final=0;
                           gs_Lp_final=0;
                           gs_Tp_final=0;
                           gs_CWSize_final = 0;
                           gs_Sp_final = 0;
                           gs_net_datarate_final = 0;
                           gs_ovhd_rate_final=0;
                           gs_latency_final= 0;
                           gus_BitloadExceptionCode = 0;
                           gs_found_valid_config =0;
                           gs_flag_fixedrate = 0;
                           gs_flag_limitedrate = 0;

                           gt_PMSParams.s_Dp[LP0_DATA_PATH] = 0;
                           gt_PMSParams.s_Mp[LP0_DATA_PATH] = 0;
                           gt_PMSParams.s_Rp[LP0_DATA_PATH] = 0;
                           gt_PMSParams.s_Tp[LP0_DATA_PATH] = 0;
                           gt_PMSParams.s_Lp[LP0_DATA_PATH] = 0 ;

                           gs_iter_conv=0;

                  } // latency
            } // valid config
         } //ovhdrate
      } // max data rate
   } // gs_INP
   fcloseall();
   } // test_run

   /* Verification for BIS bits and gain allocation based on a set of SNRs saved in sn_data.h
   compute bi, gi and rms fine gain */
   file_pms=fopen(argv[5],"w");
   file_pms1=fopen(argv[6],"w");
   //    file_pms=fopen("test5.txt","w");
   //    file_pms1=fopen("test6.txt","w");


   for (test_run=0; test_run < 6; test_run++)
   {

      gs_RxNumTones=256;

      switch(test_run)
      {
         // test various SNRs
      case 0:
         fprintf(file_pms, " TEST SNR 0kft \n \n ");

         gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_0kft;


         fprintf(file_pms1, "\n \nTestSnrBuf_0kft:");
         break;

      case 1:
         fprintf(file_pms, " TEST SNR 10Kft \n \n ");
         fprintf(file_pms1, "\n \n MedleySnrBuf_10kft :");

         gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_10kft;
         break;

      case 2:
         fprintf(file_pms, " TEST SNR 18kft \n \n ");
         fprintf(file_pms1, " \nMedleySnrBuf_18kft : ");

         gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_18kft;
         break;

      case 3:
         fprintf(file_pms, " TEST SNR INCREASE DECREASE \n \n ");
         fprintf(file_pms1, " \n \nTest_snr_increase_decrease : ");

         gsa_my_MedleySnrBuf = gsa_test_snr_increase_decrease;
         break;

      case 4:
         fprintf(file_pms, " TEST SNR LONG LOOP \n \n ");
         fprintf(file_pms1, " \n \nMedleySnrBuf_longloop : ");

         gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_longloop1;
         break;

      case 5:
         fprintf(file_pms, " TEST SNR 18kft_500bt \n \n ");
         fprintf(file_pms1, " \n \nMedleySnrBuf_18kft_500ftbt : ");

         gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_18kft_500bt;
         break;
      }

      for(i=0;i<gs_RxNumTones;i++)
         fprintf(file_pms1,"%ld ", gsa_my_MedleySnrBuf[i] >> 8);

      fprintf(file_pms1,"\n \n ");
      printf("test_case : %ld\t \n", test_run);

      fprintf (file_pms1, "SNR \t MAXRATE (Kbps)\t  CO_MAXMARGIN\t DESIRED_MARGIN\t RMSFGAIN\t AVMARGIN\t MINMARGIN\t EMR\t STATUS\t \n");

      // do an increment of 1 bit at a time for long loop case

      if (test_run==4) step_rate = 1;
      else step_rate = 32;

      /*****************************************************************
      Initialze the medley and reverb3 snr and RX num Tones
      *****************************************************************/

      for(i=0;i<gs_RxNumTones;i++)
      {
         gsa_ReverbSnrBuf[i]=(int16)(gsa_my_MedleySnrBuf[i]);
         gsa_ReverbEchoSnrBuf[i]=(int16)(gsa_my_MedleySnrBuf[i]);
         gusa_DS_Tssi_Value[i] = gusa_DS_Tssi_Value1[i];
      }

      copy_my_medley_snr(gsa_MedleySnrBuf, gsa_my_MedleySnrBuf);

      OPTNArray[OPTN_AlgControl] = 0x0FF8;
      gs_tcm_coding_gain = TCM_CODING_GAIN;
      gs_max_coding_gain = MAX_CODING_GAIN;
      /*  SNR's (in dB) required for QAM */

      gsa_ConstellationSNR[0] = 0x0B4F;   /*  11.31 dB =  1 bit (NOT USED) */
      gsa_ConstellationSNR[1] = 0x0B4F;   /*  11.31 dB =  1 bit (NOT USED) */
      gsa_ConstellationSNR[2] = 0x0E51; /*  14.32 dB =  2 bits  */
      gsa_ConstellationSNR[3] = 0x131C;   /*  19.11 dB =  3 bits */
      gsa_ConstellationSNR[4] = 0x154F;   /*  21.31 dB =  4 bits */
      gsa_ConstellationSNR[5] = 0x1875;   /*  24.46 dB =  5 bits */
      gsa_ConstellationSNR[6] = 0x1B8A;   /*  27.54 dB =  6 bits */
      gsa_ConstellationSNR[7] = 0x1E97;   /*  30.59 dB =  7 bits */
      gsa_ConstellationSNR[8] = 0x219C;   /*  33.61 dB =  8 bits */
      gsa_ConstellationSNR[9] = 0x24A1;   /*  36.63 dB =  9 bits */
      gsa_ConstellationSNR[10] = 0x27A6; /*  39.65 dB = 10 bits */
      gsa_ConstellationSNR[11] = 0x2AA8; /*  42.66 dB = 11 bits */
      gsa_ConstellationSNR[12] = 0x2DAB; /*  45.67 dB = 12 bits */
      gsa_ConstellationSNR[13] = 0x30AE;  /*  48.68 dB = 13 bits */
      gsa_ConstellationSNR[14] = 0x33B0; /*  51.69 dB = 14 bits */
      gsa_ConstellationSNR[15] = 0x36B3; /*  54.70 dB = 15 bits */

      gs_INP_in = 0;

      /* Initialize the handshake parameters for standalone test */
      gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = gs_INP_in;

      gs_ovhdrate_in=4;

      gs_maxlatency=63;


      gt_HandshakeBis.s_MinMSGDSOverheadRate = gs_ovhdrate_in;

      gt_HandshakeBis.sa_DS_MaxLatencyBC[0] = gs_maxlatency;
      /* define which Bearer channels and latency paths are active */

      gt_HandshakeBis.sa_DS_BCActive[0] = 1;
      gt_HandshakeBis.sa_DS_BCActive[1] = 0;
      gt_HandshakeBis.s_NumDSLatencyPaths = 1;     /* DS number of latency paths activated */



      // Loop thru various options for desired margin
      for ( i_desired_margin= 0 ; i_desired_margin <4; i_desired_margin++)
      {
         s_desired_margin = Desired_Margin[i_desired_margin];

         gs_RxDesiredMargin = s_desired_margin;

         // Run Adaptive Rate
         gs_maxdatarate_in= 4000;

         gt_HandshakeBis.sa_DS_MaxDataRateLP[LP0_DATA_PATH] = gs_maxdatarate_in;


         gt_HandshakeBis.sa_DS_MaxNetDataRateBC[0] = gs_maxdatarate_in;

         gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[0] = 8;

         // calls bitload_bis
         BgMedleyBitload_bis();

         gs_Lp_final=gt_PMSParams.s_Lp[LP0_DATA_PATH];

         s_BatCheck = VerifyBat((uint8 *)&guca_RxBat[0]);

         fprintf(file_pms, "DESIRED MARGIN = %5.2f \t \n", (float)s_desired_margin/256);

         if ((s_BatCheck == FAIL) || (gft_BitloadOK == FAIL))
         {
            fprintf(file_pms, " ****BITLOAD FAILURE **** \n \n");
            fprintf (file_pms1,"%ld\t %ld\t %5.2f\t %5.2f\t %5.2f\t %5.2f\t %5.2f\t %5.2f\t %ld\t  ***BITLOAD FAILURE*** \n", test_run,   gs_maxdatarate_in *4, (float)s_max_margin/10, (float)s_desired_margin/256, (float)gt_TxPMDControl.us_RMSGI_DS/256 ,(float)gs_RxAvMargin/256 , (float)gs_RxMinMargin/256 , (float)gt_FineGainInfo.s_ExcessMarRedDB/256 , s_error_code );

            s_max_datarate_lim =0;
         }

         else
         {
            s_max_datarate_lim = gl_ATTNDRds_Initial / 4000;

            fprintf(file_pms, "TONE\t MED SNR\t BAT\t FINEGAIN\t MARGIN \n");

            for(i=0; i<gs_RxNumTones; i++)
            {
               fprintf(file_pms, "%4d\t %6d\t %6d\t %5d\t \n", i, gpsa_MeasuredSnrBuf[i], guca_RxBat[i],gsa_RxFineGains[i]);
            }

            fprintf(file_pms, " gs_RMSFineGain (Q8.8) = %5d\t  \n", gt_TxPMDControl.us_RMSGI_DS);
            fprintf(file_pms, " gs_RxAvMargin (Q8.8) = %5d\t  \n", gs_RxAvMargin);
            fprintf(file_pms, " gs_RxMinMargin (Q8.8) = %5d\t  \n", gs_RxMinMargin);
            fprintf(file_pms, " gs_ExcessMarRed (Q8.8) = %5d\t  \n \n", gt_FineGainInfo.s_ExcessMarRedDB);

            if (gs_RxMinMargin < gs_RxDesiredMargin)
            {
               fprintf(file_pms, " *** ERROR *** MIN MARGIN < DESIRED MARGIN\n");
            }

            if (gt_TxPMDControl.us_RMSGI_DS > 0)
            {
               fprintf(file_pms, " *** ERROR *** RMS FINE GAIN > 0 \n");
            }

            if ((gs_RxMinMargin-256 >gs_RxDesiredMargin ) && (gs_RxMinMargin-256 > (gt_RCMsgs1_bis.us_MAXSNRMds/10 << 8)) && (gt_TxPMDControl.us_RMSGI_DS > -11.5 *256))
            {
               fprintf(file_pms, " *** ERROR *** FURTHER EMR REDUCTION POSSIBLE \n");

            }

         }
         gus_BitloadExceptionCode = 0;
         gs_found_valid_config =0;
         gs_flag_fixedrate = 0;
         gs_flag_limitedrate = 0;

         gt_PMSParams.s_Dp[LP0_DATA_PATH] = 0;
         gt_PMSParams.s_Mp[LP0_DATA_PATH] = 0;
         gt_PMSParams.s_Rp[LP0_DATA_PATH] = 0;
         gt_PMSParams.s_Tp[LP0_DATA_PATH] = 0;
         gt_PMSParams.s_Lp[LP0_DATA_PATH] = 0 ;

         gs_iter_conv=0;



         for(i=0; i<gs_RxNumTones; i++)
            gsa_RxFineGains[i] = 0;


         // loop through various options for max margin setting
         for (j = 0; j < 7; j +=1)
         {
            s_max_margin = Max_Margin[j];
            gt_RCMsgs1_bis.us_MAXSNRMds = s_max_margin ;

            // special case meaning no margin reduction
            if(gt_RCMsgs1_bis.us_MAXSNRMds == 511) gt_RCMsgs1_bis.us_MAXSNRMds = 1000; //100dB

            // if max margin < desired skip
            if ( (s_max_margin/10)<<8  < s_desired_margin) continue;

            for (gs_maxdatarate_in=8; gs_maxdatarate_in < s_max_datarate_lim ;gs_maxdatarate_in += step_rate)
            {
               //             printf("FINEGAIN TEST maxdatarate = %d\n", gs_maxdatarate_in);

               gt_HandshakeBis.sa_DS_MaxDataRateLP[LP0_DATA_PATH] = gs_maxdatarate_in;


               gt_HandshakeBis.sa_DS_MaxNetDataRateBC[0] = gs_maxdatarate_in;

               gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[0]=gs_maxdatarate_in ;


               // calls bitload_bis
               BgMedleyBitload_bis();

               gs_Lp_final=gt_PMSParams.s_Lp[LP0_DATA_PATH];

               s_BatCheck = VerifyBat((uint8 *)&guca_RxBat[0]);

               if ((s_BatCheck == FAIL) || (gft_BitloadOK == FAIL))
               {
                  if (gs_forceeven1bit_notonefound ==1)
                  {
                     s_error_code =4;
                  }
                  if (s_error_code==4)
                     fprintf (file_pms1,"%ld\t %ld\t %5.2f\t %5.2f\t %5.2f\t %5.2f\t %5.2f\t %5.2f\t  %ld\t ***BITLOAD FAILURE  LP REDUCE FAIL*** \n", test_run,  gs_maxdatarate_in *4, (float)s_max_margin/10, (float)s_desired_margin/256, (float)gt_TxPMDControl.us_RMSGI_DS/256 ,(float)gs_RxAvMargin/256 , (float)gs_RxMinMargin/256 , (float)gt_FineGainInfo.s_ExcessMarRedDB/256 , s_error_code );
                  else
                     fprintf (file_pms1,"%ld\t %ld\t %5.2f\t %5.2f\t %5.2f\t %5.2f\t %5.2f\t %5.2f\t   %ld\t ***BITLOAD FAILURE***\n", test_run,   gs_maxdatarate_in *4, (float)s_max_margin/10, (float)s_desired_margin/256, (float)gt_TxPMDControl.us_RMSGI_DS/256 ,(float)gs_RxAvMargin/256 , (float)gs_RxMinMargin/256 , (float)gt_FineGainInfo.s_ExcessMarRedDB/256 , s_error_code );

               }
               else
               {
                  if (gs_forceeven1bit_notonefound ==1)
                  {
                     s_error_code =4;
                  }

                  if (gs_RxMinMargin < gs_RxDesiredMargin)
                  {
                     s_error_code = 1;
                  }

                  if (gt_TxPMDControl.us_RMSGI_DS > 0)
                  {
                     s_error_code = 2;
                  }

                  if ((gs_RxMinMargin-256 >gs_RxDesiredMargin ) && (gs_RxMinMargin-256 > (gt_RCMsgs1_bis.us_MAXSNRMds/10 << 8)) && (gt_TxPMDControl.us_RMSGI_DS > -11.0 *256))
                  {
                     s_error_code = 3;

                  }

                  if (s_error_code ==0)
                     fprintf (file_pms1,"%ld\t %ld\t %5.2f\t %5.2f\t %5.2f\t %5.2f\t %5.2f\t %5.2f\t  PASS\n", test_run,   gs_maxdatarate_in*4,    (float)s_max_margin/10, (float)s_desired_margin/256, (float)gt_TxPMDControl.us_RMSGI_DS/256  ,(float)gs_RxAvMargin/256 , (float)gs_RxMinMargin/256 , (float)gt_FineGainInfo.s_ExcessMarRedDB/256  );
                  else if (s_error_code == 4)
                     fprintf (file_pms1,"%ld\t %ld\t %5.2f\t %5.2f\t %5.2f\t %5.2f\t %5.2f\t %5.2f\t  FLAG Lp Decrease (forceeve1bit)\n", test_run,   gs_maxdatarate_in*4, (float)s_max_margin/10, (float)s_desired_margin/256,  (float)gt_TxPMDControl.us_RMSGI_DS/256 ,(float)gs_RxAvMargin/256 , (float)gs_RxMinMargin/256 , (float)gt_FineGainInfo.s_ExcessMarRedDB/256 );
                  else
                     fprintf (file_pms1,"%ld\t %ld\t %5.2f\t %5.2f\t %5.2f\t %5.2f\t %5.2f\t %5.2f\t  FAIL %ld\t\n", test_run,   gs_maxdatarate_in*4, (float)s_max_margin/10, (float)s_desired_margin/256,  (float)gt_TxPMDControl.us_RMSGI_DS/256 ,(float)gs_RxAvMargin/256 , (float)gs_RxMinMargin/256 , (float)gt_FineGainInfo.s_ExcessMarRedDB/256 , s_error_code );

               }


               // reset the variables
               gus_BitloadExceptionCode = 0;
               gs_found_valid_config =0;
               gs_flag_fixedrate = 0;
               gs_flag_limitedrate = 0;

               gt_PMSParams.s_Dp[LP0_DATA_PATH] = 0;
               gt_PMSParams.s_Mp[LP0_DATA_PATH] = 0;
               gt_PMSParams.s_Rp[LP0_DATA_PATH] = 0;
               gt_PMSParams.s_Tp[LP0_DATA_PATH] = 0;
               gt_PMSParams.s_Lp[LP0_DATA_PATH] = 0 ;

               gs_iter_conv=0;

               for(i=0; i<gs_RxNumTones; i++)
                  gsa_RxFineGains[i] = 0;

               s_error_code = 0;
               gs_forceeven1bit_notonefound = 0;


            }
         }


      }

   }

   // BIS TEST WITH FINE GAIN OFF LONG LOOP


      gft_FineGainOn = FALSE;


      gs_RxNumTones=256;

      fprintf(file_pms, "\nTEST FINE GAIN OFF \n");
      fprintf(file_pms1, " \nTEST FINE GAIN OFF \n");

      fprintf(file_pms, " TEST SNR LONG LOOP \n \n ");
      fprintf(file_pms1, " \n \nMedleySnrBuf_longloop : ");

      gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_longloop;

      for(i=0;i<gs_RxNumTones;i++)
         fprintf(file_pms1,"%ld ", gsa_my_MedleySnrBuf[i] >> 8);

      fprintf(file_pms1,"\n \n ");
      printf("test_case : %ld\t \n", test_run);

      fprintf (file_pms1, "SNR \t MAXRATE (Kbps)\t  CO_MAXMARGIN\t DESIRED_MARGIN\t  AVMARGIN\t MINMARGIN\t  STATUS\t \n");


      /*****************************************************************
      Initialze the medley and reverb3 snr and RX num Tones
      *****************************************************************/

      for(i=0;i<gs_RxNumTones;i++)
      {
         gsa_ReverbSnrBuf[i]=(int16)(gsa_my_MedleySnrBuf[i]);
         gsa_ReverbEchoSnrBuf[i]=(int16)(gsa_my_MedleySnrBuf[i]);
         gusa_DS_Tssi_Value[i] = gusa_DS_Tssi_Value1[i];
      }

      copy_my_medley_snr(gsa_MedleySnrBuf, gsa_my_MedleySnrBuf);

      OPTNArray[OPTN_AlgControl] = 0x0FF8;
      gs_tcm_coding_gain = TCM_CODING_GAIN;
      gs_max_coding_gain = MAX_CODING_GAIN;
      /*  SNR's (in dB) required for QAM */

      gsa_ConstellationSNR[0] = 0x0B4F;   /*  11.31 dB =  1 bit (NOT USED) */
      gsa_ConstellationSNR[1] = 0x0B4F;   /*  11.31 dB =  1 bit (NOT USED) */
      gsa_ConstellationSNR[2] = 0x0E51; /*  14.32 dB =  2 bits  */
      gsa_ConstellationSNR[3] = 0x131C;   /*  19.11 dB =  3 bits */
      gsa_ConstellationSNR[4] = 0x154F;   /*  21.31 dB =  4 bits */
      gsa_ConstellationSNR[5] = 0x1875;   /*  24.46 dB =  5 bits */
      gsa_ConstellationSNR[6] = 0x1B8A;   /*  27.54 dB =  6 bits */
      gsa_ConstellationSNR[7] = 0x1E97;   /*  30.59 dB =  7 bits */
      gsa_ConstellationSNR[8] = 0x219C;   /*  33.61 dB =  8 bits */
      gsa_ConstellationSNR[9] = 0x24A1;   /*  36.63 dB =  9 bits */
      gsa_ConstellationSNR[10] = 0x27A6; /*  39.65 dB = 10 bits */
      gsa_ConstellationSNR[11] = 0x2AA8; /*  42.66 dB = 11 bits */
      gsa_ConstellationSNR[12] = 0x2DAB; /*  45.67 dB = 12 bits */
      gsa_ConstellationSNR[13] = 0x30AE;  /*  48.68 dB = 13 bits */
      gsa_ConstellationSNR[14] = 0x33B0; /*  51.69 dB = 14 bits */
      gsa_ConstellationSNR[15] = 0x36B3; /*  54.70 dB = 15 bits */

      gs_INP_in = 0;

      /* Initialize the handshake parameters for standalone test */
      gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = gs_INP_in;

      gs_ovhdrate_in=4;

      gs_maxlatency=63;


      gt_HandshakeBis.s_MinMSGDSOverheadRate = gs_ovhdrate_in;

      gt_HandshakeBis.sa_DS_MaxLatencyBC[0] = gs_maxlatency;
      /* define which Bearer channels and latency paths are active */

      gt_HandshakeBis.sa_DS_BCActive[0] = 1;
      gt_HandshakeBis.sa_DS_BCActive[1] = 0;
      gt_HandshakeBis.s_NumDSLatencyPaths = 1;     /* DS number of latency paths activated */



      // Loop thru various options for desired margin
      for ( i_desired_margin= 0 ; i_desired_margin < 4 ; i_desired_margin++)
      {
         s_desired_margin = Desired_Margin[i_desired_margin];

         gs_RxDesiredMargin = s_desired_margin;

         // Run Adaptive Rate
         gs_maxdatarate_in= 4000;

         gt_HandshakeBis.sa_DS_MaxDataRateLP[LP0_DATA_PATH] = gs_maxdatarate_in;


         gt_HandshakeBis.sa_DS_MaxNetDataRateBC[0] = gs_maxdatarate_in;

         gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[0]  = 8;

         // calls bitload_bis
         BgMedleyBitload_bis();

         gs_Lp_final=gt_PMSParams.s_Lp[LP0_DATA_PATH];

         s_BatCheck = VerifyBat((uint8 *)&guca_RxBat[0]);

         fprintf(file_pms, "DESIRED MARGIN = %5.2f \t \n", (float)s_desired_margin/256);

         if ((s_BatCheck == FAIL) || (gft_BitloadOK == FAIL))
         {
            fprintf(file_pms, " ****BITLOAD FAILURE **** \n \n");
            fprintf (file_pms1,"%ld\t %ld\t %5.2f\t %5.2f\t %5.2f\t %5.2f\t %ld\t  ***BITLOAD FAILURE*** \n", test_run, gs_maxdatarate_in *4, (float)s_max_margin/10, (float)s_desired_margin/256,(float)gs_RxAvMargin/256 , (float)gs_RxMinMargin/256  , s_error_code );

            s_max_datarate_lim =0;
         }

         else
         {
            s_max_datarate_lim = gl_ATTNDRds_Initial / 4000;

            fprintf(file_pms, "TONE\t MED SNR\t BAT\t FINEGAIN\t MARGIN \n");

            for(i=0; i<gs_RxNumTones; i++)
            {
               fprintf(file_pms, "%4d\t %6d\t %6d\t %5d\t \n", i, gpsa_MeasuredSnrBuf[i], guca_RxBat[i],gsa_RxFineGains[i]);
            }

            fprintf(file_pms, " gs_RMSFineGain (Q8.8) = %5d\t  \n", gt_TxPMDControl.us_RMSGI_DS);
            fprintf(file_pms, " gs_RxAvMargin (Q8.8) = %5d\t  \n", gs_RxAvMargin);
            fprintf(file_pms, " gs_RxMinMargin (Q8.8) = %5d\t  \n", gs_RxMinMargin);
            fprintf(file_pms, " gs_ExcessMarRed (Q8.8) = %5d\t  \n \n", gt_FineGainInfo.s_ExcessMarRedDB);

            if (gs_RxMinMargin < gs_RxDesiredMargin)
            {
               fprintf(file_pms, " *** ERROR *** MIN MARGIN < DESIRED MARGIN\n");
            }

            if (gt_TxPMDControl.us_RMSGI_DS > 0)
            {
               fprintf(file_pms, " *** ERROR *** RMS FINE GAIN > 0 \n");
            }

            if ((gs_RxMinMargin-256 >gs_RxDesiredMargin ) && (gs_RxMinMargin-256 > (gt_RCMsgs1_bis.us_MAXSNRMds/10 << 8)) && (gt_TxPMDControl.us_RMSGI_DS > -11.5 *256))
            {
               fprintf(file_pms, " *** ERROR *** FURTHER EMR REDUCTION POSSIBLE \n");

            }

         }
         gus_BitloadExceptionCode = 0;
         gs_found_valid_config =0;
         gs_flag_fixedrate = 0;
         gs_flag_limitedrate = 0;

         gt_PMSParams.s_Dp[LP0_DATA_PATH] = 0;
         gt_PMSParams.s_Mp[LP0_DATA_PATH] = 0;
         gt_PMSParams.s_Rp[LP0_DATA_PATH] = 0;
         gt_PMSParams.s_Tp[LP0_DATA_PATH] = 0;
         gt_PMSParams.s_Lp[LP0_DATA_PATH] = 0 ;

         gs_iter_conv=0;



         for(i=0; i<gs_RxNumTones; i++)
            gsa_RxFineGains[i] = 0;



         // loop through various options for max margin setting
         for (j = 0; j < 7; j +=1)
         {
            s_max_margin = Max_Margin[j];
            gt_RCMsgs1_bis.us_MAXSNRMds = s_max_margin ;

            // special case meaning no margin reduction
            if(gt_RCMsgs1_bis.us_MAXSNRMds == 511) gt_RCMsgs1_bis.us_MAXSNRMds = 1000; //100dB

            // if max margin < desired skip
            if ( (s_max_margin/10)<<8  < s_desired_margin) continue;

            for (gs_maxdatarate_in=8; gs_maxdatarate_in < s_max_datarate_lim ;gs_maxdatarate_in += 1)
            {
               printf("FINEGAIN TEST maxdatarate = %d\n", gs_maxdatarate_in);

               gt_HandshakeBis.sa_DS_MaxDataRateLP[LP0_DATA_PATH] = gs_maxdatarate_in;


               gt_HandshakeBis.sa_DS_MaxNetDataRateBC[0] = gs_maxdatarate_in;

               gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[0] = gs_maxdatarate_in;


               // calls bitload_bis
               BgMedleyBitload_bis();

               gs_Lp_final=gt_PMSParams.s_Lp[LP0_DATA_PATH];

               s_BatCheck = VerifyBat((uint8 *)&guca_RxBat[0]);

               if ((s_BatCheck == FAIL) || (gft_BitloadOK == FAIL))
               {
                  if (gs_forceeven1bit_notonefound ==1)
                  {
                     s_error_code =4;
                  }
                  if (s_error_code==4)
                     fprintf (file_pms1,"%ld\t %ld\t %5.2f\t %5.2f\t %5.2f\t  %ld\t  ***BITLOAD FAILURE  LP REDUCE FAIL*** \n", test_run, gs_maxdatarate_in *4, (float)s_max_margin/10, (float)s_desired_margin/256  ,(float)gs_RxAvMargin/256 , (float)gs_RxMinMargin/256 ,  s_error_code );
                  else
                     fprintf (file_pms1,"%ld\t %ld\t %5.2f\t %5.2f\t %5.2f\t   %ld\t  ***BITLOAD FAILURE*** \n", test_run, gs_maxdatarate_in *4, (float)s_max_margin/10, (float)s_desired_margin/256, (float)gs_RxAvMargin/256 , (float)gs_RxMinMargin/256 ,  s_error_code );

               }
               else
               {
                  if (gs_forceeven1bit_notonefound ==1)
                  {
                     s_error_code =4;
                  }

                  if (gs_RxMinMargin < gs_RxDesiredMargin)
                  {
                     s_error_code = 1;
                  }


                  if (s_error_code ==0)
                     fprintf (file_pms1,"%ld\t %ld\t %5.2f\t %5.2f\t %5.2f\t  %ld\t  PASS\n", test_run,  gs_maxdatarate_in*4,    (float)s_max_margin/10, (float)s_desired_margin/256   ,(float)gs_RxAvMargin/256 , (float)gs_RxMinMargin/256   );
                  else if (s_error_code == 4)
                     fprintf (file_pms1,"%ld\t %ld\t %5.2f\t %5.2f\t %5.2f\t  %ld\t  FLAG Lp Decrease (forceeve1bit) %ld\t\n", test_run,  gs_maxdatarate_in*4, (float)s_max_margin/10, (float)s_desired_margin/256,  (float)gs_RxAvMargin/256 , (float)gs_RxMinMargin/256 , s_error_code , gus_BitloadExceptionCode);
                  else
                     fprintf (file_pms1,"%ld\t %ld\t %5.2f\t %5.2f\t %5.2f\t  %ld\t  FAIL %ld\t\n", test_run,  gs_maxdatarate_in*4, (float)s_max_margin/10, (float)s_desired_margin/256,  (float)gs_RxAvMargin/256 , (float)gs_RxMinMargin/256 ,  s_error_code, gus_BitloadExceptionCode );

               }


               // reset the variables
               gus_BitloadExceptionCode = 0;
               gs_found_valid_config =0;
               gs_flag_fixedrate = 0;
               gs_flag_limitedrate = 0;

               gt_PMSParams.s_Dp[LP0_DATA_PATH] = 0;
               gt_PMSParams.s_Mp[LP0_DATA_PATH] = 0;
               gt_PMSParams.s_Rp[LP0_DATA_PATH] = 0;
               gt_PMSParams.s_Tp[LP0_DATA_PATH] = 0;
               gt_PMSParams.s_Lp[LP0_DATA_PATH] = 0 ;

               gs_iter_conv=0;

               for(i=0; i<gs_RxNumTones; i++)
                  gsa_RxFineGains[i] = 0;

               s_error_code = 0;
               gs_forceeven1bit_notonefound = 0;


            }
         }


      }

      fcloseall();


      // DMT Bitload test
      gft_FineGainOn = TRUE;

      file_pms=fopen(argv[7],"w");
      file_pms1=fopen(argv[8],"w");
      //    file_pms=fopen("test7.txt","w");
      //    file_pms1=fopen("test8.txt","w");

      fprintf (file_pms1, "SNR \t TOTAL_BIT_Supp\t MAXRATE\t   RMSFGAIN\t AVMARGIN\t MINMARGIN\t  STATUS\t \n");

      // define DMT for standalone test
      gft_ModemType = G_DMT;

      STATArray[STAT_Mode] = STAT_ConfigMode_G992_1_A;

      gl_SelectedMode = MODE_G992_1 | ANNEX_A;

      for (test_run=0; test_run < 4; test_run++)
      {

         // initialize the margin to be 6 dB
         gs_RxDesiredMargin=DESIRED_SNR_MARGIN;

         gs_RxNumTones=256;

         switch(test_run)
         {
            // test various SNRs
         case 0:
            fprintf(file_pms, " TEST SNR 0kft \n \n ");

            gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_0kft  ;

            break;

         case 1:
            fprintf(file_pms, " TEST SNR 10Kft \n \n ");

            gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_10kft;
            break;

         case 2:
            fprintf(file_pms, " TEST SNR 16kft \n \n ");

            gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_16kft;
            break;

         case 3:
            fprintf(file_pms, " TEST SNR INCREASE DECREASE \n \n ");

            gsa_my_MedleySnrBuf = gsa_test_snr_increase_decrease;
            break;

         }

         /*****************************************************************
         Initialze the medley and reverb3 snr and RX num Tones
         *****************************************************************/

         for(i=0;i<gs_RxNumTones;i++)
         {
            gsa_ReverbSnrBuf[i]=(int16)(gsa_my_MedleySnrBuf[i]);
            gsa_ReverbEchoSnrBuf[i]=(int16)(gsa_my_MedleySnrBuf[i]);
            gusa_DS_Tssi_Value[i] = gusa_DS_Tssi_Value1[i];
         }

         copy_my_medley_snr(gsa_MedleySnrBuf, gsa_my_MedleySnrBuf);
         gft_TcmFlag = TRUE;
         gs_tcm_coding_gain = TCM_CODING_GAIN;
         gs_max_coding_gain = MAX_CODING_GAIN;

         //Init Bit Loading
         gft_BitloadOK = InitBitloading(s_path);

         //Get the total maximum coding gain (RS+TCM) (in Q8.8 format)
         s_RSCodingGain = GetCodingGain(16);

         /*  SNR's (in dB) required for QAM */

         gsa_ConstellationSNR[0] = 0x0B4F;   /*  11.31 dB =  1 bit (NOT USED) */
         gsa_ConstellationSNR[1] = 0x0B4F;   /*  11.31 dB =  1 bit (NOT USED) */
         gsa_ConstellationSNR[2] = 0x0E51; /*  14.32 dB =  2 bits  */
         gsa_ConstellationSNR[3] = 0x131C;   /*  19.11 dB =  3 bits */
         gsa_ConstellationSNR[4] = 0x154F;   /*  21.31 dB =  4 bits */
         gsa_ConstellationSNR[5] = 0x1875;   /*  24.46 dB =  5 bits */
         gsa_ConstellationSNR[6] = 0x1B8A;   /*  27.54 dB =  6 bits */
         gsa_ConstellationSNR[7] = 0x1E97;   /*  30.59 dB =  7 bits */
         gsa_ConstellationSNR[8] = 0x219C;   /*  33.61 dB =  8 bits */
         gsa_ConstellationSNR[9] = 0x24A1;   /*  36.63 dB =  9 bits */
         gsa_ConstellationSNR[10] = 0x27A6; /*  39.65 dB = 10 bits */
         gsa_ConstellationSNR[11] = 0x2AA8; /*  42.66 dB = 11 bits */
         gsa_ConstellationSNR[12] = 0x2DAB; /*  45.67 dB = 12 bits */
         gsa_ConstellationSNR[13] = 0x30AE;  /*  48.68 dB = 13 bits */
         gsa_ConstellationSNR[14] = 0x33B0; /*  51.69 dB = 14 bits */
         gsa_ConstellationSNR[15] = 0x36B3; /*  54.70 dB = 15 bits */

         if (gft_TcmFlag == TRUE)
            AdjustTcmCodingGains(16);

         //Compute Required SNR (= constellation SNR + margin) for each constellation
         OffsetSNRRequired(gs_RxDesiredMargin, gsa_SNRRequired);

         //Compute SNR plus coding gain
         gpsa_MeasuredSnrBuf = &gsa_RxShowtimeSnrBuf[0];

         //Add coding gain to SNRs
         AddCodingGainToSnr(gsa_MedleySnrBuf, (int16)(s_RSCodingGain<<7), gpsa_MeasuredSnrBuf, s_path);

         //Calculate the max bits per symbol that the channel can support
         //and perform initial bit allocation and fine gain marking
         gs_TotalBitsSupported = CalcMaxBits(gft_FineGainOn, guca_RxBat, gsa_RxFineGains, &gs_RxExtraBits, &gus_ncloaded, &gs_RxAvFineGain, 0x7FFF, s_path);
         s_max_datarate_lim = gs_TotalBitsSupported - 120;  // take 120 for TCM overhead


         /* compute RMS fine gain value */
         l_Prod = (int32) ComputeRMSFineGain(guca_RxBat, gsa_RxFineGains, gs_RxNumTones, gs_CurrentCoChipset, 0, 0);

         gt_TxPMDControl.us_RMSGI_DS = 2* (ConvertToDB(l_Prod)  -  ConvertToDB(8192));

         gs_RxMinMargin = 0x7FFF;

         //Calulate actual fine gain and margin
         CalcMarginsAndGains(gft_FineGainOn, guca_RxBat, gsa_RxFineGains, &gs_RxAvMargin, &gs_RxAvFineGain, &gs_RxMinMargin);

         if (gt_TxPMDControl.us_RMSGI_DS > 0)
         {
            //       s_error_code = 2;
         }
         fprintf(file_pms, "TONE\t MED SNR\t BAT\t FINEGAIN\t MARGIN \n");

         for(i=0; i<gs_RxNumTones; i++)
         {
            fprintf(file_pms, "%4d\t %6d\t %6d\t %5d\t \n", i, gpsa_MeasuredSnrBuf[i], guca_RxBat[i],gsa_RxFineGains[i]);
         }


         fprintf(file_pms, "  gs_TotalBitsSupported(Q8.8) = %5d\t  \n", gs_TotalBitsSupported);
         fprintf(file_pms, " gs_RMSFineGain (Q8.8) = %5d\t  \n", gt_TxPMDControl.us_RMSGI_DS);
         fprintf(file_pms, " gs_RxAvMargin (Q8.8) = %5d\t  \n", gs_RxAvMargin);
         fprintf(file_pms, " gs_RxMinMargin (Q8.8) = %5d\t  \n \n \n", gs_RxMinMargin);




         for (gs_maxdatarate_in=32; gs_maxdatarate_in < s_max_datarate_lim; gs_maxdatarate_in+=32)
         {
            printf(" DMT maxdatarate = %d\n", gs_maxdatarate_in);

            // set tone flag, currently all tones are set to 1, this is important mainly in BIS

            for (i=gs_RxFirstChannel ; i<=gs_RxLastChannel ; i++)
               SETTONEFLAG(p_MEDLEYset_DS, i);

            //Init Bit Loading
            gft_BitloadOK = InitBitloading(s_path);

            //Get the total maximum coding gain (RS+TCM) (in Q8.8 format)
            s_RSCodingGain = GetCodingGain(16);

            //Compute Required SNR (= constellation SNR + margin) for each constellation
            OffsetSNRRequired(gs_RxDesiredMargin, gsa_SNRRequired);

            //Compute SNR plus coding gain
            gpsa_MeasuredSnrBuf = &gsa_RxShowtimeSnrBuf[0];

            //Add coding gain to SNRs
            AddCodingGainToSnr(gsa_MedleySnrBuf, (int16)(s_RSCodingGain<<7), gpsa_MeasuredSnrBuf, s_path);

            //Calculate the max bits per symbol that the channel can support
            //and perform initial bit allocation and fine gain marking
            gs_TotalBitsSupported = CalcMaxBits(gft_FineGainOn, guca_RxBat, gsa_RxFineGains, &gs_RxExtraBits, &gus_ncloaded, &gs_RxAvFineGain, 0x7FFF, s_path);

            /* Compute TCM overhead based adjusted number loaded tones */
            if(gft_TcmFlag == TRUE)
               s_OhTcm = (int16)(((gus_ncloaded+1)>>1) + 4);
            else
               s_OhTcm = 0;


            s_delta_Lp =   gs_maxdatarate_in + s_OhTcm - gs_TotalBitsSupported;
            gft_BitloadOK = !ChangeLpKeepMaxMargin(guca_RxBat, gsa_RxFineGains, s_delta_Lp , gsa_RxShowtimeSnrBuf, gs_RxDesiredMargin, p_MEDLEYset_DS, guca_RxBitswapTones, &s_ActualDeltaSumLp, FALSE, 0, 0);

            gs_RxMinMargin = 0x7FFF;

            //Calulate actual fine gain and margin
            CalcMarginsAndGains(gft_FineGainOn, guca_RxBat, gsa_RxFineGains, &gs_RxAvMargin, &gs_RxAvFineGain, &gs_RxMinMargin);

            gs_Lp_final = gs_maxdatarate_in;

            if (gft_BitloadOK)
               s_BatCheck = VerifyBat((uint8 *)&guca_RxBat[0]);

            /* compute RMS fine gain value */
            l_Prod = (int32) ComputeRMSFineGain(guca_RxBat, gsa_RxFineGains, gs_RxNumTones, gs_CurrentCoChipset, 0, 0);

            gt_TxPMDControl.us_RMSGI_DS = 2* (ConvertToDB(l_Prod)  -  ConvertToDB(8192));

            if ((s_BatCheck == FAIL) || (gft_BitloadOK == FAIL))
            {
               fprintf(file_pms, " ****BITLOAD FAILURE **** \n \n");

            }
            else
            {
               fprintf (file_pms1,"%ld\t %ld\t %ld\t %5.2f\t %5.2f\t %5.2f\t  PASS\n", test_run, gs_TotalBitsSupported,    gs_maxdatarate_in,   (float)gt_TxPMDControl.us_RMSGI_DS/256 ,(float)gs_RxAvMargin/256 , (float)gs_RxMinMargin/256  );
            }

            // reset the parameters
            s_error_code =0;

            for(i=0; i<gs_RxNumTones; i++)
               gsa_RxFineGains[i] = 0;

         }
   }
      fcloseall();


      // TEST ADSL2 PLUS BITLOADING

      gs_RxLastChannel = 511;
      gs_max_CWSize = 255;


      gs_RxBitLoadFirstChannel = gs_RxFirstChannel;
      gs_RxBitLoadLastChannel = gs_RxLastChannel;

      gft_FineGainOn = TRUE;

      gs_max_fine_gain =  640;      // 2.5dB in Q 8.8
      gs_min_fine_gain = -640;      // -2.5dB in Q8.8


      guca_RSCodingGain[0] = 0;
      guca_RSCodingGain[1]= RS_CODING_GAIN_2;
      guca_RSCodingGain[2]= RS_CODING_GAIN_4;
      guca_RSCodingGain[3]= RS_CODING_GAIN_6;
      guca_RSCodingGain[4]= RS_CODING_GAIN_8;
      guca_RSCodingGain[5]= RS_CODING_GAIN_10;
      guca_RSCodingGain[6]= RS_CODING_GAIN_12;
      guca_RSCodingGain[7]= RS_CODING_GAIN_14;
      guca_RSCodingGain[8]= RS_CODING_GAIN_16;

      gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_plus;

      // Point Task layer pointers to locally defined buffers.

      copy_my_medley_snr(gsa_MedleySnrBuf, gsa_my_MedleySnrBuf);

      gsa_RxShowtimeSnrBuf = gsa_my_RxShowtimeSnrBuf_Plus;
      gsa_RxFineGains = gsa_my_RxFineGains;
      gsa_RxToneOrder = gsa_my_RxToneOrder;



      for (i=0 ; i< RX_NUM_TONES ; i++)
         gsa_RxToneOrder[i] = i;

      for (i=gs_RxFirstChannel ; i<=gs_RxLastChannel ; i++)
         SETTONEFLAG(p_MEDLEYset_DS, i);

      // define BIS for standalone test
      gft_ModemType = G_DMT_BIS;

      STATArray[STAT_Mode] = (int16)STAT_ConfigMode_G992_5_A;

      gt_HandshakeBis.s_OneOverSminADSL2 = 3;

      gl_SelectedMode = MODE_G992_5 | ANNEX_A;

      /*  We re-allocate the default values to the HS_BIS structure before entering bit-loading. */
      gt_HandshakeBis.sa_DS_MaxCheckbytesLP[LP0_DATA_PATH] = (int16) (2* MAX_R_LP0_DS);
      gt_HandshakeBis.sa_DS_MaxIntlvDepthLP[LP0_DATA_PATH] = (int16) 64;


      guc_MaxAllocBitsPerTone = RX_MAX_BITS_PER_TONE;

      gs_AuxPilotToneIdx = gs_CPilotTone;

      for (i=0; i<21; i++)
      {
         gs_supportedDvalues[i] = save_myD_Values_Old[i];
      }


      for (test_run=0; test_run <4; test_run++)
      {
         // First two cases run min = max
         if(test_run==0) // set the parameters for tcm on
         {
            file_pms=fopen(argv[9],"w");
            //       file_pms=fopen("test9.txt","w");
            OPTNArray[OPTN_AlgControl] = 0x0FF8;
            gs_tcm_coding_gain = TCM_CODING_GAIN;
            gs_max_coding_gain = MAX_CODING_GAIN;
         }

         if (test_run==1)
         {
            file_pms=fopen(argv[10],"w");
            //       file_pms=fopen("test10.txt","w");
            OPTNArray[OPTN_AlgControl] = 0x2FF8;
            gs_tcm_coding_gain = 0;
            gs_max_coding_gain = MAX_CODING_GAIN;
         }

         if(test_run==2) // set the parameters for tcm on
         {
            file_pms=fopen(argv[11],"w");
            //       file_pms=fopen("test11.txt","w");
            OPTNArray[OPTN_AlgControl] = 0x0FF8;
            gs_tcm_coding_gain = TCM_CODING_GAIN;
            gs_max_coding_gain = MAX_CODING_GAIN;
         }

         if (test_run==3)
         {
            file_pms=fopen(argv[12],"w");
            //       file_pms=fopen("test12.txt","w");
            OPTNArray[OPTN_AlgControl] = 0x2FF8;
            gs_tcm_coding_gain = 0;
            gs_max_coding_gain = MAX_CODING_GAIN;
         }

         /*  SNR's (in dB) required for QAM */

         gsa_ConstellationSNR[0] = 0x0B4F;   /*  11.31 dB =  1 bit (NOT USED) */
         gsa_ConstellationSNR[1] = 0x0B4F;   /*  11.31 dB =  1 bit (NOT USED) */
         gsa_ConstellationSNR[2] = 0x0E51; /*  14.32 dB =  2 bits  */
         gsa_ConstellationSNR[3] = 0x131C;   /*  19.11 dB =  3 bits */
         gsa_ConstellationSNR[4] = 0x154F;   /*  21.31 dB =  4 bits */
         gsa_ConstellationSNR[5] = 0x1875;   /*  24.46 dB =  5 bits */
         gsa_ConstellationSNR[6] = 0x1B8A;   /*  27.54 dB =  6 bits */
         gsa_ConstellationSNR[7] = 0x1E97;   /*  30.59 dB =  7 bits */
         gsa_ConstellationSNR[8] = 0x219C;   /*  33.61 dB =  8 bits */
         gsa_ConstellationSNR[9] = 0x24A1;   /*  36.63 dB =  9 bits */
         gsa_ConstellationSNR[10] = 0x27A6; /*  39.65 dB = 10 bits */
         gsa_ConstellationSNR[11] = 0x2AA8; /*  42.66 dB = 11 bits */
         gsa_ConstellationSNR[12] = 0x2DAB; /*  45.67 dB = 12 bits */
         gsa_ConstellationSNR[13] = 0x30AE;  /*  48.68 dB = 13 bits */
         gsa_ConstellationSNR[14] = 0x33B0; /*  51.69 dB = 14 bits */
         gsa_ConstellationSNR[15] = 0x36B3; /*  54.70 dB = 15 bits */

         fprintf(file_pms, "INP\t maxrate\t msg_ovhdrate\t maxlatency\t Kp\t Dp\t Mp\t Rp\t Lp\t Tp\t CWSize\t Sp(8.8)\t net_datarate\t ovhd_rate\t latency_achvd\t INP_achvd\t  datarate\t diff_rate\t Ex_code\t  SEQp\t MSGc\t PERp\t MSGc_rate\t\n");

         /***********************************************************************
         Loop thru various values of max data rate, overhead rate and latency

         ***********************************************************************/
         for (gs_INP_in = 0 ; gs_INP_in < 7 ; gs_INP_in++)
         {
            /* Initialize the handshake parameters for standalone test */

               if (gs_INP_in == 0)
               {
                  /* Initialize the handshake parameters for standalone test */
                  gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 0;
                  s_actual_inp = 0;
               }
               else if (gs_INP_in == 1)
               {
                  gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 1; // 0.5 frame protection
                  s_actual_inp = 0.5;
               }
               else if (gs_INP_in == 2)
               {
                  gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 2; // 1 frame protection
                  s_actual_inp = 1;
               }
               else if (gs_INP_in == 3)
               {
                  gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 4; // 2 frame protection
                  s_actual_inp = 2;
               }
               else if (gs_INP_in == 4)
               {
                  gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 8; // 4 frame protection
                  s_actual_inp = 4;
               }
               else if (gs_INP_in == 5)
               {
                  gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 16 ;// 8 frame protection
                  s_actual_inp = 8;
               }
               else if (gs_INP_in == 6)
               {
                  gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 32; // 16 frame protection
                  s_actual_inp = 16;
               }



            if(gs_INP_in <= 1)
               s_max_datarate_lim = 6000;
            else
               s_max_datarate_lim = min(8 * gt_HandshakeBis.sa_DS_MaxCheckbytesLP[LP0_DATA_PATH] * gt_HandshakeBis.sa_DS_MaxIntlvDepthLP[LP0_DATA_PATH] / s_actual_inp , 6000);

            for (gs_maxdatarate_in=33; gs_maxdatarate_in < s_max_datarate_lim; gs_maxdatarate_in+=200)
            {
               printf("PMS TEST maxdatarate = %d\n", gs_maxdatarate_in);

               for (gs_ovhdrate_in = 4; gs_ovhdrate_in < 56; gs_ovhdrate_in+=8)
               {
                  s_Lp_est = gs_maxdatarate_in + gs_ovhdrate_in * 4;
                  s_ncloaded_est = (s_Lp_est +14) / 15;  // Assuming 15 bits max
                  // test_run = 0, TCM on
                  if (test_run ==0)
                     s_TCM_Oh_est = (s_ncloaded_est + 1)/2 + 4;
                  else
                     s_TCM_Oh_est = 0;

                  s_Lp_est = s_Lp_est + s_TCM_Oh_est;

                  if (s_Lp_est < RX_MAX_BITS_PER_TONE * (gs_RxLastChannel - gs_RxFirstChannel +1))
                  { // considered a pausible config

                     for (gs_maxlatency_array = 0; gs_maxlatency_array < 7; gs_maxlatency_array += 1)
                     {
                        gs_maxlatency = s_savelatencyvalue[gs_maxlatency_array];

                        gt_HandshakeBis.sa_DS_MaxDataRateLP[LP0_DATA_PATH] = gs_maxdatarate_in;


                        gt_HandshakeBis.sa_DS_MaxNetDataRateBC[0] = gs_maxdatarate_in;

                        if (test_run <= 1)
                           /* TEST MIN= MAX */
                           gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[0]  = gs_maxdatarate_in;
                        else
                           /* TEST MIN < MAX */
                           gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[0]  = 8;


                        gt_HandshakeBis.s_MinMSGDSOverheadRate = gs_ovhdrate_in;

                        gt_HandshakeBis.sa_DS_MaxLatencyBC[0] = gs_maxlatency;
                        /* define which Bearer channels and latency paths are active */

                        gt_HandshakeBis.sa_DS_BCActive[0] = 1;
                        gt_HandshakeBis.sa_DS_BCActive[1] = 0;
                        gt_HandshakeBis.s_NumDSLatencyPaths = 1;     /* DS number of latency paths activated */

                        // initialize the margin to be 6 dB
                        gs_RxDesiredMargin=DESIRED_SNR_MARGIN;

                        gs_RxNumTones=512;


                        /*****************************************************************
                        Initialze the medley and reverb3 snr and RX num Tones
                        *****************************************************************/

                        for(i=0;i<gs_RxNumTones;i++)
                        {
                           gsa_ReverbSnrBuf[i]=(int16)(gsa_my_MedleySnrBuf[i]);
                           gsa_ReverbEchoSnrBuf[i]=(int16)(gsa_my_MedleySnrBuf[i]);
                           gusa_DS_Tssi_Value[i] = gusa_DS_Tssi_Value1[i];
                        }

                        copy_my_medley_snr(gsa_MedleySnrBuf, gsa_my_MedleySnrBuf);

                        // calls bitload_bis
                        BgMedleyBitload_bis();

                        if (gft_BitloadOK)
                        {
                           //compute back the final parameters, mainly to see the final results on data rates and final latency
                           gs_BytesForBC0_final = gt_PMSParams.sa_Bpn[LP0_DATA_PATH][DS_AS0_BEARER_CHANNEL];
                           gs_BytesForBC1_final =  gt_PMSParams.sa_Bpn[LP0_DATA_PATH][DS_AS1_BEARER_CHANNEL];
                           gs_Kp_MDF_final=gs_BytesForBC0_final + gs_BytesForBC1_final + 1;
                           gs_Dp_final=gt_PMSParams.s_Dp[LP0_DATA_PATH];
                           gs_Mp_final=gt_PMSParams.s_Mp[LP0_DATA_PATH];
                           gs_Rp_final=gt_PMSParams.s_Rp[LP0_DATA_PATH];
                           gs_Lp_final=gt_PMSParams.s_Lp[LP0_DATA_PATH];
                           gs_Tp_final=gt_PMSParams.s_Tp[LP0_DATA_PATH];

                           if(gft_TcmFlag_bis_DS == TRUE)
                           {
                              gs_TCM_Oh_final =(((int16) gus_ncloaded - (gus_Rx_Tcm_Num1bits >> 1) + 1) >> 1) + 4;
                           }
                           else
                              gs_TCM_Oh_final=0;

                           gs_CWSize_final = gs_Kp_MDF_final*gs_Mp_final + gs_Rp_final;
                           gs_Sp_final = (int16)(8 * gs_CWSize_final*256/ gs_Lp_final); // Sp in 8.8 format

                           // net data rate (bits per frame)
                           gs_net_datarate_final = (int16)((((gs_Tp_final*gs_Kp_MDF_final-1)*gs_Mp_final*((int32)(gs_Lp_final*16)))/(gs_Tp_final*(gs_Kp_MDF_final*gs_Mp_final+gs_Rp_final))+8)/16);

                           // overhead rate is in kbps (final rate is in 8.8 format)
                           gs_ovhd_rate_final=(int16)((gs_Mp_final*((int32)gs_Lp_final)*4*256)/(gs_Tp_final*(gs_Kp_MDF_final*gs_Mp_final+gs_Rp_final)));
                           gs_latency_final= (int16)((int32)gs_Sp_final * gs_Dp_final / 4); // 8.8 format (ms)

                           s_BatCheck = VerifyBat((uint8 *)&guca_RxBat[0]);
                           /**************************************************************************************
                           INP is impulse noise protection = (1/2) (S*D) (R/CWSize)
                           ***************************************************************************************/

                           if(gs_CWSize_final != 0)
                              INP = (gs_Sp_final*gs_Dp_final * gs_Rp_final/(2*gs_CWSize_final));

                           else
                              INP=0;

                              /**************************************************************************************
                              Save the final computed parameters
                           ***************************************************************************************/
                           datarate_final = (float)(  (gs_Tp_final * gs_Kp_MDF_final - 1) *  gs_Mp_final * (float)(gs_Lp_final) / (gs_Tp_final * gs_CWSize_final));
                           datarate_diff = datarate_final- (float) gs_maxdatarate_in ;

                           datarate_msgc = (float) (gs_ovhd_rate_final* gs_MSGc_final)/(256*(gs_MSGc_final+6));

                           /* compute RMS fine gain value */
                           l_Prod = (int32) ComputeRMSFineGain(guca_RxBat, gsa_RxFineGains, gs_RxNumTones, gs_CurrentCoChipset, 0, 0);

                           gt_TxPMDControl.us_RMSGI_DS = 2* (ConvertToDB(l_Prod)  -  ConvertToDB(8192));
                        }
                        if (gt_TxPMDControl.us_RMSGI_DS > 0)
                        {
                           s_error_code = 2;
                        }


                        if ((s_BatCheck == FAIL) || (gft_BitloadOK == FAIL))
                        {
                           fprintf(file_pms,"%8.1f\t %ld\t %ld\t %ld\t %ld\t %ld\t %ld\t %ld\t %ld\t %ld\t %ld\t  %ld\t %ld\t %ld\t  %ld\t %ld\t %8.2f\t %8.2f\t %ld\t  %ld\t  %ld\t %ld\t %8.2f\t %ld\t",s_actual_inp , gs_maxdatarate_in, gs_ovhdrate_in, gs_maxlatency,  gs_Kp_MDF_final, gs_Dp_final,   gs_Mp_final,   gs_Rp_final, gs_Lp_final,  gs_Tp_final,gs_CWSize_final,gs_Sp_final,gs_net_datarate_final,gs_ovhd_rate_final,gs_latency_final, INP, datarate_final, datarate_diff,gus_BitloadExceptionCode,  gs_seq_final, gs_MSGc_final, gs_per_final, datarate_msgc, gt_TxPMDControl.us_RMSGI_DS);

                           fprintf(file_pms, "***ERROR:");
                           // First check for BitloadOK failure
                           if (gft_BitloadOK == FAIL)
                              fprintf(file_pms, "BitloadOK=FAIL***\n");
                           // Then if BitloadOK is ok, check for bad Bat.
                           else if (s_BatCheck == FAIL)
                              fprintf(file_pms, "Bad BAT***\n");
                           ;
                        }
                        else
                           fprintf(file_pms,"%8.1f\t %ld\t %ld\t %ld\t %ld\t %ld\t %ld\t %ld\t %ld\t %ld\t %ld\t  %ld\t %ld\t %ld\t  %ld\t %ld\t %8.2f\t %8.2f\t %ld %ld\t  %ld\t %ld\t %8.2f\t %ld\t\n", s_actual_inp, gs_maxdatarate_in, gs_ovhdrate_in, gs_maxlatency,  gs_Kp_MDF_final,  gs_Dp_final,   gs_Mp_final,   gs_Rp_final, gs_Lp_final,  gs_Tp_final,gs_CWSize_final,gs_Sp_final,gs_net_datarate_final,gs_ovhd_rate_final,gs_latency_final, INP,  datarate_final,datarate_diff, gus_BitloadExceptionCode, gs_seq_final, gs_MSGc_final, gs_per_final, datarate_msgc, gt_TxPMDControl.us_RMSGI_DS);



                        // reset all the global variables and pms structure
                        gs_Kp_MDF_final= 0;
                        gs_Dp_final=0;
                        gs_Mp_final=0;
                        gs_Rp_final=0;
                        gs_Lp_final=0;
                        gs_Tp_final=0;
                        gs_CWSize_final = 0;
                        gs_Sp_final = 0;
                        gs_net_datarate_final = 0;
                        gs_ovhd_rate_final=0;
                        gs_latency_final= 0;
                        gus_BitloadExceptionCode = 0;
                        gs_found_valid_config =0;
                        gs_flag_fixedrate = 0;
                        gs_flag_limitedrate = 0;

                        gt_PMSParams.s_Dp[LP0_DATA_PATH] = 0;
                        gt_PMSParams.s_Mp[LP0_DATA_PATH] = 0;
                        gt_PMSParams.s_Rp[LP0_DATA_PATH] = 0;
                        gt_PMSParams.s_Tp[LP0_DATA_PATH] = 0;
                        gt_PMSParams.s_Lp[LP0_DATA_PATH] = 0 ;

                        gs_iter_conv=0;

                  } // latency
            } // valid config
         } //ovhdrate
      } // max data rate
   } // gs_INP
   fcloseall();
   } // test_run


   // TEST ADSL2 PLUS BITLOADING ADAPTIVE RATE

   //    file_pms=fopen("test14.txt","w");

   file_pms=fopen(argv[14],"w");

   gs_RxLastChannel = 511;
   gs_max_CWSize = 255;


   gs_RxBitLoadFirstChannel = gs_RxFirstChannel;
   gs_RxBitLoadLastChannel = gs_RxLastChannel;

   gft_FineGainOn = TRUE;

   gs_max_fine_gain =  640;      // 2.5dB in Q 8.8
   gs_min_fine_gain = -640;      // -2.5dB in Q8.8


   guca_RSCodingGain[0] = 0;
   guca_RSCodingGain[1]= RS_CODING_GAIN_2;
   guca_RSCodingGain[2]= RS_CODING_GAIN_4;
   guca_RSCodingGain[3]= RS_CODING_GAIN_6;
   guca_RSCodingGain[4]= RS_CODING_GAIN_8;
   guca_RSCodingGain[5]= RS_CODING_GAIN_10;
   guca_RSCodingGain[6]= RS_CODING_GAIN_12;
   guca_RSCodingGain[7]= RS_CODING_GAIN_14;
   guca_RSCodingGain[8]= RS_CODING_GAIN_16;

   for (i=0 ; i< RX_NUM_TONES ; i++)
      gsa_RxToneOrder[i] = i;

   for (i=gs_RxFirstChannel ; i<=gs_RxLastChannel ; i++)
      SETTONEFLAG(p_MEDLEYset_DS, i);

   // define BIS for standalone test
   gft_ModemType = G_DMT_BIS;

   STATArray[STAT_Mode] = (int16)STAT_ConfigMode_G992_5_A;

   gt_HandshakeBis.s_OneOverSminADSL2 = 3;

   gl_SelectedMode = MODE_G992_5 | ANNEX_A;

   /*  We re-allocate the default values to the HS_BIS structure before entering bit-loading. */
   gt_HandshakeBis.sa_DS_MaxCheckbytesLP[LP0_DATA_PATH] = (int16) (2* MAX_R_LP0_DS);
   gt_HandshakeBis.sa_DS_MaxIntlvDepthLP[LP0_DATA_PATH] = (int16) 64;


   guc_MaxAllocBitsPerTone = RX_MAX_BITS_PER_TONE;

   gs_AuxPilotToneIdx = gs_CPilotTone;


   for (i=0; i<21; i++)
   {
      gs_supportedDvalues[i] = save_myD_Values_Old[i];
   }

   for (test_run=0; test_run <4; test_run++)
   {
      if(test_run==0) // set the parameters for tcm on
      {
         gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_0ft_plus; // 0ft
         fprintf(file_pms, "\n\t NULL LOOP \n");
      }

      if (test_run==1)
      {
         gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_plus_12kft;
         fprintf(file_pms, "\n\t 12 KFT LOOP \n");
      }

      if(test_run==2) // set the parameters for tcm on
      {
         gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_plus_13kft;
         fprintf(file_pms, "\n \t 13KFT LOOP \n");
      }

      if (test_run==3)
      {
         gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_plus_9kft;
         fprintf(file_pms, "\n\t 9KF LOOP \n");
      }


      for (test_case = 0; test_case<1; test_case++)
      {
         // consider two cases, in first don't enable INP over rate cmv

         if (test_case ==0)
         {
            OPTNArray[OPTN_AlgControl2] = !OPTN_FavorINPOverRate;
            fprintf(file_pms, "\t NOT ENABLE INP OVER RATE \n");
         }
         else if (test_case ==1)
         {
            OPTNArray[OPTN_AlgControl2] = OPTN_FavorINPOverRate;
            fprintf(file_pms, "\tENABLE INP OVER RATE\n");
         }

         OPTNArray[OPTN_AlgControl] = 0x0FF8;
         gs_tcm_coding_gain = TCM_CODING_GAIN;
         gs_max_coding_gain = MAX_CODING_GAIN;

         // Point Task layer pointers to locally defined buffers.

         copy_my_medley_snr(gsa_MedleySnrBuf, gsa_my_MedleySnrBuf);

         gsa_RxShowtimeSnrBuf = gsa_my_RxShowtimeSnrBuf_Plus;
         gsa_RxFineGains = gsa_my_RxFineGains;
         gsa_RxToneOrder = gsa_my_RxToneOrder;

         /*  SNR's (in dB) required for QAM */

         gsa_ConstellationSNR[0] = 0x0B4F;   /*  11.31 dB =  1 bit (NOT USED) */
         gsa_ConstellationSNR[1] = 0x0B4F;   /*  11.31 dB =  1 bit (NOT USED) */
         gsa_ConstellationSNR[2] = 0x0E51; /*  14.32 dB =  2 bits  */
         gsa_ConstellationSNR[3] = 0x131C;   /*  19.11 dB =  3 bits */
         gsa_ConstellationSNR[4] = 0x154F;   /*  21.31 dB =  4 bits */
         gsa_ConstellationSNR[5] = 0x1875;   /*  24.46 dB =  5 bits */
         gsa_ConstellationSNR[6] = 0x1B8A;   /*  27.54 dB =  6 bits */
         gsa_ConstellationSNR[7] = 0x1E97;   /*  30.59 dB =  7 bits */
         gsa_ConstellationSNR[8] = 0x219C;   /*  33.61 dB =  8 bits */
         gsa_ConstellationSNR[9] = 0x24A1;   /*  36.63 dB =  9 bits */
         gsa_ConstellationSNR[10] = 0x27A6; /*  39.65 dB = 10 bits */
         gsa_ConstellationSNR[11] = 0x2AA8; /*  42.66 dB = 11 bits */
         gsa_ConstellationSNR[12] = 0x2DAB; /*  45.67 dB = 12 bits */
         gsa_ConstellationSNR[13] = 0x30AE;  /*  48.68 dB = 13 bits */
         gsa_ConstellationSNR[14] = 0x33B0; /*  51.69 dB = 14 bits */
         gsa_ConstellationSNR[15] = 0x36B3; /*  54.70 dB = 15 bits */

         fprintf(file_pms, "INP\t  msg_ovhdrate\t maxlatency\t Kp\t Dp\t Mp\t Rp\t Lp\t Tp\t CWSize\t Sp(8.8)\t net_datarate\t ovhd_rate\t latency_achvd\t INP_achvd\t  datarate\t Ex_code\t  RMSGain\t\n");

         /***********************************************************************
         Loop thru various values of max data rate, overhead rate and latency

         ***********************************************************************/
         for (gs_INP_in = 0 ; gs_INP_in < 7 ; gs_INP_in++)
         {
            /* Initialize the handshake parameters for standalone test */

               if (gs_INP_in == 0)
               {
                  /* Initialize the handshake parameters for standalone test */
                  gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 0;
                  s_actual_inp = 0;
               }
               else if (gs_INP_in == 1)
               {
                  gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 1; // 0.5 frame protection
                  s_actual_inp = 0.5;
               }
               else if (gs_INP_in == 2)
               {
                  gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 2; // 1 frame protection
                  s_actual_inp = 1;
               }
               else if (gs_INP_in == 3)
               {
                  gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 4; // 2 frame protection
                  s_actual_inp = 2;
               }
               else if (gs_INP_in == 4)
               {
                  gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 8; // 4 frame protection
                  s_actual_inp = 4;
               }
               else if (gs_INP_in == 5)
               {
                  gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 16 ;// 8 frame protection
                  s_actual_inp = 8;
               }
               else if (gs_INP_in == 6)
               {
                  gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 32; // 16 frame protection
                  s_actual_inp = 16;
               }


            gs_maxdatarate_in = 8000;

            for (gs_ovhdrate_in = 4; gs_ovhdrate_in < 6; gs_ovhdrate_in+=8)
            {
               for (gs_maxlatency_array = 0; gs_maxlatency_array < 7; gs_maxlatency_array += 1)
               {
                  gs_maxlatency = s_savelatencyvalue[gs_maxlatency_array];

                  gt_HandshakeBis.sa_DS_MaxDataRateLP[LP0_DATA_PATH] = 8000;


                  gt_HandshakeBis.sa_DS_MaxNetDataRateBC[0] = gs_maxdatarate_in;


                  gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[0]  = 8;


                  gt_HandshakeBis.s_MinMSGDSOverheadRate = gs_ovhdrate_in;

                  gt_HandshakeBis.sa_DS_MaxLatencyBC[0] = gs_maxlatency;
                  /* define which Bearer channels and latency paths are active */

                  gt_HandshakeBis.sa_DS_BCActive[0] = 1;
                  gt_HandshakeBis.sa_DS_BCActive[1] = 0;
                  gt_HandshakeBis.s_NumDSLatencyPaths = 1;     /* DS number of latency paths activated */

                  // initialize the margin to be 6 dB
                  gs_RxDesiredMargin=DESIRED_SNR_MARGIN;

                  gs_RxNumTones=512;


                  /*****************************************************************
                  Initialze the medley and reverb3 snr and RX num Tones
                  *****************************************************************/

                  for(i=0;i<gs_RxNumTones;i++)
                  {
                     gsa_ReverbSnrBuf[i]=(int16)(gsa_my_MedleySnrBuf[i]);
                     gsa_ReverbEchoSnrBuf[i]=(int16)(gsa_my_MedleySnrBuf[i]);
                     gusa_DS_Tssi_Value[i] = gusa_DS_Tssi_Value1[i];
                  }

                  copy_my_medley_snr(gsa_MedleySnrBuf, gsa_my_MedleySnrBuf);

                  // calls bitload_bis
                  BgMedleyBitload_bis();
                  if (gft_BitloadOK)
                  {

                     //compute back the final parameters, mainly to see the final results on data rates and final latency
                     gs_BytesForBC0_final = gt_PMSParams.sa_Bpn[LP0_DATA_PATH][DS_AS0_BEARER_CHANNEL];
                     gs_BytesForBC1_final =  gt_PMSParams.sa_Bpn[LP0_DATA_PATH][DS_AS1_BEARER_CHANNEL];
                     gs_Kp_MDF_final=gs_BytesForBC0_final + gs_BytesForBC1_final + 1;
                     gs_Dp_final=gt_PMSParams.s_Dp[LP0_DATA_PATH];
                     gs_Mp_final=gt_PMSParams.s_Mp[LP0_DATA_PATH];
                     gs_Rp_final=gt_PMSParams.s_Rp[LP0_DATA_PATH];
                     gs_Lp_final=gt_PMSParams.s_Lp[LP0_DATA_PATH];
                     gs_Tp_final=gt_PMSParams.s_Tp[LP0_DATA_PATH];

                     if(gft_TcmFlag_bis_DS == TRUE)
                     {
                        gs_TCM_Oh_final =(((int16) gus_ncloaded - (gus_Rx_Tcm_Num1bits >> 1) + 1) >> 1) + 4;
                     }
                     else
                        gs_TCM_Oh_final=0;

                     gs_CWSize_final = gs_Kp_MDF_final*gs_Mp_final + gs_Rp_final;
                     gs_Sp_final = (int16)(8 * gs_CWSize_final*256/ gs_Lp_final); // Sp in 8.8 format

                     // net data rate (bits per frame)
                     gs_net_datarate_final = (int16)((((gs_Tp_final*gs_Kp_MDF_final-1)*gs_Mp_final*((int32)(gs_Lp_final*16)))/(gs_Tp_final*(gs_Kp_MDF_final*gs_Mp_final+gs_Rp_final))+8)/16);

                     // overhead rate is in kbps (final rate is in 8.8 format)
                     gs_ovhd_rate_final=(int16)((gs_Mp_final*((int32)gs_Lp_final)*4*256)/(gs_Tp_final*(gs_Kp_MDF_final*gs_Mp_final+gs_Rp_final)));
                     gs_latency_final= (int16)((int32)gs_Sp_final * gs_Dp_final / 4); // 8.8 format (ms)

                     s_BatCheck = VerifyBat((uint8 *)&guca_RxBat[0]);
                     /**************************************************************************************
                     INP is impulse noise protection = (1/2) (S*D) (R/CWSize)
                     ***************************************************************************************/

                     if(gs_CWSize_final != 0)
                        INP = (gs_Sp_final*gs_Dp_final * gs_Rp_final/(2*gs_CWSize_final));

                     else
                        INP=0;

                        /**************************************************************************************
                        Save the final computed parameters
                     ***************************************************************************************/
                     datarate_final = (float)(  (gs_Tp_final * gs_Kp_MDF_final - 1) *  gs_Mp_final * (float)(gs_Lp_final) / (gs_Tp_final * gs_CWSize_final));

                     datarate_msgc = (float) (gs_ovhd_rate_final* gs_MSGc_final)/(256*(gs_MSGc_final+6));

                     /* compute RMS fine gain value */
                     l_Prod = (int32) ComputeRMSFineGain(guca_RxBat, gsa_RxFineGains, gs_RxNumTones, gs_CurrentCoChipset, 0, 0);

                     gt_TxPMDControl.us_RMSGI_DS = 2* (ConvertToDB(l_Prod)  -  ConvertToDB(8192));
                  }
                  if (gt_TxPMDControl.us_RMSGI_DS > 0)
                  {
                     s_error_code = 2;
                  }


                  if ((s_BatCheck == FAIL) || (gft_BitloadOK == FAIL))
                  {
                     gs_net_datarate_final=0;
                     fprintf(file_pms,"%8.1f\t %ld\t  %ld\t %ld\t %ld\t %ld\t  %ld\t %ld\t %ld\t %ld\t  %ld\t %ld\t %ld\t  %ld\t %ld\t %8.2f\t %ld\t   %ld\t", s_actual_inp ,  gs_ovhdrate_in, gs_maxlatency,  gs_Kp_MDF_final,  gs_Dp_final,   gs_Mp_final,   gs_Rp_final, gs_Lp_final,  gs_Tp_final,gs_CWSize_final,gs_Sp_final,gs_net_datarate_final,gs_ovhd_rate_final,gs_latency_final, INP, datarate_final,gus_BitloadExceptionCode,   gt_TxPMDControl.us_RMSGI_DS);

                     fprintf(file_pms, "***ERROR:");
                     // First check for BitloadOK failure
                     if (gft_BitloadOK == FAIL)
                        fprintf(file_pms, "BitloadOK=FAIL***\n");
                     // Then if BitloadOK is ok, check for bad Bat.
                     else if (s_BatCheck == FAIL)
                        fprintf(file_pms, "Bad BAT***\n");
                     ;
                  }
                  else
                  {
                     s_maxintlvdepth = (gs_CWSize_final-1) * (gs_Dp_final-1);
                     fprintf(file_pms,"%8.1f\t  %ld\t %ld\t %ld\t%ld\t %ld\t %ld\t %ld\t %ld\t %ld\t %ld\t  %ld\t %ld\t %ld\t  %ld\t  %8.2f\t %ld\t %ld\t %ld\t  \n", s_actual_inp,  gs_ovhdrate_in, gs_maxlatency,  gs_Kp_MDF_final,  gs_Dp_final,   gs_Mp_final,   gs_Rp_final, gs_Lp_final,  gs_Tp_final,gs_CWSize_final,gs_Sp_final,gs_net_datarate_final * 4,gs_ovhd_rate_final,gs_latency_final, INP,  datarate_final, gus_BitloadExceptionCode,  gt_TxPMDControl.us_RMSGI_DS, s_maxintlvdepth);
                  }


                  // reset all the global variables and pms structure
                  gs_Kp_MDF_final= 0;
                  gs_Dp_final=0;
                  gs_Mp_final=0;
                  gs_Rp_final=0;
                  gs_Lp_final=0;
                  gs_Tp_final=0;
                  gs_CWSize_final = 0;
                  gs_Sp_final = 0;
                  gs_net_datarate_final = 0;
                  gs_ovhd_rate_final=0;
                  gs_latency_final= 0;
                  gus_BitloadExceptionCode = 0;
                  gs_found_valid_config =0;
                  gs_flag_fixedrate = 0;
                  gs_flag_limitedrate = 0;

                  gt_PMSParams.s_Dp[LP0_DATA_PATH] = 0;
                  gt_PMSParams.s_Mp[LP0_DATA_PATH] = 0;
                  gt_PMSParams.s_Rp[LP0_DATA_PATH] = 0;
                  gt_PMSParams.s_Tp[LP0_DATA_PATH] = 0;
                  gt_PMSParams.s_Lp[LP0_DATA_PATH] = 0 ;

                  gs_iter_conv=0;

                  } // latency

            } //ovhdrate
         } // gs_INP
      } // test_case
   } // test_run

   fcloseall();
#endif

#ifdef TESTALL
   // TEST ADSL2 PLUS BITLOADING ADAPTIVE RATE

   //    file_pms=fopen("test15_extended_SandD.txt","w");

   file_pms=fopen(argv[15],"w");

   gs_RxLastChannel = 511;
   gs_max_CWSize = 255;


   gs_RxBitLoadFirstChannel = gs_RxFirstChannel;
   gs_RxBitLoadLastChannel = gs_RxLastChannel;

   gft_FineGainOn = TRUE;

   gs_max_fine_gain =  640;      // 2.5dB in Q 8.8
   gs_min_fine_gain = -640;      // -2.5dB in Q8.8


   guca_RSCodingGain[0] = 0;
   guca_RSCodingGain[1]= RS_CODING_GAIN_2;
   guca_RSCodingGain[2]= RS_CODING_GAIN_4;
   guca_RSCodingGain[3]= RS_CODING_GAIN_6;
   guca_RSCodingGain[4]= RS_CODING_GAIN_8;
   guca_RSCodingGain[5]= RS_CODING_GAIN_10;
   guca_RSCodingGain[6]= RS_CODING_GAIN_12;
   guca_RSCodingGain[7]= RS_CODING_GAIN_14;
   guca_RSCodingGain[8]= RS_CODING_GAIN_16;

   for (i=0 ; i< RX_NUM_TONES ; i++)
      gsa_RxToneOrder[i] = i;

   for (i=gs_RxFirstChannel ; i<=gs_RxLastChannel ; i++)
      SETTONEFLAG(p_MEDLEYset_DS, i);

   // define BIS for standalone test
   gft_ModemType = G_DMT_BIS;

   STATArray[STAT_Mode] = (int16)STAT_ConfigMode_G992_5_A;

   gl_SelectedMode = MODE_G992_5 | ANNEX_A;

   gt_HandshakeBis.s_OneOverSminADSL2 = 16;

   /*  We re-allocate the default values to the HS_BIS structure before entering bit-loading. */
   gt_HandshakeBis.sa_DS_MaxCheckbytesLP[LP0_DATA_PATH] = (int16) (2* MAX_R_LP0_DS);
   gt_HandshakeBis.sa_DS_MaxIntlvDepthLP[LP0_DATA_PATH] = (int16) 511;

   guc_MaxAllocBitsPerTone = RX_MAX_BITS_PER_TONE;

   gs_AuxPilotToneIdx = gs_CPilotTone;


   for (i=0; i<21; i++)
   {
      gs_supportedDvalues[i] = save_myD_Values_New[i];
   }

   for (test_run=0; test_run <4; test_run++)
   {
      if(test_run==0) // set the parameters for tcm on
      {
         gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_0ft_plus; // 0ft
         fprintf(file_pms, "\n\t NULL LOOP \n");
      }

      if (test_run==1)
      {
         gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_plus_12kft;
         fprintf(file_pms, "\n\t 12 KFT LOOP \n");
      }

      if(test_run==2) // set the parameters for tcm on
      {
         gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_plus_13kft;
         fprintf(file_pms, "\n \t 13KFT LOOP \n");
      }

      if (test_run==3)
      {
         gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_plus_9kft;
         fprintf(file_pms, "\n\t 9KF LOOP \n");
      }


      for (test_case = 0; test_case<1; test_case++)
      {
         // consider two cases, in first don't enable INP over rate cmv

         if (test_case ==0)
         {
            OPTNArray[OPTN_AlgControl2] = !OPTN_FavorINPOverRate;
            fprintf(file_pms, "\t NOT ENABLE INP OVER RATE \n");
         }
         else if (test_case ==1)
         {
            OPTNArray[OPTN_AlgControl2] = OPTN_FavorINPOverRate;
            fprintf(file_pms, "\tENABLE INP OVER RATE\n");
         }

         OPTNArray[OPTN_AlgControl] = 0x0FF8;
         gs_tcm_coding_gain = TCM_CODING_GAIN;
         //       OPTNArray[OPTN_AlgControl] = 0x2FF8;
         //       gs_tcm_coding_gain = 0;
         gs_max_coding_gain = MAX_CODING_GAIN;

         // Point Task layer pointers to locally defined buffers.

         copy_my_medley_snr(gsa_MedleySnrBuf, gsa_my_MedleySnrBuf);

         gsa_RxShowtimeSnrBuf = gsa_my_RxShowtimeSnrBuf_Plus;
         gsa_RxFineGains = gsa_my_RxFineGains;
         gsa_RxToneOrder = gsa_my_RxToneOrder;

         /*  SNR's (in dB) required for QAM */

         gsa_ConstellationSNR[0] = 0x0B4F;   /*  11.31 dB =  1 bit (NOT USED) */
         gsa_ConstellationSNR[1] = 0x0B4F;   /*  11.31 dB =  1 bit (NOT USED) */
         gsa_ConstellationSNR[2] = 0x0E51; /*  14.32 dB =  2 bits  */
         gsa_ConstellationSNR[3] = 0x131C;   /*  19.11 dB =  3 bits */
         gsa_ConstellationSNR[4] = 0x154F;   /*  21.31 dB =  4 bits */
         gsa_ConstellationSNR[5] = 0x1875;   /*  24.46 dB =  5 bits */
         gsa_ConstellationSNR[6] = 0x1B8A;   /*  27.54 dB =  6 bits */
         gsa_ConstellationSNR[7] = 0x1E97;   /*  30.59 dB =  7 bits */
         gsa_ConstellationSNR[8] = 0x219C;   /*  33.61 dB =  8 bits */
         gsa_ConstellationSNR[9] = 0x24A1;   /*  36.63 dB =  9 bits */
         gsa_ConstellationSNR[10] = 0x27A6; /*  39.65 dB = 10 bits */
         gsa_ConstellationSNR[11] = 0x2AA8; /*  42.66 dB = 11 bits */
         gsa_ConstellationSNR[12] = 0x2DAB; /*  45.67 dB = 12 bits */
         gsa_ConstellationSNR[13] = 0x30AE;  /*  48.68 dB = 13 bits */
         gsa_ConstellationSNR[14] = 0x33B0; /*  51.69 dB = 14 bits */
         gsa_ConstellationSNR[15] = 0x36B3; /*  54.70 dB = 15 bits */

         fprintf(file_pms, "INP\t  msg_ovhdrate\t maxlatency\t Kp\t Dp\t Mp\t Rp\t Lp\t Tp\t CWSize\t Sp(8.8)\t net_datarate\t ovhd_rate\t latency_achvd\t INP_achvd\t  datarate\t Ex_code\t  RMSGain\t\n");

         /***********************************************************************
         Loop thru various values of max data rate, overhead rate and latency

         ***********************************************************************/
         for (gs_INP_in = 0 ; gs_INP_in < 33 ; gs_INP_in=gs_INP_in+2)
         {
            // Consider all continuous values of INP 0-16
            /* Initialize the handshake parameters for standalone test */

            gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] =  gs_INP_in;
            s_actual_inp=gs_INP_in>> 1;

            if (gs_INP_in == 2) // 0.5 frame protection
            s_actual_inp=0.5;

            gs_maxdatarate_in = 8000;

            for (gs_ovhdrate_in = 4; gs_ovhdrate_in < 6; gs_ovhdrate_in+=8)
            {

               for (gs_maxlatency_array = 0; gs_maxlatency_array < 7; gs_maxlatency_array += 1)
               {
                  gs_maxlatency = s_savelatencyvalue[gs_maxlatency_array];

                  gt_HandshakeBis.sa_DS_MaxDataRateLP[LP0_DATA_PATH] = 8000;


                  gt_HandshakeBis.sa_DS_MaxNetDataRateBC[0] = gs_maxdatarate_in;


                  gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[0]  = 8;


                  gt_HandshakeBis.s_MinMSGDSOverheadRate = gs_ovhdrate_in;

                  gt_HandshakeBis.sa_DS_MaxLatencyBC[0] = gs_maxlatency;
                  /* define which Bearer channels and latency paths are active */

                  gt_HandshakeBis.sa_DS_BCActive[0] = 1;
                  gt_HandshakeBis.sa_DS_BCActive[1] = 0;
                  gt_HandshakeBis.s_NumDSLatencyPaths = 1;     /* DS number of latency paths activated */

                  // initialize the margin to be 6 dB
                  gs_RxDesiredMargin=DESIRED_SNR_MARGIN;

                  gs_RxNumTones=512;


                  /*****************************************************************
                  Initialze the medley and reverb3 snr and RX num Tones
                  *****************************************************************/

                  for(i=0;i<gs_RxNumTones;i++)
                  {
                     gsa_ReverbSnrBuf[i]=(int16)(gsa_my_MedleySnrBuf[i]);
                     gsa_ReverbEchoSnrBuf[i]=(int16)(gsa_my_MedleySnrBuf[i]);
                  }

                  copy_my_medley_snr(gsa_MedleySnrBuf, gsa_my_MedleySnrBuf);

                  // calls bitload_bis
                  BgMedleyBitload_bis();
                  if (gft_BitloadOK)
                  {

                     //compute back the final parameters, mainly to see the final results on data rates and final latency
                     gs_BytesForBC0_final = gt_PMSParams.sa_Bpn[LP0_DATA_PATH][DS_AS0_BEARER_CHANNEL];
                     gs_BytesForBC1_final =  gt_PMSParams.sa_Bpn[LP0_DATA_PATH][DS_AS1_BEARER_CHANNEL];
                     gs_Kp_MDF_final=gs_BytesForBC0_final + gs_BytesForBC1_final + 1;
                     gs_Dp_final=gt_PMSParams.s_Dp[LP0_DATA_PATH];
                     gs_Mp_final=gt_PMSParams.s_Mp[LP0_DATA_PATH];
                     gs_Rp_final=gt_PMSParams.s_Rp[LP0_DATA_PATH];
                     gs_Lp_final=gt_PMSParams.s_Lp[LP0_DATA_PATH];
                     gs_Tp_final=gt_PMSParams.s_Tp[LP0_DATA_PATH];

                     if(gft_TcmFlag_bis_DS == TRUE)
                     {
                        gs_TCM_Oh_final =(((int16) gus_ncloaded - (gus_Rx_Tcm_Num1bits >> 1) + 1) >> 1) + 4;
                     }
                     else
                        gs_TCM_Oh_final=0;

                     gs_CWSize_final = gs_Kp_MDF_final*gs_Mp_final + gs_Rp_final;
                     gs_Sp_final = (int16)(8 * gs_CWSize_final*256/ gs_Lp_final); // Sp in 8.8 format

                     // net data rate (bits per frame)
                     gs_net_datarate_final = (int16)((((gs_Tp_final*gs_Kp_MDF_final-1)*gs_Mp_final*((int32)(gs_Lp_final*16)))/(gs_Tp_final*(gs_Kp_MDF_final*gs_Mp_final+gs_Rp_final))+8)/16);

                     // overhead rate is in kbps (final rate is in 8.8 format)
                     gs_ovhd_rate_final=(int16)((gs_Mp_final*((int32)gs_Lp_final)*4*256)/(gs_Tp_final*(gs_Kp_MDF_final*gs_Mp_final+gs_Rp_final)));
                     gs_latency_final= (int16)((int32)gs_Sp_final * gs_Dp_final / 4); // 8.8 format (ms)

                     s_BatCheck = VerifyBat((uint8 *)&guca_RxBat[0]);
                     /**************************************************************************************
                     INP is impulse noise protection = (1/2) (S*D) (R/CWSize)
                     ***************************************************************************************/

                     if(gs_CWSize_final != 0)
                        INP = (gs_Sp_final*gs_Dp_final * gs_Rp_final/(2*gs_CWSize_final));

                     else
                        INP=0;

                        /**************************************************************************************
                        Save the final computed parameters
                     ***************************************************************************************/
                     datarate_final = (float)(  (gs_Tp_final * gs_Kp_MDF_final - 1) *  gs_Mp_final * (float)(gs_Lp_final) / (gs_Tp_final * gs_CWSize_final));

                     datarate_msgc = (float) (gs_ovhd_rate_final* gs_MSGc_final)/(256*(gs_MSGc_final+6));

                     /* compute RMS fine gain value */
                     l_Prod = (int32) ComputeRMSFineGain(guca_RxBat, gsa_RxFineGains, gs_RxNumTones, gs_CurrentCoChipset, 0, 0);

                     gt_TxPMDControl.us_RMSGI_DS = 2* (ConvertToDB(l_Prod)  -  ConvertToDB(8192));
                  }
                  if (gt_TxPMDControl.us_RMSGI_DS > 0)
                  {
                     s_error_code = 2;
                  }


                  if ((s_BatCheck == FAIL) || (gft_BitloadOK == FAIL))
                  {
                     gs_net_datarate_final=0;
                     fprintf(file_pms,"%8.1f\t %ld\t %ld\t %ld\t %ld\t %ld\t  %ld\t %ld\t %ld\t %ld\t  %ld\t %ld\t %ld\t  %ld\t %ld\t %8.2f\t %ld\t   %ld\t",s_actual_inp ,  gs_ovhdrate_in, gs_maxlatency,  gs_Kp_MDF_final, gs_Dp_final,   gs_Mp_final,   gs_Rp_final, gs_Lp_final,  gs_Tp_final,gs_CWSize_final,gs_Sp_final,gs_net_datarate_final,gs_ovhd_rate_final,gs_latency_final, INP, datarate_final,gus_BitloadExceptionCode,   gt_TxPMDControl.us_RMSGI_DS);

                     fprintf(file_pms, "***ERROR:");
                     // First check for BitloadOK failure
                     if (gft_BitloadOK == FAIL)
                        fprintf(file_pms, "BitloadOK=FAIL***\n");
                     // Then if BitloadOK is ok, check for bad Bat.
                     else if (s_BatCheck == FAIL)
                        fprintf(file_pms, "Bad BAT***\n");
                     ;
                  }
                  else
                  {
                     s_maxintlvdepth = (gs_CWSize_final-1) * (gs_Dp_final-1);
                     fprintf(file_pms,"%8.1f\t   %ld\t %ld\t %ld\t%ld\t %ld\t %ld\t %ld\t %ld\t %ld\t %ld\t  %ld\t %ld\t %ld\t  %ld\t  %8.2f\t  %ld\t %ld\t  %ld\t\n", s_actual_inp,  gs_ovhdrate_in, gs_maxlatency,  gs_Kp_MDF_final, gs_Dp_final,   gs_Mp_final,   gs_Rp_final, gs_Lp_final,  gs_Tp_final,gs_CWSize_final,gs_Sp_final,gs_net_datarate_final * 4,gs_ovhd_rate_final,gs_latency_final, INP,  datarate_final, gus_BitloadExceptionCode,  gt_TxPMDControl.us_RMSGI_DS, s_maxintlvdepth);
                  }


                  // reset all the global variables and pms structure
                  gs_Kp_MDF_final= 0;
                  gs_Dp_final=0;
                  gs_Mp_final=0;
                  gs_Rp_final=0;
                  gs_Lp_final=0;
                  gs_Tp_final=0;
                  gs_CWSize_final = 0;
                  gs_Sp_final = 0;
                  gs_net_datarate_final = 0;
                  gs_ovhd_rate_final=0;
                  gs_latency_final= 0;
                  gus_BitloadExceptionCode = 0;
                  gs_found_valid_config =0;
                  gs_flag_fixedrate = 0;
                  gs_flag_limitedrate = 0;

                  gt_PMSParams.s_Dp[LP0_DATA_PATH] = 0;
                  gt_PMSParams.s_Mp[LP0_DATA_PATH] = 0;
                  gt_PMSParams.s_Rp[LP0_DATA_PATH] = 0;
                  gt_PMSParams.s_Tp[LP0_DATA_PATH] = 0;
                  gt_PMSParams.s_Lp[LP0_DATA_PATH] = 0 ;


                  gs_iter_conv=0;

                  } // latency

            } //ovhdrate
         } // gs_INP
      } // test_case
   } // test_run

   fcloseall();
#endif


   // ADSL2 PLUS FIXED RATE TESTS, Running only the border cases with strict INP / latency
   // restrictions (many cases are not configured currently)

// file_pms=fopen("test.txt","w");
   gs_RxLastChannel = 511;
   gs_max_CWSize = 255;


   gs_RxBitLoadFirstChannel = gs_RxFirstChannel;
   gs_RxBitLoadLastChannel = gs_RxLastChannel;

   gft_FineGainOn = TRUE;

   gs_max_fine_gain =  640;      // 2.5dB in Q 8.8
   gs_min_fine_gain = -640;      // -2.5dB in Q8.8


   guca_RSCodingGain[0] = 0;
   guca_RSCodingGain[1]= RS_CODING_GAIN_2;
   guca_RSCodingGain[2]= RS_CODING_GAIN_4;
   guca_RSCodingGain[3]= RS_CODING_GAIN_6;
   guca_RSCodingGain[4]= RS_CODING_GAIN_8;
   guca_RSCodingGain[5]= RS_CODING_GAIN_10;
   guca_RSCodingGain[6]= RS_CODING_GAIN_12;
   guca_RSCodingGain[7]= RS_CODING_GAIN_14;
   guca_RSCodingGain[8]= RS_CODING_GAIN_16;

   for (i=0 ; i< RX_NUM_TONES ; i++)
      gsa_RxToneOrder[i] = i;

   for (i=gs_RxFirstChannel ; i<=gs_RxLastChannel ; i++)
      SETTONEFLAG(p_MEDLEYset_DS, i);

   // define BIS for standalone test
   gft_ModemType = G_DMT_BIS;

   STATArray[STAT_Mode] = (int16)STAT_ConfigMode_G992_5_A;

   gl_SelectedMode = MODE_G992_5 | ANNEX_A;

   gt_HandshakeBis.s_OneOverSminADSL2 = 16;

   /*  We re-allocate the default values to the HS_BIS structure before entering bit-loading. */
   gt_HandshakeBis.sa_DS_MaxCheckbytesLP[LP0_DATA_PATH] = (int16) (2* MAX_R_LP0_DS);
   gt_HandshakeBis.sa_DS_MaxIntlvDepthLP[LP0_DATA_PATH] = (int16) 511;

   guc_MaxAllocBitsPerTone = RX_MAX_BITS_PER_TONE;

   gs_AuxPilotToneIdx = gs_CPilotTone;


   for (i=0; i<21; i++)
   {
      gs_supportedDvalues[i] = save_myD_Values_New[i];
   }

   gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_0ft_plus; // 0ft
// fprintf(file_pms, "\n\t NULL LOOP \n");


   OPTNArray[OPTN_AlgControl2] = !OPTN_FavorINPOverRate;

   OPTNArray[OPTN_AlgControl] = 0x0FF8;
   gs_tcm_coding_gain = TCM_CODING_GAIN;
//       OPTNArray[OPTN_AlgControl] = 0x2FF8;
            //       gs_tcm_coding_gain = 0;
   gs_max_coding_gain = MAX_CODING_GAIN;

   // Point Task layer pointers to locally defined buffers.

   copy_my_medley_snr(gsa_MedleySnrBuf, gsa_my_MedleySnrBuf);

   gsa_RxShowtimeSnrBuf = gsa_my_RxShowtimeSnrBuf_Plus;
   gsa_RxFineGains = gsa_my_RxFineGains;
   gsa_RxToneOrder = gsa_my_RxToneOrder;

            /*  SNR's (in dB) required for QAM */

   gsa_ConstellationSNR[0] = 0x0B4F;   /*  11.31 dB =  1 bit (NOT USED) */
   gsa_ConstellationSNR[1] = 0x0B4F;   /*  11.31 dB =  1 bit (NOT USED) */
   gsa_ConstellationSNR[2] = 0x0E51; /*  14.32 dB =  2 bits  */
   gsa_ConstellationSNR[3] = 0x131C;   /*  19.11 dB =  3 bits */
   gsa_ConstellationSNR[4] = 0x154F;   /*  21.31 dB =  4 bits */
   gsa_ConstellationSNR[5] = 0x1875;   /*  24.46 dB =  5 bits */
   gsa_ConstellationSNR[6] = 0x1B8A;   /*  27.54 dB =  6 bits */
   gsa_ConstellationSNR[7] = 0x1E97;   /*  30.59 dB =  7 bits */
   gsa_ConstellationSNR[8] = 0x219C;   /*  33.61 dB =  8 bits */
   gsa_ConstellationSNR[9] = 0x24A1;   /*  36.63 dB =  9 bits */
   gsa_ConstellationSNR[10] = 0x27A6; /*  39.65 dB = 10 bits */
   gsa_ConstellationSNR[11] = 0x2AA8; /*  42.66 dB = 11 bits */
   gsa_ConstellationSNR[12] = 0x2DAB; /*  45.67 dB = 12 bits */
   gsa_ConstellationSNR[13] = 0x30AE;  /*  48.68 dB = 13 bits */
   gsa_ConstellationSNR[14] = 0x33B0; /*  51.69 dB = 14 bits */
   gsa_ConstellationSNR[15] = 0x36B3; /*  54.70 dB = 15 bits */



   for (test_run=0; test_run<2; test_run++)
   {
      // test_run=0; fixed rate and test_run=1, limited rate
      if (test_run==0)
      {
         // fixed rate
         file_pms=fopen(argv[16],"w");
         fprintf(file_pms, "\n FIXED RATE \n");
         fprintf(file_pms, "INP\t MAx rate\t  msg_ovhdrate\t maxlatency\t Kp\t Dp\t Mp\t Rp\t Lp\t Tp\t CWSize\t Sp(8.8)\t net_datarate\t ovhd_rate\t latency_achvd\t INP_achvd\t  datarate\t Ex_code\t  RMSGain\t\n");
      }
      else if (test_run==1)
      {
         // Limited Rate
         file_pms=fopen(argv[17],"w");
         fprintf(file_pms, "\n LIMITED RATE \n");
         fprintf(file_pms, "INP\t MAx rate\t  msg_ovhdrate\t maxlatency\t Kp\t Dp\t Mp\t Rp\t Lp\t Tp\t CWSize\t Sp(8.8)\t net_datarate\t ovhd_rate\t latency_achvd\t INP_achvd\t  datarate\t Ex_code\t  RMSGain\t\n");
      }

      /***********************************************************************
      Loop thru various values of max data rate, overhead rate and latency

      ***********************************************************************/
      for (gs_INP_in = 0 ; gs_INP_in < 7 ; gs_INP_in++)
      {
      /* Initialize the handshake parameters for standalone test
      set up latency limits based on INP just to test border cases
         also set max rate limits, based on achievable rate */

         if (gs_INP_in ==0)
         {
            gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = gs_INP_in;
            gs_maxlatency=1;
            s_max_datarate_lim = 7000;
            s_actual_inp = 0;

         }
         else if (gs_INP_in == 1)
         {
            gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 1;
            gs_maxlatency=2;
            s_max_datarate_lim = 6500;
            s_actual_inp = 0.5;

         }
         else if (gs_INP_in == 2)
         {
            gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 2;
            gs_maxlatency=2;
            s_max_datarate_lim = 5500;
            s_actual_inp = 1;

         }
         else if (gs_INP_in == 3)
         {
            gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 4;
            gs_maxlatency=2;
            s_max_datarate_lim = 2000;
            s_actual_inp = 2;

         }

         else if (gs_INP_in == 4)
         {
            gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 8; // 4 frame protection corresponds to 0111
            gs_maxlatency=4;
            s_max_datarate_lim = 2000;
            s_actual_inp = 4;
         }
         else if (gs_INP_in == 5)
         {
            gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 16 ;// 8 frame protection corresponds to 1011
            gs_maxlatency=8;
            s_max_datarate_lim = 2000;
            s_actual_inp = 8;
         }
         else if (gs_INP_in == 6)
         {
            gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 32; // 16 frame protection corresponds to 1111
            gs_maxlatency=16;
            s_max_datarate_lim = 1000;
            s_actual_inp = 16;
         }




         for (gs_maxdatarate_in=8; gs_maxdatarate_in < s_max_datarate_lim; gs_maxdatarate_in+=8)
         {

            for (gs_ovhdrate_in = 4; gs_ovhdrate_in < 6; gs_ovhdrate_in+=8)
            {


               gt_HandshakeBis.sa_DS_MaxNetDataRateBC[0] = gs_maxdatarate_in;

               if (test_run==0)
                  // fixed rate
                  gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[0]  = gs_maxdatarate_in; // min = max
               else if (test_run==1)
                  // limited rate
                  gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[0]  = 8;


               gt_HandshakeBis.sa_DS_MaxDataRateLP[LP0_DATA_PATH] = gs_maxdatarate_in;


               gt_HandshakeBis.s_MinMSGDSOverheadRate = gs_ovhdrate_in;

               gt_HandshakeBis.sa_DS_MaxLatencyBC[0] = gs_maxlatency;
               /* define which Bearer channels and latency paths are active */

               gt_HandshakeBis.sa_DS_BCActive[0] = 1;
               gt_HandshakeBis.sa_DS_BCActive[1] = 0;
               gt_HandshakeBis.s_NumDSLatencyPaths = 1;     /* DS number of latency paths activated */

               // initialize the margin to be 6 dB
               gs_RxDesiredMargin=DESIRED_SNR_MARGIN;

               gs_RxNumTones=512;


               /*****************************************************************
               Initialze the medley and reverb3 snr and RX num Tones
               *****************************************************************/

               for(i=0;i<gs_RxNumTones;i++)
               {
                  gsa_ReverbSnrBuf[i]=(int16)(gsa_my_MedleySnrBuf[i]);
                  gsa_ReverbEchoSnrBuf[i]=(int16)(gsa_my_MedleySnrBuf[i]);
               }

               copy_my_medley_snr(gsa_MedleySnrBuf, gsa_my_MedleySnrBuf);

               // calls bitload_bis
               BgMedleyBitload_bis();
               if (gft_BitloadOK)
               {

                  //compute back the final parameters, mainly to see the final results on data rates and final latency
                  gs_BytesForBC0_final = gt_PMSParams.sa_Bpn[LP0_DATA_PATH][DS_AS0_BEARER_CHANNEL];
                  gs_BytesForBC1_final =  gt_PMSParams.sa_Bpn[LP0_DATA_PATH][DS_AS1_BEARER_CHANNEL];
                  gs_Kp_MDF_final=gs_BytesForBC0_final + gs_BytesForBC1_final + 1;
                  gs_Dp_final=gt_PMSParams.s_Dp[LP0_DATA_PATH];
                  gs_Mp_final=gt_PMSParams.s_Mp[LP0_DATA_PATH];
                  gs_Rp_final=gt_PMSParams.s_Rp[LP0_DATA_PATH];
                  gs_Lp_final=gt_PMSParams.s_Lp[LP0_DATA_PATH];
                  gs_Tp_final=gt_PMSParams.s_Tp[LP0_DATA_PATH];

                  if(gft_TcmFlag_bis_DS == TRUE)
                  {
                     gs_TCM_Oh_final =(((int16) gus_ncloaded - (gus_Rx_Tcm_Num1bits >> 1) + 1) >> 1) + 4;
                  }
                  else
                     gs_TCM_Oh_final=0;

                  gs_CWSize_final = gs_Kp_MDF_final*gs_Mp_final + gs_Rp_final;
                  gs_Sp_final = (int16)(8 * gs_CWSize_final*256/ gs_Lp_final); // Sp in 8.8 format

                  // net data rate (bits per frame)
                  gs_net_datarate_final = (int16)((((gs_Tp_final*gs_Kp_MDF_final-1)*gs_Mp_final*((int32)(gs_Lp_final*16)))/(gs_Tp_final*(gs_Kp_MDF_final*gs_Mp_final+gs_Rp_final))+8)/16);

                  // overhead rate is in kbps (final rate is in 8.8 format)
                  gs_ovhd_rate_final=(int16)((gs_Mp_final*((int32)gs_Lp_final)*4*256)/(gs_Tp_final*(gs_Kp_MDF_final*gs_Mp_final+gs_Rp_final)));
                  gs_latency_final= (int16)((int32)gs_Sp_final * gs_Dp_final / 4); // 8.8 format (ms)

                  s_BatCheck = VerifyBat((uint8 *)&guca_RxBat[0]);
                  /**************************************************************************************
                  INP is impulse noise protection = (1/2) (S*D) (R/CWSize)
                  ***************************************************************************************/

                  if(gs_CWSize_final != 0)
                     INP = (gs_Sp_final*gs_Dp_final * gs_Rp_final/(2*gs_CWSize_final));

                  else
                     INP=0;

                     /**************************************************************************************
                     Save the final computed parameters
                  ***************************************************************************************/
                  datarate_final = (float)(  (gs_Tp_final * gs_Kp_MDF_final - 1) *  gs_Mp_final * (float)(gs_Lp_final) / (gs_Tp_final * gs_CWSize_final));

                  datarate_msgc = (float) (gs_ovhd_rate_final* gs_MSGc_final)/(256*(gs_MSGc_final+6));

                  /* compute RMS fine gain value */
                  l_Prod = (int32) ComputeRMSFineGain(guca_RxBat, gsa_RxFineGains, gs_RxNumTones, gs_CurrentCoChipset, 0, 0);

                  gt_TxPMDControl.us_RMSGI_DS = 2* (ConvertToDB(l_Prod)  -  ConvertToDB(8192));
               }
               if (gt_TxPMDControl.us_RMSGI_DS > 0)
               {
                  s_error_code = 2;
               }


               if ((s_BatCheck == FAIL) || (gft_BitloadOK == FAIL))
               {
                  gs_net_datarate_final=0;
                  fprintf(file_pms,"%8.1f\t %ld\t %ld\t %ld\t %ld\t %ld\t %ld\t  %ld\t %ld\t %ld\t %ld\t  %ld\t %ld\t %ld\t  %ld\t %ld\t %8.2f\t %ld\t   %ld\t",s_actual_inp , gs_maxdatarate_in, gs_ovhdrate_in, gs_maxlatency,  gs_Kp_MDF_final, gs_Dp_final,   gs_Mp_final,   gs_Rp_final, gs_Lp_final,  gs_Tp_final,gs_CWSize_final,gs_Sp_final,gs_net_datarate_final,gs_ovhd_rate_final,gs_latency_final, INP, datarate_final,gus_BitloadExceptionCode,   gt_TxPMDControl.us_RMSGI_DS);

                  fprintf(file_pms, "***ERROR:");
                  // First check for BitloadOK failure
                  if (gft_BitloadOK == FAIL)
                     fprintf(file_pms, "BitloadOK=FAIL***\n");
                  // Then if BitloadOK is ok, check for bad Bat.
                  else if (s_BatCheck == FAIL)
                     fprintf(file_pms, "Bad BAT***\n");
                  ;
               }
               else
               {
                  s_maxintlvdepth = (gs_CWSize_final-1) * (gs_Dp_final-1);
                  fprintf(file_pms,"%8.1f\t  %ld\t %ld\t %ld\t %ld\t%ld\t %ld\t %ld\t %ld\t %ld\t %ld\t %ld\t  %ld\t %ld\t %ld\t  %ld\t  %8.2f\t  %ld\t %ld\t  %ld\t\n", s_actual_inp, gs_maxdatarate_in, gs_ovhdrate_in, gs_maxlatency,  gs_Kp_MDF_final,  gs_Dp_final,   gs_Mp_final,   gs_Rp_final, gs_Lp_final,  gs_Tp_final,gs_CWSize_final,gs_Sp_final,gs_net_datarate_final * 4,gs_ovhd_rate_final,gs_latency_final, INP,  datarate_final, gus_BitloadExceptionCode,  gt_TxPMDControl.us_RMSGI_DS, s_maxintlvdepth);
               }


               // reset all the global variables and pms structure
               gs_Kp_MDF_final= 0;
               gs_Dp_final=0;
               gs_Mp_final=0;
               gs_Rp_final=0;
               gs_Lp_final=0;
               gs_Tp_final=0;
               gs_CWSize_final = 0;
               gs_Sp_final = 0;
               gs_net_datarate_final = 0;
               gs_ovhd_rate_final=0;
               gs_latency_final= 0;
               gus_BitloadExceptionCode = 0;
               gs_found_valid_config =0;
               gs_flag_fixedrate = 0;
               gs_flag_limitedrate = 0;

               gt_PMSParams.s_Dp[LP0_DATA_PATH] = 0;
               gt_PMSParams.s_Mp[LP0_DATA_PATH] = 0;
               gt_PMSParams.s_Rp[LP0_DATA_PATH] = 0;
               gt_PMSParams.s_Tp[LP0_DATA_PATH] = 0;
               gt_PMSParams.s_Lp[LP0_DATA_PATH] = 0 ;

               gs_iter_conv=0;


            } //ovhdrate
            } // max date rate
         } // gs_INP

fcloseall();

} // test_run



#ifdef TESTALL
   OPTNArray[OPTN_AlgControl2] = !OPTN_FavorINPOverRate;

   // TEST NOMATP code (ADSL2 PLUS )

   gs_RxLastChannel = 511;
   gs_max_CWSize = 255;


   gs_RxBitLoadFirstChannel = gs_RxFirstChannel;
   gs_RxBitLoadLastChannel = gs_RxLastChannel;

   gft_FineGainOn = TRUE;

   gs_max_fine_gain =  640;      // 2.5dB in Q 8.8
   gs_min_fine_gain = -640;      // -2.5dB in Q8.8


   guca_RSCodingGain[0] = 0;
   guca_RSCodingGain[1]= RS_CODING_GAIN_2;
   guca_RSCodingGain[2]= RS_CODING_GAIN_4;
   guca_RSCodingGain[3]= RS_CODING_GAIN_6;
   guca_RSCodingGain[4]= RS_CODING_GAIN_8;
   guca_RSCodingGain[5]= RS_CODING_GAIN_10;
   guca_RSCodingGain[6]= RS_CODING_GAIN_12;
   guca_RSCodingGain[7]= RS_CODING_GAIN_14;
   guca_RSCodingGain[8]= RS_CODING_GAIN_16;

   gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_plus_9kft;

   // Point Task layer pointers to locally defined buffers.

   copy_my_medley_snr(gsa_MedleySnrBuf, gsa_my_MedleySnrBuf);

   gsa_RxShowtimeSnrBuf = gsa_my_RxShowtimeSnrBuf_Plus;
   gsa_RxFineGains = gsa_my_RxFineGains;
   gsa_RxToneOrder = gsa_my_RxToneOrder;



   for (i=0 ; i< RX_NUM_TONES ; i++)
      gsa_RxToneOrder[i] = i;

   for (i=gs_RxFirstChannel ; i<=gs_RxLastChannel ; i++)
      SETTONEFLAG(p_MEDLEYset_DS, i);

   // define BIS for standalone test
   gft_ModemType = G_DMT_BIS;

   STATArray[STAT_Mode] = (int16) STAT_ConfigMode_G992_5_A;
   gt_HandshakeBis.s_OneOverSminADSL2 = 3;

   gl_SelectedMode = MODE_G992_5 | ANNEX_A;

   /*  We re-allocate the default values to the HS_BIS structure before entering bit-loading. */
   gt_HandshakeBis.sa_DS_MaxCheckbytesLP[LP0_DATA_PATH] = (int16) (2* MAX_R_LP0_DS);
   gt_HandshakeBis.sa_DS_MaxIntlvDepthLP[LP0_DATA_PATH] = (int16) 64;


   guc_MaxAllocBitsPerTone = RX_MAX_BITS_PER_TONE;

   gs_CPilotTone = C_PILOT_TONE_64;
   gs_AuxPilotToneIdx = gs_CPilotTone;
   gs_PilotToneIdx = gs_CPilotTone;
   CLEARTONEFLAG(p_MEDLEYset_DS, gs_CPilotTone);


   gft_EnableNomATP = 1;

   //    file_pms=fopen("result_nomATP_9kft.txt","w");

   file_pms=fopen(argv[13],"w");

   fprintf(file_pms, "RMSFINEGAIN\t MaxNomATP\t NomATP \t NomATP(CALCNOMATP)\t TotalBits\t LimitCause\t \n");


   gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_plus_9kft;

   // Point Task layer pointers to locally defined buffers.

   copy_my_medley_snr(gsa_MedleySnrBuf, gsa_my_MedleySnrBuf);

   OPTNArray[OPTN_AlgControl] = 0x0FF8;
   gs_tcm_coding_gain = TCM_CODING_GAIN;
   gs_max_coding_gain = MAX_CODING_GAIN;


   gsa_RxShowtimeSnrBuf = gsa_my_RxShowtimeSnrBuf_Plus;

   /*  SNR's (in dB) required for QAM */

   gsa_ConstellationSNR[0] = 0x0B4F;   /*  11.31 dB =  1 bit (NOT USED) */
   gsa_ConstellationSNR[1] = 0x0B4F;   /*  11.31 dB =  1 bit (NOT USED) */
   gsa_ConstellationSNR[2] = 0x0E51; /*  14.32 dB =  2 bits  */
   gsa_ConstellationSNR[3] = 0x131C;   /*  19.11 dB =  3 bits */
   gsa_ConstellationSNR[4] = 0x154F;   /*  21.31 dB =  4 bits */
   gsa_ConstellationSNR[5] = 0x1875;   /*  24.46 dB =  5 bits */
   gsa_ConstellationSNR[6] = 0x1B8A;   /*  27.54 dB =  6 bits */
   gsa_ConstellationSNR[7] = 0x1E97;   /*  30.59 dB =  7 bits */
   gsa_ConstellationSNR[8] = 0x219C;   /*  33.61 dB =  8 bits */
   gsa_ConstellationSNR[9] = 0x24A1;   /*  36.63 dB =  9 bits */
   gsa_ConstellationSNR[10] = 0x27A6; /*  39.65 dB = 10 bits */
   gsa_ConstellationSNR[11] = 0x2AA8; /*  42.66 dB = 11 bits */
   gsa_ConstellationSNR[12] = 0x2DAB; /*  45.67 dB = 12 bits */
   gsa_ConstellationSNR[13] = 0x30AE;  /*  48.68 dB = 13 bits */
   gsa_ConstellationSNR[14] = 0x33B0; /*  51.69 dB = 14 bits */
   gsa_ConstellationSNR[15] = 0x36B3; /*  54.70 dB = 15 bits */

   gt_FineGainInfo.s_ExcessMarFGReduction = 0x2000;


   /***********************************************************************
   Loop thru various values of max data rate, overhead rate and latency

   ***********************************************************************/
   for (s_MaxNomATP_DS = 0 ; s_MaxNomATP_DS < 25 ; s_MaxNomATP_DS++)
   {

      gt_TxPMDControl.s_MAXNOMATP_DS = s_MaxNomATP_DS - 20;

      /* Initialize the handshake parameters for standalone test */
      gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 0;
      gs_maxdatarate_in=8000;
      gs_ovhdrate_in = 4;
      gs_maxlatency =1;

      gt_HandshakeBis.sa_DS_MaxDataRateLP[LP0_DATA_PATH] = gs_maxdatarate_in;


      gt_HandshakeBis.sa_DS_MaxNetDataRateBC[0] = gs_maxdatarate_in;

      /* TEST MIN < MAX */
      gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[0]  = 8;


      gt_HandshakeBis.s_MinMSGDSOverheadRate = gs_ovhdrate_in;

      gt_HandshakeBis.sa_DS_MaxLatencyBC[0] = gs_maxlatency;
      /* define which Bearer channels and latency paths are active */

      gt_HandshakeBis.sa_DS_BCActive[0] = 1;
      gt_HandshakeBis.sa_DS_BCActive[1] = 0;
      gt_HandshakeBis.s_NumDSLatencyPaths = 1;     /* DS number of latency paths activated */

      // initialize the margin to be 6 dB
      gs_RxDesiredMargin=DESIRED_SNR_MARGIN;

      gs_RxNumTones=512;

      /*****************************************************************
      Initialze the medley and reverb3 snr and RX num Tones
      *****************************************************************/

      for(i=0;i<gs_RxNumTones;i++)
      {
         gsa_ReverbSnrBuf[i]=(int16)(gsa_my_MedleySnrBuf[i]);
         gsa_ReverbEchoSnrBuf[i]=(int16)(gsa_my_MedleySnrBuf[i]);
         gusa_DS_Tssi_Value[i] = gusa_DS_Tssi_Value1[i];
      }

      copy_my_medley_snr(gsa_MedleySnrBuf, gsa_my_MedleySnrBuf);

      // calls bitload_bis
      BgMedleyBitload_bis();



      /// fine gain in linear format (3.13)
      for(i=0;i<gs_RxNumTones;i++)
      {
         gsa_RxFineGainsLin[i] = DecimalGain(gsa_RxFineGains[i]) ;
      }

      s_NOMATP_DS = CalcNOMATP(0,(int16)DEFAULT_NOMPSD_DS,(int16)DEFAULT_MAXNOMATP_DS_204,gsa_RxFineGainsLin,gt_FineGainInfo.s_ExcessMarFGReduction,gusa_DS_Tssi_Value,p_MEDLEYset_DS,gs_RxNumTones, &(gt_TxPMDControl.s_NOMPSD_DS_dBmHz));


      // compute norm ATP float
      l_AddGiSqTssiSq = 0;
      for(i=0;i<gs_RxNumTones;i++)
      {
         if(IS_TONEFLAGSET(p_MEDLEYset_DS,i))
         {
            s_FGainLin = (int16)(DecimalGain(gsa_RxFineGains[i])+ (1<<3))>>4 ; //3.9
            l_SumFGainLinSq =( (int32)s_FGainLin * gt_FineGainInfo.s_ExcessMarFGReduction) >> 13   ;// 3.9

            l_GiSqTssiSq = ((int32)l_SumFGainLinSq * gusa_DS_Tssi_Value[i]) ; // 3.19
            l_GiSqTssiSq = round(l_GiSqTssiSq,6);
            s_FGainLin = (int16)(l_GiSqTssiSq);

            l_GiSqTssiSq = ((int32) s_FGainLin * s_FGainLin);
            l_GiSqTssiSq = round(l_GiSqTssiSq, 9);

            l_AddGiSqTssiSq = l_add(l_GiSqTssiSq,l_AddGiSqTssiSq) ;
         }
      }


      s_temp = ConvertToDB((int32)l_AddGiSqTssiSq);
      s_temp = s_temp - (2*(19-6)-9) * C_10LOG10_2 ; // 8.8
      s_temp = (int16)(TEN_LOG_DELTA_F + s_temp - (40<<8));

      l_test = (int32)s_temp *10;
      s_temp = (int16)(l_test >> 8);


      s_nomATP_dB = s_temp - DEFAULT_MAXNOMATP_DS_204;

      if (s_nomATP_dB <= s_MaxNomATP_DS - 20)
         fprintf(file_pms," %ld\t%ld\t %ld\t %ld\t %ld\t %ld\t\n",  gt_TxPMDControl.us_RMSGI_DS, s_MaxNomATP_DS - 20, s_NOMATP_DS, s_nomATP_dB, gs_TotalBitsSupported, -1);
      else
         fprintf(file_pms,"NOMATP VIOLATION\n");

      // reset all the global variables and pms structure
      gs_Kp_MDF_final= 0;
      gs_Dp_final=0;
      gs_Mp_final=0;
      gs_Rp_final=0;
      gs_Lp_final=0;
      gs_Tp_final=0;
      gs_CWSize_final = 0;
      gs_Sp_final = 0;
      gs_net_datarate_final = 0;
      gs_ovhd_rate_final=0;
      gs_latency_final= 0;
      gus_BitloadExceptionCode = 0;
      gs_found_valid_config =0;
      gs_flag_fixedrate = 0;
      gs_flag_limitedrate = 0;

      gt_PMSParams.s_Dp[LP0_DATA_PATH] = 0;
      gt_PMSParams.s_Mp[LP0_DATA_PATH] = 0;
      gt_PMSParams.s_Rp[LP0_DATA_PATH] = 0;
      gt_PMSParams.s_Tp[LP0_DATA_PATH] = 0;
      gt_PMSParams.s_Lp[LP0_DATA_PATH] = 0 ;


      gs_iter_conv=0;
   } // NOMATP

   fcloseall();

   // New Test to test the need for turning off trellis for PLUS test

   file_pms=fopen(argv[18],"w");

   TESTArray[TEST_Control2] = TEST_TrellisOnOff;


   gs_RxLastChannel = 511;
   gs_max_CWSize = 255;


   gs_RxBitLoadFirstChannel = gs_RxFirstChannel;
   gs_RxBitLoadLastChannel = gs_RxLastChannel;

   gft_FineGainOn = TRUE;

   gs_max_fine_gain =  640;      // 2.5dB in Q 8.8
   gs_min_fine_gain = -640;      // -2.5dB in Q8.8


   guca_RSCodingGain[0] = 0;
   guca_RSCodingGain[1]= RS_CODING_GAIN_2;
   guca_RSCodingGain[2]= RS_CODING_GAIN_4;
   guca_RSCodingGain[3]= RS_CODING_GAIN_6;
   guca_RSCodingGain[4]= RS_CODING_GAIN_8;
   guca_RSCodingGain[5]= RS_CODING_GAIN_10;
   guca_RSCodingGain[6]= RS_CODING_GAIN_12;
   guca_RSCodingGain[7]= RS_CODING_GAIN_14;
   guca_RSCodingGain[8]= RS_CODING_GAIN_16;

   for (i=0 ; i< RX_NUM_TONES ; i++)
      gsa_RxToneOrder[i] = i;

   for (i=gs_RxFirstChannel ; i<=gs_RxLastChannel ; i++)
      SETTONEFLAG(p_MEDLEYset_DS, i);

   // define BIS for standalone test
   gft_ModemType = G_DMT_BIS;

   STATArray[STAT_Mode] = (int16)STAT_ConfigMode_G992_5_A;

   gl_SelectedMode = MODE_G992_5 | ANNEX_A;

   gt_HandshakeBis.s_OneOverSminADSL2 = 16;

   /*  We re-allocate the default values to the HS_BIS structure before entering bit-loading. */
   gt_HandshakeBis.sa_DS_MaxCheckbytesLP[LP0_DATA_PATH] = (int16) (2* MAX_R_LP0_DS);
   gt_HandshakeBis.sa_DS_MaxIntlvDepthLP[LP0_DATA_PATH] = (int16) 511;

   guc_MaxAllocBitsPerTone = RX_MAX_BITS_PER_TONE;

   gs_AuxPilotToneIdx = gs_CPilotTone;


   for (i=0; i<21; i++)
   {
      gs_supportedDvalues[i] = save_myD_Values_New[i];
   }

   for (test_run=0; test_run <4; test_run++)
   {
      if(test_run==0) // set the parameters for tcm on
      {
         gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_0ft_plus; // 0ft
         fprintf(file_pms, "\n\t NULL LOOP \n");
      }

      if (test_run==1)
      {
         gsa_my_MedleySnrBuf = gsa_Med_0kft_Plus;
         fprintf(file_pms, "\n\t 0 KFT LOOP \n");
      }

      if(test_run==2) // set the parameters for tcm on
      {
         gsa_my_MedleySnrBuf = gsa_Med_1kft_Plus;
         fprintf(file_pms, "\n \t 1 KFT LOOP \n");
      }

      if (test_run==3)
      {
         gsa_my_MedleySnrBuf =gsa_med_constructed_nullloop;
         fprintf(file_pms, "\n\t Null Loop constructed \n");
      }

         // Trellis is ON

         OPTNArray[OPTN_AlgControl] = 0x0FF8;
         gs_tcm_coding_gain = TCM_CODING_GAIN;
         gs_max_coding_gain = MAX_CODING_GAIN;

         // Point Task layer pointers to locally defined buffers.

         copy_my_medley_snr(gsa_MedleySnrBuf, gsa_my_MedleySnrBuf);

         gsa_RxShowtimeSnrBuf = gsa_my_RxShowtimeSnrBuf_Plus;
         gsa_RxFineGains = gsa_my_RxFineGains;
         gsa_RxToneOrder = gsa_my_RxToneOrder;

         /*  SNR's (in dB) required for QAM */

         gsa_ConstellationSNR[0] = 0x0B4F;   /*  11.31 dB =  1 bit (NOT USED) */
         gsa_ConstellationSNR[1] = 0x0B4F;   /*  11.31 dB =  1 bit (NOT USED) */
         gsa_ConstellationSNR[2] = 0x0E51; /*  14.32 dB =  2 bits  */
         gsa_ConstellationSNR[3] = 0x131C;   /*  19.11 dB =  3 bits */
         gsa_ConstellationSNR[4] = 0x154F;   /*  21.31 dB =  4 bits */
         gsa_ConstellationSNR[5] = 0x1875;   /*  24.46 dB =  5 bits */
         gsa_ConstellationSNR[6] = 0x1B8A;   /*  27.54 dB =  6 bits */
         gsa_ConstellationSNR[7] = 0x1E97;   /*  30.59 dB =  7 bits */
         gsa_ConstellationSNR[8] = 0x219C;   /*  33.61 dB =  8 bits */
         gsa_ConstellationSNR[9] = 0x24A1;   /*  36.63 dB =  9 bits */
         gsa_ConstellationSNR[10] = 0x27A6; /*  39.65 dB = 10 bits */
         gsa_ConstellationSNR[11] = 0x2AA8; /*  42.66 dB = 11 bits */
         gsa_ConstellationSNR[12] = 0x2DAB; /*  45.67 dB = 12 bits */
         gsa_ConstellationSNR[13] = 0x30AE;  /*  48.68 dB = 13 bits */
         gsa_ConstellationSNR[14] = 0x33B0; /*  51.69 dB = 14 bits */
         gsa_ConstellationSNR[15] = 0x36B3; /*  54.70 dB = 15 bits */

         fprintf(file_pms, "INP\t  msg_ovhdrate\t maxlatency\t Kp\t Dp\t Mp\t Rp\t Lp\t Tp\t CWSize\t Sp(8.8)\t net_datarate\t ovhd_rate\t latency_achvd\t INP_achvd\t  datarate\t Ex_code\t  RMSGain\t TrellisOn\t\n");

         /* Initialize the handshake parameters  : INP =0, Latency = 1ms, Adaptive rate*/

         gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] =  0;
         s_actual_inp=0;

         gs_maxdatarate_in = 8000;

         gs_ovhdrate_in = 4;

         gs_maxlatency = 1;

         gt_HandshakeBis.sa_DS_MaxDataRateLP[LP0_DATA_PATH] = 8000;

         gt_HandshakeBis.sa_DS_MaxNetDataRateBC[0] = gs_maxdatarate_in;

         // Adaptive Rate
         gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[0]  = 8;

         gt_HandshakeBis.s_MinMSGDSOverheadRate = gs_ovhdrate_in;

         gt_HandshakeBis.sa_DS_MaxLatencyBC[0] = gs_maxlatency;
         /* define which Bearer channels and latency paths are active */

         gt_HandshakeBis.sa_DS_BCActive[0] = 1;
         gt_HandshakeBis.sa_DS_BCActive[1] = 0;
         gt_HandshakeBis.s_NumDSLatencyPaths = 1;     /* DS number of latency paths activated */

         // initialize the margin to be 6 dB
         gs_RxDesiredMargin=DESIRED_SNR_MARGIN;

         gs_RxNumTones=512;


         /*****************************************************************
         Initialze the medley and reverb3 snr and RX num Tones
         *****************************************************************/

         for(i=0;i<gs_RxNumTones;i++)
         {
            gsa_ReverbSnrBuf[i]=(int16)(gsa_my_MedleySnrBuf[i]);
            gsa_ReverbEchoSnrBuf[i]=(int16)(gsa_my_MedleySnrBuf[i]);
         }

         copy_my_medley_snr(gsa_MedleySnrBuf, gsa_my_MedleySnrBuf);

         // calls bitload_bis
         BgMedleyBitload_bis();

         if (gft_BitloadOK)
         {

            //compute back the final parameters, mainly to see the final results on data rates and final latency
            gs_BytesForBC0_final = gt_PMSParams.sa_Bpn[LP0_DATA_PATH][DS_AS0_BEARER_CHANNEL];
            gs_BytesForBC1_final =  gt_PMSParams.sa_Bpn[LP0_DATA_PATH][DS_AS1_BEARER_CHANNEL];
            gs_Kp_MDF_final=gs_BytesForBC0_final + gs_BytesForBC1_final + 1;
            gs_Dp_final=gt_PMSParams.s_Dp[LP0_DATA_PATH];
            gs_Mp_final=gt_PMSParams.s_Mp[LP0_DATA_PATH];
            gs_Rp_final=gt_PMSParams.s_Rp[LP0_DATA_PATH];
            gs_Lp_final=gt_PMSParams.s_Lp[LP0_DATA_PATH];
            gs_Tp_final=gt_PMSParams.s_Tp[LP0_DATA_PATH];

            if(gft_TcmFlag_bis_DS == TRUE)
            {
               gs_TCM_Oh_final =(((int16) gus_ncloaded - (gus_Rx_Tcm_Num1bits >> 1) + 1) >> 1) + 4;
            }
            else
               gs_TCM_Oh_final=0;

            gs_CWSize_final = gs_Kp_MDF_final*gs_Mp_final + gs_Rp_final;
            gs_Sp_final = (int16)(8 * gs_CWSize_final*256/ gs_Lp_final); // Sp in 8.8 format

            // net data rate (bits per frame)
            gs_net_datarate_final = (int16)((((gs_Tp_final*gs_Kp_MDF_final-1)*gs_Mp_final*((int32)(gs_Lp_final*16)))/(gs_Tp_final*(gs_Kp_MDF_final*gs_Mp_final+gs_Rp_final))+8)/16);

            // overhead rate is in kbps (final rate is in 8.8 format)
            gs_ovhd_rate_final=(int16)((gs_Mp_final*((int32)gs_Lp_final)*4*256)/(gs_Tp_final*(gs_Kp_MDF_final*gs_Mp_final+gs_Rp_final)));
            gs_latency_final= (int16)((int32)gs_Sp_final * gs_Dp_final / 4); // 8.8 format (ms)

            s_BatCheck = VerifyBat((uint8 *)&guca_RxBat[0]);
            /**************************************************************************************
            INP is impulse noise protection = (1/2) (S*D) (R/CWSize)
            ***************************************************************************************/

            if(gs_CWSize_final != 0)
               INP = (gs_Sp_final*gs_Dp_final * gs_Rp_final/(2*gs_CWSize_final));

            else
               INP=0;

               /**************************************************************************************
               Save the final computed parameters
            ***************************************************************************************/
            datarate_final = (float)(  (gs_Tp_final * gs_Kp_MDF_final - 1) *  gs_Mp_final * (float)(gs_Lp_final) / (gs_Tp_final * gs_CWSize_final));

            datarate_msgc = (float) (gs_ovhd_rate_final* gs_MSGc_final)/(256*(gs_MSGc_final+6));

            /* compute RMS fine gain value */
            l_Prod = (int32) ComputeRMSFineGain(guca_RxBat, gsa_RxFineGains, gs_RxNumTones, gs_CurrentCoChipset, 0, 0);

            gt_TxPMDControl.us_RMSGI_DS = 2* (ConvertToDB(l_Prod)  -  ConvertToDB(8192));
         }


         if ((s_BatCheck == FAIL) || (gft_BitloadOK == FAIL))
         {
            gs_net_datarate_final=0;
            fprintf(file_pms,"%8.1f\t %ld\t %ld\t %ld\t %ld\t %ld\t  %ld\t %ld\t %ld\t %ld\t  %ld\t %ld\t %ld\t  %ld\t %ld\t %8.2f\t %ld\t   %ld\t",s_actual_inp ,  gs_ovhdrate_in, gs_maxlatency,  gs_Kp_MDF_final, gs_Dp_final,   gs_Mp_final,   gs_Rp_final, gs_Lp_final,  gs_Tp_final,gs_CWSize_final,gs_Sp_final,gs_net_datarate_final,gs_ovhd_rate_final,gs_latency_final, INP, datarate_final,gus_BitloadExceptionCode,   gt_TxPMDControl.us_RMSGI_DS, gft_TcmFlag_bis_DS);

            fprintf(file_pms, "***ERROR:");
            // First check for BitloadOK failure
            if (gft_BitloadOK == FAIL)
               fprintf(file_pms, "BitloadOK=FAIL***\n");
            // Then if BitloadOK is ok, check for bad Bat.
            else if (s_BatCheck == FAIL)
               fprintf(file_pms, "Bad BAT***\n");
            ;
         }
         else
         {
            fprintf(file_pms,"%8.1f\t   %ld\t %ld\t %ld\t%ld\t %ld\t %ld\t %ld\t %ld\t %ld\t %ld\t  %ld\t %ld\t %ld\t  %ld\t  %8.2f\t  %ld\t %ld\t  %ld\t\n", s_actual_inp,  gs_ovhdrate_in, gs_maxlatency,  gs_Kp_MDF_final, gs_Dp_final,   gs_Mp_final,   gs_Rp_final, gs_Lp_final,  gs_Tp_final,gs_CWSize_final,gs_Sp_final,gs_net_datarate_final * 4,gs_ovhd_rate_final,gs_latency_final, INP,  datarate_final, gus_BitloadExceptionCode,  gt_TxPMDControl.us_RMSGI_DS, gft_TcmFlag_bis_DS);
         }


         // reset all the global variables and pms structure
         gs_Kp_MDF_final= 0;
         gs_Dp_final=0;
         gs_Mp_final=0;
         gs_Rp_final=0;
         gs_Lp_final=0;
         gs_Tp_final=0;
         gs_CWSize_final = 0;
         gs_Sp_final = 0;
         gs_net_datarate_final = 0;
         gs_ovhd_rate_final=0;
         gs_latency_final= 0;
         gus_BitloadExceptionCode = 0;
         gs_found_valid_config =0;
         gs_flag_fixedrate = 0;
         gs_flag_limitedrate = 0;

         gt_PMSParams.s_Dp[LP0_DATA_PATH] = 0;
         gt_PMSParams.s_Mp[LP0_DATA_PATH] = 0;
         gt_PMSParams.s_Rp[LP0_DATA_PATH] = 0;
         gt_PMSParams.s_Tp[LP0_DATA_PATH] = 0;
         gt_PMSParams.s_Lp[LP0_DATA_PATH] = 0 ;


         gs_iter_conv=0;

   } // test_run

   fcloseall();
#endif
 }  // end of main program

   /********************************************************************************
   ;  Subroutine Name: void VerifyBat(void)
   ;
   ;
   ;  Prototype:
   ;     void VerifyBat(void)
   ;
   ;  Input Arguments:
   ;
   ;
   ;  Output Arguments:
   ;
   ;
   ;  Return:
   ;
   ;
   ;  Global Variable used by this file:
   ;
   ;****************************************************************************/

   C_SCOPE int16 VerifyBat(uint8 *psa_Bat)
   {
      FlagT ft_TcmFlag;
      int16 i, s_bits, s_NumLoadedTones;

      if(gft_ModemType == G_DMT_BIS) ft_TcmFlag =  gft_TcmFlag_bis_DS;
      else ft_TcmFlag = gft_TcmFlag;

      s_bits = 0;
      for(i=0; i<gs_RxNumTones; i++) {
         s_bits += psa_Bat[i];
      }

      gus_Rx_Tcm_Num1bits = 0;
      for(i=0, s_NumLoadedTones=0; i<gs_RxNumTones; i++) {
         s_NumLoadedTones += (int16) (psa_Bat[i] > 0);
         if (ft_TcmFlag==TRUE) gus_Rx_Tcm_Num1bits += (int16) (psa_Bat[i] == 1);
      }

      // Update count of # of loaded tones
      gus_ncloaded = (uint16)(s_NumLoadedTones & 0xFFFF);

      if (ft_TcmFlag==TRUE) {
         s_bits -= (4 + ((s_NumLoadedTones - (gus_Rx_Tcm_Num1bits>>1) + 1) >> 1));
      }

      if(s_bits != gs_Lp_final)
         return(FAIL);
      else
         return(SUCCEED);
   }


   /* Dummy Variable to get test_bitload to build */
   PtrToFunc gpF_RxStateFunc; // Global function pointer of RX state function
   /* Dummy Functions to get test_bitload to build */
   void ExceptionHandler(void)
   {
   }


   void FormRInfo2(void)
   {
   }

   void SelectDsRateOption(Option_t *pta_options, int16 *ps_OutRateOption)
   {
   }
