/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*********************************************************************************/
/* Test code to Autonomous Bitswaps in BIS
/* Standalone code
/* Code takes a predefined SNr, does Bitloading based on that
After that all SNRs are changed based on some random values.
equivalent to SNR update.

  We also have the provision to add noise on a set of tones from
  s_tone_noiseincrease_start to s_tone_noiseincrease_end, with every SNR update,
  -0.5dB of noise is added. Aim is to see that these tones are unloaded eventually.

   Current code does bitswap, tones are moved out, till the time we have 2bit tones there.
   (as we are not unloading the tones completely as yet)

   SNR, BAT before is grabbed. With every bitswap, min margin, min margin tone, average margin before and after swap is grabbed.


/********************************************************************************/
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "typedef.h"
#include "gdata_bis.h"
#include "bitload_bis.h"
#include "gdata.h"
#include "bitload2.h"
#include "bitload.h"
#include "bitload_const.h"
#include "compiler.h"
#include "cmv.h"
#include "cmv_data.h"
#include "const.h"
#include "statein1.h"
#include "states.h"
#include "changebat.h"
#include "minmaxmargin.h"
#include "bitload_support.h"
#include "pll.h"
#include "snr_data.h"

#include "ComputeRMSFineGain.h"
#include "snr.h"
#include "rx_ovrhd_bis.h"
#include "memsetbf.h"

void gen_noise_spectrum(int16 s_tone_noiseincrease_start, int16 s_tone_noiseincrease_end, int16 test_run, int16 noise_power,float64 p, int16 *psa_noise_sp);

// Local functions
C_SCOPE int16 VerifyBat(uint8 *psa_Bat);
int16 Noise(void);
float64 gasdev(int32 *idum);
float64 ran1(int32 *idum);

// Define local buffers for SNRs, BAT.
int16 *gsa_my_MedleySnrBuf;
int16 gsa_my_RxShowtimeSnrBuf[256];
int16 gsa_my_RxShowtimeSnrBuf_Plus[512];
int16 gsa_my_RxFineGainPlusBitChannel[RX_LAST_CHANNEL+1];
int16 gsa_my_RxFineGains[RX_NUM_TONES],  gsa_my_RxTempFineGains[RX_NUM_TONES];
int16 gsa_my_RxToneOrder[RX_NUM_TONES];
int16 gsa_my_RxCombinedGains[RX_NUM_TONES];
uint8 guca_RxBat_save[RX_NUM_TONES], guca_RxBat_init[RX_NUM_TONES];;

int16 gs_maxdatarate_in;
int16 gsa_StatesTrail[1024];
int16 gs_trail_deltaLp[NUM_DATA_PATHS], gs_trail_deltaBpn[NUM_DATA_PATHS];

FILE *file_pms;

extern int16  gs_tcm_coding_gain, gs_max_coding_gain;
extern int16  gsa_my_MedleySnrBuf_10kft[256];
extern int16 gsa_my_MedleySnrBuf_longloop1[256];
extern int16 gsa_my_MedleySnrBuf_18kft[256];
extern int16 gsa_my_MedleySnrBuf_16kft[256], gsa_test_snr_increase_decrease[256];
extern int16 gsa_snr_18kft_ckt[256];
extern int16 gsa_snr_18kft_nockt[256];
extern int16 gsa_snr13k_nockt[256];
extern int16 gsa_snr13k_ckt[256];
extern int16 gsa_snr13k_nockt1[256];
extern int16 gsa_snr13k_ckt1[256];
extern int16 gsa_snr20k_nockt[256];
extern int16 gsa_snr20k_ckt[256];
extern int16 gsa_my_MedleySnrBuf_testforceeven1bit[256];

extern int16 gs_trail_bitswap, gs_REDUCE_LP_DELTA_BITSWAP, gs_BITSWAP_TRIGGER_DELTA , gs_Bitswap_Accept_Delta ;
extern int16  gs_iter_conv, gs_found_valid_config, gs_flag_fixedrate, gs_flag_limitedrate;

uint8 guc_DECAdaptationState;
FILE *gfp_hdlc_out;


int16 gsa_noise_sp[256];

int16 s_MAX_ITER = 100, s_tone_noiseincrease_start=40, s_tone_noiseincrease_end=50;
int16 s_RxMinMarginBeforeSwap, s_RxMinMarginAfterSwap, s_BatCheck1,  s_RxAvgMarginBeforeSwap, s_RxAvgMarginAfterSwap;
int16 s_RxMinMarginToneBeforeSwap, s_RxMinMarginToneAfterSwap, s_ActualDeltaLp, s_deltaLpcount;
int16 Noise_rand[2560];
int16 s_RxAvMargin, s_RxAvFineGain, s_RxMinMargin, guc_RX_MIN_BITS_PER_TONE;
int16 test_run, test_case;
int16 gs_Lp_final;
int16  gs_DS_RateOption;               /* final downstream rate option */
RMsgRA_t gt_RMsgRA;
RMsg2_t gt_RMsg2;                /* R_MSG2 parameters */
Option_t gta_DS_options[NUM_DS_RATE_OPTIONS];

int16 s_ncloaded_beforeswap, s_Num1BitTones_before, s_TCM_Ovhd_before, s_FinalSumBi_before;
int16 s_ncloaded_afterswap, s_Num1BitTones_after, s_TCM_Ovhd_after, s_FinalSumBi_after, s_error, bi;

uint16 gusa_DS_Tssi_Value1[RX_NUM_TONES];
//int16 gs_OneOverSminADSL2;

/* Count of errors per second */
int16 gs_fec_ecs_cnt;
int16 gs_crc_cnt;
int16 gs_norm_crc_1sec;

DebugTrailTriggerControl_t gt_debugTrailTriggerControl;
DebugTrailCollectControl_t gt_debugTrailCollectControl;


#ifdef LEAVE_TRAIL
TRAILFILE crc_fid;
#endif

// global variables
#define RX_MAX_BITS_PER_TONE     (15)        /*  maximum number of bits per tone at RX */

// Dummy function.  We don't need this functionality for this test.
void DebugTrail(int16 s_count, ... )
{}

void logShowtimeEventB(uint32 l_dummy)
{}

void copy_my_medley_snr(int16 *psa_destBuf, int16 *psa_srcBuf)
{
   int16 i;

   for (i = 0; i < 512; i++)
   {
      psa_destBuf[i] = psa_srcBuf[i];
   }
}

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void Update_OLRPMCnt(OLRPMCntInfo_t* pt_OLRPMCnt, int16 s_OLRPMType, int16 s_countType)
*
*   Description:
*     Update couter info of OLRPMCnt_t structure
*
*  Arguments:
*
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
void Update_OLRPMCnt(OLRPMCntInfo_t* pt_OLRPMCnt, int16 s_OLRPMType, int16 s_countType)
{
   int16 *p_addr;

   //to cover the PLUS OLR type
   if(s_OLRPMType > 3)
      s_OLRPMType -= 3;

   p_addr = (int16*)pt_OLRPMCnt + (s_OLRPMType-1) * gt_StructureSizeInfo.s_OLRPMCntStructOffset + s_countType;

   (*p_addr)++;

}

int main(int argc, char **argv)
//void main()
{
   int16 i, j, gi, s_bat_stable, s_CodingGain;
   int32 gl_Rx_Total_Power=0, l_Prod;                       /*  average received signal power */
   int16 s_BatCheck, s_RMSFineGaindB_beforeSwap, s_RMSFineGaindB_AfterSwap, s_MinBitsperTone;
   int16 s_excessgain[512], s_ReqdSNR, s_SNR, s_path = 2;
#ifdef TEST_ALL
   int16 noise_power;
   int32 l_seed;
   float64 p;
#endif

    //gusa_DS_Tssi_Value1 is used without initlization, but it seems the
    //bitswap-test does not care about the value at all.
//    gusa_DS_Tssi_Value = gusa_DS_Tssi_Value1;

   /*******************************************************************************
   Initialize Global Variables
   ********************************************************************************/
   gs_TxNumTones = 32;


   gs_RxFirstChannel = 33;

   gs_RxLastChannel = 255;


   /* for cocomo testing limit the max CWSize to be 240; this is because of bm limitation of
   TDP CO, will be removed in next upgrade*/
   gs_max_CWSize = 247;

   gs_RxBitLoadFirstChannel = gs_RxFirstChannel;
   gs_RxBitLoadLastChannel = gs_RxLastChannel;

   gft_FineGainOn = TRUE;

   gs_max_fine_gain =  640;      // 2.5dB in Q 8.8
   gs_min_fine_gain = -640;      // -2.5dB in Q8.8


   guca_RSCodingGain[0] = 0;
   guca_RSCodingGain[1]= RS_CODING_GAIN_2;
   guca_RSCodingGain[2]= RS_CODING_GAIN_4;
   guca_RSCodingGain[3]= RS_CODING_GAIN_6;
   guca_RSCodingGain[4]= RS_CODING_GAIN_8;
   guca_RSCodingGain[5]= RS_CODING_GAIN_10;
   guca_RSCodingGain[6]= RS_CODING_GAIN_12;
   guca_RSCodingGain[7]= RS_CODING_GAIN_14;
   guca_RSCodingGain[8]= RS_CODING_GAIN_16;

   gs_CPilotTone = C_PILOT_TONE_64;

// gt_debugTrailTriggerControl.s_logType = 0x2000;
   gt_debugTrailCollectControl.s_debugTrailSize = 1024;
   INFOMap[INFO_DebugTrail] = (int16*)&gsa_StatesTrail;

// file_pms=fopen("jnk1.txt","w");
   file_pms=fopen(argv[1],"w");


      // run various bitswap cases with evacuating tones
      fprintf(file_pms, "\n  *****   BITSWAP TEST WITH TONE EVACUATION ***** \n\n");


      s_MinBitsperTone = 1;

      for (test_run=0; test_run < 6; test_run++)
      {

         gs_RxNumTones=256;

         gs_AuxPilotToneIdx = gs_CPilotTone;
         gs_PilotToneIdx = gs_CPilotTone;


         switch(test_run)
         {
            // test various SNRs
         case 0:
            fprintf(file_pms, " TEST SNR 0kft  \n ");

            gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_0kft;
            // tones for adding noise
            s_tone_noiseincrease_start = 40;
            s_tone_noiseincrease_end = 42;

            break;

         case 1:
            fprintf(file_pms, " TEST SNR 10Kft \n ");

            gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_10kft;
            // tones for adding noise
            s_tone_noiseincrease_start = 40;
            s_tone_noiseincrease_end = 42;

            break;

         case 2:
            fprintf(file_pms, " TEST SNR 18kft \n ");

            gsa_my_MedleySnrBuf = gsa_snr_18kft_nockt;

            // tones for adding noise
            s_tone_noiseincrease_start = 40;
            s_tone_noiseincrease_end = 42;

            break;

         case 3:
            fprintf(file_pms, " TEST SNR INCREASE DECREASE \n ");

            gsa_my_MedleySnrBuf = gsa_test_snr_increase_decrease;
            // tones for adding noise
            s_tone_noiseincrease_start = 150;
            s_tone_noiseincrease_end = 160;

            break;

         case 4:
            fprintf(file_pms, " TEST SNR LONG LOOP  \n ");

            gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_16kft;

            // tones for adding noise
            s_tone_noiseincrease_start = 40;
            s_tone_noiseincrease_end = 41;
            gs_AuxPilotToneIdx = 48;
            gs_PilotToneIdx = 48;


            break;

         case 5:
            fprintf(file_pms, " TEST SNR 18kft_500bt \n ");

            gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_18kft_500bt;
            // tones for adding noise
            s_tone_noiseincrease_start = 34;
            s_tone_noiseincrease_end = 41;

            break;
         }


         // Point Task layer pointers to locally defined buffers.

         copy_my_medley_snr(gsa_MedleySnrBuf, gsa_my_MedleySnrBuf);
         gsa_RxShowtimeSnrBuf = gsa_my_RxShowtimeSnrBuf;
         gsa_RxFineGains = gsa_my_RxFineGains;
         gsa_TempRxFineGains = gsa_my_RxTempFineGains;
         gsa_RxCombinedGains = gsa_my_RxCombinedGains;
         gsa_RxToneOrder = gsa_my_RxToneOrder;


         for (i=0 ; i< RX_NUM_TONES ; i++)
         {
            gsa_RxToneOrder[i] = i;
            gusa_DS_Tssi_Value[i] = gusa_DS_Tssi_Value1[i];
         }

         for (i=gs_RxFirstChannel ; i<=gs_RxLastChannel ; i++)
            SETTONEFLAG(p_MEDLEYset_DS, i);



         // define BIS for standalone test
         gft_ModemType = G_DMT_BIS;

         guc_RX_MIN_BITS_PER_TONE = 1;

         STATArray[STAT_Mode] = STAT_ConfigMode_G992_3_A;

         gt_HandshakeBis.s_OneOverSminADSL2 = 2;

         gl_SelectedMode = MODE_G992_3 | ANNEX_A;

         /*  We re-allocate the default values to the HS_BIS structure before entering bit-loading. */
         gt_HandshakeBis.sa_DS_MaxCheckbytesLP[LP0_DATA_PATH] = (int16) (2* MAX_R_LP0_DS);
         gt_HandshakeBis.sa_DS_MaxIntlvDepthLP[LP0_DATA_PATH] = (int16) 64;


         guc_MaxAllocBitsPerTone = RX_MAX_BITS_PER_TONE;


         CLEARTONEFLAG(p_MEDLEYset_DS, gs_PilotToneIdx);

         gs_RxNumTones=256;

         fprintf(file_pms,"\n SNR \n ");


         for(i=0;i<gs_RxNumTones;i++)
            fprintf(file_pms,"%ld ", gsa_my_MedleySnrBuf[i] >> 8);

         fprintf(file_pms,"\n \n ");


         /*****************************************************************
         Initialze the medley and reverb3 snr
         *****************************************************************/

         for(i=0;i<gs_RxNumTones;i++)
         {
            gsa_ReverbSnrBuf[i]=(int16)(gsa_my_MedleySnrBuf[i]);
            gsa_ReverbEchoSnrBuf[i]=(int16)(gsa_my_MedleySnrBuf[i]);
//          gsa_my_RxShowtimeSnrBuf[i] = (int16)(gsa_my_MedleySnrBuf[i]);
         }

         copy_my_medley_snr(gsa_MedleySnrBuf, gsa_my_MedleySnrBuf);

         // TCM on, Bitswap enable
         OPTNArray[OPTN_AlgControl] = 0x0F40;

         gs_tcm_coding_gain = TCM_CODING_GAIN;
         gs_max_coding_gain = MAX_CODING_GAIN;
         /*  SNR's (in dB) required for QAM */

         gsa_ConstellationSNR[0] = 0x0B4F;   /*  11.31 dB =  1 bit (NOT USED) */
         gsa_ConstellationSNR[1] = 0x0B4F;   /*  11.31 dB =  1 bit (NOT USED) */
         gsa_ConstellationSNR[2] = 0x0E51; /*  14.32 dB =  2 bits  */
         gsa_ConstellationSNR[3] = 0x131C;   /*  19.11 dB =  3 bits */
         gsa_ConstellationSNR[4] = 0x154F;   /*  21.31 dB =  4 bits */
         gsa_ConstellationSNR[5] = 0x1875;   /*  24.46 dB =  5 bits */
         gsa_ConstellationSNR[6] = 0x1B8A;   /*  27.54 dB =  6 bits */
         gsa_ConstellationSNR[7] = 0x1E97;   /*  30.59 dB =  7 bits */
         gsa_ConstellationSNR[8] = 0x219C;   /*  33.61 dB =  8 bits */
         gsa_ConstellationSNR[9] = 0x24A1;   /*  36.63 dB =  9 bits */
         gsa_ConstellationSNR[10] = 0x27A6; /*  39.65 dB = 10 bits */
         gsa_ConstellationSNR[11] = 0x2AA8; /*  42.66 dB = 11 bits */
         gsa_ConstellationSNR[12] = 0x2DAB; /*  45.67 dB = 12 bits */
         gsa_ConstellationSNR[13] = 0x30AE;  /*  48.68 dB = 13 bits */
         gsa_ConstellationSNR[14] = 0x33B0; /*  51.69 dB = 14 bits */
         gsa_ConstellationSNR[15] = 0x36B3; /*  54.70 dB = 15 bits */


         /* Initialize the handshake parameters for standalone test */
         gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 0;

         gt_HandshakeBis.s_MinMSGDSOverheadRate = 4;

         gt_HandshakeBis.sa_DS_MaxLatencyBC[0] = 63;

         /* define which Bearer channels and latency paths are active */

         gt_HandshakeBis.sa_DS_BCActive[0] = 1;
         gt_HandshakeBis.sa_DS_BCActive[1] = 0;
         gt_HandshakeBis.s_NumDSLatencyPaths = 1;     /* DS number of latency paths activated */


         gs_RxDesiredMargin = 1536;
         gt_RCMsgs1_bis.us_MAXSNRMds = 110 ;    // 11 dB

         // Run Adaptive Rate
         gs_maxdatarate_in= 4000;

         gt_HandshakeBis.sa_DS_MaxDataRateLP[LP0_DATA_PATH] = gs_maxdatarate_in;

         gt_HandshakeBis.sa_DS_MaxNetDataRateBC[0] = gs_maxdatarate_in;

         gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[0] = 8;

         // initialize it here, required in ChangeBat, so as not to change ncloaded
         gs_RxState = R_C_MEDLEY_RX;

         // calls bitload_bis
         BgMedleyBitload_bis();

         gs_Lp_final=gt_PMSParams.s_Lp[LP0_DATA_PATH];

         s_BatCheck = VerifyBat((uint8 *)&guca_RxBat[0]);

         // initialize it here, required in ChangeBat, so as not to change ncloaded
         gs_RxState = R_C_SHOWTIME_RX;

         for(i=0;i<gs_RxNumTones;i++)
         {
            gsa_my_RxShowtimeSnrBuf[i] = (int16)(gsa_my_MedleySnrBuf[i]);
         }

         gsa_RxShowtimeSnrBuf = gsa_my_RxShowtimeSnrBuf;

         // initialize showtime pointers

         gt_rx_config.psa_BAT =  guca_RxBat;
         gt_rx_config.psa_FineGains = gsa_RxFineGains;

         // Initialize to L0 state for OLR
         gt_RxOLRPMVars.uc_rxOLRPMState = L0_STEADY_STATE;

         fprintf(file_pms, "\n \n");


         // collect bitswap trail
         gs_trail_bitswap = 0;

         gs_REDUCE_LP_DELTA_BITSWAP = 100;
         gs_BITSWAP_TRIGGER_DELTA = 0x300;// 3dB
         gs_Bitswap_Accept_Delta = 0x100; // 1dB

         fprintf(file_pms, "\nBitswap trigger = %ld\t dB\n",gs_BITSWAP_TRIGGER_DELTA>>8);
         fprintf(file_pms, "Bitswap Accept =  %ld\t dB  \n",gs_Bitswap_Accept_Delta>>8);
         fprintf(file_pms, "DeltaLp =  %ld\t dB  \n",gs_REDUCE_LP_DELTA_BITSWAP);

         fprintf(file_pms, "Tone start noise add = %ld \n", s_tone_noiseincrease_start);
         fprintf(file_pms, "Tone end noise add = %ld \n", s_tone_noiseincrease_end);

         fprintf (file_pms, "\nLoop \t MinMgn_before\t MinMrgTone \t AvgMrgBeforeSwap\t MinMrg_after \t MinMrg_Tone\t  Avg_Margin_afterswap\t   DeltaLp\t RMS_Gain \t\n");


         s_deltaLpcount = 4;  // based on saved States trail

         // save the initial BAT
         for(i=gs_RxFirstChannel;i<gs_RxNumTones;i++)
         {
            guca_RxBat_init[i] = guca_RxBat[i];
         }

         // Add noise same as an snr update;
         for(j=0; j < s_MAX_ITER; j++)
         {
            for(i=gs_RxFirstChannel;i<gs_RxNumTones;i++)
            {
               Noise_rand[i]=Noise();
               gsa_RxShowtimeSnrBuf[i] -= Noise_rand[i];
            }


            // Decrease SNR on set of tones
            // stop iterating if bits on these tones are min bits
            // (for the current set up 2)

            for(i=s_tone_noiseincrease_start;i<s_tone_noiseincrease_end;i++)
            {
               gsa_RxShowtimeSnrBuf[i] -= 128;
            }

            s_bat_stable = 0;

            // Do as many required bitswaps
            while(!s_bat_stable)
            {
               // initialize
               s_RxMinMargin = 0x7FFF; /* Initialise to a large number */

               gs_MaxToneForFast = -1;                         /* Number of tones whose bits are allocated to fast path */

               s_RxAvMargin = CalcAvgMargin(gsa_RxToneOrder, gsa_RxShowtimeSnrBuf, guca_RxBat, gsa_RxFineGains,  (FlagT) 0, 0, 0);

               FindToneWithExtremeMargin(SMALLEST_MARGIN, guca_RxBat, gsa_RxFineGains, gsa_RxShowtimeSnrBuf, p_MEDLEYset_DS, s_MinBitsperTone, (int16) guc_MaxAllocBitsPerTone, &s_RxMinMarginToneBeforeSwap, &s_RxMinMarginBeforeSwap);

               s_RxAvgMarginBeforeSwap = s_RxAvMargin;

               // save the current BAT
               for(i=gs_RxFirstChannel;i<gs_RxNumTones;i++)
               {
                  guca_RxBat_save[i] = guca_RxBat[i];
               }

               // determine BAT status before bitswap
               GetBatStats(guca_RxBat, gs_RxNumTones, gft_TcmFlag_bis_DS, &s_ncloaded_beforeswap, &s_Num1BitTones_before, &s_TCM_Ovhd_before, &s_FinalSumBi_before, s_path);

               /* compute RMS fine gain value */
               l_Prod = (int32) ComputeRMSFineGain(guca_RxBat, gsa_RxFineGains, gs_RxNumTones, gs_CurrentCoChipset, 0, 0);

               s_RMSFineGaindB_beforeSwap = 2* (ConvertToDB(l_Prod)  -  ConvertToDB(8192));

               gt_rx_config.s_Lp[0] = gt_PMSParams.s_Lp[0];

               // check for any OLR
               Rx_OLR_Decision();


               s_RxMinMargin = 0x7FFF; /* Initialise to a large number */

               gt_debugTrailTriggerControl.s_logType = 0x2000;

               s_RxAvMargin = CalcAvgMargin(gsa_RxToneOrder, gsa_RxShowtimeSnrBuf, guca_RxBat, gsa_RxFineGains,  (FlagT) 0, 0, 0);

               FindToneWithExtremeMargin(SMALLEST_MARGIN, guca_RxBat, gsa_RxFineGains, gsa_RxShowtimeSnrBuf, p_MEDLEYset_DS, s_MinBitsperTone, (int16) guc_MaxAllocBitsPerTone, &s_RxMinMarginToneAfterSwap, &s_RxMinMarginAfterSwap);
               s_RxAvgMarginAfterSwap = s_RxAvMargin;

               // Bitswap performed
               if (gt_RxOLRPMVars.uc_rxOLRPMState == OLR_LOAD_TABLES) // BITSWAP OK
               {

                  // determine BAT status
                  GetBatStats(guca_RxBat, gs_RxNumTones, gft_TcmFlag_bis_DS, &s_ncloaded_afterswap, &s_Num1BitTones_after, &s_TCM_Ovhd_after, &s_FinalSumBi_after, s_path);

                  /* compute RMS fine gain value */
                  l_Prod = (int32) ComputeRMSFineGain(guca_RxBat, gsa_RxFineGains, gs_RxNumTones, gs_CurrentCoChipset, 0, 0);

                  s_RMSFineGaindB_AfterSwap = 2* (ConvertToDB(l_Prod)  -  ConvertToDB(8192));


                  // set diferent error flags
                  s_error = 0;
                  if (0) // check for these if tones are not being emptied
                  {
                     if (s_ncloaded_afterswap != s_ncloaded_beforeswap) s_error = 1;
                     if (s_Num1BitTones_after != s_Num1BitTones_before) s_error = 2;
                     if (s_TCM_Ovhd_after != s_TCM_Ovhd_before) s_error = 3;
                     if (s_FinalSumBi_after != s_FinalSumBi_before) s_error = 4;
                     // check all gi are correct
                     if (s_RMSFineGaindB_AfterSwap > 0 ) s_error=6;
                  }
                  // check that all bi are between min and max

                  for(i=gs_RxFirstChannel;i<gs_RxNumTones;i++)
                  {
                     bi = guca_RxBat[i];
                     if (((bi < guc_RX_MIN_BITS_PER_TONE) || (bi > RX_MAX_BITS_PER_TONE)) && (bi !=0))
                        s_error = 5;
                  }


                  for(i=gs_RxFirstChannel;i<gs_RxNumTones;i++)
                  {
                     gi = gsa_RxFineGains[i];
                     if (((gi < gs_min_fine_gain) || (gi > gs_max_fine_gain)) && (gi != -32768))
                        s_error = 7;
                  }


                  s_BatCheck1 = VerifyBat((uint8 *)&guca_RxBat[0]);

                  // check that min margin after swap is greater than margin before swap
                  if (s_RxMinMarginAfterSwap < s_RxMinMarginBeforeSwap + gs_Bitswap_Accept_Delta)
                     s_error = 8;

                  // compute excess gain
                  s_CodingGain = gsa_TotalCodingGain[0];

                  for(i=gs_RxFirstChannel;i<gs_RxNumTones;i++)
                  {

                     s_excessgain[i] = 0;
                     bi = guca_RxBat[i];
                     gi = gsa_RxFineGains[i];
                     s_SNR =  gsa_RxShowtimeSnrBuf[i];

                     if (bi!=0)
                     {
                        s_ReqdSNR = gsa_SNRRequired[bi];
                        s_excessgain[i] = s_SNR + s_CodingGain + gi - s_ReqdSNR;
                     }
                     else
                        s_excessgain[i] = 0;

                  }

                  // if min margin < desired margin then check that there is no excess gii on that tone

/*                if (s_RxMinMarginAfterSwap < gs_RxDesiredMargin)
                  {
                     bi = s_RxMinMarginToneAfterSwap;
                     if ((gsa_RxFineGains[bi] < gs_max_fine_gain) && (s_excessgain[bi] > 0))
                        s_error = 9;
                  }



  */

                  s_ActualDeltaLp = gsa_StatesTrail[s_deltaLpcount];
                  s_ActualDeltaLp = 0; // cleared as statestrail contains margin per tone, shall be fixed in next check in
                  s_deltaLpcount += 6;

                  if (s_error!=0)
                  {
                     if (s_error == 1) fprintf (file_pms, " ERROR  NcLoaded Different \n");
                     if (s_error ==2)  fprintf (file_pms, " ERROR  Num1Bit Different \n");
                     if (s_error == 3) fprintf (file_pms, " ERROR  TCM overhead Different \n");
                     if (s_error ==4)  fprintf (file_pms, " ERROR  FinalSumBi Different \n");
                     if (s_error ==5)  fprintf (file_pms, " ERROR  bi not between min and max Bits Allowed  \n");
                     if (s_error ==6)  fprintf (file_pms, " ERROR  RMS gain > 0 \n");
                     if (s_error ==7)  fprintf (file_pms, " ERROR  gi not between min and max gain Allowed  \n");
                     if (s_error ==8)  fprintf (file_pms, " ERROR  margin after swap not better  \n");
//                   if (s_error == 9)  fprintf (file_pms, " ERROR  Excess gi available on min margin tone  \n");

                  }

                  else if (s_BatCheck1 == 0)
                     fprintf (file_pms, " BAT ERROR \n");

                  // print the result under all cases
                  fprintf (file_pms, "%ld\t %ld\t %ld\t %ld\t %ld \t %ld\t %ld \t%ld \t%ld\n", j, s_RxMinMarginBeforeSwap,s_RxMinMarginToneBeforeSwap,s_RxAvgMarginBeforeSwap, s_RxMinMarginAfterSwap,s_RxMinMarginToneAfterSwap, s_RxAvgMarginAfterSwap,  s_ActualDeltaLp, s_RMSFineGaindB_AfterSwap);


                  s_bat_stable = 0;

                  // kick another bitswap
                  gt_RxOLRPMVars.uc_rxOLRPMState = L0_STEADY_STATE;


         }
         else if (   gt_RxOLRPMVars.uc_rxOLRPMState == OLR_READ_TABLES)
            // OLR aborted
         {
            // load back the old BAT table
            for(i=gs_RxFirstChannel;i<gs_RxNumTones;i++)
            {
               guca_RxBat[i] = guca_RxBat_save[i];
            }
            // load back gain values

            // Gains  are loaded back in rx_olr_decision

            s_bat_stable = 1;

            // kick another bitswap
            gt_RxOLRPMVars.uc_rxOLRPMState = L0_STEADY_STATE;

         }
         else if (gt_RxOLRPMVars.uc_rxOLRPMState == L0_STEADY_STATE)
         {
            // no bitswap got triggered
            s_bat_stable = 1;
         }

         // equivalent to evacuating a tone
         if (guca_RxBat[s_tone_noiseincrease_start] == s_MinBitsperTone -1 ) j = s_MAX_ITER;

         } // s_bat_stable

      }//j

      fprintf(file_pms, "\n BAT_BEFORE & AFTER SWAPS MARGIN \n");


      for(i=0;i<gs_RxNumTones;i++)
         fprintf(file_pms,"%ld \t %ld \t %ld\t %ld\t\n ",i,guca_RxBat_init[i], guca_RxBat[i], gsa_StatesTrail[i] );
      fprintf(file_pms,"\n\n");


                     // reset all the global variables and pms structure

                     gus_BitloadExceptionCode = 0;
                     gs_found_valid_config =0;
                     gs_flag_fixedrate = 0;
                     gs_flag_limitedrate = 0;

                     gt_PMSParams.s_Dp[LP0_DATA_PATH] = 0;
                     gt_PMSParams.s_Mp[LP0_DATA_PATH] = 0;
                     gt_PMSParams.s_Rp[LP0_DATA_PATH] = 0;
                     gt_PMSParams.s_Tp[LP0_DATA_PATH] = 0;
                     gt_PMSParams.s_Lp[LP0_DATA_PATH] = 0 ;

                     gs_iter_conv=0;

      for(i=0;i<gs_RxNumTones;i++)
         gsa_StatesTrail[i]=0;
   }

#ifdef TEST_ALL

   // test forceeven1bit
   fprintf(file_pms, " ******* SNR to test Forceven1 bit ******* \n");

   s_MinBitsperTone = 1;

for (test_run=0; test_run<1; test_run++)
{

   switch(test_run)
   {
   case 0:
      fprintf(file_pms, " TEST SNR FORCEEven1bit \n ");

      gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_testforceeven1bit;
      // tones for adding noise
      s_tone_noiseincrease_start =34;
      s_tone_noiseincrease_end = 35;

      break;


   }

            // Point Task layer pointers to locally defined buffers.

         gsa_MedleySnrBuf=&gsa_my_MedleySnrBuf[0];
         gsa_RxShowtimeSnrBuf = gsa_my_RxShowtimeSnrBuf;
         gsa_RxFineGains = gsa_my_RxFineGains;
         gsa_TempRxFineGains = gsa_my_RxTempFineGains;
         gsa_RxCombinedGains = gsa_my_RxCombinedGains;
         gsa_RxToneOrder = gsa_my_RxToneOrder;


         for (i=0 ; i< RX_NUM_TONES ; i++)
            gsa_RxToneOrder[i] = i;

         for (i=gs_RxFirstChannel ; i<=gs_RxLastChannel ; i++)
            SETTONEFLAG(p_MEDLEYset_DS, i);



         // define BIS for standalone test
         gft_ModemType = G_DMT_BIS;

         guc_RX_MIN_BITS_PER_TONE = 1;

         STATArray[STAT_Mode] = STAT_ConfigMode_G992_3_A;

         gl_SelectedMode = MODE_G992_3 | ANNEX_A;


         /*  We re-allocate the default values to the HS_BIS structure before entering bit-loading. */
         gt_HandshakeBis.sa_DS_MaxCheckbytesLP[LP0_DATA_PATH] = (int16) (2* MAX_R_LP0_DS);
         gt_HandshakeBis.sa_DS_MaxIntlvDepthLP[LP0_DATA_PATH] = (int16) 64;


         guc_MaxAllocBitsPerTone = RX_MAX_BITS_PER_TONE;


         CLEARTONEFLAG(p_MEDLEYset_DS, gs_PilotToneIdx);

         gs_RxNumTones=256;

         fprintf(file_pms,"\n SNR \n ");


         for(i=0;i<gs_RxNumTones;i++)
            fprintf(file_pms,"%ld ", gsa_my_MedleySnrBuf[i] >> 8);

         fprintf(file_pms,"\n \n ");


         /*****************************************************************
         Initialze the medley and reverb3 snr
         *****************************************************************/

         for(i=0;i<gs_RxNumTones;i++)
         {
            gsa_ReverbSnrBuf[i]=(int16)(gsa_my_MedleySnrBuf[i]);
            gsa_ReverbEchoSnrBuf[i]=(int16)(gsa_my_MedleySnrBuf[i]);
//          gsa_my_RxShowtimeSnrBuf[i] = (int16)(gsa_my_MedleySnrBuf[i]);
         }

         gsa_MedleySnrBuf=&gsa_my_MedleySnrBuf[0];

         // TCM on, Bitswap enable
         OPTNArray[OPTN_AlgControl] = 0x0F40;

         gs_tcm_coding_gain = TCM_CODING_GAIN;
         gs_max_coding_gain = MAX_CODING_GAIN;
         /*  SNR's (in dB) required for QAM */

         gsa_ConstellationSNR[0] = 0x0B4F;   /*  11.31 dB =  1 bit (NOT USED) */
         gsa_ConstellationSNR[1] = 0x0B4F;   /*  11.31 dB =  1 bit (NOT USED) */
         gsa_ConstellationSNR[2] = 0x0E51; /*  14.32 dB =  2 bits  */
         gsa_ConstellationSNR[3] = 0x131C;   /*  19.11 dB =  3 bits */
         gsa_ConstellationSNR[4] = 0x154F;   /*  21.31 dB =  4 bits */
         gsa_ConstellationSNR[5] = 0x1875;   /*  24.46 dB =  5 bits */
         gsa_ConstellationSNR[6] = 0x1B8A;   /*  27.54 dB =  6 bits */
         gsa_ConstellationSNR[7] = 0x1E97;   /*  30.59 dB =  7 bits */
         gsa_ConstellationSNR[8] = 0x219C;   /*  33.61 dB =  8 bits */
         gsa_ConstellationSNR[9] = 0x24A1;   /*  36.63 dB =  9 bits */
         gsa_ConstellationSNR[10] = 0x27A6; /*  39.65 dB = 10 bits */
         gsa_ConstellationSNR[11] = 0x2AA8; /*  42.66 dB = 11 bits */
         gsa_ConstellationSNR[12] = 0x2DAB; /*  45.67 dB = 12 bits */
         gsa_ConstellationSNR[13] = 0x30AE;  /*  48.68 dB = 13 bits */
         gsa_ConstellationSNR[14] = 0x33B0; /*  51.69 dB = 14 bits */
         gsa_ConstellationSNR[15] = 0x36B3; /*  54.70 dB = 15 bits */


         /* Initialize the handshake parameters for standalone test */
         gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 0;

         gt_HandshakeBis.s_MinMSGDSOverheadRate = 4;

         gt_HandshakeBis.sa_DS_MaxLatencyBC[0] = 63;

         /* define which Bearer channels and latency paths are active */

         gt_HandshakeBis.sa_DS_BCActive[0] = 1;
         gt_HandshakeBis.sa_DS_BCActive[1] = 0;
         gt_HandshakeBis.s_NumDSLatencyPaths = 1;     /* DS number of latency paths activated */


         gs_RxDesiredMargin = 1536;
         gt_RCMsgs1_bis.us_MAXSNRMds = 110 ;    // 11 dB

         // Run Adaptive Rate
         gs_maxdatarate_in= 4000;

         gt_HandshakeBis.sa_DS_MaxDataRateLP[LP0_DATA_PATH] = gs_maxdatarate_in;

         gt_HandshakeBis.sa_DS_MaxNetDataRateBC[0] = gs_maxdatarate_in;

         gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[0] = 8;

         // calls bitload_bis
         BgMedleyBitload_bis();

         gs_Lp_final=gt_PMSParams.s_Lp[LP0_DATA_PATH];

         s_BatCheck = VerifyBat((uint8 *)&guca_RxBat[0]);

         // initialize it here, required in ChangeBat, so as not to change ncloaded
         gs_RxState = R_C_SHOWTIME_RX;

         for(i=0;i<gs_RxNumTones;i++)
         {
            gsa_my_RxShowtimeSnrBuf[i] = (int16)(gsa_my_MedleySnrBuf[i]);
         }

         gsa_RxShowtimeSnrBuf = gsa_my_RxShowtimeSnrBuf;

         // initialize showtime pointers
         gt_RxShowTimeVars.pt_Config =  &gt_rx_config;

         gt_rx_config.psa_BAT =  guca_RxBat;
         gt_rx_config.psa_FineGains = gsa_RxFineGains;

         // Initialize to L0 state for OLR
         gt_RxOLRPMVars.uc_rxOLRPMState = L0_STEADY_STATE;

         fprintf(file_pms, "\n \n");


         // collect bitswap trail
         gs_trail_bitswap = 0;

         gs_REDUCE_LP_DELTA_BITSWAP = 2;
         gs_BITSWAP_TRIGGER_DELTA = 0x300;// 3dB
         gs_Bitswap_Accept_Delta = 0x100; // 1dB

         fprintf(file_pms, "\nBitswap trigger = %ld\t dB\n",gs_BITSWAP_TRIGGER_DELTA>>8);
         fprintf(file_pms, "Bitswap Accept =  %ld\t dB  \n",gs_Bitswap_Accept_Delta>>8);
         fprintf(file_pms, "DeltaLp =  %ld\t dB  \n",gs_REDUCE_LP_DELTA_BITSWAP);

         fprintf(file_pms, "Tone start noise add = %ld \n", s_tone_noiseincrease_start);
         fprintf(file_pms, "Tone end noise add = %ld \n", s_tone_noiseincrease_end);

         fprintf (file_pms, "\nLoop \t MinMgn_before\t MinMrgTone \t AvgMrgBeforeSwap\t MinMrg_after \t MinMrg_Tone\t  Avg_Margin_afterswap\t  BitSwap_cnt \t DeltaLp\t RMS_Gain \t\n");


         s_deltaLpcount = 4;  // based on saved States trail

         // save the initial BAT
         for(i=gs_RxFirstChannel;i<gs_RxNumTones;i++)
         {
            guca_RxBat_init[i] = guca_RxBat[i];
         }
            // Add noise same as an snr update;
         for(j=0; j<1; j++)
         {

            // Decrease SNR on set of tones
            // stop iterating if bits on these tones are min bits
            // (for the current set up 2)

            for(i=s_tone_noiseincrease_start;i<s_tone_noiseincrease_end;i++)
            {
               gsa_RxShowtimeSnrBuf[i] -= 2400; // decrease enough to bring this tone to 1 bit
            }

            s_bat_stable = 0;

            // Do as many required bitswaps
            while(!s_bat_stable)
            {
               // initialize
               s_RxMinMargin = 0x7FFF; /* Initialise to a large number */

               gs_MaxToneForFast = -1;                         /* Number of tones whose bits are allocated to fast path */

               s_RxAvMargin = CalcAvgMargin(gsa_RxToneOrder, gsa_RxShowtimeSnrBuf, guca_RxBat, gsa_RxFineGains,  (FlagT) 0, 0, 0);

               FindToneWithExtremeMargin(SMALLEST_MARGIN, guca_RxBat, gsa_RxFineGains, gsa_RxShowtimeSnrBuf, p_MEDLEYset_DS, s_MinBitsperTone, (int16) guc_MaxAllocBitsPerTone, &s_RxMinMarginToneBeforeSwap, &s_RxMinMarginBeforeSwap);

               s_RxAvgMarginBeforeSwap = s_RxAvMargin;

               // save the current BAT
               for(i=gs_RxFirstChannel;i<gs_RxNumTones;i++)
               {
                  guca_RxBat_save[i] = guca_RxBat[i];
               }

               // determine BAT status before bitswap
               GetBatStats(guca_RxBat, gs_RxNumTones, gft_TcmFlag_bis_DS, &s_ncloaded_beforeswap, &s_Num1BitTones_before, &s_TCM_Ovhd_before, &s_FinalSumBi_before, s_path);

               /* compute RMS fine gain value */
               l_Prod = (int32) ComputeRMSFineGain(guca_RxBat, gsa_RxFineGains, gs_RxNumTones, gs_CurrentCoChipset, 0, 0);

               s_RMSFineGaindB_beforeSwap = 2* (ConvertToDB(l_Prod)  -  ConvertToDB(8192));


               // check for any OLR
               Rx_OLR_Decision();


               s_RxMinMargin = 0x7FFF; /* Initialise to a large number */

               s_RxAvMargin = CalcAvgMargin(gsa_RxToneOrder, gsa_RxShowtimeSnrBuf, guca_RxBat, gsa_RxFineGains,  (FlagT) 0, 0, 0);

               FindToneWithExtremeMargin(SMALLEST_MARGIN, guca_RxBat, gsa_RxFineGains, gsa_RxShowtimeSnrBuf, p_MEDLEYset_DS, s_MinBitsperTone, (int16) guc_MaxAllocBitsPerTone, &s_RxMinMarginToneAfterSwap, &s_RxMinMarginAfterSwap);
               s_RxAvgMarginAfterSwap = s_RxAvMargin;

               // Bitswap performed
               if (gt_RxOLRPMVars.uc_rxOLRPMState == OLR_LOAD_TABLES) // BITSWAP OK
               {

                  // determine BAT status
                  GetBatStats(guca_RxBat, gs_RxNumTones, gft_TcmFlag_bis_DS, &s_ncloaded_afterswap, &s_Num1BitTones_after, &s_TCM_Ovhd_after, &s_FinalSumBi_after, s_path);

                  /* compute RMS fine gain value */
                  l_Prod = (int32) ComputeRMSFineGain(guca_RxBat, gsa_RxFineGains, gs_RxNumTones, gs_CurrentCoChipset, 0, 0);

                  s_RMSFineGaindB_AfterSwap = 2* (ConvertToDB(l_Prod)  -  ConvertToDB(8192));


                  // set diferent error flags
                  s_error = 0;

                  // check that all bi are between min and max

                  for(i=gs_RxFirstChannel;i<gs_RxNumTones;i++)
                  {
                     bi = guca_RxBat[i];
                     if (((bi < guc_RX_MIN_BITS_PER_TONE) || (bi > RX_MAX_BITS_PER_TONE)) && (bi !=0))
                        s_error = 5;
                  }


                  for(i=gs_RxFirstChannel;i<gs_RxNumTones;i++)
                  {
                     gi = gsa_RxFineGains[i];
                     if (((gi < gs_min_fine_gain) || (gi > gs_max_fine_gain)) && (gi != -32768))
                        s_error = 7;
                  }


                  s_BatCheck1 = VerifyBat((uint8 *)&guca_RxBat[0]);

                  // check that min margin after swap is greater than margin before swap
                  if (s_RxMinMarginAfterSwap < s_RxMinMarginBeforeSwap + gs_Bitswap_Accept_Delta)
                     s_error = 8;

                  // compute excess gain
                  s_CodingGain = gsa_TotalCodingGain[0];

                  for(i=gs_RxFirstChannel;i<gs_RxNumTones;i++)
                  {

                     s_excessgain[i] = 0;
                     bi = guca_RxBat[i];
                     gi = gsa_RxFineGains[i];
                     s_SNR =  gsa_RxShowtimeSnrBuf[i];

                     if (bi!=0)
                     {
                        s_ReqdSNR = gsa_SNRRequired[bi];
                        s_excessgain[i] = s_SNR + s_CodingGain + gi - s_ReqdSNR;
                     }
                     else
                        s_excessgain[i] = 0;

                  }

                  // if min margin < desired margin then check that there is no excess gii on that tone

                  if (s_RxMinMarginAfterSwap < gs_RxDesiredMargin)
                  {
                     bi = s_RxMinMarginToneAfterSwap;
                     if ((gsa_RxFineGains[bi] < gs_max_fine_gain) && (s_excessgain[bi] > 0))
                        s_error = 9;
                  }


                  s_ActualDeltaLp = gsa_StatesTrail[s_deltaLpcount];
                  s_deltaLpcount += 6;

                  if (s_error!=0)
                  {
                     if (s_error == 1) fprintf (file_pms, " ERROR  NcLoaded Different \n");
                     if (s_error ==2)  fprintf (file_pms, " ERROR  Num1Bit Different \n");
                     if (s_error == 3) fprintf (file_pms, " ERROR  TCM overhead Different \n");
                     if (s_error ==4)  fprintf (file_pms, " ERROR  FinalSumBi Different \n");
                     if (s_error ==5)  fprintf (file_pms, " ERROR  bi not between min and max Bits Allowed  \n");
                     if (s_error ==6)  fprintf (file_pms, " ERROR  RMS gain > 0 \n");
                     if (s_error ==7)  fprintf (file_pms, " ERROR  gi not between min and max gain Allowed  \n");
                     if (s_error ==8)  fprintf (file_pms, " ERROR  margin after swap not better  \n");
                     if (s_error == 9)  fprintf (file_pms, " ERROR  Excess gi available on min margin tone  \n");

                  }

                  else if (s_BatCheck1 == 0)
                     fprintf (file_pms, " BAT ERROR \n");

                  // print the result under all cases
                  fprintf (file_pms, "%ld\t %ld\t %ld\t %ld\t %ld\t  %ld\t %ld \t%ld \t%ld\n", j, s_RxMinMarginBeforeSwap,s_RxMinMarginToneBeforeSwap,s_RxAvgMarginBeforeSwap, s_RxMinMarginAfterSwap,s_RxMinMarginToneAfterSwap, s_RxAvgMarginAfterSwap,  s_ActualDeltaLp, s_RMSFineGaindB_AfterSwap);

                  s_bat_stable = 0;

                  // kick another bitswap
                  gt_RxOLRPMVars.uc_rxOLRPMState = L0_STEADY_STATE;


         }
         else if (   gt_RxOLRPMVars.uc_rxOLRPMState == OLR_READ_TABLES)
            // OLR aborted
         {
            // load back the old BAT table
            for(i=gs_RxFirstChannel;i<gs_RxNumTones;i++)
            {
               guca_RxBat[i] = guca_RxBat_save[i];
            }
            // load back gain values

            // Gains  are loaded back in rx_olr_decision

            s_bat_stable = 1;

            // kick another bitswap
            gt_RxOLRPMVars.uc_rxOLRPMState = L0_STEADY_STATE;

         }
         else if (gt_RxOLRPMVars.uc_rxOLRPMState == L0_STEADY_STATE)
         {
            // no bitswap got triggered
            s_bat_stable = 1;
         }

         // equivalent to evacuating a tone
         if (guca_RxBat[s_tone_noiseincrease_start] == s_MinBitsperTone -1 ) j = s_MAX_ITER;

         } // s_bat_stable

      }//j
         fprintf(file_pms, "\n BAT_BEFORE & AFTER SWAPS \n");

      for(i=0;i<gs_RxNumTones;i++)
         fprintf(file_pms,"%ld \t %ld\t \n ",guca_RxBat_init[i], guca_RxBat[i] );
      fprintf(file_pms,"\n\n");
}


   // test to select the number of tones to add noise randomly
   // start with a predefined SNR, do bitloading on it

   l_seed = -10;


   /* Add noise  of different kinds
      test_run =  0; random noise
               1, flat noise
               2, shaped spectrum
   */
      fprintf(file_pms, "\n \n");

      fprintf(file_pms, " TEST WITH DIFFERENT NOISE ADDITIONS; SPECIFYING TONE START, \n");
      fprintf(file_pms, "  TONE END, PERCENTAGE OF TONES GETTING PERTURBED \n");


   for (test_run=0; test_run < 3; test_run++)
   {
      // percentage of tones to which noise is added before OLR
      p=ran1(&l_seed);

      noise_power =3;  // in dB

      gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_10kft;
      // tones for adding noise
      s_tone_noiseincrease_start = 33;
      s_tone_noiseincrease_end = 255;

      for (i=gs_RxFirstChannel ; i<=gs_RxLastChannel ; i++)
         SETTONEFLAG(p_MEDLEYset_DS, i);

      // define BIS for standalone test
      gft_ModemType = G_DMT_BIS;

      guc_RX_MIN_BITS_PER_TONE = 1;

      STATArray[STAT_Mode] = STAT_ConfigMode_G992_3_A;
      gt_HandshakeBis.s_OneOverSminADSL2 = 2;

      gl_SelectedMode = MODE_G992_3 | ANNEX_A;


      /*  We re-allocate the default values to the HS_BIS structure before entering bit-loading. */
      gt_HandshakeBis.sa_DS_MaxCheckbytesLP[LP0_DATA_PATH] = (int16) (2* MAX_R_LP0_DS);
      gt_HandshakeBis.sa_DS_MaxIntlvDepthLP[LP0_DATA_PATH] = (int16) 64;


      guc_MaxAllocBitsPerTone = RX_MAX_BITS_PER_TONE;

      gs_AuxPilotToneIdx = gs_CPilotTone;
      gs_PilotToneIdx = gs_CPilotTone;

      // Point Task layer pointers to locally defined buffers.

      gsa_MedleySnrBuf=gsa_my_MedleySnrBuf;

      gsa_RxShowtimeSnrBuf = gsa_my_RxShowtimeSnrBuf;
      gsa_RxFineGains = gsa_my_RxFineGains;
      gsa_TempRxFineGains = gsa_my_RxTempFineGains;
      gsa_RxCombinedGains = gsa_my_RxCombinedGains;
      gsa_RxToneOrder = gsa_my_RxToneOrder;

      for (i=0 ; i< RX_NUM_TONES ; i++)
         gsa_RxToneOrder[i] = i;

      /*****************************************************************
         Initialze the medley and reverb3 snr and RX num Tones
      *****************************************************************/

      for(i=0;i<gs_RxNumTones;i++)
      {
         gsa_ReverbSnrBuf[i]=(int16)(gsa_my_MedleySnrBuf[i]);
         gsa_ReverbEchoSnrBuf[i]=(int16)(gsa_my_MedleySnrBuf[i]);
      }

      gsa_MedleySnrBuf=&gsa_my_MedleySnrBuf[0];

      // TCM on, Bitswap enable
      OPTNArray[OPTN_AlgControl] = 0x0F40;

      gs_tcm_coding_gain = TCM_CODING_GAIN;
      gs_max_coding_gain = MAX_CODING_GAIN;
      /*  SNR's (in dB) required for QAM */

      gsa_ConstellationSNR[0] = 0x0B4F;   /*  11.31 dB =  1 bit (NOT USED) */
      gsa_ConstellationSNR[1] = 0x0B4F;   /*  11.31 dB =  1 bit (NOT USED) */
      gsa_ConstellationSNR[2] = 0x0E51; /*  14.32 dB =  2 bits  */
      gsa_ConstellationSNR[3] = 0x131C;   /*  19.11 dB =  3 bits */
      gsa_ConstellationSNR[4] = 0x154F;   /*  21.31 dB =  4 bits */
      gsa_ConstellationSNR[5] = 0x1875;   /*  24.46 dB =  5 bits */
      gsa_ConstellationSNR[6] = 0x1B8A;   /*  27.54 dB =  6 bits */
      gsa_ConstellationSNR[7] = 0x1E97;   /*  30.59 dB =  7 bits */
      gsa_ConstellationSNR[8] = 0x219C;   /*  33.61 dB =  8 bits */
      gsa_ConstellationSNR[9] = 0x24A1;   /*  36.63 dB =  9 bits */
      gsa_ConstellationSNR[10] = 0x27A6; /*  39.65 dB = 10 bits */
      gsa_ConstellationSNR[11] = 0x2AA8; /*  42.66 dB = 11 bits */
      gsa_ConstellationSNR[12] = 0x2DAB; /*  45.67 dB = 12 bits */
      gsa_ConstellationSNR[13] = 0x30AE;  /*  48.68 dB = 13 bits */
      gsa_ConstellationSNR[14] = 0x33B0; /*  51.69 dB = 14 bits */
      gsa_ConstellationSNR[15] = 0x36B3; /*  54.70 dB = 15 bits */

      /* Initialize the handshake parameters for standalone test */
      gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 0;

      gt_HandshakeBis.s_MinMSGDSOverheadRate = 4;

      gt_HandshakeBis.sa_DS_MaxLatencyBC[0] = 63;

      /* define which Bearer channels and latency paths are active */

      gt_HandshakeBis.sa_DS_BCActive[0] = 1;
      gt_HandshakeBis.sa_DS_BCActive[1] = 0;
      gt_HandshakeBis.s_NumDSLatencyPaths = 1;     /* DS number of latency paths activated */


      gs_RxDesiredMargin = 1536;
      gt_RCMsgs1_bis.us_MAXSNRMds = 110 ;    // 11 dB

      // Run Adaptive Rate
      gs_maxdatarate_in= 4000;

      gt_HandshakeBis.sa_DS_MaxDataRateLP[LP0_DATA_PATH] = gs_maxdatarate_in;

      gt_HandshakeBis.sa_DS_MaxNetDataRateBC[0] = gs_maxdatarate_in;

      gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[0] = 8;

      gs_RxNumTones = 256;

      // calls bitload_bis
      BgMedleyBitload_bis();

      // determine BAT status before bitswap
      GetBatStats(guca_RxBat, gs_RxNumTones, gft_TcmFlag_bis_DS, &gus_ncloaded, &s_Num1BitTones_before, &s_TCM_Ovhd_before, &s_FinalSumBi_before, s_path);

      gs_Lp_final=gt_PMSParams.s_Lp[LP0_DATA_PATH];

      s_BatCheck = VerifyBat((uint8 *)&guca_RxBat[0]);

      // initialize it here, required in ChangeBat, so as not to change ncloaded
      gs_RxState = R_C_SHOWTIME_RX;

      // initialize it here, required in ChangeBat, so as not to change ncloaded

         for(i=0;i<gs_RxNumTones;i++)
         {
            gsa_my_RxShowtimeSnrBuf[i] = (int16)(gsa_my_MedleySnrBuf[i]);
         }

         gsa_RxShowtimeSnrBuf = gsa_my_RxShowtimeSnrBuf;

      // initialize showtime pointers
      gt_RxShowTimeVars.pt_Config =  &gt_rx_config;

      gt_rx_config.psa_BAT =  guca_RxBat;
      gt_rx_config.psa_FineGains = gsa_RxFineGains;

      // kick another bitswap
      gt_RxOLRPMVars.uc_rxOLRPMState = L0_STEADY_STATE;

      gs_REDUCE_LP_DELTA_BITSWAP = 100;
      gs_BITSWAP_TRIGGER_DELTA = 0x0;// 3dB
      gs_Bitswap_Accept_Delta = 0x0; // 1dB

      switch (test_run)
      {
      case 0:
         fprintf(file_pms, "\n RANDOM NOISE \n");
         break;

      case 1:
         fprintf(file_pms, "\n RANDOM PLUS FLAT NOISE \n");
         break;

      case 2:
         fprintf(file_pms, "\n RANDOM PLUS SHAPED SPECTRUM (HDSL) \n");
         break;
      }


      fprintf(file_pms, "\nBitswap trigger = %ld\t dB\n",gs_BITSWAP_TRIGGER_DELTA>>8);
      fprintf(file_pms, "Bitswap Accept =  %ld\t dB  \n",gs_Bitswap_Accept_Delta>>8);
      fprintf(file_pms, "DeltaLp =  %ld\t dB  \n",gs_REDUCE_LP_DELTA_BITSWAP);

      fprintf(file_pms, "Tone start noise add = %ld \n", s_tone_noiseincrease_start);
      fprintf(file_pms, "Tone end noise add = %ld \n", s_tone_noiseincrease_end);
      fprintf (file_pms, "Percentage of Tones getting perturbed = %f6 \n", p);
      fprintf(file_pms, "Noise Power in dB = %ld \n", noise_power);

      fprintf (file_pms, "\nTest \t MinMgn_before\t MinMrgTone \t AvgMrgBeforeSwap\t MinMrg_after \t MinMrg_Tone\t  Avg_Margin_afterswap\t  BitSwap_cnt \t DeltaLp\t RMS_Gain \t\n");


      // save the initial BAT
      for(i=gs_RxFirstChannel;i<gs_RxNumTones;i++)
      {
         guca_RxBat_init[i] = guca_RxBat[i];
      }

      // showtimesnr buffer same as medley snr
      gsa_RxShowtimeSnrBuf = gsa_my_MedleySnrBuf;


      gen_noise_spectrum( s_tone_noiseincrease_start,  s_tone_noiseincrease_end,  test_run,  noise_power,  p, gsa_noise_sp);


      for(i=s_tone_noiseincrease_start;i<s_tone_noiseincrease_end;i++)
      {
//       gsa_RxShowtimeSnrBuf[i] -= gsa_noise_sp[i];
      }


      // check for bitswap
      s_bat_stable = 0;

      // Do as many required bitswaps
      while(!s_bat_stable)
      {
         // initialize
         s_RxMinMargin = 0x7FFF; /* Initialise to a large number */

         gs_MaxToneForFast = -1;                         /* Number of tones whose bits are allocated to fast path */

         s_RxAvMargin = CalcAvgMargin(gsa_RxToneOrder, gsa_RxShowtimeSnrBuf, guca_RxBat, gsa_RxFineGains,  (FlagT) 0, 0, 0);

         FindToneWithExtremeMargin(SMALLEST_MARGIN, guca_RxBat, gsa_RxFineGains, gsa_RxShowtimeSnrBuf, p_MEDLEYset_DS,  s_MinBitsperTone, (int16) guc_MaxAllocBitsPerTone, &s_RxMinMarginToneBeforeSwap, &s_RxMinMarginBeforeSwap);

         s_RxAvgMarginBeforeSwap = s_RxAvMargin;

         // save the current BAT
         for(i=gs_RxFirstChannel;i<gs_RxNumTones;i++)
         {
            guca_RxBat_save[i] = guca_RxBat[i];
         }

         // determine BAT status before bitswap
         GetBatStats(guca_RxBat, gs_RxNumTones, gft_TcmFlag_bis_DS, &s_ncloaded_beforeswap, &s_Num1BitTones_before, &s_TCM_Ovhd_before, &s_FinalSumBi_before, s_path);

         /* compute RMS fine gain value */
         l_Prod = (int32) ComputeRMSFineGain(guca_RxBat, gsa_RxFineGains, gs_RxNumTones, gs_CurrentCoChipset, 0, 0);

         s_RMSFineGaindB_beforeSwap = 2* (ConvertToDB(l_Prod)  -  ConvertToDB(8192));


         // check for any OLR
         Rx_OLR_Decision();


         s_RxMinMargin = 0x7FFF; /* Initialise to a large number */

         s_RxAvMargin = CalcAvgMargin(gsa_RxToneOrder, gsa_RxShowtimeSnrBuf, guca_RxBat, gsa_RxFineGains,  (FlagT) 0, 0, 0);

         FindToneWithExtremeMargin(SMALLEST_MARGIN, guca_RxBat, gsa_RxFineGains, gsa_RxShowtimeSnrBuf, p_MEDLEYset_DS,  s_MinBitsperTone, (int16) guc_MaxAllocBitsPerTone, &s_RxMinMarginToneAfterSwap, &s_RxMinMarginAfterSwap);
         s_RxAvgMarginAfterSwap = s_RxAvMargin;

         // Bitswap performed
         if (gt_RxOLRPMVars.uc_rxOLRPMState == OLR_LOAD_TABLES) // BITSWAP OK
         {

            // determine BAT status
            GetBatStats(guca_RxBat, gs_RxNumTones, gft_TcmFlag_bis_DS, &s_ncloaded_afterswap, &s_Num1BitTones_after, &s_TCM_Ovhd_after, &s_FinalSumBi_after, s_path);

            /* compute RMS fine gain value */
            l_Prod = (int32) ComputeRMSFineGain(guca_RxBat, gsa_RxFineGains, gs_RxNumTones, gs_CurrentCoChipset, 0, 0);

            s_RMSFineGaindB_AfterSwap = 2* (ConvertToDB(l_Prod)  -  ConvertToDB(8192));


            // set diferent error flags
            s_error = 0;

            if (s_ncloaded_afterswap != s_ncloaded_beforeswap) s_error = 1;
            if (s_Num1BitTones_after != s_Num1BitTones_before) s_error = 2;
            if (s_TCM_Ovhd_after != s_TCM_Ovhd_before) s_error = 3;
            if (s_FinalSumBi_after != s_FinalSumBi_before) s_error = 4;

            // check that all bi are between min and max

            for(i=gs_RxFirstChannel;i<gs_RxNumTones;i++)
            {
               bi = guca_RxBat[i];
               if (((bi < guc_RX_MIN_BITS_PER_TONE) || (bi > RX_MAX_BITS_PER_TONE)) && (bi !=0))
                  s_error = 5;
            }

            // check all gi are correct
            if (s_RMSFineGaindB_AfterSwap > 0 ) s_error=6;

            for(i=gs_RxFirstChannel;i<gs_RxNumTones;i++)
            {
               gi = gsa_RxFineGains[i];
               if (((gi < gs_min_fine_gain) || (gi > gs_max_fine_gain)) && (gi != -32768))
                  s_error = 7;
            }


            s_BatCheck1 = VerifyBat((uint8 *)&guca_RxBat[0]);

            // check that min margin after swap is greater than margin before swap
            if (s_RxMinMarginAfterSwap < s_RxMinMarginBeforeSwap + gs_Bitswap_Accept_Delta)
               s_error = 8;

            // compute excess gain
            s_CodingGain = gsa_TotalCodingGain[0];

            for(i=gs_RxFirstChannel;i<gs_RxNumTones;i++)
            {

               s_excessgain[i] = 0;
               bi = guca_RxBat[i];
               gi = gsa_RxFineGains[i];
               s_SNR =  gsa_RxShowtimeSnrBuf[i];

               if (bi!=0)
               {
                  s_ReqdSNR = gsa_SNRRequired[bi];
                  s_excessgain[i] = s_SNR + s_CodingGain + gi - s_ReqdSNR;
               }
               else
                  s_excessgain[i] = 0;

            }

            // if min margin < desired margin then check that there is no excess gii on that tone

            if (s_RxMinMarginAfterSwap < gs_RxDesiredMargin)
            {
               bi = s_RxMinMarginToneAfterSwap;
               if ((gsa_RxFineGains[bi] < gs_max_fine_gain) && (s_excessgain[bi] > 0))
                  s_error = 9;
            }


            s_ActualDeltaLp = gsa_StatesTrail[s_deltaLpcount];
            s_deltaLpcount += 6;

            if (s_error!=0)
            {
               if (s_error == 1) fprintf (file_pms, " ERROR  NcLoaded Different \n");
               if (s_error ==2)  fprintf (file_pms, " ERROR  Num1Bit Different \n");
               if (s_error == 3) fprintf (file_pms, " ERROR  TCM overhead Different \n");
               if (s_error ==4)  fprintf (file_pms, " ERROR  FinalSumBi Different \n");
               if (s_error ==5)  fprintf (file_pms, " ERROR  bi not between min and max Bits Allowed  \n");
               if (s_error ==6)  fprintf (file_pms, " ERROR  RMS gain > 0 \n");
               if (s_error ==7)  fprintf (file_pms, " ERROR  gi not between min and max gain Allowed  \n");
               if (s_error ==8)  fprintf (file_pms, " ERROR  margin after swap not better  \n");
               if (s_error == 9)  fprintf (file_pms, " ERROR  Excess gi available on min margin tone  \n");

            }

            else if (s_BatCheck1 == 0)
               fprintf (file_pms, " BAT ERROR \n");
            else
               fprintf (file_pms, "%ld\t %ld\t %ld\t %ld\t  %ld \t %ld\t %ld \t%ld \t%ld\n",test_run, s_RxMinMarginBeforeSwap,s_RxMinMarginToneBeforeSwap,s_RxAvgMarginBeforeSwap, s_RxMinMarginAfterSwap,s_RxMinMarginToneAfterSwap, s_RxAvgMarginAfterSwap, s_ActualDeltaLp, s_RMSFineGaindB_AfterSwap);

            s_bat_stable = 0;

            // kick another bitswap
            gt_RxOLRPMVars.uc_rxOLRPMState = L0_STEADY_STATE;


         }
         else if (   gt_RxOLRPMVars.uc_rxOLRPMState == OLR_READ_TABLES)
            // OLR aborted
         {
            // load back the old BAT table
            for(i=gs_RxFirstChannel;i<gs_RxNumTones;i++)
            {
               guca_RxBat[i] = guca_RxBat_save[i];
            }
            // load back gain values

            // Gains  are loaded back in rx_olr_decision

            s_bat_stable = 1;

            // kick another bitswap
            gt_RxOLRPMVars.uc_rxOLRPMState = L0_STEADY_STATE;

         }
         else if (gt_RxOLRPMVars.uc_rxOLRPMState == L0_STEADY_STATE)
         {
            // no bitswap got triggered
            s_bat_stable = 1;

         }


         // equivalent to evacuating a tone
         if (guca_RxBat[s_tone_noiseincrease_start] ==2 ) j = s_MAX_ITER;

         } // s_bat_stable

         }// test_run
#endif
         fcloseall();


 }  // end of main program

   /********************************************************************************
   ;  Subroutine Name: void VerifyBat(void)
   ;
   ;
   ;  Prototype:
   ;     void VerifyBat(void)
   ;
   ;  Input Arguments:
   ;
   ;
   ;  Output Arguments:
   ;
   ;
   ;  Return:
   ;
   ;
   ;  Global Variable used by this file:
   ;
   ;****************************************************************************/

   C_SCOPE int16 VerifyBat(uint8 *psa_Bat)
   {
      FlagT ft_TcmFlag;
      int16 i, s_bits, s_NumLoadedTones;

      if(gft_ModemType == G_DMT_BIS) ft_TcmFlag =  gft_TcmFlag_bis_DS;
      else ft_TcmFlag = gft_TcmFlag;

      s_bits = 0;
      for(i=0; i<gs_RxNumTones; i++) {
         s_bits += psa_Bat[i];
      }

      gus_Rx_Tcm_Num1bits = 0;
      for(i=0, s_NumLoadedTones=0; i<gs_RxNumTones; i++) {
         s_NumLoadedTones += (int16) (psa_Bat[i] > 0);
         if (ft_TcmFlag==TRUE) gus_Rx_Tcm_Num1bits += (int16) (psa_Bat[i] == 1);
      }

      // Update count of # of loaded tones
      gus_ncloaded = (uint16)(s_NumLoadedTones & 0xFFFF);

      if (ft_TcmFlag==TRUE) {
         s_bits -= (4 + ((s_NumLoadedTones - (gus_Rx_Tcm_Num1bits>>1) + 1) >> 1));
      }

      if(s_bits != gs_Lp_final)
         return(FAIL);
      else
         return(SUCCEED);
   }


   /* Dummy Variable to get test_bitload to build */
   PtrToFunc gpF_RxStateFunc; // Global function pointer of RX state function
   /* Dummy Functions to get test_bitload to build */
   void ExceptionHandler(void)
   {
   }


   void FormRInfo2(void)
   {
   }

   void SelectDsRateOption(Option_t *pta_options, int16 *ps_OutRateOption)
   {
   }

   int16 Noise(void)
   {
#define SEED (-10) /* < 0 */

      static int32 l_seed = SEED;
            return ((int16)  (72*gasdev(&l_seed)));
//    return ((int16) (200*gasdev(&l_seed)));

   }
#define IA 16807
#define IM 2147483647
#define AM (1.0/IM)
#define IQ 127773
#define IR 2836
#define NTAB 32
#define NDIV (1+(IM-1)/NTAB)
#define EPS 1.2e-7
#define RNMX (1.0-EPS)

   float64 ran1(int32 *idum)
   {
      int16 j;
      int32 k;
      static int32 iy = 0;
      static int32 iv[NTAB];
      float64 temp;

      if ((*idum <= 0) || !iy) {
         if (-(*idum) < 1) *idum = 1;
         else *idum = -(*idum);
         for (j=NTAB+7; j>=0; j--) {
            k = (*idum)/IQ;
            *idum = IA*(*idum-k*IQ)-IR*k;
            if (*idum < 0) *idum += IM;
            if (j < NTAB) iv[j] = *idum;
         }
         iy = iv[0];
      }
      k = (*idum)/IQ;
      *idum = IA*(*idum-k*IQ)-IR*k;
      if (*idum < 0) *idum += IM;
      j = iy/NDIV;
      iy = iv[j];
      iv[j] = *idum;
      if ((temp = AM*iy) > RNMX) return RNMX;
      else return temp;
   }

#undef IA
#undef IM
#undef AM
#undef IQ
#undef IR
#undef NTAB
#undef NDIV
#undef EPS
#undef RNMX

   float64 gasdev(int32 *idum)
   {
      float64 ran1(int32 *idum);
      static int16 iset = 0;
      static float64 gset;
      float64 fac, rsq, v1, v2;

      if (iset == 0) {
         do {
            v1 = 2.0*ran1(idum)-1.0;
            v2 = 2.0*ran1(idum)-1.0;
            rsq = v1*v1+v2*v2;
         }while ((rsq >= 1.0) || (rsq == 0.0));
         fac = sqrt(-2.0*log(rsq)/rsq);
         gset = v1*fac;
         iset = 1;
         return v2*fac;
      }
      else {
         iset = 0;
         return gset;
      }
   }



   /*void gen_noise_spectrum(int16 s_tone_noiseincrease_start, int16 s_tone_noiseincrease_end, int16 test_run, int16 noise_power, float64 p, int16 *psa_noise_sp)
   Standalone function to generate noise spectrum

   Inputs :
   s_tone_noiseincrease_start : tone from which noise needs to be added
   s_tone_noiseincrease_end  : last tone to which noise is added
   test_run :  0 add random noise
   1 add fixed noise
   2 shaped spectrum
   noise_power : power of noise in steps of dB
   p : percentage of tones to be perturbed

      Returns :
      psa_noise_sp (array of noise values)
   */


   void gen_noise_spectrum(int16 s_tone_noiseincrease_start, int16 s_tone_noiseincrease_end, int16 test_run, int16 noise_power, float64 p, int16 *psa_noise_sp)
   {
      int16 i, s_ch, s_numtonesconsider, s_numtonestoch, s_tonetoconsider;
      RxToneFlags p_ActiveTones_ToConsider;
      int32 l_seed=-10;
      float64 p1;

      int16 sa_shaped_sp[256]={0 ,
         167 ,
         209 ,
         225 ,
         232 ,
         237 ,
         240 ,
         242 ,
         243 ,
         244 ,
         245 ,
         246 ,
         247 ,
         247 ,
         247 ,
         247 ,
         247 ,
         247 ,
         247 ,
         247 ,
         247 ,
         247 ,
         246 ,
         246 ,
         245 ,
         245 ,
         244 ,
         243 ,
         243 ,
         242 ,
         241 ,
         240 ,
         239 ,
         238 ,
         237 ,
         236 ,
         234 ,
         233 ,
         232 ,
         231 ,
         229 ,
         228 ,
         226 ,
         225 ,
         223 ,
         222 ,
         220 ,
         219 ,
         217 ,
         216 ,
         214 ,
         212 ,
         211 ,
         209 ,
         208 ,
         206 ,
         204 ,
         203 ,
         201 ,
         200 ,
         198 ,
         196 ,
         195 ,
         193 ,
         192 ,
         190 ,
         189 ,
         187 ,
         186 ,
         184 ,
         183 ,
         181 ,
         180 ,
         178 ,
         177 ,
         176 ,
         174 ,
         173 ,
         171 ,
         170 ,
         169 ,
         167 ,
         166 ,
         165 ,
         163 ,
         162 ,
         161 ,
         160 ,
         158 ,
         157 ,
         156 ,
         155 ,
         153 ,
         152 ,
         151 ,
         150 ,
         149 ,
         148 ,
         146 ,
         145 ,
         144 ,
         143 ,
         142 ,
         141 ,
         140 ,
         139 ,
         138 ,
         136 ,
         135 ,
         134 ,
         133 ,
         132 ,
         131 ,
         130 ,
         129 ,
         128 ,
         127 ,
         126 ,
         125 ,
         125 ,
         124 ,
         123 ,
         122 ,
         121 ,
         120 ,
         119 ,
         118 ,
         117 ,
         116 ,
         115 ,
         115 ,
         114 ,
         113 ,
         112 ,
         111 ,
         110 ,
         110 ,
         109 ,
         108 ,
         107 ,
         106 ,
         105 ,
         105 ,
         104 ,
         103 ,
         102 ,
         102 ,
         101 ,
         100 ,
         99 ,
         99 ,
         98 ,
         97 ,
         97 ,
         96 ,
         95 ,
         94 ,
         94 ,
         93 ,
         92 ,
         92 ,
         91 ,
         90 ,
         90 ,
         89 ,
         88 ,
         88 ,
         87 ,
         86 ,
         86 ,
         85 ,
         84 ,
         84 ,
         83 ,
         83 ,
         82 ,
         81 ,
         81 ,
         80 ,
         80 ,
         79 ,
         78 ,
         78 ,
         77 ,
         77 ,
         76 ,
         76 ,
         75 ,
         74 ,
         74 ,
         73 ,
         73 ,
         72 ,
         72 ,
         71 ,
         71 ,
         70 ,
         69 ,
         69 ,
         68 ,
         68 ,
         67 ,
         67 ,
         66 ,
         66 ,
         65 ,
         65 ,
         64 ,
         64 ,
         63 ,
         63 ,
         62 ,
         62 ,
         61 ,
         61 ,
         60 ,
         60 ,
         59 ,
         59 ,
         58 ,
         58 ,
         58 ,
         57 ,
         57 ,
         56 ,
         56 ,
         55 ,
         55 ,
         54 ,
         54 ,
         54 ,
         53 ,
         53 ,
         52 ,
         52 ,
         52 ,
         51 ,
         51 ,
         51 ,
         50 ,
         50 ,
         50 ,
         50 ,
         49 ,
         49 ,
         49 ,
         49 ,
         48 ,
         48 ,
         48 ,
         48 ,
         48 ,
         48 ,
         48 ,
         48 ,
         48    };

         for (s_ch = 0; s_ch < gs_RxNumTones; s_ch++)
            CLEARTONEFLAG(p_ActiveTones_ToConsider, s_ch);

         s_numtonestoch = (int16)(gus_ncloaded * p);
         s_numtonesconsider = 0;

         if ( p ==1)
         {
            for (s_ch = 0; s_ch < gs_RxNumTones; s_ch++)
               SETTONEFLAG(p_ActiveTones_ToConsider, s_ch);

         }

         //based on value of p, select p% tones to be effected

         while ((s_numtonesconsider < s_numtonestoch) && (s_numtonestoch < gus_ncloaded))
         {

            p1=ran1(&l_seed);
            s_tonetoconsider = (int16)(gs_RxFirstChannel +  p1* (gs_RxLastChannel - gs_RxFirstChannel));

            if( IS_TONEFLAGSET(p_ActiveTones_ToConsider, s_tonetoconsider))
               continue;
            else
            {
               SETTONEFLAG(p_ActiveTones_ToConsider, s_tonetoconsider);
               s_numtonesconsider++;
            }
         }



         for(i=gs_RxFirstChannel;i<gs_RxNumTones;i++)
         {
            psa_noise_sp[i]=  0;
         }


         switch (test_run)

         {
         case 0: // random noise
            for(i=s_tone_noiseincrease_start;i<s_tone_noiseincrease_end;i++)
            {
               if( IS_TONEFLAGSET(p_ActiveTones_ToConsider, i))
                  psa_noise_sp[i]=  noise_power * Noise();
            }

            break;

         case 1: // test fixed flat noise
            for(i=s_tone_noiseincrease_start;i<s_tone_noiseincrease_end;i++)
            {
               if( IS_TONEFLAGSET(p_ActiveTones_ToConsider, i))
               {
                  // add random noise to all tones
                  psa_noise_sp[i]=    Noise();
                  // flat noise
                  psa_noise_sp[i] +=  noise_power * 0x100;
               }
            }

            break;



         case 2: // shaped spectrum

            for(i=s_tone_noiseincrease_start;i<s_tone_noiseincrease_end;i++)
            {
               if( IS_TONEFLAGSET(p_ActiveTones_ToConsider, i))
               {
                  // add random noise to all tones
                  psa_noise_sp[i]  =   Noise();
                  // shaped noise
                  psa_noise_sp[i] +=  noise_power * sa_shaped_sp[i] ;
               }
            }

            break;

         }
   }

