/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   DoFDExtrap.c
*
*-------------------------------------------------------------------------
*/
/*********************************************************************************/
// Test code to verify Frequency Domain Extrapolation on Channel Estimation
// Standalone code
// Takes lab collected DMT channel estimation
// Runs through the extrapolation and generate the new data
/********************************************************************************/
// ******************************************************************
// DoFDExtrap.c
//
// History
// 10/01/2012 ChihWen/Balabath: To improve the US/DS rate against NVLT-C in T1413 mode, the solutions are below.
//          1. When preparing the parameters in R-MsgsRA, search the best R which will achieve highest K (best net rate),
//                then set the parameters in R-MsgsRA accordingly.
//          After receiving R-MsgsRA, NVLT-C will send C-RatesRA with the first option of the R and K,
//                which are provided by CPE in R-MsgsRA.
//          Then CPE will select the first option from the C-RatesRA.
//          2. The channel response (HLin) on tone 33~38 could be (0,0), which will make channel extrapolation (DoFDExtrap)
//       incorrect because the extrapolation needs to convert the channel response on tone 33~38 to dB scale (ConvertToDB).
//       Then output will be saturated value (-31768, -32768). The saturated response (-32768, -32768) will make
//       frame sync and TDQ calculation incorrect.
//       The fix is to shift the indices of the reference tones in (DoFDExtrap) from tone 33~38 to tone 40~45, and also check the
//       zero response for the reference tones.
//          3. Change near-end vendor ID to "AWARE" to improve US rate.
//          4. NVLT-C will take about 550 symbols to transit from C-Pilot1 state to C-REVERB1 state after receiving R-REVERB1,
//       so adding 32 more symbols (512+16+32) for the transition from C-Pilot1 state to C-REVERB1 state.
//          Grep for XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement.
//
// ******************************************************************
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "typedef.h"
#include "gdata.h"
#include "ghs.h"
#include "gpersistent.h"
#include "ieee_flt.h"
//XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement (START_END)
#include "const.h"
extern void Extrapolate3(Float32* fa_h_ref, Float32* fa_Hinterp, int16 s_NumRefPoints, int16 s_NumExtraPoints, int16 s_ExtrapType, int16 s_ExtrapOrder);
extern void ConvertComplexToAbsPhase(int16 s_Real, int16 s_Imag, Float32* f_Abs, Float32* f_Phase, FlagT ft_doLogAbs);
extern void UnwrapPhase(Float32 *pfa_Array, int16 s_pts);
extern void ConvertAbsPhaseToComplex(Float32 f_Abs, Float32 f_Phase, int16 *psa_h, FlagT ft_doLogAbs);

#define NUM_EXTRAP_TONES  (18)
#define EXTRAP_LAST_TONE  (32)
#define INTERP_ORDER    (3)

FlagT gft_extrap = 1;
int16 gs_NumExtraPoints = 0;

void DoFDExtrap(int16* sa_h_in)
{
   int16 s_RefFirstTone, s_RefLastTone, s_ExtraFirstTone, s_ExtraLastTone, s_ExtrapType, s_ExtrapOrder;
   int16 i, s_skip;
   Float32 fa_h_refAbs[6], fa_h_refPhase[6];
   Float32 fa_Habsinterp[NUM_EXTRAP_TONES], fa_Hphaseinterp[NUM_EXTRAP_TONES];
   int16 s_NumExtraPoints, s_NumRefPoints;

   //Initialize the reference tones and extrapolated tones
// if (gs_CurrentCoChipset ==  IFTN_CO_CHIPSET)  //#define IFTN_CO_CHIPSET    (0x70)
// {
      s_RefFirstTone = 33;
      s_RefLastTone = 38;
      //XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement (START)
      //Shift the indices of the reference tones to 7 once the flag is TRUE.
#ifndef ISDN   // Only for Annex-A
      if (gft_NVLTC_T1413_fix == TRUE)
      {
         s_RefFirstTone += FDEXTRP_OFFSET;
         s_RefLastTone += FDEXTRP_OFFSET;
      }
#endif
      //XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement (END)

      s_NumRefPoints = 6;

      s_NumExtraPoints = 18;//NUM_EXTRAP_TONES;
      //XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement (START)
      //s_ExtraLastTone = EXTRAP_LAST_TONE;
      //s_ExtraFirstTone = EXTRAP_LAST_TONE - s_NumExtraPoints + 1;
      s_ExtraLastTone = s_RefFirstTone-1;
      s_ExtraFirstTone = s_ExtraLastTone - s_NumExtraPoints + 1;
      //XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement (END)

      s_ExtrapType = 0;   //0: Cubic polynomial extrapolation; 1: linear extrapolation; 2: simple extrapolation
      s_ExtrapOrder = INTERP_ORDER;
// }
// else if (gs_CurrentCoChipset == ALA_CO_CHIPSET) //#define ALA_CO_CHIPSET      (0x20)
// {


// }


   //convert reference data from int (real, imag) to float (abs, phase)
   for (i = s_RefFirstTone; i <= s_RefLastTone; i++)
   {
      //XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement (START)
      //Avoid zero input to function (ConvertToDB) in the function (ConvertComplexToAbsPhase).
      if ((sa_h_in[2*i] == 0) && (sa_h_in[2*i+1] == 0))
      {
         sa_h_in[2*i] = 1;
         sa_h_in[2*i+1] = 1;
      }
      //XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement (END)
      ConvertComplexToAbsPhase(sa_h_in[2*i], sa_h_in[2*i+1], &fa_h_refAbs[i-s_RefFirstTone], &fa_h_refPhase[i-s_RefFirstTone], 1);
   }

   //unwrap phase
   UnwrapPhase(fa_h_refPhase, (int16)(s_RefLastTone-s_RefFirstTone+1));

   //call Extrapolation function
   Extrapolate3(fa_h_refAbs, fa_Habsinterp, s_NumRefPoints, s_NumExtraPoints, 0, s_ExtrapOrder);

   //protect the slope of the extrapolation curve from changing sign (meaning the slop should be monotonic)
   for (i = s_NumExtraPoints-2; i >= 0; i--)
   {
      if(cmpgtf32(fa_Habsinterp[i], fa_Habsinterp[i+1]))
         break;
   }

   s_skip = i+1;
   s_NumExtraPoints -= s_skip;
   //XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement (START)
   //s_ExtraFirstTone = EXTRAP_LAST_TONE - s_NumExtraPoints + 1;
   s_ExtraFirstTone = s_ExtraLastTone - s_NumExtraPoints + 1;
   //XDSLRTFW-375 / ADSLRTFW-1346 IOP_ALL_T1413_NVLTC_RateImprovement (END)
   gs_NumExtraPoints = s_NumExtraPoints;

   //the extrapolate points magnitude is always positive.
// for (i = 0; i < s_NumExtraPoints-1; i++)
// {
//    if (cmpgtf32(fa_Habsinterp[i], 0x80000000))
//       break;
// }

// s_skip = i;

   //Then do phase extrapolation
   Extrapolate3(fa_h_refPhase, fa_Hphaseinterp, s_NumRefPoints, s_NumExtraPoints, 0, s_ExtrapOrder);

   //convert extrapolated data from float (abs, phase) to int (real, imag)
   for (i = 0; i < s_NumExtraPoints; i++)
      ConvertAbsPhaseToComplex(fa_Habsinterp[i+s_skip], fa_Hphaseinterp[i], &sa_h_in[2*(i+s_ExtraFirstTone)], 1);

}
