/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   test_FDExtrap.c
*
*-------------------------------------------------------------------------
*/

/*********************************************************************************/
/* Test code to verify Frequency Domain Extrapolation on Channel Estimation
/* Standalone code
/* Takes lab collected DMT channel estimation
/* Runs through the extrapolation and generate the new data
/********************************************************************************/

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "typedef.h"
#include "gdata.h"
#include "ghs.h"
#include "gpersistent.h"

extern void Extrapolate3(Float32* fa_h_ref, Float32* fa_Hinterp, int16 s_NumRefPoints, int16 s_NumExtraPoints, int16 s_ExtrapType, int16 s_ExtrapOrder);
extern void ConvertComplexToAbsPhase(int16 s_Real, int16 s_Imag, Float32* f_Abs, Float32* f_Phase, FlagT ft_doLogAbs);
extern void UnwrapPhase(Float32 *pfa_Array, int16 s_pts);
extern void ConvertAbsPhaseToComplex(Float32 f_Abs, Float32 f_Phase, int16 *psa_h, FlagT ft_doLogAbs);

#define NUM_EXTRAP_TONES  (18)
#define EXTRAP_LAST_TONE  (32)
#define INTERP_ORDER    (3)

main(int16 argc, char* argv[])
{
   FILE* fp_DMT_h_in;
   FILE* fp_DMT_h_out;
   int16 s_RefFirstTone, s_RefLastTone, s_ExtraFirstTone, s_ExtraLastTone, s_ExtrapType, s_ExtrapOrder;
   int16 sa_h_in[512], i, s_tmp;
   Float32 fa_h_refAbs[6], fa_h_refPhase[6];
   Float32 fa_Habsinterp[NUM_EXTRAP_TONES], fa_Hphaseinterp[NUM_EXTRAP_TONES];
   int16 s_NumExtraPoints, s_NumRefPoints;

   //get the lab data of channel estimation
   if (argc <= 2)
   {
      printf("Usage: FDExtrapolation  file.dat  COVendor\n");
      exit(-1);
   }

   fp_DMT_h_in = fopen(argv[1], "r");
   if (!fp_DMT_h_in)
   {
      printf("%s does not exist\n", argv[1]);
      exit(-1);
   }

   fp_DMT_h_out = fopen("extrap_h.dat", "w");
   if(!fp_DMT_h_out)
   {
      printf("%s cannot be created.\n", "extrap_h.dat");
      exit(-1);
   }

   i = 0;
   while(fscanf(fp_DMT_h_in, "%d\n", &s_tmp) != EOF)
   {
      sa_h_in[i] = s_tmp;
      i++;
   }

   //extract the CO vendor id
   gs_CurrentCoChipset = (int16)strtol(argv[2], (char**)NULL, 16);

   //Initialize the reference tones and extrapolated tones
   if (gs_CurrentCoChipset ==  IFTN_CO_CHIPSET)  //#define IFTN_CO_CHIPSET    (0x70)
   {
      s_RefFirstTone = 33;
      s_RefLastTone = 38;
      s_NumRefPoints = 6;

      s_NumExtraPoints = NUM_EXTRAP_TONES;
      s_ExtraLastTone = EXTRAP_LAST_TONE;
      s_ExtraFirstTone = EXTRAP_LAST_TONE - NUM_EXTRAP_TONES + 1;

      s_ExtrapType = 0;   //0: Cubic polynomial extrapolation; 1: linear extrapolation; 2: simple extrapolation
      s_ExtrapOrder = INTERP_ORDER;
   }
   else if (gs_CurrentCoChipset == ALA_CO_CHIPSET) //#define ALA_CO_CHIPSET      (0x20)
   {


   }


   //convert reference data from int (real, imag) to float (abs, phase)
   for (i = s_RefFirstTone; i <= s_RefLastTone; i++)
   {
      ConvertComplexToAbsPhase(sa_h_in[2*i], sa_h_in[2*i+1], &fa_h_refAbs[i-s_RefFirstTone], &fa_h_refPhase[i-s_RefFirstTone], 1);
   }

   //unwrap phase
   UnwrapPhase(fa_h_refPhase, (int16)(s_RefLastTone-s_RefFirstTone+1));

   //call Extrapolation function
   Extrapolate3(fa_h_refAbs, fa_Habsinterp, s_NumRefPoints, s_NumExtraPoints, 0, s_ExtrapOrder);

   //Then do phase extrapolation
   Extrapolate3(fa_h_refPhase, fa_Hphaseinterp, s_NumRefPoints, s_NumExtraPoints, 1, s_ExtrapOrder);

   //convert extrapolated data from float (abs, phase) to int (real, imag)
   for (i = s_ExtraFirstTone; i <= s_ExtraLastTone; i++)
      ConvertAbsPhaseToComplex(fa_Habsinterp[i-s_ExtraFirstTone], fa_Hphaseinterp[i-s_ExtraFirstTone], &sa_h_in[2*i], 1);

   for (i = 0; i < 256; i++)
   {
      fprintf(fp_DMT_h_out, "%d\n", sa_h_in[2*i]);
      fprintf(fp_DMT_h_out, "%d\n", sa_h_in[2*i+1]);
   }

   fclose(fp_DMT_h_in);
   fclose(fp_DMT_h_out);
}
