/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   VerifyRateWithTwoCG.c
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "tone_ord.h"
#include "bitload2.h"
#include "bitload.h"
#include "exchdata.h"
#include "rinfotbl.h"
#include "snr.h"
#include "changebat.h"
#include "bitload_support.h"
#include "bitload_const.h"
#include "pll.h"
#include "dsp_op.h"

/*^^^
*-------------------------------------------------------------------------------------------------
*
*   Prototype:
*     void AddTwoCGToSnr(int16 *psa_CodingGain, int16 *psa_RxToneOrder, int16 *psa_InputSnrBuf, int16 *psa_OutputSnrBuf)
*
*   Abstract:
*       This function adds the coding gain used to the SNRs that psa_InputSnrBuf points to, and
*       stores the result in psa_OutputSnrBuf.  The fast path coding gain is added to the SNRs
*       for tones used by the fast data path, and the interleaved path coding gain is added to
*       the SNRs for tones used for interleaved data path.

*   Input Arguments:
*     psa_CodingGain    -- pointer to an array containg a pair of coding gain
*     psa_RxToneOrder   -- pointer to first non-zero bitloaded tone in gsa_RxToneOrder[] array
*     psa_InputSnrBuf[] -- pointer to input SNR buffer
*
*  Output Arguments:
*     psa_OutputSnrBuf  -- pointer to buffer containing Medley SNR + coding gain
*
*  Return:
*
*  Global Variables:
*     gs_RxFirstChannel -- (I) RX first tone number
*     gs_RxLastChannel  -- (I) RX Last tone number
*--------------------------------------------------------------------------------------------------
^^^*/
C_SCOPE void AddTwoCGToSnr(int16 *psa_CodingGain, int16 *psa_RxToneOrder, int16 *psa_InputSnrBuf, int16 *psa_OutputSnrBuf)
{
   int16 i, s_ch, s_Path;
    int32 l_Acc;

   /* Add coding gain for interleave path to tones used for interleave path */
   for(i=0; i<gus_ncloaded; i++) {
      if (i<=gs_MaxToneForFast)
         s_Path = FAST_DATA_PATH;
      else
         s_Path = INTERLEAVE_DATA_PATH;
      s_ch = psa_RxToneOrder[i];
        l_Acc = psa_InputSnrBuf[s_ch] + psa_CodingGain[s_Path];
      psa_OutputSnrBuf[s_ch] = sature16(l_Acc);
   }
}

/*^^^
*-------------------------------------------------------------------------------------------------
*
*   Prototype:
*     FlagT VerifyRateWithTwoCG(int16 *psa_BytesPerPath, int16 *psa_CodingGain)
*
*   Abstract:
*       This function verifies if the given rate option can be supported.
*  The assumption made here is that the coding gain used for each data
*  path is less than or equal to the coding gain in calculating RxBat[]
*  table.
*
*   Input Arguments:
*     psa_BytesPerPath  -- pointer to the buffer containing the required
*                    number of bytes for each path
*     psa_R       -- pointer to the buffer containing the number of
*                    check bytes used for each path
*
*  Output Arguments:
*
*  Return:
*     TRUE:  This option is valid
*     FALSE: This option is invalid
*
*  Global Variables:
*     gt_RMsgRA.uc_ncloaded -- (I) no. of loaded tones in RxBat[] table
*     gpsa_RxBat[]         -- (I) RX bit allocation table
*     gs_RxToneOrder[]  -- (I) Index of reordered tones
*     gs_RxDesiredMargin   -- (I) Desired RX snr margin
*     gsa_MedleySnrBuf[]   -- (I) SNR computed in Medley
*     gft_TcmFlag       -- (I) TCM enable/disable flag
*
*--------------------------------------------------------------------------------------------------
^^^*/

#define CODING_GAIN_SCALE  (2*3) //where 2 is needed to convert coding gain in Q15.1 format to Q16.0 format
                           //3 is based on the assumption of 3dB per bit

FlagT VerifyRateWithTwoCG(int16 *psa_BytesPerPath, int16 *psa_CodingGain)
{

   int16 i, k;
   int16 s_qc, s_ch, sa_CodingGain[NUM_DATA_PATHS], sa_RequiredBits[NUM_DATA_PATHS];
   int16 s_OhTcm;
   int16 sa_AvailableBits[NUM_DATA_PATHS], sa_CG_Adjust[NUM_DATA_PATHS];
   int16 sa_ToneIdx[NUM_DATA_PATHS], sa_ncloaded[NUM_DATA_PATHS];
   int16 *psa_RxToneOrder;
   int16 s_delta_Lp, s_ActualDeltaSumLp;
   int16 s_Dummy2ReturnValue, s_Initial_TCM_Ovhd, s_InitialSumBi;

   int16 s_path = COMBINED_LP;

   // Store coding gain in Q15.1 format
   sa_CodingGain[0] = psa_CodingGain[0];
   sa_CodingGain[1] = psa_CodingGain[1];

   //Subtract the coding gain by amount equalvalent to TCM overhead
   //Since every two tones cost about 1 bit, so every tone costs
   //about 1.5 dB (3 in Q15.1 format)
   if(gft_TcmFlag == TRUE)
   {
      sa_CodingGain[0] -= 3;
      sa_CodingGain[1] -= 3;
   }
   //Perform tone ordering
   ToneOrdering(guca_RxBat, gs_RxNumTones, (int16)guc_MaxAllocBitsPerTone, gsa_RxToneOrder);

   /* Point to the first non-zero tone */
   psa_RxToneOrder = &gsa_RxToneOrder[gs_FirstNonzeroRxTone];

   /* Select tones for fast path and interleave path respectively */
   for(k=0; k<NUM_DATA_PATHS; k++) {

      /* Compute the total number of requires bits per symbol for this path */
      /* (note instead of dividing coding gain by CODING_GAIN_SCALE, we */
      /* multiply other bits number by it) */
      sa_RequiredBits[k] = psa_BytesPerPath[k]*8*CODING_GAIN_SCALE;

      /* Compute coding gain adjustment for each path, which is equal to */
      /* CGmax - s_CodingGain */
      sa_CG_Adjust[k] = gt_RMsgRA.us_CodingGain - sa_CodingGain[k];

      sa_AvailableBits[k] = 0;
      sa_ToneIdx[k] = -1;
      sa_ncloaded[k] = 0;

      if(k == FAST_DATA_PATH) {

         /* =============================================================================== */
         /* The following loop is to find the minimum number of tones needed for fast */
         /* path, where the sum is computed in ascending tone order, */
         /* =============================================================================== */
         for(i=0; i<gt_RMsgRA.us_ncloaded; i++) {

            /* Get tone index */
            s_ch = psa_RxToneOrder[i];

            /* Compute bits (scaled by CODING_GAIN_SCALE) */
            /* allocated to this tone after coding gain adjustment */
            s_qc = (guca_RxBat[s_ch] * CODING_GAIN_SCALE - sa_CG_Adjust[k]);

            /* Compute the sum of bits up to tone i after applying coding gain adjustment */
            if(s_qc >= (RX_MIN_BITS_PER_TONE*CODING_GAIN_SCALE)) {
               sa_AvailableBits[k] += s_qc;
               sa_ncloaded[k]++;

               if(sa_AvailableBits[k] >= sa_RequiredBits[k]) {
                  sa_ToneIdx[k] = i;
                  break;
               } /* if(sa_AvailableBits[k] >= sa_RequiredBits[k]) { */
            } /* if(s_qc >= (2*CODING_GAIN_SCALE)) */
         } /* for(i=0; i<gt_RMsgRA.us_ncloaded ; i++) { */

      }
      else {

         /* =============================================================================== */
         /* The following loop is to find the minimum number of tones needed for interleave */
         /* path, where the sum is computed in descending tone order, */
         /* =============================================================================== */
         for(i=gt_RMsgRA.us_ncloaded-1; i >= sa_ToneIdx[FAST_DATA_PATH]; i--) {

            /* Get tone index */
            s_ch = psa_RxToneOrder[i];

            /* Compute bits (scaled by CODING_GAIN_SCALE) */
            /* allocated to this tone after coding gain adjustment */
            s_qc = (guca_RxBat[s_ch] * CODING_GAIN_SCALE - sa_CG_Adjust[k]);

            /* Compute the sum of bits up to tone i after applying coding gain adjustment */
            if(s_qc >= (RX_MIN_BITS_PER_TONE*CODING_GAIN_SCALE)) {
               sa_AvailableBits[k] += s_qc;
               sa_ncloaded[k]++;

               if(sa_AvailableBits[k] >= sa_RequiredBits[k]) {
                  sa_ToneIdx[k] = i;
                  break;
               }
            } /* if(s_qc >= (2*CODING_GAIN_SCALE)) */
         } /* for(i=gt_RMsgRA.us_ncloaded-1; i >= sa_ToneIdx[FAST_DATA_PATH]; i--) { */
      }

      /* If there is not enough bits for this path, this option fails */
      if(sa_ToneIdx[k] == -1)
         return(FAIL);

      /* Represent coding gain in Q8.8 format for following computation */
      sa_CodingGain[k] <<= 7;

   } /* for(k=0; k<NUM_DATA_PATHS; k++) { */

   /* ====================================================================================== */
   /* Adjust the tone boundary (the last tone for fast data using reordered tone index) */
   /* with objective to make both region have as close as possible SNR margin */
   /* ====================================================================================== */
   if((sa_ToneIdx[INTERLEAVE_DATA_PATH] - sa_ToneIdx[FAST_DATA_PATH]) <= 1) {
      gs_MaxToneForFast = sa_ToneIdx[FAST_DATA_PATH];
      goto _final_select;
   }

   /* Compute the extra bits (beyond required bits) for each path and store them */
   /* in sa_AvailableBits[]. The goal is to select the maximum tone index for */
   /* fast path, gs_MaxToneForFast, such that extra bits PER TONE for fast path */
   /* are as close as possible to extra bits PER TONE for interleave path */

   sa_AvailableBits[FAST_DATA_PATH] -= sa_RequiredBits[FAST_DATA_PATH];
   sa_AvailableBits[INTERLEAVE_DATA_PATH] -= sa_RequiredBits[INTERLEAVE_DATA_PATH];

   /* Compute the total number of bits between sa_ToneIdx[FAST_DATA_PATH]+1 and sa_ToneIdx[INTERLEAVE_DATA_PATH] */
   /* using interleave path coding gain adjustment */
   for(i=sa_ToneIdx[FAST_DATA_PATH]+1; i<sa_ToneIdx[INTERLEAVE_DATA_PATH]; i++) {
      s_ch = psa_RxToneOrder[i];
      s_qc = guca_RxBat[s_ch] * CODING_GAIN_SCALE - sa_CG_Adjust[INTERLEAVE_DATA_PATH];
      sa_AvailableBits[INTERLEAVE_DATA_PATH] += s_qc;
   }
   sa_ncloaded[INTERLEAVE_DATA_PATH] += (sa_ToneIdx[INTERLEAVE_DATA_PATH]-sa_ToneIdx[FAST_DATA_PATH]-1);

   /* Search for the maximum tone index for fast path  */
   for(gs_MaxToneForFast=sa_ToneIdx[FAST_DATA_PATH]+1; gs_MaxToneForFast<sa_ToneIdx[INTERLEAVE_DATA_PATH]; gs_MaxToneForFast++) {
      s_ch = psa_RxToneOrder[gs_MaxToneForFast];
      s_qc = guca_RxBat[s_ch] * CODING_GAIN_SCALE;

      s_OhTcm =  s_qc - sa_CG_Adjust[FAST_DATA_PATH];
      if(s_OhTcm >= (RX_MIN_BITS_PER_TONE*CODING_GAIN_SCALE)) {
         sa_AvailableBits[FAST_DATA_PATH] += s_qc;
         sa_ncloaded[FAST_DATA_PATH]++;
      }
      sa_ncloaded[INTERLEAVE_DATA_PATH]--;

      sa_AvailableBits[INTERLEAVE_DATA_PATH] -= (s_qc - sa_CG_Adjust[INTERLEAVE_DATA_PATH]);

      /* if((sa_AvailableBits[FAST_DATA_PATH]/number_tones_for_fast)  */
      /* >= (sa_AvailableBits[INTERLEAVE_DATA_PATH]/number_tones_for_inlv)) */
      /* current tone index is selected */
      if((sa_AvailableBits[FAST_DATA_PATH]*sa_ncloaded[INTERLEAVE_DATA_PATH]) >=
         (sa_AvailableBits[INTERLEAVE_DATA_PATH]*sa_ncloaded[FAST_DATA_PATH] )) {
         break;
      }
   } /* for(gs_MaxToneForFast=sa_ToneIdx[FAST_DATA_PATH]+1; gs_MaxToneForFast<sa_ToneIdx[FAST_DATA_PATH]; gs_MaxToneForFast++) */

_final_select:


   /* Compute SNR plus coding gain for fast data tone */
   gpsa_MeasuredSnrBuf = &gsa_RxShowtimeSnrBuf[0];

   /* Add coding gain for each path to tones used for each path respectively */
   AddTwoCGToSnr(sa_CodingGain, psa_RxToneOrder, gsa_MedleySnrBuf, gpsa_MeasuredSnrBuf);

   /* Calculate the maximum number of bits supported by these SNRs */

   gft_BitloadOK = InitBitloading(s_path);
   gs_TotalBitsSupported = CalcMaxBits(gft_FineGainOn, guca_RxBat, gsa_RxFineGains, &gs_RxExtraBits, &gus_ncloaded, &gs_RxAvFineGain, 0x7FFF, s_path);

   /* Compute TCM over head based adjusted number loaded tones */
   if(gft_TcmFlag == TRUE)
      s_OhTcm = (int16)(((gus_ncloaded+1)>>1) + 4);
   else
      s_OhTcm = 0;

   /* Check if the total available bits is greater than the total required bits */
   sa_RequiredBits[0] =  ((psa_BytesPerPath[0]+psa_BytesPerPath[1])*8)+s_OhTcm;

   if(gs_TotalBitsSupported < sa_RequiredBits[0])
      return(FAIL);
   else {


      for (i=0 ; i<gs_RxNumTones ; i++)
      {
         SETTONEFLAG(p_MEDLEYset_DS, i);
      }

      // clear tone flag for Aux Pilot tone
      CLEARTONEFLAG(p_MEDLEYset_DS, gs_PilotToneIdx);

      s_delta_Lp = sa_RequiredBits[0]  - gs_TotalBitsSupported;
      gft_BitloadOK = !ChangeLpKeepMaxMargin(guca_RxBat, gsa_RxFineGains, s_delta_Lp , gsa_RxShowtimeSnrBuf, gs_RxDesiredMargin, p_MEDLEYset_DS, guca_RxBitswapTones, &s_ActualDeltaSumLp, FALSE, 0, 0);

      GetBatStats(guca_RxBat, gs_RxNumTones, gft_TcmFlag, &gus_ncloaded, &s_Dummy2ReturnValue, &s_Initial_TCM_Ovhd, &s_InitialSumBi, s_path);

      if(gft_BitloadOK == SUCCEED) {

         /* Perform tone reordering (in case AllocFixedRates() change the order) */
         ToneOrdering(guca_RxBat, gs_RxNumTones, (int16)guc_MaxAllocBitsPerTone, gsa_RxToneOrder);
         gs_FirstNonzeroRxTone = gs_FirstNonzeroTone;    /* gs_FirstNonzeroTone is set by ToneOrdering() */

         /* Point to the first non-zero tone */
         psa_RxToneOrder = &gsa_RxToneOrder[gs_FirstNonzeroRxTone];

         /* Recompute the maximum tone number used for fast path */
         sa_AvailableBits[FAST_DATA_PATH] = 0;
         sa_RequiredBits[FAST_DATA_PATH] = psa_BytesPerPath[FAST_DATA_PATH]*8;

         if(sa_RequiredBits[FAST_DATA_PATH] == 0)
         {
            gs_MaxToneForFast = -1;
         }
         else
         {
            for(i=0; i<gus_ncloaded; i++)
            {
               s_ch = psa_RxToneOrder[i];
               sa_AvailableBits[FAST_DATA_PATH] += guca_RxBat[s_ch];

               if(sa_AvailableBits[FAST_DATA_PATH] >= sa_RequiredBits[FAST_DATA_PATH])
               {
                  gs_MaxToneForFast = i;
                  break;
               }
            }
         }

         /* Add coding gain for each path to tones used for each path respectively */
         AddTwoCGToSnr(sa_CodingGain, psa_RxToneOrder, gsa_MedleySnrBuf, gpsa_MeasuredSnrBuf);

         // Copy coding gains to global variables.
         gsa_TotalCodingGain[FAST_DATA_PATH] = sa_CodingGain[FAST_DATA_PATH];
         gsa_TotalCodingGain[INTERLEAVE_DATA_PATH] = sa_CodingGain[INTERLEAVE_DATA_PATH];

         //initialize to a large value
         gs_RxMinMargin = 0x7FFF;

         /* Calulate actual fine gain and margin */
         CalcMarginsAndGains(gft_FineGainOn, guca_RxBat, gsa_RxFineGains, &gs_RxAvMargin, &gs_RxAvFineGain, &gs_RxMinMargin);

         // save the average and min margin at the end of initializations
         gs_init_AvMargin = gs_RxAvMargin;
         gs_init_MinMargin = gs_RxMinMargin;

         return(SUCCEED);
      }
      else
         return(FAIL);
   } /* if(gs_TotalBitsSupported < sa_RequiredBits[0]) {..} else */

}

