/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   test_aoc.c
*
*-------------------------------------------------------------------------
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "config.h"
#include "common.h"
#include "aoc_ini.h"
#include "gdata.h"
#include "ghs.h"
#include "hndshk_Data.h"
#include "mp.h"
#include "AllocateDataBuffers_PostHndshk.h"
#include "AllocateDataBuffers_PreHndshk.h"
#include "tone_ord.h"
#include "cmv.h"
#include "bitswap.h"
#include "tx_aoc.h"
#include "rx_aoc.h"
#include "statein1.h"

extern uint8 TX_OH_Handler(int16 s_frame_number);
extern void RX_OH_Handler(int16 s_frame_number, uint8 uc_sb);

#define NUM_SFRAME_TO_TEST    260
#define DESIRED_SNR_MARGIN    (6<<8)         /* 6 dB in Q8.8 format */

/* Global variables */
int16 gs_RxDesiredMargin = DESIRED_SNR_MARGIN;

int16 sa_TxCombinedGains[TX_NUM_TONES] =  /* TX Combined gain */
{0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000};



uint8 sa_TxBat[TX_NUM_TONES] =            /* TX bit allocation table */
{0, 0, 0, 0, 0, 0, 2, 2, 3, 3,            /* 0  - 9 */
 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,            /* 10 - 19 */
 9, 9, 10, 10, 11, 11, 12, 13, 14, 15,    /* 20 - 29 */
 0, 0};                             /* 30 - 31 */


int16 sa_RxCombinedGains[RX_NUM_TONES] = /* RX Combined gain */
{0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000};





uint8 sa_RxBat[RX_NUM_TONES] =         /* RX bit allocation table */
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0,            /* bin 0 - 9 */
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,            /* bin 10 - 19 */
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,            /* bin 20 - 29 */
 0, 0, 0, 2, 2, 2, 2, 2, 2, 2,            /* bin 30 - 39 */
 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,            /* bin 40 - 49 */
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,            /* bin 50 - 59 */
 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,            /* bin 60 - 69 */
 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,            /* bin 70 - 79 */
 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,            /* bin 80 - 89 */
 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,            /* bin 90 - 99 */
 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,            /* bin 100 - 109 */
 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,            /* bin 110 - 119 */
 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,  /* bin 120 - 129 */
 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,  /* bin 130 - 139 */
 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,  /* bin 140 - 149 */
 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,    /* bin 150 - 159 */
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,  /* bin 160 - 169 */
 15, 15, 15, 15, 15, 15, 15, 15, 15, 15      /* bin 170 - 179 */
};                               /* all others are zero */


/* SNR values match to the above bit allocation */
int16 sa_RxShowtimeSnrBuf[RX_NUM_TONES] = /* showtime SNR buffer */
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0,            /* bin 0 - 9 */
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,            /* bin 10 - 19 */
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,            /* bin 20 - 29 */
 0, 0, 0,                           /* bin 30 - 32 */
0x0E51,           /* 14.32 dB =  2 bits   //bin 33 - 49 */
0x0E51,           /* 14.32 dB =  2 bits  */
0x0E51,           /* 14.32 dB =  2 bits */
0x0E51,           /* 14.32 dB =  2 bits */
0x0E51,           /* 14.32 dB =  2 bits */
0x0E51,           /* 14.32 dB =  2 bits  */
0x0E51,           /* 14.32 dB =  2 bits */
0x0E51,           /* 14.32 dB =  2 bits */
0x0E51,           /* 14.32 dB =  2 bits */
0x0E51,           /* 14.32 dB =  2 bits  */
0x0E51,           /* 14.32 dB =  2 bits */
0x0E51,           /* 14.32 dB =  2 bits */
0x0E51,           /* 14.32 dB =  2 bits */
0x0E51,           /* 14.32 dB =  2 bits  */
0x0E51,           /* 14.32 dB =  2 bits */
0x0E51,           /* 14.32 dB =  2 bits */
0x0E51,           /* 14.32 dB =  2 bits */

0x131C,           /* 19.11 dB =  3 bits   //bin 50 - 59 */
0x131C,           /* 19.11 dB =  3 bits */
0x131C,           /* 19.11 dB =  3 bits */
0x131C,           /* 19.11 dB =  3 bits */
0x131C,           /* 19.11 dB =  3 bits */
0x131C,           /* 19.11 dB =  3 bits */
0x131C,           /* 19.11 dB =  3 bits */
0x131C,           /* 19.11 dB =  3 bits */
0x131C,           /* 19.11 dB =  3 bits */
0x131C,           /* 19.11 dB =  3 bits */

0x154F,           /* 21.31 dB =  4 bits   //bin 60 - 69 */
0x154F,           /* 21.31 dB =  4 bits */
0x154F,           /* 21.31 dB =  4 bits */
0x154F,           /* 21.31 dB =  4 bits */
0x154F,           /* 21.31 dB =  4 bits */
0x154F,           /* 21.31 dB =  4 bits */
0x154F,           /* 21.31 dB =  4 bits */
0x154F,           /* 21.31 dB =  4 bits */
0x154F,           /* 21.31 dB =  4 bits */
0x154F,           /* 21.31 dB =  4 bits */

0x1875,           /*  24.46 dB =  5 bits  //bin 70 - 79 */
0x1875,           /*  24.46 dB =  5 bits */
0x1875,           /*  24.46 dB =  5 bits */
0x1875,           /*  24.46 dB =  5 bits */
0x1875,           /*  24.46 dB =  5 bits */
0x1875,           /*  24.46 dB =  5 bits */
0x1875,           /*  24.46 dB =  5 bits */
0x1875,           /*  24.46 dB =  5 bits */
0x1875,           /*  24.46 dB =  5 bits */
0x1875,           /*  24.46 dB =  5 bits */

0x1B8A,           /*  27.54 dB =  6 bits  //bin 80 - 89 */
0x1B8A,           /*  27.54 dB =  6 bits */
0x1B8A,           /*  27.54 dB =  6 bits */
0x1B8A,           /*  27.54 dB =  6 bits */
0x1B8A,           /*  27.54 dB =  6 bits */
0x1B8A,           /*  27.54 dB =  6 bits */
0x1B8A,           /*  27.54 dB =  6 bits */
0x1B8A,           /*  27.54 dB =  6 bits */
0x1B8A,           /*  27.54 dB =  6 bits */
0x1B8A,           /*  27.54 dB =  6 bits */

0x1E97,           /*  30.59 dB =  7 bits  //bin 90 - 99 */
0x1E97,           /*  30.59 dB =  7 bits */
0x1E97,           /*  30.59 dB =  7 bits */
0x1E97,           /*  30.59 dB =  7 bits */
0x1E97,           /*  30.59 dB =  7 bits */
0x1E97,           /*  30.59 dB =  7 bits */
0x1E97,           /*  30.59 dB =  7 bits */
0x1E97,           /*  30.59 dB =  7 bits */
0x1E97,           /*  30.59 dB =  7 bits */
0x1E97,           /*  30.59 dB =  7 bits */

0x219C,           /*  33.61 dB =  8 bits  //bin 100 - 109 */
0x219C,           /*  33.61 dB =  8 bits */
0x219C,           /*  33.61 dB =  8 bits */
0x219C,           /*  33.61 dB =  8 bits */
0x219C,           /*  33.61 dB =  8 bits */
0x219C,           /*  33.61 dB =  8 bits */
0x219C,           /*  33.61 dB =  8 bits */
0x219C,           /*  33.61 dB =  8 bits */
0x219C,           /*  33.61 dB =  8 bits */
0x219C,           /*  33.61 dB =  8 bits */

0x24A1,           /*  36.63 dB =  9 bits  //bin 110 - 119 */
0x24A1,           /*  36.63 dB =  9 bits */
0x24A1,           /*  36.63 dB =  9 bits */
0x24A1,           /*  36.63 dB =  9 bits */
0x24A1,           /*  36.63 dB =  9 bits */
0x24A1,           /*  36.63 dB =  9 bits */
0x24A1,           /*  36.63 dB =  9 bits */
0x24A1,           /*  36.63 dB =  9 bits */
0x24A1,           /*  36.63 dB =  9 bits */
0x24A1,           /*  36.63 dB =  9 bits */

0x27A6,           /*  39.65 dB = 10 bits  //bin 120 - 129 */
0x27A6,           /*  39.65 dB = 10 bits */
0x27A6,           /*  39.65 dB = 10 bits */
0x27A6,           /*  39.65 dB = 10 bits */
0x27A6,           /*  39.65 dB = 10 bits */
0x27A6,           /*  39.65 dB = 10 bits */
0x27A6,           /*  39.65 dB = 10 bits */
0x27A6,           /*  39.65 dB = 10 bits */
0x27A6,           /*  39.65 dB = 10 bits */
0x27A6,           /*  39.65 dB = 10 bits */

0x2AA8,           /*  42.66 dB = 11 bits  //bin 130 - 139 */
0x2AA8,           /*  42.66 dB = 11 bits */
0x2AA8,           /*  42.66 dB = 11 bits */
0x2AA8,           /*  42.66 dB = 11 bits */
0x2AA8,           /*  42.66 dB = 11 bits */
0x2AA8,           /*  42.66 dB = 11 bits */
0x2AA8,           /*  42.66 dB = 11 bits */
0x2AA8,           /*  42.66 dB = 11 bits */
0x2AA8,           /*  42.66 dB = 11 bits */
0x2AA8,           /*  42.66 dB = 11 bits */

0x2DAB,           /*  45.67 dB = 12 bits  //bin 140 - 149 */
0x2DAB,           /*  45.67 dB = 12 bits */
0x2DAB,           /*  45.67 dB = 12 bits */
0x2DAB,           /*  45.67 dB = 12 bits */
0x2DAB,           /*  45.67 dB = 12 bits */
0x2DAB,           /*  45.67 dB = 12 bits */
0x2DAB,           /*  45.67 dB = 12 bits */
0x2DAB,           /*  45.67 dB = 12 bits */
0x2DAB,           /*  45.67 dB = 12 bits */
0x2DAB,           /*  45.67 dB = 12 bits */

0x30AE,           /*  48.68 dB = 13 bits  //bin 150 - 159 */
0x30AE,           /*  48.68 dB = 13 bits */
0x30AE,           /*  48.68 dB = 13 bits */
0x30AE,           /*  48.68 dB = 13 bits */
0x30AE,           /*  48.68 dB = 13 bits */
0x30AE,           /*  48.68 dB = 13 bits */
0x30AE,           /*  48.68 dB = 13 bits */
0x30AE,           /*  48.68 dB = 13 bits */
0x30AE,           /*  48.68 dB = 13 bits */
0x30AE,           /*  48.68 dB = 13 bits */

0x33B0,           /*  51.69 dB = 14 bits  //bin 160 - 169 */
0x33B0,           /*  51.69 dB = 14 bits */
0x33B0,           /*  51.69 dB = 14 bits */
0x33B0,           /*  51.69 dB = 14 bits */
0x33B0,           /*  51.69 dB = 14 bits */
0x33B0,           /*  51.69 dB = 14 bits */
0x33B0,           /*  51.69 dB = 14 bits */
0x33B0,           /*  51.69 dB = 14 bits */
0x33B0,           /*  51.69 dB = 14 bits */
0x33B0,           /*  51.69 dB = 14 bits */

0x36B3,           /*  54.70 dB = 15 bits  //bin 170 - 179   */
0x36B3,           /*  54.70 dB = 15 bits */
0x36B3,           /*  54.70 dB = 15 bits */
0x36B3,           /*  54.70 dB = 15 bits */
0x36B3,           /*  54.70 dB = 15 bits */
0x36B3,           /*  54.70 dB = 15 bits */
0x36B3,           /*  54.70 dB = 15 bits */
0x36B3,           /*  54.70 dB = 15 bits */
0x36B3,           /*  54.70 dB = 15 bits */
0x36B3            /*  54.70 dB = 15 bits */
};

#define NUM_BSR_TEST    4     /* no. of tests for sending BSR */

int16 gsa_SnrModifier[NUM_BSR_TEST][RX_NUM_TONES] = {
//Test 1: no SNR change
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},

//Test 2: 1 bit should be cut from bin #71 and #72, and 1 bit should be added to bin #79 and #80, rcv BSA
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, -(5<<8), -(4<<8), -(3<<8), -(2<<8), 0, (1<<8), (2<<8), (3<<8), (4<<8), (5<<8),
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},

//Test 3: 1 bit should be cut from bin #74, and 1 bit should be added to bin #78, rcv BSA
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, -(1<<8), -(1<<8), -(2<<8), -(6<<8), 0, (1<<8), (2<<8), (6<<8), (4<<8), (5<<8),
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},

//Test 4: send BSR, 1 bit should be cut from bin #73 , 1 bit should be added to bitn #77, rcv UTC
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, -(1<<8), -(1<<8), -(4<<8), -(1<<8), 0, (1<<8), (5<<8), (5<<8), (4<<8), (5<<8),
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
};

FILE *fp_aoc_trail, *fp_rx_in;
int16 gs_superframe_cnt;
int16 gs_frame_cnt;

/*-------------------------------------------------------------------
*
*  int Pause(void)
*
*  Description: For debugging purposes.  Stops the DSL cores (necessary) and allows
*  external debug reads and writes to be performed, dummy here
*
*-------------------------------------------------------------------
*^^^
*/
void Pause(int16 s_Marker)
{
}

void main(int argc, char *argv[])
{


   int16 i;
   int16 s_num_test;
   int16 sa_SnrBuf[RX_NUM_TONES];
   AocMsgStruc_t *pt_TxMsg;
   uint8 uc_byte, uc_msg_len = 0;
   unsigned long ul_stuffing_byte_cnt;

   AllocateDataBuffers_PreHndshk();

   InitGlobalVariables();

   /* If the second argument is provided, open RX input file */
   /* Otherwise, only test TX output */
   if(argc == 2) {

      /* Open RX input file */
      if((fp_rx_in  = fopen(SetInputDir(argv[1]), "r")) == NULL) {
         fprintf(stderr, "Cannot open input file %s\n", SetInputDir(argv[1]));
         exit(-1);
      }
   }

   /* Open output file */
   fp_aoc_trail = fopen("trail.txt", "w");

   /* ======================= */
    /* Initialization */
   /* ======================= */
   gs_RxNumTones = RX_NUM_TONES; //gs_RxNumTones must be defined to initialize data buffers.
   AllocateDataBuffers_PostHndshk();

   // Initialize Data

   for (i=0 ; i<RX_NUM_TONES ; i++){
      gsa_RxCombinedGains[i] = sa_RxCombinedGains[i];
      gsa_RxFineGains[i] = sa_RxCombinedGains[i];
      guca_RxBat[i] = sa_RxBat[i];
      gsa_RxShowtimeSnrBuf[i] = sa_RxShowtimeSnrBuf[i];
   }
   gt_rx_config.psa_BAT       = guca_RxBat;         /* set BAT table pointer */
   gt_rx_config.psa_FineGains = gsa_RxFineGains;   /* set fine gain pointer */
   gt_RxShowTimeVars.pt_Config = &gt_rx_config;

   ToneOrdering(gt_rx_config.psa_BAT, gs_RxNumTones, 15, gsa_RxToneOrder);
   gs_FirstNonzeroRxTone = gs_FirstNonzeroTone;    /* gs_FirstNonzeroTone is set by ToneOrdering() */


   for (i=0 ; i<gs_TxNumTones ; i++){
      gsa_TxCombinedGains[i] = sa_TxCombinedGains[i];
      gsa_TxFineGains[i] = sa_TxCombinedGains[i];
      guca_TxBat[i] = sa_TxBat[i];
   }
   gt_tx_config.psa_BAT       = guca_TxBat;         /* set BAT table pointer */
   gt_tx_config.psa_FineGains = gsa_TxFineGains;   /* set fine gain pointer */

   /* Determine if g992_1 or g992_2 */
// InitializeInfoField( gpt_TxInfo );

    /* Init. super frame count */
   gs_bitswap_tx_sframe_count = -1;
   gs_bitswap_rx_sframe_count = -1;
   gl_rx_sframe_count = -1;

   //=================================================================
   // Initialize some variables that would normally get set during
   // the bitloading process.
   //=================================================================
   //===========================================
   //  gus_ncloaded, gsa_RxBat, gsa_RxFineGains
   //===========================================

   gus_ncloaded = 0;

   for (i=0 ; i< gs_RxNumTones ; i++){
      gsa_RxFineGains[i] = gt_rx_config.psa_FineGains[i];
      guca_RxBat[i] = gt_rx_config.psa_BAT[i];
      if (guca_RxBat[i] != 0)
         gus_ncloaded++;
   }



   /* Init. AOC transmitter */
   TxAocInit();

   /* Init. AOC receiver */
   RxAocInit();

   pt_TxMsg = &gt_TxAocMsgBSR;
   pt_TxMsg->uc_msg_flag = IDLE;

   ul_stuffing_byte_cnt = 0;
    s_num_test = 0;


   /* =========================================================================== */
   /* Start super frame loop */
   /* =========================================================================== */
   for(gs_superframe_cnt = 0; gs_superframe_cnt < NUM_SFRAME_TO_TEST; gs_superframe_cnt++) {

      if(s_num_test < NUM_BSR_TEST) {

         if(gft_SendAocMsg_Flag == IDLE) {

            /* Modify SNRs to test the bit swap algorithm */
            for(i=gs_RxFirstChannel; i<=gs_RxLastChannel; i++)
               sa_SnrBuf[i] = gsa_RxShowtimeSnrBuf[i] + gsa_SnrModifier[s_num_test][i]
                        + gs_RxDesiredMargin;
            s_num_test++;

            if(RxBitSwapDecision(sa_SnrBuf) == TRUE)
               fprintf(fp_aoc_trail, "\n========= TX initiates BIT SWAP =========\n\n");
            else
               fprintf(fp_aoc_trail, "\n========= TX don't initiate BIT SWAP =========\n\n");
         }
      }

      /* Check to see if TX bit swap need to be tone */
      if(gft_TxBitSwapFlag == TRUE) {
         CheckForTxBitSwap();

         if(gft_TxBitSwapFlag == FALSE) {
            fprintf(fp_aoc_trail, "\n*** TX BIT SWAP take places at super frame #%d ***\n\n", gs_bitswap_tx_sframe_count);

            fprintf(fp_aoc_trail, "TxBAT[] after bit swap:\n");
            for(i=gs_TxFirstChannel; i<=gs_TxLastChannel; i++)
               fprintf(fp_aoc_trail, "gsa_TxBat[%d] = %d\n", i, guca_TxBat[i]);

            fprintf(fp_aoc_trail, "\nTxFineGains[] after bit swap:\n");
            for(i=gs_TxFirstChannel; i<=gs_TxLastChannel; i++)
               fprintf(fp_aoc_trail, "gsa_TxFineGains[%d] = %d\n", i, gsa_TxFineGains[i]);
         }
      }

      /* Check to see if RX bit swap need to be done */
      if(gft_RxBitSwapFlag == TRUE) {
         CheckForRxBitSwap();

         if(gft_RxBitSwapFlag == FALSE) {
            fprintf(fp_aoc_trail, "\n*** RX BIT SWAP take places at super frame #%d ***\n\n", gs_bitswap_tx_sframe_count);

            fprintf(fp_aoc_trail, "RxBAT[] after bit swap:\n");
            for(i=gs_RxFirstChannel; i<=gs_RxLastChannel; i++)
               fprintf(fp_aoc_trail, "gsa_RxBat[%d] = %d\n", i, guca_RxBat[i]);

            fprintf(fp_aoc_trail, "\nRxFineGains[] after bit swap:\n");
            for(i=gs_RxFirstChannel; i<=gs_RxLastChannel; i++)
               fprintf(fp_aoc_trail, "gsa_RxFineGains[%d] = %d\n", i, gsa_RxFineGains[i]);
         }
      }

      /* =========================================================================== */
      /* Start frame loop */
      /* =========================================================================== */
      for(gs_frame_cnt = 0; gs_frame_cnt < TX_SYMBOLS_PER_SFRAME; gs_frame_cnt++) {

         if(gft_SendAocMsg_Flag == OUTSTANDING) {
            if(TxAocMsgPut(pt_TxMsg) == SUCCEED) {
               gft_SendAocMsg_Flag = SUCCEED;
               fprintf(fp_aoc_trail, "Send message (ID = %d)\n\n", pt_TxMsg->uc_msg_id);
            }
         }

         /* Check the TX message status */
         if( (pt_TxMsg->uc_msg_flag != OUTSTANDING) && (pt_TxMsg->uc_msg_flag != IDLE)) {

            if(ul_stuffing_byte_cnt > 0)
               fprintf(fp_aoc_trail, "no. stuffing bytes sent = %d\n", ul_stuffing_byte_cnt);
            ul_stuffing_byte_cnt = 0;

            if(pt_TxMsg->uc_msg_flag == SUCCEED) {
               fprintf(fp_aoc_trail, "\nTX Message (ID = %d) is acknowledged\n\n", pt_TxMsg->uc_msg_id);
               pt_TxMsg->uc_msg_flag = IDLE;
            }
            else if(pt_TxMsg->uc_msg_flag == FAIL) {
               fprintf(fp_aoc_trail, "\nTX Message (ID = %d) fails due to reason %d\n\n",
               pt_TxMsg->uc_msg_id, pt_TxMsg->uc_reason_of_fail);
               pt_TxMsg->uc_msg_flag = IDLE;
            }

         }  /* if( (pt_TxMsg->uc_msg_flag != OUTSTANDING) && */

         /* Get an overhead byte for this frame */
         uc_byte = TX_OH_Handler(gs_frame_cnt);

         if(gs_frame_cnt > 0) {
            if((uc_byte == 0) && (uc_msg_len == 0) )
               ul_stuffing_byte_cnt++;
            else {
               if(ul_stuffing_byte_cnt > 0) {
                  fprintf(fp_aoc_trail, "no. of stuffing bytes sent = %d\n", ul_stuffing_byte_cnt);
                  ul_stuffing_byte_cnt = 0;
               }
               fprintf(fp_aoc_trail, "0x%x\n", uc_byte);

               if(uc_msg_len == 0) {
                  if(gpt_TxAocHandler->uc_nonoutstanding_msg_count == 1)
                     uc_msg_len = gpt_TxAocHandler->pt_nonoutstanding_msg->uc_msg_length;
                  else
                     uc_msg_len = gpt_TxAocHandler->pt_outstanding_msg->uc_msg_length;
               }
               uc_msg_len--;

            }
         }  /* if(s_frame_cnt > 0) */

         /* Read in input synch byte */
         if(argc == 2) {
            if(fscanf(fp_rx_in, "%x", &uc_byte) == EOF) {
               uc_byte = 0;
            }

            /* Process an overhead byte received this frame */
            RX_OH_Handler(gs_frame_cnt, uc_byte);

            if(guc_aoc_msg_id != AOC_MSG_ID_UNDEFINED)
               fprintf(fp_aoc_trail, "\nReceive message (ID = %d)\n\n", guc_aoc_msg_id);
         }

      } /* for(s_frame_cnt */

   } /* for(s_sframe_cnt */


   fprintf(fp_aoc_trail, "no. of TX stuffing bytes = %d\n", ul_stuffing_byte_cnt);
   fflush(fp_aoc_trail);
   fclose(fp_aoc_trail);

   exit(0);

}

uint8 TX_OH_Handler(int16 s_frame_number)
{

   uint8 uc_byte;


   /* Decide the content of the synch byte based on the frame number */
   if(s_frame_number == 0) {

      /* Update super frame count */
      gs_bitswap_tx_sframe_count++;
      gl_tx_sframe_count++;
      if(gs_bitswap_tx_sframe_count == MAX_SFRAME_COUNT)
         gs_bitswap_tx_sframe_count = 0;

      /* place 0 for CRC byte */
      uc_byte = 0;

      fprintf(fp_aoc_trail, "Superframe Count = %d\n", gs_bitswap_tx_sframe_count);

   }
   else {
      /* return AOC byte */
      uc_byte = TxAocHandler(s_frame_number);
   }

   return(uc_byte);
}

void RX_OH_Handler(int16 s_frame_number, uint8 uc_sb)
{

   uint8 uc_byte;

   uc_byte = uc_sb;


   /* Decide the content of the synch byte based on the frame number */
   if(s_frame_number == 0) {

      /* Update super frame count */
      gl_rx_sframe_count++;

      gs_bitswap_rx_sframe_count++;

      if(gs_bitswap_rx_sframe_count == MAX_SFRAME_COUNT)
         gs_bitswap_rx_sframe_count = 0;

   }
   else {
      /* Call RxAocHandler and RxAocProcessor() to process AOC message */
      RxAocHandler(uc_byte);
      guc_aoc_msg_id = RxAocProcessor();
   }
}

