/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  test_eoc.c
;
;  The following main program is to test TX and RX EOC code
;  To compile this program, the following files should be added to the project:
;  test_eoc.c tx_eoc.c rx_eoc.c tx_sb.c rx_sb.c
;  and include sandbox\include directory into VC++ include path.
;
;***************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "common.h"
#include "config.h"
#include "eoc.h"
#include "tx_eoc.h"
#include "rx_eoc.h"
#include "tx_m3oh.h"
#include "rx_m3oh.h"
#include "fifo.h"
#include "nmp.h"
#include "cmv.h"

/* =============================================== */
/* global variable declarations (some may be moved to static or external) */
/* =============================================== */
/* TXProfileStruc_t gta_TXProfile[NUM_PROFILES]; */
/* RXProfileStruc_t gta_RXProfile[NUM_PROFILES]; */
/* int16 gsa_rx_profile_ord[NUM_PROFILES]; */

float gf_Pga;
NewMPStruct NewMPTxBuffer, NewMPRxBuffer;

int16 ReadNewMPtoModem(int16 x){
return 0;
}
void WriteModemtoNewMP(int16 x1, int16 x2)
{}
void WriteNewMPtoModem(int16 x1, int16 x2)
{}

void Rx_Mode3OH_Handler1(int16 s_frame_number, uint8 uc_sb);
void RxEocHandler1(int16 s_frame_number, uint8 uc_sb);
void GetRxEocMessage_AddToFifo1();

extern void RxEocProcessor(void);

char * SetInputDir(char * input_string);

#define MAX_SFRAME_COUNT      (256)
Config_t gt_tx_config;
Config_t gt_rx_config;

#ifdef ISDN
int16 gs_TxNumTones = (int16) TX_NUM_TONES;
#else
int16 gs_TxNumTones = 32;
#endif

int16 gs_RxNumTones = RX_NUM_TONES;
int16 gs_TxNextState, gs_RxNextState;
TxEocNetworkStruct_t    gt_TxEocNetworkHandler; /* structure of the TX EOC Network  variables */
int16 gs_bitswap_tx_sframe_count;

extern uint16 gus_RxEocRegister;
extern FlagT gft_tx_msg_pending;
extern MessageFifo_t gt_RxEocFifo;

/* =============================================== */
/* constants used by this file only */
/* =============================================== */
#define NUM_SFRAME_TO_TEST 986

/* =============================================== */
/* static variable declarations */
/* =============================================== */
FILE *fp_eoc_trail, *fp_rx_in, *fp_tx_out;


/*-------------------------------------------------------------------
*
*  int Pause(void)
*
*  Description: For debugging purposes.  Stops the DSL cores (necessary) and allows
*  external debug reads and writes to be performed, dummy here
*
*-------------------------------------------------------------------
*^^^
*/
void Pause(int16 s_Marker)
{
}

void main(int argc, char *argv[])
{
    int16 i, s_frame_cnt, s_sframe_cnt;
    uint8 uc_byte;

    if(argc == 2) {

        /* Open RX input file */
        fp_rx_in  = fopen(argv[1], "r");
   if((fp_rx_in  = fopen(SetInputDir(argv[1]), "r")) == NULL) {
      fprintf(stderr, "Cannot open input file %s\n", SetInputDir(argv[1]));
      exit(-1);
        };

    }

    /* Open output file    */
    fp_eoc_trail = fopen("trail.txt", "w");
    fprintf(fp_eoc_trail, "Super Frame \t Data Frame \t Tx \t\t Rx\n");

    fp_tx_out = fopen("tx_out.txt", "w");

    gt_TxEocNetworkHandler.uc_EocAction = 0;        /*  No action */

    /* Initialization */

   /* Do RX EOC initialization */
   RxEocInit();

   /* Init. EOC transmitter */
   gs_bitswap_tx_sframe_count = -1;
   TxEocInit();


    /* TxSyncByteHandlerInit(); */
    /* RxSyncByteHandlerInit(); */

    for (i=0; i<EOC_VENDOR_ID_LEN; i++)
        gt_EocRxReadBuf.us_vendor_id[i] = 0x30;

    for (i=0; i<EOC_REVISION_NUM_LEN; i++)
        gt_EocRxReadBuf.us_revision_num[i] = 0x20;

    for (i=0; i<EOC_SERIAL_NUM_LEN; i++)
        gt_EocRxReadBuf.us_serial_num[i] = 0x35;

    for (i=0; i<EOC_LINE_ATTENUATION_LEN; i++)
        gt_EocRxReadBuf.uc_line_attenuation[i] = 0x05;

    for (i=0; i<EOC_SNR_MARGIN_LEN; i++)
        gt_EocRxReadBuf.c_snr_margin[i] = 0x08;

    for (i=0; i<EOC_ATU_R_CONFIGURATION_LEN; i++)
        gt_EocRxReadBuf.uc_atu_r_configuration[i] = 0x00;

    for(s_sframe_cnt = 0; s_sframe_cnt < NUM_SFRAME_TO_TEST; s_sframe_cnt++) {
        for(s_frame_cnt = 0; s_frame_cnt < TX_SYMBOLS_PER_SFRAME; s_frame_cnt++) {


            /*  form DGASP opcode message */
            if ((s_sframe_cnt == 64) && (s_frame_cnt == 10))
                CNTLArray[CNTL_ModemDying] = CNTL_ModemSendDyingGasp;

            /* Get a synch byte for this frame */
            uc_byte = Tx_Mode3OH_Handler(s_frame_cnt);

            if(((s_frame_cnt & 0x3) >= 2) && (s_frame_cnt != 34) && (s_frame_cnt != 35))  {

                /* fprintf(fp_eoc_trail, "Tx:\t %d\t%d\t 0x%02x\n", s_sframe_cnt, s_frame_cnt, uc_byte); */
                fprintf(fp_eoc_trail, "%d\t\t\t\t\t\t%d\t\t\t\t 0x%02x\t\t", s_sframe_cnt, s_frame_cnt, uc_byte);
                fprintf(fp_tx_out, "0x%02x\n", uc_byte);

                /* Read in input synch byte */
                fscanf(fp_rx_in, "%x", &uc_byte);

                /* Process a synch byte received this frame */
                Rx_Mode3OH_Handler1(s_frame_cnt, uc_byte);
                /* fprintf(fp_eoc_trail, "Rx:\t %d\t%d\t 0x%02x\n", s_sframe_cnt, s_frame_cnt, uc_byte); */
                fprintf(fp_eoc_trail, "0x%02x\n", uc_byte);

            }
            else
                Rx_Mode3OH_Handler1(s_frame_cnt, 0);

        } /* for(s_frame_cnt */

    } /* for(s_sframe_cnt */

    exit(0);
}

/* undefine constant used by this file only */
#undef NUM_SFRAME_TO_TEST

/*****************************************************************************
;  Subroutine Name: Rx_Mode3OH_Handler1
;
;  Description:
;     This subroutine calls different handlers to process the received synch byte
;     (containing SI, AOC or EOC message) based on input frame number.
;     It also updates the RX super frame count.
;
;  Prototype:
;     void Rx_Mode3OH_Handler1(int16 s_frame_number, uint8 uc_sb);
;
;  Input Arguments:
;     s_frame_number -- current RX frame number
;     uc_sb       -- received synch byte for this frame
;
;  Output Arguments:
;     none
;
;  Return:
;     none
;
;  Global Variables:
;     gl_rx_sframe_count -- (I/O) super frame count
;     guc_aoc_msg_id    -- (O) a valid AOC message ID or AOC_MSG_ID_UNDEFINED
;                    (this parameter is used for test purpose)
;
*******************************************************************************/
void Rx_Mode3OH_Handler1(int16 s_frame_number, uint8 uc_sb)
{
   int16 i;
   uint8 uc_byte;

   uc_byte = uc_sb;

   /* Decide the content of the overhead byte based on the frame number */
   if(s_frame_number == 0)
    {
        /*  CRC frame - CRC processed in RShowtimeRxF_DMT() */
        return;
   }
   /* Process IB byte */
   else if((s_frame_number == 1) || (s_frame_number == 34) || (s_frame_number == 35)) {

      /* Call IB handler */
      /* RxIbHandler(uc_byte, s_frame_number); */

   }
   /* Process either EOC byte or AOC byte */
   else {

      i = s_frame_number&0x3;
      if(i<2) {

         /* Call RxAocHandler to process AOC message */
         /* guc_aoc_msg_id = RxAocHandler(uc_byte); */
      }
      else {

         /* Call RxEocHandler to process EOC message */
         RxEocHandler1(s_frame_number, uc_byte);
      }
   }
}

/*****************************************************************************
;  Prototype: char * SetInputDir(char * input_string)
;
;     If this function finds an INPUTDIR environment variable,
;     it will return a combination of the INPUTDIR and the
;     input_string.  Otherwise, this function will return an
;     unchanged input_string.
;
;  Input Arguments:
;
;     char * input_string - usually an input filename
;
;  Output Arguments:
;
;     char * - always expected to be a valid char *
;
;  Return:
;
;     Will return either the original character pointer, or a
;     newly formed one.  This function is never expected to
;     return NULL.
;
;  Global Variables:
;
;  Environment Variables:
;
;     INPUTDIR - as input
;
;****************************************************************************/
char * SetInputDir(char * input_string)
{

    char * input_dir;
    char * file_path;
    unsigned int len_input_dir = 0;

    /* Get the INPUTDIR environment variable */
    input_dir = getenv ("INPUTDIR");

    if( input_dir != NULL ) {
        /* Strip any spaces off the end of input_dir */
        len_input_dir = strlen(input_dir);
      while ((len_input_dir > 0) &&
         (input_dir[len_input_dir-1] == ' ')) {
             input_dir[(len_input_dir--)-1] = '\0';
      };

        if (len_input_dir > 0) {
            /* Allocate enough space for both strings, a slash, and a null char */
            file_path = (char *) malloc (len_input_dir + strlen (input_string) + 2);
            strcpy(file_path, input_dir);
            /* Add a slash between, if needed */
            if ((input_dir[len_input_dir-1] != '\\') &&
                (input_dir[len_input_dir-1] != '/'))
                strcat(file_path, "\\");
            strcat(file_path, input_string);
            return(file_path);
        };
    };

    /* Return input_string if there is no input directory */
    /* environment variable or if it is empty.            */
    return (input_string);
};

/*****************************************************************************
*   Subroutine Name: RxEocHandler1
*
*   Description:
*     This subroutine takes the current EOC input byte and, if valid,
*  uses it to build the 16-bit us_rx_eoc_msg (part of the global
*  gt_RxEocHandler structure.
*
*     This function is part of the SW Engine layer.
*
*
*   Prototype:
*       void RxEocHandler1(int16 s_frame_number, uint8 uc_sb);
*
*   Input Arguments:
*       s_frame_number  - Data frame number
*       uc_sb           - current EOC input byte
*
*   Output Arguments: none
*
*   Return: none
*
*   Global Variables:
*   gt_RxEocHandler -- the RX EOC handler structure, the following variables are modified:
*       us_rx_eoc_msg_count - Received eoc message count
*       us_RxEocState       - current state of Rx Eoc state machine
*       us_rx_eoc_msg       - current received eoc message
*       us_pre_eoc_msg      - previous received eoc message
*       *puc_rx_eoc_buf     - pointer to the members of ReadEocBuf
*       us_msg_len          - length of the ATU-R data registers
*
*
*******************************************************************************/

void RxEocHandler1(int16 s_frame_number, uint8 uc_sb)
{
    uint8 uc_byte;


    uc_byte = uc_sb;
    if ((uc_byte & EOC_MESSAGE) == 1) { /*  if eoc message */

        gft_no_sync_flag = FALSE;

        /*  collect two eoc bytes and form a 16bit message */
        if ((s_frame_number & 0x01) == 0) { /*  even numbered frame, first byte */

            gus_RxEocRegister = uc_sb;   /*  write the 1st byte in the lower byte position */
            return;

        }
        else if ((s_frame_number & 0x01) == 1) { /*  odd numbered frame, second byte */

            /*  form a 16bit word */
            gus_RxEocRegister |= (uc_sb << 8);   /*  move the 2nd byte to the upper byte  */
                                            /*  position to form a 16bit message */
        }


   } /*  if ((uc_byte & EOC_MESSAGE) == 1) */

    /* this call is moved to time critical task in showtime.c */
   GetRxEocMessage_AddToFifo1();

}

/*****************************************************************************
*   Subroutine Name: GetRxEocMessage_AddToFifo1
*
*   Description:
*
*     This function checks the Engine EOC data.  If valid,
*  this EOC word is placed into the EOC Fifo and the the EOC data is cleared
*  to prevent this message from being processed again.
*
*     This function is designed as a Time Critical API function.
*
*   Prototype:
*       void GetRxEocMessage_AddToFifo1(void)
*
*   Input Arguments: none
*
*   Output Arguments: none
*
*   Return: none
*
*   Global Variables:
*
*     gus_RxEocRegister    - 16 bit EOC word
*
*******************************************************************************/


void GetRxEocMessage_AddToFifo1()
{

    GetEocMessage(&gus_RxEocRegister);

   /* =======================================================================================   */
   /* if the eoc data is not valid, i.e. if the lsb of both bytes are not set             */
   /* then return                                                          */
   /* =======================================================================================   */
   if ((gus_RxEocRegister & 0x0101) != 0x0101)
   {
      return;
   }

   /* =======================================================================================   */
   /* otherwise, put the new valid message onto the EOC fifo and clear RxEocRegister         */
   /* to prevent this message from being processed a second time.                      */
   /* For now, call RxEocProcessor immediately.  Later, move this call to Showtime NTC task  */
   /*                                                                   */
   /* =======================================================================================   */

   AddMessageToFifo(&gt_RxEocFifo, gus_RxEocRegister);
   gus_RxEocRegister = 0;

    RxEocProcessor();

}
