/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: test_ib.c
;
;   The following main program is to test the TX and RX Indicator Bits code.
;   To compile this program, the following files should be added to the project:
;   test_ib.c, tx_ib.c, and rx_ib.c.
;
;***************************************************************************/

#include <stdlib.h>
#include <stdio.h>

#include "typedef.h"
#include "config.h"
#include "gdata.h"
#include "xgdata.h"
#include "ib.h"
#include "tx_ib.h"
#include "rx_ib.h"
#include "synsymbl.h"
#include "ghs.h"
#include "hndshk_Data.h"
#include "statein1.h"
#include "AllocateDataBuffers_PreHndshk.h"

extern void RxIbHandler(uint8 uc_byte, int16 s_frame_number); // implemented in SWE rx_oh.c

int16 gs_RxAvMargin;          /* average SNR margin in Q8.8 */
int16 gsa_ConstellationSNR[16];     /* SNR required for supporting each constellation size */

/* =============================================== */
/* constants used by this file only */
/* =============================================== */
#define TEST_SUPERFRAMES 30

/* =============================================== */
/* global variable declarations */
/* =============================================== */
uint8 uc_RXsf34[TEST_SUPERFRAMES] =
{ 0x3C, 0x39, 0xD6, 0xF9, 0xF6, 0x79, 0x7C, 0x73, 0x76, 0x7B,
  0xAF, 0xAF, 0xAF, 0x9F, 0xBF, 0xFF, 0xEF, 0xEF, 0xEF, 0xEF,
  0xFF, 0xFF, 0xFF, 0xEF, 0xEF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF };

uint8 uc_RXsf35[TEST_SUPERFRAMES] =
{ 0x8F, 0x9F, 0xAF, 0xBF, 0xCF, 0xDD, 0xED, 0xFD, 0x0F, 0x1F,
  0x2F, 0x3F, 0x4F, 0x5F, 0x6F, 0x7F, 0x8F, 0x9F, 0xAF, 0xBF,
  0xCE, 0xDE, 0xEE, 0xFF, 0x0F, 0x1F, 0x2F, 0x3F, 0x4F, 0x5F };

FILE *fid, *fout;


/*-------------------------------------------------------------------
*
*  int Pause(void)
*
*  Description: For debugging purposes.  Stops the DSL cores (necessary) and allows
*  external debug reads and writes to be performed, dummy here
*
*-------------------------------------------------------------------
*^^^
*/
void Pause(int16 s_Marker)
{
}

void TestResultHandler(uint8 *puc_txbyte, int16 i)
{

    /* tx output */
    fprintf(fout, "Superframe #%d\n",i);
    fprintf(fout,"0x%02X\n",puc_txbyte[0]);
    fprintf(fout,"0x%02X\n",puc_txbyte[1]);
    fprintf(fout,"0x%02X\n\n",puc_txbyte[2]);

    /* rx results */
    fprintf(fid, "\n\nSuperframe #%d\n\n",i);
    if (gt_RxIbData.uc_febe_i) fprintf(fid,"RX FEBE-I INDICATION\n");
    if (gt_RxIbData.uc_ffec_i) fprintf(fid,"RX FFEC-I INDICATION\n");
    if (gt_RxIbData.uc_febe_f) fprintf(fid,"RX FEBE-F INDICATION\n");
    if (gt_RxIbData.uc_ffec_f) fprintf(fid,"RX FFEC-F INDICATION\n");
    if (gt_RxIbData.uc_flos)   fprintf(fid,"RX FLOS INDICATION\n");
    if (gt_RxIbData.uc_frdi)   fprintf(fid,"RX FRDI INDICATION\n");
    if (gt_RxIbData.uc_fncd_i) fprintf(fid,"RX FNCD-I INDICATION\n");
    if (gt_RxIbData.uc_fncd_f) fprintf(fid,"RX FNCD-F INDICATION\n");
    if (gt_RxIbData.uc_fhec_i) fprintf(fid,"RX FHEC-I INDICATION\n");
    if (gt_RxIbData.uc_fhec_f) fprintf(fid,"RX FHEC-F INDICATION\n");

    if (gt_RxIbData.uc_fncd_i_anom == PRESENT) fprintf(fid,"RX No Cell Delineation Interleaved ANOMALY\n");
    if (gt_RxIbData.uc_focd_i_anom == PRESENT) fprintf(fid,"RX Out of Cell Delineation Interleaved ANOMALY\n");
   /* not used anywhere, so deleted
    if (gt_RxIbData.uc_flos_def    == PRESENT) fprintf(fid,"RX Loss of Synch DEFECT\n");
   */
    if (gt_RxIbData.uc_flcd_i_def  == PRESENT) fprintf(fid,"RX Loss of Cell Delineation Interleaved DEFECT\n");

    if (gt_RxIbData.uc_fncd_f_anom == PRESENT) fprintf(fid,"RX No Cell Delineation Fast ANOMALY\n");
    if (gt_RxIbData.uc_focd_f_anom == PRESENT) fprintf(fid,"RX Out of Cell Delineation Fast ANOMALY\n");
    if (gt_RxIbData.uc_flcd_f_def  == PRESENT) fprintf(fid,"RX Loss of Cell Delineation Fast DEFECT\n");
}

void main()
{
    int16 i;
    uint8 uc_txbyte[3];

   printf("Begin testing indicator bits.\n");

    gusa_CRC_count[INTERLEAVE_DATA_PATH] = 0;   //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)
   gusa_CRC_count[FAST_DATA_PATH] = 0; //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)

    guc_ShowtimeSnrCalcState = SHOWTIME_SNR_CALC_DISABLE;
    guc_SEFDetectState       = SEF_DETECT_DISABLED;

   // Initialize data buffer pointers.
   AllocateDataBuffers_PreHndshk();

   InitGlobalVariables();
// InitializeInfoField( gpt_TxInfo );  /*  initialize Tx information fields */
    TxInitIb();
    RxInitIb();

    gt_TxIbData.uc_cd_f_flag = TRUE;

   if ((fid = fopen("trail_ib.txt","w")) == NULL) {
      fprintf(stderr, "Cannot open trail_ib.txt file for writing.\n");
      exit(-1);
   }
   if ((fout = fopen("ib_out.txt","w")) == NULL) {
      fprintf(stderr, "Cannot open ib_out.txt file for writing.\n");
      exit(-1);
   }

    for (i = 0; i < TEST_SUPERFRAMES; i++)
    {
        if ( (i%5) == 0)  gusa_CRC_count[INTERLEAVE_DATA_PATH]++; //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)
        if ( (i%5) == 1)  gusa_CRC_count[FAST_DATA_PATH]++; //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)

        if ( (i%6) == 1)
        {
            gt_TxIbData.uc_ffec_i_anom      = PRESENT;
            gt_TxIbData.uc_ffec_i_anom_hist = PRESENT;
        }
        else
        {
            gt_TxIbData.uc_ffec_i_anom = TERMINATED;
        }

        if ( (i%6) == 2)
        {
            gt_TxIbData.uc_ffec_f_anom      = PRESENT;
            gt_TxIbData.uc_ffec_f_anom_hist = PRESENT;
        }
        else
        {
            gt_TxIbData.uc_ffec_f_anom = TERMINATED;
        }

        if ( (i%7) == 2)  gt_TxIbData.uc_flos_def = PRESENT;
        else              gt_TxIbData.uc_flos_def = TERMINATED;

        if ( (i%10) >= 4)
        {
            gt_TxIbData.uc_cd_i_flag      = TRUE;
            gt_TxIbData.uc_cd_i_flag_hist = TRUE;
        }
        else
        {
            gt_TxIbData.uc_cd_i_flag = FALSE;
        }

        if ( (i%10) <  6)
        {
            gt_TxIbData.uc_cd_f_flag      = TRUE;
            gt_TxIbData.uc_cd_f_flag_hist = TRUE;
        }
        else
        {
            gt_TxIbData.uc_cd_f_flag = FALSE;
        }

        if (i == 23)      gt_TxIbData.uc_fsef_def = PRESENT;
        else              gt_TxIbData.uc_fsef_def = TERMINATED;

        if ( (i%4) == 3)
        {
            gt_TxIbData.uc_fhec_i_anom      = PRESENT;
            gt_TxIbData.uc_fhec_i_anom_hist = PRESENT;
        }
        else
        {
            gt_TxIbData.uc_fhec_i_anom = TERMINATED;
        }

        if ( (i%4) == 2)
        {
            gt_TxIbData.uc_fhec_f_anom      = PRESENT;
            gt_TxIbData.uc_fhec_f_anom_hist = PRESENT;
        }
        else
        {
            gt_TxIbData.uc_fhec_f_anom = TERMINATED;
        }

        /*  CPE does not transmit NTR */
        /*  gt_TxIbData.s_fntr = (i%16) - 8; // test values from -8 to +8 */

        uc_txbyte[0] = TxIbHandler(1);
        RxIbHandler(0xFF,1);

        uc_txbyte[1] = TxIbHandler(34);
        RxIbHandler(uc_RXsf34[i],34);

        uc_txbyte[2] = TxIbHandler(35);
        RxIbHandler(uc_RXsf35[i],35);
      RxIbProcessor();

        TestResultHandler(uc_txbyte, i);

      BgRxSyncFrameProcessing();
    }

    fprintf(fid,"\n\nTOTAL RX FEBE-I's = %d\n",gt_RxIbData.s_febe_i_cnt);
    fprintf(fid,"TOTAL RX FFEC-I's = %d\n",gt_RxIbData.s_ffec_i_cnt);
    fprintf(fid,"TOTAL RX FHEC-I's = %d\n",gt_RxIbData.s_fhec_i_cnt);
    fprintf(fid,"\nTOTAL RX FEBE-F's = %d\n",gt_RxIbData.s_febe_f_cnt);
    fprintf(fid,"TOTAL RX FFEC-F's = %d\n",gt_RxIbData.s_ffec_f_cnt);
    fprintf(fid,"TOTAL RX FHEC-F's = %d\n",gt_RxIbData.s_fhec_f_cnt);
   /* this counter not used anywhere, so deleted
    fprintf(fid,"TOTAL RX FRDI's = %d\n",gt_RxIbData.l_frdi_cnt);
   */

    fclose(fid);
    fclose(fout);

   printf("Finished testing indicator bits.\n");

    exit(0);

}

/* undefine constants used by this file only */
#undef TEST_SUPERFRAMES

