/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: tone_ord.c
;
;  This file contains routine of perform tone ordering.
;
;***************************************************************************/

/*****************************************************************************
;  Prototype:
;     void ToneOrdering(int16 *psa_BAT, int16 s_NumTones, int16 s_MaxBitPerTone, int16 *psa_ToneIndices)
;
;  This subroutine performs the tone ordering as specified in G992.1 specification.
;
;
;  Input Arguments:
;     psa_BAT        -- pointer to the Bit Allocation Table
;
;     s_NumTone      -- total number of frequency tones or bands (DC and Nyquist tone is consider to
;                    be one tone)
;     s_MaxBitsPerTone-- maximum number of bits per tone
;
;  Output Arguments:
;     psa_ToneIndices -- pointer to an array of tone indices with the number of bits per tone
;              in ascending order (for those tones with the same number of bits,
;              the tone indices are in ascending order)
;
;  Global Variables Used:
;
;****************************************************************************/
#include "config.h"
#include "common.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "bitload_const.h"

extern uint16 gus_ncloaded_LP1;

C_SCOPE void ToneOrdering(uint8 *psa_BAT, int16 s_NumTones, int16 s_MaxBitsPerTone, int16 *psa_ToneIndices)
{
      int16 i, j, k;
      int16 sa_count[TX_MAX_BITS_PER_TONE+1];
      int16 sa_idx[TX_MAX_BITS_PER_TONE+1];
      int16 s_MinBitsPerTone = (int16) RX_MIN_BITS_PER_TONE;

      if (gft_ModemType == G_DMT_BIS)
         s_MinBitsPerTone = gs_RxMinBitsPerTone_BIS_TCM;

      /* Init tone count to 0 */
      for(k=0; k<=s_MaxBitsPerTone; k++)
         sa_count[k] = 0;

      /* Count the number of tones in each bit-assignment group */
      for(i=0; i<s_NumTones; i++) {
         k = psa_BAT[i];
         sa_count[k]++;
      }

      /* Compute the first tone location for each bit-assignment group */
      sa_idx[0] = 0;
      sa_idx[1] = sa_count[0];

   // sa_idx[2] = sa_count[0];

      gs_FirstNonzeroTone = sa_idx[1];

      for(k=s_MinBitsPerTone; k<=s_MaxBitsPerTone; k++) {

         j = k-1;
         sa_idx[k] = sa_idx[j] + sa_count[j];
      }

      /* Sort indices according to tone ordering rule  */
      for(i=0; i<s_NumTones; i++) {
         k = psa_BAT[i];
         psa_ToneIndices[sa_idx[k]] = i;
         sa_idx[k]++;
      }
}

/********************************************************************************
;  Subroutine Name: void RxToneOrderingBis(uint8 *puca_BAT, int16 s_NumTones, int16 s_NumLoadedTones, int16 s_num1bits, int16 *psa_toneorder)
;
;
;  Prototype:
;     void RxToneOrderingBis(uint8 *puca_BAT, int16 s_NumTones, int16 s_NumLoadedTones, int16 s_num1bits, int16 *psa_toneorder)
;
;  Input Arguments:
;     puca_BAT    -  Input bat table
;     s_NumTones     -  Number of tones
;     s_num1bits     -  Number of 1 bits
;     psa_toneorder  -  Output tone-ordering table
;
;
;  Output Arguments:
;
;
;  Return:
;
;
;  Global Variable used by this file:
;
;****************************************************************************/
C_SCOPE void RxToneOrderingBis(uint8 *puca_BAT, int16 s_NumTones, int16 s_NumLoadedTones, int16 s_num1bits, int16 *psa_toneorder)
{
   int16 s_bat, s_tone, *psa_toneorder_1bits, *psa_toneorder_non1bits, *psa_toneorderLP1;
   int16 s_min_distance_adj_physical_tones, s_min_distance_adj_tcm_tones, s_num_intlv_tones;
   int16 s_bi_gtthn1_physical_tone = 0, s_bi_gtthn1_logical_tone = 0;

   // considered numloaded tones for interleaving LP0 tones
   s_NumLoadedTones -= gus_ncloaded_LP1;

   /* distance between adjacent physical tones after tone ordering */
   s_min_distance_adj_physical_tones = gs_BisToneOrderIntlvDepth;
   /* distance between two adjacent tones into tcm encoder */
   s_min_distance_adj_tcm_tones = (s_NumLoadedTones - s_num1bits) / gs_BisToneOrderIntlvDepth;
   /* total number of tones we will be interleaving <= num tones with bi>1 */
   s_num_intlv_tones = s_min_distance_adj_tcm_tones * gs_BisToneOrderIntlvDepth;

   gs_FirstNonzeroTone = (s_NumTones - s_NumLoadedTones);

   psa_toneorder_1bits = (psa_toneorder + s_NumTones - s_num1bits);
   psa_toneorder_non1bits = (psa_toneorder + s_NumTones - s_NumLoadedTones);

   psa_toneorderLP1 = (psa_toneorder + s_NumTones - s_NumLoadedTones - gus_ncloaded_LP1);

   for (s_tone = 0; s_tone < s_NumTones; s_tone++) {
      s_bat = *(puca_BAT+s_tone);
      if (s_bat == 0) {
         *psa_toneorder++ = s_tone;
      }
      else if (s_bat == 1) {
         *psa_toneorder_1bits++ = s_tone;
      }

      else if (!IS_TONEFLAGSET(p_TonesAllocatedtoLP1_DS,s_tone)){

         if (s_bi_gtthn1_physical_tone < s_num_intlv_tones) {
            /* logical_n = (n mod k)*L + floor(n/k) */
            /* logical_n = (n - floor(n/k)*k)*L + floor(n/k) */
            s_bi_gtthn1_logical_tone = s_bi_gtthn1_physical_tone / s_min_distance_adj_tcm_tones;
            s_bi_gtthn1_logical_tone += ((s_bi_gtthn1_physical_tone - (s_bi_gtthn1_logical_tone * s_min_distance_adj_tcm_tones))*s_min_distance_adj_physical_tones);
         }
         else {
            /* logical_n = n */
            s_bi_gtthn1_logical_tone = s_bi_gtthn1_physical_tone;
         }
         *(psa_toneorder_non1bits + s_bi_gtthn1_logical_tone) = s_tone;
         s_bi_gtthn1_physical_tone++;
      }
      else
         // if dual latency, put all the LP1 tones before LP0 tones
         *psa_toneorderLP1++ = s_tone;

   }
}

