/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   File Name: trail1.c
*
*  This file contains function to print any results
*-------------------------------------------------------------------------
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "bitload.h"
#include "config.h"
#include "common.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "xgdata.h"
#include "bert.h"
#include "cmv.h"
#include "mp.h"
#include "fretrain.h"
#include "trailfileio_defs.h"
#include "tx_plam.h"
#include "tx_plam_bis.h"
#include "rx_plam.h"

#ifdef LEAVE_TRAIL
   #include "trailend.h"
   #include "trail.h"
#endif



/*****                              *****/
/*****  global variable declarations   *****/
/*****                              *****/

//#ifdef LEAVE_TRAIL
//    extern FILE *trail_fid;
//#endif

// Include this declaration for compilers without built-in fprintf() support.
// Exclude this declaration when using the DLL version of the MSVC CRT library.
#if !defined(_DLL) // _DLL = macro indicating the presence of DLL version of the CRT library
extern int fprintf(FILE* stream, const char *fmt, ...);
#endif //#if defined(_DLL)

/*----------------------------------------------------------------------------*
 *                               Local Functions                              *
 *----------------------------------------------------------------------------*/

/*****************************************************************************
;  Prototype: void PrnConfigParams(void)
;
;  This subroutine prints showtime configuration data to the trail file
;
;  Input Arguments:
;       None
;
;  Output Arguments:
;       None
;
;  Global Variables:
;
;
;****************************************************************************/

#ifdef LEAVE_TRAIL

void PrnConfigParams_DMT(void)
{
    int16 i;
   int16 s_RxFastPayloadBytes, s_RxIntlvPayloadBytes;
   int16 s_TxFastPayloadBytes, s_TxIntlvPayloadBytes;
   int16 s_Kp, s_CWSize;
   int32 l_S;

   s_TxFastPayloadBytes = 0;
   s_TxIntlvPayloadBytes = 0;

   for (i = 0; i < NUM_US_BEARER_CHANNELS; i++)
   {
      s_TxFastPayloadBytes += gt_tx_config.sa_Bpn[FAST_DATA_PATH][i];
      s_TxIntlvPayloadBytes += gt_tx_config.sa_Bpn[INTERLEAVE_DATA_PATH][i];
   }


    FPRINTF_TO_TRAILFILE(trail_fid, "\nFinal TX Configuration Parameters:\n");
    FPRINTF_TO_TRAILFILE(trail_fid, "\n\tFast Path:\n");
   FPRINTF_TO_TRAILFILE(trail_fid, "\tParity bytes per codeword (R) = %d\n", gt_tx_config.s_Rp[FAST_DATA_PATH]);
    FPRINTF_TO_TRAILFILE(trail_fid, "\tPayload bytes per mux frame (Bf):\n");
   FPRINTF_TO_TRAILFILE(trail_fid, "\t\tLS0 = %d\n", gt_tx_config.sa_Bpn[FAST_DATA_PATH][US_LS0_BEARER_CHANNEL]);
    FPRINTF_TO_TRAILFILE(trail_fid, "\t\tLS1 = %d\n", gt_tx_config.sa_Bpn[FAST_DATA_PATH][US_LS1_BEARER_CHANNEL]);
    FPRINTF_TO_TRAILFILE(trail_fid, "\t\tLS2 = %d\n", gt_tx_config.sa_Bpn[FAST_DATA_PATH][US_LS2_BEARER_CHANNEL]);

   FPRINTF_TO_TRAILFILE(trail_fid, "\tTotal payload bytes per Tx fast mux frame = %lu\n", s_TxFastPayloadBytes);

    FPRINTF_TO_TRAILFILE(trail_fid, "\n\tInterleaved Path:\n");
   FPRINTF_TO_TRAILFILE(trail_fid, "\tParity bytes per codeword (R) = %d\n", gt_tx_config.s_Rp[INTERLEAVE_DATA_PATH]);
   FPRINTF_TO_TRAILFILE(trail_fid, "\tS = %d\n", gt_tx_config.s_Mp[INTERLEAVE_DATA_PATH]);
   FPRINTF_TO_TRAILFILE(trail_fid, "\tD = %d\n", gt_tx_config.s_Dp[INTERLEAVE_DATA_PATH]);
    FPRINTF_TO_TRAILFILE(trail_fid, "\tPayload bytes per mux frame (Bi):\n");
    FPRINTF_TO_TRAILFILE(trail_fid, "\t\tBi, LS0 = %d\n", gt_tx_config.sa_Bpn[INTERLEAVE_DATA_PATH][US_LS0_BEARER_CHANNEL]);
    FPRINTF_TO_TRAILFILE(trail_fid, "\t\tBi, LS1 = %d\n", gt_tx_config.sa_Bpn[INTERLEAVE_DATA_PATH][US_LS1_BEARER_CHANNEL]);
    FPRINTF_TO_TRAILFILE(trail_fid, "\t\tBi, LS2 = %d\n", gt_tx_config.sa_Bpn[INTERLEAVE_DATA_PATH][US_LS2_BEARER_CHANNEL]);

   FPRINTF_TO_TRAILFILE(trail_fid, "Total payload bytes per Tx interleaved mux frame = %lu\n", s_TxIntlvPayloadBytes);

   s_RxFastPayloadBytes = 0;
   s_RxIntlvPayloadBytes = 0;

   for (i = 0; i < NUM_DS_BEARER_CHANNELS; i++)
   {
      s_RxFastPayloadBytes += gt_rx_config.sa_Bpn[FAST_DATA_PATH][i];
      s_RxIntlvPayloadBytes += gt_rx_config.sa_Bpn[INTERLEAVE_DATA_PATH][i];
   }

   FPRINTF_TO_TRAILFILE(trail_fid, "\nFinal RX Configuration Parameters:\n");
    FPRINTF_TO_TRAILFILE(trail_fid, "\n\tFast Path:\n");
   FPRINTF_TO_TRAILFILE(trail_fid, "\tParity bytes per codeword (R) = %d\n", gt_rx_config.s_Rp[FAST_DATA_PATH]);
   if(gft_ModemType == G_DMT)
   {
   //DMT
      FPRINTF_TO_TRAILFILE(trail_fid, "\tS = %d\n", gt_rx_config.s_Mp[INTERLEAVE_DATA_PATH]);

      FPRINTF_TO_TRAILFILE(trail_fid, "\tPayload bytes per mux frame (Bf):\n");
      FPRINTF_TO_TRAILFILE(trail_fid, "\t\tBf, AS0 = %d\n", gt_rx_config.sa_Bpn[FAST_DATA_PATH][DS_AS0_BEARER_CHANNEL]);
      FPRINTF_TO_TRAILFILE(trail_fid, "\t\tBf, AS1 = %d\n", gt_rx_config.sa_Bpn[FAST_DATA_PATH][DS_AS1_BEARER_CHANNEL]);
      FPRINTF_TO_TRAILFILE(trail_fid, "\t\tBf, AS2 = %d\n", gt_rx_config.sa_Bpn[FAST_DATA_PATH][DS_AS2_BEARER_CHANNEL]);
      FPRINTF_TO_TRAILFILE(trail_fid, "\t\tBf, AS3 = %d\n", gt_rx_config.sa_Bpn[FAST_DATA_PATH][DS_AS3_BEARER_CHANNEL]);
      FPRINTF_TO_TRAILFILE(trail_fid, "\t\tBf, LS0 = %d\n", gt_rx_config.sa_Bpn[FAST_DATA_PATH][DS_LS0_BEARER_CHANNEL]);
      FPRINTF_TO_TRAILFILE(trail_fid, "\t\tBf, LS1 = %d\n", gt_rx_config.sa_Bpn[FAST_DATA_PATH][DS_LS1_BEARER_CHANNEL]);
      FPRINTF_TO_TRAILFILE(trail_fid, "\t\tBf, LS2 = %d\n", gt_rx_config.sa_Bpn[FAST_DATA_PATH][DS_LS2_BEARER_CHANNEL]);
   }
   else if(gft_ModemType == G_DMT_BIS)
   {
   // bis
      FPRINTF_TO_TRAILFILE(trail_fid, "\tM = %d\n", gt_rx_config.s_Mp[FAST_DATA_PATH]);
      s_Kp = s_RxFastPayloadBytes + 1;
      s_CWSize = s_Kp * gt_rx_config.s_Mp[FAST_DATA_PATH] + gt_rx_config.s_Rp[FAST_DATA_PATH];
      if (gt_rx_config.s_Lp[FAST_DATA_PATH] !=0)
      {
      l_S = 8 * s_CWSize *256 / gt_rx_config.s_Lp[FAST_DATA_PATH]; // S in 8.8 format
      FPRINTF_TO_TRAILFILE(trail_fid, "\tS (8.8) = %d\n", l_S);
      }
      FPRINTF_TO_TRAILFILE(trail_fid, "\tPayload bytes per mux frame (Bf):\n");
      FPRINTF_TO_TRAILFILE(trail_fid, "\t\tBf, AS0 = %d\n", gt_rx_config.sa_Bpn[FAST_DATA_PATH][DS_AS0_BEARER_CHANNEL]);
      FPRINTF_TO_TRAILFILE(trail_fid, "\t\tBf, AS1 = %d\n", gt_rx_config.sa_Bpn[FAST_DATA_PATH][DS_AS1_BEARER_CHANNEL]);
      FPRINTF_TO_TRAILFILE(trail_fid, "\t\tBf, AS2 = %d\n", gt_rx_config.sa_Bpn[FAST_DATA_PATH][DS_AS2_BEARER_CHANNEL]);
      FPRINTF_TO_TRAILFILE(trail_fid, "\t\tBf, AS3 = %d\n", gt_rx_config.sa_Bpn[FAST_DATA_PATH][DS_AS3_BEARER_CHANNEL]);
   }

   FPRINTF_TO_TRAILFILE(trail_fid, "Total payload bytes per Rx fast mux frame = %lu\n", s_RxFastPayloadBytes);

    FPRINTF_TO_TRAILFILE(trail_fid, "\n\tInterleaved Path:\n");
   FPRINTF_TO_TRAILFILE(trail_fid, "\tParity bytes per codeword (R) = %d\n", gt_rx_config.s_Rp[INTERLEAVE_DATA_PATH]);
   if(gft_ModemType == G_DMT)
   {
   //DMT
      if (gt_rx_config.s_Mp[INTERLEAVE_DATA_PATH] != 0)
      FPRINTF_TO_TRAILFILE(trail_fid, "\tS = %d\n", gt_rx_config.s_Mp[INTERLEAVE_DATA_PATH]);
      else
      FPRINTF_TO_TRAILFILE(trail_fid, "\tS = 0.5\n");

      FPRINTF_TO_TRAILFILE(trail_fid, "\tD = %d\n", gt_rx_config.s_Dp[INTERLEAVE_DATA_PATH]);

        FPRINTF_TO_TRAILFILE(trail_fid, "\tPayload bytes per mux frame (Bi):\n");
      FPRINTF_TO_TRAILFILE(trail_fid, "\t\tBi, AS0 = %d\n", gt_rx_config.sa_Bpn[INTERLEAVE_DATA_PATH][DS_AS0_BEARER_CHANNEL]);
      FPRINTF_TO_TRAILFILE(trail_fid, "\t\tBi, AS1 = %d\n", gt_rx_config.sa_Bpn[INTERLEAVE_DATA_PATH][DS_AS1_BEARER_CHANNEL]);
      FPRINTF_TO_TRAILFILE(trail_fid, "\t\tBi, AS2 = %d\n", gt_rx_config.sa_Bpn[INTERLEAVE_DATA_PATH][DS_AS2_BEARER_CHANNEL]);
      FPRINTF_TO_TRAILFILE(trail_fid, "\t\tBi, AS3 = %d\n", gt_rx_config.sa_Bpn[INTERLEAVE_DATA_PATH][DS_AS3_BEARER_CHANNEL]);
      FPRINTF_TO_TRAILFILE(trail_fid, "\t\tBi, LS0 = %d\n", gt_rx_config.sa_Bpn[INTERLEAVE_DATA_PATH][DS_LS0_BEARER_CHANNEL]);
      FPRINTF_TO_TRAILFILE(trail_fid, "\t\tBi, LS1 = %d\n", gt_rx_config.sa_Bpn[INTERLEAVE_DATA_PATH][DS_LS1_BEARER_CHANNEL]);
      FPRINTF_TO_TRAILFILE(trail_fid, "\t\tBi, LS2 = %d\n", gt_rx_config.sa_Bpn[INTERLEAVE_DATA_PATH][DS_LS2_BEARER_CHANNEL]);
   }
   else if(gft_ModemType == G_DMT_BIS)
   {
   // bis
      FPRINTF_TO_TRAILFILE(trail_fid, "\tM = %d\n", gt_rx_config.s_Mp[INTERLEAVE_DATA_PATH]);
      s_Kp = s_RxIntlvPayloadBytes + 1;
      s_CWSize = s_Kp * gt_rx_config.s_Mp[INTERLEAVE_DATA_PATH] + gt_rx_config.s_Rp[INTERLEAVE_DATA_PATH];
      if (gt_rx_config.s_Lp[INTERLEAVE_DATA_PATH] != 0)
      {
      l_S = 8 * s_CWSize *256 / gt_rx_config.s_Lp[INTERLEAVE_DATA_PATH]; // S in 8.8 format
      FPRINTF_TO_TRAILFILE(trail_fid, "\tS (8.8) = %d\n", l_S);
      }
      FPRINTF_TO_TRAILFILE(trail_fid, "\tD = %d\n", gt_rx_config.s_Dp[INTERLEAVE_DATA_PATH]);

      FPRINTF_TO_TRAILFILE(trail_fid, "\tPayload bytes per mux frame (Bi):\n");
      FPRINTF_TO_TRAILFILE(trail_fid, "\t\tBi, AS0 = %d\n", gt_rx_config.sa_Bpn[INTERLEAVE_DATA_PATH][DS_AS0_BEARER_CHANNEL]);
      FPRINTF_TO_TRAILFILE(trail_fid, "\t\tBi, AS1 = %d\n", gt_rx_config.sa_Bpn[INTERLEAVE_DATA_PATH][DS_AS1_BEARER_CHANNEL]);
      FPRINTF_TO_TRAILFILE(trail_fid, "\t\tBi, AS2 = %d\n", gt_rx_config.sa_Bpn[INTERLEAVE_DATA_PATH][DS_AS2_BEARER_CHANNEL]);
      FPRINTF_TO_TRAILFILE(trail_fid, "\t\tBi, AS3 = %d\n", gt_rx_config.sa_Bpn[INTERLEAVE_DATA_PATH][DS_AS3_BEARER_CHANNEL]);
   }



   FPRINTF_TO_TRAILFILE(trail_fid, "Total payload bytes per Rx interleaved mux frame = %lu\n", s_RxIntlvPayloadBytes);

   FPRINTF_TO_TRAILFILE(trail_fid, "Average total payload bytes per Rx DMT frame = %lu\n", s_RxFastPayloadBytes+s_RxIntlvPayloadBytes);


   gft_USDS_Payloads_PrintedToTrail = 1;

}


void PrntCnfgInfo(Config_t pt_config)
{
   int16 s_lp;

   FPRINTF_TO_TRAILFILE(trail_fid, "        Mp  |  Rp  |  Dp  |  Tp  |   Lp  |  BC0  |  BC1 \n");
   FPRINTF_TO_TRAILFILE(trail_fid, "----------------------------------------------------------\n");
   for (s_lp = 0; s_lp < gt_rx_config.s_Nlp; s_lp++)
   {
   FPRINTF_TO_TRAILFILE(trail_fid, "LP%d: ", s_lp);
      FPRINTF_TO_TRAILFILE(trail_fid, "%4d  %4d    %4d   %4d   %6d   %5d   %5d\n",  pt_config.s_Mp[s_lp], pt_config.s_Rp[s_lp], pt_config.s_Dp[s_lp], pt_config.s_Tp[s_lp], pt_config.s_Lp[s_lp], pt_config.sa_Bpn[s_lp][0], pt_config.sa_Bpn[s_lp][1]);
   }

   FPRINTF_TO_TRAILFILE(trail_fid, "Framing Mode = %d\n", pt_config.s_FramingMode);
   FPRINTF_TO_TRAILFILE(trail_fid, "MSGlp = %d\n", pt_config.s_MSGlp);
   FPRINTF_TO_TRAILFILE(trail_fid, "MSGc = %d\n", pt_config.s_MSGc);
   FPRINTF_TO_TRAILFILE(trail_fid, "\n");

}

void PrnConfigParams_BIS(void)
{

   FPRINTF_TO_TRAILFILE(trail_fid, "\n");
   FPRINTF_TO_TRAILFILE(trail_fid, "Showtime Configuration Parameters:\n");

   // print out downstream showtime config info
   FPRINTF_TO_TRAILFILE(trail_fid, "Downstream:\n");
   PrntCnfgInfo(gt_rx_config);

   // print out upstream showtime config info
   FPRINTF_TO_TRAILFILE(trail_fid, "Upstream:\n");
   PrntCnfgInfo(gt_tx_config);

}

#endif /*  LEAVE_TRAIL */


/*****************************************************************************
;  Prototype: void PrnConfigParamsLite(void)
;
;  This subroutine
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variables:
;
;
;****************************************************************************/
#ifdef LEAVE_TRAIL
void PrnConfigParamsLite(void)
{
    FPRINTF_TO_TRAILFILE(trail_fid, "\nFinal TX Configuration Parameters:\n");
   FPRINTF_TO_TRAILFILE(trail_fid, "\tR = %d\n", gt_tx_config.s_Rp[INTERLEAVE_DATA_PATH]);
   FPRINTF_TO_TRAILFILE(trail_fid, "\tS = %d\n", gt_tx_config.s_Mp[INTERLEAVE_DATA_PATH]);
   FPRINTF_TO_TRAILFILE(trail_fid, "\tD = %d\n", gt_tx_config.s_Dp[INTERLEAVE_DATA_PATH]);
   FPRINTF_TO_TRAILFILE(trail_fid, "\tPayload Bytes (Bi) = %d\n\n", gt_tx_config.sa_Bpn[INTERLEAVE_DATA_PATH][0]);

   FPRINTF_TO_TRAILFILE(trail_fid, "\nFinal RX Configuration Parameters:\n");
   FPRINTF_TO_TRAILFILE(trail_fid, "\tR = %d\n", gt_rx_config.s_Rp[INTERLEAVE_DATA_PATH]);
   FPRINTF_TO_TRAILFILE(trail_fid, "\tS = %d\n", gt_rx_config.s_Mp[INTERLEAVE_DATA_PATH]);
   FPRINTF_TO_TRAILFILE(trail_fid, "\tD = %d\n", gt_rx_config.s_Dp[INTERLEAVE_DATA_PATH]);
   FPRINTF_TO_TRAILFILE(trail_fid, "\tPayload Bytes (Bi) = %d\n\n", gt_rx_config.sa_Bpn[INTERLEAVE_DATA_PATH][0]);

   gft_USDS_Payloads_PrintedToTrail = 1;

}
#endif

/*****************************************************************************
;  Prototype: void PrnShowTimeResults()
;
;  This subroutine prints results collected during showtime to the trail file.
;   These results include:
;   CRC errors
;   RS errors detected and corrected
;   BERT  statistics (if enabled)
;
;  Input Arguments:
;       None
;
;  Output Arguments:
;       None
;
;  Global Variables:
;
;
;****************************************************************************/
#ifdef LEAVE_TRAIL

void PrnShowTimeResults()
{

    int16 i = 0, s_bc, s_BearerChannel;
   int s_USLatencyPathOffset, s_DSLatencyPathOffset;
    uint8 uca_chan_str[5];
   int16 s_RxPayloadBytes;
   uint32 ul_ExpectedBitErrors;

    if (gft_ShowtimeStateReached == 1) {

      FPRINTF_TO_TRAILFILE(trail_fid, "\nSHOWTIME STATISTICS:\n\n");

      if ((STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_AB)
      ||(( (gl_SelectedMode & (MODE_G992_2))) && (gl_SelectedMode & (ANNEX_C)  )))
         FPRINTF_TO_TRAILFILE(trail_fid, "Mode = G992.2\n");
      else if (( gl_SelectedMode & (MODE_G992_3)  ))
         FPRINTF_TO_TRAILFILE(trail_fid, "Mode = G992.3\n");
      else if (( gl_SelectedMode & (MODE_G992_5)  ))
         FPRINTF_TO_TRAILFILE(trail_fid, "Mode = G992.5\n");
      else if (( (gl_SelectedMode & (MODE_G992_1))) && (gl_SelectedMode & (ANNEX_B)  ))
         FPRINTF_TO_TRAILFILE(trail_fid, "Mode = G992.1B\n");
      else
         FPRINTF_TO_TRAILFILE(trail_fid, "Mode = G992.1\n");

      FPRINTF_TO_TRAILFILE(trail_fid, "Framing Mode = %d\n", gft_FrameMode);
      if(gft_ModemType == G_DMT_BIS) {
         FPRINTF_TO_TRAILFILE(trail_fid, "Trellis enabled = %d\n", gft_TcmFlag_bis_DS);
      }
      else {
         FPRINTF_TO_TRAILFILE(trail_fid, "Trellis enabled = %d\n", gft_TcmFlag);
      }


      FPRINTF_TO_TRAILFILE(trail_fid, "Number of frames early Tx interleave path was started = %d\n", gs_num_preproc_frames);


      if (gft_USDS_Payloads_PrintedToTrail == 0){
         // Print path, bearer channel payloads if not already printed.
         if (gs_RxNumTones == 128) // Lite Mode
            PrnConfigParamsLite();
         else //Full Mode
         {
            if (gft_ModemType != G_DMT_BIS)
               PrnConfigParams_DMT();
            else
               PrnConfigParams_BIS();

         }
      }

      if(gft_ModemType == G_DMT_BIS)
         FPRINTF_TO_TRAILFILE(trail_fid, "\nTX SuperFrames:  %ld\n", gl_tx_sframe_count);
      else
         FPRINTF_TO_TRAILFILE(trail_fid, "\nTX SuperFrames:  %ld\n", gs_bitswap_tx_sframe_count);

      FPRINTF_TO_TRAILFILE(trail_fid, "\nTotal Rx data frames = %lu\n", gul_TotalRxDataFrameCnt);


        FPRINTF_TO_TRAILFILE(trail_fid, "RX SuperFrames:  %d\n", gl_rx_sframe_count-1);

      /* =========================================== */
      /*  Print CRC and Reed Solomon error counts */
      /* =========================================== */

      FPRINTF_TO_TRAILFILE(trail_fid, "\n");
        FPRINTF_TO_TRAILFILE(trail_fid, "Fast CRC errors (near end) = %d\n", gusa_CRC_count[FAST_DATA_PATH]);  //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)
      FPRINTF_TO_TRAILFILE(trail_fid, "Intlv CRC errors (near end) = %d\n", gusa_CRC_count[INTERLEAVE_DATA_PATH]);   //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)

      FPRINTF_TO_TRAILFILE(trail_fid, "Fast RS errors corrected = %d\n", gsa_CorrectedRSErrors[FAST_DATA_PATH] );
      FPRINTF_TO_TRAILFILE(trail_fid, "Fast uncorrectable RS Codewords = %d\n", gs_UncorrectableRSCodewordCnt[FAST_DATA_PATH]);

      FPRINTF_TO_TRAILFILE(trail_fid, "Intlv RS errors corrected = %d\n", gsa_CorrectedRSErrors[INTERLEAVE_DATA_PATH] );
      FPRINTF_TO_TRAILFILE(trail_fid, "Intlv uncorrectable RS Codewords = %d\n", gs_UncorrectableRSCodewordCnt[INTERLEAVE_DATA_PATH]);


      // Print ATM info
      if ( (TESTArray[TEST_Control] & TEST_AlphaeusControl) != 0)
      {
         FPRINTF_TO_TRAILFILE(trail_fid, "\n");
         FPRINTF_TO_TRAILFILE(trail_fid, "ATM statistics:\n");

         // print Upstream ATM info
         FPRINTF_TO_TRAILFILE(trail_fid, "*** Upstream transmit side ***\n");
         FPRINTF_TO_TRAILFILE(trail_fid, "Cell Counter || Non-Idle Cell | Idle Cell | Total Cell | Idle Cell%%\n");
         FPRINTF_TO_TRAILFILE(trail_fid, "-----------------------------------------------------------------------\n");


         s_BearerChannel = (gt_tx_config.s_Nbc <MAX_ATM_SIZE) ? gt_tx_config.s_Nbc: MAX_ATM_SIZE;

         for ( s_bc = 0; s_bc < s_BearerChannel; s_bc++)
         {
            FPRINTF_TO_TRAILFILE(trail_fid, "    BC%d:       ", s_bc);
            FPRINTF_TO_TRAILFILE(trail_fid, "%8ld       ", gula_fe_non_idle_cell_cnt[s_bc]);
            FPRINTF_TO_TRAILFILE(trail_fid, "%7ld      ", gula_fe_idle_cell_cnt[s_bc]);
            FPRINTF_TO_TRAILFILE(trail_fid, "%7ld      ", gula_fe_tot_cell_cnt[s_bc]);
            if (gula_fe_tot_cell_cnt[s_bc])
               FPRINTF_TO_TRAILFILE(trail_fid, "%  1.6f    \n", (float)gula_fe_idle_cell_cnt[s_bc]/(float)gula_fe_tot_cell_cnt[s_bc]);
            else
               FPRINTF_TO_TRAILFILE(trail_fid, "      -    \n");

         }

         // print Downstream ATM info
         FPRINTF_TO_TRAILFILE(trail_fid, "\n*** Downstream receive side ***\n");
         FPRINTF_TO_TRAILFILE(trail_fid, "Cell Counter || Non-Idle | Idle | Dropped | Total |  Total   |  Total   | Idle Cell \n");
         FPRINTF_TO_TRAILFILE(trail_fid, "             ||   Cell   | Cell |  Cell   |  Cell | HEC Cell |HEC Error | Percentage \n");
         FPRINTF_TO_TRAILFILE(trail_fid, "-----------------------------------------------------------------------\n");

         s_BearerChannel = (gt_rx_config.s_Nbc <MAX_ATM_SIZE) ? gt_rx_config.s_Nbc: MAX_ATM_SIZE;

         for ( s_bc = 0; s_bc < s_BearerChannel; s_bc++)
         {
         FPRINTF_TO_TRAILFILE(trail_fid, "     BC%d:     ", s_bc);
            FPRINTF_TO_TRAILFILE(trail_fid, "%7ld     ", gula_non_idle_cell_cnt[s_bc]);
            FPRINTF_TO_TRAILFILE(trail_fid, "%5ld   ", gula_idle_cell_cnt[s_bc]);
            FPRINTF_TO_TRAILFILE(trail_fid, "%4ld    ", gula_dropped_cell_cnt[s_bc]);
            FPRINTF_TO_TRAILFILE(trail_fid, "%6ld   ", gula_tot_cell_cnt[s_bc]);
            FPRINTF_TO_TRAILFILE(trail_fid, "%6ld    ", gula_tot_hec_cnt[s_bc]);
            FPRINTF_TO_TRAILFILE(trail_fid, "%7ld    ", gula_hec_error_cnt[s_bc]);
            if (gula_tot_hec_cnt[s_bc])
               FPRINTF_TO_TRAILFILE(trail_fid, "  %1.6f    \n", (double)gula_idle_cell_cnt[s_bc]/(double)gula_tot_hec_cnt[s_bc]);
            else
               FPRINTF_TO_TRAILFILE(trail_fid, "      -    \n");
         }


      }


      if (gs_do_bert == 1)
      {
         /* =========================================== */
         /*  Print BERT results */
         /* =========================================== */
         FPRINTF_TO_TRAILFILE(trail_fid, "\nBERT RESULTS:\n");

         // Determine average payload bytes per frame.
         for (i = 0, s_RxPayloadBytes = 0; i < NUM_DS_BEARER_CHANNELS; i++)
         {
            s_RxPayloadBytes += gt_rx_config.sa_Bpn[FAST_DATA_PATH][i] + gt_rx_config.sa_Bpn[INTERLEAVE_DATA_PATH][i];
         }

         for (i = 0; i < NUM_DS_BEARER_CHANNELS; i++)
         {
            switch (i)
            {
            case 0:
               strcpy(uca_chan_str, "AS0");
               break;
            case 1:
               strcpy(uca_chan_str, "AS1");
               break;
            case 2:
               strcpy(uca_chan_str, "AS2");
               break;
            case 3:
               strcpy(uca_chan_str, "AS3");
               break;
            case 4:
               strcpy(uca_chan_str, "LS0");
               break;
            case 5:
               strcpy(uca_chan_str, "LS1");
               break;
            case 6:
               strcpy(uca_chan_str, "LS2");
               break;
            }

            if(gt_rx_config.sa_Bpn[FAST_DATA_PATH][i] != 0)
            {

               if (gta_RxBertStat[i].s_pattern_sync == 1)
               {
                  FPRINTF_TO_TRAILFILE(trail_fid, "FAST PATH, %s HAS BERT PATTERN SYNC AT TERMINATION\n", uca_chan_str);
               }
               else
               {
                  FPRINTF_TO_TRAILFILE(trail_fid, "FAST PATH, %s DOES NOT HAVE BERT PATTERN SYNC AT TERMINATION\n", uca_chan_str);
               }

               // Expected bit error rate using BERT is 1 in 1000 received bits. Approximate this as 1 in 1024.

               // Calculate expected bit error count = frames * bytes/frame * 8bits/byte / 1024.
               // To avoid overflowing the 32-bit representation,
               // there are two ways to do it depending on magnitude of gul_TotalRxDataFrameCnt.
               // We know that gt_rx_config.sa_Bf[i] will always be less than 256.

               if (gul_TotalRxDataFrameCnt < (((uint32) 1)<<24))
                  ul_ExpectedBitErrors = (gul_TotalRxDataFrameCnt * gt_rx_config.sa_Bpn[FAST_DATA_PATH][i]) >> 7;
               else
                  ul_ExpectedBitErrors = (gul_TotalRxDataFrameCnt >> 7) * gt_rx_config.sa_Bpn[FAST_DATA_PATH][i];

               FPRINTF_TO_TRAILFILE(trail_fid, "FAST PATH, %s EXPECTED BIT ERRORS (APPROXIMATELY 1 in 1024) = %d\n",uca_chan_str, ul_ExpectedBitErrors);
               FPRINTF_TO_TRAILFILE(trail_fid, "FAST PATH, %s ACTUAL BIT ERRORS = %d\n",uca_chan_str, gta_RxBertStat[i].ul_num_bit_errs);
            }
         }

         FPRINTF_TO_TRAILFILE(trail_fid, "\n");

         for (i = 0; i < NUM_DS_BEARER_CHANNELS; i++)
         {
            switch (i)
            {
            case 0:
               strcpy(uca_chan_str, "AS0");
               break;
            case 1:
               strcpy(uca_chan_str, "AS1");
               break;
            case 2:
               strcpy(uca_chan_str, "AS2");
               break;
            case 3:
               strcpy(uca_chan_str, "AS3");
               break;
            case 4:
               strcpy(uca_chan_str, "LS0");
               break;
            case 5:
               strcpy(uca_chan_str, "LS1");
               break;
            case 6:
               strcpy(uca_chan_str, "LS2");
               break;
            }

            if(gt_rx_config.sa_Bpn[INTERLEAVE_DATA_PATH][i] != 0)
            {
               if (gta_RxBertStat[i].s_pattern_sync == 1)
               {
                  FPRINTF_TO_TRAILFILE(trail_fid, "INTERLEAVED PATH, %s HAS BERT PATTERN SYNC AT TERMINATION\n", uca_chan_str);
               }
               else
               {
                  FPRINTF_TO_TRAILFILE(trail_fid, "INTERLEAVED PATH, %s DOES NOT HAVE BERT PATTERN SYNC AT TERMINATION\n", uca_chan_str);
               }

               // Expected bit error rate using BERT is 1 in 1000 received bits. Approximate this as 1 in 1024.

               // Calculate expected bit error count = frames * bytes/frame * 8bits/byte / 1024.
               // To avoid overflowing the 32-bit representation,
               // there are two ways to do it depending on magnitude of gul_TotalRxDataFrameCnt.
               // We know that gt_rx_config.sa_Bf[i] will always be less than 256.

               if (gul_TotalRxDataFrameCnt < (((uint32) 1)<<24))
                  ul_ExpectedBitErrors = (gul_TotalRxDataFrameCnt * gt_rx_config.sa_Bpn[INTERLEAVE_DATA_PATH][i]) >> 7;
               else
                  ul_ExpectedBitErrors = (gul_TotalRxDataFrameCnt >> 7) * gt_rx_config.sa_Bpn[INTERLEAVE_DATA_PATH][i];

               FPRINTF_TO_TRAILFILE(trail_fid, "INTERLEAVED PATH, %s EXPECTED BIT ERRORS (APPROXIMATELY 1 in 1024) = %d\n",uca_chan_str, ul_ExpectedBitErrors);
               FPRINTF_TO_TRAILFILE(trail_fid, "INTERLEAVED PATH, %s ACTUAL BIT ERRORS = %d\n",uca_chan_str, gta_RxBertStat[i].ul_num_bit_errs);
            }
         }
      }

      FPRINTF_TO_TRAILFILE(trail_fid, "\n");
      FPRINTF_TO_TRAILFILE(trail_fid, "Number of SNR Updates = %d\n",gus_ShowtimeSNRUpdateCount);
      FPRINTF_TO_TRAILFILE(trail_fid, "Number of FDQ Updates = %d\n",gus_ShowtimeFDQUpdateCount);
      FPRINTF_TO_TRAILFILE(trail_fid, "Number of DEC Updates = %d\n", (int16) *(INFOMap[INFO_ShowtimeDECUpdateCount]));

      FPRINTF_TO_TRAILFILE(trail_fid, "\n");
      FPRINTF_TO_TRAILFILE(trail_fid, "SEF Total Count = %d\n",gus_SEF_totalcount);
      FPRINTF_TO_TRAILFILE(trail_fid, "SEF Running Count = %d\n",gs_SEF_sframe_cnt);
      FPRINTF_TO_TRAILFILE(trail_fid, "SEF Defects Per Sec = %d\n",gs_sef_cnt);
      FPRINTF_TO_TRAILFILE(trail_fid, "LOS Defects Per Sec = %d\n",gs_los_cnt);
      FPRINTF_TO_TRAILFILE(trail_fid, "Errored Data Frames Total Count = %d\n",gl_DD_numDiscardedDataFrames);

      if(OPTNArray[OPTN_FFTBufferControl] != 0)
      {
         FPRINTF_TO_TRAILFILE(trail_fid, "\n");
         FPRINTF_TO_TRAILFILE(trail_fid, "Train FFT Scenario = %d\n",(OPTNArray[OPTN_FFTBufferControl] & OPTN_FFTBufferTrainControlMask));
         FPRINTF_TO_TRAILFILE(trail_fid, "Showtime FFT Scenario = %d\n",((OPTNArray[OPTN_FFTBufferControl] & OPTN_FFTBufferShowtimeControlMask)>>4));
      }



      if (gus_ShowtimeSNRUpdateCount >= 1) {
         FPRINTF_TO_TRAILFILE(trail_fid, "\nFinal Showtime SNR in dB\n");
         for(i=0; i<gs_RxNumTones;i++)
            FPRINTF_TO_TRAILFILE(trail_fid, "gsa_RxShowtimeSnrBuf[%d] = %d\n", i, (gsa_RxShowtimeSnrBuf[i]>>8));
      }



        FPRINTF_TO_TRAILFILE(trail_fid, "LATNus = %d [dB * 10]\n",                              *(((int16 *)INFOMap[69]) + 1));
        FPRINTF_TO_TRAILFILE(trail_fid, "LATNds = %d [dB * 10]\n",                              *(((int16 *)INFOMap[68]) + 1));

        FPRINTF_TO_TRAILFILE(trail_fid, "ACTATPus = %d [dB * 10]\n",                            *(((int16 *)INFOMap[69]) + 6));
        FPRINTF_TO_TRAILFILE(trail_fid, "ACTATPds = %d [dB * 10]\n",                            *(((int16 *)INFOMap[68]) + 6));

        FPRINTF_TO_TRAILFILE(trail_fid, "ATTNDRus = %d [bits/sec]\n",                           (*(((int16 *)INFOMap[69]) + 5)<<16) + (*(((int16 *)INFOMap[69]) + 4) & 0xFFFF));
        FPRINTF_TO_TRAILFILE(trail_fid, "ATTNDRds = %d [bits/sec]\n",                           (*(((int16 *)INFOMap[68]) + 5)<<16) + (*(((int16 *)INFOMap[68]) + 4) & 0xFFFF));

      s_USLatencyPathOffset = *((int16 *)INFOMap[93]);
      s_DSLatencyPathOffset = *((int16 *)INFOMap[92]);

      if(STATArray[STAT_ACTIVEBCLP_US] & LP0_ACTIVE)
         FPRINTF_TO_TRAILFILE(trail_fid, "DELAYus Lp0 = %d [ms * 4]\n",                          *(((int16 *)INFOMap[93]) + 1));
      if(STATArray[STAT_ACTIVEBCLP_US] & LP1_ACTIVE)
         FPRINTF_TO_TRAILFILE(trail_fid, "DELAYus Lp1 = %d [ms * 4]\n",                      *(((int16 *)INFOMap[93]) + 1 + s_USLatencyPathOffset));

      if(STATArray[STAT_ACTIVEBCLP_DS] & LP0_ACTIVE)
         FPRINTF_TO_TRAILFILE(trail_fid, "DELAYds Lp0 = %d [ms * 4]\n",                          *(((int16 *)INFOMap[92]) + 1));
      if(STATArray[STAT_ACTIVEBCLP_DS] & LP1_ACTIVE)
         FPRINTF_TO_TRAILFILE(trail_fid, "DELAYds Lp1 = %d [ms * 4]\n",                      *(((int16 *)INFOMap[92]) + 3 + s_DSLatencyPathOffset));

      if(STATArray[STAT_ACTIVEBCLP_US] & LP0_ACTIVE)
         FPRINTF_TO_TRAILFILE(trail_fid, "INPus Lp0 = %d [INP * 10]\n",                          *(((int16 *)INFOMap[93]) + 2));
      if(STATArray[STAT_ACTIVEBCLP_US] & LP1_ACTIVE)
         FPRINTF_TO_TRAILFILE(trail_fid, "INPus Lp1 = %d [INP * 10]\n",                      *(((int16 *)INFOMap[93]) + 4 + s_USLatencyPathOffset));

      if(STATArray[STAT_ACTIVEBCLP_DS] & LP0_ACTIVE)
         FPRINTF_TO_TRAILFILE(trail_fid, "INPds Lp0 = %d [INP * 10]\n",                          *(((int16 *)INFOMap[92]) + 2));
      if(STATArray[STAT_ACTIVEBCLP_DS] & LP1_ACTIVE)
         FPRINTF_TO_TRAILFILE(trail_fid, "INPds Lp1 = %d [INP * 10]\n",                      *(((int16 *)INFOMap[92]) + 4 + s_DSLatencyPathOffset));

        FPRINTF_TO_TRAILFILE(trail_fid, "\nNegotiated DS G.hs Parameters:\n");
        FPRINTF_TO_TRAILFILE(trail_fid, "MSGmin = %d\n",                                        *(((int16 *)INFOMap[98]) + 0));
        FPRINTF_TO_TRAILFILE(trail_fid, "Nlp = %d\n",                                           *(((int16 *)INFOMap[98]) + 1));
        FPRINTF_TO_TRAILFILE(trail_fid, "Rpmax Lp0 = %d\n",                                     *(((int16 *)INFOMap[98]) + 2));
        FPRINTF_TO_TRAILFILE(trail_fid, "Rpmax Lp1 = %d\n",                                     *(((int16 *)INFOMap[98]) + 3));
        FPRINTF_TO_TRAILFILE(trail_fid, "Dpmax Lp0 = %d\n",                                     *(((int16 *)INFOMap[98]) + 4));
        FPRINTF_TO_TRAILFILE(trail_fid, "Dpmax Lp1 = %d\n",                                     *(((int16 *)INFOMap[98]) + 5));
        FPRINTF_TO_TRAILFILE(trail_fid, "Max net data rate Lp0 = %d\n",                         *(((int16 *)INFOMap[98]) + 6));
        FPRINTF_TO_TRAILFILE(trail_fid, "Max net data rate Lp1 = %d\n",                         *(((int16 *)INFOMap[98]) + 7));
        FPRINTF_TO_TRAILFILE(trail_fid, "Frame bearer supported Lp0 = %d\n",                    *(((int16 *)INFOMap[98]) + 8));
        FPRINTF_TO_TRAILFILE(trail_fid, "Frame bearer supported Lp1 = %d\n",                    *(((int16 *)INFOMap[98]) + 9));
        FPRINTF_TO_TRAILFILE(trail_fid, "Min net data rate BC0 = %d\n",                         *(((int16 *)INFOMap[98]) + 10));
        FPRINTF_TO_TRAILFILE(trail_fid, "Min net data rate BC1 = %d\n",                         *(((int16 *)INFOMap[98]) + 11));
        FPRINTF_TO_TRAILFILE(trail_fid, "Max net data rate BC0 = %d\n",                         *(((int16 *)INFOMap[98]) + 12));
        FPRINTF_TO_TRAILFILE(trail_fid, "Max net data rate BC1 = %d\n",                         *(((int16 *)INFOMap[98]) + 13));
        FPRINTF_TO_TRAILFILE(trail_fid, "Min reserved data rate BC0 = %d\n",                    *(((int16 *)INFOMap[98]) + 14));
        FPRINTF_TO_TRAILFILE(trail_fid, "Min reserved data rate BC1 = %d\n",                    *(((int16 *)INFOMap[98]) + 15));
        FPRINTF_TO_TRAILFILE(trail_fid, "Max delay BC0 = %d\n",                                 *(((int16 *)INFOMap[98]) + 16));
        FPRINTF_TO_TRAILFILE(trail_fid, "Max delay BC1 = %d\n",                                 *(((int16 *)INFOMap[98]) + 17));
        FPRINTF_TO_TRAILFILE(trail_fid, "Max Bit Error Rate BC0 = %d\n",                        *(((int16 *)INFOMap[98]) + 18));
        FPRINTF_TO_TRAILFILE(trail_fid, "Max Bit Error Rate BC1 = %d\n",                        *(((int16 *)INFOMap[98]) + 19));
        FPRINTF_TO_TRAILFILE(trail_fid, "Min Impulse Noise Protection BC0 = %d\n",              *(((int16 *)INFOMap[98]) + 20));
        FPRINTF_TO_TRAILFILE(trail_fid, "Min Impulse Noise Protection BC1 = %d\n",              *(((int16 *)INFOMap[98]) + 21));
        FPRINTF_TO_TRAILFILE(trail_fid, "Supporteed D Values LP0 = %d\n",                       *(((int16 *)INFOMap[98]) + 22));
        FPRINTF_TO_TRAILFILE(trail_fid, "Min supported S value BC0 = %d\n",                     *(((int16 *)INFOMap[98]) + 23));
        FPRINTF_TO_TRAILFILE(trail_fid, "Transfer Mode BC0 = %d\n",                             *(((int16 *)INFOMap[98]) + 24));
        FPRINTF_TO_TRAILFILE(trail_fid, "Transfer Mode BC1 = %d\n",                             *(((int16 *)INFOMap[98]) + 25));

      if(guc_AlignmentTrainingState == TRAINING_DONE) {
         FPRINTF_TO_TRAILFILE(trail_fid, "\nReverb2 Frame Alignment:\n");
         FPRINTF_TO_TRAILFILE(trail_fid, "Correlation Peak Method  = %d\n", gus_SyncOffset_Corr_Method);
         FPRINTF_TO_TRAILFILE(trail_fid, "Max Window Energy Method = %d\n\n", gus_SyncOffset);
      }

      if (gft_FDQ_PrintedToTrail == 0)
         // Print FDQ coefficients if they weren't already printed.
         PrintFinalFDQ();


      if (gft_DS_BAT_PrintedToTrail == 0){
         // Print Downstream bit allocation table if it wasn't already printed.
         PrintFinal_DS_BAT();
      }

      if (gft_DS_FineGains_PrintedToTrail == 0){
         // Print Downstream fine gains table if it wasn't already printed.
         PrintFinal_DS_FineGains();
      }

      if (gft_US_BAT_PrintedToTrail == 0){
         // Print Downstream bit allocation table if it wasn't already printed.
         PrintFinal_US_BAT();
      }

      if (gft_US_FineGains_PrintedToTrail == 0){
         // Print Downstream fine gains table if it wasn't already printed.
         PrintFinal_US_FineGains();
      }
   }
}

#endif /* LEAVE_TRAIL */


/*****************************************************************************
;  Prototype: void PrnOtherResults(void)
;
;  This subroutine
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variables:
;
;
;****************************************************************************/
void PrnOtherResults(void)
{
#ifdef LEAVE_TRAIL
   if (TESTArray[TEST_InitState] == TEST_RetrainInitState)
   {
      FPRINTF_TO_TRAILFILE(trail_fid, "FRTruncate Flag: %d\n\n", gft_FR_Truncate_Flag);
      FPRINTF_TO_TRAILFILE(trail_fid, "Escape to G.hs Flag: %d\n\n", gft_EscFromFR_Flag);

      FPRINTF_TO_TRAILFILE(trail_fid, "R_MSG_FR1:\n");
      for(i=0; i<R_MSG_FR1_NUM_BYTES ; i++)
         FPRINTF_TO_TRAILFILE(trail_fid, "guca_RMsgFR1Tab[%d] = 0x%02x\n", i, guca_RMsgFR1Tab[i]);
      FPRINTF_TO_TRAILFILE(trail_fid, "\n");

      FPRINTF_TO_TRAILFILE(trail_fid, "C_MSG_FR1:\n");
      for(i=0; i<R_C_MSG_FR1_NUM_BYTES ; i++)
         FPRINTF_TO_TRAILFILE(trail_fid, "guca_R_C_Msg_FR1[%d] = 0x%02x\n", i, guca_R_C_Msg_FR1[i]);
      FPRINTF_TO_TRAILFILE(trail_fid, "\n");

      /* print R_Msg_FR2 and C_Msg_FR2 only if we reach those states */
      if(gft_FR_Truncate_Flag == FALSE)
      {
         FPRINTF_TO_TRAILFILE(trail_fid, "R_MSG_FR2:\n");
         for(i=0; i<R_MSG_FR2_NUM_BYTES ; i++)
            FPRINTF_TO_TRAILFILE(trail_fid, "guca_RMsgFR2Tab[%d] = 0x%02x\n", i, guca_RMsgFR2Tab[i]);
         FPRINTF_TO_TRAILFILE(trail_fid, "\n");

         FPRINTF_TO_TRAILFILE(trail_fid, "C_MSG_FR2:\n");
         for(i=0; i<R_C_MSG_FR2_NUM_BYTES ; i++)
            FPRINTF_TO_TRAILFILE(trail_fid, "guca_R_C_Msg_FR2[%d] = 0x%02x\n", i, guca_R_C_Msg_FR2[i]);
         FPRINTF_TO_TRAILFILE(trail_fid, "\n");
      }

      FPRINTF_TO_TRAILFILE(trail_fid, "Relative Downstream Fast Retrain Power Cutback:\n");
      FPRINTF_TO_TRAILFILE(trail_fid, "gs_RDC = %d dB\n", gs_RDC);
      FPRINTF_TO_TRAILFILE(trail_fid, "\n");

      FPRINTF_TO_TRAILFILE(trail_fid, "Absolute Upstream Fast Retrain Power Cutback:\n");
      FPRINTF_TO_TRAILFILE(trail_fid, "gs_UC = %d dB\n", gs_UC);
      FPRINTF_TO_TRAILFILE(trail_fid, "\n");

      FPRINTF_TO_TRAILFILE(trail_fid, "\nC_R_MEDLEY_FR: SNR in dB\n");
      for(s_count=0; s_count<gs_RxNumTones; s_count++)
         FPRINTF_TO_TRAILFILE(trail_fid, "gsa_FRSnrBuf[%d] = %d\n", s_count, (gsa_FRSnrBuf[s_count]>>8));

      FPRINTF_TO_TRAILFILE(trail_fid, "\nBit Loading Information:\n\n");
      FPRINTF_TO_TRAILFILE(trail_fid, "guc_ProfileLoadOK = %d\n", guc_ProfileLoadOK);
   }

   if(guc_ProfileLoadOK == SUCCEED) {

      if (gft_DS_BAT_PrintedToTrail == 0){
         // Print Downstream bit allocation table if it wasn't already printed.
         PrintFinal_DS_BAT();
      }

      if(gft_FineGainOn) {
         if (gft_DS_FineGains_PrintedToTrail == 0)
            PrintFinal_DS_FineGains();


         FPRINTF_TO_TRAILFILE(trail_fid,"Average fine gain = %d (in decimal)\n", (gs_RxAvFineGain>>8));


         FPRINTF_TO_TRAILFILE(trail_fid, "\nDecoded Fine Gain Table (upstream) in Q3.13\n");
            for(i=0; i<gs_TxNumTones; i++) {
               FPRINTF_TO_TRAILFILE(trail_fid, "%d %d\n", i, gsa_TxFineGains[i]);
            }
      }

      if (gft_US_BAT_PrintedToTrail == 0){
         // Print Downstream bit allocation table if it wasn't already printed.
         PrintFinal_US_BAT();
      }

      if (gft_US_FineGains_PrintedToTrail == 0)
         PrintFinal_US_FineGains();

      FPRINTF_TO_TRAILFILE(trail_fid, "\n Downstream Profile Selected: %d\n", gs_DS_Profile);
      FPRINTF_TO_TRAILFILE(trail_fid, "\n Upstream Profile Received: %d\n", gs_US_Profile);


      if (gft_USDS_Payloads_PrintedToTrail == 0){
         // Print path, bearer channel payloads if not already printed.
         if (gs_RxNumTones == 128) // Lite Mode
            PrnConfigParamsLite();
         else
         {
            if (gft_ModemType == G_DMT_BIS)
               PrnConfigParams_BIS();
            else //Full Mode
               PrnConfigParams_DMT();
         }
      }

   }
#endif
}


