/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: aoc_gen.c
;
;  This program generates test signal for testing AOC operations:
;   The testvector is assumed to be the signal received from ATU-R.
;
;  To run the program:
;
;  a.out
;
;  the testvector is stored in "rx_aoc.asc"
;
;
;***************************************************************************/
#include <stdio.h>
#include <stdlib.h>

#include "config.h"
#include "common.h"
#include "aoc.h"
#include "bitswap.h"
#include "tx_aoc.h"
#include "rx_aoc.h"

/* =============================================================================== */
/* External Function Prototypes */
/* =============================================================================== */
uint8 TX_OH_Handler(int16 s_frame_number);

AocMsgStruc_t gt_TxMsg;
int16 gs_bitswap_tx_sframe_count = -1;
FlagT gft_SendBSR_Flag = IDLE;
uint8 guc_AocTxMaxRetries = AOC_TX_MAX_RETRIES;

FILE *fp_tx_out;

void main(int argc, char *argv[])
{
   AocMsgStruc_t *pt_TxMsg;

   int16 s_frame_cnt, s_sframe_cnt;
   uint8 uc_byte, uc_msg_cnt;


   /* Open output file  */
   fp_tx_out = fopen("rx_aoc.asc", "w");

   /* Init AOC */
   TxAocInit();

   uc_msg_cnt = 0;
   s_sframe_cnt = 0;
   pt_TxMsg = &gt_TxMsg;
   pt_TxMsg->uc_msg_flag = IDLE;

   while(1) {

      for(s_frame_cnt = 0; s_frame_cnt < TX_SYMBOLS_PER_SFRAME; s_frame_cnt++) {

         if((s_sframe_cnt >= 3) && (uc_msg_cnt == 0)) {
            if(pt_TxMsg->uc_msg_flag == IDLE) {

               /* Send BSA message  */
               TxAocMsgBSA((uint8)(s_sframe_cnt+NUM_SUPERFRAMES_WT_FOR_BITSWAP), &gt_TxMsg);
               TxAocMsgPut(pt_TxMsg);
               uc_msg_cnt++;
            }
         }

         if((s_sframe_cnt >= 11) && (uc_msg_cnt == 1)) {
            if(pt_TxMsg->uc_msg_flag != OUTSTANDING) {

               /* Send BSR message */
               gt_TxMsg.uc_msg_length = 9;
               gt_TxMsg.uca_msg_body[0] = 0xFF;    /* BSR header */
               gt_TxMsg.uca_msg_body[1] = 0x01;    /* inc 1 bit */
               gt_TxMsg.uca_msg_body[2] = 7;       /* bin 7 */
               gt_TxMsg.uca_msg_body[3] = 0x02;    /* dec 1 bit */
               gt_TxMsg.uca_msg_body[4] = 9;       /* bin 9 */
               gt_TxMsg.uca_msg_body[5] = 0x03;    /* inc 1 dB */
               gt_TxMsg.uca_msg_body[6] = 7;       /* bin 7 */
               gt_TxMsg.uca_msg_body[7] = 0x07;    /* dec 2 dB */
               gt_TxMsg.uca_msg_body[8] = 10;         /* bin 10 */

               TxAocMsgPut(pt_TxMsg);
               pt_TxMsg->s_msg_timer = 150;
               pt_TxMsg->uc_msg_retry_count = 1;

               uc_msg_cnt++;
            }
         }

         if((s_sframe_cnt >= 17) && (uc_msg_cnt == 2)) {
            if(pt_TxMsg->uc_msg_flag != OUTSTANDING) {

               /* Send BSA message */
               gt_TxMsg.uc_msg_length = 3;
               gt_TxMsg.uca_msg_body[0] = 0xFF; /* header */
               gt_TxMsg.uca_msg_body[1] = 0xFF; /* command */
               gt_TxMsg.uca_msg_body[2] = 80;      /* super frame count number */

               TxAocMsgPut(pt_TxMsg);

               uc_msg_cnt++;
            }
         }

         if((s_sframe_cnt >= 8+NUM_SUPERFRAMES_WT_FOR_BITSWAP) && (uc_msg_cnt == 3)) {
            if(pt_TxMsg->uc_msg_flag != OUTSTANDING) {

               /* Send BSA message */
               TxAocMsgBSA((uint8)(s_sframe_cnt+NUM_SUPERFRAMES_WT_FOR_BITSWAP), &gt_TxMsg);
               TxAocMsgPut(pt_TxMsg);
               uc_msg_cnt++;
            }

         }

         if((s_sframe_cnt == (16+NUM_SUPERFRAMES_WT_FOR_BITSWAP)) && (uc_msg_cnt == 4)) {

            if(pt_TxMsg->uc_msg_flag != OUTSTANDING) {

               /* Send EBSR message */
               gt_TxMsg.uc_msg_length = 13;
               gt_TxMsg.uca_msg_body[0] = 0xFC; /* EBSR header */
               gt_TxMsg.uca_msg_body[1] = 0x01; /* inc 1 bit */
               gt_TxMsg.uca_msg_body[2] = 8;    /* bin 8 */
               gt_TxMsg.uca_msg_body[3] = 0x01; /* inc 1 bit */
               gt_TxMsg.uca_msg_body[4] = 8;    /* bin 8 */
               gt_TxMsg.uca_msg_body[5] = 0x02; /* dec 1 bit */
               gt_TxMsg.uca_msg_body[6] = 24;      /* bin 24 */
               gt_TxMsg.uca_msg_body[7] = 0x02; /* dec 1 bit */
               gt_TxMsg.uca_msg_body[8] = 24;      /* bin 24 */
               gt_TxMsg.uca_msg_body[9] = 0x05; /* inc 3 dB */
               gt_TxMsg.uca_msg_body[10] = 8;      /* bin 8 */
               gt_TxMsg.uca_msg_body[11] = 0x06;   /* dec 1 dB */
               gt_TxMsg.uca_msg_body[12] = 24;     /* bin 24 */

               TxAocMsgPut(pt_TxMsg);

               pt_TxMsg->s_msg_timer = 150;
               pt_TxMsg->uc_msg_retry_count = 1;

               uc_msg_cnt++;
            }

         }


         if((s_sframe_cnt == (13+2*NUM_SUPERFRAMES_WT_FOR_BITSWAP)) && (uc_msg_cnt == 5)) {

            if(pt_TxMsg->uc_msg_flag != OUTSTANDING) {

               /* Send UTC message */
               TxAocMsgUTC(&gt_TxMsg);
               TxAocMsgPut(pt_TxMsg);
               uc_msg_cnt++;
            }
         }


         if(uc_msg_cnt == 6) {
            if(pt_TxMsg->uc_msg_flag != OUTSTANDING) {
               goto _exit;
            }
         }

         /* Get an overhead byte for this frame */
         uc_byte = TX_OH_Handler(s_frame_cnt);

         fprintf(fp_tx_out, "0x%2.2x\n", uc_byte);


      } /* for(s_frame_cnt */

      s_sframe_cnt++;

   } /* for(s_sframe_cnt */

_exit:

   /* Put out additional 100 0-bytes */
   /* for(i=0; i<100; i++) */
   /*    fprintf(fp_tx_out, "0x%2.2x\n", 0); */

   exit(0);

}

uint8 TX_OH_Handler(int16 s_frame_number)
{

   uint8 uc_byte;


   /* Decide the content of the synch byte based on the frame number */
   if(s_frame_number == 0) {

      /* Update super frame count */
      gs_bitswap_tx_sframe_count++;
      gl_tx_sframe_count++;
      if(gs_bitswap_tx_sframe_count == MAX_SFRAME_COUNT)
         gs_bitswap_tx_sframe_count = 0;

      /* place 0 for CRC byte */
      uc_byte = 0;

   }
   else {
      /* return AOC byte */
      uc_byte = TxAocHandler(s_frame_number);
   }

   return(uc_byte);
}

/*****************************************************************************
;  Subroutine Name: AocMsgId(...)
;
;  This subroutine uses the message header and command to decide the
;  type of the message represented by a message ID.
;  If the message command doesn't match the message header, it
;  return AOC_MSG_ID_UNDEFINED.
;
;  Prototype:
;     uint8 AocMsgId(uint8 *puca_msg_buf, uint8 uc_msg_length)
;
;  Input Arguments:
;     puca_msg_buf   -- pointer to the input message buffer
;     uc_msg_length  -- length of the first message in the input buffer
;
;  Output Arguments:
;     none
;
;  Return:
;     message ID     -- identify the type of message
;
;  Global Variables:
;
*******************************************************************************/
uint8 AocMsgId(uint8 *puca_msg_buf, uint8 uc_msg_length) {

   uint8 uc_msg_header, uc_msg_cmd;

   uc_msg_header = puca_msg_buf[0];

   if(uc_msg_length > 1)
      uc_msg_cmd = puca_msg_buf[1];

   switch(uc_msg_header) {

   case AOC_HEADER_UTC:

      return(AOC_MSG_ID_UTC);

   case AOC_HEADER_PMR:

      if(uc_msg_cmd == AOC_CMD_PMR)
         return(AOC_MSG_ID_PMR);
      else if(uc_msg_cmd == AOC_CMD_PMA)
         return(AOC_MSG_ID_PMA);
      else
         return(AOC_MSG_ID_UNDEFINED);

   case AOC_HEADER_BSR:

      if(uc_msg_cmd == AOC_CMD_BSA)
         return(AOC_MSG_ID_BSA);
      else if(uc_msg_cmd <= AOC_CMD_PWR_DEC2)
         return(AOC_MSG_ID_BSR);
      else
         return(AOC_MSG_ID_UNDEFINED);

   case AOC_HEADER_EBSR:

      if(uc_msg_cmd <= AOC_CMD_PWR_DEC2)
         return(AOC_MSG_ID_EBSR);
      else
         return(AOC_MSG_ID_UNDEFINED);
   default:
      return(AOC_MSG_ID_UNDEFINED);
   }

}



