/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  ghs_gen.c
;
;  This program generates test signal for testing G.hs ATU-R system.
;   The test signal from the ATU-C is following the scenario:
;
;   R_Tones_Req (R) -> C_Tones1 (C) -> R_Silence1 (R) -> R_Tone1 (R) ->
;   C_Galf1 (C) -> R_Flag1 (R) -> CLR (R) ->  CL 1st segment (C) ->
;   ACK2 (R) -> CL 2nd segment (C) -> ACK1 (R) -> MS (R) -> ACK1 (C) ->
;   GALFs (R) -> FLAGs (C) -> exit to full initialization
;
;
;  To run the program:
;
;  a.out          -> produce the testvector (rx input) for testing G.hs
;                          the testvector is stored in "hndshk.bin"
;
;   Notes: requires the following files in the project to compile:
;          shared\dsp_op.c
;          shared\fft_fix.c
;          shared\fft_tab.c
;          hndshk\hs_mesg.c
;          hndshk\hs_misc.c
;          hndshk\ghs_gen.c
;          also set the include path to the directory which holds all the include
;          files (same as the one used for the state machine code)
;
;***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#include "common.h"
#include "rt_tones.h"
#include "rt_state.h"
#include "dsp_op.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "ghs.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "ifft_fix.h"
#include "qam_enc.h"
#include "hndshk_Data.h"


/* =============================================== */
/* external variable declarations */
/* =============================================== */
/* hndshk.c */
HandShakeControl_t gt_hsc;

int16 gs_TxAn_Prev;                         /*  last bit symbol for xceiver */
int16 gs_RxAn_Prev;                         /*  last bit symbol for receiver */
uint8 guc_TxOctet, guc_RxOctet;             /*  Octet buffers for Tx and Rx */
int16 gsa_RxSubBitBuf[ SYMBOLS_PER_BIT ];   /*  contains the DPSK encoded subbit symbols (+1 or -1) for one bit */

/* ---- message arrarys ---- */
uint8* gpuca_RxMsgBuf;     /*size: MESSAGE_BUF_LEN      Rx side */
uint8* gpuca_DecodeBuf;    /*size: DECODE_BUF_LEN */
uint8* gpuca_TxMsgBuf;     /*size: MESSAGE_BUF_LEN      Tx side */
int16 gs_RxMsgBufCnt;
int16 gs_DecodeBufCnt;

/* ---- structures containing information fields ---- */
InfoField_t* gpt_RxInfo;  /*  Rx side */
InfoField_t* gpt_TxInfo;  /*  Tx side */
InfoField_t* gpt_TxInfoSave;

/* ---- must have been declared in the existing code, e.g. main.c ---- */
FlagT gft_EnableGetRxToneFlag = FALSE;
ModemConfig_t gpt_ModemConfig;
FILE *outfd, *infd;

/* =============================================== */
/* external function prototypes */
/* =============================================== */
extern void IfftReal(int16* ps_inbuf, int16* ps_outbuf, int16 i_fftn, int16 i_log2n);

/* =============================================== */
/* constants used by this file only */
/* =============================================== */
#define DELAY           (16)  /*  two-way transmission delay */
#define FIR_LEN         (4)
#define IIR_LEN         (4)

#if (TX_NUM_TONES == 256)
   #define TX_LOG2_FFT_LENGTH    9     /* log2(2*TX_NUM_TONES) */
#endif

#if (TX_NUM_TONES == 128)
   #define TX_LOG2_FFT_LENGTH    8     /* log2(2*TX_NUM_TONES) */
#endif

#if (TX_NUM_TONES == 32)   /* =32 */
   #define TX_LOG2_FFT_LENGTH    6     /* log2(2*TX_NUM_TONES) */
#endif

#if (RX_NUM_TONES == 256)
   #define RX_LOG2_FFT_LENGTH    9     /* log2(2*TX_NUM_TONES) */
#endif

#if (RX_NUM_TONES == 128)
   #define RX_LOG2_FFT_LENGTH    8     /* log2(2*TX_NUM_TONES) */
#endif

#if (RX_NUM_TONES == 32)   /* =32 */
   #define RX_LOG2_FFT_LENGTH    6     /* log2(2*TX_NUM_TONES) */
#endif

#define RX_FFT_LENGTH   (2*RX_NUM_TONES)

#ifdef ISDN
int16 gs_TxNumTones = (int16) TX_NUM_TONES;
#else
int16 gs_TxNumTones = 32;
#endif

int16 gs_TxLog2FftLength1 = (TX_LOG2_FFT_LENGTH-1);
int16 gs_TxFftLength = 2*gs_TxNumTones;
int16 gs_TxCPLength = TX_PREFIX_LENGTH;

int16 gs_RxNumTones = RX_NUM_TONES;
int16 gs_RxLog2FftLength1 = (RX_LOG2_FFT_LENGTH-1);
int16 gs_RxFftLength = RX_FFT_LENGTH;
int16 gs_RxCPLength = RX_PREFIX_LENGTH;

/* =============================================== */
/* global variable declarations */
/* =============================================== */
int16 gsa_IFFT_OutBuf[RX_FFT_LENGTH+2];         /*  TX IFFT output buffer */
int16 gsa_TxToneBuf[(RX_NUM_TONES+1)*2];     /*  TX DMT tone buffer */
int16 gsa_TxOutBuf[RX_INBUF_FRAME_SIZE];     /*  TX output buffer */
int16 gsa_RxInBuf[RX_INBUF_FRAME_SIZE];
int16 gsa_RxToneBuf[(RX_NUM_TONES+1)*2];
int16 gs_TxState, gs_TxNextState;
int16 gs_RxState, gs_RxNextState, gs_RxSubStateCnt;
int32 gl_TxSymbolCount, gl_RxSymbolCount;

/* =============================================== */
/* static variable declarations */
/* =============================================== */
int16 x_mem[FIR_LEN] = {0, 0, 0, 0};
int16 y_mem[IIR_LEN] = {0, 0, 0, 0};
int16 b[FIR_LEN] = { (int16)0x0f94, (int16)0x2ebd, (int16)0x2ebd, (int16)0x0f94 };
int16 a[IIR_LEN] = { (int16)0x7fff, (int16)0xd1e2, (int16)0x2f11, (int16)0xfbb0 };

/* =============================================== */
/* static function prototypes */
/* =============================================== */
uint16 CalcFCS( uint8 uca_M[], int16 s_Length );
void TxOctet( uint8 uc_Oct, int16 TxGain );
void TxFCS( uint16 us_FCS, int16 TxGain );
int16 noise(void);
void filter(int16* x, int16* y, int16 len);
void TxOut(int16 *psa_inbuf, int16 i_InbufSize, int16 i_CP_length);

void main(int argc, char *argv[])
{

    int16 sa_zero[RX_INBUF_FRAME_SIZE];
    int16  i, j;

    int16 TxGain = TX_NEG165DBM;    /* -1.65 dBm */

    int16 i_length;

   FlagT ft_noise_flag  = FALSE;    /* FALSE: not adding noise; TRUE: adding noise */
   FlagT ft_filter_flag = FALSE;    /* FALSE: not applying channel filter; TRUE: apply channel filter */

    int16 s_MsgLen;
    uint16 us_FCS;


   /* =========================================================================== */
   /* Initialization */
   /* =========================================================================== */

   gs_TxAn_Prev = 1;

    /* Make an array of zeros */
   for(i=0; i<gs_RxFftLength; i++)
      sa_zero[i] = 0;


    /* =========================================================================== */
   /*  Open files */
   /* =========================================================================== */

   /* Open output file */
   if((outfd = fopen("tmp_file.bin", "wb")) == NULL) {
      fprintf(stderr, "Cannot open output file\n");
      exit(-1);
   }


   if(argc == 2) {

      /* Open Showtime RX input file */
      if((infd = fopen(argv[1], "rb")) == NULL) {
         fprintf(stderr, "Cannot open file %s\n", argv[1]);
         exit(-1);
      }
   }


    /* =========================================================================== */
    /*  1.5sec of Silence at the beginning */
   /* =========================================================================== */
    printf("C_IDLE (%d)\n", TIME_500MS*3);
    for (j = 0; j < TIME_500MS*3; j++)
      TxOut(sa_zero, gs_RxFftLength, 0);


    /* =========================================================================== */
    /*  C_TONES for 0.5sec */
   /* =========================================================================== */
    printf("C_TONES (%d)\n", TIME_500MS );

    /* ---- clear tone buffer ---- */
    for (i=0; i < (gs_RxFftLength+2); i++)
        gsa_TxToneBuf[i] = 0;

    for ( j = 0; j < NUM_CARRIERS_IN_SET; j++ ) {
        gsa_TxToneBuf[ 2*gsa_DnCarSet[j] ]   = TxGain;
        gsa_TxToneBuf[ 2*gsa_DnCarSet[j]+1 ] = TxGain;
    }

    IfftReal(gsa_TxToneBuf, gsa_IFFT_OutBuf, (int16)(gs_RxFftLength>>1), gs_RxLog2FftLength1);

    for (j = 0; j < TIME_500MS; j++)
      TxOut(gsa_IFFT_OutBuf, gs_RxFftLength, 0);


    /* =========================================================================== */
    /*  C_GALF1 for SYMBOLS_PER_OCTET*8 (for sending 8 Galfs ) */
   /* =========================================================================== */
    printf("C_GALF1 (%d)\n", SYMBOLS_PER_OCTET * 4 );
    for ( i = 0; i < 4; i++ )
        TxOctet( GALF, TxGain );


    /* =========================================================================== */
    /*  C_FLAG1 for SYMBOLS_PER_OCTET*2 (for sending 2 Flags ) */
   /* =========================================================================== */
    printf("C_FLAG1 (%d)\n", SYMBOLS_PER_OCTET * 2 );
    for ( i = 0; i < 4; i++ )
        TxOctet( FLAG, TxGain );


    /* =========================================================================== */
    /*  Message exchange phase */
    /*  Number of FLAGs at the tail of each message should depend on the message */
    /*  length that is transmitted by the ATU-C */
   /* =========================================================================== */

    InitializeInfoField( gpt_TxInfo );

    /*  ATU-R shall start with a CLR */
    for ( i = 0; i < 70; i++ )
        TxOctet( FLAG, TxGain );

    /*  CL */
    gpt_TxInfo->uc_Type = M_CL;
    gpt_TxInfo->uc_ID_NPar1     = NON_STANDARD;
    gpt_TxInfo->uc_ID_SPar1[0]     = NDR_UP | NDR_DN | DFC_UP | DFC_DN | R_SPLITTER | C_SPLITTER;
   gpt_TxInfo->uc_SI_SPar1[0]     = G992_1_A;
    gpt_TxInfo->uc_SI_2AB_NPar2 = R_ACK1 | R_ACK2 | ATM | STM | CLEAR_EOC_G997_1;
    gpt_TxInfo->uc_SI_2AB_SPar2 = SPECTRUM_UP | SPECTRUM_DN;
    gpt_TxInfo->uc_NumBlock = 3;  /*  3 non-standard blocks */

    gpt_TxInfo->ta_NS_Info[0].uc_NSLen = 10;
    for ( i = 0; i < gpt_TxInfo->ta_NS_Info[0].uc_NSLen-6; i++ ) /*  block 1 */
        gpt_TxInfo->ta_NS_Info[0].uca_NSVendorSpec[i] = (uint8) i;

    gpt_TxInfo->ta_NS_Info[1].uc_NSLen = 23;
    for ( i = 0; i < gpt_TxInfo->ta_NS_Info[1].uc_NSLen-6; i++ ) /*  block 2 */
        gpt_TxInfo->ta_NS_Info[1].uca_NSVendorSpec[i] = (uint8) i;

    gpt_TxInfo->ta_NS_Info[2].uc_NSLen = 39;
    for ( i = 0; i < gpt_TxInfo->ta_NS_Info[2].uc_NSLen-6; i++ ) /*  block 3 */
        gpt_TxInfo->ta_NS_Info[2].uca_NSVendorSpec[i] = (uint8) i;

    s_MsgLen = FormMessage( gpt_TxInfo, gpuca_TxMsgBuf );   /*  first segment */

#define FIRST_SEGMENT_SIZE  12
    printf("1st segment of CL (%d)\n", (FIRST_SEGMENT_SIZE + 11)*SYMBOLS_PER_OCTET);
    for ( i = 0; i < FIRST_SEGMENT_SIZE; i++ )
        TxOctet( gpuca_TxMsgBuf[i], TxGain );
    us_FCS = CalcFCS( gpuca_TxMsgBuf, FIRST_SEGMENT_SIZE );
    TxFCS( us_FCS, TxGain );

    /*  ATU-R will respond with ACK2 */
    for ( i = 0; i < 12; i++ )
        TxOctet( FLAG, TxGain );

    printf("2nd segment of CL (%d)\n", (s_MsgLen-FIRST_SEGMENT_SIZE + 11)*SYMBOLS_PER_OCTET);
    for ( i = FIRST_SEGMENT_SIZE; i < s_MsgLen-FCS_LEN; i++ )
        TxOctet( gpuca_TxMsgBuf[i], TxGain );
    us_FCS = CalcFCS( &gpuca_TxMsgBuf[FIRST_SEGMENT_SIZE], (int16) (s_MsgLen-FCS_LEN-FIRST_SEGMENT_SIZE) );
    TxFCS( us_FCS, TxGain );

    /*  ATU-R will respond with ACK2 */
    for ( i = 0; i < 12; i++ )
        TxOctet( FLAG, TxGain );

    /*  3rd segment of CL */
    gpt_RxInfo->uc_Type = M_ACK2;
    s_MsgLen = FormMessage( gpt_TxInfo, gpuca_TxMsgBuf );    /*  second segment */
    gpt_RxInfo->uc_Type = 0;        /*  this is very important */

#define THIRD_SEGMENT_SIZE  25
    printf("3rd segment of CL (%d)\n", (THIRD_SEGMENT_SIZE + 45)*SYMBOLS_PER_OCTET);
    for ( i = 0; i < THIRD_SEGMENT_SIZE; i++ )
        TxOctet( gpuca_TxMsgBuf[i], TxGain );
    us_FCS = CalcFCS( gpuca_TxMsgBuf, THIRD_SEGMENT_SIZE );
    TxFCS( us_FCS, TxGain );

    /*  ATU-R will respond with ACK2 */
    for ( i = 0; i < 12; i++ )
        TxOctet( FLAG, TxGain );

    printf("4th segment of CL (%d)\n", (s_MsgLen - THIRD_SEGMENT_SIZE + 45)*SYMBOLS_PER_OCTET);
    for ( i = THIRD_SEGMENT_SIZE; i < s_MsgLen-FCS_LEN; i++ )
        TxOctet( gpuca_TxMsgBuf[i], TxGain );
    us_FCS = CalcFCS( &gpuca_TxMsgBuf[THIRD_SEGMENT_SIZE], (int16) (s_MsgLen-FCS_LEN-THIRD_SEGMENT_SIZE) );
    TxFCS( us_FCS, TxGain );

    gt_hsc.s_TxNSBCnt = 0;    /*  reset counter */


    /*  ATU-R will respond with ACK1 */
    for ( i = 0; i < 12; i++ )
        TxOctet( FLAG, TxGain );

    /*  ATU-R will send with MS */
    for ( i = 0; i < 46; i++ )
        TxOctet( FLAG, TxGain );

    /*  ACK1 */
    gpt_TxInfo->uc_Type = M_ACK1;
    s_MsgLen = FormMessage( &gpt_TxInfo, gpuca_TxMsgBuf );
    for ( i = 0; i < s_MsgLen; i++ )
        TxOctet( gpuca_TxMsgBuf[i], TxGain );

    printf("ACK1 (%d)\n", (s_MsgLen+10)*SYMBOLS_PER_OCTET);

    /*  ATU-R will send GALFs */
    for ( i = 0; i < 10; i++ )
        TxOctet( FLAG, TxGain );

    /*  16 FLAGs */
    for ( i = 0; i < 16; i++ )
        TxOctet( FLAG, TxGain );

    /*  C_QUIET2  */
    printf("C_QUIET2 (%d)\n", (gs_num_cleardown_flags-1) * SYMBOLS_PER_OCTET );

    for (j = 0; j < (gs_num_cleardown_flags-1) * SYMBOLS_PER_OCTET; j++) {
      TxOut(sa_zero, gs_RxFftLength, 0);
    }

    /*  after all, the ATU's will exit to xceiver training */


   if(outfd != NULL)
      fclose(outfd);

   if(infd != NULL)
      fclose(infd);


   /* Process the output file by channel */
   if((infd = fopen("tmp_file.bin", "rb")) == NULL) {
      fprintf(stderr, "Cannot open file tmp_file.bin\n");
      exit(-1);
   }

   /* Open output file */
   if((outfd = fopen("hndshk.bin", "wb")) == NULL) {
      fprintf(stderr, "Cannot open file hndshk.bin\n");
      exit(-1);
   }


   /* Add noise to output file if desired */
   while(1) {
      i_length = fread(gsa_TxOutBuf, sizeof(int16), RX_INBUF_FRAME_SIZE, infd);

      if(i_length > 0) {
         if(ft_noise_flag) {
            for(i=0; i<i_length; i++)
               gsa_TxOutBuf[i] += noise();
         }
         if(ft_filter_flag) {
            filter(gsa_TxOutBuf, gsa_TxOutBuf, i_length);
         }

         fwrite(gsa_TxOutBuf, sizeof(int16), i_length, outfd);
      }
      else
         break;
   }

   if(outfd != NULL)
      fclose(outfd);

   if(infd != NULL)
      fclose(infd);


   /* remove the tmp_file.bin */
   if( remove( "tmp_file.bin" ) == -1)
      fprintf(stderr, "cannot remove tmp_file.bin\n");

   exit(0);

}



/* ------------------------------------------------- */
/*  functions used in this file */
/* ------------------------------------------------- */

uint16 CalcFCS( uint8 uca_M[], int16 s_Length ) {

    int16 i;
    uint16 us_FCS;
    uint8 uc_Octet;

    us_FCS = 0xFFFF;
    for ( i = 0; i < s_Length; i++ ) {

        /*---- octet transparency ----*/
        if ( uca_M[i] == 0x7D ) {
            i++;
            uc_Octet = uca_M[i] ^ 0x20;
        }
        else {
            uc_Octet = uca_M[i];
        }

        us_FCS = CalcCRC_Byte( uc_Octet, us_FCS, FCS_GEN_POLY );
    }
    us_FCS = ~us_FCS;   /*  take 1's compliment */

    return (us_FCS);

}


void TxOctet( uint8 uc_Oct, int16 TxGain ) {

    int16 j, k;
    int16 s_bn, s_An;

    s_An = gs_TxAn_Prev;

    for ( j = 0; j < (SYMBOLS_PER_OCTET / SYMBOLS_PER_BIT); j++ ) {

        /* ---- differential encoding ---- */
        s_bn = ( uc_Oct >> j ) & LSB_MASK;
        s_An = (s_bn == 0)? s_An : -s_An;

        for ( k = 0; k < NUM_CARRIERS_IN_SET; k++ ) {
            gsa_TxToneBuf[ 2*gsa_DnCarSet[k] ]   = s_An * TxGain;
            gsa_TxToneBuf[ 2*gsa_DnCarSet[k]+1 ] = s_An * TxGain;
        }

        IfftReal(gsa_TxToneBuf, gsa_IFFT_OutBuf, (int16)(gs_RxFftLength>>1), gs_RxLog2FftLength1);

        for (k = 0; k < SYMBOLS_PER_BIT; k++)
           TxOut(gsa_IFFT_OutBuf, gs_RxFftLength, 0);

    }

    gs_TxAn_Prev = s_An;
}


void TxFCS( uint16 us_FCS, int16 TxGain ) {

    int16  i;
    uint8 uc_Octet;

    for ( i = 0; i < 2; i++ ) {
        uc_Octet = (uint8) ( us_FCS >> (8*i) );
        if ( (uc_Octet == FLAG) || (uc_Octet == 0x7D) ) {
            TxOctet( 0x7D, TxGain );
            uc_Octet ^= 0x20;
            TxOctet( uc_Octet, TxGain );
        }
        else {
            TxOctet( uc_Octet, TxGain );
        }
    }
}

int16 noise(void) {

    int16 s_noise;

    s_noise = (rand() - RAND_MAX/2) >> 8;
    /* s_noise = 0; */

    return s_noise;

}


void filter(int16* x, int16* y, int16 len) {

    int16    n,i;
    int32   y0;
    int32   Acc0;

    for (n = 0; n < len; n++) {

        /*  clear output */
        y0 = 0;

        /* ================= */
        /*  compute FIR part */
        /* ================= */

        /* update FIR memory */
        for (i = (FIR_LEN - 1); i > 0; i--) {
            x_mem[i] = x_mem[i-1];
        }
        x_mem[0] = x[n];

        /* apply FIR */
        for (i = 0; i < FIR_LEN; i++) {
            Acc0 = x_mem[i] * b[i];
            y0 = l_add(y0, Acc0);
        }

        /* ================= */
        /*  compute IIR part */
        /* ================= */

        /* update IIR memory */
        for (i = (IIR_LEN - 1); i > 0; i--) {
            y_mem[i] = y_mem[i-1];
        }

        /* apply IIR */
        for (i = 1; i < IIR_LEN; i++) {
            Acc0 = y_mem[i] * a[i];
            Acc0 *= -1;

            y0 = l_add(y0, Acc0);
        }

        y_mem[0] = (int16) (round(y0,15));
        y[n] = y_mem[0];

    }
}

void TxOut(int16 *psa_inbuf, int16 i_InbufSize, int16 i_CP_length) {

    int16 i, i_length;

   int16 s_outbuf[RX_FFT_LENGTH+RX_PREFIX_LENGTH];

   i_length = i_InbufSize + i_CP_length;

   for(i = 0; i < i_CP_length; i++)
      s_outbuf[i] = psa_inbuf[i_InbufSize - i_CP_length + i];

   for(i=0; i<i_InbufSize; i++)
      s_outbuf[i+i_CP_length] = psa_inbuf[i];

   /* Write to output file */
   fwrite(s_outbuf, sizeof(int16), i_length, outfd);

}
/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *    TxQuiet
 *
 * Prototype:
 *    void TxQuiet(int16 s_Noutput_samples);
 *
 *  Abstract:
 *    TxQuiet() - Fills global transmit output buffer gsa_TxOutBuf with all
 *    zeros
 *
 *  Returns:
 *    None
 *
 *  Global Variables Used:
 *      gsa_TxOutBuf[]    - (O) array of time domain samples to transmit
 *
 *------------------------------------------------------------------------
 */
void TxQuiet(int16 s_Noutput_samples) {

    int16 i;

    for (i=0; i<s_Noutput_samples; i++)
        gsa_TxOutBuf[i] = 0;

}




/* undefine constants used by this file only */
#undef DELAY
#undef FIR_LEN
#undef IIR_LEN

