/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "config.h"
#include "common.h"
#include "gdata.h"
#include "aoc.h"
#include "aoc_ini.h"
#include "tx_m3oh.h"
#include "rx_m3oh.h"
#include "bitload.h"
#include "mp.h"
#include "cmv.h"
#include "AllocateDataBuffers_PreHndshk.h"
#include "AllocateDataBuffers_PostHndshk.h"
#include "prf_man.h"
#include "tx_aoc.h"
#include "rx_aoc.h"
#include "statein1.h"

/* ============================================================================= */
/* The following main program is to test TX and RX AOC code */
/* To compile this program, the following files should be added to the project: */
/* test_aoc.c tx_aoc.c rx_aoc.c tx_sb.c rx_sb.c rx_ib.c tx_ib.c */
/* and include sandbox\include directory into VC++ include path. */
/* ============================================================================= */


#define NUM_SFRAME_TO_TEST 1000

extern int16 gsa_FineGains[128];

#if 0
int16 gsa_DS_BAT68[128] =
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,      /* 0-32              */
 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8,                           /* 33-49 */
 8, 8, 8, 9, 9, 9, 9, 10, 10, 10, 10, 11, 11, 11, 0, 11, 12, 12, 12, 12,         /* 50-69 */
 13, 13, 13, 13, 14, 14, 14, 14, 15, 15, 15, 15, 2, 2, 2, 2, 2, 2, 2, 2,         /* 70-89 */
 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,                  /* 90-119 */
 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0                      /* 120-117 */
};

int16 gsa_US_BAT28[32] = {0, 0, 0, 0, 0, 0, 6, 6, 5, 5,
                  4, 4, 3, 5, 2, 15, 0, 15, 14, 14,
                  13, 13, 12, 12, 11, 11, 10, 10, 9, 9,
                     8, 8};

#else
extern uint8 guca_DS_BAT68[128];
extern uint8 guca_US_BAT28[32];
#endif
Config_t gt_tx_config =
{
   NUM_DS_BEARER_CHANNELS,
   NUM_DATA_PATHS,
   {8, 0},           /* s_Rp[p] */
   {8, -1},       /* s_Mp[p] */
   {-1, -1},         /* s_Lp[p] */
   {-1, -1},         /* s_Tp[p] */
   {16, -1},         /* s_Dp[p] */
   {  {66,0,0,0,0,0,0}, /* s_Bpn[p][n] */
      {0,0,0,0,0,0,0}
   },

   REDUCED_MERGED,      /* Framing Mode */
   -1,               /* s_MSGlp     */
   -1,               /* s_IBITSlp   */
   -1,               /* s_MSGc      */
   guca_DS_BAT68,    /* psa_BAT     */
   gsa_FineGains     /* psa_FineGains*/
};

Config_t gt_rx_config =
{
   NUM_DS_BEARER_CHANNELS,
   NUM_DATA_PATHS,
   {8, 0},           /* s_Rp[p] */
   {4, -1},       /* s_Mp[p] */
   {-1, -1},         /* s_Lp[p] */
   {-1, -1},         /* s_Tp[p] */
   {4, -1},       /* s_Dp[p] */
   {  {25,0,0,0,0,0,0},/* s_Bpn[p][n] */
      {0,0,0,0,0,0,0}
   },

   REDUCED_MERGED,      /* Framing Mode */
   -1,               /* s_MSGlp */
   -1,               /* s_IBITSlp   */
   -1,               /* s_MSGc */
   guca_US_BAT28,    /* psa_BAT */
   gsa_FineGains     /* psa_FineGains */
};

AocMsgStruc_t gt_TxMsgPMA, gt_TxMsgUTC;

FILE *fp_aoc_trail, *fp_rx_in;

/*-------------------------------------------------------------------
*
*  int Pause(void)
*
*  Description: For debugging purposes.  Stops the DSL cores (necessary) and allows
*  external debug reads and writes to be performed, dummy here
*
*-------------------------------------------------------------------
*^^^
*/
void Pause(int16 s_Marker)
{
}


void main(int argc, char *argv[])
{
   AocMsgStruc_t *pt_TxMsg;

   int16 s_frame_cnt, s_sframe_cnt, s_stuffing_byte_cnt, i, s_id, s_length;
   uint8 uc_byte, uc_msg_id, uc_msg_cnt;

   if(argc == 2) {

      /* Open RX input file */
      if((fp_rx_in  = fopen(SetInputDir(argv[1]), "r")) == NULL) {
         fprintf(stderr, "Cannot open input file %s\n", SetInputDir(argv[1]));
         exit(-1);
      }
   }

   /* Open output file */
   fp_aoc_trail = fopen("trail.txt", "w");

   /* ======================= */
    /* Initialization */
   /* ======================= */

#ifdef ISDN //For G992.1 only.
   gs_TxNumTones = (int16) TX_NUM_TONES;
#else
   gs_TxNumTones = 32;
#endif

   gs_RxNumTones = RX_NUM_TONES;

   /* Set STAT CMV to indicate Lite mode */
   STATArray[STAT_Mode] |= STAT_ConfigMode_G992_2_AB;

   AllocateDataBuffers_PreHndshk();

   InitGlobalVariables();

   AllocateDataBuffers_PostHndshk();

   /* Initialize BAT and fine gains */
   for(i=0; i<gs_RxNumTones; i++) {
      guca_RxBat[i] = gt_rx_config.psa_BAT[i];
      gsa_RxFineGains[i] = gt_rx_config.psa_FineGains[i];
   }
   gt_rx_config.psa_BAT = guca_RxBat;
   gt_rx_config.psa_FineGains = gsa_RxFineGains;

   for(i=0; i<gs_TxNumTones; i++) {
      guca_TxBat[i] = gt_tx_config.psa_BAT[i];
      gsa_TxFineGains[i] = gt_tx_config.psa_FineGains[i];
   }
   gt_tx_config.psa_BAT = guca_TxBat;
   gt_tx_config.psa_FineGains = gsa_TxFineGains;

    /* Init. super frame count */
   gs_bitswap_tx_sframe_count = -1;

   /* Init. AOC transmitter */
   TxAocInit();

   /* ===================================== */
    /* Initialize the overhead byte handlers */
    /* ===================================== */

   /* Do RX AOC initialization */
   RxAocInit();

   /* Send a PMR with profile number = 1 */
   fprintf(fp_aoc_trail, "Send a PMR with profile number = 1\n");
   TxAocMsgPMR(1, &gt_TxMsgPMR);
   pt_TxMsg = &gt_TxMsgPMR;
   TxAocMsgPut(pt_TxMsg);

   uc_msg_cnt = 1;
   s_stuffing_byte_cnt = 0;

   for(s_sframe_cnt = 0; s_sframe_cnt < NUM_SFRAME_TO_TEST; s_sframe_cnt++) {
      for(s_frame_cnt = 0; s_frame_cnt < TX_SYMBOLS_PER_SFRAME; s_frame_cnt++) {

         /* Check the TX message status */
         if( (pt_TxMsg->uc_msg_flag != OUTSTANDING) && (pt_TxMsg->uc_msg_flag != IDLE)) {

            if(s_stuffing_byte_cnt > 0)
               fprintf(fp_aoc_trail, "no. of TX stuffing bytes = %d\n", s_stuffing_byte_cnt);
            s_stuffing_byte_cnt = 0;

            /* Get TX message ID */
            AocMsgId(pt_TxMsg->uca_msg_body[0], pt_TxMsg->uca_msg_body[1], &s_id, &s_length);
            uc_msg_id = (uint8) s_id;

            if(pt_TxMsg->uc_msg_flag == SUCCEED) {
               fprintf(fp_aoc_trail, "\nTX Message (ID = %d) succeeds\n\n", uc_msg_id);
               pt_TxMsg->uc_msg_flag = IDLE;
            }
            else if(pt_TxMsg->uc_msg_flag == FAIL) {
               fprintf(fp_aoc_trail, "\nTX Message (ID = %d) fails due to reason %d\n\n",
                  uc_msg_id, pt_TxMsg->uc_reason_of_fail);
               pt_TxMsg->uc_msg_flag = IDLE;
            }

            /* Send PMR message with profile number = 10 */
            if(uc_msg_cnt == 1) {
               fprintf(fp_aoc_trail, "Send a PMR with profile number = 10\n");
               TxAocMsgPMR(10, &gt_TxMsgPMR);
               pt_TxMsg = &gt_TxMsgPMR;
               TxAocMsgPut(pt_TxMsg);
            }

            /* Increase the message count */
            uc_msg_cnt++;
         }


         /* Get a synch byte for this frame */
         uc_byte = Tx_Mode3OH_Handler(s_frame_cnt);

         if((s_frame_cnt != 1) && (s_frame_cnt != 34) && (s_frame_cnt != 35)) {

            if((s_frame_cnt&0x3) < 2) {

               if(uc_byte == 0)
                  s_stuffing_byte_cnt++;
               else {
                  if(s_stuffing_byte_cnt > 0)
                     fprintf(fp_aoc_trail, "no. of TX stuffing bytes = %d\n", s_stuffing_byte_cnt);
                  fprintf(fp_aoc_trail, "0x%x\n", uc_byte);
                  s_stuffing_byte_cnt = 0;
               }
            }  /* if((s_frame_cnt&0x3) < 2) { */
         } /* if((s_frame_cnt != 1) && (s_frame_cnt != 34) && (s_frame_cnt != 35))) {  */

         /* Read in input synch byte */
         if(argc == 2) {
            fscanf(fp_rx_in, "%x", &uc_byte);

            /* Process a synch byte received this frame */
            Rx_Mode3OH_Handler(s_frame_cnt, uc_byte);
            guc_aoc_msg_id = RxAocProcessor();

            if(guc_aoc_msg_id != AOC_MSG_ID_UNDEFINED) {
               fprintf(fp_aoc_trail, "\nReceive message (ID = %d)\n\n", guc_aoc_msg_id);
            }
         }

      } /* for(s_frame_cnt */

   } /* for(s_sframe_cnt */


   fprintf(fp_aoc_trail, "Stored TX Profile:\n");
   for(i=0; i<NUM_PROFILES; i++) {
      if(gta_TXProfile[i].s_ReqdBits > 0) {
         fprintf(fp_aoc_trail, "Profile Number = %d\n", i);
      }
   }

   fprintf(fp_aoc_trail, "Stored RX Profile:\n");
   for(i=0; i<NUM_PROFILES; i++) {
      if(gta_RXProfile[i].s_ReqdBits > 0) {
         fprintf(fp_aoc_trail, "Profile Number = %d\n", i);
      }
   }

   fprintf(fp_aoc_trail, "Profile Search Order:\n");
   for(i=0; i<NUM_PROFILES; i++)
      fprintf(fp_aoc_trail, "%d\n", gsa_rx_profile_ord[i]);
   fflush(fp_aoc_trail);

   exit(0);

}


