/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _CNFG9922_H
#define _CNFG9922_H


/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: cnfg9922.h
;
;  This is a header file containing constant definitions
;
;***************************************************************************/


#define C_PILOT_TONE          (64)
#define C_PILOT_TONE_MIN         (59)  /*  minimum tone index used for detection of C_PILOT1_TONE */
#define C_PILOT_TONE_MAX         (69)  /*  maximum tone index used for detection of C_PILOT1_TONE */


/* ============================================================================ */
/* The following parameters are used for configuring the system. */
/*                                                          */
/* The TX_FFT_LENGTH and RX_FFT_LENGTH define the IFFT and FFT length,        */
/* respectively.                                               */
/* The TX and RX CP LENGTHs are 1/16 of the IFFT and FFT length, respectively.   */
/*
/* Setting TX_NUM_TONES to 128 is used only to generate the test vector */
/* as the RX input during SHOWTIME; */

/* Setting RX_NUM_TONES to 32 is used only to test the TX output */
/* during SHOWTIME (to verify no CRC errors) */
/* ============================================================================ */

#define RX_FFT_LENGTH            (256) /*  FFT length */

#define RX_BUFFER_SIZE      (512)       /* used to size the buffers to adsl+ */

#define GLITE_DS_NUM_TONES 128         /* G.lite downstream number of tones */
#define GLITE_US_NUM_TONES 32       /* G.lite upstream number of tones */

#define TX_NUM_TONES    GLITE_US_NUM_TONES         /* number of tones for US */
#define RX_NUM_TONES    GLITE_DS_NUM_TONES         /* number of tones for DS */
/* ======================================================================== */
/*  Carrier or Channel Parameters */
/* ======================================================================== */
#if (TX_NUM_TONES == 32)   /* this is used for test symmetric case only */
   #define TX_FIRST_CHANNEL    6
   #define TX_LAST_CHANNEL     31
#else /* =128 */
   #define TX_FIRST_CHANNEL    33
   #define TX_LAST_CHANNEL     127
#endif

#if (RX_NUM_TONES == 32)
   #define RX_FIRST_CHANNEL     6
   #define RX_LAST_CHANNEL     31
#else /* 128 */
   #define RX_FIRST_CHANNEL    33
   #define RX_LAST_CHANNEL     127
#endif

// Hardware limit assuming all US channels are used as data channels.
// Max upstream overhead is 2 bytes (sync and LEX byte in framing mode 1).
#define MAX_LSX_PAYLOAD_BYTES  (64-2)    /*  bytes per frame to reach 640 kbps */

/* =========================================================================================== */
/* Modem Configuration Parameters */
/* =========================================================================================== */
#define  TCM_OPTION           0           /* not support trellis coding */


/* =========================================================================================== */
/* Paramters associated with TDQ */
/* WARNING! The following constants are used for test purpose and they need to be calibrated */
/* for real system. */
/* =========================================================================================== */

#define  TDQ_LENGTH              (6)            /*  TDQ filter length */
#define TDQ_RIGHT_SHIFT_COUNT    (3)            /*  TDQ intermediate result right shift count */
                                       /*  set to approximately log2(TDQ_LENGTH) */

/* ========================================================================= */
/*  Showtime parameters */
/* ========================================================================= */

#define RX_MAX_D           16          /* maximum DS interleave depth */

/* ====================================================================================== */
/* Bit loading paramters */
/* ====================================================================================== */
#define  MAX_PAYLOAD_OVERHEAD_BYTES 1        /* maximum no. of overhead bytes per symbol */
#define  MAX_US_PAYLOAD_BYTES (16)        /* maximum number of payload bytes per symbol for US */
#define  MAX_US_BYTES         (MAX_US_PAYLOAD_BYTES+MAX_PAYLOAD_OVERHEAD_BYTES+2)
                                    /* maximum number of bytes per symbol for upstream */
                                    /* 16 payload (=(512 Kbps)/(4000*8))+1 overhead + 2 checkbytes */
                                    /* where we assume that check bytes is limited to <=10% */
#define  MAX_DS_PAYLOAD_BYTES (48)        /* maximum number of payload bytes per symbol for DS */
#define  MAX_DS_BYTES         (MAX_DS_PAYLOAD_BYTES+MAX_PAYLOAD_OVERHEAD_BYTES+4)
                                    /* maximum number of bytes per symbol for downstream */
                                    /* 48 payload (= (1536 Kbps)/(4000*8)) + 1 overhead + 4 checkbytes */
                                    /* where we assume that check bytes is limited to <=10% */
#define MAX_RX_OUTBUF_FRAME_SIZE    (70)
#define  DESIRED_SNR_MARGIN      (4<<8)         /* 4 dB in Q8.8 format */

/* ======================================================================= */
/*  CONSTANTS */
/*  ====================================================================== */

#define R_C_RECOV_BURST_CNT                 (1)

/* ====================================================================================== */
/*  Handshake parameters. These parameters can be configured */
/* ====================================================================================== */

#define MAX_NET_DATARATE_US     8      /*  maximum net data rate upstream = 512Kbps */
                                        /*  For data rates y (in Mbps) >= 2Mbps, this value should be equal to 32+(y/2) */
                                        /*  Eg: for y = 14Mbps, this value should be 32+(14/2) = 39 */
                                        /*  For data rates y (in kbps) < 2Mbps, this value should be equal to (y/64) */
                                        /*  Eg: for y = 640kbps, this value should be (640/64) = 10 */
                                        /*  we can have multiples of 64kbps or multiples of 2Mbps only */

#define MIN_NET_DATARATE_US     1       /*  minimum net data rate upstream = 64Kbps */
                                        /*  For data rates y (in Mbps) >= 2Mbps, this value should be equal to 32+(y/2) */
                                        /*  Eg: for y = 4Mbps, this value should be 32+(4/2) = 34 */
                                        /*  For data rates y (in kbps) < 2Mbps, this value should be equal to (y/64) */
                                        /*  Eg: for y = 128kbps, this value should be (128/64) = 2 */
                                        /*  we can have multiples of 64kbps or multiples of 2Mbps only */

#define AVG_NET_DATARATE_US     4      /*  Average net data rate upstream = 256Kbps */
                                        /*  For data rates y (in Mbps) >= 2Mbps, this value should be equal to 32+(y/2) */
                                        /*  Eg: for y = 14Mbps, this value should be 32+(14/2) = 39 */
                                        /*  For data rates y (in kbps) < 2Mbps, this value should be equal to (y/64) */
                                        /*  Eg: for y = 640kbps, this value should be (640/64) = 10 */
                                        /*  we can have multiples of 64kbps or multiples of 2Mbps only */

#define MAX_NET_DATARATE_DS     24      /*  maximum net data rate upstream = 1536Kbps */
                                        /*  For data rates y (in Mbps) >= 2Mbps, this value should be equal to 32+(y/2) */
                                        /*  Eg: for y = 12Mbps, this value should be 32+(12/2) = 38 */
                                        /*  For data rates y (in kbps) < 2Mbps, this value should be equal to (y/64) */
                                        /*  Eg: for y = 640kbps, this value should be (640/64) = 10 */
                                        /*  we can have multiples of 64kbps or multiples of 2Mbps only */

#define MIN_NET_DATARATE_DS     1       /*  minimum net data rate upstream = 64kbps */
                                        /*  For data rates y (in Mbps) >= 2Mbps, this value should be equal to 32+(y/2) */
                                        /*  Eg: for y = 4Mbps, this value should be 32+(4/2) = 34 */
                                        /*  For data rates y (in kbps) < 2Mbps, this value should be equal to (y/64) */
                                        /*  Eg: for y = 128kbps, this value should be (128/64) = 2 */
                                        /*  we can have multiples of 64kbps or multiples of 2Mbps only */

#define AVG_NET_DATARATE_DS     12      /*  Average net data rate upstream = 768Kbps */
                                        /*  For data rates y (in Mbps) >= 2Mbps, this value should be equal to 32+(y/2) */
                                        /*  Eg: for y = 6Mbps, this value should be 32+(6/2) = 35 */
                                        /*  For data rates y (in kbps) < 2Mbps, this value should be equal to (y/64) */
                                        /*  Eg: for y = 640kbps, this value should be (640/64) = 10 */
                                        /*  we can have multiples of 64kbps or multiples of 2Mbps only */

#define MAX_LATENCY_US          MAX_DELAY_IN_MSEC      /*  maximum latency upstream  */
                                        /*  For latency y (in msec) <= 31ms, this value should be equal to (y/1) 32+(y/2) */
                                        /*  Eg: for y = 6ms, this value should be 6 */
                                        /*  For latency y (in ms) >= 40ms, this value should be equal to 32+(y/10)-4 */
                                        /*  Eg: for y = 60ms, this value should be 32+(60/10)-4 = 34 */
                                        /*  we can have multiples of 1ms upto 31ms and thereafter we can have multiples of 10ms only */

#define AVG_LATENCY_US          8       /*  Average latency upstream = 8ms */
                                        /*  For latency y (in msec) <= 31ms, this value should be equal to (y/1) 32+(y/2) */
                                        /*  Eg: for y = 6ms, this value should be 6 */
                                        /*  For latency y (in ms) >= 40ms, this value should be equal to 32+(y/10)-4 */
                                        /*  Eg: for y = 60ms, this value should be 32+(60/10)-4 = 34 */
                                        /*  we can have multiples of 1ms upto 31ms and thereafter we can have multiples of 10ms only */

#define MAX_LATENCY_DS          MAX_DELAY_IN_MSEC      /*  maximum latency downstream  */
                                        /*  For latency y (in msec) <= 31ms, this value should be equal to (y/1) 32+(y/2) */
                                        /*  Eg: for y = 6ms, this value should be 6 */
                                        /*  For latency y (in ms) >= 40ms, this value should be equal to 32+(y/10)-4 */
                                        /*  Eg: for y = 60ms, this value should be 32+(60/10)-4 = 34 */
                                        /*  we can have multiples of 1ms upto 31ms and thereafter we can have multiples of 10ms only */

#define AVG_LATENCY_DS          8       /*  Average latency downstream = 8ms */
                                        /*  For latency y (in msec) <= 31ms, this value should be equal to (y/1) 32+(y/2) */
                                        /*  Eg: for y = 6ms, this value should be 6 */
                                        /*  For latency y (in ms) >= 40ms, this value should be equal to 32+(y/10)-4 */
                                        /*  Eg: for y = 60ms, this value should be 32+(60/10)-4 = 34 */
                                        /*  we can have multiples of 1ms upto 31ms and thereafter we can have multiples of 10ms only */

#define RELATIVE_POWER_LEVEL_A43_UP 0  /* Attenuation in G.994.1 transmit power per carrier relative */
                              /* to maximum power (bits 6 to 1 x 0.5dB) for upstream carrier set A43 */
#define RELATIVE_POWER_LEVEL_A43_DN 0  /* Attenuation in G.994.1 transmit power per carrier relative */
                              /* to maximum power (bits 6 to 1 x 0.5dB) for downstream carrier set A43 */
#define RELATIVE_POWER_LEVEL_B43_UP 0  /* Attenuation in G.994.1 transmit power per carrier relative */
                              /* to maximum power (bits 6 to 1 x 0.5dB) for upstream carrier set B43 */
#define RELATIVE_POWER_LEVEL_B43_DN 0  /* Attenuation in G.994.1 transmit power per carrier relative */
                              /* to maximum power (bits 6 to 1 x 0.5dB) for downstream carrier set B43 */
#define RELATIVE_POWER_LEVEL_C43_UP 0  /* Attenuation in G.994.1 transmit power per carrier relative */
                              /* to maximum power (bits 6 to 1 x 0.5dB) for upstream carrier set C43 */
#define RELATIVE_POWER_LEVEL_C43_DN 0  /* Attenuation in G.994.1 transmit power per carrier relative */
                              /* to maximum power (bits 6 to 1 x 0.5dB) for downstream carrier set C43 */
#define RELATIVE_POWER_LEVEL_A4_UP  0  /* Attenuation in G.994.1 transmit power per carrier relative */
                              /* to maximum power (bits 6 to 1 x 0.5dB) for upstream carrier set A4 */
#define RELATIVE_POWER_LEVEL_A4_DN  0  /* Attenuation in G.994.1 transmit power per carrier relative */
                              /* to maximum power (bits 6 to 1 x 0.5dB) for downstream carrier set A4 */

#define GHS_SPAR1 0x8      /* G992_2_AB */
                                             // Tone power = -40dBm/Hz + 10log10(4.3125kHz) = -3.65 dBm,                               // where
                                             // -40dBm/Hz is nominal PSD specified in standard, and 4.3125kHz is                                            // bandwidth of single tone.  In Q8.8 format, -3.65dBm => 0xFC59.
#endif   /* CNFG9922_H */

