/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  test_ib.c
;
;   The following main program is to test TX and RX Indicator Bits code.
;
;***************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include "typedef.h"
#include "gdata.h"
#include "ib.h"
#include "tx_ib.h"
#include "rx_ib.h"
#include "cmv.h"
#include "statein1.h"
#include "AllocateDataBuffers_PreHndshk.h"

extern void RxIbHandler(uint8 uc_byte, int16 s_frame_number); // implemented in SWE rx_oh.c

/* =============================================== */
/* constants used by this file only */
/* =============================================== */
#define TEST_SUPERFRAMES 30

/* =============================================== */
/* global variable declarations */
/* =============================================== */
uint8 uc_RXsf34[TEST_SUPERFRAMES] =
{ 0xBC, 0xBD, 0xDE, 0xFD, 0xFE, 0xFD, 0xFC, 0xFF, 0xFE, 0xFF,
  0xAF, 0xAF, 0xAF, 0x9F, 0xBF, 0xFF, 0xEF, 0xEF, 0xEF, 0xEF,
  0xFF, 0xFF, 0xFF, 0xEF, 0xEF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF };

uint8 uc_RXsf35[TEST_SUPERFRAMES] =
{ 0x8F, 0x9F, 0xAF, 0xBF, 0xCF, 0xDF, 0xEF, 0xFF, 0x0F, 0x1F,
  0x2F, 0x3F, 0x4F, 0x5F, 0x6F, 0x7F, 0x8F, 0x9F, 0xAF, 0xBF,
  0xCE, 0xDE, 0xEE, 0xFF, 0x0F, 0x1F, 0x2F, 0x3F, 0x4F, 0x5F };

/* =============================================== */
/* static variable declarations */
/* =============================================== */
FILE *fid, *fout;

void TestResultHandler(uint8 *puc_txbyte, int16 i)
{

    /* tx output */
    fprintf(fout,"0x%02X\n",puc_txbyte[0]);
    fprintf(fout,"0x%02X\n",puc_txbyte[1]);
    fprintf(fout,"0x%02X\n\n",puc_txbyte[2]);

    /* rx results */
    fprintf(fid, "\n\nSuperframe #%d\n\n",i);
    if (gt_RxIbData.uc_febe_i) fprintf(fid,"RX FEBE INDICATION\n");
    if (gt_RxIbData.uc_ffec_i) fprintf(fid,"RX FFEC INDICATION\n");
    if (gt_RxIbData.uc_flos) fprintf(fid,"RX FLOS INDICATION\n");
    if (gt_RxIbData.uc_frdi) fprintf(fid,"RX FRDI INDICATION\n");
    if (gt_RxIbData.uc_fncd_i) fprintf(fid,"RX FNCD INDICATION\n");
    if (gt_RxIbData.uc_fhec_i) fprintf(fid,"RX FHEC INDICATION\n");
   fprintf(fid,"RX NTR = %d\n",gt_RxIbData.s_fntr);

    if (gt_RxIbData.uc_fncd_i_anom == PRESENT) fprintf(fid,"RX No Cell Delineation ANOMALY\n");
    if (gt_RxIbData.uc_focd_i_anom == PRESENT) fprintf(fid,"RX Out of Cell Delineation ANOMALY\n");
   /* not used anywhere, so deleted
    if (gt_RxIbData.uc_flos_def  == PRESENT) fprintf(fid,"RX Loss of Synch DEFECT\n");
   */
    if (gt_RxIbData.uc_flcd_i_def  == PRESENT) fprintf(fid,"RX Loss of Cell Delineation DEFECT\n");

}

/*-------------------------------------------------------------------
*
*  int Pause(void)
*
*  Description: For debugging purposes.  Stops the DSL cores (necessary) and allows
*  external debug reads and writes to be performed, dummy here
*
*-------------------------------------------------------------------
*^^^
*/
void Pause(int16 s_Marker)
{
}


void main()
{
    int16 i;
    uint8 uc_txbyte[3];

    /* Set STAT CMV to indicate Lite mode */
   STATArray[STAT_Mode] |= STAT_ConfigMode_G992_2_AB;

   AllocateDataBuffers_PreHndshk();

   InitGlobalVariables();
    TxInitIb();
    RxInitIb();

   gusa_CRC_count[INTERLEAVE_DATA_PATH] = 0; //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)
   gusa_CRC_count[FAST_DATA_PATH] = 0; //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)

    if ((fid = fopen("trail_ib.txt","w")) == NULL) {
      fprintf(stderr, "Cannot open trail_ib.txt file\n");
      exit(-1);
   }
    if ((fout = fopen("ib_out.txt","w")) == NULL) {
      fprintf(stderr, "Cannot open ib_out.txt file\n");
      exit(-1);
   }

    for (i = 0; i < TEST_SUPERFRAMES; i++)
    {
        if ( (i%5) == 0)  gusa_CRC_count[INTERLEAVE_DATA_PATH]++; //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)

        if ( (i%6) == 1)
        {
            gt_TxIbData.uc_ffec_i_anom      = PRESENT;
            gt_TxIbData.uc_ffec_i_anom_hist = PRESENT;
        }
        else
        {
            gt_TxIbData.uc_ffec_i_anom = TERMINATED;
        }

        if ( (i%7) == 2)  gt_TxIbData.uc_flos_def = PRESENT;
        else              gt_TxIbData.uc_flos_def = TERMINATED;

        if ( (i%10) >= 4)
        {
            gt_TxIbData.uc_cd_i_flag      = TRUE;
            gt_TxIbData.uc_cd_i_flag_hist = TRUE;
        }
        else
        {
            gt_TxIbData.uc_cd_i_flag = FALSE;
        }

        if (i == 23)      gt_TxIbData.uc_fsef_def = PRESENT;
        else              gt_TxIbData.uc_fsef_def = TERMINATED;

        if ( (i%4) == 3)
        {
            gt_TxIbData.uc_fhec_i_anom      = PRESENT;
            gt_TxIbData.uc_fhec_i_anom_hist = PRESENT;
        }
        else
        {
            gt_TxIbData.uc_fhec_i_anom = TERMINATED;
        }

        uc_txbyte[0] = TxIbHandler(1);
        RxIbHandler(0xFF,1);

        uc_txbyte[1] = TxIbHandler(34);
        RxIbHandler(uc_RXsf34[i],34);

        uc_txbyte[2] = TxIbHandler(35);
        RxIbHandler(uc_RXsf35[i],35);
      RxIbProcessor();

        Update_TxIb();

        TestResultHandler(uc_txbyte, i);
    }

    fprintf(fid,"\n\nTOTAL RX FEBE's = %d\n",gt_RxIbData.s_febe_i_cnt);
    fprintf(fid,"TOTAL RX FFEC's = %d\n",gt_RxIbData.s_ffec_i_cnt);
    fprintf(fid,"TOTAL RX FHEC's = %d\n",gt_RxIbData.s_fhec_i_cnt);
   /* this counter was not used anywhere, so deleted
    fprintf(fid,"TOTAL RX FRDI's = %d\n",gt_RxIbData.l_frdi_cnt);
   */

    fclose(fid);
    fclose(fout);

    exit(0);

}

/* undefine constants used by this file only */
#undef TEST_SUPERFRAMES

