/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *-------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   PWR_MAN.C
 *
 *   IDLE Link state (L3) functions for Tx and Rx
 *
 *-------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_tones.h"
#include "rt_state.h"
#include "gdata.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "ghs.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "hndshk_Data.h"
#include "ifft_fix.h"
#include "xrtstate.h"
#include "mtkernel.h"
#include "states.h"
#include "cmv.h"
#include "mp.h"
#include "detect.h"
#include "TxTneSt.h"
#include "RCSilent1RxF.h"
#include "RCRecovRxF.h"
#include "RCTonesRxF.h"
#include "RSilent0TxF.h"
#include "RTone1TxF.h"
#include "RRecovTxF.h"


/*^^^
*-------------------------------------------------------------------
########               ########
######## TX ROUTINES   ########
########               ########
*-------------------------------------------------------------------
*^^^
*/

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RIdleLinkTxF
 *
 *  Description: R_IDLE_LINK_TX is a silent state where no signal is transmitted.
 *  A host command from the host controller or detection of C_Tones or  C_Recov
 *  from an ATU-C moves the Tx state to next state.
 *
 *  Prototype: void RIdleLinkTxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gs_TxOutBuf[]  -   The current symbol (bit) that is to be modulated
 *                         onto the carrier set frequencies.
 *
 *  Notes: implements state R_IDLE_LINK_TX
 *
 *------------------------------------------------------------------------
 *^^^
 */

void RIdleLinkTxF(void) {

    /* ---- transmit silence ---- */
    if (gl_TxSymbolCount == 0)
   {
      gft_IFFT_On = TRUE;
        TxToneSetUp(0,0,0);
      gt_TaskArray[TX_FRAME_START].TimeCriticalTask=TxProcessTones;
   }
    switch ( gs_RxState ) {
    case R_C_SILENT1_RX:
        gs_TxNextState = R_SILENT0_TX;
      gpF_TxStateFunc  = (PtrToFunc)RSilent0TxF;
        break;
    case R_C_TONES_RX:
        gs_TxNextState = R_TONE1_TX;
      gpF_TxStateFunc  = (PtrToFunc)RTone1TxF;
        break;
    case R_C_RECOV_RX:
        gs_TxNextState = R_RECOV_TX;
      gpF_TxStateFunc  = (PtrToFunc)RRecovTxF;
        break;
    }

}   /*  RIdleLinkTxF */


/*^^^
*-------------------------------------------------------------------
########               ########
######## RX ROUTINES   ########
########               ########
*-------------------------------------------------------------------
*^^^
*/

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RIdleLinkRxF
 *
 *  Description: R_IDLE_LINK_RX first transmit silence for 500ms, then detects
 *  C_Tones or C_Recov signal intermittantly every 100 ms. Upon detection of
 *  either signal or the host command, the Rx moves to next state.
 *
 *  Prototype: void RIdleLinkRxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gs_FFT_InBuf                           - used in DetectTones() and DetectMultiTones()
 *
 *  Substates:
 *      R_IDLE_LINK_RX_INITIAL_WAIT           - Receiver does nothing for
 *                                              INITIAL_SILENCE_LEN symbols.
 *      R_IDLE_LINK_RX_INITIAL_TONE_DETECTION - Alternatively attempt to detect C_TONES
 *                                              or C_RECOV every 119ms. Also, listen for
 *                                              a host command to either START_GHS or
 *                                              START_FAST_RETRAIN.
 *      R_IDLE_LINK_RX_C_TONES_DETECTED       - Continue to detect C_TONES. If it is
 *                                              detected for 216
 *                                              consecutive symbols, the receiver
 *                                              transitions to R_C_TONES_RX.
 *      R_IDLE_LINK_RX_C_RECOV_DETECTED       - Continue to detect C_RECOV. If it is
 *                                              detected for R_C_RECOV_BURST_CNT consecutive
 *                                              symbols, the receiver transitions to
 *                                              R_C_RECOV_RX.
 *
 *  Notes: implements state R_IDLE_LINK_RX
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates */
/* =============================================== */
#define R_IDLE_LINK_RX_INITIAL_WAIT           (0)
#define R_IDLE_LINK_RX_INITIAL_TONE_DETECTION (1)
#define R_IDLE_LINK_RX_C_TONES_DETECTED       (2)
#define R_IDLE_LINK_RX_C_RECOV_DETECTED       (3)

/* =============================================== */
/* other constants */
/* =============================================== */
#define R_IDLE_LINK_RX_INITIAL_WAIT_LEN       (TIME_500MS) /*  minimum initial silence period of 500ms */
#define LOG2_INTERVAL                         (9)          /*  LOG2 of tone detection interval (2^9 = 512 symbols = 119ms) */
#define LSB9_MASK                             (0x1FF)      /*  Mask 9 LSBs */

void RIdleLinkRxF(void) {

    switch ( gs_RxSubState ) {

    case R_IDLE_LINK_RX_INITIAL_WAIT:

      STATArray[STAT_MacroState] = STAT_IdleState;
        if (gl_RxSymbolCount >= R_IDLE_LINK_RX_INITIAL_WAIT_LEN)
            gs_RxSubState = R_IDLE_LINK_RX_INITIAL_TONE_DETECTION;

        break;

    case R_IDLE_LINK_RX_INITIAL_TONE_DETECTION:
        /* ---- alternatively detect R_Tones_Req or R_Recov every 119ms ---- */
        if ( ( (gl_RxSymbolCount >> LOG2_INTERVAL) & LSB_MASK) == 0 ) {
            if ( DetectMultiTones( (CONSTANT int16*)gsa_DnCarSet, NUM_CARRIERS_IN_SET, NUM_CARRIERS_REQUIRED, DETECT_SCALE << 8) ) {
                gs_RxSubStateCnt = 0;
                gs_RxSubState = R_IDLE_LINK_RX_C_TONES_DETECTED;
            }
        }
        else {

            if ( DetectTone(gsa_RxToneBuf, C_RECOV_TONE, C_RECOV_TONE_MIN, C_RECOV_TONE_MAX, DETECT_SCALE << 8) ) {
                gs_RxSubStateCnt = 0;
                gs_RxSubState = R_IDLE_LINK_RX_C_RECOV_DETECTED;
            }
        }

        /* ---- host command changes link state ---- */
        if (OPTNArray[OPTN_PwrManControl] & OPTN_PwrManWakeUpGhs) {
         OPTNArray[OPTN_PwrManControl] &= ~(OPTN_PwrManWakeUpGhs);
            gs_RxNextState = R_C_SILENT1_RX;
         gpF_RxStateFunc  = (PtrToFunc) RCSilent1RxF;
        }
        else if (OPTNArray[OPTN_PwrManControl] & OPTN_PwrManWakeUpFR) {
         OPTNArray[OPTN_PwrManControl] &= ~(OPTN_PwrManWakeUpFR);
            gs_RxNextState = R_C_RECOV_RX;
         gpF_RxStateFunc  = (PtrToFunc)RCRecovRxF;

        }

        break;

    case R_IDLE_LINK_RX_C_TONES_DETECTED:

        if ( DetectMultiTones( (CONSTANT int16*)gsa_DnCarSet, NUM_CARRIERS_IN_SET, NUM_CARRIERS_REQUIRED, DETECT_SCALE << 8) )
         gs_RxSubStateCnt++;
        else
            gs_RxSubState = R_IDLE_LINK_RX_INITIAL_TONE_DETECTION;

        if (gs_RxSubStateCnt >= 216) {
         gs_RxNextState = R_C_TONES_RX;
         gpF_RxStateFunc  = (PtrToFunc) RCTonesRxF;
      }

        break;

    case R_IDLE_LINK_RX_C_RECOV_DETECTED:

        if ( DetectTone(gsa_RxToneBuf, C_RECOV_TONE, C_RECOV_TONE_MIN, C_RECOV_TONE_MAX, DETECT_SCALE << 8) )
         gs_RxSubStateCnt++;
        else
            gs_RxSubState = R_IDLE_LINK_RX_INITIAL_TONE_DETECTION;

        if (gs_RxSubStateCnt >=  R_C_RECOV_BURST_CNT) {
         gs_RxNextState = R_C_RECOV_RX;
         gpF_RxStateFunc  = (PtrToFunc)RCRecovRxF;
      }

        break;

    }   /*  switch (substate) */

}   /*  RIdleLinkRxF */

#undef R_IDLE_LINK_RX_INITIAL_WAIT
#undef R_IDLE_LINK_RX_INITIAL_TONE_DETECTION
#undef R_IDLE_LINK_RX_C_TONES_DETECTED
#undef R_IDLE_LINK_RX_C_RECOV_DETECTED

#undef R_IDLE_LINK_RX_INITIAL_WAIT_LEN
#undef LOG2_INTERVAL
#undef LSB9_MASK

