/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCCrcFr1RxF.c
 *
 *   Fast Retrain RX State Functions for ATU-R.
 *   Covering the RX states: R_C_CRC_FR1_RX
 *                   R_C_CRC_FR2_RX
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_tones.h"
#include "snr.h"
#include "pga_set.h"
#include "rx_ops.h"
#include "dsp_op.h"
#include "pll.h"
#include "gdata.h"
#include "frm_sync.h"
#include "tdq_init.h"
#include "fdq_init.h"
#include "fifo.h"
#include "DSLEngin.h"
#include "fretrain.h"
#include "accum32.h"
#include "xrtstate.h"
#include "cmv.h"
#include "profile2.h"
#include "crc16.h"
#include <string.h>
#include "vecpwr.h"
#include "detect.h"
#include "states.h"
#include "sleep.h"
#include "RCReverbFR3RxF.h"
#include "RCReverbFR8RxF.h"


/* =============================================== */
/* Global variable declarations                    */
/* =============================================== */

/*^^^
*-------------------------------------------------------------------
########               ########
######## RX ROUTINES   ########
########               ########
*-------------------------------------------------------------------
*^^^
*/

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCCrcFr1RxF
 *
 *  Description: Decodes the R_C_CRC information and compares to the
 *  CRC computed on the received message.  If the CRC's
 *  match then initialization continues with next state, otherwise
 *  initialization failure is declared.
 * This function is reused by several states:
 *
 *  Prototype: void RCCrcFr1RxF(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gus_RC_CRC_computed   - (I) R_C_CRC1 computed over received R_C_RATES1
 *      gus_RC_CRC_received   - (I/O) received R_C_CRC1
 *      gusa_PN512Tab[]     - (I) packed PRD sequence
 *      gsa_RxToneBuf[]     - (O) output of FDQ
 *      gl_RxSymbolCount    - (I) number of symbol periods in current state
 *      gs_RxNextState      - (O) RX state beginning next symbol period
 *    gs_RxState        - (I) current RX state
 *
 *  Notes: implements states R_C_CRC_FR1_RX and R_C_CRC_FR2_RX
 *
 *------------------------------------------------------------------------
 *^^^
 */

void RCCrcFr1RxF(void) {

   uint16  us_infobit;

   /*  clear received RC_CRC1 */
   if (gl_RxSymbolCount == 0)
      gus_RC_CRC_received =  0x0000;

   /*  get infobit */
   us_infobit = DetectReverbSegue(gsa_RSDetect_Bins, gsa_RSDetect_PNSeq, gs_RSDetect_NumBins, NULL, NULL);

   /*  build received RC_CRC1 */
   gus_RC_CRC_received |=  (us_infobit << gl_RxSymbolCount);

   /*  compare CRC's when all bits received */
   if (gl_RxSymbolCount == (R_C_CRC1_RX_LEN - 1)) {

      /* ============================================================ */
      /* If received CRC equals to the computed CRC */
      /* ============================================================ */
      if ( gus_RC_CRC_received == gus_RC_CRC_computed ) {

         switch (gs_RxState) {

            case R_C_CRC_FR1_RX:

               DecodeCInfoFR1();

               /* Since the power change is introduced by CO in next symbol */
               /* FDQ need to be retrained, so we turn off the following flags */
               AddFunctionToFifo(gp_RxLoadingFunctionFifo,DisableFDQ);

               /* set FDQ flag to wait again  */
               guc_FdqTrainingState = TRAINING_WAITING;

               //Set up the flag to reset reference tone since FDQ is turned off
               guc_CommandedPllState = PLL_RESET_REFERENCE_TONE;

                    if(gft_FR_Truncate_Flag == TRUE) {
                         gs_RxNextState = SLEEP_RX;
                  gpF_RxStateFunc  = (PtrToFunc)RSleepRxF;
               }
                    else  {
                  gs_RxNextState = R_C_REVERB_FR3_RX;
                  gpF_RxStateFunc  = (PtrToFunc)RCReverbFR3RxF;
               }

                  break;

            case R_C_CRC_FR2_RX:
               DecodeCInfoFR2();
               gs_RxNextState = R_C_REVERB_FR8_RX;
               gpF_RxStateFunc  = (PtrToFunc)RCReverbFR8RxF;

               break;

         } /* switch (gs_RxState)  */
      }
      else {
         /* ============================================================ */
         /*  CRC's don't match:  go to FAIL state */
         /* ============================================================ */
         gft_RCExch1RcvFlag = NOT_RECEIVE;
         gs_RxNextState = FAIL_RX;
         gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

            /* Disable the recovering from FAIL state to GHS start */
            gft_AutoRestartFlag = FALSE;

         /* Set exception handler variables */
         gus_ExceptionState   = gs_RxState;
         gus_ExceptionCode = E_CODE_RCCRCFR1_DECOD_ERR;
      }
   }
}
