/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCEctFRRxF.c
 *
 *   Fast Retrain RX State Functions for ATU-R.
 *   Covering the RX states: R_C_ECT_FR
 *
 *   Notes:
 *
 *   R_C_MSG_FR1 is implemented in analysi2.c
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_tones.h"
#include "snr.h"
#include "pga_set.h"
#include "rx_ops.h"
#include "dsp_op.h"
#include "pll.h"
#include "gdata.h"
#include "frm_sync.h"
#include "tdq_init.h"
#include "fdq_init.h"
#include "fifo.h"
#include "fretrain.h"
#include "accum32.h"
#include "xrtstate.h"
#include "cmv.h"
#include "profile2.h"
#include "crc16.h"
#include <string.h>
#include "vecpwr.h"
#include "detect.h"
#include "memsetbf.h"
#include "bufmisc.h"
#include "afe.h"
#include "frm_sync_b.h"
#include "states.h"
#include "RCReverbFR5RxF.h"


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : RCEctFRRxF
 *
 *  Description:  Receives the C_Ect_FR signal and ignores it.
 *
 *  Prototype:
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Return:
 *
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RCEctFRRxF(void) {

   if (gl_RxSymbolCount == (R_C_ECT_FR_RX_LEN - 1) ) {
      gs_RxNextState = R_C_REVERB_FR5_RX;
      gpF_RxStateFunc = (PtrToFunc)RCReverbFR5RxF;

   }
}

