/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCMedleyFRRxF.c
 *
 *   RX: R_C_MEDLEY_FR,
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "xrtstate.h"
#include "rt_tones.h"
#include "gdata.h"
#include "snr.h"
#include "rx_ops.h"
#include "pll.h"
#include "medley.h"
#include "pn_tab.h"
#include "fifo.h"
#include "profile3.h"
#include "noiseacc.h"
#include "detect.h"
#include <string.h>
#include "memsetbf.h"
#include "memcopy.h"
#include "states.h"
#include "RCMsgFRRxF.h"



/*^^^
*-------------------------------------------------------------------
########               ########
######## RX ROUTINES   ########
########               ########
*-------------------------------------------------------------------
*^^^
*/

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCMedleyFRRxF
 *
 *  Description: Processes the C_Medley_FR signal and detects C_Segue2.
 *  C_Medley_FR is used by the ATU-R to calculate the downstream SNR per tone, which
 *  is then used to determine the number of bits per tone.
 *
 *  Prototype: RCMedleyFRRxF(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gl_RxSymbolCount            - (I) number of symbol periods in current state
 *      gs_RxNextState              - (O) RX state beginning next symbol period
 *    gusa_PN512Tab[]            - (I) PN512 sequence table
 *    gs_RxToneBuf[]          - (I) received DMT tones (FDQ output)
 *    gsa_MedleySnrBuf[]          - (O) computed SNR per tone
 *    guc_BitloadOK           - (O) indicator if bit loading succeeds
 *
 * Substates:
 * ----------
 * R_C_MEDLEY_FR_RX_INITIALIZE            - Initialization
 * R_C_MEDLEY_FR_RX_SNR_INIT           - Initialize for final SNR computation
 * R_C_MEDLEY_FR_RX_CALCULATE_SNR         - Gather average frame and calculate final SNR
 * R_C_MEDLEY_FR_RX_BITLOAD               - Perform bitloading or selecting profile
 * R_C_MEDLEY_FR_RX_WAIT               - Wait for the end of the R_C_MEDLEY_FR state.
 * R_C_MEDLEY_FR_RX_DETECT_SEGUE       - Detect C_SEGUE2 and check for time out.
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates */
/* =============================================== */
#define  R_C_MEDLEY_FR_RX_SNR_INIT        (0)
#define R_C_MEDLEY_FR_RX_CALCULATE_SNR    (1)
#define  R_C_MEDLEY_FR_RX_BITLOAD         (2)
#define  R_C_MEDLEY_FR_RX_WAIT            (3)
#define R_C_MEDLEY_FR_RX_DETECT_SEGUE     (4)

void RCMedleyFRRxF(void) {

   int16 s_ToneType;
   int16 s_gain = (int16) DEC_QPSK_GAIN;

   /* ============================================================================= */
   /* Perform necessary initialization at symbol 0 */
   /* ============================================================================= */
   if(gl_RxSymbolCount == 0) {

      gt_StateMachCntrl.l_RXCurrentStateLen = R_C_MEDLEY_FR_RX_LEN-1;
      gt_StateMachCntrl.s_RXFollowingState = R_C_MSG_FR2_RX;
      gt_StateMachCntrl.pF_RxFollowingState = (PtrToFunc)RCMsgFRRxF;
      gt_StateMachCntrl.psa_RXSNRBuf = gsa_FRSnrBuf;

      gs_num_snr_training_symbols = NUM_SNR_TRAINING_SYMBOLS_FR;
      gs_log2_num_snr_training_symbols = LOG2_NUM_SNR_TRAINING_SYMBOLS_FR;

      /* Unpack PN512 sequence to DMT tones */
      UnpackPN(gsa_unpk_PN512, (PN512_LEN + 1), gusa_PN512Tab, s_gain);

      gs_RxFirstPNbit = 0;
      gs_MedleyModulo = PN512_LEN;
      gsa_ref_tones = gsa_unpk_PN512;

      /* initialize Accumulation pointers for BgNoiseAcc()*/
      gla_NoisePower = gla_RxAccumBuf+2*gs_RxFirstChannel;
      gs_TrainCnt = 0;
   }

   /* ============================================================================== */
   /* Generate Medley reference frame */
   /* ============================================================================== */
   if(gs_RxSubState < R_C_MEDLEY_FR_RX_WAIT) {
      /* Get offset to first unpacked bit */
      if (gs_RxFirstPNbit >= PN512_LEN)
         gs_RxFirstPNbit -= (int16)PN512_LEN;
   }


   switch (gs_RxSubState) {


   /* ============================================================================== */
   /* Wait until TX transmits R_MEDLEY signal, initialize for SNR calculations       */
   /* ============================================================================== */
   case R_C_MEDLEY_FR_RX_SNR_INIT:

      if (gs_TxState == R_MEDLEY_FR_TX) {
         /* Initialize for test SNR calculation */
         MemSetBuffer((int16 *)(void *)gla_RxAccumBuf, 0, 0, (int16)(sizeof(int32)*(2*gs_RxNumTones)));
            /* Init SNR's to 0 prior to SNR calculation */
            MemSetBuffer(gsa_FRSnrBuf, 0, 0, (int16)(sizeof(int16)*gs_RxNumTones));
         gs_TrainCnt = 0;
         guc_AccumState = TRAINING_DONE;

         gs_RxSubStateCnt = 0;
         gs_RxSubState = R_C_MEDLEY_FR_RX_CALCULATE_SNR;
      }
      break;

   /* ============================================================================== */
   /* Calculate final SNR for the chosen pair */
   /* ============================================================================== */
   case R_C_MEDLEY_FR_RX_CALCULATE_SNR:

      /* Accumulate noise after initial waiting period  */
      if (gs_RxSubStateCnt >  R_C_MEDLEY_WT_LEN)
      {

         NoiseAcc(gla_NoisePower, 0, gsa_RxToneBuf, gs_RxFirstPNbit,gs_MedleyModulo,
            (int16) (2*gs_RxNumTones), gsa_ref_tones, gs_RxFirstChannel, gs_RxLastChannel);
         gs_TrainCnt++;

         /* Compute SNR value in the background */
         if(gs_TrainCnt == gs_num_snr_training_symbols) {

            guc_SnrCalcState = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc) BGMedleySnrCalc);

            gs_RxSubStateCnt = -1;
            gs_RxSubState = R_C_MEDLEY_FR_RX_BITLOAD;

         }  /* if(gs_RxSubStateCnt == gs_num_snr_training_symbols) */

      } /* else if(gs_RxSubStateCnt >=  C_R_MEDLEY_WT_LEN) */


      gs_RxSubStateCnt++;
      break;


   /* ============================================================================== */
   /* Perform Bitloading and Clear equalizers */
   /* ============================================================================== */
   case R_C_MEDLEY_FR_RX_BITLOAD:

      if (guc_SnrCalcState == TRAINING_DONE) {
         /* Perform bitloading or loading profile */
         gft_BitloadState = TRAINING_IN_PROGRESS;

         AddFunctionToBkgdFifo((PtrToBkgdFunc) SelectProfile);


         gs_RxSubStateCnt = 0;
         gs_RxSubState =   R_C_MEDLEY_FR_RX_WAIT;

      }
      break;


   case R_C_MEDLEY_FR_RX_WAIT:
      /* Waiting for the end of R_C_MEDLEY state */
      if(gft_BitloadState == TRAINING_DONE &&
         gl_RxSymbolCount >= gt_StateMachCntrl.l_RXCurrentStateLen-R_C_MEDLEY_WT_LEN)
      {
         gs_RxSubStateCnt = -1;
         gs_RxSubState = R_C_MEDLEY_FR_RX_DETECT_SEGUE;
      }
      gs_RxSubStateCnt++;
      break;


   case R_C_MEDLEY_FR_RX_DETECT_SEGUE:

      /* ================================================================ */
      /* Detect C_SEGUE2 and check for time out */
      /* ================================================================ */
      /*  decode incoming symbol */
      s_ToneType = DetectReverbSegue(gsa_RSDetect_Bins, gsa_RSDetect_PNSeq, gs_RSDetect_NumBins, NULL, NULL);

      /*  if incoming symbol is C_Segue, then incr. counter */
      /*  else reset counter */
      if (s_ToneType == C_SEGUE) {  /*  C_Segue detected */
         gs_RxSubStateCnt++;
      }
      else {
         gs_RxSubStateCnt = 0;

      }

      /*  C_SEGUE2 detected, go to next state */
      if (gs_RxSubStateCnt >= R_C_SEGUE2_LEN) {
         gs_RxNextState = gt_StateMachCntrl.s_RXFollowingState;
         gpF_RxStateFunc = gt_StateMachCntrl.pF_RxFollowingState;
      }

      /*  if C_SEGUE not detected yet, then the ATU-C has timed out */
      /*  goto FAIL_RX state  */
      if (gl_RxSymbolCount >= R_C_MEDLEY_FR_TIMEOUT ) {
         gs_RxNextState = FAIL_RX;
         gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

         /* Set exception handler variables */
         gus_ExceptionState   = gs_RxState;
         gus_ExceptionCode = E_CODE_RCMedleyFRRx_C_SEGUE2_Failure;
      }

        break;
   }

   /* ============================================================================== */
   /* increment RxFirstPNbit following its use in the NoiseAccum function        */
   /* ============================================================================== */
   if(gs_RxSubState < R_C_MEDLEY_FR_RX_WAIT)
   {
      gs_RxFirstPNbit++;
   }


}

/* undefine substates */
#undef R_C_MEDLEY_FR_RX_INITIALIZE
#undef R_C_MEDLEY_FR_RX_SNR_INIT
#undef R_C_MEDLEY_FR_RX_CALCULATE_SNR
#undef R_C_MEDLEY_FR_RX_BITLOAD
#undef R_C_MEDLEY_FR_RX_WAIT
#undef R_C_MEDLEY_FR_RX_DETECT_SEGUE







