/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCMsgFRRxF.c
 *
 *   Fast Retrain RX State Functions for ATU-R.
 *   Covering the RX states: R_C_MSG_FR
 *
 *   Notes:
 *
 *   R_C_MSG_FR1 is implemented in analysi2.c
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_tones.h"
#include "snr.h"
#include "pga_set.h"
#include "rx_ops.h"
#include "dsp_op.h"
#include "pll.h"
#include "gdata.h"
#include "frm_sync.h"
#include "tdq_init.h"
#include "fdq_init.h"
#include "fifo.h"
#include "fretrain.h"
#include "accum32.h"
#include "xrtstate.h"
#include "cmv.h"
#include "profile2.h"
#include "crc16.h"
#include <string.h>
#include "vecpwr.h"
#include "detect.h"
#include "memsetbf.h"
#include "bufmisc.h"
#include "afe.h"
#include "frm_sync_b.h"
#include "states.h"
#include "RCCrcFr1RxF.h"


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCMsgFRRxF
 *
 *  Description: Receives messages encoded as one symbol of C_Reverb as a 0 bit
 *  and one symbol of C_Segue as a 1 bit.  These messages include:
 *      MESSAGE         STORAGE LOCATION
 *      R_Msg_FR1       guca_R_C_Msg_FR1[];
 *      R_Msg_FR2       guca_R_C_Msg_FR2[];
 *
 *  Prototype: void RCMsgFRRxF(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gus_RC_CRC_computed   - (O) R_C_CRC1 computed over recevied message
 *      guca_R_C_Msg_FR1[] - (O) received R_C_MSG_FR1 message
 *      guca_R_C_Msg_FR2[] - (O) received R_C_MSG_FR2 message
 *      gusa_PN512Tab[]     - (I) packed PRD sequence
 *      gsa_RxToneBuf[]     - (O) output of FFT
 *      gl_RxSymbolCount    - (I) number of symbol periods in current state
 *      gs_RxNextState      - (O) RX state beginning next symbol period
 *    gs_RxState        - (I) current RX state
 *    gs_RxSubStateCnt  - (I/O) substate count
 *
 *  Notes: implements states R_C_MSG_FR1_RX and R_C_MSG_FR2_RX
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RCMsgFRRxF(void) {

   uint16  us_infobit;
   int16   s_bitpos, s_index, i;

   if (gl_RxSymbolCount == 0) {

      switch (gs_RxState) {

         case R_C_MSG_FR1_RX:
            gt_StateMachCntrl.l_RXCurrentStateLen    = R_C_MSG_FR1_RX_LEN-1;
            gt_StateMachCntrl.s_RXFollowingState     = R_C_CRC_FR1_RX;
            gt_StateMachCntrl.pF_RxFollowingState= (PtrToFunc)RCCrcFr1RxF;
            gt_StateMachCntrl.s_RXmessage_len        = R_C_MSG_FR1_NUM_BYTES;
            gt_StateMachCntrl.s_RXmessage_prefix_len = 0;
            break;

         case R_C_MSG_FR2_RX:
            gt_StateMachCntrl.l_RXCurrentStateLen    = R_C_MSG_FR2_RX_LEN-1;
            gt_StateMachCntrl.s_RXFollowingState     = R_C_CRC_FR2_RX;
            gt_StateMachCntrl.pF_RxFollowingState= (PtrToFunc)RCCrcFr1RxF;
            gt_StateMachCntrl.s_RXmessage_len        = R_C_MSG_FR2_NUM_BYTES;
            gt_StateMachCntrl.s_RXmessage_prefix_len = 0;
            break;
      }

      for(i=0; i<gt_StateMachCntrl.s_RXmessage_len; i++)
         gt_StateMachCntrl.puc_RXmessage[i] = 0;
      gus_RC_CRC_computed = 0x0000;

      gs_RxSubStateCnt = 0;
   }

   if(gl_RxSymbolCount >= gt_StateMachCntrl.s_RXmessage_prefix_len) {

      /*  get infobit */
      us_infobit = DetectReverbSegue(gsa_RSDetect_Bins, gsa_RSDetect_PNSeq, gs_RSDetect_NumBins, NULL, NULL);

      /*  put infobit into message */
      s_bitpos = gs_RxSubStateCnt & 0x7;
      s_index = gs_RxSubStateCnt >> 3;
      gs_RxSubStateCnt++;

      gt_StateMachCntrl.puc_RXmessage[s_index] |=  (us_infobit << s_bitpos);

      /*  update CRC count */
      CalcCRC16(&gus_RC_CRC_computed, us_infobit);

      if (gl_RxSymbolCount == gt_StateMachCntrl.l_RXCurrentStateLen) {
         gs_RxNextState = gt_StateMachCntrl.s_RXFollowingState;
         gpF_RxStateFunc = gt_StateMachCntrl.pF_RxFollowingState;
      }
   }
}

