/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCRecovRxF.c
 *
 *   Fast Retrain RX State Functions for ATU-R.
 *   Covering the RX states: R_C_RECOV
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include "cmv.h"
#include "rt_tones.h"
#include "fifo.h"
#include "rx_ops.h"
#include "pll.h"
#include "accum32.h"
#include "frm_sync.h"
#include "pga_set.h"
#include "fretrain.h"
#include "detect.h"
#include <string.h>
#include "hndshk_Data.h"
#include "states.h"
#include "RCReverbFR1RxF.h"

/* =============================================== */
/* Global variable declarations                    */
/* =============================================== */
int16  gs_C_TonesCnt = 0;

/*^^^
*-------------------------------------------------------------------
########               ########
######## RX ROUTINES   ########
########               ########
*-------------------------------------------------------------------
*^^^
*/

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCRecovRxF
 *
 *  Description:  Detects C_Recov signal and then determines the threshold for
 *  detecting C_Reverb_FR1 signal. After detection of R_C_REVERB1_DET_CNT consecutive
 *  symbols of C_Reverb_FR1, the state machine moves to R_C_REVERB_FR1_RX state.
 *
 *  Prototype: void RCRecovRxF(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *
 *  Substates:
 *      R_C_RECOV_DETECT        - Detect the C_RECOV signal.
 *      R_C_RECOV_MEASURE_POWER - Measure the RX power for R_C_RECOV_THR_LEN and
 *                                establish a threshold for detection of C_REVERB_FR1.
 *      R_C_RECOV_COUNT_SYMBOLS - Continue to measure RX power and declare
 *                                C_Reverb_FR1 received if threshold exceeds for
 *                                R_C_REVERB1_DET_CNT consecutive symbols.
 *
 *  Notes: implements state R_C_RECOV_RX
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates */
/* =============================================== */
#define R_C_RECOV_DETECT        (0)
#define R_C_RECOV_DETECT_REVERB (1)


void RCRecovRxF(void) {

   switch (gs_RxSubState) {

      case R_C_RECOV_DETECT:

         if (gl_RxSymbolCount == 0) {
            /* Indicate fast retrain is in progress. */
            STATArray[STAT_MacroState] = STAT_FastRetrainState;

            gs_C_TonesCnt = 0;
            gs_RxSubStateCnt = 0;

            guc_FdqTrainingState = TRAINING_WAITING;
            guc_TdqTrainingState = TRAINING_WAITING;
            guc_EcTrainingState  = TRAINING_WAITING;
            guc_AlignmentTrainingState = TRAINING_WAITING;

            /* Clear DEC, FDQ, TDQ, AEC. */
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,UnityTDQ);
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,DisableFDQ);
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,ClearDEC);
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,ClearAEC);

            /* Turn off PLL. */
            gft_EnablePLL = FALSE;

            /* Reset LoadTdq Flag which may have been set to FALSE based on  */
            /* Multi-TDQ processig in Full-Init Medley.                      */

         }

         if( DetectTone(gsa_RxToneBuf, C_RECOV_TONE, C_RECOV_TONE_MIN, C_RECOV_TONE_MAX, (DETECT_SCALE*256)) ) {

            /* C_RECOV detected. */
            gs_RxSubStateCnt++;

            /* If C_TONES is not detected, reset the counter. */
            gs_C_TonesCnt = 0;

            /* If C_RECOV is detected R_C_RECOV_CNT consecutive times declare */
            /* ATU-C is sending C_RECOV tones */
            if (gs_RxSubStateCnt == R_C_RECOV_CNT) {
               gs_RxSubState = R_C_RECOV_DETECT_REVERB;
               gs_RxSubStateCnt = 0;
            }
         }
         else {

            /* If C_RECOV is not detected, reset the counter. */
            gs_RxSubStateCnt = 0;

            /*  Check if C_TONES is being sent by CO. If yes, then abort FR */
            /*  and go back to G.handshake */
#ifdef ISDN
            if ( DetectMultiTones(gsa_RxToneBuf, (CONSTANT int16*)gsa_DnCarSetB43_J43, NUM_CARRIERS_IN_SET, NUM_CARRIERS_REQUIRED, DETECT_SCALE << 8) )
#else
            if ( DetectMultiTones(gsa_RxToneBuf, (CONSTANT int16*)gsa_DnCarSetA43, NUM_CARRIERS_IN_SET, NUM_CARRIERS_REQUIRED, DETECT_SCALE << 8) )
#endif
               /* C_TONES detected. */
               gs_C_TonesCnt++;
            else
               /* If C_TONES is not detected, reset the counter. */
               gs_C_TonesCnt = 0;

            /* If C_TONES is detected R_C_RECOV_CNT consecutive times go to G.hs */
            if(gs_C_TonesCnt == R_C_RECOV_CNT) {
               gs_TxNextState = FAIL_TX;
               gs_RxNextState = FAIL_RX;
               gpF_TxStateFunc = (PtrToFunc)ExceptionHandler;
               gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

               /* set exception handler variables */
               gus_ExceptionState   = gs_RxState;
               gus_ExceptionCode = E_CODE_C_TONES;
            }
         }
         break;

      case R_C_RECOV_DETECT_REVERB: /* wait for tone to be removed */

         /* Detect reverb signal as absence of C_RECOV tones. */
         if( !DetectTone(gsa_RxToneBuf, C_RECOV_TONE, C_RECOV_TONE_MIN, C_RECOV_TONE_MAX, (DETECT_SCALE*256)) )
            /* C_REVERB detected. */
            gs_RxSubStateCnt++;
         else
            /* If C_REVERB is not detected, reset the counter. */
            gs_RxSubStateCnt = 0;

         /* Change states when C_REVERB has been detected R_C_REVERB1_DET_CNT */
         /* consecutive times. */
         if (gs_RxSubStateCnt == R_C_REVERB1_DET_CNT)
         {
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,Disable_FFT_Reordering);
            gs_RxNextState = R_C_REVERB_FR1_RX;
            gpF_RxStateFunc = (PtrToFunc)RCReverbFR1RxF;
         }
         break;

   } /* switch(s_RxSubState) */

   /*  check for timeout */
   if(gl_RxSymbolCount >= R_C_RECOV_TIMEOUT) {

      /*  go to fail states */
      gs_TxNextState = FAIL_TX;
      gs_RxNextState = FAIL_RX;
      gpF_TxStateFunc = (PtrToFunc)ExceptionHandler;
      gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

      /*  set exception handler variables */
      gus_ExceptionState   = gs_RxState;
      gus_ExceptionCode = E_CODE_RCRecovRx_SingnalEnd_TIMEOUT;
   }
}

#undef R_C_RECOV_DETECT
#undef R_C_RECOV_DETECT_REVERB

