/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCReverbFR1RxF.c
 *
 *   Fast Retrain RX State Functions for ATU-R.
 *   Covering the RX states: R_C_REVERB_FR1
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include "cmv.h"
#include "rt_tones.h"
#include "fifo.h"
#include "rx_ops.h"
#include "pll.h"
#include "accum32.h"
#include "frm_sync.h"
#include "fretrain.h"
#include "detect.h"
#include <string.h>
#include "memsetbf.h"
#include "bufmisc.h"
#include "frm_sync_b.h"
#include "states.h"
#include "RCPilotFR1RxF.h"
#include "RReverbFrTxF.h"

/*^^^
*-------------------------------------------------------------------
########               ########
######## RX ROUTINES   ########
########               ########
*-------------------------------------------------------------------
*^^^
*/

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCReverbFR1RxF
 *
 *  Description: Receives the C_Reverb signal from the ATU-C and calculates
 *  "Relative Downstream Fast Retrain Power Cutback",
 *  performs frame alignment.  EC, TDQ, and FDQ
 *  are turned off during frame alignment (turned off when exiting
 *  R_C_RECOV_RX), after frame alignment they are  turned back on.
 *
 *  Prototype: void RCReverbFR1RxF(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *
 *  Substates:
 *      R_C_REVERB_FR1_RX_INITIALIZE        - Initialize the phase lock loop (PLL)
 *                                            parameters and power estimate parameters.
 *      R_C_REVERB_FR1_RX_CALCULATE_CUTBACK - Calculate relative downstream Fast
 *                                            Retrain power cutback.
 *      R_C_REVERB_FR1_RX_AVERAGE_FRAME     - Accumulate an average frame of time
 *                                            samples to be used for frame alignment.
 *      R_C_REVERB_FR1_RX_FRAME_ALIGNMENT   - Calculate frame alignment by converting
 *                                            the representative frame to the frequency
 *                                            domain and finding the alignment offset.
 *      R_C_REVERB_FR1_RX_LOCK_PLL          - Wait until the PLL has acquired lock.
 *                                            When it does, notify the transmitter to
 *                                            begin transmitting the R_REVERB_FR1 signal.
 *      R_C_REVERB_FR1_RX_DETECT_PILOT      - Detect the beginning of C_PILOT_FR1 signal.
 *
 *  Notes: implements state R_C_REVERB_FR1_RX
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* global vairables used by this function only */
/* =============================================== */


/* =============================================== */
/* substates */
/* =============================================== */
#define R_C_REVERB_FR1_RX_INITIALIZE                (0)
#define R_C_REVERB_FR1_RX_LOCK_PLL                  (1)
#define R_C_REVERB_FR1_RX_AVERAGE_FRAME_FOR_RDC     (2)
#define R_C_REVERB_FR1_RX_CALCULATE_CUTBACK         (3)
#define R_C_REVERB_FR1_RX_AVERAGE_FRAME             (4)
#define R_C_REVERB_FR1_RX_FRAME_ALIGNMENT           (5)
#define R_C_REVERB_FR1_RX_WAIT                      (6)
#define R_C_REVERB_FR1_RX_DETECT_PILOT              (7)

void RCReverbFR1RxF(void){

   static int16 gs_RxSubStateCnt1;

   int16   s_new_position;

   switch (gs_RxSubState) {

      case R_C_REVERB_FR1_RX_INITIALIZE:

         /* Switch to time-domain processing. */
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,MoveToFrameStartInt);

         /* Get the reference phase of pilot signal. */
         ResetPllRefTone(gsa_RxPilotTone[0], gsa_RxPilotTone[1]);

         /* Turn on PLL. */
         gft_EnablePLL = TRUE;

         /* Set PLL loop filter parameters to fast converge. */
         ResetPLL((int16)gs_Kp_Fast, (int16)gs_Ki_Fast, (int16)PLL_HALF_PI_RADIANS);

         /* Clear accumulator buffer. */
         MemSetBuffer((int16 *)(void *)gla_RxAccumBuf,0,0,(int16)(sizeof(int32)*gs_RxSamplesPerFrame));

         gs_RxSubState = R_C_REVERB_FR1_RX_LOCK_PLL;
         gs_RxSubStateCnt = 0;

         break;

      case R_C_REVERB_FR1_RX_LOCK_PLL:

         /*  wait until the PLL has acquired lock if it hasn't */
         /*  the assumption is that PLL_ACQUISITION_LEN0 is greater than  */
         /*  the time needed to do PGA setting, power estimate and frame alignment */

         gs_RxSubStateCnt++;

         if (gs_RxSubStateCnt == 1)
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,DisableFDQDoneNTC_DisableGetRxTones);

         if (gs_RxSubStateCnt == PLL_FAST_ACQUISITION_LEN) /* Reset PLL loop filter parameters to slow converge parameters */
            ResetPLL((int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS);

            if (gs_RxSubStateCnt == (PLL_ACQUISITION_LEN0_FR-R_C_REVERB1_DET_CNT-2))
         {
            gs_RxSubState = R_C_REVERB_FR1_RX_AVERAGE_FRAME_FOR_RDC;
            gs_RxSubStateCnt = 0;
         }
         break;

      case R_C_REVERB_FR1_RX_AVERAGE_FRAME_FOR_RDC:

         gs_RxSubStateCnt++;

         /* Accumulate time domain data. */
         Accum16to32(gla_RxAccumBuf, 0, gsa_RxToneBuf, 0, gs_RxSamplesPerFrame);

         /* Calculate Relative Downstream Fast Retrain Power Cutback. */
         if (gs_RxSubStateCnt == RDC_ACCUM_SYMBOLS) {

            AddFunctionToBkgdFifo((PtrToBkgdFunc)CalcCutBack);
            guc_AlignmentTrainingState = TRAINING_IN_PROGRESS;
            gs_RxSubState = R_C_REVERB_FR1_RX_CALCULATE_CUTBACK;
         }
         break;

         case R_C_REVERB_FR1_RX_CALCULATE_CUTBACK:

         if(guc_AlignmentTrainingState == TRAINING_DONE) {

            /* Clear accumulator buffer. */
               MemSetBuffer((int16 *)(void *)gla_RxAccumBuf,0,0,(int16)(sizeof(int32)*gs_RxSamplesPerFrame));

            gs_RxSubState = R_C_REVERB_FR1_RX_AVERAGE_FRAME;
            gs_RxSubStateCnt = 0;
         }
         break;

      case R_C_REVERB_FR1_RX_AVERAGE_FRAME:

         gs_RxSubStateCnt++;

         /* Accumulate time-domain data. */
         Accum16to32(gla_RxAccumBuf, 0, gsa_RxToneBuf, 0, gs_RxSamplesPerFrame);

         if (gs_RxSubStateCnt == (R_C_REVERB_FR1_AC_LEN-1))
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,MoveToFdqDoneInt);

         if (gs_RxSubStateCnt == R_C_REVERB_FR1_AC_LEN) {
            /* Compute average of the accumulated frames. */
            /* Note: This is done in-place. */
            RightShiftAndRound32to16(gsa_RxRepFrameAlignBuf, 0,
               gla_RxAccumBuf, 0, gs_RxSamplesPerFrame, LOG2_R_C_REVERB_FR1_AC_LEN);

            /* Switch to frequency-domain processing. */
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,EnableFDQDoneNTC_EnableGetRxTones);

            /* Compute frame alignment. */
            guc_AlignmentTrainingState = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgAlignmentTraining);

            gs_RxSubState = R_C_REVERB_FR1_RX_FRAME_ALIGNMENT;
         }
         break;

      case R_C_REVERB_FR1_RX_FRAME_ALIGNMENT:

#ifdef USE_ENGINE_FOR_BG_FFTS
         if (gft_StartEngineFFT)
            EngineFFT_StateMachine();
#endif
         if(guc_AlignmentTrainingState == TRAINING_DONE) {

            /*  set flag for I/O routine to perform realignment of input data */
            if (gus_SyncOffset != 0) {

               if (gs_PreSyncOffset > 0)
               {
                  s_new_position = gs_PreSyncOffset+gus_SyncOffset;
                  if (s_new_position > gs_RxSamplesPerFrame)
                     s_new_position -= gs_RxSamplesPerFrame;
                  gs_PreSyncOffset = s_new_position;
               }
               else
               {
                  gs_PreSyncOffset = (int16)gus_SyncOffset;
               }
               FrameAlign();

               /* Turn off PLL: */
               gft_EnablePLL = FALSE;
            }

            gs_RxSubState =  R_C_REVERB_FR1_RX_WAIT;
            gs_RxSubStateCnt = 0;
         }
         break;

      case R_C_REVERB_FR1_RX_WAIT:

         gs_RxSubStateCnt ++;

         if(gs_RxSubStateCnt == 1)
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,ResetRxAlign);

            if(gs_RxSubStateCnt == 4) {

            if(gft_EnablePLL == FALSE) {
               gft_EnablePLL = TRUE;
               ResetPllRefTone(gsa_RxPilotTone[0], gsa_RxPilotTone[1]);
            }
         }

         /* notify TX to begin transmitting R_REVERB_FR1 signal (after receiving */
         /* the minimum of 256 symbols C_REVERB-FR1 required by G992.2)*/
         if(gl_RxSymbolCount >= (256-R_C_REVERB1_DET_CNT) ) {
            gs_TxNextState = R_REVERB_FR1_TX;
            gpF_TxStateFunc = (PtrToFunc)RReverbFrTxF;
            gs_RxSubState = R_C_REVERB_FR1_RX_DETECT_PILOT;
            gs_RxSubStateCnt = 0;
            gs_RxSubStateCnt1 = 0;
         }
         break;

      case R_C_REVERB_FR1_RX_DETECT_PILOT:

         gs_RxSubStateCnt1++;

         /*  detect pilot tone */
         if( DetectTone(gsa_RxToneBuf, gs_CPilotTone, (int16)(gs_CPilotTone-5), (int16)(gs_CPilotTone+5), (DETECT_SCALE*256)) ) {
            gs_RxSubStateCnt++;
         }
         else {
            gs_RxSubStateCnt = 0;
         }

         if (gs_RxSubStateCnt == R_C_REVERB1_DET_CNT) {
            gs_RxNextState = R_C_PILOT_FR1_RX;
            gpF_RxStateFunc = (PtrToFunc)RCPilotFR1RxF;
         }

         /*  check for timeout */
         if(gs_RxSubStateCnt1 >= R_C_REVERB_FR1_TIMEOUT) {
            gs_RxNextState = FAIL_RX;
            gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

            /*  set exception handler variables */
            gus_ExceptionState   = gs_RxState;
            gus_ExceptionCode = E_CODE_RCReverbFR1Rx_Failure;
         }
         break;
   }  /*  switch (s_RxSubState) */
}

#undef R_C_REVERB_FR1_RX_INITIALIZE
#undef R_C_REVERB_FR1_RX_LOCK_PLL
#undef R_C_REVERB_FR1_RX_AVERAGE_FRAME_FOR_RDC
#undef R_C_REVERB_FR1_RX_CALCULATE_CUTBACK
#undef R_C_REVERB_FR1_RX_AVERAGE_FRAME
#undef R_C_REVERB_FR1_RX_FRAME_ALIGNMENT
#undef R_C_REVERB_FR1_RX_WAIT
#undef R_C_REVERB_FR1_RX_DETECT_PILOT
