/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCReverbFR2RxF.c
 *
 *   Fast Retrain RX State Functions for ATU-R.
 *   Covering the RX states: R_C_REVERB_FR2
 *
 *   Notes:
 *
 *   R_C_MSG_FR1 is implemented in analysi2.c
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_tones.h"
#include "snr.h"
#include "pga_set.h"
#include "rx_ops.h"
#include "dsp_op.h"
#include "pll.h"
#include "gdata.h"
#include "frm_sync.h"
#include "tdq_init.h"
#include "fdq_init.h"
#include "fifo.h"
#include "fretrain.h"
#include "accum32.h"
#include "xrtstate.h"
#include "cmv.h"
#include "profile2.h"
#include "crc16.h"
#include <string.h>
#include "vecpwr.h"
#include "detect.h"
#include "memsetbf.h"
#include "bufmisc.h"
#include "afe.h"
#include "frm_sync_b.h"
#include "states.h"
#include "RCMsgFRRxF.h"


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCReverbFR2RxF
 *
 *  Description: Receives the C_Reverb signal from the ATU-C. FDQ is trained
 *  during this state in order to enable the decoding of C_MSG_FR1.
 *
 *  Prototype: void RCReverbFR2RxF(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *
 * Substates:
 *      R_C_REVERB_FR2_RX_WAIT            - Clear the RxAccumBuf buffer and wait for
 *                                          the channel to clear.
 *      R_C_REVERB_FR2_RX_AVERAGE_FRAME   - Accumulate a representative frame of time
 *                                          samples and average over
 *                                          NUM_FDQ_TRAIN_SYMBOLS_IN_REVER_FR2 samples.
 *      R_C_REVERB_FR2_RX_BEGIN_FDQ_TRAIN - Perform FDQ training. Note that the function
 *                                          FDQTrain() does not execute in the duration
 *                                          of one symbol period. A real time system must
 *                                          call FDQTrain() as a background process. To
 *                                          emulate a real time system the state variable
 *                                          guc_FdqTrainingState is set to TRAINING_IN_PROGRESS
 *                                          by the state machine. The completion of
 *                                          FDQTrain will reset this state variable to
 *                                          TRAINING_DONE. The state machine will monitor this
 *                                          flag and change states when it sees that
 *                                          the flag has been reset.
 *      R_C_REVERB_FR2_RX_END_FDQ_TRAIN   - Check flag to see if FDQ training is complete.
 *                                          If guc_FdqTrainingState == TRAINING_DONE, the FDQ
 *                                          training is done. All the filter states are
 *                                          reset since they will be turned on from this
 *                                          point on.
 *      R_C_REVERB_FR2_RX_DETECT_SEGUE    - Detect SEGUE for R_C_SEGUE_FR1_LEN symbols
 *                                          and then transition to R_C_MSG_FR1_RX.
 *
 *  Notes:implements state R_C_REVERB_FR2_RX
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates */
/* =============================================== */
#define R_C_REVERB_FR2_RX_WAIT            (0)
#define R_C_REVERB_FR2_RX_AVERAGE_FRAME   (1)
#define R_C_REVERB_FR2_RX_BEGIN_FDQ_TRAIN (2)
#define R_C_REVERB_FR2_RX_END_FDQ_TRAIN   (3)
#define R_C_REVERB_FR2_RX_DETECT_SEGUE    (4)

void RCReverbFR2RxF(void){

   int16  s_ToneType;

   switch (gs_RxSubState) {

      case R_C_REVERB_FR2_RX_WAIT:

         if(gl_RxSymbolCount == 0)
         {
         /* Prepare to accumulate frequency domain */
         /* data for the FDQ training */
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,DisableFDQ);
         }

         /* wait for channel stablized */
         if(gl_RxSymbolCount == R_C_REVERB_FR2_WT_LEN-1) {

            /* clear RxAccumBuf for FDQ Accum*/
            MemSetBuffer((int16 *)(void *)gla_RxAccumBuf,0,0,(int16)(sizeof(int32)*2*gs_RxNumTones));

            gs_RxSubState = R_C_REVERB_FR2_RX_AVERAGE_FRAME;
            gs_RxSubStateCnt = 0;
         }

         break;

      case R_C_REVERB_FR2_RX_AVERAGE_FRAME:

         gs_RxSubStateCnt++;

         Accum16to32(gla_RxAccumBuf, 0, gsa_RxToneBuf, 0, (int16)(2*gs_RxNumTones));

         /* compute average of the accumulated frequency domain frames */
         if(gs_RxSubStateCnt == NUM_FDQ_TRAIN_SYMBOLS_IN_REVER_FR2)
         {
            gft_CopyRxBuffer = FALSE;

            RightShiftAndRound32to16(gsa_RxRepFDQTrainBuf, 0,
               gla_RxAccumBuf, 0, (int16)(2*gs_RxNumTones), LOG2_NUM_FDQ_TRAIN_SYMBOLS_IN_REVER_FR2);

            gs_RxSubState = R_C_REVERB_FR2_RX_BEGIN_FDQ_TRAIN;
         }
         break;

      case R_C_REVERB_FR2_RX_BEGIN_FDQ_TRAIN:
         /* ==================================================================== */
         /*  FDQ training */
         /*  NOTE: FDQTrain() does not execute in the duration of one symbol  */
         /*  period.  A real time system must call FDQTrain() as a background */
         /*  process.  To emulate a real time system the state variable guc_FdqTrainingState */
         /*  is set by the state machine.  The completion of FDQTrain will reset this */
         /*  flag.  The state machine will monitor this flag and change states */
         /*  when it sees that the flag has been reset. */
         /* ====================================================================    */
         guc_FdqTrainingState = TRAINING_IN_PROGRESS;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)FDQTrain);
         gs_RxSubState = R_C_REVERB_FR2_RX_END_FDQ_TRAIN;
         break;

      case R_C_REVERB_FR2_RX_END_FDQ_TRAIN:
         /* If guc_FdqTrainingState == TRAINING_DONE, means the FDQ training is done */
         if (guc_FdqTrainingState == TRAINING_DONE) {

            gft_CopyRxBuffer = TRUE;

            /* Load FDQ taps. */
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadFDQ);

            gs_RxSubState = R_C_REVERB_FR2_RX_DETECT_SEGUE;
            gs_RxSubStateCnt = 0;
         }
         break;

      case R_C_REVERB_FR2_RX_DETECT_SEGUE:


      /*  detect C_Segue */

         s_ToneType = DetectReverbSegue(gsa_RSDetect_Bins, gsa_RSDetect_PNSeq, gs_RSDetect_NumBins, NULL, NULL);

         if (s_ToneType == C_SEGUE)
            gs_RxSubStateCnt++;
         else
            gs_RxSubStateCnt = 0;

         if (gs_RxSubStateCnt == R_C_SEGUE_FR1_LEN) {    /*  declare tone valid  */
            gt_StateMachCntrl.puc_RXmessage = guca_R_C_Msg_FR1;
            gs_RxNextState = R_C_MSG_FR1_RX;
            gpF_RxStateFunc = (PtrToFunc)RCMsgFRRxF;
         }
         else if(gl_RxSymbolCount >= R_C_REVERB_FR2_RX_LEN + 50) {   /* allow extra 50 symbols */
                                                   /* before declaring timeout */

            gs_RxNextState = FAIL_RX;
            gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

            /* Set exception handler variables */
            gus_ExceptionState   = gs_RxState;
            gus_ExceptionCode = E_CODE_RCReverbFR2Rx_C_Segue_Failure;
         }
         break;

   }  /* switch (s_RxSubState) */
}

#undef R_C_REVERB_FR2_RX_WAIT
#undef R_C_REVERB_FR2_RX_AVERAGE_FRAME
#undef R_C_REVERB_FR2_RX_BEGIN_FDQ_TRAIN
#undef R_C_REVERB_FR2_RX_END_FDQ_TRAIN
#undef R_C_REVERB_FR2_RX_DETECT_SEGUE

