/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCReverbFR3RxF.c
 *
 *   Fast Retrain RX State Functions for ATU-R.
 *   Covering the RX states: R_C_REVERB_FR3
 *
 *   Notes:
 *
 *   R_C_MSG_FR1 is implemented in analysi2.c
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_tones.h"
#include "snr.h"
#include "pga_set.h"
#include "rx_ops.h"
#include "dsp_op.h"
#include "pll.h"
#include "gdata.h"
#include "frm_sync.h"
#include "tdq_init.h"
#include "fdq_init.h"
#include "fifo.h"
#include "fretrain.h"
#include "accum32.h"
#include "xrtstate.h"
#include "cmv.h"
#include "profile2.h"
#include "crc16.h"
#include <string.h>
#include "vecpwr.h"
#include "detect.h"
#include "memsetbf.h"
#include "bufmisc.h"
#include "afe.h"
#include "frm_sync_b.h"
#include "states.h"
#include "RCPilotFR2RxF.h"

#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCReverbFR3RxF
 *
 *  Description:  Receives the C_Reverb signal from the ATU-C and determines
 *  PGA setting, performs frame alignment.  EC, TDQ, and FDQ  are turned off
 *  during frame alignment, after frame alignment they are turned back on.
 *
 *  Prototype: void RCReverbFR3RxF(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *
 * Substates:
 *      R_C_REVERB_FR3_RX_INITIALIZE        - Perform initialization (clear the
 *                                            accumulator for calculating average
 *                                            power) and wait for the transmitter
 *                                            to transition to the R_REVEB_FR3
 *                                            state.
 *      R_C_REVERB_FR3_RX_SET_PGA           - Set the PGA by computing the
 *                                            received power in each symbol and
 *                                            averaging over several accumulated
 *                                            frames, and computing the
 *                                            recommended PGA adjustment.
 *      R_C_REVERB_FR3_RX_ACCUMULATE_FRAME  - Perform frame alignment by
 *                                            accumulating a representative
 *                                            frame of time samples and averaging
 *                                            over several accumulated frames.
 *      R_C_REVERB_FR3_RX_FRAME_ALIGN       - Calculate frame alignment by
 *                                            converting the representative
 *                                            frame to the frequency domain and
 *                                            finding the alignment offset.
 *      R_C_REVERB_FR3_RX_WAIT              - Wait for the end of this state.
 *
 *  Notes: implements state R_C_REVERB_FR3_RX
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates */
/* =============================================== */
#define R_C_REVERB_FR3_RX_INITIALIZE       (0)
#define R_C_REVERB_FR3_RX_SET_PGA          (1)
#define R_C_REVERB_FR3_RX_ACCUMULATE_FRAME (2)
#define R_C_REVERB_FR3_RX_FRAME_ALIGN      (3)
#define R_C_REVERB_FR3_RX_WAIT             (4)
#define R_C_REVERB_FR3_PGA_WAIT            (5)

void RCReverbFR3RxF(void){

    int32 l_Psym;
   int16 s_new_position;


    switch (gs_RxSubState) {

    case R_C_REVERB_FR3_RX_INITIALIZE:

   /* Wait for TX side goes to R_REVEB_FR3 state */
         if (gs_TxState == R_REVERB_FR3_TX) {

            gs_RxSubStateCnt++;

            if(gs_RxSubStateCnt == 1)
               AddFunctionToFifo(gp_RxLoadingFunctionFifo,MoveToFrameStartInt);

            if(gs_RxSubStateCnt == 2)
               AddFunctionToFifo(gp_RxLoadingFunctionFifo,DisableFDQDoneNTC_DisableGetRxTones);

            if((gs_RxSubStateCnt > 2) && (gl_TxSymbolCount >= (R_C_REVERB_FR3_WT_LEN-1))) {

               gl_Pa = 0;      //clear average power accumulator;
               gs_RxSubStateCnt = 0;
               gs_RxSubState = R_C_REVERB_FR3_RX_SET_PGA;
            }
         }
         break;

   /* ==================================================================== */
    /* set the PGA */
    /* ==================================================================== */
      case R_C_REVERB_FR3_RX_SET_PGA:

        /*  accumulate RX power, set PGA */
        gs_RxSubStateCnt++;

        /*  compute received power in current symbol */
      l_Psym = VectorPower(gsa_RxToneBuf, 0, gs_RxSamplesPerFrame, gs_Log2RxSamplesPerFrame);

        /*  accumulate average power  */
        l_Psym = round(l_Psym, LOG2_PGA_ACCUM_SYMBOLS);
        gl_Pa += l_Psym;

        if (gs_RxSubStateCnt == PGA_ACCUM_SYMBOLS)
        {
      /*  compute recommended PGA adjustment */
      gs_PGA_required = PD_DB - ConvertToDB(gl_Pa) + gs_PGA_set;  /* recommended gain */
      gs_PGA_required -= gs_PGA_margin;            /* reduce the PGA setting by the margin */
      guc_PgaTrainingState = TRAINING_IN_PROGRESS;
      AddFunctionToBkgdFifo((PtrToBkgdFunc)AFED_BgPGA);

      /* Clear accumulator buffer. */
      MemSetBuffer((int16 *)(void *)gla_RxAccumBuf,0,0,(int16)(sizeof(int32)*gs_RxSamplesPerFrame));

      /* Change substate. */
      gs_RxSubState = R_C_REVERB_FR3_PGA_WAIT;
      gs_RxSubStateCnt = 0;

         //Enable PLL in GetRxTone()
//       guc_CommandedPllState = PLL_RESET_REFERENCE_TONE;
        }
        break;

   case R_C_REVERB_FR3_PGA_WAIT:

      if (guc_PgaTrainingState == TRAINING_DONE){
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_SetPga);
         gs_RxSubState = R_C_REVERB_FR3_RX_ACCUMULATE_FRAME;
      }
      break;

   case R_C_REVERB_FR3_RX_ACCUMULATE_FRAME:

      gs_RxSubStateCnt++;

      /* Accumulate data for frame alignment. */
      Accum16to32(gla_RxAccumBuf, 0, gsa_RxToneBuf, 0, gs_RxSamplesPerFrame);

      if (gs_RxSubStateCnt == R_C_REVERB_FR3_AC_LEN) {
         /*  compute average of the accumulated frames */
         RightShiftAndRound32to16(gsa_RxRepFrameAlignBuf, 0,
            gla_RxAccumBuf, 0, gs_RxSamplesPerFrame, LOG2_R_C_REVERB_FR3_AC_LEN);

         gs_RxSubState = R_C_REVERB_FR3_RX_FRAME_ALIGN;
         guc_AlignmentTrainingState = TRAINING_IN_PROGRESS;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)BgAlignmentTraining);
      }
      break;

    case R_C_REVERB_FR3_RX_FRAME_ALIGN:

      if(guc_AlignmentTrainingState == TRAINING_DONE) {
         /*  set flag for I/O routine to perform realignment of input data */
         if (gus_SyncOffset != 0)
         {
            if (gs_PreSyncOffset > 0)
            {
               s_new_position = gs_PreSyncOffset+gus_SyncOffset;
               if (s_new_position > gs_RxSamplesPerFrame)
                  s_new_position -= gs_RxSamplesPerFrame;
               gs_PreSyncOffset = s_new_position;
            }
            else
            {
               gs_PreSyncOffset = (int16)gus_SyncOffset;
            }
            FrameAlign();

            //Reset PLL reference tone since frame is realigned
            guc_CommandedPllState = PLL_RESET_REFERENCE_TONE;
         }
         gs_RxSubState = R_C_REVERB_FR3_RX_WAIT;
         gs_RxSubStateCnt = 0;
      }
      break;

   /* ==================================================================== */
   /* Wait for the end of this state */
   /* ==================================================================== */
   case R_C_REVERB_FR3_RX_WAIT:

      if(gs_RxSubStateCnt == 0)
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,ResetRxAlign);

      gs_RxSubStateCnt++;

      if (gl_RxSymbolCount == (R_C_REVERB_FR3_RX_LEN - 3)){
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,MoveToFdqDoneInt);
      }
      if (gl_RxSymbolCount == (R_C_REVERB_FR3_RX_LEN - 2)){
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,EnableFDQDoneNTC_EnableGetRxTones);
      }
      if (gl_RxSymbolCount == (R_C_REVERB_FR3_RX_LEN - 1)) {
         gs_RxNextState = R_C_PILOT_FR2_RX;
         gpF_RxStateFunc = (PtrToFunc)RCPilotFR2RxF;
      }
      break;
   }  /* switch (s_RxSubState) */
}

#undef R_C_REVERB_FR3_RX_INITIALIZE
#undef R_C_REVERB_FR3_RX_SET_PGA
#undef R_C_REVERB_FR3_RX_ACCUMULATE_FRAME
#undef R_C_REVERB_FR3_RX_FRAME_ALIGN
#undef R_C_REVERB_FR3_RX_WAIT

