/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCReverbFR5RxF.c
 *
 *   Fast Retrain RX State Functions for ATU-R.
 *   Covering the RX states: R_C_REVERB_FR5
 *
 *   Notes:
 *
 *   R_C_MSG_FR1 is implemented in analysi2.c
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_tones.h"
#include "snr.h"
#include "pga_set.h"
#include "rx_ops.h"
#include "dsp_op.h"
#include "pll.h"
#include "gdata.h"
#include "frm_sync.h"
#include "tdq_init.h"
#include "fdq_init.h"
#include "fifo.h"
#include "fretrain.h"
#include "accum32.h"
#include "xrtstate.h"
#include "cmv.h"
#include "profile2.h"
#include "crc16.h"
#include <string.h>
#include "vecpwr.h"
#include "detect.h"
#include "memsetbf.h"
#include "bufmisc.h"
#include "afe.h"
#include "frm_sync_b.h"
#include "states.h"
#include "RCPilot3Tref2RxF.h"
#include "pll.h"

extern void EstimateChannel(int16 *psa_CapturedReverbFrame);
void BgEstimateChannel(void)
{
   /* Used by fast retrain */

   /*  save Reverb frame for TDQ scaling */
   memcpy(gsa_MultiTdqRxSignal, gsa_RxRepFrameAlignBuf, sizeof(int16)*gs_RxSamplesPerFrame);

   /*  estimate the channel impulse response */
   EstimateChannel(gsa_RxRepFrameAlignBuf);

   memcpy(&(gsa_RxRepFrameAlignBuf[gs_RxSamplesPerFrame]), gsa_MultiTdqRxSignal, sizeof(int16)*gs_RxSamplesPerFrame);
}


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : RCReverbFR5RxF
 *
 *  Description:  Receives the C_Reverb signal so that the ATU-R may
 *  re-train the TDQ and FDQ
 *
 *  Prototype: none
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *
 * Substates:
 *      R_C_REVERB_FR5_RX_INITIALIZE        - Wait for channel to stabilize.
 *      R_C_REVERB_FR5_RX_AVERAGE_FRAME     - Accumulate a representative frame of
 *                                            time samples and averaging over
 *                                            several samples.
 *      R_C_REVERB_FR5_RX_BEGIN_TDQ_TRAIN   - Perform TDQ training. Note that the
 *                                            function TdqInit() does not execute
 *                                            in the duration of one symbol period.
 *                                            A real time system must call TdqInit()
 *                                            as a background process.  To emulate a
 *                                            real time system the state variable
 *                                            guc_TdqTrainingState is set to done by
 *                                            the state machine. The completion of TDQTrain
 *                                            will reset this flag. The state
 *                                            machine will monitor this flag and
 *                                            change states when it sees that the
 *                                            flag has been reset.
 *      R_C_REVERB_FR5_RX_END_TDQ_TRAIN     - Check flag to see if TDQ training is
 *                                            complete. If guc_TdqTrainingState ==
 *                                            TRAINING_DONE, the FDQ training is done.
 *      R_C_REVERB_FR5_RX_AVERAGE_FRAME_2   - Re-gather frames to check frame
 *                                            alignment with TDQ on. Skip the first
 *                                            TDQ_STABLIZE_LEN frames to allow the
 *                                            TDQ filter state to stablize and then
 *                                            start accumulation of frames.
 *      R_C_REVERB_FR5_RX_FRAME_ALIGN_2     - Check frame alignment with TDQ turned
 *                                            on by finding the symbol offset.
 *      R_C_REVERB_FR5_RX_AVERAGE_FRAME_3   - Accumulate a representative frame of
 *                                            time samples with TDQ turned on and
 *                                            average over several samples.
 *      R_C_REVERB_FR5_RX_BEGIN_FDQ_TRAIN   - Perform FDQ training with TDQ turned
 *                                            on. Note that the function FDQTrain()
 *                                            does not execute in the duration of
 *                                            one symbol period.  A real time system
 *                                            must call FDQTrain() as a background
 *                                            process.  To emulate a real time system
 *                                            the flag guc_FdqTrainingState is set
 *                                            to TRAINING_IN_PROGRESS by the state machine.
 *                                            The completion of FDQTrain will reset
 *                                            this flag to TRAINING_DONE. The
 *                                            state machine will monitor this flag
 *                                            and change states when it sees that
 *                                            the flag has been reset.
 *      R_C_REVERB_FR5_RX_END_FDQ_TRAIN     - Check flag to see if FDQ training is
 *                                            complete. If guc_FdqTrainingState ==
 *                                            TRAINING_DONE, the FDQ training is done.
 *
 *  Notes:implements state R_C_REVERB_FR5_RX
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates */
/* =============================================== */
#define R_C_REVERB_FR5_RX_INITIALIZE        (0)
#define R_C_REVERB_FR5_RX_AVERAGE_FRAME     (1)
#define R_C_REVERB_FR5_RX_BEGIN_TDQ_TRAIN   (2)
#define R_C_REVERB_FR5_RX_END_TDQ_TRAIN     (3)
#define R_C_REVERB_FR5_RX_AVERAGE_FRAME_2   (4)
#define R_C_REVERB_FR5_RX_FRAME_ALIGN_2     (5)
#define R_C_REVERB_FR5_RX_AVERAGE_FRAME_3   (6)
#define R_C_REVERB_FR5_RX_BEGIN_FDQ_TRAIN   (7)
#define R_C_REVERB_FR5_RX_END_FDQ_TRAIN     (8)
#define R_C_REVERB_FR5_RX_WAIT              (9)

void RCReverbFR5RxF(void) {

   int16 s_new_position;

    switch (gs_RxSubState) {

    /* ==================================================================== */
    /* perform TDQ training */
    /* ==================================================================== */
    case R_C_REVERB_FR5_RX_INITIALIZE:
      if(gl_RxSymbolCount == (R_C_REVERB_FR5_WT_LEN-3)) {
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,MoveToFrameStartInt);
      }
      if(gl_RxSymbolCount == (R_C_REVERB_FR5_WT_LEN-2)) {
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,DisableFDQDoneNTC_DisableGetRxTones);
      }
      /* Wait for channel stablized */
      if(gl_RxSymbolCount == (R_C_REVERB_FR5_WT_LEN-1)) {

         /* Clear accumulator buffer. */
         MemSetBuffer((int16 *)(void *)gla_RxAccumBuf,0,0,(int16)(sizeof(int32)*gs_RxSamplesPerFrame));

         /* Change substate. */
         gs_RxSubState = R_C_REVERB_FR5_RX_AVERAGE_FRAME;
         gs_RxSubStateCnt = 0;

         //Enable PLL
//       guc_CommandedPllState = PLL_PERFORM_PHASE_LOCK;
      }
      break;

   /*  accumulate samples, generate representative frame */
   case R_C_REVERB_FR5_RX_AVERAGE_FRAME:

      gs_RxSubStateCnt++;

      /*  accumulate representative frame of time samples */
      Accum16to32(gla_RxAccumBuf, 0, gsa_RxToneBuf, 0, gs_RxSamplesPerFrame);

      if (gs_RxSubStateCnt == R_C_REVERB_FR5_AC_LEN) {
         /*  compute average of the accumulated frames */
         RightShiftAndRound32to16(gsa_RxRepFrameAlignBuf, 0,
            gla_RxAccumBuf, 0, gs_RxSamplesPerFrame, LOG2_R_C_REVERB_FR5_AC_LEN);

         gs_RxSubState = R_C_REVERB_FR5_RX_BEGIN_TDQ_TRAIN;
      }
      break;

    case R_C_REVERB_FR5_RX_BEGIN_TDQ_TRAIN:
    /* ==================================================================== */
    /*  TDQ training */

    /*  NOTE: TdqInit() does not execute in the duration of one symbol  */
    /*  period.  A real time system must call TdqInit() as a background */
    /*  process.  To emulate a real time system the state variable guc_TdqTrainingState */
    /*  is set by the state machine.  The completion of TdqInit will reset this */
    /*  flag.  The state machine will monitor this flag and change states */
    /*  when it sees that the flag has been reset. */
    /* ==================================================================== */

      /*  begin TDQ training */
        guc_TdqTrainingState = TRAINING_IN_PROGRESS;
        gs_RxSubState = R_C_REVERB_FR5_RX_END_TDQ_TRAIN;
      AddFunctionToBkgdFifo((PtrToBkgdFunc)BgEstimateChannel);
      AddFunctionToBkgdFifo((PtrToBkgdFunc)TdqInit);
        break;

    /*  check flag to see if TDQ training is complete */
    case R_C_REVERB_FR5_RX_END_TDQ_TRAIN:

        if (guc_TdqTrainingState == TRAINING_DONE) {
            gs_RxSubStateCnt = 0;
            if ((OPTNArray[OPTN_AlgControl] & OPTN_TDQDnldDisable)== FALSE) {
                AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadDECTDQ);
            }

#if 1    /* #if 0 -->Skip post TDQ frame synch; #if 1 --> perform post frame synch */
            gs_RxSubState = R_C_REVERB_FR5_RX_AVERAGE_FRAME_2;
#else
         gs_RxSubState = R_C_REVERB_FR5_RX_AVERAGE_FRAME_3;
#endif

         /*  clear RxAccumBuf */
         MemSetBuffer((int16 *)(void *)gla_RxAccumBuf,0,0,(int16)(sizeof(int32)*gs_RxSamplesPerFrame));

         //Hold PLL until channel stablized after turning on TDQ filter
//       guc_CommandedPllState = PLL_DISABLE;

        }
        break;

    /* ==================================================================== */
    /*  Compute average received frame with TDQ on */
    /* ==================================================================== */
    case R_C_REVERB_FR5_RX_AVERAGE_FRAME_2:

      /*  gather representative frame TDQ turned on */
        gs_RxSubStateCnt++;

      /*  skip the first "TDQ_STABLIZE_LEN" frame to allow TDQ filter state stablized */
      /*  and then start accumulation of frames */
      if(gs_RxSubStateCnt >= TDQ_STABLIZE_LEN) {
         Accum16to32(gla_RxAccumBuf, 0,  gsa_RxToneBuf, 0, gs_RxSamplesPerFrame);
      }

      /* Compute average of the accumulated frames */
      /* Note: This is done in place. */
      if (gs_RxSubStateCnt == (R_C_REVERB_FR5_AC_LEN+TDQ_STABLIZE_LEN)) {
         RightShiftAndRound32to16(gsa_RxRepFrameAlignBuf, 0,
            gla_RxAccumBuf, 0, gs_RxSamplesPerFrame, LOG2_R_C_REVERB_FR5_AC_LEN);

         guc_AlignmentTrainingState = TRAINING_IN_PROGRESS;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)BgAlignmentTraining);
         gs_RxSubState = R_C_REVERB_FR5_RX_FRAME_ALIGN_2;
      }
      break;

   /* ==================================================================== */
   /*  Check Frame Alignment: find symbol offset */
   /* ==================================================================== */
   case R_C_REVERB_FR5_RX_FRAME_ALIGN_2:

      if(guc_AlignmentTrainingState == TRAINING_DONE) {

         if (gus_SyncOffset != 0)
         {
            if (gs_PreSyncOffset > 0)
            {
               s_new_position = gs_PreSyncOffset+gus_SyncOffset;
               if (s_new_position > gs_RxSamplesPerFrame)
                  s_new_position -= gs_RxSamplesPerFrame;
               gs_PreSyncOffset = s_new_position;
            }
            else
            {
               gs_PreSyncOffset = (int16)gus_SyncOffset;
            }
            FrameAlign();
         }

         /* switch back to FDQ DONE interrupt to accumulate frequency domain  */
         /* data for the FDQ training                             */
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,DisableFDQ);
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,MoveToFdqDoneInt);

         /* Clear RxAccumBuf for FDQ Accum */
         MemSetBuffer((int16 *)(void *)gla_RxAccumBuf,0,0,(int16)(sizeof(int32)*2*gs_RxNumTones));

         /* Change substate. */
         gs_RxSubState = R_C_REVERB_FR5_RX_AVERAGE_FRAME_3;
         gs_RxSubStateCnt = 0;
      }
      break;

   /* ==================================================================== */
   /*  FDQ Training: Gather representative frame with TDQ turned on */
   /* ==================================================================== */
   case R_C_REVERB_FR5_RX_AVERAGE_FRAME_3:

      if(gs_RxSubStateCnt == 0)
      {
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,EnableFDQDoneNTC_EnableGetRxTones);
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,ResetRxAlign);
         gs_num_fdq_training_symbols = NUM_FDQ_TRAINING_SYMBOLS;
         gs_log2_num_fdq_training_symbols = LOG2_NUM_FDQ_TRAINING_SYMBOLS;
      }

      gs_RxSubStateCnt++;

      //Reset PLL reference tone and enable PLL update
//    if(gs_RxSubStateCnt == TDQ_STABLIZE_LEN)
//       guc_CommandedPllState = PLL_RESET_REFERENCE_TONE;

      /*  skip the first "TDQ_STABLIZE_LEN" frame to allow TDQ filter state stablized */
      /*  and then start accumulation of frames for FDQ init*/
      if(gs_RxSubStateCnt > TDQ_STABLIZE_LEN) {
         Accum16to32(gla_RxAccumBuf, 0, gsa_RxToneBuf, 0, (int16)(2*gs_RxNumTones));
      }

      /*  compute average of the accumulated frames */
      if (gs_RxSubStateCnt == (gs_num_fdq_training_symbols+TDQ_STABLIZE_LEN)) {
         RightShiftAndRound32to16(gsa_RxRepFDQTrainBuf, 0,
            gla_RxAccumBuf, 0, (int16)(2*gs_RxNumTones), gs_log2_num_fdq_training_symbols);

         gs_RxSubState = R_C_REVERB_FR5_RX_BEGIN_FDQ_TRAIN;
      }
      break;

   /* ==================================================================== */
   /*  FDQ training */
   /*  NOTE: FDQTrain() does not execute in the duration of one symbol  */
   /*  period.  A real time system must call FDQTrain() as a background */
   /*  process.  To emulate a real time system the state variable guc_FdqTrainingState */
   /*  is set by the state machine.  The completion of FDQTrain will reset this */
   /*  flag.  The state machine will monitor this flag and change states */
   /*  when it sees that the flag has been reset. */
   /* ====================================================================    */
   case R_C_REVERB_FR5_RX_BEGIN_FDQ_TRAIN:

      guc_FdqTrainingState = TRAINING_IN_PROGRESS;

      AddFunctionToBkgdFifo((PtrToBkgdFunc)FDQTrain);

      gs_RxSubState = R_C_REVERB_FR5_RX_END_FDQ_TRAIN;
      break;

   /*  check flag to see if FDQ training is complete */
   case R_C_REVERB_FR5_RX_END_FDQ_TRAIN:

      /*  if guc_FdqTrainingState == TRAINING_DONE, mean the FDQ training is done */
      if (guc_FdqTrainingState == TRAINING_DONE) {

         AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadFDQ);

         //Reset PLL reference tone since FDQ is changed
//       guc_CommandedPllState = PLL_RESET_REFERENCE_TONE;

         gs_RxSubState = R_C_REVERB_FR5_RX_WAIT;
      }
      break;

   /*  wait for end of R_C_REVERB_FR5_RX */
   case R_C_REVERB_FR5_RX_WAIT:

      if (gl_RxSymbolCount == (R_C_REVERB_FR5_RX_LEN-2))
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,MoveToFrameStartInt);

      if (gl_RxSymbolCount == (R_C_REVERB_FR5_RX_LEN-1)) {

         AddFunctionToFifo(gp_RxLoadingFunctionFifo,DisableFDQDoneNTC_DisableGetRxTones);

         gs_RxNextState = R_C_PILOT_FR3_RX;
         gpF_RxStateFunc = (PtrToFunc)RCPilot3Tref2RxF;

         /* Turn off PLL in GetRxTone() during EC training */
         /* since echo of training signal can affect pilot tone. */
//       guc_CommandedPllState = PLL_DISABLE;

      }
      else if(gl_RxSymbolCount >= R_C_REVERB_FR5_RX_LEN) {

         gs_RxNextState = FAIL_RX;
         gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

         /*  set exception handler variables */
         gus_ExceptionState   = gs_RxState;
         gus_ExceptionCode = E_CODE_RCReverbFR5Rx_SignalEnd_TIMEOUT;
      }
      break;
   }
}

#undef R_C_REVERB_FR5_RX_INITIALIZE
#undef R_C_REVERB_FR5_RX_AVERAGE_FRAME
#undef R_C_REVERB_FR5_RX_BEGIN_TDQ_TRAIN
#undef R_C_REVERB_FR5_RX_END_TDQ_TRAIN
#undef R_C_REVERB_FR5_RX_AVERAGE_FRAME_2
#undef R_C_REVERB_FR5_RX_FRAME_ALIGN_2
#undef R_C_REVERB_FR5_RX_AVERAGE_FRAME_3
#undef R_C_REVERB_FR5_RX_BEGIN_FDQ_TRAIN
#undef R_C_REVERB_FR5_RX_END_FDQ_TRAIN
#undef R_C_REVERB_FR5_RX_WAIT
