/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCReverbFR6RxF.c
 *
 *   Fast Retrain RX State Functions for ATU-R.
 *   Covering the RX states: R_C_REVERB_FR6, R_C_SEGUE_FR2 (which is actually
 *                           part of R_C_REVERB_FR6)
 *
 *   Notes:
 *
 *   R_C_PILOT_FR3 is implemented in RCReverb3RxF.c
 *   R_C_MEDLEY_FR is implemented in analysi2.c
 *   R_C_MSG_FR2 is implemented in analysi2.c
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_tones.h"
#include "rt_state.h"
#include "snr.h"
#include "pga_set.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "dsp_op.h"
#include "pll.h"
#include "gdata.h"
#include "frm_sync.h"
#include "tdq_init.h"
#include "fdq_init.h"
#include "exchmsgs.h"
#include "showtime.h"
#include "pwr_ctbk.h"
#include "ghs.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "crc16.h"
#include "showinit.h"
#include "ec_init.h"
#include "xgdata.h"
#include "xrtstate.h"
#include "fretrain.h"
#include "states.h"
#include "mtkernel.h"
#include "fifo.h"
#include "DSLEngin.h"
#include "fretrain.h"
#include "detect.h"
#include "RCMedleyFRRxF.h"

#include <string.h>

/*^^^
*-------------------------------------------------------------------
########               ########
######## RX ROUTINES   ########
########               ########
*-------------------------------------------------------------------
*^^^
*/

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCReverbFR6RxF
 *
 *  Description: Remains in current state until C_Segue is detected
 *
 *  Prototype: void RCReverbFR6RxF(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *
 *  Notes: implements state R_C_REVERB_FR6_RX
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RCReverbFR6RxF(void) {

    int16  s_ToneType;

    if (gl_RxSymbolCount == 0) {
        gs_RxSubStateCnt = 0;          /*  reset C_Reverb_FR6 symbol counter */

      /*  reset PLL's reference tone after EC training */
      guc_CommandedPllState = PLL_RESET_REFERENCE_TONE;
   }

    /*  detect C_Segue   */
    s_ToneType = DetectReverbSegue(gsa_RSDetect_Bins, gsa_RSDetect_PNSeq, gs_RSDetect_NumBins, NULL, NULL);

    if (s_ToneType == C_SEGUE) {
        gs_RxSubStateCnt++;
    }
    else {
        gs_RxSubStateCnt = 0;
    }

   if (gs_RxSubStateCnt == gs_FRCyclicPrefixInsertCnt)
      /* introduce cyclic prefix in R_C_REVERB_FR6_RX */
      AddFunctionToFifo(gp_RxLoadingFunctionFifo,InsertRxCP);

    if (gs_RxSubStateCnt == R_C_SEGUE_FR2_RX_LEN) {    /*  declare C_Segue detected */
      gt_StateMachCntrl.psa_RXSNRBuf           = gsa_FRSnrBuf;
      gt_StateMachCntrl.puc_RXmessage          = guca_R_C_Msg_FR2;
        gs_RxNextState = R_C_MEDLEY_FR_RX;
      gpF_RxStateFunc = (PtrToFunc)RCMedleyFRRxF;
    }

   /*  check for time out */
   if(gl_RxSymbolCount >= R_C_REVERB_FR6_TIMEOUT) {
         gs_RxNextState = FAIL_RX;
         gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

         /*  set exception handler variables */
         gus_ExceptionState   = gs_RxState;
         gus_ExceptionCode = E_CODE_RCReverbFR6Rx_C_SEGUE_Failure;
   }

}

