/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCReverbFR8RxF.c
 *
 *   Fast Retrain RX State Functions for ATU-R.
 *   Covering the RX states: R_C_REVERB_FR8,
 *                           R_C_SEGUE_FR4 (which is actually part of
 *                           R_C_REVERB_FR8).
 *
 *   Notes:
 *
 *   R_C_PILOT_FR3 is implemented in RCReverb3RxF.c
 *   R_C_MEDLEY_FR is implemented in analysi2.c
 *   R_C_MSG_FR2 is implemented in analysi2.c
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_tones.h"
#include "rt_state.h"
#include "snr.h"
#include "pga_set.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "dsp_op.h"
#include "pll.h"
#include "gdata.h"
#include "frm_sync.h"
#include "tdq_init.h"
#include "fdq_init.h"
#include "exchmsgs.h"
#include "showtime.h"
#include "pwr_ctbk.h"
#include "ghs.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "crc16.h"
#include "showinit.h"
#include "ec_init.h"
#include "xgdata.h"
#include "xrtstate.h"
#include "fretrain.h"
#include "states.h"
#include "mtkernel.h"
#include "fifo.h"
#include "DSLEngin.h"
#include "fretrain.h"
#include "detect.h"

#include <string.h>

/*^^^
*-------------------------------------------------------------------
########               ########
######## RX ROUTINES   ########
########               ########
*-------------------------------------------------------------------
*^^^
*/


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCReverbFR8RxF
 *
 *  Description:  Receives the C_Reverb_FR8 signal and waits for the C_Segue_FR4.
 *  Once C_Segue_FR4 is detected the state machine will move to Showtime if
 *  the unknown profile bit has not been set in either R_MSG_FR2 or R_C_MSG_FR2.
 *  If the unknown profile bit has been set then the state machine will jump to full
 *  initialization.
 *
 *  Prototype: void RCReverbFR8RxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gs_RxSubStateCnt           - (O) number of C_Segue's detected
 *      guca_RMsgFR2Tab[]          - (I) message sent during R_MSG_FR2_TX
 *      s_RxNextState              - (O) RX State that will begin next symbol period
 *      gft_RxInFastRetrain_flag   - (O) = TRUE, RX state machine is in fast retrain
 *      gusa_PN512Tab              - (I) PN used for C_Reverb/C_Segue generation
 *      s_RxToneBuf[]              - (I) output of FDQ, compare with PN sequence
 *                                    (in DetectReverbSegue() )
 *      ucByteMaskTable[]          - (I) byte mask for decoding psuedo random
 *                                    sequence (in DetectReverbSegue() )
 *
 *  Notes: implements state R_C_REVERB_FR8_RX
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RCReverbFR8RxF(void) {

   int16  s_ToneType;

   if(gl_RxSymbolCount == 0) {

      gft_RxInFastRetrain_flag = TRUE;

      if(guc_ProfileLoadOK == SUCCEED) {
         /*  initialize Showtime RX */
         guc_ShowTimeRxState = TRAINING_IN_PROGRESS;
         guc_RxDataPumpState = TRAINING_WAITING;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)BgInitShowTimeRx);
      }
   }

   if((guc_ShowTimeRxState == TRAINING_DONE) && (guc_RxDataPumpState != TRAINING_DONE))
      AddFunctionToFifo(gp_RxLoadingFunctionFifo,RxDataPumpSetUp);

   /*  detect C_Segue */
   s_ToneType = DetectReverbSegue(gsa_RSDetect_Bins, gsa_RSDetect_PNSeq, gs_RSDetect_NumBins, NULL, NULL);

   if (s_ToneType == C_SEGUE)
      gs_RxSubStateCnt++;
   else
      gs_RxSubStateCnt = 0;

   /* Train to showtime transition */
   DoRxFFTBufferScenarioTransition(gs_RxSubStateCnt, R_C_SEGUE_FR4_RX_LEN);      // Starts at (R_C_SEGUE_FR4_RX_LEN-2)

   if (gs_RxSubStateCnt == R_C_SEGUE_FR4_RX_LEN) {    /*  declare C_Segue detected */

      /*  see if profile loading was successful */
      if (guc_ProfileLoadOK == SUCCEED) {

         /* check if showtime initialization is complete */
         if((guc_ShowTimeRxState != TRAINING_DONE) ||
            (guc_RxDataPumpState != TRAINING_DONE)) {

            gs_RxNextState = FAIL_RX;
            gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
            gft_EscFromFR_Flag = TRUE; /*  Flag indicating G.hs is initiated from Fast Retrain */

            /*  set exception handler variables */
            gus_ExceptionState   = gs_RxState;
            gus_ExceptionCode = E_CODE_RCReverbFR8Rx_C_SEGUE_FR4_Failure;

            gft_TxInFastRetrain_flag = FALSE;
         }
      }
      else {                                      /*  jump to full initialization */
         gs_RxNextState = FAIL_RX;
         gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
         gft_EscFromFR_Flag = TRUE; /*  Flag indicating G.hs is initiated from Fast Retrain */

         /*  set exception handler variables */
         gus_ExceptionState   = gs_RxState;
         gus_ExceptionCode = E_CODE_RCReverbFR8Rx_No_PROFILE;

         gft_TxInFastRetrain_flag = FALSE;
      }
      gft_RxInFastRetrain_flag = FALSE;
   }

   if(gl_RxSymbolCount >= R_C_REVERB_FR8_TIMEOUT) {
      gs_RxNextState = FAIL_RX;
      gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

      // set exception handler variables
      gus_ExceptionState   = gs_RxState;
      gus_ExceptionCode = E_CODE_RCReverbFR8Rx_SignalEnd_TIMEOUT;

      gft_TxInFastRetrain_flag = FALSE;
      gft_RxInFastRetrain_flag = FALSE;
   }
}
