/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RLineProbeTxF.c
 *
 *   Fast Retrain TX State Functions for ATU-R.
 *
 *   Notes:
 *
 *   R_ECT_FR is implemented in xcvr_tx2.c
 *
 *
 *------------------------------------------------------------------------
 */
#include "common.h"
#include "rt_tones.h"
#include "tx_ops.h"
#include "gdata.h"
#include "crc16.h"
#include "xrtstate.h"
#include "fifo.h"
#include "DSLEngin.h"
#include "profile2.h"
#include <string.h>
#include "TxTneSt.h"
#include "TxMTnSt.h"
#include "states.h"
#include "RReverbFrTxF.h"
#include "memsetbf.h"

/*^^^
*-------------------------------------------------------------------
########               ########
######## TX ROUTINES   ########
########               ########
*-------------------------------------------------------------------
*^^^
*/



/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RLineProbeTxF
 *
 *  Description: Transmits the R_LineProbe signal for 512 symbols.
 *  R_LineProbe signal consists of tone 17, 18, 19. The power of the
 *  line probe signal is determined by the measured power of the
 *  harmonics at the receiver.
 *  At the end of this state, the transmit power should be set back to
 *  -38dBm/Hz in the variable gus_TxSineGain.
 *
 *  Prototype: void RLineProbeTxF(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *
 *  Substates:
 *      R_LINE_PROBE_TX_INITIALIZE - Set up R_LINE_PROBE signal for transmission
 *                                   by generating time samples, inserting samples
 *                                   into transmit buffer, removing cyclic prefix, etc.
 *      R_LINE_PROBE_TX_TRANSMIT  - Transmit R_LINE_PROBE for R_LINE_PROBE_TX_LEN
 *                                   symbols.
 *
 *  Notes: none
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates */
/* =============================================== */
#define R_LINE_PROBE_TX_INITIALIZE (0)
#define R_LINE_PROBE_TX_TRANSMIT  (1)

void RLineProbeTxF(void) {

   int32 l_temp;
   int16 i;

   CONSTANT int16 sa_CarSet[3] = {R_LINEPROBE_TONE1, R_LINEPROBE_TONE2, R_LINEPROBE_TONE3};

   switch (gs_TxSubState) {

      case R_LINE_PROBE_TX_INITIALIZE:

         /* ================================================================ */
         /*  setup R_LineProbe Signal. Go through this case statement only once */
         /* ================================================================ */
         guc_lineprobe_cutback = 0;

         /* insert R_LineProbe tones */
         MemSetBuffer(gsa_TxToneBuf, 0, 0, (int16)(sizeof(int16)*gs_TxFftLength));
         TxMultiToneSetUp(sa_CarSet, 3, R_LINEPROBE_POWER);

         /*  save the Tx Power gain */
         gus_TxSineGain_Before_LineProbe = gus_TxSineGain;

         /*  boost gus_TxSineGain by a factor of three for this test  */
         gus_TxSineGain *= LINEPROBE_GAIN_FACTOR;

         /* Change substate. */
         gs_TxSubState = R_LINE_PROBE_TX_TRANSMIT;
         gs_TxSubStateCnt = 0;
         break;

      case R_LINE_PROBE_TX_TRANSMIT:

        gus_TxSineGain = gus_TxGain_NoCutBack;
      for (i=0; i< guc_lineprobe_cutback; i++)
      {
           l_temp = (int32)gus_TxSineGain*gus_TxGainCutBackFactor;
         gus_TxSineGain = (int16)(l_temp >>15);
      }


         /*  set TX power to -38 dBm/Hz - CUTBACK */
      // gus_TxSineGain = gusa_txgain[guc_lineprobe_cutback] * LINEPROBE_GAIN_FACTOR;
      gus_TxSineGain = gus_TxSineGain * LINEPROBE_GAIN_FACTOR;

         if(gl_TxSymbolCount == (R_LINE_PROBE_TX_LEN-1)) {
            gs_TxNextState = R_REVERB_FR2_TX;
            gpF_TxStateFunc = (PtrToFunc)RReverbFrTxF;

            /*  restore the TX power that existed before entering this state. */
            gus_TxSineGain = gus_TxSineGain_Before_LineProbe;
         }
         break;
   } /*  switch(gs_TxSubstate) */
   AddFunctionToFifo(gp_TxLoadingFunctionFifo,LoadTxSineGain);
}

#undef R_LINE_PROBE_TX_INITIALIZE
#undef R_LINE_PROBE_TX_TRANSMIT

