/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RMsgs1FrTxF.c
 *
 *   Fast Retrain TX State Functions for ATU-R.
 *
 *   Notes:
 *
 *   R_ECT_FR is implemented in xcvr_tx2.c
 *
 *
 *------------------------------------------------------------------------
 */
#include "common.h"
#include "rt_tones.h"
#include "tx_ops.h"
#include "gdata.h"
#include "crc16.h"
#include "xrtstate.h"
#include "fifo.h"
#include "DSLEngin.h"
#include "profile2.h"
#include <string.h>
#include "TxTneSt.h"
#include "TxMTnSt.h"
#include "RCrc1FrTxF.h"
#include "states.h"

/*^^^
*-------------------------------------------------------------------
########               ########
######## TX ROUTINES   ########
########               ########
*-------------------------------------------------------------------
*^^^
*/




/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RMsgs1FrTxF
 *
 *  Description: Sends either the R_MSG_FR1 or R_MSG_FR2 message to
 *  the ATU-C.  One bit of information is transmitted in each symbol.
 *  A zero bit is encoded as one symbol of R_Reverb and a one
 *  bit is encoded as one symbol of R_Segue.  A CRC16 checksum is computed
 *  on the R_MSG_FR1 or R_MSG_FR2 which will be sent during next state
 *
 *  Prototype: void RMsgs1FrTxF(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      guca_RMsgs1Tab[]    - (O) R_Msgs1 message data to be transmitted
 *    guca_RMsgFR2Tab[] - (I) R_Msg_FR2 message data to be transmitted
 *    guca_RMsgFR1Tab[]   - (I) R_Msg_FR1 message data to be transmitted
 *    gus_R_CRC           - (I/O) CRC16 computed over gus_RMsgs1Tab[]
 *      gl_TxSymbolCount    - (I) # symbol periods in current TX state
 *      gs_TxNextState      - (O) TX state that will begin next symbol period
 *    gs_TxState        - (I) Current TX state
 *      gt_StateMachCntrl   - (O) Maintains state machine control variables
 *
 *  Notes: implements states R_MSG_FR1_TX, and R_MSG_FR2_TX
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RMsgs1FrTxF(void) {

   uint16  us_infobit;

   if (gl_TxSymbolCount == 0) {
      gft_IFFT_On = TRUE;

      switch (gs_TxState) {

         case R_MSG_FR1_TX:
            /* Check for valid stored profiles. */
            CheckStoredProfiles();

            gt_StateMachCntrl.l_TXCurrentStateLen = R_MSG_FR1_TX_LEN-1;
            gt_StateMachCntrl.s_TXFollowingState  = R_CRC_FR1_TX;
            gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RCrc1FrTxF;
            gt_StateMachCntrl.puca_TX_message     = guca_RMsgFR1Tab;
            break;

         case R_MSG_FR2_TX:
            gt_StateMachCntrl.l_TXCurrentStateLen = R_MSG_FR2_TX_LEN-1;
            gt_StateMachCntrl.s_TXFollowingState  = R_CRC_FR2_TX;
            gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RCrc1FrTxF;
            gt_StateMachCntrl.puca_TX_message     = guca_RMsgFR2Tab;
            break;
      }

      gus_R_CRC = 0x0000;
   }

   us_infobit = TxInfoBit( gt_StateMachCntrl.puca_TX_message, (int16)(gl_TxSymbolCount));

   /*  computed CRC2 */
   CalcCRC16(&gus_R_CRC, us_infobit);

   if (gl_TxSymbolCount == (gt_StateMachCntrl.l_TXCurrentStateLen)) {
      gs_TxNextState = gt_StateMachCntrl.s_TXFollowingState;
      gpF_TxStateFunc = gt_StateMachCntrl.pF_TxFollowingState;
   }
}


