/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RQuietFR1TxF.c
 *
 *   Fast Retrain TX State Functions for ATU-R.
 *   Covering the TX states: R_QUIET_FR1_TX
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_tones.h"
#include "tx_ops.h"
#include "gdata.h"
#include "crc16.h"
#include "xrtstate.h"
#include "fifo.h"
#include "DSLEngin.h"
#include "profile2.h"
#include <string.h>
#include "TxTneSt.h"
#include "TxMTnSt.h"
#include "states.h"
#include "RSilent0TxF.h"
#include "RCSilent1RxF.h"
#include "RReverbFrTxF.h"
#include "pll.h"

/* =============================================== */
/* Global variable declarations                    */
/* =============================================== */

/*^^^
*-------------------------------------------------------------------
########               ########
######## TX ROUTINES   ########
########               ########
*-------------------------------------------------------------------
*^^^
*/

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RQuietFR1TxF
 *
 *  Description: The Transmitter remains quiet for 750 +/- 6 symbols after
 *  start of R_SEGUE_FR1 signal in R_QUIET_FR1_TX state.
 *
 *  Prototype: void RQuietFR1TxF(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *
 *  Notes: implements R_QUIET_FR1_TX only.
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RQuietFR1TxF(void) {

   if (gl_TxSymbolCount == 0) {

      /* Produce quiet signal */
      gft_IFFT_On=TRUE;
      TxToneSetUp(0,0,0);
   }

   if (gl_TxSymbolCount == R_QUIET_FR1_TX_LEN-1) {

      /*  if Fast Retrain Truncate bit is set, go to full initialization */
      if (gft_FR_Truncate_Flag == TRUE)
      {
         /* Execute initialization reset procedure  */
              gs_TxNextState = R_SILENT0_TX;
            gs_RxNextState = R_C_SILENT1_RX;

         gpF_TxStateFunc = (PtrToFunc)RSilent0TxF;
         gpF_RxStateFunc = (PtrToFunc)RCSilent1RxF;

            gft_EscFromFR_Flag = TRUE;

                  /* Turn off PLL */
                      gft_EnablePLL = FALSE;
      }
      else {
         gs_TxNextState = R_REVERB_FR3_TX;
         gpF_TxStateFunc = (PtrToFunc)RReverbFrTxF;
      }
   }
}

