/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RRecovTxF.c
 *
 *   Fast Retrain TX State Functions for ATU-R.
 *   Covering the TX states: R_RECOV
 *
 *   Notes:
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include "rt_tones.h"
#include "fifo.h"
#include "DSLEngin.h"
#include "xrtstate.h"
#include "tx_ops.h"
#include "TxTneSt.h"
#include "states.h"

/*^^^
*-------------------------------------------------------------------
########               ########
######## TX ROUTINES   ########
########               ########
*-------------------------------------------------------------------
*^^^
*/

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RRecovTxF
 *
 *  Description: Starting from SHOWTIME_TX, this state is entered upon
 *  a Fast Retrain Request, when a notable line change is detected by
 *  either the ATU-R, or the ATU-C itself.  It transmits the R_Recov which
 *  consists of a tone signal corresponding to channel 20 without cyclic
 *  prefix.  Also, as the first state within the fast retrain sequence,
 *  this function resets a number of control parameters.
 *
 *  Prototype: void RRecovTxF(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *
 *  Substates:
 *      R_RECOV_INITIALIZE - Set up R-RECOV signal for transmission by generating
 *                           time samples, inserting samples into transmit buffer,
 *                           removing cyclic prefix, setting power level, etc.
 *      R_RECOV_TRANSMIT   - Transmit R_RECOV until processing in R_CREVERB_FR1_RX
 *                           is done.
 *
 *  Notes: implements state R_RECOV_TX
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates */
/* =============================================== */
#define R_RECOV_INITIALIZE (0)
#define R_RECOV_TRANSMIT   (1)

void RRecovTxF(void) {

    switch (gs_TxSubState) {

    case R_RECOV_INITIALIZE:

      gft_IFFT_On = TRUE;

      /*  Setup R_Recov signal. */
      TxToneSetUp((int16) R_RECOV_TONE,(int16) R_RECOV_POWER,(int16) R_RECOV_POWER);

        /*  Reset TX power to -38 dBm/Hz - NO CUTBACK */
        //gus_TxSineGain = gusa_txgain[0];
      gus_TxSineGain = gus_TxGain_NoCutBack;

      AddFunctionToFifo(gp_TxLoadingFunctionFifo,LoadTxSineGain);

        /* Change substate. */
        gs_TxSubState = R_RECOV_TRANSMIT;
        gs_TxSubStateCnt = 0;
        break;

    case R_RECOV_TRANSMIT:

        /*  TxNextState is set to R_REVERB_FR1_TX on the receiver side in function RCReverbFr1RxF()  */

      /*  check for timeout, if timeout, set next states to fail states */
      if(gl_TxSymbolCount >= (R_RECOV_TX_TIMEOUT-1)) {

         gs_TxNextState = FAIL_TX;
         gpF_TxStateFunc = (PtrToFunc)ExceptionHandler;

         /*  set exception handler variables */
         gus_ExceptionState   = gs_TxState;
         gus_ExceptionCode = E_CODE_RRecovTx_SignalEnd_TIMEOUT;
      }
        break;
    }
}

#undef R_RECOV_INITIALIZE
#undef R_RECOV_TRANSMIT
