/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RReverbFrTx3F.c
 *
 *   Fast Retrain TX State Functions for ATU-R.

 *
 *   Notes:
 *
 *   R_MEDLEY_FR, R_MSG_FR2 and R_CRC_FR2 are implemented in analysi2.c
 *
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_tones.h"
#include "rt_state.h"
#include "snr.h"
#include "pga_set.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "dsp_op.h"
#include "pll.h"
#include "gdata.h"
#include "frm_sync.h"
#include "tdq_init.h"
#include "fdq_init.h"
#include "exchmsgs.h"
#include "showtime.h"
#include "pwr_ctbk.h"
#include "ghs.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "crc16.h"
#include "showinit.h"
#include "ec_init.h"
#include "xgdata.h"
#include "xrtstate.h"
#include "fretrain.h"
#include "states.h"
#include "mtkernel.h"
#include "fifo.h"
#include "DSLEngin.h"
#include "fretrain.h"
#include "ClrTxBuf.h"
#include "engine_const.h"
#include "RSegueFrTx3F.h"
#include "RSegueFR5TxF.h"
#include <string.h>

/*^^^
*-------------------------------------------------------------------
########               ########
######## TX ROUTINES   ########
########               ########
*-------------------------------------------------------------------
*^^^
*/

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RReverbFrTx3F
 *
 *  Description: Sends the R_Reverb signal to the ATU-C.  R_Reverb is
 *  sent on tones gs_TxFirstChannel to gs_TxLastChannel.  This function is
 *  reused for several states. The R-ECT signal level is also decided
 * during R_REVERB1
 *
 *  Prototype: void RReverbFrTxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gs_TxToneBuf[]     - (O) frequency domains samples (set in TxReverbSegue() )
 *    gs_TxState        - (I) current TX state
 *      gl_TxSymbolCount   - (I) # symbol periods in current TX state
 *      gs_TxNextState     - (O) TX state that will begin next symbol period
 *    gt_StateMachCntrl - (I/O) state machine control structure
 *    gus_TxSineGain    - (O) TX sine gain
 *
 *  Notes: implements states R_REVERB_FR1_TX,R_REVERB_FR2_TX, R_REVERB_FR3_TX,
 *          R_REVERB_FR4_TX, R_REVERB_FR5_TX, R_REVERB_FR6_TX, and R_REVERB_FR7_TX
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RReverbFrTx3F(void) {

    if (gl_TxSymbolCount == 0) {

      /* Enable IFFT */
      gft_IFFT_On = TRUE;
      AddFunctionToFifo(gp_TxLoadingFunctionFifo, Enable_IFFT_Reordering);

      /*  generate time domain samples  */
        TxReverbSegueSetUp(gs_TxFirstChannel, gs_TxLastChannel, R_REVERB);

      /*  state machine control */
        switch (gs_TxState) {

        case R_REVERB_FR5_TX:
            gt_StateMachCntrl.l_TXCurrentStateLen = R_REVERB_FR5_TX_LEN-1;
            gt_StateMachCntrl.s_TXFollowingState  = R_SEGUE_FR3_TX;
         gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RSegueFrTx3F;
         Clear_TxToneBuf();

         break;

        case R_REVERB_FR6_TX:
            gt_StateMachCntrl.l_TXCurrentStateLen = R_REVERB_FR6_TX_LEN-1;
            gt_StateMachCntrl.s_TXFollowingState  = R_SEGUE_FR4_TX;
         gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RSegueFrTx3F;
         guc_TXProfileLoadOK = FAIL;
            break;

        case R_REVERB_FR7_TX:
            gt_StateMachCntrl.l_TXCurrentStateLen = R_REVERB_FR7_TX_LEN-1;
            gt_StateMachCntrl.s_TXFollowingState  = R_SEGUE_FR5_TX;
         gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RSegueFR5TxF;
         gft_TxInFastRetrain_flag = TRUE;
         guc_ShowTimeTxState = TRAINING_WAITING;
         gs_num_preproc_frames = 0;
            break;
        }
    }

   if(gs_TxState == R_REVERB_FR7_TX) {

      /* Start initializing Showtime TX, where gs_num_preproc_frames */
      /* is the number of frames which should be processed before SHOWTIME */
      /* to avoid underflow of output */
      if((guc_TXProfileLoadOK == SUCCEED) && (guc_ShowTimeTxState == TRAINING_WAITING)) {

         guc_ShowTimeTxState = TRAINING_IN_PROGRESS;
         guc_TxDataPumpState = TRAINING_WAITING;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)BgInitShowTimeTx);
      }

      if((guc_ShowTimeTxState == TRAINING_DONE) && (guc_TxDataPumpState != TRAINING_DONE))
         AddFunctionToFifo(gp_TxLoadingFunctionFifo,TxDataPumpSetUp);
   }

    if(gl_TxSymbolCount == (gt_StateMachCntrl.l_TXCurrentStateLen)) {
        gs_TxNextState = gt_StateMachCntrl.s_TXFollowingState;
      gpF_TxStateFunc = gt_StateMachCntrl.pF_TxFollowingState;
    }
}



