/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RReverbFrTxF.c
 *
 *   Fast Retrain TX State Functions for ATU-R.
 *   Covering the TX states: R_REVERB_FR
 *
 *   Notes:
 *
 *   R_ECT_FR is implemented in xcvr_tx2.c
 *
 *
 *------------------------------------------------------------------------
 */
#include "common.h"
#include "rt_tones.h"
#include "tx_ops.h"
#include "gdata.h"
#include "crc16.h"
#include "xrtstate.h"
#include "fifo.h"
#include "DSLEngin.h"
#include "profile2.h"
#include <string.h>
#include "TxTneSt.h"
#include "TxMTnSt.h"
#include "RSegueFrTxF.h"
#include "RQuietFR2TxF.h"
#include "REctTxF.h"
#include "states.h"

/*^^^
*-------------------------------------------------------------------
########               ########
######## TX ROUTINES   ########
########               ########
*-------------------------------------------------------------------
*^^^
*/

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RReverbFrTxF
 *
 *  Description: Sends the R_Reverb signal to the ATU-C.  R_Reverb is
 *  sent on tones gs_TxFirstChannel to gs_TxLastChannel.  This function is
 *  reused for several states. The R-ECT signal level is also decided
 * during R_REVERB1
 *
 *  Prototype: void RReverbFrTxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gs_TxToneBuf[]     - (O) frequency domains samples (set in TxReverbSegue() )
 *    gs_TxState        - (I) current TX state
 *      gl_TxSymbolCount   - (I) # symbol periods in current TX state
 *      gs_TxNextState     - (O) TX state that will begin next symbol period
 *    gt_StateMachCntrl - (I/O) state machine control structure
 *    gus_TxSineGain    - (O) TX sine gain
 *
 *  Notes: implements states R_REVERB_FR1_TX,R_REVERB_FR2_TX, R_REVERB_FR3_TX,
 *          R_REVERB_FR4_TX.
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RReverbFrTxF(void) {

   int32 l_temp;
   int16 i;

    if (gl_TxSymbolCount == 0) {

      gft_IFFT_On = TRUE;

      /*  generate time domain samples  */
        TxReverbSegueSetUp(gs_TxFirstChannel, gs_TxLastChannel, R_REVERB);

      /*  state machine control */
        if(gs_TxState == R_REVERB_FR1_TX)
      {
            gt_StateMachCntrl.l_TXCurrentStateLen = R_REVERB_FR1_TX_LEN-1;
            gt_StateMachCntrl.s_TXFollowingState  = R_SEGUE_FR1_TX;
         gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RSegueFrTxF;
      }
        else if(gs_TxState == R_REVERB_FR2_TX)
      {
            gt_StateMachCntrl.l_TXCurrentStateLen = R_REVERB_FR2_TX_LEN-1;
            gt_StateMachCntrl.s_TXFollowingState  = R_SEGUE_FR2_TX;
         gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RSegueFrTxF;
      }
        else if(gs_TxState == R_REVERB_FR3_TX)
      {
            gt_StateMachCntrl.l_TXCurrentStateLen = R_REVERB_FR3_TX_LEN-1;
            gt_StateMachCntrl.s_TXFollowingState  = R_QUIET_FR2_TX;
         gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RQuietFR2TxF;

         /*  apply Absolute Upstream Fast Retrain Power Cutback, UC,  */
            /*  informed by ATU-R in R_MSG_FR1 */

         gus_TxSineGain = gus_TxGain_NoCutBack;
         for (i=0; i< gs_UC; i++)
         {
              l_temp = (int32)gus_TxSineGain*gus_TxGainCutBackFactor;
            gus_TxSineGain = (int16)(l_temp >>15);
         }

         //    gus_TxSineGain = gusa_txgain[gs_UC];
         AddFunctionToFifo(gp_TxLoadingFunctionFifo,LoadTxSineGain);
      }
        else if(gs_TxState ==  R_REVERB_FR4_TX)
      {
            gt_StateMachCntrl.l_TXCurrentStateLen = R_REVERB_FR4_TX_LEN-1;
            gt_StateMachCntrl.s_TXFollowingState  = R_ECT_FR_TX;
         gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)REctTxF;
      }
   }

   if(gl_TxSymbolCount == (gt_StateMachCntrl.l_TXCurrentStateLen)) {
      gs_TxNextState = gt_StateMachCntrl.s_TXFollowingState;
      gpF_TxStateFunc = gt_StateMachCntrl.pF_TxFollowingState;
   }
}

