/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RSegueFR5TxF.c
 *
 *   Fast Retrain TX State Functions for ATU-R.
 *   Covering the TX states: R_SEGUE_FR5
 *
 *   Notes:
 *
 *   R_ECT_FR is implemented in xcvr_tx2.c
 *   R_MEDLEY_FR, R_MSG_FR2 and R_CRC_FR2 are implemented in analysi2.c
 *
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_tones.h"
#include "rt_state.h"
#include "snr.h"
#include "pga_set.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "dsp_op.h"
#include "pll.h"
#include "gdata.h"
#include "frm_sync.h"
#include "tdq_init.h"
#include "fdq_init.h"
#include "exchmsgs.h"
#include "showtime.h"
#include "pwr_ctbk.h"
#include "ghs.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "crc16.h"
#include "showinit.h"
#include "ec_init.h"
#include "xgdata.h"
#include "xrtstate.h"
#include "fretrain.h"
#include "states.h"
#include "mtkernel.h"
#include "fifo.h"
#include "DSLEngin.h"
#include "fretrain.h"
#include "ClrTxBuf.h"
#include "engine_const.h"

#include <string.h>

/*^^^
*-------------------------------------------------------------------
########               ########
######## TX ROUTINES   ########
########               ########
*-------------------------------------------------------------------
*^^^
*/



/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RSegueFR5TxF
 *
 *  Description: Transmits 10 symbols of R_Segue signal to indicate to
 * ATU-C that following R_SEGUE_FR5 the ATU-R has completed fast retrain
 * and will enter state R-SHOWTIME.  If either the ATU-C or the ATU-R has
 *  set the Unknown Profile bit the R_MSG_FR2 or R_C_MSG_FR2 then a full
 *  initialization will follow rather than Showtime
 * (Take 10 symbols)
 *
 *  Prototype: void RSegueFR5TxF(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount    - (I) # symbol periods in current TX state
 *      gs_TxNextState      - (O) TX state that will begin next symbol period
 *
 *  Notes: implements state R_SEGUE_FR5_TX
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RSegueFR5TxF(void) {

   if (gl_TxSymbolCount == 0) {
      gft_IFFT_On = TRUE;

      /*  generate time domain samples for R_Segue */
      TxReverbSegueSetUp(gs_TxFirstChannel, gs_TxLastChannel, R_SEGUE);
   }

   /* Fail if Tx engine is not ready. */
   if((guc_ShowTimeTxState != TRAINING_DONE) || (guc_TxDataPumpState != TRAINING_DONE)) {

      gs_TxNextState = FAIL_TX;
      gpF_TxStateFunc = (PtrToFunc)ExceptionHandler;
      gft_EscFromFR_Flag = TRUE;

      /* set exception handler variables */
      gus_ExceptionState   = gs_TxState;
      gus_ExceptionCode = E_CODE_RSegueFR5Tx_TX_Not_Ready_TIMEOUT;

      gft_TxInFastRetrain_flag = FALSE;
      gft_RxInFastRetrain_flag = FALSE;
      return;
   }

   if(gl_TxSymbolCount == (R_SEGUE_FR5_TX_LEN-FRAME_LATENCY_TX_SHOWTIME - gs_num_preproc_frames))
   {
      /* enable TX data input on the interleaved path */
      gft_TxInlvInputEnabled = TRUE;
      AddFunctionToFifo(gp_TxLoadingFunctionFifo, EnableTxIntlvFraming);
   }
   else if(gl_TxSymbolCount > (R_SEGUE_FR5_TX_LEN-FRAME_LATENCY_TX_SHOWTIME - gs_num_preproc_frames))
   {
      gft_TxDataPump_On = TRUE;
   }

   if (gl_TxSymbolCount == (R_SEGUE_FR5_TX_LEN - FRAME_LATENCY_TX_SHOWTIME))
   {
      /*  see if profile loading was successful */
      if (guc_ProfileLoadOK == SUCCEED) { /*  jump to showtime */

         /* enable TX data input on the fast path */
         gft_TxFastInputEnabled = TRUE;
         AddFunctionToFifo(gp_TxLoadingFunctionFifo, Enable_MTE_Tx);
         AddFunctionToFifo(gp_TxLoadingFunctionFifo, EnableTxFastFraming);

      }
   }
   if (gl_TxSymbolCount == (R_SEGUE_FR5_TX_LEN - 1))
   {
      /*  see if profile loading was successful */
      if (guc_ProfileLoadOK == SUCCEED) { /*  jump to showtime */

         /* Start Showtime TX */
         gs_TxNextState = R_SHOWTIME_TX;
         gpF_TxStateFunc = (PtrToFunc)RShowtimeTxF_DMT;
      }
      else {                                       /*  jump to full initialization */
         gs_TxNextState = FAIL_TX;
         gpF_TxStateFunc = (PtrToFunc)ExceptionHandler;
         gft_EscFromFR_Flag = TRUE;

         /* set exception handler variables */
         gus_ExceptionState   = gs_TxState;
         gus_ExceptionCode = guc_ProfileLoadOK;
         gft_RxInFastRetrain_flag = FALSE;
      }

      gft_TxInFastRetrain_flag = FALSE;
   }
}
