/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RSegueFrTxF.c
 *
 *   Fast Retrain TX State Functions for ATU-R.
 *
 *   Notes:
 *
 *   R_ECT_FR is implemented in xcvr_tx2.c
 *
 *
 *------------------------------------------------------------------------
 */
#include "common.h"
#include "rt_tones.h"
#include "tx_ops.h"
#include "gdata.h"
#include "crc16.h"
#include "xrtstate.h"
#include "fifo.h"
#include "DSLEngin.h"
#include "profile2.h"
#include <string.h>
#include "TxTneSt.h"
#include "TxMTnSt.h"
#include "RLineProbeTxF.h"
#include "RMsgs1FrTxF.h"
#include "states.h"

/*^^^
*-------------------------------------------------------------------
########               ########
######## TX ROUTINES   ########
########               ########
*-------------------------------------------------------------------
*^^^
*/


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RSegueFrTxF
 *
 *  Description: Transmits the R_Segue signal to the ATU-C.
 *  This function is reused by several states.
 *
 *  Prototype: void RSegueFrTxF(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gsa_TxToneBuf[]      - (O) frequency domains samples
 *                                (set in TxReverbSegue() )
 *      gl_TxSymbolCount     - (I) # symbol periods in current TX state
 *      gs_TxNextState       - (O) TX state that will begin next symbol period
 *      gs_Tx_OutBuf_Size    - (O) # samples / symbol period
 *      gt_StateMachCntrl    -  (O) Maintains state machine control variables
 *
 *  Notes: implements states R_SEGUE_FR1_TX, R_SEGUE_FR2_TX, R_SEGUE_FR3_TX,
 *  and R_SEGUE_FR4_TX
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RSegueFrTxF(void) {

    if (gl_TxSymbolCount == 0) {
      gft_IFFT_On = TRUE;
      TxReverbSegueSetUp(gs_TxFirstChannel, gs_TxLastChannel, R_SEGUE);

        /*  state machine control */
      switch (gs_TxState) {

      case R_SEGUE_FR1_TX:
        gt_StateMachCntrl.s_TXFollowingState  = R_LINE_PROBE_TX;
      gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RLineProbeTxF;
        break;

      case R_SEGUE_FR2_TX:
        gt_StateMachCntrl.s_TXFollowingState  = R_MSG_FR1_TX;
      gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RMsgs1FrTxF;
        break;

   }

   }
    if (gl_TxSymbolCount == (R_SEGUE1_TX_LEN-1)) {

      /* set the next TX state */
        gs_TxNextState = gt_StateMachCntrl.s_TXFollowingState;
      gpF_TxStateFunc = gt_StateMachCntrl.pF_TxFollowingState;
    }
}


