/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   fretrain.c
 *
 *   Fast Retrain Functions for ATU-R.
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_tones.h"
#include "rt_state.h"
#include "snr.h"
#include "pga_set.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "dsp_op.h"
#include "pll.h"
#include "gdata.h"
#include "frm_sync.h"
#include "tdq_init.h"
#include "fdq_init.h"
#include "exchmsgs.h"
#include "showtime.h"
#include "pwr_ctbk.h"
#include "ghs.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "crc16.h"
#include "ec_init.h"
#include "xgdata.h"
#include "xrtstate.h"
#include "fretrain.h"
#include "states.h"
#include "mtkernel.h"
#include "fifo.h"
#include "DSLEngin.h"
#include "fft_bg.h"
#include <string.h>
#include "vecpwr.h"

/* =============================================== */
/* Local routines                                  */
/* =============================================== */

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: get_RDC
 *
 *  Description: Computes RDC, Relative Downstream Fast Retrain Power Cutback, based
 *  on the power of C_Reverb_FR1
 *
 *  Prototype: void get_RDC(int32 l_CReverbFr1Pwr)
 *
 *  Input Arguments:
 *      int32 l_CReverbFr1Pwr   average power during C_Reverb_FR1
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void get_RDC(int32 l_CReverbFr1Pwr)
{
    int16   s_txpower_index;
    int16   s_offset_db;
    int16   s_new_PGA, s_RDC_db;
    int16    i;

    //offset = measured power - desired power
    s_offset_db = ConvertToDB(l_CReverbFr1Pwr) - (int16)PD_DB;

    /* apply recommended cutback to current PGA setting */
    s_new_PGA = gs_PGA_set - s_offset_db;

    //if the newly calculated PGA is smaller than the (minimum pga + echo margin)
    // apply cutback
    // smaller s_new_PGA => higher received power from CO,hence apply cutback
    if (s_new_PGA <= ((int16)MIN_PGA + (int16)EC_MARGIN)) {

        //calculate RDC
        s_RDC_db = (int16)MIN_PGA + (int16)EC_MARGIN - s_new_PGA;

      s_txpower_index = 31;
        for (i = 0; i < 31; i++) {

            if (s_RDC_db < gsa_fr_cutback_thresh[i]) {
                s_txpower_index = i;
                break;
            }
        }
    }
   else
      s_txpower_index = 0;

    //record RDC, Relative Downstream Fast Retrain Power Cutback
    gs_RDC = 2 * s_txpower_index;

    // report RDC in R-MSG-FR1
    // d0 to d4, Relative Downstream Fast Retrain Power Cutback
    guca_RMsgFR1Tab[0] |= (uint8)(s_txpower_index & 0x1F);
}

/*^^^
*-------------------------------------------------------------------
########                       ########
######## BACKGROUND ROUTINES   ########
########                       ########
*-------------------------------------------------------------------
*^^^
*/
void CalcCutBack(void) {

   int16 i;
   int32 l_Psym;

   /* average time domain data */
   for (i = 0; i < gs_RxSamplesPerFrame; i++) {
      gsa_RxToneBuf[i] = (int16)round(gla_RxAccumBuf[i], LOG2_RDC_ACCUM_SYMBOLS);
   }

   /*  accumulate received power */
   l_Psym = VectorPower(gsa_RxToneBuf, 0, gs_RxSamplesPerFrame, gs_Log2RxSamplesPerFrame);

    /* Computes RDC, Relative Downstream Fast Retrain Power Cutback */
   get_RDC(l_Psym);

   guc_AlignmentTrainingState = TRAINING_DONE;

};


