/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   LOAD_PRF.c
 *
 *   Description:   Initializes the RX and TX profiles for fast retrain testing
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include "xgdata.h"
#include "aoc.h"

void RxLoadProfile(void){

    int16    i;

   guc_num_rx_profiles_stored = 4;

    /* ====================================== */
    /*  profile 0 */
    /* ====================================== */
    gta_RXProfile[0].s_ReqdBits = 424;
    for (i = 0; i < gs_RxNumTones; i++) {
        gta_RXProfile[0].sa_BG[i] = 0; // 0dB
    }

    for (i = 33; i <= 63; i++) {
        gta_RXProfile[0].sa_BG[i] |= 0x8; /* 8 bits per tone */
    }
    for (i = 65; i <= 86; i++) {
        gta_RXProfile[0].sa_BG[i] |= 0x8; /* 8 bits per tone */
    }
    gta_RXProfile[0].s_R = 0;
    gta_RXProfile[0].s_S = 1;
    gta_RXProfile[0].s_D = 1;

    /* ====================================== */
    /*  profile 1 */
    /* ====================================== */
    gta_RXProfile[1].s_ReqdBits = 32;
    for (i = 0; i < gs_RxNumTones; i++) {
        gta_RXProfile[1].sa_BG[i] = 0; // 0dB
    }
    for (i = 50; i <= 63; i++) {
        gta_RXProfile[1].sa_BG[i] |= 0x2; /* 2 bits per tone */
    }
    for (i = 65; i <= 66; i++) {
        gta_RXProfile[1].sa_BG[i] |= 0x2; /* 2 bits per tone */
    }

    gta_RXProfile[1].s_R = 0;
    gta_RXProfile[1].s_S = 1;
    gta_RXProfile[1].s_D = 1;

    /* ====================================== */
    /*  profile 2 */
    /* ====================================== */
    gta_RXProfile[2].s_ReqdBits = 376;
    for (i = 0; i < gs_RxNumTones; i++) {
        gta_RXProfile[2].sa_BG[i] = 0; // 0dB
    }

    for (i = 33; i <= 73; i++) {
        gta_RXProfile[2].sa_BG[i] |= 0x9; /* 9 bits per tone */
    }
    gta_RXProfile[2].sa_BG[64] = 0x2000;

    for (i = 74; i <= 75; i++) {
        gta_RXProfile[2].sa_BG[i] |= 0x8; /* 8 bits per tone */
    }

    gta_RXProfile[2].s_R = 0;
    gta_RXProfile[2].s_S = 1;
    gta_RXProfile[2].s_D = 1;


    /* ====================================== */
    /*  profile 3 */
    /* ====================================== */
    gta_RXProfile[3].s_ReqdBits = 416;
    for (i = 0; i < gs_RxNumTones; i++) {
        gta_RXProfile[3].sa_BG[i] = 0; // 0dB
    }

    for (i = 33; i <= 63; i++) {
        gta_RXProfile[3].sa_BG[i] |= 0x9; /* 9 bits per tone */
    }
    for (i = 65; i <= 73; i++) {
        gta_RXProfile[3].sa_BG[i] |= 0x9; /* 9 bits per tone */
    }
   for (i = 74; i <= 80; i++) {
        gta_RXProfile[3].sa_BG[i] |= 0x8; /* 8 bits per tone */
    }

    gta_RXProfile[3].s_R = 0;
    gta_RXProfile[3].s_S = 1;
    gta_RXProfile[3].s_D = 1;


    gsa_rx_profile_ord[0] = 0;
    gsa_rx_profile_ord[1] = 3;
    gsa_rx_profile_ord[2] = 2;
    gsa_rx_profile_ord[3] = 1;

}

void TxLoadProfile(void){

    int16    i;

   guc_num_tx_profiles_stored = 2;

    /*  load 2 profiles and leave the other 2 empty */

    /* ====================================== */
    /*  profile 0 */
    /* ====================================== */
    gta_TXProfile[0].s_ReqdBits = 16;
    for (i = 0; i < gs_TxNumTones; i++) {
        gta_TXProfile[0].sa_bat[i] = 0;
        gta_TXProfile[0].sa_gain[i] = 0x2000; /* should be in Q3.13 format */
    }
    for (i = 6; i <= 13; i++) {
        gta_TXProfile[0].sa_bat[i] = 2;
    }
    gta_TXProfile[0].s_R = 0;
    gta_TXProfile[0].s_S = 1;
    gta_TXProfile[0].s_D = 1;

    /* ====================================== */
    /*  profile 1 */
    /* ====================================== */
    gta_TXProfile[1].s_ReqdBits = 72;
    for (i = 0; i < gs_TxNumTones; i++) {
        gta_TXProfile[1].sa_bat[i] = 0;
        gta_TXProfile[1].sa_gain[i] = 0x2000; /* should be in Q3.13 format */
    }
    for (i = 6; i <= 8; i++) {
        gta_TXProfile[1].sa_bat[i] = 6;
    }

    for (i =9; i <= 9; i++) {
        gta_TXProfile[1].sa_bat[i] = 7;
    }

   for (i = 10; i <= 14; i++) {
        gta_TXProfile[1].sa_bat[i] = 6;
    }
   for (i = 15; i <= 16; i++) {
        gta_TXProfile[1].sa_bat[i] = 5;
    }

   gta_TXProfile[1].sa_bat[17] = 4;
   gta_TXProfile[1].sa_bat[18] = 3;

   for (i = 19; i <= 21; i++) {
        gta_TXProfile[1].sa_bat[i] = 0;
    }

    gta_TXProfile[1].s_R = 0;
    gta_TXProfile[1].s_S = 1;
    gta_TXProfile[1].s_D = 1;

    /* ====================================== */
    /*  profile 2 */
    /* ====================================== */
    gta_TXProfile[2].s_ReqdBits = 80;
    for (i = 0; i < gs_TxNumTones; i++) {
        gta_TXProfile[2].sa_bat[i] = 0;
        gta_TXProfile[2].sa_gain[i] = 0x2000;
    }
    gta_TXProfile[2].sa_bat[6] = 5;
    gta_TXProfile[2].sa_bat[7] = 6;
    for (i = 8; i <= 9; i++) {
        gta_TXProfile[2].sa_bat[i] = 7;
    }
    for (i = 10; i <= 14; i++) {
        gta_TXProfile[2].sa_bat[i] = 6;
    }
    for (i = 15; i <= 16; i++) {
        gta_TXProfile[2].sa_bat[i] = 5;
    }
    for (i = 17; i <= 18; i++) {
        gta_TXProfile[2].sa_bat[i] = 4;
    }
    gta_TXProfile[2].sa_bat[19] = 3;
    for (i = 20; i <= 21; i++) {
        gta_TXProfile[2].sa_bat[i] = 2;
    }
    gta_TXProfile[2].s_R = 0;
    gta_TXProfile[2].s_S = 1;
    gta_TXProfile[2].s_D = 1;

    /* ====================================== */
    /*  profile 3 */
    /* ====================================== */
    gta_TXProfile[3].s_ReqdBits = 0;
    for (i = 0; i < gs_TxNumTones; i++) {
        gta_TXProfile[3].sa_bat[i] = 0;
        gta_TXProfile[3].sa_gain[i] = 0x0000;
    }

    gta_TXProfile[3].s_R = 0;
    gta_TXProfile[3].s_S = 0;
    gta_TXProfile[3].s_D = 0;


}

