/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   profile1.c
*
*   Profile management algorithms.
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"



/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: InitProfile
 *
 *  Description: Clears all of the upstream and downstream profiles
 *
 *  Prototype: void InitProfile(void);
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void InitProfile(void) {

    int16 i,j;

    for (j = 0; j < NUM_PROFILES; j++) {

        /*  clear RX Profile */
        gta_RXProfile[j].s_ReqdBits = 0;
        for (i = 0; i < gs_RxNumTones; i++) {
            gta_RXProfile[j].sa_BG[i] = 0;
        }

        gta_RXProfile[j].s_R = 0;
        gta_RXProfile[j].s_S = 0;
        gta_RXProfile[j].s_D = 0;



        /*  clear TX Profile */
        gta_TXProfile[j].s_ReqdBits = 0;
        for (i = 0; i < gs_TxNumTones; i++) {
            gta_TXProfile[j].sa_bat[i] = 0;
            gta_TXProfile[j].sa_gain[i] = 0x0000;
        }

        gta_TXProfile[j].s_R = 0;
        gta_TXProfile[j].s_S = 0;
        gta_TXProfile[j].s_D = 0;



        /*  clear ordering */
        gsa_rx_profile_ord[j] = 0;

    }
}
