/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   profile3.c
*
*   Profile management algorithms.
*
*-------------------------------------------------------------------------
*/
//#include <string.h>
#include "common.h"
//#include "rt_tones.h"
//#include "dsp_op.h"
#include "snr.h"
#include "gdata.h"
#include "bitload2.h"
//#include "xgdata.h"
//#include "pwr_ctbk.h"
#include "aoc.h"
//#include "fretrain.h"



#define PROFILE_RX_BITS    0x000F
#define PROFILE_RX_GAINS   0xFFF0

/* =============================================== */
/* static function prototypes */
/* =============================================== */
uint8 TestProfile(int16 s_indx);
int16 GetCodingGain(int16 s_R);
void LoadDSProfile(void);


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: SelectProfile
 *
 *  Description: Chooses the best downstream (DS) profile that the
 *  measured SNR will support.  First the maximum total bits that can
 *  be supported is calculated.  Next the profiles are searched from highest
 *  bit rate to lowest.  A quick check is performed comparing the total bits
 *  required by the profile vs. the maximum supported.  If the required bits
 *  can be supported then each bin is then checked to see if it can support
 *  the bit allocation of the profile, if not the next profile is checked.
 *  If a valid profile is found then the B&G are loaded.  Finally the R_MSG_FR2
 *  is formed, indicating the selected profile, or unknown profile in the case
 *  that no profile is selected.
 *
 *  Prototype: void SelectProfile(void);
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      guc_ProfileLoadOK   (O) = SUCCEED , valid DS profile found;
 *                              = FAIL, no valid DS profile found
 *    gsa_RxBat[]         (O) bit allocation array
 *                              cleared in InitBitLoading()
 *                              set in LoadProfile()
 *    gsa_RxFineGain[]    (O) fine gain array
 *                              cleared in InitBitLoading()
 *                              set in LoadProfile()
 *      gs_RxDesiredMargin  (I) Desired RX SNR Margin
 *      gsa_SNRRequired[]   (O) Required margin per constellation size
 *      gsa_FRSnrBuf[]      (I) SNR measured during R_C_MEDLEY_FR_RX
 *      gsa_rx_profile_ord  (I) profile numbers, sorted by bit rate
 *      gta_RXProfile[]      (I) array of stored US profiles
 *      guca_RMsgFR2Tab[]   (O) message containing selected profile to
 *                              be sent during R_MSG_FR2_TX
 *
 *------------------------------------------------------------------------
 *^^^
 */
void SelectProfile(void) {

    int16   s_MaxBits, s_RSCodingGain;
    int16    i, s_indx, j;
   int16 s_path=COMBINED_LP;
   /* Copy SNRs computed in FR state to local SNR buffer */
   gpsa_MeasuredSnrBuf = gsa_FRSnrBuf;

   guc_ProfileLoadOK = InitBitloading(s_path);

    for (i = 0; i < guc_num_rx_profiles_stored; i++) {

      /*  get profile number w/ highest bit rate that */
        /*  has not been tested; */
        s_indx = gsa_rx_profile_ord[i];

      /*  get RS coding gain corresponding to this profile */
      j = gta_RXProfile[s_indx].s_R * gta_RXProfile[s_indx].s_S;
      if(j > 0)
         s_RSCodingGain = GetCodingGain(j);
      else
         s_RSCodingGain = 0;

      /* Compute required SNR margin for each constellation size */
      OffsetSNRRequired((int16)(gs_RxDesiredMargin-s_RSCodingGain), gsa_SNRRequired);

      /*  determine max. bits supported by current SNR measurement */
      /*  CalcMaxBits also loads gsa_RxBat[] with max bits for each tone */
      s_MaxBits = CalcMaxBits(gft_FineGainOn, guca_RxBat, gsa_RxFineGains, &gs_RxExtraBits, &gus_ncloaded, &gs_RxAvFineGain, 0x7FFF, s_path);

        /*  test if current channel can support profile */
        /*  first test if total bits can be supported */
        if (s_MaxBits < gta_RXProfile[s_indx].s_ReqdBits) {
            continue; /*  current profile not supported, go to next profile */
        }

        /*  test this profile to see if BAT can be supported */
        guc_ProfileLoadOK = TestProfile(s_indx);

      /*  finally check if the bit rate in the stored profile */
      /*  is very low. If so, initiate full initialization with the hope that */
      /*  we can start at a higher data rate */

      if(guc_ProfileLoadOK == SUCCEED)
      {
         /* check to see if the data rate for the current channel */
         /* conditions is greateer than the absolute max. rate */
#if 0
         if (s_MaxBits <= (int16)gus_DS_max_bits_per_symbol)
            s_MaxBitsToCompare = s_MaxBits;
         else
            s_MaxBitsToCompare = gus_DS_max_bits_per_symbol;

         if (gta_RXProfile[s_indx].s_ReqdBits <= (s_MaxBitsToCompare - NUM_BITS_TO_BE_INCREMENTED))
         {
            guc_ProfileLoadOK = FAIL; /*  go to full initialization because we may get higher data rate */
            break;
         }
#endif
      }
        /*  if profile can be supported then load profile and */
        /*  stop searching */
        if (guc_ProfileLoadOK == SUCCEED) {
            gs_DS_Profile = s_indx;
            LoadDSProfile();
            break;
        }
    } /* for (i = ....) */

    /*  form R_MSG_FR2 */
    if (guc_ProfileLoadOK == SUCCEED) {
        guca_RMsgFR2Tab[0] = 0x0F & (uint8)gs_DS_Profile;
    }
    else {
        guca_RMsgFR2Tab[0] = UNKNOWN_PROFILE; /* set unknown profile bit */
    }

    guca_RMsgFR2Tab[1] = 0x00;

    gft_BitloadState = TRAINING_DONE;
    return;
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: TestProfile
 *
 *  Description: Tests the BAT of profile 's_indx' to see if it can
 *  be supported by the measured SNR.  If a tone is found that cannot
 *  support the profile's BAT, the search is halted and failure is declared.
 *  If all tones can support the profile's BAT then success us declared
 *
 *  Prototype: uint8 TestProfile(int16 s_indx);
 *
 *  Arguments:
 *      s_indx:     index into table of profiles
 *
 *  Return:
 *      FAIL:     Profile doesn't support measured SNR
 *      SUCCEED:  Profile does support measured SNR
 *
 *  Global Variables Used:
 *      gsa_RxBAT[]         (I) contains maximum BAT that channel conditions
 *                              will support
 *      gta_RXProfile[]      (I) table of stored profiles
 *      gsa_SNRRequired[]   (I) SNR required to support each constellation size
 *
 *------------------------------------------------------------------------
 *^^^
 */
uint8 TestProfile(int16 s_indx) {

    uint8   s_ProfileOK;
    int16   s_SNR, s_qc, s_RxProfileGain;
    int32   l_PwrGain;
    int16    j;

    /*  now test each bin */
    s_ProfileOK = SUCCEED;

    for (j = gs_RxFirstChannel; j <= gs_RxLastChannel; j++) {

        /*  first test if bit allocation can be supported,  */
        if (guca_RxBat[j] < (gta_RXProfile[s_indx].sa_BG[j] & PROFILE_RX_BITS)) {
            s_ProfileOK = FAIL;
            break;
        }

        /*  now confirm that it can be supported with gain */
        s_qc = gta_RXProfile[s_indx].sa_BG[j] & PROFILE_RX_BITS;

      /*  gta_RXProfile[i].sa_gain[j] is in Q3.13 format */
      /*  this is an absolute value and we want to change it to dB */
      s_RxProfileGain = gta_RXProfile[s_indx].sa_BG[j] & PROFILE_RX_GAINS;

      /* ============================================================== */
        /* Express s_RxProfileGain in dB because gsa_SNRRequired is in dB */
      /* Remember s_RxProfileGain in decimal number is in Q3.13 format */
        /* ============================================================== */

        /*  express as a power gain factor (Q6.26) */
        l_PwrGain = (int32)s_RxProfileGain*s_RxProfileGain;

        /*  compute dB, ConvertToDB() uses a Q32.0 input format so */
        /*  subtract 10log10(2^26) to get correct result */
        s_RxProfileGain = ConvertToDB(l_PwrGain) - FINE_GAIN_DB_FACTOR;

      s_SNR = gsa_SNRRequired[s_qc] - s_RxProfileGain;

        /*  search only if there are at least some min. bits in each bin */
      if(s_qc >= RX_MIN_BITS_PER_TONE)
      {
         /*  if bin fails then abort search */
         if (gsa_FRSnrBuf[j] < s_SNR) {
            s_ProfileOK = FAIL;
            break;
         }
      }

    } /*  for j */

    return s_ProfileOK;
}


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: LoadDSProfile()
 *
 *  Description: Loads the Downstream BAT and gains table
 *
 *  Prototype: void LoadDSProfile()
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *    gsa_RxBat[]         (O) bit allocation array
 *    gsa_RxFineGain[]    (O) fine gain array
 *      gta_RXProfile[]      (I) array of stored DS profiles
 *
 *------------------------------------------------------------------------
 *^^^
 */
void LoadDSProfile(){

   int16 i,  *ps_fg_dest, *ps_bg_src;
   uint8 *ps_bat_dest;

   ps_bg_src = gta_RXProfile[gs_DS_Profile].sa_BG;
   ps_bat_dest = guca_RxBat;
   ps_fg_dest = gsa_RxFineGains;

   for(i=0; i<gs_RxNumTones; i++) {
      *ps_bat_dest++ = (*ps_bg_src) & PROFILE_RX_BITS;
      *ps_fg_dest++ = (*ps_bg_src++) & PROFILE_RX_GAINS;
   }



   return;
}
